/*
 *  Mike Hughes <mfh@psilord.com>
 *  Papadimitriou Spiros <spapadim+@cs.cmu.edu>
 *
 *  This code released under the GNU GPL.
 *  Read the file COPYING for more information.
 *
 * Some utility functions
 */


#include <gtk/gtk.h>

/*
 * create a button with a stock image and a label
 */
GtkWidget *
gdict_button_new_with_stock_image (const gchar* text, const gchar* stock_id)
{
	GtkWidget *button;
	GtkWidget *label;
	GtkWidget *image;
	GtkWidget *hbox;
	GtkWidget *align;

	button = gtk_button_new ();
	image = gtk_image_new_from_stock (stock_id, GTK_ICON_SIZE_BUTTON);
	hbox = gtk_hbox_new (FALSE, 2);
	align = gtk_alignment_new (0.5, 0.5, 0.0, 0.0);
	gtk_box_pack_start (GTK_BOX (hbox), image, FALSE, FALSE, 0);
	if (text != NULL) {
		label = gtk_label_new_with_mnemonic (text);
		gtk_label_set_mnemonic_widget (GTK_LABEL (label), GTK_WIDGET (button));
		gtk_box_pack_end (GTK_BOX (hbox), label, FALSE, FALSE, 0);
	}
	gtk_container_add (GTK_CONTAINER (button), align);
	gtk_container_add (GTK_CONTAINER (align), hbox);
	gtk_widget_show_all (align);

	return button;
}

GtkWidget *
gdict_dialog_add_button (GtkDialog *dialog, const gchar* text, const gchar* stock_id, 
                         gint response_id)
{
        GtkWidget *button;

        g_return_val_if_fail (GTK_IS_DIALOG (dialog), NULL);
        g_return_val_if_fail (text != NULL, NULL);
        g_return_val_if_fail (stock_id != NULL, NULL);

        button = gdict_button_new_with_stock_image (text, stock_id);
        g_return_val_if_fail (button != NULL, NULL);

        GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);

        gtk_widget_show (button);

        gtk_dialog_add_action_widget (dialog, button, response_id);

        return button;
}

/**
 * gdict_add_atk_namedesc
 * @widget    : The Gtk Widget for which @name and @desc are added.
 * @name      : Accessible Name
 * @desc      : Accessible Description
 * Description: This function adds accessible name and description to a
 *              Gtk widget.
 */
void
gdict_add_atk_namedesc (GtkWidget *widget, const gchar *name, const gchar *desc)
{
	AtkObject *atk_widget;

	g_return_if_fail (GTK_IS_WIDGET (widget));

	atk_widget = gtk_widget_get_accessible(widget);
    
	if (name != NULL)
		atk_object_set_name(atk_widget, name);

	if (desc !=NULL)
		atk_object_set_description(atk_widget, desc);
}

/**
 * gdict_add_atk_relation
 * @obj1      : The first widget in the relation @rel_type
 * @obj2      : The second widget in the relation @rel_type.
 * @rel_type  : Relation type which relates @obj1 and @obj2
 * Description: This function establishes Atk Relation between two given
 *              objects.
 */
void
gdict_add_atk_relation (GtkWidget *obj1, GtkWidget *obj2, AtkRelationType rel_type)
{
	AtkObject *atk_obj1, *atk_obj2;
	AtkRelationSet *relation_set;
	AtkRelation *relation;

	g_return_if_fail (GTK_IS_WIDGET (obj1));
	g_return_if_fail (GTK_IS_WIDGET (obj2));

	atk_obj1 = gtk_widget_get_accessible(obj1);
	atk_obj2 = gtk_widget_get_accessible(obj2);

	relation_set = atk_object_ref_relation_set (atk_obj1);
	relation = atk_relation_new (&atk_obj2, 1, rel_type);
	atk_relation_set_add (relation_set, relation);

	g_object_unref (G_OBJECT (relation));
}
