#ifndef __GDICT_APP_H_
#define __GDICT_APP_H_

/* $Id: gdict-app.h,v 1.26 2004/12/17 17:15:17 vnoel Exp $ */

/*
 *  Mike Hughes <mfh@psilord.com>
 *  Papadimitriou Spiros <spapadim@cs.cmu.edu>
 *  Bradford Hovinen <hovinen@udel.edu>
 *
 *  This code released under the GNU GPL.
 *  Read the file COPYING for more information.
 *
 *  GDict main window
 *
 */

#include "dict.h"
#include "gdict-defbox.h"

extern gboolean  gail_loaded;

#define GDICT_TYPE_WINDOW		  (gdict_window_get_type ())
#define GDICT_WINDOW(obj)		  (GTK_CHECK_CAST ((obj), GDICT_TYPE_WINDOW, GDictWindow))
#define GDICT_WINDOW_CLASS(klass)	  (GTK_CHECK_CLASS_CAST ((klass), GDICT_TYPE_WINDOW, GDictWindowClass))
#define GDICT_IS_WINDOW(obj)	  (GTK_CHECK_TYPE ((obj), GDICT_TYPE_WINDOW))
#define GDICT_IS_WINDOW_CLASS(klass)  (GTK_CHECK_CLASS_TYPE ((obj), GDICT_TYPE_WINDOW))
#define GDICT_WINDOW_GET_CLASS(obj)   (GTK_CHECK_GET_CLASS ((obj), GDICT_TYPE_WINDOW, GDictWindowClass))

enum {
	SEARCH_TYPE_REGULAR,
	SEARCH_TYPE_WEB
};

typedef struct _GDictWindow GDictWindow;
typedef struct _GDictWindowClass GDictWindowClass;

#include "gdict-pref.h"

struct _GDictWindow {
	GtkWindow parent_instance;

	GtkActionGroup *menu_actions;
	GtkActionGroup *edit_actions;
	GtkActionGroup *search_type_actions;
	GtkWidget *statusbar;
	GDictDefbox *defbox;
	GtkWidget *word_entry;
	GtkWidget *gnome_word_entry;

	GtkWidget *find_dialog;
	GtkWidget *find_dialog_entry;

	GtkWidget *pref_dialog;
	GDictPref *pref;

        gchar *find_text;
        gboolean search_from_beginning;       

        gpointer applet;
	gpointer speller;
	gboolean speller_visible;

	GtkUIManager *ui;
	dict_context_t *context;

	gpointer print_job;

	int      x, y;
	int      search_type;
	GSList *web_search_sites;
};

struct _GDictWindowClass {
	GtkWindowClass parent_class;
};

void gdict_app_do_lookup (GDictWindow *gdict, gchar *text);
void gdict_app_show_preferences (GDictWindow *gdict);
GType gdict_window_get_type (void);
GtkWidget *gdict_window_new (void);
gint gdict_init_context (GDictWindow *gdict);
gint gdict_spell (GDictWindow *gdict, gchar *text, gboolean pattern);

#endif /* __GDICT_APP_H_ */
