/* $Id: main.c,v 1.45 2004/12/14 18:47:12 vnoel Exp $ */

/*
 *  Mike Hughes <mfh@psilord.com>
 *  Papadimitriou Spiros <spapadim+@cs.cmu.edu>
 *
 *  This code released under the GNU GPL.
 *  Read the file COPYING for more information.
 *
 *  Main program function
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glib/goption.h>
#include <libgnomeui/gnome-ui-init.h>
#include <libgnomeui/gnome-client.h>
#include "dict.h"
#include "gdict-defbox.h"
#include "gdict-applet.h"
#include "gdict-app.h"

static gboolean
save_yourself_cb (GnomeClient       *client,
                  gint               phase,
                  GnomeRestartStyle  save_style,
                  gint               shutdown,
                  GnomeInteractStyle interact_style,
                  gint               fast,
                  gpointer           client_data)
{
	gchar *argv[] = {NULL, NULL, NULL, NULL, NULL};
	gchar *word;
	gint argc = 1;
	GDictWindow *gdict = client_data;

	argv[0] = g_get_prgname ();

	if ((word = gdict_defbox_get_word(gdict->defbox)) != NULL)
		argv[argc++] = word;

	gnome_client_set_restart_command(client, argc, argv);
	gnome_client_set_clone_command(client, 0, NULL);

	return TRUE;
}

#if 0
static gint
die_cb (GnomeClient *client, gpointer client_data)
{
	gtk_main_quit ();
}
#endif

int main (int argc, char *argv[])
{
	GnomeClient *client;
	GnomeProgram *program;
	GDictWindow *gdict;
	GtkWidget *window;
	GOptionContext *ctx;
	GError *error;
	gint i;

	bindtextdomain(GETTEXT_PACKAGE, GNOMELOCALEDIR);
	bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
	textdomain(GETTEXT_PACKAGE);

	program = gnome_program_init ("gnome-dictionary",
				      VERSION,
				      LIBGNOMEUI_MODULE,
				      argc, argv,
				      GNOME_PARAM_APP_DATADIR,
				      DATADIR, NULL);

	g_set_application_name (_("Gnome Dictionary"));
	gtk_window_set_default_icon_name ("gdict");

	if ((client = gnome_master_client()) != NULL) {
		g_signal_connect (client, "save_yourself",
				  G_CALLBACK (save_yourself_cb), NULL);
	    /* FIXME: We should really connect to this, but gnome-session wants to 
	     * remove non-reponsive clients after a timeout - in this case the 
	     * client is busy trying to connect to the dict server
             * g_signal_connect (client, "die", G_CALLBACK (client_die_cb), NULL);
	     */
	}

	ctx = g_option_context_new (" - Dictionary and spelling tool");
	g_option_context_parse (ctx, &argc, &argv, &error);

	if (argc > 1) {
		for (i = 1; i < argc; i++) {			
			window = gdict_window_new ();
			gdict = GDICT_WINDOW (window);
			gtk_window_present (GTK_WINDOW(gdict));
			gdict_defbox_lookup(gdict->defbox, (char *)argv[i]);
		}
	} else {
		window = gdict_window_new ();
		gdict = GDICT_WINDOW (window);
		gtk_window_present (GTK_WINDOW(gdict));
		
	}

	gtk_main();

	return 0;
}
