/* presconf.c
 *
 * Copyright 2001, 2002 Sun Microsystems, Inc.,
 * Copyright 2001, 2002 BAUM Retec, A.G.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "config.h"
#include "presconf.h"
#include "SRMessages.h"
#include "gnopiconf.h"
#include <string.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>
#include "libsrconf.h"
#include "srintl.h"

PresentationStruct default_presentations[] = 
{
		{"braille",	"generic",	"generic",	N_("%role%%name%")},

		{"braille",	"check-box",	"generic",	N_("%role%%name%%(shortcut)%%?state:checked?\"(C)\":\"( )\"?%")},
		{"braille",	"check-box",	"present",	N_("%role%%name%%(shortcut)%%?state:checked?\"(C)\":\"( )\"?%%?state:enabled?\"\":\"(U)\"?%")},
		{"braille",	"check-menu-item","generic",	N_("%role%%name%%(accelerator)%%(shortcut)%%?state:checked?\"(C)\":\"( )\"?%%?state:enabled?\"\":\"(U)\"?%")},
		{"braille",	"combo-box",	"generic",	N_("%role%%name%%text:line%")},
		{"braille",	"label",	"generic",	N_("%role%%text:line%")},
		{"braille",	"link",		"generic",	N_("%role%%text:line%")},
		{"braille",	"list",		"generic",	N_("%role%%name%%childcount%%1childcount?\"item\":\"items\"1%")},
		{"braille",	"list-item",	"generic",	N_("%role%%name%%(shortcut)%")},		
		{"braille",	"menu",		"generic",	N_("%role%%name%%childcount%%1childcount?\"item\":\"items\"1%")},
		{"braille",	"menu-bar",	"generic",	N_("%role%%name%%childcount%%1childcount?\"item\":\"items\"1%")},
		{"braille",	"menu-item",	"generic",	N_("%role%%name%%(accelerator)%%(shortcut)%%?state:enabled?\"\":\"(U)\"?%")},
		{"braille",	"page-tab",	"generic",	N_("%role%%name%%(shortcut)%")},
		{"braille",	"push-button",	"generic",	N_("%role%%!123478!%%name%%!145678!%%(shortcut)%")},
		{"braille",	"radio-button",	"focus:",	N_("%role%%name%")},
		{"braille",	"radio-menu-item","generic",	N_("%role%%name%%(accelerator)%%(shortcut)%%?state:checked?\"(C)\":\"( )\"?%%?state:enabled?\"\":\"(U)\"?%")},
		{"braille",	"slider",	"generic",	N_("%role%%name%%value:crt%")},
		{"braille",	"spin-button",	"object:property-change:accessible-value",N_("%role%%name%%value:crt%")},
		{"braille",	"spin-button",	"generic",	N_("%role%%name%%text:line%")},
		{"braille",	"table-columns-header","generic",N_("%name%%role%%children[%name%%?state:checked?\"(C)\":\"\"?%%?state:expanded?\"(E)\":\"\"?%%?state:collapsed?\"(c)\":\"\"?%][%!1237!%]%")},
		{"braille",	"table-line",	"generic",	N_("%name%%role%%children[%name%%?state:checked?\"(C)\":\"\"?%%?state:unchecked?\"( )\":\"\"?%%?state:expanded?\"(E)\":\"\"?%%?state:collapsed?\"(c)\":\"\"?%][%!1237!%]%")},
		{"braille",	"terminal",	"generic",	N_("%role%%text:line%")},
		{"braille",	"text",		"generic",	N_("%role%%text:line%")},
		{"braille",	"title-bar",	"generic",	N_("%role%%name%%?state:minimized?\"(m)\":\"(n)\"?%")},
		{"braille",	"toggle-button","generic",	N_("%role%%name%%?state:checked?\"(P)\":\"( )\"?%")},
		{"braille",	"tool-bar",	"generic",	N_("%role%%name%%children[%name%][%!1237!%]%")},
		{"braille",	"tool-tip",	"generic",	N_("%role%%name%")},
		{"braille",	"tree-item",	"generic",	N_("%role%%level%%name%%?state:expanded?\"(E)\":\"\"?%%?state:collapsed?\"(c)\":\"\"?%")},
		
			    
		{"speech", 	"generic", 	"generic", 	N_("%name<voice=name>%%role<voice=role>%")},
		{"speech", 	"generic", 	"object:text-changed:insert",N_("%text:difference<voice=text>%")},
		{"speech", 	"generic", 	"object:text-changed:delete",N_("%text:difference<voice=text>%")},
		{"speech", 	"generic", 	"object:text-selection-changed",N_("%?text:selection?\"\":\"no selection anymore\"<voice=system>?%%text:selection<voice=text>%")},
		{"speech", 	"generic", 	"object:text-caret-moved",N_("%text:best<voice=text>%")},

		{"speech",	"check-box",	"focus:",	N_("%name<voice=name>%%role<voice=role>%%?shortcut?\"shortcut\":\"\"<voice=system>?%%shortcut<voice=shortcut>%%?state:checked?\"checked\":\"unchecked\"<voice=state>?%")},
	    	{"speech",	"check-box",	"object:state-changed:checked",	N_("%?state:checked?\"checked\":\"unchecked\"<voice=state>?%")},
		{"speech", 	"check-menu-item","generic", 	N_("%name<voice=name>%%role<voice=role>%%?shortcut?\"shortcut\":\"\"<voice=system>?%%shortcut<voice=shortcut>%%?accelerator?\"accelerator\":\"\"<voice=system>?%%accelerator<voice=shortcut>%%?state:checked?\"checked\":\"unchecked\"<voice=state>?%%?state:enabled?\"available\":\"not available\"<voice=state>?%")},
	    	{"speech",	"check-menu-item","object:state-changed:checked",	N_("%?state:checked?\"checked\":\"unchecked\"<voice=state>?%")},
		{"speech",	"combo-box",	"focus:",	N_("%name<voice=name>%%role<voice=role>%%text:line<voice=text>%")},
	    	{"speech",	"combo-box",	"object:property-changed:accessible-content",N_("%text:line<voice=text>%")},
		{"speech", 	"label", 	"generic", 	N_("%text:line<voice=name>%%role<voice=role>%")},
		{"speech", 	"link", 	"generic", 	N_("%text:line<voice=name>%%role<voice=role>%")},
		{"speech",	"list",		"generic",	N_("%name<voice=name>%%role<voice=role>%%childcount<voice=childcount>%%1childcount?\"item\":\"items\"<voice=system>1%")},
		{"speech", 	"list-item", 	"generic", 	N_("%name<voice=name>%%role<voice=role>%")},
		{"speech",	"menu",		"generic",	N_("%name<voice=name>%%role<voice=role>%%?shortcut?\"shortcut\":\"\"<voice=system>?%%shortcut<voice=shortcut>%%childcount<voice=childcount>%%1childcount?\"item\":\"items\"<voice=system>1%")},
		{"speech",	"menu-bar",	"generic",	N_("%role<voice=role>%%childcount<voice=childcount>%%1childcount?\"item\":\"items\"<voice=system>1%%children[%name<voice=name>%][]%")},
		{"speech", 	"menu-item", 	"generic", 	N_("%name<voice=name>%%role<voice=role>%%?shortcut?\"shortcut\":\"\"<voice=system>?%%shortcut<voice=shortcut>%%?accelerator?\"accelerator\":\"\"<voice=system>?%%accelerator<voice=shortcut>%%?state:enabled?\"available\":\"not available\"<voice=state>?%")},
		{"speech", 	"page-tab", 	"generic", 	N_("%name<voice=name>%%role<voice=role>%%?shortcut?\"shortcut\":\"\"<voice=system>?%%shortcut<voice=shortcut>%")},
		{"speech",	"push-button",	"generic",	N_("%name<voice=name>%%role<voice=role>%%?shortcut?\"shortcut\":\"\"<voice=system>?%%shortcut<voice=shortcut>%")},
		{"speech", 	"radio-button",	"generic", 	N_("%name<voice=name>%%role<voice=role>%%?shortcut?\"shortcut\":\"\"<voice=system>?%%shortcut<voice=shortcut>%%?state:checked?\"checked\":\"unchecked\"<voice=state>?%")},
		{"speech", 	"radio-menu-item","generic", 	N_("%name<voice=name>%%role<voice=role>%%?shortcut?\"shortcut\":\"\"<voice=system>?%%shortcut<voice=shortcut>%%?accelerator?\"accelerator\":\"\"<voice=system>?%%accelerator<voice=shortcut>%%?state:checked?\"checked\":\"unchecked\"<voice=state>?%%?state:enabled?\"available\":\"not available\"<voice=state>?%")},
	    	{"speech",	"radio-menu-item","object:state-changed:checked",	N_("%?state:checked?\"checked\":\"unchecked\"<voice=state>?%")},
		{"speech", 	"slider", 	"generic", 	N_("%name<voice=name>%%role<voice=role>%curent value<voice=system>%value:crt<voice=value>%")},
		{"speech", 	"slider", 	"object:property-change:accessible-value",N_("%value:crt<voice=value>%")},
		{"speech", 	"spin-button", 	"focus:", 	N_("%name<voice=name>%%role<voice=role>%curent value<voice=system>%value:crt<voice=value>%")},
		{"speech", 	"spin-button", 	"generic", 	N_("%name<voice=name>%%role<voice=role>%curent text<voice=system>%text:line<voice=text>%")},
		{"speech", 	"spin-button", 	"object:property-change:accessible-value",N_("%value:crt<voice=value>%")},
		{"speech", 	"status-bar", 	"generic", 	N_("%role<voice=role>%%children[%name<voice=name>%][]%")},
		{"speech", 	"table-line", 	"generic", 	N_("%name<voice=name>%%role<voice=role>%%childcount<voice=childcount>%%1childcount?\"item\":\"items\"<voice=system>1%%children[%name<voice=name>%%?state:checked?\"checked\":\"\"<voice=state>?%%?state:unchecked?\"unchecked\":\"\"<voice=state>?%%?state:expanded?\"expanded\":\"\"<voice=state>?%%?state:collapsed?\"collapsed\":\"\"<voice=state>?%][]%")},
		{"speech", 	"table-line", 	"object:state-changed:expanded",N_("%children[%?state:expanded?\"expanded\":\"\"<voice=state>?%%?state:collapsed?\"collapsed\":\"\"<voice=state>?%][]%")},
		{"speech", 	"terminal", 	"generic", 	N_("%role<voice=role>%%text:line<voice=text>%")},
		{"speech", 	"text", 	"focus:", 	N_("%name<voice=name>%%role<voice=role>%%text:line<voice=text>%")},
		{"speech", 	"title-bar", 	"generic",	N_("%role<voice=role>%%name<voice=name>%%?state:minimized?\"minimized\":\"normal\"<voice=state>?%")},
		{"speech", 	"toggle-button","generic", 	N_("%name<voice=name>%%role<voice=role>%%?state:checked?\"pressed\":\"unpressed\"<voice=state>?%")},
	    	{"speech",	"toggle-button","object:state-changed:checked",	N_("%?state:checked?\"pressed\":\"unpressed\"<voice=state>?%")},
		{"speech", 	"tool-bar", 	"generic", 	N_("%role<voice=role>%%children[%name<voice=name>%][]%")},
		{"speech",	"tree-item",	"generic",	N_("%name<voice=name>%%role<voice=role>%level<voice=system>%level<voice=system>%%?state:expanded?\"expanded\":\"\"<voice=state>?%%?state:collapsed?\"collapsed\":\"\"<voice=state>?%")},
		{"speech", 	"tree-item", 	"object:state-changed:expanded",N_("%?state:expanded?\"expanded\":\"\"<voice=state>?%%?state:collapsed?\"collapsed\":\"\"<voice=state>?%")},
		
		{"speech", 	"tool-tip", 	"tooltip:show",	N_("show tool tip<voice=system>%name<voice=name>%")},
		{"speech", 	"tool-tip", 	"tooltip:hide",	N_("hide tool tip<voice=system>%name<voice=name>%")},
	
		{"speech", 	"generic", 	"window:create",N_("create window<voice=system>%name<voice=name>%")},
		{"speech", 	"generic", 	"window:destroy",N_("destroy window<voice=system>%name<voice=name>%")},
		{"speech", 	"generic", 	"window:minimize",N_("minimize window<voice=system>%name<voice=name>%")},
		{"speech", 	"generic", 	"window:titlelize",N_("titlelize window<voice=system>%name<voice=name>%")},
		{"speech", 	"generic", 	"window:restore",N_("restore window<voice=system>%name<voice=name>%")},
		{"speech", 	"generic", 	"window:maximize",N_("maximize window<voice=system>%name<voice=name>%")},
		{"speech", 	"generic", 	"window:switch",N_("switch to window<voice=system>%name<voice=name>%")},

		{"magnifier", 	"text", 	"generic",	"%text:char<AlignmentX=\"0\" AlignmentY=\"0\">%"},
		{"magnifier", 	"generic", 	"generic",	"%object<AlignmentX=\"0\" AlignmentY=\"0\">%"}
};

static gboolean presentation_end = FALSE;
extern GConfClient *gnopernicus_client;
static GSList *pres_removed_list = NULL;
       GSList *pres_list = NULL;

gboolean 
presconf_gconf_init (void)
{
    if (!gnopiconf_client_add_dir (CONFIG_PATH PRESENTATION_PATH))
	return FALSE;

    if (!gconf_client_dir_exists (gnopernicus_client, CONFIG_PATH PRESENTATION_PATH, NULL))
	presconf_set_defaults ();

    return TRUE;
}

void 
presconf_gconf_terminate (void)
{    	
    if (gconf_client_dir_exists (gnopernicus_client, CONFIG_PATH PRESENTATION_PATH,NULL))
	gconf_client_remove_dir (gnopernicus_client, CONFIG_PATH PRESENTATION_PATH,NULL);	
    if (pres_list)
	presconf_free_list (pres_list);
    if (pres_removed_list)
	presconf_free_list (pres_removed_list);
	
}

PresentationStruct*
presconf_presentation_struct_new (const gchar *device,
				  const gchar *role,
				  const gchar *event,
				  const gchar *chunk)
{
    PresentationStruct *new_val = NULL;

    sru_return_val_if_fail (device, NULL);
    sru_return_val_if_fail (role, NULL);
    sru_return_val_if_fail (event, NULL);
    sru_return_val_if_fail (chunk, NULL);
    
    new_val =  (PresentationStruct *) g_new0( PresentationStruct, 1 );
    
    if (new_val == NULL)
    {
	sru_error (_("Unable to allocate memory."));
	return NULL;
    }

    if (strlen (device) > strlen (CONFIG_PATH PRESENTATION_PATH) + 1)
	new_val->device = g_strdup (device + strlen (CONFIG_PATH PRESENTATION_PATH) + 1);
    else
	new_val->device = g_strdup (device);
	
    new_val->role   = g_strdup (role);
    new_val->event  = g_strdup (event);
    new_val->chunk  = g_strdup (chunk);
    
    return new_val; 
}

gboolean
presconf_presentation_struct_free (PresentationStruct* value)
{
    sru_return_val_if_fail (value, FALSE);
    g_free (value->device);
    g_free (value->role);
    g_free (value->event);
    g_free (value->chunk);
    g_free (value);
    value = NULL;
    return TRUE;
}

GSList*
presconf_get_all_entries (void)
{
    return gnopiconf_get_all_entries (CONFIG_PATH PRESENTATION_PATH);
}



void
presconf_add_pres_item_in_list (const gchar *key, const gchar *chunk)
{
    gchar **tokens;
    
    sru_return_if_fail (key);
    sru_return_if_fail (chunk);

    tokens = g_strsplit (key, "_", -1);
        
    if (tokens [2])
    {
	pres_list = g_slist_prepend ( pres_list,
				    presconf_presentation_struct_new 
				    ( tokens [0], tokens [1], tokens [2],
				    chunk));
    }
    
    g_strfreev (tokens);
}

static void
presconf_foreach (gpointer value, gpointer user)
{
    presconf_presentation_struct_free ((PresentationStruct *)value);
}

void
presconf_free_list (GSList* list)
{
    if (!list)
	return;
    g_slist_foreach (list, presconf_foreach, NULL);
    g_slist_free (list);
    list = NULL;
}

void
presconf_preload_list (void)
{
    GSList     *list  = NULL;
    GSList     *elem  = NULL;
    
    presconf_free_list (pres_list);
    pres_list = NULL;
    
    list = presconf_get_all_entries ();
    elem = list;
    
    while (elem)
    {
	GConfEntry *list_item = NULL;
        GConfValue *list_value = NULL;
	
	list_item  = (GConfEntry*)elem->data;
	list_value = gconf_entry_get_value (list_item);
	if (list_value->type == GCONF_VALUE_STRING)
	    presconf_add_pres_item_in_list (gconf_entry_get_key (list_item), 
					    gconf_value_get_string (list_value)
					    );
	elem = elem->next;
    }
    if (list) 
	g_slist_free (list);
}   


static gchar*
presconf_create_key (const gchar *device,
		     const gchar *role,
		     const gchar *event)
{
    return g_strdup_printf ("%s/%s_%s_%s", CONFIG_PATH PRESENTATION_PATH,
			    device, role, event);
}

static void
presconf_changes_end (void)
{
    presentation_end = !presentation_end;
    gnopiconf_set_bool (presentation_end,
			CONFIG_PATH PRESENTATION_PATH PRESENTATION_CHANGES_END);
}

void
presconf_set_defaults (void)
{
    gint iter;
    for (iter = 0 ; iter < G_N_ELEMENTS (default_presentations) ; iter ++)
    {
	gchar *key = NULL;
	key = presconf_create_key ( default_presentations[iter].device,
			    	    default_presentations[iter].role,
			    	    default_presentations[iter].event);
	gnopiconf_set_string (default_presentations[iter].chunk, key);
	g_free (key);
    }
    presconf_changes_end ();
}

void
presconf_save_list (void)
{
    GSList *elem = NULL;
    elem = pres_list;
    
    while (elem)
    {
	gchar *key = NULL;
	PresentationStruct *value = (PresentationStruct *)elem->data;
	key = presconf_create_key ( value->device,
			    	    value->role,
			    	    value->event);
	gnopiconf_set_string (value->chunk, key);
	g_free (key);
	elem = elem->next;
    }
    presconf_changes_end ();
}

void
presconf_append_item_to_list (const gchar *device,
			      const gchar *role,
			      const gchar *event,
			      const gchar *chunk)
{
    pres_list = g_slist_prepend (pres_list,
				presconf_presentation_struct_new 
				( device, role, event, chunk)
				);
}

gboolean
presconf_remove_from_list(const gchar *device,
			  const gchar *role,
			  const gchar *event,
			  const gchar *chunk)
{
    GSList *elem;
    sru_return_val_if_fail (device,FALSE);
    sru_return_val_if_fail (role,  FALSE);
    sru_return_val_if_fail (event, FALSE);
    sru_return_val_if_fail (chunk, FALSE);
    elem = pres_list;
    while (elem)
    {
	PresentationStruct *value = (PresentationStruct *)elem->data;
	if (!strcmp (value->device,device) &&
	    !strcmp (value->role, role)    &&
	    !strcmp (value->event,event))
	{
	    pres_list = g_slist_remove_link (pres_list, elem);
	    pres_removed_list = g_slist_prepend (pres_removed_list, elem->data);
	    g_slist_free (elem);
	    return TRUE;
	} 
		 
	elem = elem->next;
    }
    return FALSE;
}


void
presconf_unset_remove_list (void)
{
    GSList *elem;
    elem = pres_removed_list;
    while (elem)
    {
	gchar *key;
	PresentationStruct *value = (PresentationStruct *)elem->data;
	key = presconf_create_key ( value->device,
			    	    value->role,
			    	    value->event);
	gnopiconf_unset_key (key);
	g_free (key);
	elem = elem->next;
    }
    presconf_free_list (pres_removed_list);
    pres_removed_list = NULL;
}

gboolean
presconf_item_exist(const gchar *device,
		    const gchar *role,
		    const gchar *event)
{
    GSList *elem;
    sru_return_val_if_fail (device, FALSE);
    sru_return_val_if_fail (role,   FALSE);
    sru_return_val_if_fail (event,  FALSE);
    elem = pres_list;
    while (elem)
    {
	PresentationStruct *value = (PresentationStruct *)elem->data;
	if (!strcmp (value->device,device) &&
	    !strcmp (value->role, role)    &&
	    !strcmp (value->event,event))
	{
	    return TRUE;
	} 
		 
	elem = elem->next;
    }
    return FALSE;
}

GSList*
presconf_search_item (const gchar *device,
		      const gchar *role,
		      const gchar *event)
{
    GSList *elem;
    sru_return_val_if_fail (device, NULL);
    sru_return_val_if_fail (role, NULL);
    sru_return_val_if_fail (event, NULL);
    elem = pres_list;
    while (elem)
    {
	PresentationStruct *value = (PresentationStruct *)elem->data;
	if (!strcmp (value->device,device) &&
	    !strcmp (value->role, role)    &&
	    !strcmp (value->event,event))
	{
	    return elem;
	} 
		 
	elem = elem->next;
    }
    return NULL;
}

