/*
 * gnote
 *
 * Copyright (C) 2011 Aurimas Cernius
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glibmm/i18n.h>
#include <gtkmm/stock.h>
#include <gtkmm/clipboard.h>

#include "notewindow.hpp"
#include "replacetitlenoteaddin.hpp"
#include "sharp/string.hpp"

namespace replacetitle {


ReplaceTitleModule::ReplaceTitleModule()
{
  ADD_INTERFACE_IMPL(ReplaceTitleNoteAddin);
}

const char * ReplaceTitleModule::id() const
{
  return "ReplaceTitleAddin";
}

const char * ReplaceTitleModule::name() const
{
  return _("Replace title");
}

const char * ReplaceTitleModule::description() const
{
  return _("Replace title with selection.");
}


const char * ReplaceTitleModule::authors() const
{
  return _("Pierre-Yves Luyten");
}

int ReplaceTitleModule::category() const
{
  return gnote::ADDIN_CATEGORY_TOOLS;
}

const char * ReplaceTitleModule::version() const
{
  return "0.1";
}

void ReplaceTitleNoteAddin::initialize()
{
}

void ReplaceTitleNoteAddin::shutdown()
{
}

void ReplaceTitleNoteAddin::on_note_opened()
{
  Gtk::ImageMenuItem *item =  manage(new Gtk::ImageMenuItem(_("Replace title")));
  item->set_image(*manage(new Gtk::Image(Gtk::Stock::FIND_AND_REPLACE, Gtk::ICON_SIZE_MENU)));
  item->signal_activate().connect(
    sigc::mem_fun(*this, &ReplaceTitleNoteAddin::replacetitle_button_clicked));

  item->add_accelerator("activate",
                        get_window()->get_accel_group(),
                        GDK_KEY_R,
                        Gdk::CONTROL_MASK,
                        Gtk::ACCEL_VISIBLE);

  item->show() ;
  add_plugin_menu_item(item);
}

void ReplaceTitleNoteAddin::replacetitle_button_clicked()
{
  // unix primary clipboard
  Glib::RefPtr<Gtk::Clipboard> refClipboard = Gtk::Clipboard::get(GDK_SELECTION_PRIMARY);
  const std::string newTitle= refClipboard->wait_for_text();
  Glib::RefPtr<Gtk::TextBuffer> buffer = get_note()->get_buffer();
  Gtk::TextIter iter = buffer->get_insert()->get_iter();
  int line = iter.get_line();
  int line_offset = iter.get_line_offset();

  // replace note content
  if(!newTitle.empty()) {
    std::string new_content(get_note()->xml_content());
    get_note()->set_xml_content(sharp::string_replace_first(new_content, get_note()->get_title(), newTitle));
    if(line) {
      iter = buffer->get_insert()->get_iter();
      iter.set_line(line);
      iter.set_line_offset(line_offset);
      buffer->place_cursor(iter);
    }
  }
}

}
