/*
 * xml-io.h: interfaces to save/read gnumeric Sheets using an XML encoding.
 *
 * Daniel Veillard <Daniel.Veillard@w3.org>
 *
 * $Id: xml-io.h,v 1.9 1999/12/30 06:44:47 jody Exp $
 */

#ifndef GNUMERIC_XML_IO_H
#define GNUMERIC_XML_IO_H

#include "sheet.h"

Sheet    *gnumeric_xml_read_sheet     (const char *filename);
int       gnumeric_xml_write_sheet    (Sheet *sheet, const char *filename);
char     *gnumeric_xml_read_workbook  (Workbook *wb, const char *filename);
int       gnumeric_xml_write_workbook (Workbook *wb, const char *filename);

void      xml_init (void);

#endif /* GNUMERIC_XML_IO_H */
