
/* A Bison parser, made from parser.y
   by GNU bison 1.30.  */

#define YYBISON 1  /* Identify Bison output.  */

# define	STRING	257
# define	QUOTED_STRING	258
# define	CONSTANT	259
# define	CELLREF	260
# define	GTE	261
# define	LTE	262
# define	NE	263
# define	SEPARATOR	264
# define	INVALID_TOKEN	265
# define	NEG	266
# define	PLUS	267
# define	RANGE_SEP	268
# define	SHEET_SEP	269

#line 1 "parser.y"

/*
 * Gnumeric Parser
 *
 * (C) 1998-2001 the Free Software Foundation
 *
 * Author:
 *    Miguel de Icaza (miguel@gnu.org)
 *    Jody Goldberg (jody@gnome.org)
 *    Morten Welinder (terra@diku.dk)
 *    Almer S. Tigelaar (almer@gnome.org)
 */
#include <config.h>
#include "gnumeric.h"
#include "number-match.h"
#include "expr.h"
#include "expr-name.h"
#include "workbook.h"
#include "sheet.h"
#include "format.h"
#include "application.h"
#include "parse-util.h"
#include "gutils.h"
#include "auto-format.h"
#include "style.h"
#include "portability.h"
#include "str.h"

#include <ctype.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-i18n.h>

#define YYDEBUG 1
/* ------------------------------------------------------------------------- */
/* Allocation with disposal-on-error */

/*
 * Defined: the stack itself will be kept in use.  This isn't much, btw.
 *   This setting is good for speed.
 *
 * Not defined: memory will be freed.  The is good for finding leaks in the
 * program.  (Here and elsewhere.)
 */
#define KEEP_DEALLOCATION_STACK_BETWEEN_CALLS

/*
 * If some dork enters "=1+2+2*(1+" we have already allocated space for
 * "1+2", "2", and "1" before the parser sees the syntax error and warps
 * us to the error production in the "line" non-terminal.
 *
 * To make sure we can clean up, we register every allocation.  On success,
 * nothing should be left (except the final expression which is unregistered),
 * but on failure we must free everything allocated.
 *
 * Note: there is some room left for optimisation here.  Talk to terra@diku.dk
 * before you set out to do it.
 */

static void
free_expr_list_list (GSList *list)
{
	GSList *l;
	for (l = list; l; l = l->next)
		expr_list_unref (l->data);
	g_slist_free (list);
}

typedef void (*ParseDeallocator) (void *);
static GPtrArray *deallocate_stack;

static void
deallocate_init (void)
{
	deallocate_stack = g_ptr_array_new ();
}

static void
deallocate_uninit (void)
{
#ifndef KEEP_DEALLOCATION_STACK_BETWEEN_CALLS
	g_ptr_array_free (deallocate_stack, TRUE);
	deallocate_stack = NULL;
#endif
}

static void
deallocate_all (void)
{
	int i;

	for (i = 0; i < (int)deallocate_stack->len; i += 2) {
		ParseDeallocator freer = g_ptr_array_index (deallocate_stack, i + 1);
		freer (g_ptr_array_index (deallocate_stack, i));
	}

	g_ptr_array_set_size (deallocate_stack, 0);
}

static void
deallocate_assert_empty (void)
{
	if (deallocate_stack->len == 0)
		return;

	g_warning ("deallocate_stack not empty as expected.");
	deallocate_all ();
}

static void *
register_allocation (void *data, ParseDeallocator freer)
{
	/* It's handy to be able to register and unregister NULLs.  */
	if (data) {
		int len;
		/*
		 * There are really only a few different freers, so we
		 * could encode the freer in the lower bits of the data
		 * pointer.  Unfortunately, no-one can predict how high
		 * Miguel would jump when he found out.
		 */
		len = deallocate_stack->len;
		g_ptr_array_set_size (deallocate_stack, len + 2);
		g_ptr_array_index (deallocate_stack, len) = data;
		g_ptr_array_index (deallocate_stack, len + 1) = freer;
	}

	/* Returning the pointer here improved readability of the caller.  */
	return data;
}

#define register_expr_allocation(expr) \
  register_allocation ((expr), (ParseDeallocator)&expr_tree_unref)

#define register_expr_list_allocation(list) \
  register_allocation ((list), (ParseDeallocator)&expr_list_unref)

#define register_expr_list_list_allocation(list) \
  register_allocation ((list), (ParseDeallocator)&free_expr_list_list)

static void
unregister_allocation (void const *data)
{
	int pos;

	/* It's handy to be able to register and unregister NULLs.  */
	if (!data)
		return;

	pos = deallocate_stack->len - 2;
	if (pos >= 0 && data == g_ptr_array_index (deallocate_stack, pos)) {
		g_ptr_array_set_size (deallocate_stack, pos);
		return;
	}

	/*
	 * Bummer.  In certain error cases, it is possible that the parser
	 * will reduce after it has discovered a token that will lead to an
	 * error.  "2/16/1800 00:00" (without the quotes) is an example.
	 * The first "00" is registered before the second division is
	 * reduced.
	 *
	 * This isn't a big deal -- we will just look at the entry just below
	 * the top.
	 */
	pos -= 2;
	if (pos >= 0 && data == g_ptr_array_index (deallocate_stack, pos)) {
		g_ptr_array_index (deallocate_stack, pos) =
			g_ptr_array_index (deallocate_stack, pos + 2);
		g_ptr_array_index (deallocate_stack, pos + 1) =
			g_ptr_array_index (deallocate_stack, pos + 3);

		g_ptr_array_set_size (deallocate_stack, pos + 2);
		return;
	}

	g_warning ("Unbalanced allocation registration");
}

/* ------------------------------------------------------------------------- */

#define ERROR -1

/* Bison/Yacc internals */
static int  yylex (void);
static int  yyerror (char *s);

typedef struct {
	/* The expression being parsed */
	char const *expr_text;

	/* A backup of the above, this will always point to the real
	 * expression beginning to calculate the offset in the expression
	 */
	char const *expr_backup;

	/* Location where the parsing is taking place */
	ParsePos const *pos;

	/* Locale info. */
	char decimal_point;
	char separator;
	char array_col_separator;

	/* flags */
	gboolean use_excel_reference_conventions	: 1;
	gboolean create_placeholder_for_unknown_func	: 1;
	gboolean force_absolute_col_references		: 1;
	gboolean force_absolute_row_references		: 1;
	gboolean force_explicit_sheet_references	: 1;

	/* The suggested format to use for this expression */
	StyleFormat **desired_fmt;
	ExprList *result;

	ParseError *error;
} ParserState;

/* The error returned from the */
static ParserState *state;

static ExprTree *
build_unary_op (Operation op, ExprTree *expr)
{
	unregister_allocation (expr);
	return register_expr_allocation (expr_tree_new_unary (op, expr));
}

static ExprTree *
build_binop (ExprTree *l, Operation op, ExprTree *r)
{
	unregister_allocation (r);
	unregister_allocation (l);
	return register_expr_allocation (expr_tree_new_binary (l, op, r));
}

static ExprTree *
build_array (GSList *cols)
{
	Value *array;
	GSList *row;
	int x, mx, y;

	if (!cols) {
		/* parser_error = PARSE_ERR_SYNTAX; */
		return NULL;
	}

	mx  = 0;
	row = cols->data;
	while (row) {
		mx++;
		row = row->next;
	}

	array = value_new_array_empty (mx, g_slist_length (cols));

	y = 0;
	while (cols) {
		row = cols->data;
		x = 0;
		while (row && x < mx) {
			ExprTree *expr = row->data;
			Value    *v = expr->constant.value;

			g_assert (expr->any.oper == OPER_CONSTANT);

			value_array_set (array, x, y, value_duplicate (v));

			x++;
			row = row->next;
		}
		if (x < mx || row) {
			/* parser_error = PARSE_ERR_SYNTAX; */
			value_release (array);
			return NULL;
		}
		y++;
		cols = cols->next;
	}

	return register_expr_allocation (expr_tree_new_constant (array));
}

static gboolean
parse_string_as_value (ExprTree *str)
{
	/*
	 * Try to parse the entered text as a basic value (empty, bool, int,
	 * float, err) if this succeeds, we store this as a Value otherwise, we
	 * return a string.
	 */
	char const *txt = str->constant.value->v_str.val->str;
	Value *v = format_match_simple (txt);

	if (v != NULL) {
		value_release (str->constant.value);
		str->constant.value = v;
		return TRUE;
	}
	return FALSE;
}

/**
 * parse_string_as_value_or_name :
 * @str : An expression with oper constant, whose value is a string.
 *
 * Check to see if a string is a name
 * if it is not check to see if it can be parsed as a value
 */
static ExprTree *
parse_string_as_value_or_name (ExprTree *str)
{
	NamedExpression *expr_name;

	expr_name = expr_name_lookup (state->pos, str->constant.value->v_str.val->str);
	if (expr_name != NULL) {
		unregister_allocation (str); expr_tree_unref (str);
		return register_expr_allocation (expr_tree_new_name (expr_name, NULL, NULL));
	}

	/* NOTE : parse_string_as_value modifies str in place */
	parse_string_as_value (str);
	return str;
}

static int
gnumeric_parse_error (ParserState *state, ParseErrorID id, char *message, int end, int relative_begin)
{
	if (state->error != NULL) {
		state->error->id         = id;
		state->error->message    = message;
		state->error->begin_char = (end - relative_begin);
		state->error->end_char   = end;
	}

	return ERROR;
}

static gboolean
force_explicit_sheet_references (ParserState *state, CellRef *ref)
{
	ref->sheet = state->pos->sheet;
	if (ref->sheet != NULL)
		return FALSE;

	gnumeric_parse_error (
		state, PERR_SHEET_IS_REQUIRED,
		g_strdup (_("Sheet name is required")),
		state->expr_text - state->expr_backup, 0);
	return TRUE;
}

/* Make byacc happier */
int yyparse (void);


#line 361 "parser.y"
typedef union {
	ExprTree *tree;
	CellRef  *cell;
	ExprList *list;
	Sheet	 *sheet;
} YYSTYPE;
#include <stdio.h>



#define	YYFINAL		87
#define	YYFLAG		-32768
#define	YYNTBASE	34

/* YYTRANSLATE(YYLEX) -- Bison token number corresponding to YYLEX. */
#define YYTRANSLATE(x) ((unsigned)(x) <= 269 ? yytranslate[x] : 45)

/* YYTRANSLATE[YYLEX] -- Bison token number corresponding to YYLEX. */
static const char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,    25,    12,     2,
      26,    27,    18,    17,     2,    16,     2,    19,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,    33,
      13,    15,    14,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    30,    32,    31,    24,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    28,     2,    29,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    20,    21,    22,    23
};

#if YYDEBUG != 0
static const short yyprhs[] =
{
       0,     0,     3,     5,     9,    10,    12,    14,    16,    18,
      22,    26,    30,    34,    38,    42,    46,    50,    54,    58,
      62,    66,    70,    73,    76,    79,    83,    88,    91,    96,
      98,   100,   103,   109,   111,   112,   114,   117,   121,   127,
     129,   133,   136,   137,   139,   141,   143,   147,   151,   152,
     154
};
static const short yyrhs[] =
{
      35,    36,     0,     1,     0,    35,    36,    10,     0,     0,
       5,     0,     4,     0,     3,     0,    40,     0,    36,    17,
      36,     0,    36,    16,    36,     0,    36,    18,    36,     0,
      36,    19,    36,     0,    36,    24,    36,     0,    36,    12,
      36,     0,    36,    15,    36,     0,    36,    13,    36,     0,
      36,    14,    36,     0,    36,     7,    36,     0,    36,     9,
      36,     0,    36,     8,    36,     0,    26,    36,    27,     0,
      36,    25,     0,    16,    36,     0,    17,    36,     0,    28,
      44,    29,     0,     3,    26,    41,    27,     0,    38,    37,
       0,    30,    37,    31,    37,     0,     3,     0,     4,     0,
      37,    23,     0,    30,    37,    31,    37,    23,     0,    38,
       0,     0,     6,     0,    38,     6,     0,     6,    22,     6,
       0,    38,     6,    22,    39,     6,     0,    36,     0,    36,
      10,    41,     0,    10,    41,     0,     0,     5,     0,    37,
       0,    42,     0,    42,    10,    43,     0,    42,    32,    43,
       0,     0,    43,     0,    43,    33,    44,     0
};

#endif

#if YYDEBUG != 0
/* YYRLINE[YYN] -- source line where rule number YYN was defined. */
static const short yyrline[] =
{
       0,   384,   389,   397,   401,   404,   405,   406,   407,   408,
     409,   410,   411,   412,   413,   414,   415,   416,   417,   418,
     419,   420,   422,   423,   424,   426,   432,   451,   471,   510,
     511,   514,   530,   555,   556,   559,   569,   574,   594,   609,
     614,   620,   630,   633,   634,   637,   642,   655,   669,   672,
     677
};
#endif


#if YYDEBUG != 0 || defined YYERROR_VERBOSE

/* YYTNAME[TOKEN_NUM] -- String name of the token TOKEN_NUM. */
static const char *const yytname[] =
{
  "$", "error", "$undefined.", "STRING", "QUOTED_STRING", "CONSTANT", 
  "CELLREF", "GTE", "LTE", "NE", "SEPARATOR", "INVALID_TOKEN", "'&'", 
  "'<'", "'>'", "'='", "'-'", "'+'", "'*'", "'/'", "NEG", "PLUS", 
  "RANGE_SEP", "SHEET_SEP", "'^'", "'%'", "'('", "')'", "'{'", "'}'", 
  "'['", "']'", "'\\\\'", "';'", "line", "opt_exp", "exp", 
  "string_opt_quote", "sheetref", "opt_sheetref", "cellref", "arg_list", 
  "array_exp", "array_row", "array_cols", NULL
};
#endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives. */
static const short yyr1[] =
{
       0,    34,    34,    35,    35,    36,    36,    36,    36,    36,
      36,    36,    36,    36,    36,    36,    36,    36,    36,    36,
      36,    36,    36,    36,    36,    36,    36,    36,    36,    37,
      37,    38,    38,    39,    39,    40,    40,    40,    40,    41,
      41,    41,    41,    42,    42,    43,    43,    43,    43,    44,
      44
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN. */
static const short yyr2[] =
{
       0,     2,     1,     3,     0,     1,     1,     1,     1,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     2,     2,     2,     3,     4,     2,     4,     1,
       1,     2,     5,     1,     0,     1,     2,     3,     5,     1,
       3,     2,     0,     1,     1,     1,     3,     3,     0,     1,
       3
};

/* YYDEFACT[S] -- default rule to reduce with in state S when YYTABLE
   doesn't specify something else to do.  Zero means the default is an
   error. */
static const short yydefact[] =
{
       0,     2,     0,     7,     6,     5,    35,     0,     0,     0,
      48,     0,     1,     0,     0,     8,    42,     0,    23,    24,
       0,    29,    30,    43,    44,    45,    49,     0,     0,     0,
       0,     0,     3,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    22,    31,    36,    27,    42,    39,     0,    37,
      21,    48,    48,    48,    25,     0,    18,    20,    19,    14,
      16,    17,    15,    10,     9,    11,    12,    13,    34,    41,
      42,    26,    46,    47,    50,    28,     0,    33,     0,    40,
      32,     0,    38,     0,     0,     0,     0,     0
};

static const short yydefgoto[] =
{
      85,     2,    47,    13,    14,    78,    15,    48,    25,    26,
      27
};

static const short yypact[] =
{
       4,-32768,    66,    53,    -5,-32768,     5,    66,    66,    66,
      86,     9,   111,     8,    33,-32768,    58,    27,    35,    35,
      90,-32768,-32768,-32768,-32768,    -4,     7,    15,    18,    66,
      66,    66,-32768,    66,    66,    66,    66,    66,    66,    66,
      66,    66,-32768,-32768,    16,-32768,    58,   130,    38,-32768,
  -32768,    86,    86,    86,-32768,     9,    -2,    -2,    -2,   143,
      -2,    -2,    -2,   145,   145,    35,    35,    35,    -1,-32768,
      58,-32768,-32768,-32768,-32768,    44,     9,-32768,    74,-32768,
  -32768,    50,-32768,     9,    44,    85,    87,-32768
};

static const short yypgoto[] =
{
  -32768,-32768,    17,   -10,    25,-32768,-32768,   -35,-32768,    26,
      42
};


#define	YYLAST		170


static const short yytable[] =
{
      24,    28,    21,    22,    45,     1,    51,    -4,    -4,    -4,
      -4,    69,    21,    22,    37,    38,    39,    40,   -30,    12,
      -4,    -4,    41,    42,    18,    19,    20,    17,    52,    76,
      -4,    43,    -4,    49,    -4,    79,    21,    22,    68,    44,
      53,    24,    24,    24,    54,    75,    56,    57,    58,    55,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    41,
      42,     3,     4,     5,     6,    71,    81,    80,    46,     3,
       4,     5,     6,    84,     7,     8,   -29,    72,    73,    16,
      82,    83,     7,     8,     9,    86,    10,    87,    11,    21,
      22,    23,     9,    77,    10,    74,    11,    29,    30,    31,
       0,     0,    33,    34,    35,    36,    37,    38,    39,    40,
       0,     0,     0,     0,    41,    42,     0,    50,    29,    30,
      31,    32,     0,    33,    34,    35,    36,    37,    38,    39,
      40,     0,     0,     0,     0,    41,    42,    29,    30,    31,
      70,     0,    33,    34,    35,    36,    37,    38,    39,    40,
      29,    30,    31,     0,    41,    42,    34,    35,    36,    37,
      38,    39,    40,    39,    40,     0,     0,    41,    42,    41,
      42
};

static const short yycheck[] =
{
      10,    11,     3,     4,    14,     1,    10,     3,     4,     5,
       6,    46,     3,     4,    16,    17,    18,    19,    23,     2,
      16,    17,    24,    25,     7,     8,     9,    22,    32,    30,
      26,    23,    28,     6,    30,    70,     3,     4,    22,     6,
      33,    51,    52,    53,    29,    55,    29,    30,    31,    31,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    24,
      25,     3,     4,     5,     6,    27,    76,    23,    10,     3,
       4,     5,     6,    83,    16,    17,    23,    51,    52,    26,
       6,    31,    16,    17,    26,     0,    28,     0,    30,     3,
       4,     5,    26,    68,    28,    53,    30,     7,     8,     9,
      -1,    -1,    12,    13,    14,    15,    16,    17,    18,    19,
      -1,    -1,    -1,    -1,    24,    25,    -1,    27,     7,     8,
       9,    10,    -1,    12,    13,    14,    15,    16,    17,    18,
      19,    -1,    -1,    -1,    -1,    24,    25,     7,     8,     9,
      10,    -1,    12,    13,    14,    15,    16,    17,    18,    19,
       7,     8,     9,    -1,    24,    25,    13,    14,    15,    16,
      17,    18,    19,    18,    19,    -1,    -1,    24,    25,    24,
      25
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/share/bison/bison.simple"

/* Skeleton output parser for bison,
   Copyright 1984, 1989, 1990, 2000, 2001 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser when
   the %semantic_parser declaration is not specified in the grammar.
   It was written by Richard Stallman by simplifying the hairy parser
   used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
# ifdef alloca
#  define YYSTACK_USE_ALLOCA 1
# else /* alloca not defined */
#  ifdef __GNUC__
#   define YYSTACK_USE_ALLOCA 1
#   define alloca __builtin_alloca
#  else /* not GNU C.  */
#   if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#    define YYSTACK_USE_ALLOCA 1
#    include <alloca.h>
#   else /* not sparc */
     /* We think this test detects Watcom and Microsoft C.  */
     /* This used to test MSDOS, but that is a bad idea since that
	symbol is in the user namespace.  */
#    if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#     if 0
       /* No need for malloc.h, which pollutes the namespace; instead,
	  just don't use alloca.  */
#      include <malloc.h>
#     endif
#    else /* not MSDOS, or __TURBOC__ */
#     if defined(_AIX)
       /* I don't know what this was needed for, but it pollutes the
	  namespace.  So I turned it off.  rms, 2 May 1997.  */
       /* #include <malloc.h>  */
 #pragma alloca
#      define YYSTACK_USE_ALLOCA 1
#     else /* not MSDOS, or __TURBOC__, or _AIX */
#      if 0
	/* haible@ilog.fr says this works for HPUX 9.05 and up, and on
	   HPUX 10.  Eventually we can turn this on.  */
#       ifdef __hpux
#        define YYSTACK_USE_ALLOCA 1
#        define alloca __builtin_alloca
#  	endif /* __hpux */
#      endif
#     endif /* not _AIX */
#    endif /* not MSDOS, or __TURBOC__ */
#   endif /* not sparc */
#  endif /* not GNU C */
# endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifndef YYSTACK_USE_ALLOCA
# define YYSTACK_USE_ALLOCA 0
#endif

#if YYSTACK_USE_ALLOCA
# define YYSTACK_ALLOC alloca
#else
# define YYSTACK_ALLOC malloc
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");			\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).

   When YYLLOC_DEFAULT is run, CURRENT is set the location of the
   first token.  By default, to implement support for ranges, extend
   its range to the last symbol.  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)       	\
   Current.last_line   = Rhs[N].last_line;	\
   Current.last_column = Rhs[N].last_column;
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#if YYPURE
# if YYLSP_NEEDED
#  ifdef YYLEX_PARAM
#   define YYLEX		yylex (&yylval, &yylloc, YYLEX_PARAM)
#  else
#   define YYLEX		yylex (&yylval, &yylloc)
#  endif
# else /* !YYLSP_NEEDED */
#  ifdef YYLEX_PARAM
#   define YYLEX		yylex (&yylval, YYLEX_PARAM)
#  else
#   define YYLEX		yylex (&yylval)
#  endif
# endif /* !YYLSP_NEEDED */
#else /* !YYPURE */
# define YYLEX			yylex ()
#endif /* !YYPURE */


/* Enable debugging if requested.  */
#if YYDEBUG
# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    fprintf Args;				\
} while (0)
/* Nonzero means print parse trace. [The following comment makes no
   sense to me.  Could someone clarify it?  --akim] Since this is
   uninitialized, it does not stop multiple parsers from coexisting.
   */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
#endif /* !YYDEBUG */

/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).  */
#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
# define __yy_memcpy(To, From, Count)	__builtin_memcpy (To, From, Count)
#else				/* not GNU C or C++ */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
# ifndef __cplusplus
__yy_memcpy (to, from, count)
     char *to;
     const char *from;
     unsigned int count;
# else /* __cplusplus */
__yy_memcpy (char *to, const char *from, unsigned int count)
# endif
{
  register const char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif

#line 216 "/usr/share/bison/bison.simple"


/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
# ifdef __cplusplus
#  define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#  define YYPARSE_PARAM_DECL
# else /* !__cplusplus */
#  define YYPARSE_PARAM_ARG YYPARSE_PARAM
#  define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
# endif /* !__cplusplus */
#else /* !YYPARSE_PARAM */
# define YYPARSE_PARAM_ARG
# define YYPARSE_PARAM_DECL
#endif /* !YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
# ifdef YYPARSE_PARAM
int yyparse (void *);
# else
int yyparse (void);
# endif
#endif

/* YY_DECL_VARIABLES -- depending whether we use a pure parser,
   variables are global, or local to YYPARSE.  */

#define _YY_DECL_VARIABLES				\
/* The lookahead symbol.  */				\
int yychar;						\
							\
/* The semantic value of the lookahead symbol. */	\
YYSTYPE yylval;						\
							\
/* Number of parse errors so far.  */			\
int yynerrs;

#if YYLSP_NEEDED
# define YY_DECL_VARIABLES			\
_YY_DECL_VARIABLES				\
						\
/* Location data for the lookahead symbol.  */	\
YYLTYPE yylloc;
#else
# define YY_DECL_VARIABLES			\
_YY_DECL_VARIABLES
#endif


/* If nonreentrant, generate the variables here. */

#if !YYPURE
YY_DECL_VARIABLES
#endif  /* !YYPURE */

int
yyparse (YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  /* If reentrant, generate the variables here. */
#if YYPURE
  YY_DECL_VARIABLES
#endif  /* !YYPURE */

  register int yystate;
  register int yyn;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yychar1 = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yysv': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack. */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;

#if YYLSP_NEEDED
  /* The location stack.  */
  YYLTYPE yylsa[YYINITDEPTH];
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;
#endif

#if YYLSP_NEEDED
# define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
# define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;


  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
# if YYLSP_NEEDED
  YYLTYPE yyloc;
# endif

  /* When reducing, the number of symbols on the RHS of the reduced
     rule. */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;
#if YYLSP_NEEDED
  yylsp = yyls;
#endif
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack. Use copies of
	 these so that the &'s don't force the real ones into memory.
	 */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#if YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of the
	 data in use in that stack, in bytes.  */
# if YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow ("parser stack overflow",
		  &yyss1, size * sizeof (*yyssp),
		  &yyvs1, size * sizeof (*yyvsp),
		  &yyls1, size * sizeof (*yylsp),
		  &yystacksize);
# else
      yyoverflow ("parser stack overflow",
		  &yyss1, size * sizeof (*yyssp),
		  &yyvs1, size * sizeof (*yyvsp),
		  &yystacksize);
# endif

      yyss = yyss1; yyvs = yyvs1;
# if YYLSP_NEEDED
      yyls = yyls1;
# endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror ("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      free (yyss);
	      free (yyvs);
# if YYLSP_NEEDED
	      free (yyls);
# endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
# if !YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
# endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
# if YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
# endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#if YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

      YYDPRINTF ((stderr, "Stack size increased to %d\n", yystacksize));

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yychar1 = YYTRANSLATE (yychar);

#if YYDEBUG
     /* We have to keep this `#if YYDEBUG', since we use variables
	which are defined only if `YYDEBUG' is set.  */
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise
	     meaning of a token, for further debugging info.  */
# ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
# endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#if YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to the semantic value of
     the lookahead token.  This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

#if YYLSP_NEEDED
  /* Similarly for the default location.  Let the user run additional
     commands if for instance locations are ranges.  */
  yyloc = yylsp[1-yylen];
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
#endif

#if YYDEBUG
  /* We have to keep this `#if YYDEBUG', since we use variables which
     are defined only if `YYDEBUG' is set.  */
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif

  switch (yyn) {

case 1:
#line 384 "parser.y"
{
		unregister_allocation (yyvsp[0].tree);
		state->result = expr_list_prepend (yyvsp[-1].list, yyvsp[0].tree);
	;
    break;}
case 2:
#line 389 "parser.y"
{
		if (state->result != NULL) {
			expr_list_unref (state->result);
			state->result = NULL;
		}
	;
    break;}
case 3:
#line 397 "parser.y"
{
	       unregister_allocation (yyvsp[-1].tree);
	       yyval.list = expr_list_prepend (yyvsp[-2].list, yyvsp[-1].tree);
	;
    break;}
case 4:
#line 401 "parser.y"
{ yyval.list = NULL; ;
    break;}
case 5:
#line 404 "parser.y"
{ yyval.tree = yyvsp[0].tree; ;
    break;}
case 6:
#line 405 "parser.y"
{ yyval.tree = yyvsp[0].tree; ;
    break;}
case 7:
#line 406 "parser.y"
{ yyval.tree = parse_string_as_value_or_name (yyvsp[0].tree); ;
    break;}
case 8:
#line 407 "parser.y"
{ yyval.tree = yyvsp[0].tree; ;
    break;}
case 9:
#line 408 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_ADD,       yyvsp[0].tree); ;
    break;}
case 10:
#line 409 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_SUB,       yyvsp[0].tree); ;
    break;}
case 11:
#line 410 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_MULT,      yyvsp[0].tree); ;
    break;}
case 12:
#line 411 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_DIV,       yyvsp[0].tree); ;
    break;}
case 13:
#line 412 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_EXP,       yyvsp[0].tree); ;
    break;}
case 14:
#line 413 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_CONCAT,    yyvsp[0].tree); ;
    break;}
case 15:
#line 414 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_EQUAL,     yyvsp[0].tree); ;
    break;}
case 16:
#line 415 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_LT,        yyvsp[0].tree); ;
    break;}
case 17:
#line 416 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_GT,        yyvsp[0].tree); ;
    break;}
case 18:
#line 417 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_GTE,       yyvsp[0].tree); ;
    break;}
case 19:
#line 418 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_NOT_EQUAL, yyvsp[0].tree); ;
    break;}
case 20:
#line 419 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_LTE,       yyvsp[0].tree); ;
    break;}
case 21:
#line 420 "parser.y"
{ yyval.tree = yyvsp[-1].tree; ;
    break;}
case 22:
#line 422 "parser.y"
{ yyval.tree = build_unary_op (OPER_PERCENT, yyvsp[-1].tree); ;
    break;}
case 23:
#line 423 "parser.y"
{ yyval.tree = build_unary_op (OPER_UNARY_NEG, yyvsp[0].tree); ;
    break;}
case 24:
#line 424 "parser.y"
{ yyval.tree = build_unary_op (OPER_UNARY_PLUS, yyvsp[0].tree); ;
    break;}
case 25:
#line 426 "parser.y"
{
		unregister_allocation (yyvsp[-1].list);
		yyval.tree = build_array (yyvsp[-1].list);
		free_expr_list_list (yyvsp[-1].list);
	;
    break;}
case 26:
#line 432 "parser.y"
{
		char const *name = yyvsp[-3].tree->constant.value->v_str.val->str;
		FunctionDefinition *f = func_lookup_by_name (name,
			state->pos->wb);

		/* THINK TODO: Do we want to make this workbook-local??  */
		if (f == NULL && state->create_placeholder_for_unknown_func)
			f = function_add_placeholder (name, "");

		unregister_allocation (yyvsp[-1].list);
		unregister_allocation (yyvsp[-3].tree); expr_tree_unref (yyvsp[-3].tree);

		if (f == NULL) {
			expr_list_unref (yyvsp[-1].list);
			YYERROR;
		} else {
			yyval.tree = register_expr_allocation (expr_tree_new_funcall (f, yyvsp[-1].list));
		}
	;
    break;}
case 27:
#line 451 "parser.y"
{
		NamedExpression *expr_name;
		char *name = yyvsp[0].tree->constant.value->v_str.val->str;
		ParsePos pos = *state->pos;

		pos.sheet = yyvsp[-1].sheet;
		expr_name = expr_name_lookup (&pos, name);
		if (expr_name == NULL) {
			int retval = gnumeric_parse_error (
				state, PERR_UNKNOWN_EXPRESSION,
				g_strdup_printf (_("Name '%s' does not exist in sheet '%s'"),
						name, yyvsp[-1].sheet->name_quoted),
				state->expr_text - state->expr_backup + 1, strlen (name));

			unregister_allocation (yyvsp[0].tree); expr_tree_unref (yyvsp[0].tree);
			return retval;
		} else
			unregister_allocation (yyvsp[0].tree); expr_tree_unref (yyvsp[0].tree);
	        yyval.tree = register_expr_allocation (expr_tree_new_name (expr_name, yyvsp[-1].sheet, NULL));
	;
    break;}
case 28:
#line 471 "parser.y"
{
		NamedExpression *expr_name;
		char *name = yyvsp[0].tree->constant.value->v_str.val->str;
		char *wb_name = yyvsp[-2].tree->constant.value->v_str.val->str;
		ParsePos pos = *state->pos;

		pos.sheet = NULL;
		pos.wb = application_workbook_get_by_name (wb_name);

		if (pos.wb == NULL) {
			int retval = gnumeric_parse_error (
				state, PERR_UNKNOWN_EXPRESSION,
				g_strdup_printf (_("Unknown workbook '%s'"), wb_name), 
				state->expr_text - state->expr_backup + 1, strlen (name));

			unregister_allocation (yyvsp[0].tree); expr_tree_unref (yyvsp[0].tree);
			unregister_allocation (yyvsp[-2].tree); expr_tree_unref (yyvsp[-2].tree);
			return retval;
		}

		expr_name = expr_name_lookup (&pos, name);
		if (expr_name == NULL) {
			int retval = gnumeric_parse_error (
				state, PERR_UNKNOWN_EXPRESSION,
				g_strdup_printf (_("Name '%s' does not exist in workbook '%s'"),
						name, wb_name),
				state->expr_text - state->expr_backup + 1, strlen (name));

			unregister_allocation (yyvsp[0].tree); expr_tree_unref (yyvsp[0].tree);
			unregister_allocation (yyvsp[-2].tree); expr_tree_unref (yyvsp[-2].tree);
			return retval;
		} else {
			unregister_allocation (yyvsp[0].tree); expr_tree_unref (yyvsp[0].tree);
			unregister_allocation (yyvsp[-2].tree); expr_tree_unref (yyvsp[-2].tree);
		}
	        yyval.tree = register_expr_allocation (expr_tree_new_name (expr_name, NULL, pos.wb));
	;
    break;}
case 31:
#line 514 "parser.y"
{
	        char  *name = yyvsp[-1].tree->constant.value->v_str.val->str;
		Sheet *sheet = workbook_sheet_by_name (state->pos->wb, name);
		if (sheet == NULL) {
			int retval = gnumeric_parse_error (
				state, PERR_UNKNOWN_SHEET,
				g_strdup_printf (_("Unknown sheet '%s'"), name),
				state->expr_text - state->expr_backup, strlen (name));

			unregister_allocation (yyvsp[-1].tree); expr_tree_unref (yyvsp[-1].tree);
			return retval;
		} else
			unregister_allocation (yyvsp[-1].tree); expr_tree_unref (yyvsp[-1].tree);
	        yyval.sheet = sheet;
	;
    break;}
case 32:
#line 530 "parser.y"
{
		Workbook * wb =
		    application_workbook_get_by_name (yyvsp[-3].tree->constant.value->v_str.val->str);
		Sheet *sheet = NULL;
		char *sheetname = yyvsp[-1].tree->constant.value->v_str.val->str;

		if (wb != NULL)
			sheet = workbook_sheet_by_name (wb, sheetname);

		unregister_allocation (yyvsp[-3].tree); expr_tree_unref (yyvsp[-3].tree);
		if (sheet == NULL) {
			int retval = gnumeric_parse_error (
				state, PERR_UNKNOWN_SHEET,
				g_strdup_printf (_("Unknown sheet '%s'"), sheetname),
				state->expr_text - state->expr_backup, strlen (sheetname));

			unregister_allocation (yyvsp[-1].tree); expr_tree_unref (yyvsp[-1].tree);
			return retval;
		} else
			unregister_allocation (yyvsp[-1].tree); expr_tree_unref (yyvsp[-1].tree);

	        yyval.sheet = sheet;
        ;
    break;}
case 34:
#line 556 "parser.y"
{ yyval.sheet = NULL; ;
    break;}
case 35:
#line 559 "parser.y"
{
		if (state->force_explicit_sheet_references &&
		    force_explicit_sheet_references (state, &yyvsp[0].tree->var.ref)) {
			unregister_allocation (yyvsp[0].tree);
			expr_tree_unref (yyvsp[0].tree);
			return ERROR;
		}
	        yyval.tree = yyvsp[0].tree;
	;
    break;}
case 36:
#line 569 "parser.y"
{
		yyvsp[0].tree->var.ref.sheet = yyvsp[-1].sheet;
	        yyval.tree = yyvsp[0].tree;
	;
    break;}
case 37:
#line 574 "parser.y"
{
		unregister_allocation (yyvsp[0].tree);
		unregister_allocation (yyvsp[-2].tree);

		if (state->force_explicit_sheet_references &&
		    (force_explicit_sheet_references (state, &yyvsp[-2].tree->var.ref) ||
		     force_explicit_sheet_references (state, &yyvsp[0].tree->var.ref))) {
			expr_tree_unref (yyvsp[0].tree);
			expr_tree_unref (yyvsp[-2].tree);
			return ERROR;
		}

		yyval.tree = register_expr_allocation
			(expr_tree_new_constant
			 (value_new_cellrange (&(yyvsp[-2].tree->var.ref), &(yyvsp[0].tree->var.ref),
					       state->pos->eval.col, state->pos->eval.row)));
		expr_tree_unref (yyvsp[0].tree);
		expr_tree_unref (yyvsp[-2].tree);
	;
    break;}
case 38:
#line 594 "parser.y"
{
		unregister_allocation (yyvsp[0].tree);
		unregister_allocation (yyvsp[-3].tree);
		yyvsp[-3].tree->var.ref.sheet = yyvsp[-4].sheet;
		yyvsp[0].tree->var.ref.sheet = yyvsp[-1].sheet ? yyvsp[-1].sheet : yyvsp[-4].sheet;
		yyval.tree = register_expr_allocation
			(expr_tree_new_constant
			 (value_new_cellrange (&(yyvsp[-3].tree->var.ref), &(yyvsp[0].tree->var.ref),
					       state->pos->eval.col, state->pos->eval.row)));

		expr_tree_unref (yyvsp[0].tree);
		expr_tree_unref (yyvsp[-3].tree);
	;
    break;}
case 39:
#line 609 "parser.y"
{
		unregister_allocation (yyvsp[0].tree);
		yyval.list = g_slist_prepend (NULL, yyvsp[0].tree);
		register_expr_list_allocation (yyval.list);
        ;
    break;}
case 40:
#line 614 "parser.y"
{
		unregister_allocation (yyvsp[0].list);
		unregister_allocation (yyvsp[-2].tree);
		yyval.list = g_slist_prepend (yyvsp[0].list, yyvsp[-2].tree);
		register_expr_list_allocation (yyval.list);
	;
    break;}
case 41:
#line 620 "parser.y"
{
		GSList *tmp = yyvsp[0].list;
		unregister_allocation (yyvsp[0].list);

		if (tmp == NULL)
			tmp = g_slist_prepend (NULL, expr_tree_new_constant (value_new_empty ()));

		yyval.list = g_slist_prepend (tmp, expr_tree_new_constant (value_new_empty ()));
		register_expr_list_allocation (yyval.list);
	;
    break;}
case 42:
#line 630 "parser.y"
{ yyval.list = NULL; ;
    break;}
case 43:
#line 633 "parser.y"
{ yyval.tree = yyvsp[0].tree; ;
    break;}
case 44:
#line 634 "parser.y"
{ parse_string_as_value (yyvsp[0].tree); yyval.tree = yyvsp[0].tree; ;
    break;}
case 45:
#line 637 "parser.y"
{
		unregister_allocation (yyvsp[0].tree);
		yyval.list = g_slist_prepend (NULL, yyvsp[0].tree);
		register_expr_list_allocation (yyval.list);
        ;
    break;}
case 46:
#line 642 "parser.y"
{
		if (state->array_col_separator == ',') {
			unregister_allocation (yyvsp[0].list);
			unregister_allocation (yyvsp[-2].tree);
			yyval.list = g_slist_prepend (yyvsp[0].list, yyvsp[-2].tree);
			register_expr_list_allocation (yyval.list);
		} else {
			return gnumeric_parse_error (
				state, PERR_INVALID_ARRAY_SEPARATOR,
				g_strdup_printf (_("The character %c cannot be used to separate array elements"),
				state->array_col_separator), state->expr_text - state->expr_backup + 1, 1);
		}
	;
    break;}
case 47:
#line 655 "parser.y"
{
		if (state->array_col_separator == '\\') {
			unregister_allocation (yyvsp[0].list);
			unregister_allocation (yyvsp[-2].tree);
			yyval.list = g_slist_prepend (yyvsp[0].list, yyvsp[-2].tree);
			register_expr_list_allocation (yyval.list);
		} else {
			/* FIXME: Is this the right error to display? */
			return gnumeric_parse_error (
				state, PERR_INVALID_ARRAY_SEPARATOR,
				g_strdup_printf (_("The character %c cannot be used to separate array elements"),
				state->array_col_separator), state->expr_text - state->expr_backup + 1, 1);
		}
	;
    break;}
case 48:
#line 669 "parser.y"
{ yyval.list = NULL; ;
    break;}
case 49:
#line 672 "parser.y"
{
		unregister_allocation (yyvsp[0].list);
		yyval.list = g_slist_prepend (NULL, yyvsp[0].list);
		register_expr_list_list_allocation (yyval.list);
        ;
    break;}
case 50:
#line 677 "parser.y"
{
		unregister_allocation (yyvsp[0].list);
		unregister_allocation (yyvsp[-2].list);
		yyval.list = g_slist_prepend (yyvsp[0].list, yyvsp[-2].list);
		register_expr_list_list_allocation (yyval.list);
	;
    break;}
}

#line 610 "/usr/share/bison/bison.simple"


  yyvsp -= yylen;
  yyssp -= yylen;
#if YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;
#if YYLSP_NEEDED
  *++yylsp = yyloc;
#endif

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (int) (sizeof (yytname) / sizeof (char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen (yytname[x]) + 15, count++;
	  size += strlen ("parse error, unexpected `") + 1;
	  size += strlen (yytname[YYTRANSLATE (yychar)]);
	  msg = (char *) malloc (size);
	  if (msg != 0)
	    {
	      strcpy (msg, "parse error, unexpected `");
	      strcat (msg, yytname[YYTRANSLATE (yychar)]);
	      strcat (msg, "'");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (int) (sizeof (yytname) / sizeof (char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat (msg, count == 0 ? ", expecting `" : " or `");
			strcat (msg, yytname[x]);
			strcat (msg, "'");
			count++;
		      }
		}
	      yyerror (msg);
	      free (msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("parse error");
    }
  goto yyerrlab1;


/*--------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action |
`--------------------------------------------------*/
yyerrlab1:
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;
      YYDPRINTF ((stderr, "Discarding token %d (%s).\n",
		  yychar, yytname[yychar1]));
      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;


/*-------------------------------------------------------------------.
| yyerrdefault -- current state does not do anything special for the |
| error token.                                                       |
`-------------------------------------------------------------------*/
yyerrdefault:
#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */

  /* If its default is to accept any token, ok.  Otherwise pop it.  */
  yyn = yydefact[yystate];
  if (yyn)
    goto yydefault;
#endif


/*---------------------------------------------------------------.
| yyerrpop -- pop the current state because it cannot handle the |
| error token                                                    |
`---------------------------------------------------------------*/
yyerrpop:
  if (yyssp == yyss)
    YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#if YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

/*--------------.
| yyerrhandle.  |
`--------------*/
yyerrhandle:
  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;
#if YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#if YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 0;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#if YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 1;
}
#line 684 "parser.y"

/**
 * parse_ref_or_string :
 * @string: the string to try.
 *
 * Attempt to parse the text as a cellref, if it fails
 * return a string.
 * DO NOT attempt to do higher level lookups here.
 *     - sheet names
 *     - function names
 *     - expression names
 *     - value parsing
 * must all be handled by the parser not the lexer.
 */
static int
parse_ref_or_string (char const *string)
{
	CellRef   ref;
	Value *v = NULL;
	char const * res;

	res = cellref_get (&ref, string, &state->pos->eval);
	if (res != NULL && *res == '\0') {
		if (state->force_absolute_col_references &&
		    ref.col_relative) {
			ref.col += state->pos->eval.col;
			ref.col_relative = FALSE;
		}
		if (state->force_absolute_row_references &&
		    ref.row_relative) {
			ref.row += state->pos->eval.row;
			ref.row_relative = FALSE;
		}
		yylval.tree = register_expr_allocation (expr_tree_new_var (&ref));
		return CELLREF;
	}

	v = value_new_string (string);
	yylval.tree = register_expr_allocation (expr_tree_new_constant (v));
	return STRING;
}

/**
 * find_char:
 * @str:
 * @c:
 *
 * Returns a pointer to character c in str.
 * Callers should check whether p is '\0'!
 **/
static char const *
find_char (char const *str, char c)
{
	for (; *str && *str != c; str++)
		if (*str == '\\' && str[1])
			str++;
	return str;
}

static char const *
find_matching_close (char const *str, char const **res)
{
	for (; *str; str++) {
		if (*str == '(') {
			char const *tmp = str;
			str = find_matching_close (str + 1, res);
			if (*str != ')' && *res == NULL) {
				*res = tmp;
				return str;
			}
		} else if (*str == ')')
			return str;
		else if (*str == '\'' || *str == '\"')
			str = find_char (str + 1, *str);
	}

	return str;
}

int
yylex (void)
{
	int c;
	char const *start;
	gboolean is_number = FALSE;

        while (isspace ((unsigned char)*state->expr_text))
                state->expr_text++;

	start = state->expr_text;
	c = (unsigned char) (*state->expr_text++);

	if (c == '(' || c == ')')
		return c;

	if (state->use_excel_reference_conventions) {
		if (c == ':')
			return RANGE_SEP;
		if (c == '!')
			return SHEET_SEP;
	} else {
		/* Treat '..' as range sep (A1..C3) */
		if (c == '.' && *state->expr_text == '.') {
			state->expr_text++;
			return RANGE_SEP;
		}
		if (c == ':')
			return SHEET_SEP;
	}

	if (c == state->separator)
		return SEPARATOR;

	if (c == state->decimal_point) {
		/* Could be a number or a stand alone  */
		if (!isdigit ((unsigned char)(*state->expr_text)))
			return c;
		is_number = TRUE;
	} else if (isdigit (c)) {
		while (isdigit ((c = (unsigned char)(*state->expr_text++))))
			;
		is_number = TRUE;
	}

	if (is_number) {
		Value *v = NULL;

		if (c == state->decimal_point || tolower (c) == 'e') {
			/* This is float */
			char *end;
			double d;

			errno = 0;
			d = strtod (start, &end);
			if (start == end) {
				g_warning ("%s is not a double, but was expected to be one", start);
			}  else if (errno != ERANGE) {
				v = value_new_float ((gnum_float)d);
				state->expr_text = end;
			} else if (tolower (c) != 'e') {
				gnumeric_parse_error (
					state, PERR_OUT_OF_RANGE,
					g_strdup (_("The number is out of range")),
					state->expr_text - state->expr_backup, end - start);
				return INVALID_TOKEN;
			} else {
				/* For an exponent it's hard to highlight the
				 * right region w/o it turning into an ugly
				 * hack, for now the cursor is put at the end.
				 */
				gnumeric_parse_error (
					state, PERR_OUT_OF_RANGE,
					g_strdup (_("The number is out of range")),
					0, 0);
				return INVALID_TOKEN;
			}
		} else {
			/* This could be a row range ref or an integer */
			char *end;
			long l;

			errno = 0;
			l = strtol (start, &end, 10);
			if (start == end) {
				g_warning ("%s is not an integer, but was expected to be one", start);
			} else if (errno != ERANGE) {
				/* Check for a Row range ref (3:4 == A3:IV4) */
				if (*end == ':' && l < SHEET_MAX_COLS) {
				    /* TODO : adjust parser to allow returning
				     * a range, not just a cellref
				     */
				}
				v = value_new_int (l);
				state->expr_text = end;
			} else if (l == LONG_MIN || l == LONG_MAX) {
				double d;

				errno = 0;
				d = strtod (start, &end);
				if (errno != ERANGE) {
					v = value_new_float ((gnum_float)d);
					state->expr_text = end;
				} else {
					gnumeric_parse_error (
						state, PERR_OUT_OF_RANGE,
						g_strdup (_("The number is out of range")),
						state->expr_text - state->expr_backup, end - start);
					return INVALID_TOKEN;
				}
			}
		}

		/* Very odd string,  Could be a bound problem.  Trigger an error */
		if (v == NULL)
			return c;

		yylval.tree = register_expr_allocation (expr_tree_new_constant (v));
		return CONSTANT;
	}

	switch (c){
	case '\'':
	case '"': {
		char const *p;
		char *string, *s;
		char quotes_end = c;
		Value *v;

 		p = state->expr_text;
 		state->expr_text = find_char (state->expr_text, quotes_end);
		if (!*state->expr_text) {
  			gnumeric_parse_error (
  				state, PERR_MISSING_CLOSING_QUOTE,
				g_strdup (_("Could not find matching closing quote")),
  				(p - state->expr_backup) + 1, 1);
			return INVALID_TOKEN;
		}

		s = string = (char *) alloca (1 + state->expr_text - p);
		while (p != state->expr_text){
			if (*p== '\\'){
				p++;
				*s++ = *p++;
			} else
				*s++ = *p++;
		}
		*s = 0;
		state->expr_text++;

		v = value_new_string (string);
		yylval.tree = register_expr_allocation (expr_tree_new_constant (v));
		return QUOTED_STRING;
	}
	}

	if (isalpha ((unsigned char)c) || c == '_' || c == '$'){
		char const *start = state->expr_text - 1;
		char *str;
		int  len;

		while (isalnum ((unsigned char)*state->expr_text) || *state->expr_text == '_' ||
		       *state->expr_text == '$' ||
		       (state->use_excel_reference_conventions && *state->expr_text == '.'))
			state->expr_text++;

		len = state->expr_text - start;
		str = alloca (len + 1);
		strncpy (str, start, len);
		str [len] = 0;
		return parse_ref_or_string (str);
	}

	if (c == '\n' || c == 0)
		return 0;

	if (c == '<'){
		if (*state->expr_text == '='){
			state->expr_text++;
			return LTE;
		}
		if (*state->expr_text == '>'){
			state->expr_text++;
			return NE;
		}
		return c;
	}

	if (c == '>'){
		if (*state->expr_text == '='){
			state->expr_text++;
			return GTE;
		}
		return c;
	}

	return c;
}

int
yyerror (char *s)
{
#if 0
	printf ("Error: %s\n", s);
#endif
	return 0;
}

/**
 * expr_parse_str:
 *
 * @expr_text   : The string to parse.
 * @flags       : See parse-utils for descriptions
 * @desired_fmt : optionally NULL ptr to the best format for result
 * @error       : optionally NULL ptr to store details of error.
 *
 * Parse a string. if @error is non-null it will be assumed that the
 * caller has passed a pointer to a ParseError struct AND that it will
 * take responsibility for freeing that struct and it's contents.
 * with parse_error_free.
 **/
ExprTree *
expr_parse_str (char const *expr_text, ParsePos const *pos,
		GnmExprParserFlags flags,
		StyleFormat **desired_fmt,
	        ParseError *error)
{
	ExprTree *expr;
	ParserState pstate;

	g_return_val_if_fail (expr_text != NULL, NULL);

	pstate.expr_text   = expr_text;
	pstate.expr_backup = expr_text;
	pstate.pos	   = pos;

	pstate.decimal_point	   = format_get_decimal ();
	pstate.separator 	   = format_get_arg_sep ();
	pstate.array_col_separator = format_get_col_sep ();

	pstate.use_excel_reference_conventions	   	= !(flags & GNM_PARSER_USE_APPLIX_REFERENCE_CONVENTIONS);
	pstate.create_placeholder_for_unknown_func	= flags & GNM_PARSER_CREATE_PLACEHOLDER_FOR_UNKNOWN_FUNC;
	pstate.force_absolute_col_references		= flags & GNM_PARSER_FORCE_ABSOLUTE_COL_REFERENCES;
	pstate.force_absolute_row_references		= flags & GNM_PARSER_FORCE_ABSOLUTE_ROW_REFERENCES;
	pstate.force_explicit_sheet_references		= flags & GNM_PARSER_FORCE_EXPLICIT_SHEET_REFERENCES;

	pstate.result = NULL;
	pstate.desired_fmt = desired_fmt;
	if (pstate.desired_fmt)
		*pstate.desired_fmt = NULL;

	pstate.error = error;
	
	if (deallocate_stack == NULL)
		deallocate_init ();

	g_return_val_if_fail (pstate.pos != NULL, NULL);
	g_return_val_if_fail (pstate.expr_text != NULL, NULL);
	g_return_val_if_fail (state == NULL, NULL);

	state = &pstate;
	yyparse ();
	state = NULL;

	if (pstate.result != NULL) {
		deallocate_assert_empty ();

#if 0
		/* If this happens, something is very wrong */
		if (pstate.error != NULL && pstate.error->message != NULL) {
			g_warning ("An error occurred and the ExprTree is non-null! This should not happen");
			g_warning ("Error message is %s (%d, %d)", pstate.error->message, pstate.error->begin_char,
					pstate.error->end_char);
		}
#endif

		if (desired_fmt != NULL) {
			StyleFormat *format;
			EvalPos tmp;

			tmp.sheet = pos->sheet;
			tmp.eval = pos->eval;
			format = auto_style_format_suggest (pstate.result->data, &tmp);
			if (format != NULL) {
				/* Override the format that came from a
				 * constant somewhere inside.
				 */
				if (*desired_fmt != NULL)
					style_format_unref (*desired_fmt);
				*desired_fmt = format;
			}
		}

		/* Do we have multiple expressions */
		if (pstate.result->next != NULL) {
			if (flags & GNM_PARSER_PERMIT_MULTIPLE_EXPRESSIONS)
				expr = expr_tree_new_set (g_slist_reverse (pstate.result));
			else {
				expr_list_unref (pstate.result);
				gnumeric_parse_error (&pstate, PERR_MULTIPLE_EXPRESSIONS,
					g_strdup (_("Multiple expressions are not supported in this context")),
					(pstate.expr_text - pstate.expr_backup) + 1,
					(pstate.expr_text - pstate.expr_backup));
				expr = NULL;
			}
		} else {
			/* Free the list, do not unref the content */
			expr = pstate.result->data;
			expr_list_free (pstate.result);
		}
	} else {
		/* If there is no error message, attempt to be more detailed */
		if (pstate.error != NULL && pstate.error->message == NULL) {
			char const *last_token = pstate.expr_text - 1;

			if (*last_token == '\0') {
				char const *str = pstate.expr_backup;
				char const *res = NULL;
				char const *last = find_matching_close (str, &res);

				if (*last)
					gnumeric_parse_error (&pstate, PERR_MISSING_PAREN_OPEN,
						g_strdup (_("Could not find matching opening parenthesis")),
						(last - str) + 2, 1);
				else if (res != NULL)
					gnumeric_parse_error (&pstate, PERR_MISSING_PAREN_CLOSE,
						g_strdup (_("Could not find matching closing parenthesis")),
						(res - str) + 2, 1);
				else
					gnumeric_parse_error (&pstate, PERR_INVALID_EXPRESSION,
						g_strdup (_("Invalid expression")),
						(pstate.expr_text - pstate.expr_backup) + 1,
						(pstate.expr_text - pstate.expr_backup));
			} else
				gnumeric_parse_error (&pstate, PERR_UNEXPECTED_TOKEN,
					g_strdup_printf (_("Unexpected token %c"), *last_token),
					(last_token - pstate.expr_backup) + 1, 1);
		}

		deallocate_all ();
		if (desired_fmt != NULL && *desired_fmt != NULL) {
			style_format_unref (*desired_fmt);
			*desired_fmt = NULL;
		}

		expr = NULL;
	}

	deallocate_uninit ();

	return expr;
}
