/* GOB C Preprocessor
 * Copyright (C) 1999 the Free Software Foundation.
 *
 * Author: George Lebl
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the  Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */
%{

#include "config.h"
#include <glib.h>
#include <string.h>

#include "treefuncs.h"
#include "parse.h"
#include "main.h"
#include "util.h"

static int parenth_depth = 0;
static int before_comment = INITIAL;
static gboolean class_after_c = FALSE;
static int code_type = CCODE;

/* GTK+ doc stuff */
static char *gtk_doc_func = NULL; /* current gtk-doc func */
GHashTable *gtk_doc_hash = NULL;

static GString *cbuf = NULL;
int ccode_line = 1;

GList *include_files = NULL;
/* 0 no, 1 means yes, 2+ means don't even start looking anymore */
static int look_for_includes = 0;

int line_no = 1;

static void
clear_cbuf(void)
{
	if(!cbuf) {
		cbuf = g_string_new(NULL);
	} else {
		cbuf = g_string_assign(cbuf, "");
	}
}

static void
add_to_cbuf(char *s)
{
	if(!cbuf) {
		cbuf = g_string_new(s);
	} else {
		cbuf = g_string_append(cbuf,s);
	}
}

static void
add_gtk_doc_func(void)
{
	if(!gtk_doc_func)
		return;

	if(!gtk_doc_hash)
		gtk_doc_hash = g_hash_table_new(g_str_hash, g_str_equal);
	g_hash_table_insert(gtk_doc_hash, gtk_doc_func, g_strdup(cbuf->str));
	clear_cbuf();

	gtk_doc_func = NULL;
}

/* Ugly warning avoiding */
#ifdef FLEX_SCANNER
int yylex(void);
#endif

%}

%x COMMENT
%x C_CODE
%x C_CODE_STRING
%x CLASS_CODE
%x CLASS_CODE_I
%x GTK_DOC_BEFORE_NAME
%x GTK_DOC
%x GTK_DOC_LINE



%%

<*>\n			{ line_no++; REJECT; }

<COMMENT>^(I(S.RI).E\(([1-9][0-9]+|[2-9]))/(\))	{
/* Thy evil easter egg */
#define QQ(x) long x
#define KK(x) =atoi(__(&,,x,))
#define MM(x,a) {QQ(i);for(i=2;i<x;i++){a}}
#define PP(Q) (P%Q)==0
#define ___(x,y,z) if(x z y)
#define __(a,x,y,z) a(yytext[y] x z)
#define O__O(a,b) fprintf(stderr,"%s is %s!\n",a,b)
QQ(m)=1;___(__(,==,2,'P'),__(,==,5,'M'),&&
){QQ(P)KK(8);MM(P,___(PP(i),,)m=0;)}__(,=,
7,0);___(,,m){O__O(__( &,,8,),__(&,,2,));}
#undef QQ
#undef KK
#undef MM
#undef PP
#undef ___
#undef __
#undef O__O
REJECT;
}

\/\/.*$			{ ; /*comment, ignore*/ }
<C_CODE>^#[ \t]*include[ \t][<"][^\n">]*[>"] {
	if(look_for_includes==1) {
		char *p;
		char *file;
		char *str = g_strdup(yytext);
		file = strchr(str,'"');
		if(!file) file = strchr(str,'<');
		file++;
		p = strchr(file,'"');
		if(!p) p = strchr(file,'>');
		*p = '\0';
		include_files = g_list_prepend(include_files,g_strdup(file));
		g_free(str);
	}
	REJECT;
}

<CLASS_CODE_I>\/\*\*[ \t]*$	{
			/* eat out gtk doc stuff */
			BEGIN(GTK_DOC_BEFORE_NAME);
			clear_cbuf();
		}
<GTK_DOC_BEFORE_NAME>^[ \t]*\*[ \t]*$ 	{
			/* empty doc lines */
			;
		}	
<GTK_DOC_BEFORE_NAME>^[ \t]*\*\ [_a-zA-Z][_a-zA-Z0-9]*:?[ \t]*$	{
			char *p;
			BEGIN(GTK_DOC);
			p = strchr(yytext, '*');
			g_free(gtk_doc_func);
			gtk_doc_func = g_strdup(p+2);
			p = strchr(gtk_doc_func, ':');
			if(p) *p='\0';
			g_strstrip(gtk_doc_func);
		}
<GTK_DOC_BEFORE_NAME>\*\/	{
			BEGIN(CLASS_CODE_I);
		}
<GTK_DOC_BEFORE_NAME>.	{
			BEGIN(COMMENT);
			before_comment = CLASS_CODE_I;
		}
<GTK_DOC>^[ \t]*\*[ \t]*$ 	{
			/* empty doc lines */
			add_to_cbuf(" *\n");
		}	
<GTK_DOC>^[ \t]*\*?\*\/	{
			BEGIN(CLASS_CODE_I);
			add_gtk_doc_func();
		}
<GTK_DOC>^[ \t]*\*\ 	{
			fflush(stdout);
			add_to_cbuf(" * ");
			BEGIN(GTK_DOC_LINE);
		}
<GTK_DOC>\*\/	{
			BEGIN(CLASS_CODE_I);
		}
<GTK_DOC>.	{
			BEGIN(COMMENT);
			before_comment = CLASS_CODE_I;
		}
<GTK_DOC_LINE>\*\/	{
			BEGIN(CLASS_CODE_I);
			add_to_cbuf("\n");
			add_gtk_doc_func();
		}
<GTK_DOC_LINE>.$	{
			BEGIN(GTK_DOC);
			add_to_cbuf(yytext);
			add_to_cbuf("\n");
		}
<GTK_DOC_LINE>.	{
			fflush(stdout);
			add_to_cbuf(yytext);
		}

<C_CODE>\/\/.*$		{ add_to_cbuf(yytext); /*comment, ignore*/ }
<CLASS_CODE>\/\/.*$	{ ; /*comment, ignore*/ }
<CLASS_CODE_I>\/\/.*$	{ ; /*comment, ignore*/ }
\/\*		{BEGIN(COMMENT); before_comment = INITIAL; }
<C_CODE>\/\*	{
	add_to_cbuf(yytext);
	BEGIN(COMMENT);
	before_comment = C_CODE;
}
<CLASS_CODE>\/\*	{BEGIN(COMMENT); before_comment = CLASS_CODE; }
<CLASS_CODE_I>\/\*	{BEGIN(COMMENT); before_comment = CLASS_CODE_I; }
<COMMENT>\*\/	{
	if(before_comment == C_CODE) add_to_cbuf(yytext);
	BEGIN(before_comment);
		}
<COMMENT>.	{
	/* comment, ignore */
	if(before_comment == C_CODE) add_to_cbuf(yytext);
		}
<COMMENT>\n	{
	/* comment, ignore */
	if(before_comment == C_CODE) add_to_cbuf(yytext);
		}

^\%(a|all)\{		{
			BEGIN(C_CODE);
			parenth_depth = 1;
			class_after_c = FALSE;
			code_type = ACODE;
			clear_cbuf();
			ccode_line = line_no;
		}
^\%(at|alltop)\{		{
			BEGIN(C_CODE);
			parenth_depth = 1;
			class_after_c = FALSE;
			code_type = ATCODE;
			clear_cbuf();
			ccode_line = line_no;
		}

^\%(ht|headertop)\{		{
			BEGIN(C_CODE);
			parenth_depth = 1;
			class_after_c = FALSE;
			code_type = HTCODE;
			clear_cbuf();
			ccode_line = line_no;
		}
^\%(ph|privateheader)\{		{
			BEGIN(C_CODE);
			parenth_depth = 1;
			class_after_c = FALSE;
			code_type = PHCODE;
			clear_cbuf();
			ccode_line = line_no;
		}
^\%(h|header)\{		{
			BEGIN(C_CODE);
			parenth_depth = 1;
			class_after_c = FALSE;
			code_type = HCODE;
			clear_cbuf();
			ccode_line = line_no;
		}
^\%\{		{
			BEGIN(C_CODE);
			parenth_depth = 1;
			class_after_c = FALSE;
			code_type = CCODE;
			clear_cbuf();
			ccode_line = line_no;
			if(look_for_includes==0)
				look_for_includes=1;
		}
<C_CODE>^\%\}	{
			BEGIN(INITIAL);
			yylval.cbuf = cbuf;
			cbuf = NULL;
			if(look_for_includes==1)
				look_for_includes=0;
			return code_type;
		}

<C_CODE>\'\{\'		{ add_to_cbuf(yytext); }
<C_CODE>\'\\\{\'	{ add_to_cbuf(yytext); }
<C_CODE>\'\}\'		{ add_to_cbuf(yytext); }
<C_CODE>\'\\\}\'	{ add_to_cbuf(yytext); }
<C_CODE>\'\"\'		{ add_to_cbuf(yytext); }
<C_CODE>\'\\\"\'	{ add_to_cbuf(yytext); }
	
<C_CODE>\\.	{ add_to_cbuf(yytext); }
<C_CODE>\"	{
			BEGIN(C_CODE_STRING);
			add_to_cbuf(yytext);
		}
<C_CODE_STRING>\\.	{ add_to_cbuf(yytext); }
<C_CODE_STRING>\"	{
				BEGIN(C_CODE);
				add_to_cbuf(yytext);
			}
<C_CODE_STRING>.	{ add_to_cbuf(yytext); }
<C_CODE_STRING>\n	{ add_to_cbuf(yytext); }

<C_CODE>\{	{
			parenth_depth++;
			add_to_cbuf(yytext);
		}
<C_CODE>\}	{
			parenth_depth--;
			if(parenth_depth<0) {
				REJECT;
			} else if(parenth_depth==0 && class_after_c) {
				BEGIN(CLASS_CODE_I);
				yylval.cbuf = cbuf;
				cbuf = NULL;
				return CCODE;
			}
			add_to_cbuf(yytext);
		}

<C_CODE>.	{ add_to_cbuf(yytext); }
<C_CODE>\n	{ add_to_cbuf(yytext); }

class		{
			static int found_classes = 0;
			look_for_includes = 2;
			BEGIN(CLASS_CODE);

			if(++found_classes > 1) {
				error_print(GOB_ERROR, line_no,
					    "Only one class per file allowed");
			}

			return CLASS;
		}

^[ \t]*requires[ \t]+[0-9]+\.[0-9]+\.[0-9]+[\t ]*$	{
			int maj = 0,min = 0,pl = 0;
			int rmaj = 0,rmin = 0,rpl = 0;
			char *p;
			
			sscanf(VERSION,"%d.%d.%d",&rmaj,&rmin,&rpl);
			p = strchr(yytext,'r');
			g_assert(p); /* we MUST have found it */
			sscanf(p,"requires %d.%d.%d",&maj,&min,&pl);
			if(rmaj < maj ||
			   (rmaj == maj && rmin < min) ||
			   (rmaj == maj && rmin == min && rpl < pl)) {
				error_printf(GOB_ERROR, line_no,
					     "GOB version %d.%d.%d required "
					     "(this is %s)\n"
					     "To upgrade your gob, see: "
					     "http://www.5z.com/jirka/gob.html",
					     maj, min, pl, VERSION);
			}
		}

<CLASS_CODE,CLASS_CODE_I>class|this	{
			if(for_cpp) {
				error_printf(GOB_WARN, line_no,
					     "'%s' keyword should not "
					     "be used when generating "
					     "C++ code", yytext);
			}
			REJECT;
		}

<CLASS_CODE>from	{return FROM;}

<CLASS_CODE_I>void	{return VOID;}
<CLASS_CODE_I>struct	{return STRUCT;}
<CLASS_CODE_I>union	{return UNION;}
<CLASS_CODE_I>enum	{return ENUM;}
<CLASS_CODE_I>signed	{return SIGNED;}
<CLASS_CODE_I>unsigned	{return UNSIGNED;}
<CLASS_CODE_I>long	{return LONG;}
<CLASS_CODE_I>short	{return SHORT;}
<CLASS_CODE_I>int	{return INT;}
<CLASS_CODE_I>float	{return FLOAT;}
<CLASS_CODE_I>double	{return DOUBLE;}
<CLASS_CODE_I>char	{return CHAR;}
<CLASS_CODE_I>const	{return CONST;}

<CLASS_CODE_I>\.\.\.	{return THREEDOTS;}

<CLASS_CODE_I>public	{yylval.line = line_no; return PUBLIC;}
<CLASS_CODE_I>private	{yylval.line = line_no; return PRIVATE;}
<CLASS_CODE_I>protected	{yylval.line = line_no; return PROTECTED;}
<CLASS_CODE_I>classwide	{yylval.line = line_no; return CLASSWIDE;}
<CLASS_CODE_I>argument	{yylval.line = line_no; return ARGUMENT;}
<CLASS_CODE_I>virtual	{yylval.line = line_no; return VIRTUAL;}
<CLASS_CODE_I>signal	{yylval.line = line_no; return SIGNAL;}
<CLASS_CODE_I>override	{yylval.line = line_no; return OVERRIDE;}
<CLASS_CODE,CLASS_CODE_I>0|[1-9][0-9]*|0x[0-9a-fA-F]+|0[0-7]+|[0-9]*\.[0-9]+|\.[0-9][0-9]*	{
			yylval.id = g_strdup(yytext);
			return NUMBER;
		}
<CLASS_CODE,CLASS_CODE_I>[A-Za-z_][A-Za-z0-9_]*(:[A-Za-z0-9_]*)+	{
			/* this one is for a classname with a namespace */
			yylval.id = g_strdup(yytext);
			return TYPETOKEN;
		}
<CLASS_CODE,CLASS_CODE_I>:[A-Za-z_][A-Za-z0-9_]*(:[A-Za-z0-9_]*)*	{
			/* this is for a classname with an empty namespace */
			yylval.id = g_strdup(yytext);
			return TYPETOKEN;
		}
<CLASS_CODE,CLASS_CODE_I>[A-Za-z_][A-Za-z0-9_]*	{
			yylval.id = g_strdup(yytext);
			return TOKEN;
		}

<CLASS_CODE_I>(\[[0-9]*\]|\[[A-Za-z_][A-Za-z0-9_]*\])+	{
			yylval.id = g_strdup(yytext);
			return ARRAY_DIM;
		}

<CLASS_CODE>\{	{
			BEGIN(CLASS_CODE_I);
			return '{';
		}
<CLASS_CODE_I>\{	{
			BEGIN(C_CODE);
			parenth_depth=1;
			class_after_c = TRUE;
			yylval.line = line_no;
			clear_cbuf();
			ccode_line = line_no;
			return '{';
		}
<CLASS_CODE_I>\}	{
				BEGIN(INITIAL);
				return '}';
			}

<CLASS_CODE,CLASS_CODE_I,INITIAL>[\t ]	;  /*ignore*/

<*>.		{
			yylval.line = line_no;
			return yytext[0];
		}

<*>[\n\r]	;  /*ignore*/

%%

/* Ugly warning avoiding */
#ifdef FLEX_SCANNER
static void warning_avoider(void) G_GNUC_UNUSED;
static void warning_avoider(void) {
	yy_flex_realloc(NULL, 0);
	yyunput(0, NULL);
	warning_avoider();
}
#endif

