/* Generated by generate_treefuncs.pl from treefuncs.def!
 * Do not edit by hand! */

#include <glib.h>
#include "treefuncs.h"

#define COPY_LIST_VALS(list,func) { GList *li; for(li=(list);li;li=li->next) { li->data=func(li->data); } }

Node * new_argument (char * gtktype, Type * atype, GList * flags, char * name, char * get, int get_line, char * set, int set_line, int line_no)
{
	Argument * self = g_new0(Argument, 1);
	self->type = ARGUMENT_NODE;
	self->gtktype = gtktype;
	self->atype = atype;
	self->flags = flags;
	self->name = name;
	self->get = get;
	self->get_line = get_line;
	self->set = set;
	self->set_line = set_line;
	self->line_no = line_no;
	return (Node *)self;
}

Node * new_ccode (int cctype, char * cbuf, int line_no)
{
	CCode * self = g_new0(CCode, 1);
	self->type = CCODE_NODE;
	self->cctype = cctype;
	self->cbuf = cbuf;
	self->line_no = line_no;
	return (Node *)self;
}

Node * new_check (int chtype, char * number)
{
	Check * self = g_new0(Check, 1);
	self->type = CHECK_NODE;
	self->chtype = chtype;
	self->number = number;
	return (Node *)self;
}

Node * new_class (char * otype, char * ptype, char * chunk_size, GList * nodes)
{
	Class * self = g_new0(Class, 1);
	self->type = CLASS_NODE;
	self->otype = otype;
	self->ptype = ptype;
	self->chunk_size = chunk_size;
	self->nodes = nodes;
	return (Node *)self;
}

Node * new_funcarg (Type * atype, char * name, GList * checks)
{
	FuncArg * self = g_new0(FuncArg, 1);
	self->type = FUNCARG_NODE;
	self->atype = atype;
	self->name = name;
	self->checks = checks;
	return (Node *)self;
}

Node * new_method (int scope, int method, Type * mtype, char * otype, GList * gtktypes, GList * flags, char * id, GList * args, char * onerror, char * defreturn, char * cbuf, int line_no, int ccode_line, gboolean vararg, int unique_id)
{
	Method * self = g_new0(Method, 1);
	self->type = METHOD_NODE;
	self->scope = scope;
	self->method = method;
	self->mtype = mtype;
	self->otype = otype;
	self->gtktypes = gtktypes;
	self->flags = flags;
	self->id = id;
	self->args = args;
	self->onerror = onerror;
	self->defreturn = defreturn;
	self->cbuf = cbuf;
	self->line_no = line_no;
	self->ccode_line = ccode_line;
	self->vararg = vararg;
	self->unique_id = unique_id;
	return (Node *)self;
}

Node * new_type (char * name, char * pointer, char * postfix)
{
	Type * self = g_new0(Type, 1);
	self->type = TYPE_NODE;
	self->name = name;
	self->pointer = pointer;
	self->postfix = postfix;
	return (Node *)self;
}

Node * new_variable (int scope, Type * vtype, char * id, int line_no, char * destructor, int destructor_line, gboolean destructor_simple, char * initializer, int initializer_line)
{
	Variable * self = g_new0(Variable, 1);
	self->type = VARIABLE_NODE;
	self->scope = scope;
	self->vtype = vtype;
	self->id = id;
	self->line_no = line_no;
	self->destructor = destructor;
	self->destructor_line = destructor_line;
	self->destructor_simple = destructor_simple;
	self->initializer = initializer;
	self->initializer_line = initializer_line;
	return (Node *)self;
}

Argument * copy_argument (Argument * self)
{
	Argument * new;
	g_return_val_if_fail(self != NULL, NULL);
	g_return_val_if_fail(self->type == ARGUMENT_NODE, NULL);
	new = g_new0(Argument, 1);
	new->type = ARGUMENT_NODE;
	new->gtktype = g_strdup(self->gtktype);
	new->atype = copy_type(self->atype);
	new->flags = g_list_copy(self->flags); COPY_LIST_VALS(new->flags, g_strdup);
	new->name = g_strdup(self->name);
	new->get = g_strdup(self->get);
	new->get_line = self->get_line;
	new->set = g_strdup(self->set);
	new->set_line = self->set_line;
	new->line_no = self->line_no;
	return new;
}

CCode * copy_ccode (CCode * self)
{
	CCode * new;
	g_return_val_if_fail(self != NULL, NULL);
	g_return_val_if_fail(self->type == CCODE_NODE, NULL);
	new = g_new0(CCode, 1);
	new->type = CCODE_NODE;
	new->cctype = self->cctype;
	new->cbuf = g_strdup(self->cbuf);
	new->line_no = self->line_no;
	return new;
}

Check * copy_check (Check * self)
{
	Check * new;
	g_return_val_if_fail(self != NULL, NULL);
	g_return_val_if_fail(self->type == CHECK_NODE, NULL);
	new = g_new0(Check, 1);
	new->type = CHECK_NODE;
	new->chtype = self->chtype;
	new->number = g_strdup(self->number);
	return new;
}

Class * copy_class (Class * self)
{
	Class * new;
	g_return_val_if_fail(self != NULL, NULL);
	g_return_val_if_fail(self->type == CLASS_NODE, NULL);
	new = g_new0(Class, 1);
	new->type = CLASS_NODE;
	new->otype = g_strdup(self->otype);
	new->ptype = g_strdup(self->ptype);
	new->chunk_size = g_strdup(self->chunk_size);
	new->nodes = copy_node_list(self->nodes);
	return new;
}

FuncArg * copy_funcarg (FuncArg * self)
{
	FuncArg * new;
	g_return_val_if_fail(self != NULL, NULL);
	g_return_val_if_fail(self->type == FUNCARG_NODE, NULL);
	new = g_new0(FuncArg, 1);
	new->type = FUNCARG_NODE;
	new->atype = copy_type(self->atype);
	new->name = g_strdup(self->name);
	new->checks = copy_node_list(self->checks);
	return new;
}

Method * copy_method (Method * self)
{
	Method * new;
	g_return_val_if_fail(self != NULL, NULL);
	g_return_val_if_fail(self->type == METHOD_NODE, NULL);
	new = g_new0(Method, 1);
	new->type = METHOD_NODE;
	new->scope = self->scope;
	new->method = self->method;
	new->mtype = copy_type(self->mtype);
	new->otype = g_strdup(self->otype);
	new->gtktypes = g_list_copy(self->gtktypes); COPY_LIST_VALS(new->gtktypes, g_strdup);
	new->flags = g_list_copy(self->flags); COPY_LIST_VALS(new->flags, g_strdup);
	new->id = g_strdup(self->id);
	new->args = copy_node_list(self->args);
	new->onerror = g_strdup(self->onerror);
	new->defreturn = g_strdup(self->defreturn);
	new->cbuf = g_strdup(self->cbuf);
	new->line_no = self->line_no;
	new->ccode_line = self->ccode_line;
	new->vararg = self->vararg;
	new->unique_id = self->unique_id;
	return new;
}

Type * copy_type (Type * self)
{
	Type * new;
	g_return_val_if_fail(self != NULL, NULL);
	g_return_val_if_fail(self->type == TYPE_NODE, NULL);
	new = g_new0(Type, 1);
	new->type = TYPE_NODE;
	new->name = g_strdup(self->name);
	new->pointer = g_strdup(self->pointer);
	new->postfix = g_strdup(self->postfix);
	return new;
}

Variable * copy_variable (Variable * self)
{
	Variable * new;
	g_return_val_if_fail(self != NULL, NULL);
	g_return_val_if_fail(self->type == VARIABLE_NODE, NULL);
	new = g_new0(Variable, 1);
	new->type = VARIABLE_NODE;
	new->scope = self->scope;
	new->vtype = copy_type(self->vtype);
	new->id = g_strdup(self->id);
	new->line_no = self->line_no;
	new->destructor = g_strdup(self->destructor);
	new->destructor_line = self->destructor_line;
	new->destructor_simple = self->destructor_simple;
	new->initializer = g_strdup(self->initializer);
	new->initializer_line = self->initializer_line;
	return new;
}

void free_argument (Argument * self)
{
	g_return_if_fail(self != NULL);
	g_return_if_fail(self->type == ARGUMENT_NODE);
	g_free(self->gtktype);
	free_type(self->atype);
	g_list_foreach(self->flags, (GFunc)g_free, NULL); g_list_free(self->flags);
	g_free(self->name);
	g_free(self->get);
	g_free(self->set);
	g_free(self);
}

void free_ccode (CCode * self)
{
	g_return_if_fail(self != NULL);
	g_return_if_fail(self->type == CCODE_NODE);
	g_free(self->cbuf);
	g_free(self);
}

void free_check (Check * self)
{
	g_return_if_fail(self != NULL);
	g_return_if_fail(self->type == CHECK_NODE);
	g_free(self->number);
	g_free(self);
}

void free_class (Class * self)
{
	g_return_if_fail(self != NULL);
	g_return_if_fail(self->type == CLASS_NODE);
	g_free(self->otype);
	g_free(self->ptype);
	g_free(self->chunk_size);
	free_node_list(self->nodes);
	g_free(self);
}

void free_funcarg (FuncArg * self)
{
	g_return_if_fail(self != NULL);
	g_return_if_fail(self->type == FUNCARG_NODE);
	free_type(self->atype);
	g_free(self->name);
	free_node_list(self->checks);
	g_free(self);
}

void free_method (Method * self)
{
	g_return_if_fail(self != NULL);
	g_return_if_fail(self->type == METHOD_NODE);
	free_type(self->mtype);
	g_free(self->otype);
	g_list_foreach(self->gtktypes, (GFunc)g_free, NULL); g_list_free(self->gtktypes);
	g_list_foreach(self->flags, (GFunc)g_free, NULL); g_list_free(self->flags);
	g_free(self->id);
	free_node_list(self->args);
	g_free(self->onerror);
	g_free(self->defreturn);
	g_free(self->cbuf);
	g_free(self);
}

void free_type (Type * self)
{
	g_return_if_fail(self != NULL);
	g_return_if_fail(self->type == TYPE_NODE);
	g_free(self->name);
	g_free(self->pointer);
	g_free(self->postfix);
	g_free(self);
}

void free_variable (Variable * self)
{
	g_return_if_fail(self != NULL);
	g_return_if_fail(self->type == VARIABLE_NODE);
	free_type(self->vtype);
	g_free(self->id);
	g_free(self->destructor);
	g_free(self->initializer);
	g_free(self);
}

Node * copy_node(Node *node)
{
	g_return_val_if_fail(node != NULL, NULL);
	g_return_val_if_fail(node->type >= 0 && node->type < LAST_NODE_TYPE, NULL);
	switch(node->type) {
	case ARGUMENT_NODE: return (Node *)copy_argument ((Argument *)node);
	case CCODE_NODE: return (Node *)copy_ccode ((CCode *)node);
	case CHECK_NODE: return (Node *)copy_check ((Check *)node);
	case CLASS_NODE: return (Node *)copy_class ((Class *)node);
	case FUNCARG_NODE: return (Node *)copy_funcarg ((FuncArg *)node);
	case METHOD_NODE: return (Node *)copy_method ((Method *)node);
	case TYPE_NODE: return (Node *)copy_type ((Type *)node);
	case VARIABLE_NODE: return (Node *)copy_variable ((Variable *)node);
	default: return NULL;
	}
}

void free_node(Node *node)
{
	g_return_if_fail(node != NULL);
	g_return_if_fail(node->type >= 0 && node->type < LAST_NODE_TYPE);
	switch(node->type) {
	case ARGUMENT_NODE: free_argument ((Argument *)node); return;
	case CCODE_NODE: free_ccode ((CCode *)node); return;
	case CHECK_NODE: free_check ((Check *)node); return;
	case CLASS_NODE: free_class ((Class *)node); return;
	case FUNCARG_NODE: free_funcarg ((FuncArg *)node); return;
	case METHOD_NODE: free_method ((Method *)node); return;
	case TYPE_NODE: free_type ((Type *)node); return;
	case VARIABLE_NODE: free_variable ((Variable *)node); return;
	default: return;
	}
}

GList * copy_node_list(GList *nodes)
{
	GList *li;
	nodes = g_list_copy(nodes);
	for(li = nodes; li != NULL; li = li->next) {
		li->data = copy_node(li->data);
	}
	return nodes;
}

void free_node_list(GList *nodes)
{
	GList *li;
	for(li = nodes; li != NULL; li = li->next) {
		free_node(li->data);
	}
	g_list_free(nodes);
}

