/* vim: set sw=8: -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * gog-pie-prefs.c
 *
 * Copyright (C) 2003-2004 Jody Goldberg (jody@gnome.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <goffice/goffice-config.h>
#include "gog-pie.h"

#include <goffice/gtk/goffice-gtk.h>
#include <goffice/app/go-plugin.h>

GtkWidget *gog_pie_series_element_pref   (GogPieSeriesElement *element, GOCmdContext *cc);

static void
cb_element_separation_changed (GtkAdjustment *adj, GObject *element)
{
	g_object_set (element, "separation", adj->value / 100., NULL);
}

GtkWidget *
gog_pie_series_element_pref (GogPieSeriesElement *element, GOCmdContext *cc)
{
	GtkWidget  *w;
	char const *dir = go_plugin_get_dir_name (
		go_plugins_get_plugin_by_id ("GOffice_plot_pie"));
	char	 *path = g_build_filename (dir, "gog-pie-series.glade", NULL);
	GladeXML *gui = go_glade_new (path, "gog_pie_series_element_prefs", GETTEXT_PACKAGE, cc);

	g_free (path);
        if (gui == NULL)
                return NULL;
	
	w = glade_xml_get_widget (gui, "separation_spinner");
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (w), element->separation * 100.);
	g_signal_connect (G_OBJECT (gtk_spin_button_get_adjustment (GTK_SPIN_BUTTON (w))),
		"value_changed",
		G_CALLBACK (cb_element_separation_changed), element);

	w = glade_xml_get_widget (gui, "gog_pie_series_element_prefs");
	g_object_set_data_full (G_OBJECT (w),
		"state", gui, (GDestroyNotify)g_object_unref);

	return w;
}

/****************************************************************************/
GtkWidget *gog_pie_plot_pref   (GogPiePlot *plot, GOCmdContext *cc);

typedef struct {
	GtkWidget	*separation_spinner;
	GogObject	*gobj;
	GladeXML	*gui;
	gulong		 update_editor_handler;
} PiePrefState;

static void
pie_pref_state_free (PiePrefState *state)
{
	g_signal_handler_disconnect (state->gobj, state->update_editor_handler);
	g_object_unref (state->gobj);
	g_object_unref (state->gui);
	g_free (state);
}

static void
cb_default_separation_changed (GtkAdjustment *adj, GObject *pie)
{
	g_object_set (pie, "default-separation", adj->value / 100., NULL);
}

static void
cb_rotation_changed (GtkAdjustment *adj, GObject *pie)
{
	g_object_set (pie, "initial-angle", adj->value, NULL);
}


static void
cb_use_style_toggled (GtkToggleButton *button, GObject *series)
{
	g_object_set (series, "vary-style-by-element",
		gtk_toggle_button_get_active (button), NULL);
}

static void
gog_pie_plot_pref_signal_connect (GogPiePlot *pie, GladeXML *gui)
{
	GtkWidget *w;
	
	w = glade_xml_get_widget (gui, "rotation_spinner");
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (w), pie->initial_angle);
	g_signal_connect (G_OBJECT (gtk_spin_button_get_adjustment (GTK_SPIN_BUTTON (w))),
		"value_changed",
		G_CALLBACK (cb_rotation_changed), pie);

	w = glade_xml_get_widget (gui, "separation_spinner");
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (w), pie->default_separation * 100.);
	g_signal_connect (G_OBJECT (gtk_spin_button_get_adjustment (GTK_SPIN_BUTTON (w))),
		"value_changed",
		G_CALLBACK (cb_default_separation_changed), pie);

	w = glade_xml_get_widget (gui, "vary_style_by_element");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (w), pie->base.vary_style_by_element);
	g_signal_connect (G_OBJECT (w),
		"toggled",
		G_CALLBACK (cb_use_style_toggled), pie);
}

static void
cb_update_editor (GogPiePlot *pie, PiePrefState *state)
{
	gfloat value;
	
	if (state->separation_spinner != NULL) {
		g_object_get (G_OBJECT (pie), "default-separation", &value, NULL);
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (state->separation_spinner), value * 100.0);
	}
}

/****************************************************************************/

GtkWidget *
gog_pie_plot_pref (GogPiePlot *pie, GOCmdContext *cc)
{
	GtkWidget  *w;
	char const *dir = go_plugin_get_dir_name (go_plugins_get_plugin_by_id ("GOffice_plot_pie"));
	char	 *path = g_build_filename (dir, "gog-pie-prefs.glade", NULL);
	GladeXML *gui = go_glade_new (path, "gog_pie_prefs", GETTEXT_PACKAGE, cc);
	PiePrefState *state;

	g_free (path);
        if (gui == NULL)
                return NULL;

	state = g_new0 (PiePrefState, 1);
	state->gui = gui;
	state->gobj = GOG_OBJECT (pie);
	state->separation_spinner = glade_xml_get_widget (gui, "separation_spinner");
	g_object_ref (G_OBJECT (pie));

	gog_pie_plot_pref_signal_connect (pie, gui);

	state->update_editor_handler = g_signal_connect (G_OBJECT (pie), 
							 "update-editor", 
							 G_CALLBACK (cb_update_editor), state);
	
	w = glade_xml_get_widget (gui, "gog_pie_prefs");
	g_object_set_data_full (G_OBJECT (w),
		"state", state, (GDestroyNotify) pie_pref_state_free);
	
	return w;
}

/****************************************************************************/

GtkWidget *gog_ring_plot_pref   (GogRingPlot *ring, GOCmdContext *cc);

static void
cb_center_size_changed (GtkAdjustment *adj, GObject *ring)
{
	g_object_set (ring, "center-size", adj->value/100., NULL);
}


GtkWidget *
gog_ring_plot_pref (GogRingPlot *ring, GOCmdContext *cc)
{
	GtkWidget  *w;
	char const *dir = go_plugin_get_dir_name (
		go_plugins_get_plugin_by_id ("GOffice_plot_pie"));
	char	 *path = g_build_filename (dir, "gog-ring-prefs.glade", NULL);
	GladeXML *gui = go_glade_new (path, "gog_ring_prefs", GETTEXT_PACKAGE, cc);
	PiePrefState *state;

	g_free (path);
        if (gui == NULL)
                return NULL;
	
	state = g_new0 (PiePrefState, 1);
	state->gui = gui;
	state->gobj = GOG_OBJECT (ring);
	state->separation_spinner = glade_xml_get_widget (gui, "separation_spinner");
	g_object_ref (G_OBJECT (ring));

	gog_pie_plot_pref_signal_connect (GOG_PIE_PLOT (ring), gui);

	w = glade_xml_get_widget (gui, "center_size_spinner");
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (w), ring->center_size * 100);
	g_signal_connect (G_OBJECT (gtk_spin_button_get_adjustment (GTK_SPIN_BUTTON (w))),
		"value_changed",
		G_CALLBACK (cb_center_size_changed), ring);

	state->update_editor_handler = g_signal_connect (G_OBJECT (ring), 
							 "update-editor", 
							 G_CALLBACK (cb_update_editor), state);
	
	w = glade_xml_get_widget (gui, "gog_ring_prefs");
	g_object_set_data_full (G_OBJECT (w),
		"state", state, (GDestroyNotify) pie_pref_state_free);

	return w;
}
