
/* autogenerated from gstaudiopack.orc */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <glib.h>

#ifndef _ORC_INTEGER_TYPEDEFS_
#define _ORC_INTEGER_TYPEDEFS_
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#include <stdint.h>
typedef int8_t orc_int8;
typedef int16_t orc_int16;
typedef int32_t orc_int32;
typedef int64_t orc_int64;
typedef uint8_t orc_uint8;
typedef uint16_t orc_uint16;
typedef uint32_t orc_uint32;
typedef uint64_t orc_uint64;
#define ORC_UINT64_C(x) UINT64_C(x)
#elif defined(_MSC_VER)
typedef signed __int8 orc_int8;
typedef signed __int16 orc_int16;
typedef signed __int32 orc_int32;
typedef signed __int64 orc_int64;
typedef unsigned __int8 orc_uint8;
typedef unsigned __int16 orc_uint16;
typedef unsigned __int32 orc_uint32;
typedef unsigned __int64 orc_uint64;
#define ORC_UINT64_C(x) (x##Ui64)
#define inline __inline
#else
#include <limits.h>
typedef signed char orc_int8;
typedef short orc_int16;
typedef int orc_int32;
typedef unsigned char orc_uint8;
typedef unsigned short orc_uint16;
typedef unsigned int orc_uint32;
#if INT_MAX == LONG_MAX
typedef long long orc_int64;
typedef unsigned long long orc_uint64;
#define ORC_UINT64_C(x) (x##ULL)
#else
typedef long orc_int64;
typedef unsigned long orc_uint64;
#define ORC_UINT64_C(x) (x##UL)
#endif
#endif
typedef union
{
  orc_int16 i;
  orc_int8 x2[2];
} orc_union16;
typedef union
{
  orc_int32 i;
  float f;
  orc_int16 x2[2];
  orc_int8 x4[4];
} orc_union32;
typedef union
{
  orc_int64 i;
  double f;
  orc_int32 x2[2];
  float x2f[2];
  orc_int16 x4[4];
} orc_union64;
#endif
#ifndef ORC_RESTRICT
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#define ORC_RESTRICT restrict
#elif defined(__GNUC__) && __GNUC__ >= 4
#define ORC_RESTRICT __restrict__
#else
#define ORC_RESTRICT
#endif
#endif

#ifndef ORC_INTERNAL
#if defined(__SUNPRO_C) && (__SUNPRO_C >= 0x590)
#define ORC_INTERNAL __attribute__((visibility("hidden")))
#elif defined(__SUNPRO_C) && (__SUNPRO_C >= 0x550)
#define ORC_INTERNAL __hidden
#elif defined (__GNUC__)
#define ORC_INTERNAL __attribute__((visibility("hidden")))
#else
#define ORC_INTERNAL
#endif
#endif


#ifndef DISABLE_ORC
#include <orc/orc.h>
#endif
void audio_orc_unpack_u8 (gint32 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_s8 (gint32 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_u16 (gint32 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_s16 (gint32 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_u16_swap (gint32 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_s16_swap (gint32 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_u24_32 (gint32 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_s24_32 (gint32 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_u24_32_swap (gint32 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_s24_32_swap (gint32 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_u32 (gint32 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_u32_swap (gint32 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_s32 (gint32 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_s32_swap (gint32 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void audio_orc_unpack_f32 (gdouble * ORC_RESTRICT d1,
    const gfloat * ORC_RESTRICT s1, int n);
void audio_orc_unpack_f32_swap (gdouble * ORC_RESTRICT d1,
    const gfloat * ORC_RESTRICT s1, int n);
void audio_orc_unpack_f64 (gdouble * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n);
void audio_orc_unpack_f64_swap (gdouble * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n);
void audio_orc_pack_u8 (guint8 * ORC_RESTRICT d1,
    const gint32 * ORC_RESTRICT s1, int n);
void audio_orc_pack_s8 (guint8 * ORC_RESTRICT d1,
    const gint32 * ORC_RESTRICT s1, int n);
void audio_orc_pack_u16 (guint8 * ORC_RESTRICT d1,
    const gint32 * ORC_RESTRICT s1, int n);
void audio_orc_pack_s16 (guint8 * ORC_RESTRICT d1,
    const gint32 * ORC_RESTRICT s1, int n);
void audio_orc_pack_u16_swap (guint8 * ORC_RESTRICT d1,
    const gint32 * ORC_RESTRICT s1, int n);
void audio_orc_pack_s16_swap (guint8 * ORC_RESTRICT d1,
    const gint32 * ORC_RESTRICT s1, int n);
void audio_orc_pack_u24_32 (guint8 * ORC_RESTRICT d1,
    const gint32 * ORC_RESTRICT s1, int n);
void audio_orc_pack_s24_32 (guint8 * ORC_RESTRICT d1,
    const gint32 * ORC_RESTRICT s1, int n);
void audio_orc_pack_u24_32_swap (guint8 * ORC_RESTRICT d1,
    const gint32 * ORC_RESTRICT s1, int n);
void audio_orc_pack_s24_32_swap (guint8 * ORC_RESTRICT d1,
    const gint32 * ORC_RESTRICT s1, int n);
void audio_orc_pack_u32 (guint8 * ORC_RESTRICT d1,
    const gint32 * ORC_RESTRICT s1, int n);
void audio_orc_pack_s32 (guint8 * ORC_RESTRICT d1,
    const gint32 * ORC_RESTRICT s1, int n);
void audio_orc_pack_u32_swap (guint8 * ORC_RESTRICT d1,
    const gint32 * ORC_RESTRICT s1, int n);
void audio_orc_pack_s32_swap (guint8 * ORC_RESTRICT d1,
    const gint32 * ORC_RESTRICT s1, int n);
void audio_orc_pack_f32 (gfloat * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n);
void audio_orc_pack_f32_swap (gfloat * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n);
void audio_orc_pack_f64 (gdouble * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n);
void audio_orc_pack_f64_swap (gdouble * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n);


/* begin Orc C target preamble */
#define ORC_CLAMP(x,a,b) ((x)<(a) ? (a) : ((x)>(b) ? (b) : (x)))
#define ORC_ABS(a) ((a)<0 ? -(a) : (a))
#define ORC_MIN(a,b) ((a)<(b) ? (a) : (b))
#define ORC_MAX(a,b) ((a)>(b) ? (a) : (b))
#define ORC_SB_MAX 127
#define ORC_SB_MIN (-1-ORC_SB_MAX)
#define ORC_UB_MAX 255
#define ORC_UB_MIN 0
#define ORC_SW_MAX 32767
#define ORC_SW_MIN (-1-ORC_SW_MAX)
#define ORC_UW_MAX 65535
#define ORC_UW_MIN 0
#define ORC_SL_MAX 2147483647
#define ORC_SL_MIN (-1-ORC_SL_MAX)
#define ORC_UL_MAX 4294967295U
#define ORC_UL_MIN 0
#define ORC_CLAMP_SB(x) ORC_CLAMP(x,ORC_SB_MIN,ORC_SB_MAX)
#define ORC_CLAMP_UB(x) ORC_CLAMP(x,ORC_UB_MIN,ORC_UB_MAX)
#define ORC_CLAMP_SW(x) ORC_CLAMP(x,ORC_SW_MIN,ORC_SW_MAX)
#define ORC_CLAMP_UW(x) ORC_CLAMP(x,ORC_UW_MIN,ORC_UW_MAX)
#define ORC_CLAMP_SL(x) ORC_CLAMP(x,ORC_SL_MIN,ORC_SL_MAX)
#define ORC_CLAMP_UL(x) ORC_CLAMP(x,ORC_UL_MIN,ORC_UL_MAX)
#define ORC_SWAP_W(x) ((((x)&0xff)<<8) | (((x)&0xff00)>>8))
#define ORC_SWAP_L(x) ((((x)&0xff)<<24) | (((x)&0xff00)<<8) | (((x)&0xff0000)>>8) | (((x)&0xff000000)>>24))
#define ORC_SWAP_Q(x) ((((x)&ORC_UINT64_C(0xff))<<56) | (((x)&ORC_UINT64_C(0xff00))<<40) | (((x)&ORC_UINT64_C(0xff0000))<<24) | (((x)&ORC_UINT64_C(0xff000000))<<8) | (((x)&ORC_UINT64_C(0xff00000000))>>8) | (((x)&ORC_UINT64_C(0xff0000000000))>>24) | (((x)&ORC_UINT64_C(0xff000000000000))>>40) | (((x)&ORC_UINT64_C(0xff00000000000000))>>56))
#define ORC_PTR_OFFSET(ptr,offset) ((void *)(((unsigned char *)(ptr)) + (offset)))
#define ORC_DENORMAL(x) ((x) & ((((x)&0x7f800000) == 0) ? 0xff800000 : 0xffffffff))
#define ORC_ISNAN(x) ((((x)&0x7f800000) == 0x7f800000) && (((x)&0x007fffff) != 0))
#define ORC_DENORMAL_DOUBLE(x) ((x) & ((((x)&ORC_UINT64_C(0x7ff0000000000000)) == 0) ? ORC_UINT64_C(0xfff0000000000000) : ORC_UINT64_C(0xffffffffffffffff)))
#define ORC_ISNAN_DOUBLE(x) ((((x)&ORC_UINT64_C(0x7ff0000000000000)) == ORC_UINT64_C(0x7ff0000000000000)) && (((x)&ORC_UINT64_C(0x000fffffffffffff)) != 0))
#ifndef ORC_RESTRICT
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#define ORC_RESTRICT restrict
#elif defined(__GNUC__) && __GNUC__ >= 4
#define ORC_RESTRICT __restrict__
#else
#define ORC_RESTRICT
#endif
#endif
/* end Orc C target preamble */



/* audio_orc_unpack_u8 */
#ifdef DISABLE_ORC
void
audio_orc_unpack_u8 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  orc_int8 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union16 var37;
  orc_union32 var38;
  orc_union32 var39;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_int8 *) s1;

  /* 4: loadpl */
  var35.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr4[i];
    /* 1: convubw */
    var37.i = (orc_uint8) var34;
    /* 2: convuwl */
    var38.i = (orc_uint16) var37.i;
    /* 3: shll */
    var39.i = var38.i << 24;
    /* 5: xorl */
    var36.i = var39.i ^ var35.i;
    /* 6: storel */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_audio_orc_unpack_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  orc_int8 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union16 var37;
  orc_union32 var38;
  orc_union32 var39;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_int8 *) ex->arrays[4];

  /* 4: loadpl */
  var35.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr4[i];
    /* 1: convubw */
    var37.i = (orc_uint8) var34;
    /* 2: convuwl */
    var38.i = (orc_uint16) var37.i;
    /* 3: shll */
    var39.i = var38.i << 24;
    /* 5: xorl */
    var36.i = var39.i ^ var35.i;
    /* 6: storel */
    ptr0[i] = var36;
  }

}

void
audio_orc_unpack_u8 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_unpack_u8");
      orc_program_set_backup_function (p, _backup_audio_orc_unpack_u8);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_constant (p, 4, 0x80000000, "c1");
      orc_program_add_constant (p, 4, 0x00000018, "c2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convuwl", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shll", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "xorl", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_C1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_s8 */
#ifdef DISABLE_ORC
void
audio_orc_unpack_s8 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  orc_int8 var34;
  orc_union32 var35;
  orc_union16 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_int8 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr4[i];
    /* 1: convubw */
    var36.i = (orc_uint8) var34;
    /* 2: convuwl */
    var37.i = (orc_uint16) var36.i;
    /* 3: shll */
    var35.i = var37.i << 24;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_audio_orc_unpack_s8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  orc_int8 var34;
  orc_union32 var35;
  orc_union16 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_int8 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr4[i];
    /* 1: convubw */
    var36.i = (orc_uint8) var34;
    /* 2: convuwl */
    var37.i = (orc_uint16) var36.i;
    /* 3: shll */
    var35.i = var37.i << 24;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

void
audio_orc_unpack_s8 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_unpack_s8");
      orc_program_set_backup_function (p, _backup_audio_orc_unpack_s8);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_constant (p, 4, 0x00000018, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convuwl", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shll", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_C1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_u16 */
#ifdef DISABLE_ORC
void
audio_orc_unpack_u16 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  orc_union16 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union16 *) s1;

  /* 3: loadpl */
  var34.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 1: convuwl */
    var36.i = (orc_uint16) var33.i;
    /* 2: shll */
    var37.i = var36.i << 16;
    /* 4: xorl */
    var35.i = var37.i ^ var34.i;
    /* 5: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_audio_orc_unpack_u16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  orc_union16 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union16 *) ex->arrays[4];

  /* 3: loadpl */
  var34.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 1: convuwl */
    var36.i = (orc_uint16) var33.i;
    /* 2: shll */
    var37.i = var36.i << 16;
    /* 4: xorl */
    var35.i = var37.i ^ var34.i;
    /* 5: storel */
    ptr0[i] = var35;
  }

}

void
audio_orc_unpack_u16 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_unpack_u16");
      orc_program_set_backup_function (p, _backup_audio_orc_unpack_u16);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 4, 0x00000010, "c1");
      orc_program_add_constant (p, 4, 0x80000000, "c2");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "convuwl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shll", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "xorl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C2,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_s16 */
#ifdef DISABLE_ORC
void
audio_orc_unpack_s16 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  orc_union16 var33;
  orc_union32 var34;
  orc_union32 var35;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union16 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 1: convuwl */
    var35.i = (orc_uint16) var33.i;
    /* 2: shll */
    var34.i = var35.i << 16;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_audio_orc_unpack_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  orc_union16 var33;
  orc_union32 var34;
  orc_union32 var35;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union16 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 1: convuwl */
    var35.i = (orc_uint16) var33.i;
    /* 2: shll */
    var34.i = var35.i << 16;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
audio_orc_unpack_s16 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_unpack_s16");
      orc_program_set_backup_function (p, _backup_audio_orc_unpack_s16);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 4, 0x00000010, "c1");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "convuwl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shll", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_u16_swap */
#ifdef DISABLE_ORC
void
audio_orc_unpack_u16_swap (gint32 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union16 var37;
  orc_union32 var38;
  orc_union32 var39;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union16 *) s1;

  /* 4: loadpl */
  var35.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 1: swapw */
    var37.i = ORC_SWAP_W (var34.i);
    /* 2: convuwl */
    var38.i = (orc_uint16) var37.i;
    /* 3: shll */
    var39.i = var38.i << 16;
    /* 5: xorl */
    var36.i = var39.i ^ var35.i;
    /* 6: storel */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_audio_orc_unpack_u16_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union16 var37;
  orc_union32 var38;
  orc_union32 var39;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union16 *) ex->arrays[4];

  /* 4: loadpl */
  var35.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 1: swapw */
    var37.i = ORC_SWAP_W (var34.i);
    /* 2: convuwl */
    var38.i = (orc_uint16) var37.i;
    /* 3: shll */
    var39.i = var38.i << 16;
    /* 5: xorl */
    var36.i = var39.i ^ var35.i;
    /* 6: storel */
    ptr0[i] = var36;
  }

}

void
audio_orc_unpack_u16_swap (gint32 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_unpack_u16_swap");
      orc_program_set_backup_function (p, _backup_audio_orc_unpack_u16_swap);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 4, 0x00000010, "c1");
      orc_program_add_constant (p, 4, 0x80000000, "c2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "swapw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convuwl", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shll", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "xorl", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_C2,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_s16_swap */
#ifdef DISABLE_ORC
void
audio_orc_unpack_s16_swap (gint32 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_union32 var35;
  orc_union16 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union16 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 1: swapw */
    var36.i = ORC_SWAP_W (var34.i);
    /* 2: convuwl */
    var37.i = (orc_uint16) var36.i;
    /* 3: shll */
    var35.i = var37.i << 16;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_audio_orc_unpack_s16_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_union32 var35;
  orc_union16 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union16 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 1: swapw */
    var36.i = ORC_SWAP_W (var34.i);
    /* 2: convuwl */
    var37.i = (orc_uint16) var36.i;
    /* 3: shll */
    var35.i = var37.i << 16;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

void
audio_orc_unpack_s16_swap (gint32 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_unpack_s16_swap");
      orc_program_set_backup_function (p, _backup_audio_orc_unpack_s16_swap);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 4, 0x00000010, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "swapw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convuwl", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shll", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_C1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_u24_32 */
#ifdef DISABLE_ORC
void
audio_orc_unpack_u24_32 (gint32 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;

  /* 2: loadpl */
  var34.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: shll */
    var36.i = var33.i << 8;
    /* 3: xorl */
    var35.i = var36.i ^ var34.i;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_audio_orc_unpack_u24_32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];

  /* 2: loadpl */
  var34.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: shll */
    var36.i = var33.i << 8;
    /* 3: xorl */
    var35.i = var36.i ^ var34.i;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

void
audio_orc_unpack_u24_32 (gint32 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_unpack_u24_32");
      orc_program_set_backup_function (p, _backup_audio_orc_unpack_u24_32);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00000008, "c1");
      orc_program_add_constant (p, 4, 0x80000000, "c2");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "shll", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "xorl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C2,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_s24_32 */
#ifdef DISABLE_ORC
void
audio_orc_unpack_s24_32 (gint32 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: shll */
    var33.i = var32.i << 8;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_audio_orc_unpack_s24_32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: shll */
    var33.i = var32.i << 8;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
audio_orc_unpack_s24_32 (gint32 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_unpack_s24_32");
      orc_program_set_backup_function (p, _backup_audio_orc_unpack_s24_32);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00000008, "c1");

      orc_program_append_2 (p, "shll", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_C1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_u24_32_swap */
#ifdef DISABLE_ORC
void
audio_orc_unpack_u24_32_swap (gint32 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;

  /* 3: loadpl */
  var34.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: swapl */
    var36.i = ORC_SWAP_L (var33.i);
    /* 2: shll */
    var37.i = var36.i << 8;
    /* 4: xorl */
    var35.i = var37.i ^ var34.i;
    /* 5: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_audio_orc_unpack_u24_32_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];

  /* 3: loadpl */
  var34.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: swapl */
    var36.i = ORC_SWAP_L (var33.i);
    /* 2: shll */
    var37.i = var36.i << 8;
    /* 4: xorl */
    var35.i = var37.i ^ var34.i;
    /* 5: storel */
    ptr0[i] = var35;
  }

}

void
audio_orc_unpack_u24_32_swap (gint32 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_unpack_u24_32_swap");
      orc_program_set_backup_function (p, _backup_audio_orc_unpack_u24_32_swap);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00000008, "c1");
      orc_program_add_constant (p, 4, 0x80000000, "c2");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "swapl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shll", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "xorl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C2,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_s24_32_swap */
#ifdef DISABLE_ORC
void
audio_orc_unpack_s24_32_swap (gint32 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: swapl */
    var35.i = ORC_SWAP_L (var33.i);
    /* 2: shll */
    var34.i = var35.i << 8;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_audio_orc_unpack_s24_32_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: swapl */
    var35.i = ORC_SWAP_L (var33.i);
    /* 2: shll */
    var34.i = var35.i << 8;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
audio_orc_unpack_s24_32_swap (gint32 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_unpack_s24_32_swap");
      orc_program_set_backup_function (p, _backup_audio_orc_unpack_s24_32_swap);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00000008, "c1");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "swapl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shll", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_u32 */
#ifdef DISABLE_ORC
void
audio_orc_unpack_u32 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;

  /* 1: loadpl */
  var33.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 2: xorl */
    var34.i = var32.i ^ var33.i;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_audio_orc_unpack_u32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];

  /* 1: loadpl */
  var33.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 2: xorl */
    var34.i = var32.i ^ var33.i;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
audio_orc_unpack_u32 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_unpack_u32");
      orc_program_set_backup_function (p, _backup_audio_orc_unpack_u32);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x80000000, "c1");

      orc_program_append_2 (p, "xorl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_C1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_u32_swap */
#ifdef DISABLE_ORC
void
audio_orc_unpack_u32_swap (gint32 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;

  /* 2: loadpl */
  var34.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: swapl */
    var36.i = ORC_SWAP_L (var33.i);
    /* 3: xorl */
    var35.i = var36.i ^ var34.i;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_audio_orc_unpack_u32_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];

  /* 2: loadpl */
  var34.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: swapl */
    var36.i = ORC_SWAP_L (var33.i);
    /* 3: xorl */
    var35.i = var36.i ^ var34.i;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

void
audio_orc_unpack_u32_swap (gint32 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_unpack_u32_swap");
      orc_program_set_backup_function (p, _backup_audio_orc_unpack_u32_swap);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x80000000, "c1");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "swapl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "xorl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_s32 */
#ifdef DISABLE_ORC
void
audio_orc_unpack_s32 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: copyl */
    var33.i = var32.i;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_audio_orc_unpack_s32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: copyl */
    var33.i = var32.i;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
audio_orc_unpack_s32 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_unpack_s32");
      orc_program_set_backup_function (p, _backup_audio_orc_unpack_s32);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");

      orc_program_append_2 (p, "copyl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_s32_swap */
#ifdef DISABLE_ORC
void
audio_orc_unpack_s32_swap (gint32 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: swapl */
    var33.i = ORC_SWAP_L (var32.i);
    /* 2: storel */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_audio_orc_unpack_s32_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: swapl */
    var33.i = ORC_SWAP_L (var32.i);
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
audio_orc_unpack_s32_swap (gint32 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_unpack_s32_swap");
      orc_program_set_backup_function (p, _backup_audio_orc_unpack_s32_swap);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");

      orc_program_append_2 (p, "swapl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_f32 */
#ifdef DISABLE_ORC
void
audio_orc_unpack_f32 (gdouble * ORC_RESTRICT d1, const gfloat * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: convfd */
    {
      orc_union32 _src1;
      _src1.i = ORC_DENORMAL (var32.i);
      var33.f = _src1.f;
    }
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_audio_orc_unpack_f32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: convfd */
    {
      orc_union32 _src1;
      _src1.i = ORC_DENORMAL (var32.i);
      var33.f = _src1.f;
    }
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

void
audio_orc_unpack_f32 (gdouble * ORC_RESTRICT d1, const gfloat * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_unpack_f32");
      orc_program_set_backup_function (p, _backup_audio_orc_unpack_f32);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 4, "s1");

      orc_program_append_2 (p, "convfd", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_f32_swap */
#ifdef DISABLE_ORC
void
audio_orc_unpack_f32_swap (gdouble * ORC_RESTRICT d1,
    const gfloat * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union64 var34;
  orc_union32 var35;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: swapl */
    var35.i = ORC_SWAP_L (var33.i);
    /* 2: convfd */
    {
      orc_union32 _src1;
      _src1.i = ORC_DENORMAL (var35.i);
      var34.f = _src1.f;
    }
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_audio_orc_unpack_f32_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union64 var34;
  orc_union32 var35;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: swapl */
    var35.i = ORC_SWAP_L (var33.i);
    /* 2: convfd */
    {
      orc_union32 _src1;
      _src1.i = ORC_DENORMAL (var35.i);
      var34.f = _src1.f;
    }
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

void
audio_orc_unpack_f32_swap (gdouble * ORC_RESTRICT d1,
    const gfloat * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_unpack_f32_swap");
      orc_program_set_backup_function (p, _backup_audio_orc_unpack_f32_swap);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "swapl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convfd", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_f64 */
#ifdef DISABLE_ORC
void
audio_orc_unpack_f64 (gdouble * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: copyq */
    var33.i = var32.i;
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_audio_orc_unpack_f64 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: copyq */
    var33.i = var32.i;
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

void
audio_orc_unpack_f64 (gdouble * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_unpack_f64");
      orc_program_set_backup_function (p, _backup_audio_orc_unpack_f64);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 8, "s1");

      orc_program_append_2 (p, "copyq", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_unpack_f64_swap */
#ifdef DISABLE_ORC
void
audio_orc_unpack_f64_swap (gdouble * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: swapq */
    var33.i = ORC_SWAP_Q (var32.i);
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_audio_orc_unpack_f64_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: swapq */
    var33.i = ORC_SWAP_Q (var32.i);
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

void
audio_orc_unpack_f64_swap (gdouble * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_unpack_f64_swap");
      orc_program_set_backup_function (p, _backup_audio_orc_unpack_f64_swap);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 8, "s1");

      orc_program_append_2 (p, "swapq", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_u8 */
#ifdef DISABLE_ORC
void
audio_orc_pack_u8 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_union32 var35;
  orc_int8 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union16 var39;

  ptr0 = (orc_int8 *) d1;
  ptr4 = (orc_union32 *) s1;

  /* 1: loadpl */
  var35.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 2: xorl */
    var37.i = var34.i ^ var35.i;
    /* 3: shrul */
    var38.i = ((orc_uint32) var37.i) >> 24;
    /* 4: convlw */
    var39.i = var38.i;
    /* 5: convwb */
    var36 = var39.i;
    /* 6: storeb */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_audio_orc_pack_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_union32 var35;
  orc_int8 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union16 var39;

  ptr0 = (orc_int8 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];

  /* 1: loadpl */
  var35.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 2: xorl */
    var37.i = var34.i ^ var35.i;
    /* 3: shrul */
    var38.i = ((orc_uint32) var37.i) >> 24;
    /* 4: convlw */
    var39.i = var38.i;
    /* 5: convwb */
    var36 = var39.i;
    /* 6: storeb */
    ptr0[i] = var36;
  }

}

void
audio_orc_pack_u8 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_pack_u8");
      orc_program_set_backup_function (p, _backup_audio_orc_pack_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00000018, "c1");
      orc_program_add_constant (p, 4, 0x80000000, "c2");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "xorl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convlw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convwb", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_s8 */
#ifdef DISABLE_ORC
void
audio_orc_pack_s8 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_int8 var35;
  orc_union32 var36;
  orc_union16 var37;

  ptr0 = (orc_int8 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 1: shrsl */
    var36.i = var34.i >> 24;
    /* 2: convlw */
    var37.i = var36.i;
    /* 3: convwb */
    var35 = var37.i;
    /* 4: storeb */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_audio_orc_pack_s8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_int8 var35;
  orc_union32 var36;
  orc_union16 var37;

  ptr0 = (orc_int8 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 1: shrsl */
    var36.i = var34.i >> 24;
    /* 2: convlw */
    var37.i = var36.i;
    /* 3: convwb */
    var35 = var37.i;
    /* 4: storeb */
    ptr0[i] = var35;
  }

}

void
audio_orc_pack_s8 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_pack_s8");
      orc_program_set_backup_function (p, _backup_audio_orc_pack_s8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00000018, "c1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convlw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convwb", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_u16 */
#ifdef DISABLE_ORC
void
audio_orc_pack_u16 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union32 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union16 *) d1;
  ptr4 = (orc_union32 *) s1;

  /* 1: loadpl */
  var34.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 2: xorl */
    var36.i = var33.i ^ var34.i;
    /* 3: shrul */
    var37.i = ((orc_uint32) var36.i) >> 16;
    /* 4: convlw */
    var35.i = var37.i;
    /* 5: storew */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_audio_orc_pack_u16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union32 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union16 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];

  /* 1: loadpl */
  var34.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 2: xorl */
    var36.i = var33.i ^ var34.i;
    /* 3: shrul */
    var37.i = ((orc_uint32) var36.i) >> 16;
    /* 4: convlw */
    var35.i = var37.i;
    /* 5: storew */
    ptr0[i] = var35;
  }

}

void
audio_orc_pack_u16 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_pack_u16");
      orc_program_set_backup_function (p, _backup_audio_orc_pack_u16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00000010, "c1");
      orc_program_add_constant (p, 4, 0x80000000, "c2");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "xorl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convlw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_s16 */
#ifdef DISABLE_ORC
void
audio_orc_pack_s16 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union16 var34;
  orc_union32 var35;

  ptr0 = (orc_union16 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: shrsl */
    var35.i = var33.i >> 16;
    /* 2: convlw */
    var34.i = var35.i;
    /* 3: storew */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_audio_orc_pack_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union16 var34;
  orc_union32 var35;

  ptr0 = (orc_union16 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: shrsl */
    var35.i = var33.i >> 16;
    /* 2: convlw */
    var34.i = var35.i;
    /* 3: storew */
    ptr0[i] = var34;
  }

}

void
audio_orc_pack_s16 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_pack_s16");
      orc_program_set_backup_function (p, _backup_audio_orc_pack_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00000010, "c1");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convlw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_u16_swap */
#ifdef DISABLE_ORC
void
audio_orc_pack_u16_swap (guint8 * ORC_RESTRICT d1,
    const gint32 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_union32 var35;
  orc_union16 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union16 var39;

  ptr0 = (orc_union16 *) d1;
  ptr4 = (orc_union32 *) s1;

  /* 1: loadpl */
  var35.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 2: xorl */
    var37.i = var34.i ^ var35.i;
    /* 3: shrul */
    var38.i = ((orc_uint32) var37.i) >> 16;
    /* 4: convlw */
    var39.i = var38.i;
    /* 5: swapw */
    var36.i = ORC_SWAP_W (var39.i);
    /* 6: storew */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_audio_orc_pack_u16_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_union32 var35;
  orc_union16 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union16 var39;

  ptr0 = (orc_union16 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];

  /* 1: loadpl */
  var35.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 2: xorl */
    var37.i = var34.i ^ var35.i;
    /* 3: shrul */
    var38.i = ((orc_uint32) var37.i) >> 16;
    /* 4: convlw */
    var39.i = var38.i;
    /* 5: swapw */
    var36.i = ORC_SWAP_W (var39.i);
    /* 6: storew */
    ptr0[i] = var36;
  }

}

void
audio_orc_pack_u16_swap (guint8 * ORC_RESTRICT d1,
    const gint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_pack_u16_swap");
      orc_program_set_backup_function (p, _backup_audio_orc_pack_u16_swap);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x80000000, "c1");
      orc_program_add_constant (p, 4, 0x00000010, "c2");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "xorl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convlw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "swapw", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_s16_swap */
#ifdef DISABLE_ORC
void
audio_orc_pack_s16_swap (guint8 * ORC_RESTRICT d1,
    const gint32 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;

  ptr0 = (orc_union16 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 1: shrsl */
    var36.i = var34.i >> 16;
    /* 2: convlw */
    var37.i = var36.i;
    /* 3: swapw */
    var35.i = ORC_SWAP_W (var37.i);
    /* 4: storew */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_audio_orc_pack_s16_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;

  ptr0 = (orc_union16 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 1: shrsl */
    var36.i = var34.i >> 16;
    /* 2: convlw */
    var37.i = var36.i;
    /* 3: swapw */
    var35.i = ORC_SWAP_W (var37.i);
    /* 4: storew */
    ptr0[i] = var35;
  }

}

void
audio_orc_pack_s16_swap (guint8 * ORC_RESTRICT d1,
    const gint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_pack_s16_swap");
      orc_program_set_backup_function (p, _backup_audio_orc_pack_s16_swap);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00000010, "c1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convlw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "swapw", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_u24_32 */
#ifdef DISABLE_ORC
void
audio_orc_pack_u24_32 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;

  /* 1: loadpl */
  var34.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 2: xorl */
    var36.i = var33.i ^ var34.i;
    /* 3: shrul */
    var35.i = ((orc_uint32) var36.i) >> 8;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_audio_orc_pack_u24_32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];

  /* 1: loadpl */
  var34.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 2: xorl */
    var36.i = var33.i ^ var34.i;
    /* 3: shrul */
    var35.i = ((orc_uint32) var36.i) >> 8;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

void
audio_orc_pack_u24_32 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_pack_u24_32");
      orc_program_set_backup_function (p, _backup_audio_orc_pack_u24_32);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x80000000, "c1");
      orc_program_add_constant (p, 4, 0x00000008, "c2");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "xorl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C2,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_s24_32 */
#ifdef DISABLE_ORC
void
audio_orc_pack_s24_32 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: shrsl */
    var33.i = var32.i >> 8;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_audio_orc_pack_s24_32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: shrsl */
    var33.i = var32.i >> 8;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
audio_orc_pack_s24_32 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_pack_s24_32");
      orc_program_set_backup_function (p, _backup_audio_orc_pack_s24_32);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00000008, "c1");

      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_C1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_u24_32_swap */
#ifdef DISABLE_ORC
void
audio_orc_pack_u24_32_swap (guint8 * ORC_RESTRICT d1,
    const gint32 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;

  /* 1: loadpl */
  var34.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 2: xorl */
    var36.i = var33.i ^ var34.i;
    /* 3: shrul */
    var37.i = ((orc_uint32) var36.i) >> 8;
    /* 4: swapl */
    var35.i = ORC_SWAP_L (var37.i);
    /* 5: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_audio_orc_pack_u24_32_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];

  /* 1: loadpl */
  var34.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 2: xorl */
    var36.i = var33.i ^ var34.i;
    /* 3: shrul */
    var37.i = ((orc_uint32) var36.i) >> 8;
    /* 4: swapl */
    var35.i = ORC_SWAP_L (var37.i);
    /* 5: storel */
    ptr0[i] = var35;
  }

}

void
audio_orc_pack_u24_32_swap (guint8 * ORC_RESTRICT d1,
    const gint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_pack_u24_32_swap");
      orc_program_set_backup_function (p, _backup_audio_orc_pack_u24_32_swap);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x80000000, "c1");
      orc_program_add_constant (p, 4, 0x00000008, "c2");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "xorl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "swapl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_s24_32_swap */
#ifdef DISABLE_ORC
void
audio_orc_pack_s24_32_swap (guint8 * ORC_RESTRICT d1,
    const gint32 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: shrsl */
    var35.i = var33.i >> 8;
    /* 2: swapl */
    var34.i = ORC_SWAP_L (var35.i);
    /* 3: storel */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_audio_orc_pack_s24_32_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: shrsl */
    var35.i = var33.i >> 8;
    /* 2: swapl */
    var34.i = ORC_SWAP_L (var35.i);
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
audio_orc_pack_s24_32_swap (guint8 * ORC_RESTRICT d1,
    const gint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_pack_s24_32_swap");
      orc_program_set_backup_function (p, _backup_audio_orc_pack_s24_32_swap);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00000008, "c1");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "swapl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_u32 */
#ifdef DISABLE_ORC
void
audio_orc_pack_u32 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;

  /* 1: loadpl */
  var33.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 2: xorl */
    var34.i = var32.i ^ var33.i;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_audio_orc_pack_u32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];

  /* 1: loadpl */
  var33.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 2: xorl */
    var34.i = var32.i ^ var33.i;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
audio_orc_pack_u32 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_pack_u32");
      orc_program_set_backup_function (p, _backup_audio_orc_pack_u32);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x80000000, "c1");

      orc_program_append_2 (p, "xorl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_C1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_s32 */
#ifdef DISABLE_ORC
void
audio_orc_pack_s32 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: copyl */
    var33.i = var32.i;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_audio_orc_pack_s32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: copyl */
    var33.i = var32.i;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
audio_orc_pack_s32 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_pack_s32");
      orc_program_set_backup_function (p, _backup_audio_orc_pack_s32);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");

      orc_program_append_2 (p, "copyl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_u32_swap */
#ifdef DISABLE_ORC
void
audio_orc_pack_u32_swap (guint8 * ORC_RESTRICT d1,
    const gint32 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;

  /* 1: loadpl */
  var33.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 2: xorl */
    var34.i = var32.i ^ var33.i;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_audio_orc_pack_u32_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];

  /* 1: loadpl */
  var33.i = (int) 0x80000000;   /* -2147483648 or 1.061e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 2: xorl */
    var34.i = var32.i ^ var33.i;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
audio_orc_pack_u32_swap (guint8 * ORC_RESTRICT d1,
    const gint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_pack_u32_swap");
      orc_program_set_backup_function (p, _backup_audio_orc_pack_u32_swap);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x80000000, "c1");

      orc_program_append_2 (p, "xorl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_C1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_s32_swap */
#ifdef DISABLE_ORC
void
audio_orc_pack_s32_swap (guint8 * ORC_RESTRICT d1,
    const gint32 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: swapl */
    var33.i = ORC_SWAP_L (var32.i);
    /* 2: storel */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_audio_orc_pack_s32_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: swapl */
    var33.i = ORC_SWAP_L (var32.i);
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
audio_orc_pack_s32_swap (guint8 * ORC_RESTRICT d1,
    const gint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_pack_s32_swap");
      orc_program_set_backup_function (p, _backup_audio_orc_pack_s32_swap);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");

      orc_program_append_2 (p, "swapl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_f32 */
#ifdef DISABLE_ORC
void
audio_orc_pack_f32 (gfloat * ORC_RESTRICT d1, const gdouble * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: convdf */
    {
      orc_union64 _src1;
      orc_union32 _dest;
      _src1.i = ORC_DENORMAL_DOUBLE (var32.i);
      _dest.f = _src1.f;
      var33.i = ORC_DENORMAL (_dest.i);
    }
    /* 2: storel */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_audio_orc_pack_f32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: convdf */
    {
      orc_union64 _src1;
      orc_union32 _dest;
      _src1.i = ORC_DENORMAL_DOUBLE (var32.i);
      _dest.f = _src1.f;
      var33.i = ORC_DENORMAL (_dest.i);
    }
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
audio_orc_pack_f32 (gfloat * ORC_RESTRICT d1, const gdouble * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_pack_f32");
      orc_program_set_backup_function (p, _backup_audio_orc_pack_f32);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 8, "s1");

      orc_program_append_2 (p, "convdf", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_f32_swap */
#ifdef DISABLE_ORC
void
audio_orc_pack_f32_swap (gfloat * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var33;
  orc_union32 var34;
  orc_union32 var35;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var33 = ptr4[i];
    /* 1: convdf */
    {
      orc_union64 _src1;
      orc_union32 _dest;
      _src1.i = ORC_DENORMAL_DOUBLE (var33.i);
      _dest.f = _src1.f;
      var35.i = ORC_DENORMAL (_dest.i);
    }
    /* 2: swapl */
    var34.i = ORC_SWAP_L (var35.i);
    /* 3: storel */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_audio_orc_pack_f32_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var33;
  orc_union32 var34;
  orc_union32 var35;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var33 = ptr4[i];
    /* 1: convdf */
    {
      orc_union64 _src1;
      orc_union32 _dest;
      _src1.i = ORC_DENORMAL_DOUBLE (var33.i);
      _dest.f = _src1.f;
      var35.i = ORC_DENORMAL (_dest.i);
    }
    /* 2: swapl */
    var34.i = ORC_SWAP_L (var35.i);
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
audio_orc_pack_f32_swap (gfloat * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_pack_f32_swap");
      orc_program_set_backup_function (p, _backup_audio_orc_pack_f32_swap);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "convdf", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "swapl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_f64 */
#ifdef DISABLE_ORC
void
audio_orc_pack_f64 (gdouble * ORC_RESTRICT d1, const gdouble * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: copyq */
    var33.i = var32.i;
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_audio_orc_pack_f64 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: copyq */
    var33.i = var32.i;
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

void
audio_orc_pack_f64 (gdouble * ORC_RESTRICT d1, const gdouble * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_pack_f64");
      orc_program_set_backup_function (p, _backup_audio_orc_pack_f64);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 8, "s1");

      orc_program_append_2 (p, "copyq", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* audio_orc_pack_f64_swap */
#ifdef DISABLE_ORC
void
audio_orc_pack_f64_swap (gdouble * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: swapq */
    var33.i = ORC_SWAP_Q (var32.i);
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_audio_orc_pack_f64_swap (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: swapq */
    var33.i = ORC_SWAP_Q (var32.i);
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

void
audio_orc_pack_f64_swap (gdouble * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "audio_orc_pack_f64_swap");
      orc_program_set_backup_function (p, _backup_audio_orc_pack_f64_swap);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 8, "s1");

      orc_program_append_2 (p, "swapq", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif
