/* GStreamer
 * Copyright (C) <1999> Erik Walthinsen <omega@cse.ogi.edu>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GST_XIMAGE_H__
#define __GST_XIMAGE_H__

#define USE_SHM

#include <glib.h> 
#include <X11/Xlib.h> 

#ifdef USE_SHM
#include <X11/extensions/XShm.h>
#endif /* USE_SHM */

#include "gstxwindow.h"
#include "gstimage.h"

G_BEGIN_DECLS

#define GST_XIMAGE(img)		((GstXImage*)(img))

typedef struct _GstXImage	      GstXImage;

#define GST_XIMAGE_BPP(img)		((img)->ximage->bits_per_pixel)
#define GST_XIMAGE_DEPTH(img)		((img)->ximage->depth)
#define GST_XIMAGE_ENDIANNESS(img)	((img)->endianness)
#define GST_XIMAGE_RED_MASK(img)	((img)->visual->red_mask)
#define GST_XIMAGE_GREEN_MASK(img)	((img)->visual->green_mask)
#define GST_XIMAGE_BLUE_MASK(img)	((img)->visual->blue_mask)

struct _GstXImage
{
  GstImage parent;

#ifdef USE_SHM
  XShmSegmentInfo SHMInfo;
#else
  gpointer *SHMInfo;
#endif
  XImage *ximage;
  Visual *visual;
  gint width, height;
  gulong endianness;
};

GstXImage* _gst_ximage_new (GstXWindow *window, gint width, gint height);
void _gst_ximage_add_formats (GstXWindow *window);

G_END_DECLS

#endif /* __GST_XIMAGE_H__ */
