/* GStreamer
 * Copyright (C) <1999> Erik Walthinsen <omega@cse.ogi.edu>
 * Copyright (C) <2003> David Schleef <ds@schleef.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* 
 * Portions derived from:
 *
 * GDK - The GIMP Drawing Kit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gst/gst.h>
/* gcc -ansi -pedantic on GNU/Linux causes warnings and errors
 * unless this is defined:
 * warning: #warning "Files using this header must be compiled with _SVID_SOURCE or _XOPEN_SOURCE"
 */
#ifndef _XOPEN_SOURCE
#  define _XOPEN_SOURCE 1
#endif

#define HAVE_XSHM

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#if defined (HAVE_IPC_H) && defined (HAVE_XSHM_H) && defined (HAVE_XSHM_H)
#define HAVE_XSHM
#endif

#ifdef HAVE_XSHM
#include <sys/ipc.h>
#include <sys/shm.h>
#endif /* HAVE_XSHM */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Xproto.h>
#include <X11/Xmd.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#ifdef HAVE_XSHM
#include <X11/extensions/XShm.h>
#endif /* HAVE_XSHM */

# include <X11/extensions/Xv.h>
# include <X11/extensions/Xvlib.h>

#include "gstxvimage.h"

static GStaticMutex omg = G_STATIC_MUTEX_INIT; /* omg, static vars */

#if 0
static int _gst_xvimage_error_caught;
#endif


static void 	_gst_xvimage_destroy 		(GstXvImage *image);
static void 	_gst_xvimage_put		(GstXWindow *window, GstXvImage *image);
#if 0
static gboolean _gst_xvimage_try_put            (GstXWindow *window, GstXvImage *image);
#endif

gboolean
_gst_xvimage_check_xvideo(Display *display)
{
  int ver, rel, req, ev, err;

  g_static_mutex_lock (&omg);
  display = XOpenDisplay(NULL);

  if (display == NULL) {
    g_static_mutex_unlock (&omg);
    return FALSE;
  }

  if (Success == XvQueryExtension(display,&ver,&rel,&req,&ev,&err)) {
    g_static_mutex_unlock (&omg);
    return TRUE;
  }
  return FALSE;
}

#if 0
static int
_gst_xvimage_error_handler(Display *d, XErrorEvent *event)
{
  _gst_xvimage_error_caught++;
  return 0;
}
#endif

GstXvImage*
_gst_xvimage_new (GstImageFormat *format,
		  GstXWindow *window,
	          gint          width,
	          gint          height)
{
#ifdef HAVE_XSHM
  GstXvImage *image = NULL;
  XShmSegmentInfo *x_shm_info;

  g_static_mutex_lock (&omg);

  image = g_new (GstXvImage, 1);

  GST_IMAGE_TYPE (image) 	= GST_TYPE_XVIMAGE;
  GST_IMAGE_DESTROYFUNC (image) = (GstImageDestroyFunc) _gst_xvimage_destroy;
  GST_IMAGE_PUTFUNC (image) 	= (GstImagePutFunc) _gst_xvimage_put;
  GST_IMAGE_WINDOW (image)      = window;

  image->type = format->im_format;
  image->width = width;
  image->height = height;

  image->x_shm_info = g_new (XShmSegmentInfo, 1);
  image->im_port = format->im_port;
  x_shm_info = image->x_shm_info;
  image->im_format = format->im_format;

  image->ximage = XvShmCreateImage(window->disp, image->im_port, 
     image->im_format, 0, width, height, x_shm_info);

  if (image->ximage == NULL)
  {
    g_warning ("XvShmCreateImage failed");
	  
    g_free (image);
    g_static_mutex_unlock (&omg);
    return NULL;
  }
    
  x_shm_info->shmid = shmget (IPC_PRIVATE,
			  image->ximage->data_size,
			  IPC_CREAT | 0777);

  if (x_shm_info->shmid == -1)
  {
    g_warning ("shmget failed!");

    XFree (image->ximage);
    g_free (image->x_shm_info);
    g_free (image);

    g_static_mutex_unlock (&omg);
    return NULL;
  }

  x_shm_info->readOnly = False;
  x_shm_info->shmaddr = shmat (x_shm_info->shmid, 0, 0);
  image->ximage->data = x_shm_info->shmaddr;

  if (x_shm_info->shmaddr == (char*) -1)
  {
    g_warning ("shmat failed!");

    XFree (image->ximage);
    shmctl (x_shm_info->shmid, IPC_RMID, 0);
		  
    g_free (image->x_shm_info);
    g_free (image);

    g_static_mutex_unlock (&omg);
    return NULL;
  }

  XShmAttach (window->disp, x_shm_info);
  XSync (window->disp, False);

  if (0)
  {
    /* this is the common failure case so omit warning */
    XFree (image->ximage);
    shmdt (x_shm_info->shmaddr);
    shmctl (x_shm_info->shmid, IPC_RMID, 0);
                  
    g_free (image->x_shm_info);
    g_free (image);


    g_static_mutex_unlock (&omg);
    return NULL;
  }
	      
   /* We mark the segment as destroyed so that when
    * the last process detaches, it will be deleted.
    * There is a small possibility of leaking if
    * we die in XShmAttach. In theory, a signal handler
    * could be set up.
    */
  shmctl (x_shm_info->shmid, IPC_RMID, 0);		      

  if (image)
  {
    GST_IMAGE_DATA (image) = image->ximage->data;
    GST_IMAGE_SIZE (image) = image->ximage->data_size;
  }

  /* don't attempt to put the image, because we may have something
   * interesting displayed, and this will overwrite it. */
#if 0
  if(!_gst_xvimage_try_put(window, image)){
    g_warning ("XvShmPutImage failed");

    g_free (image);
    g_static_mutex_unlock (&omg);
    return NULL;
  }
#endif

  g_static_mutex_unlock (&omg);
  _gst_xwindow_ref (window);
  return image;
#else
  g_warning ("compiled without shared memory support: Xv image creation not supported");
  return NULL;
#endif /* HAVE_XSHM */
  return NULL; /* well tell me if it's wrong to do this */
}

static void
_gst_xvimage_destroy (GstXvImage *image)
{
#ifdef HAVE_XSHM
  XShmSegmentInfo *x_shm_info;
#endif /* HAVE_XSHM */

  g_return_if_fail (image != NULL);

#ifdef HAVE_XSHM
  XShmDetach (GST_IMAGE_WINDOW (image)->disp, image->x_shm_info);
  XFree (image->ximage);

  x_shm_info = image->x_shm_info;
  shmdt (x_shm_info->shmaddr);
      
  g_free (image->x_shm_info);

  _gst_xwindow_unref (GST_IMAGE_WINDOW (image));

#else /* HAVE_XSHM */
  g_error ("trying to destroy shared memory image when gst was compiled without shared memory support");
#endif /* HAVE_XSHM */

  g_free (image);
}

#if 0
static gboolean
_gst_xvimage_try_put (GstXWindow *window,
		 GstXvImage *image)
{
#ifdef HAVE_XSHM
  XWindowAttributes attr; 
  void *old_handler;

  g_return_val_if_fail (window != NULL, FALSE);
  g_return_val_if_fail (image != NULL, FALSE);

  XGetWindowAttributes(window->disp, window->win, &attr); 

  XSync(window->disp,0);
  _gst_xvimage_error_caught = 0;
  old_handler = XSetErrorHandler(_gst_xvimage_error_handler);
  XvShmPutImage (window->disp, image->im_port, window->win,
		window->gc, image->ximage,
		0, 0, image->width, image->height, 
		0, 0, attr.width, attr.height, False);
  XSync(window->disp, False);
  XSetErrorHandler(old_handler);
  if(_gst_xvimage_error_caught>0){
    return FALSE;
  }

  return TRUE;
#else /* HAVE_XSHM */
  g_error ("trying to draw shared memory image when gst was compiled without shared memory support");
  return FALSE;
#endif /* HAVE_XSHM */
}
#endif

static void
_gst_xvimage_put (GstXWindow *window,
		 GstXvImage *image)
{
#ifdef HAVE_XSHM
  XWindowAttributes attr; 

  g_return_if_fail (window != NULL);
  g_return_if_fail (image != NULL);

  XGetWindowAttributes(window->disp, window->win, &attr); 

  XvShmPutImage (window->disp, image->im_port, window->win,
		window->gc, image->ximage,
		0, 0, image->width, image->height, 
		0, 0, attr.width, attr.height, False);
  XSync(window->disp, False);

#else /* HAVE_XSHM */
  g_error ("trying to draw shared memory image when gst was compiled without shared memory support");
#endif /* HAVE_XSHM */
}

void
_gst_xvimage_add_formats(GstXWindow *window)
{
  int i;
  int j;
  int im_adaptor;
  int im_port;
  int adaptors;
  XvAdaptorInfo *ai;
  XvImageFormatValues *fo;
  int formats;
  
  g_return_if_fail(window);

  if (!_gst_xvimage_check_xvideo(window->disp)) {
    GST_DEBUG ("Xv: Server has no Xvideo extention support");
    return;
  }

  g_static_mutex_lock (&omg);
  im_adaptor = im_port = -1;
  if (Success != XvQueryAdaptors(window->disp,DefaultRootWindow(window->disp),
	&adaptors,&ai)) {
    g_warning ("Xv: XvQueryAdaptors failed");
    g_static_mutex_unlock (&omg);
    return;
  }
  GST_DEBUG ( "Xv: %d adaptors available.",adaptors);

  for (i = 0; i < adaptors; i++) {
    GST_DEBUG ( "Xv: %s:%s%s%s%s%s, ports %ld-%ld",
                     ai[i].name,
	            (ai[i].type & XvInputMask)  ? " input"  : "",
		    (ai[i].type & XvOutputMask) ? " output" : "",
		    (ai[i].type & XvVideoMask)  ? " video"  : "",
		    (ai[i].type & XvStillMask)  ? " still"  : "",
		    (ai[i].type & XvImageMask)  ? " image"  : "",
		    ai[i].base_id,
		    ai[i].base_id+ai[i].num_ports-1);

    if (!((ai[i].type & XvInputMask) && (ai[i].type & XvImageMask)))
      continue;

    if (im_port != -1)
      continue;

    im_port = ai[i].base_id;
    im_adaptor = i;

    {
      int count;
      const XvAttribute * const attr = XvQueryPortAttributes(window->disp,
	  im_port, &count);

      for (j = 0; j < count; ++j) {
	if (strcmp(attr[j].name, "XV_AUTOPAINT_COLORKEY") == 0) {
	  const Atom atom = XInternAtom(window->disp, "XV_AUTOPAINT_COLORKEY",
	      False);
	  XvSetPortAttribute(window->disp, im_port, atom, 1);
	  break;
	}
      }
    }

    /* *** image scaler port *** */
    fo = XvListImageFormats(window->disp, im_port, &formats);

    GST_DEBUG ("  image format list for port %d",im_port);
    for(j = 0; j < formats; j++) {
      GstImageFormat *image_format;

      image_format = g_new0(GstImageFormat, 1);

      image_format->type = GST_TYPE_XVIMAGE;
      image_format->im_adaptor = im_adaptor;
      image_format->im_port = im_port;
      image_format->im_format = fo[j].id;

      if(fo[j].type == XvRGB){
      	GST_DEBUG ( "    RGB 0x%x (" GST_FOURCC_FORMAT ") %s (%08x,%08x,%08x)",
	    fo[j].id,
	    GST_FOURCC_ARGS(fo[j].id),
	    (fo[j].format == XvPacked) ? "packed" : "planar",
	    fo[j].red_mask,
	    fo[j].green_mask,
	    fo[j].blue_mask);
        image_format->caps = GST_CAPS_NEW ( "xvideosink_caps",
	    "video/x-raw-rgb", 
	    "endianness", GST_PROPS_INT (G_BYTE_ORDER),
	    "depth",     GST_PROPS_INT (fo[j].depth),
	    "bpp",       GST_PROPS_INT (fo[j].bits_per_pixel),
	    "blue_mask", GST_PROPS_INT (fo[j].red_mask),
	    "green_mask", GST_PROPS_INT (fo[j].green_mask),
	    "red_mask",  GST_PROPS_INT (fo[j].blue_mask),
            "width",     GST_PROPS_INT_RANGE (0, G_MAXINT),
	    "height",    GST_PROPS_INT_RANGE (0, G_MAXINT),
	    "framerate", GST_PROPS_FLOAT_RANGE (0, G_MAXFLOAT));
      }else{
      	GST_DEBUG ( "    YUV 0x%x (" GST_FOURCC_FORMAT ") %s %.32s (%d:%d;%d,%d:%d:%d,%d:%d:%d)",
	    fo[j].id,
	    GST_FOURCC_ARGS(fo[j].id),
	    (fo[j].format == XvPacked) ? "packed" : "planar",
	    fo[j].component_order,
	    fo[j].y_sample_bits,
	    fo[j].u_sample_bits,
	    fo[j].v_sample_bits,
	    fo[j].horz_y_period,
	    fo[j].horz_u_period,
	    fo[j].horz_v_period,
	    fo[j].vert_y_period,
	    fo[j].vert_u_period,
	    fo[j].vert_v_period);

        image_format->caps = GST_CAPS_NEW ( "xvideosink_caps",
	    "video/x-raw-yuv", 
	    "format",      GST_PROPS_FOURCC (fo[j].id),
            "width",     GST_PROPS_INT_RANGE (0, G_MAXINT),
	    "height",    GST_PROPS_INT_RANGE (0, G_MAXINT),
	    "framerate", GST_PROPS_FLOAT_RANGE (0, G_MAXFLOAT));
      }

      g_ptr_array_add(window->image_formats, image_format);
    }
  }
  g_static_mutex_unlock (&omg);
}

