/* A Bison parser, made by GNU Bison 1.875a.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* If NAME_PREFIX is specified substitute the variables and functions
   names.  */
#define yyparse _gst_parse__yyparse
#define yylex   _gst_parse__yylex
#define yyerror _gst_parse__yyerror
#define yylval  _gst_parse__yylval
#define yychar  _gst_parse__yychar
#define yydebug _gst_parse__yydebug
#define yynerrs _gst_parse__yynerrs


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     IDENTIFIER = 258,
     BINREF = 259,
     PADREF = 260,
     REF = 261,
     ASSIGNMENT = 262,
     LINK = 263
   };
#endif
#define IDENTIFIER 258
#define BINREF 259
#define PADREF 260
#define REF 261
#define ASSIGNMENT 262
#define LINK 263




/* Copy the first part of user declarations.  */
#line 1 "./grammar.y"

#include <glib-object.h>
#include <glib.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "../gst_private.h"

#include "../gstparse.h"
#include "../gstinfo.h"
#include "types.h"

#define YYERROR_VERBOSE 1
#define YYPARSE_PARAM graph

#ifdef __GST_PARSE_TRACE
static guint __strings;
static guint __links;
static guint __chains;
gchar *
__gst_parse_strdup (gchar *org)
{
  gchar *ret; 
  __strings++;
  ret = g_strdup (org);
  /* g_print ("ALLOCATED STR   (%3u): %p %s\n", __strings, ret, ret); */
  return ret;
}
void
__gst_parse_strfree (gchar *str)
{
  if (str) {
    /* g_print ("FREEING STR     (%3u): %p %s\n", __strings - 1, str, str); */
    g_free (str);
    g_return_if_fail (__strings > 0);
    __strings--;
  }
}
link_t *__gst_parse_link_new ()
{
  link_t *ret;
  __links++;
  ret = g_new0 (link_t, 1);
  /* g_print ("ALLOCATED LINK  (%3u): %p\n", __links, ret); */
  return ret;
}
void
__gst_parse_link_free (link_t *data)
{
  if (data) {
    /* g_print ("FREEING LINK    (%3u): %p\n", __links - 1, data); */
    g_free (data);
    g_return_if_fail (__links > 0);
    __links--;
  }
}
chain_t *
__gst_parse_chain_new ()
{
  chain_t *ret;
  __chains++;
  ret = g_new0 (chain_t, 1);
  /* g_print ("ALLOCATED CHAIN (%3u): %p\n", __chains, ret); */
  return ret;
}
void
__gst_parse_chain_free (chain_t *data)
{
  if (data) {
    /* g_print ("FREEING CHAIN   (%3u): %p\n", __chains - 1, data); */
    g_free (data);
    g_return_if_fail (__chains > 0);
    __chains--;
  }
}

#endif /* __GST_PARSE_TRACE */

typedef struct {
  gchar *src_pad;
  gchar *sink_pad;
  GstElement *sink;
  GstCaps *caps;
  gulong signal_id;
  /* FIXME: need to connect to "disposed" signal to clean up, but there is no such signal */
} DelayedLink;

#ifdef G_HAVE_ISO_VARARGS
#define SET_ERROR(error, type, ...) G_STMT_START{ \
  if (error) { \
    if (*(error)) { \
      g_warning (__VA_ARGS__); \
    } else { \
      g_set_error ((error), GST_PARSE_ERROR, (type), __VA_ARGS__); \
    }\
  } \
}G_STMT_END
#define ERROR(type, ...) SET_ERROR (((graph_t *) graph)->error, (type), __VA_ARGS__ )
#ifdef GST_DEBUG_ENABLED
#  define YYDEBUG 1
   /* bison 1.35 calls this macro with side effects, we need to make sure the
      side effects work - crappy bison
#  define YYFPRINTF(a, ...) GST_CAT_DEBUG (GST_CAT_PIPELINE, __VA_ARGS__)
 */
#  define YYFPRINTF(a, ...) G_STMT_START{ \
     gchar *temp = g_strdup_printf (__VA_ARGS__); \
     GST_CAT_DEBUG (GST_CAT_PIPELINE, temp); \
     g_free (temp); \
   }G_STMT_END
#endif

#elif defined(G_HAVE_GNUC_VARARGS)

#define SET_ERROR(error, type, args...) G_STMT_START{ \
  if (error) { \
    if (*(error)) { \
      g_warning ( ## args ); \
    } else { \
      g_set_error ((error), GST_PARSE_ERROR, (type), ## args ); \
    }\
  } \
}G_STMT_END
#define ERROR(type, args...) SET_ERROR (((graph_t *) graph)->error, (type), ## args )
#ifdef GST_DEBUG_ENABLED
#  define YYDEBUG 1
   /* bison 1.35 calls this macro with side effects, we need to make sure the
      side effects work - crappy bison
#  define YYFPRINTF(a, args...) GST_CAT_DEBUG (GST_CAT_PIPELINE, ## args )
 */
#  define YYFPRINTF(a, args...) G_STMT_START{ \
     gchar *temp = g_strdup_printf ( ## args ); \
     GST_CAT_DEBUG (GST_CAT_PIPELINE, temp); \
     g_free (temp); \
   }G_STMT_END
#endif

#else

#define SET_ERROR(error, type, ...) G_STMT_START{ \
  if (error) { \
    if (*(error)) { \
      g_warning ("error while parsing"); \
    } else { \
      g_set_error ((error), GST_PARSE_ERROR, (type), "error while parsing"); \
    }\
  } \
}G_STMT_END
#define ERROR(type, ...) SET_ERROR (((graph_t *) graph)->error, (type), "error while parsing")
#ifdef GST_DEBUG_ENABLED
#  define YYDEBUG 1
#endif

#endif /* G_HAVE_ISO_VARARGS */

#define GST_BIN_MAKE(res, type, chainval, assign) G_STMT_START{ \
  chain_t *chain = chainval; \
  GSList *walk; \
  GstBin *bin = (GstBin *) gst_element_factory_make (type, NULL); \
  if (!chain) { \
    ERROR (GST_PARSE_ERROR_EMPTY_BIN, "Specified empty bin \"%s\", not allowed", type); \
    g_slist_foreach (assign, (GFunc) gst_parse_strfree, NULL); \
    g_slist_free (assign); \
    YYERROR; \
  } else if (!bin) { \
    ERROR (GST_PARSE_ERROR_NO_SUCH_ELEMENT, "No bin \"%s\", omitting...", type); \
    g_slist_foreach (assign, (GFunc) gst_parse_strfree, NULL); \
    g_slist_free (assign); \
    res = chain; \
  } else { \
    walk = chain->elements; \
    while (walk) { \
      gst_bin_add (bin, GST_ELEMENT (walk->data)); \
      walk = walk->next; \
    } \
    g_slist_free (chain->elements); \
    chain->elements = g_slist_prepend (NULL, bin); \
    res = chain; \
    /* set the properties now */ \
    walk = assign; \
    while (walk) { \
      gst_parse_element_set ((gchar *) walk->data, GST_ELEMENT (bin), graph); \
      walk = g_slist_next (walk); \
    } \
    g_slist_free (assign); \
  } \
}G_STMT_END

#define MAKE_LINK(link, _src, _src_name, _src_pads, _sink, _sink_name, _sink_pads) G_STMT_START{ \
  link = gst_parse_link_new (); \
  link->src = _src; \
  link->sink = _sink; \
  link->src_name = _src_name; \
  link->sink_name = _sink_name; \
  link->src_pads = _src_pads; \
  link->sink_pads = _sink_pads; \
  link->caps = NULL; \
}G_STMT_END

#define MAKE_REF(link, _src, _pads) G_STMT_START{ \
  gchar *padname = _src; \
  GSList *pads = _pads; \
  if (padname) { \
    while (*padname != '.') padname++; \
    *padname = '\0'; \
    padname++; \
    if (*padname != '\0') \
      pads = g_slist_prepend (pads, gst_parse_strdup (padname)); \
  } \
  MAKE_LINK (link, NULL, _src, pads, NULL, NULL, NULL); \
}G_STMT_END

static inline void gst_parse_unescape (gchar *str)
{
  gchar *walk;
  
  g_return_if_fail (str != NULL);
  
  walk = str;
  
  while (*walk) {
    if (*walk == '\\')
      walk++;
    *str = *walk;
    str++;
    walk++;
  }
  *str = '\0';
}
static void
gst_parse_element_set (gchar *value, GstElement *element, graph_t *graph)
{
  GParamSpec *pspec;
  gchar *pos = value;
  /* parse the string, so the property name is null-terminated an pos points
     to the beginning of the value */
  while (!g_ascii_isspace (*pos) && (*pos != '=')) pos++; 
  if (*pos == '=') { 
    *pos = '\0'; 
  } else { 
    *pos = '\0'; 
    pos++;
    while (g_ascii_isspace (*pos)) pos++; 
  } 
  pos++; 
  while (g_ascii_isspace (*pos)) pos++; 
  if (*pos == '"') {
    pos++;
    pos[strlen (pos) - 1] = '\0';
  }
  gst_parse_unescape (pos); 
  if ((pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (element), value))) { 
    GValue v = { 0, }; 
    GValue v2 = { 0, };
    g_value_init (&v, G_PARAM_SPEC_VALUE_TYPE(pspec)); 
    switch (G_TYPE_FUNDAMENTAL (G_PARAM_SPEC_VALUE_TYPE (pspec))) {
    case G_TYPE_STRING:
      g_value_set_string (&v, pos);
      break;      
    case G_TYPE_BOOLEAN:
      if (g_ascii_strcasecmp (pos, "true") && g_ascii_strcasecmp (pos, "yes") && g_ascii_strcasecmp (pos, "1")) {
        g_value_set_boolean (&v, FALSE);
      } else {
        g_value_set_boolean (&v, TRUE);
      }
      break;
    case G_TYPE_ENUM: {
      GEnumValue *en;
      gchar *endptr = NULL;
      GEnumClass *klass = (GEnumClass *) g_type_class_peek (G_PARAM_SPEC_VALUE_TYPE (pspec));
      if (klass == NULL) goto error;
      if (!(en = g_enum_get_value_by_name (klass, pos))) {
        if (!(en = g_enum_get_value_by_nick (klass, pos))) {
          gint i = strtol (pos, &endptr, 0);
	  if (endptr && *endptr == '\0') {
	    en = g_enum_get_value (klass, i);
	  }
        }
      }
      if (!en)
	goto error;
      g_value_set_enum (&v, en->value);
      break;
    }
    case G_TYPE_INT:
    case G_TYPE_LONG:
    case G_TYPE_INT64: {
      gchar *endptr;
      glong l;
      g_value_init (&v2, G_TYPE_LONG); 
      l = strtol (pos, &endptr, 0);
      if (*endptr != '\0') goto error_conversion;
      g_value_set_long (&v2, l);
      if (!g_value_transform (&v2, &v)) goto error_conversion;
      break;      
    }
    case G_TYPE_UINT:
    case G_TYPE_ULONG:
    case G_TYPE_UINT64: {
      gchar *endptr;
      gulong ul;
      g_value_init (&v2, G_TYPE_ULONG); 
      ul = strtoul (pos, &endptr, 0);
      if (*endptr != '\0') goto error_conversion;
      g_value_set_ulong (&v2, ul);
      if (!g_value_transform (&v2, &v)) goto error_conversion;
      break;      
    }
    case G_TYPE_FLOAT:
    case G_TYPE_DOUBLE: {
      gchar *endptr;
      gdouble d;
      g_value_init (&v2, G_TYPE_DOUBLE); 
      d = g_ascii_strtod (pos, &endptr);
      if (*endptr != '\0') goto error_conversion;
      g_value_set_double (&v2, d);
      if (!g_value_transform (&v2, &v)) goto error_conversion;
      break;      
    }
    default:
      /* add more */
      g_warning ("property \"%s\" in element %s cannot be set", value, GST_ELEMENT_NAME (element)); 
      goto error;
    }
    g_object_set_property (G_OBJECT (element), value, &v); 
  } else { 
    ERROR (GST_PARSE_ERROR_NO_SUCH_PROPERTY, "No property \"%s\" in element \"%s\"", value, GST_ELEMENT_NAME (element)); 
  }

out:
  gst_parse_strfree (value);
  return;
  
error:
  ERROR (GST_PARSE_ERROR_COULD_NOT_SET_PROPERTY,
         "Could not set property \"%s\" in element \"%s\" to \"%s\"", 
	 value, GST_ELEMENT_NAME (element), pos); 
  goto out;
error_conversion:
  ERROR (GST_PARSE_ERROR_COULD_NOT_SET_PROPERTY,
         "Could not convert \"%s\" so that it fits property \"%s\" in element \"%s\"",
         pos, value, GST_ELEMENT_NAME (element)); 
  goto out;
}
static inline void
gst_parse_free_link (link_t *link)
{
  gst_parse_strfree (link->src_name);
  gst_parse_strfree (link->sink_name);
  g_slist_foreach (link->src_pads, (GFunc) gst_parse_strfree, NULL);
  g_slist_foreach (link->sink_pads, (GFunc) gst_parse_strfree, NULL);
  g_slist_free (link->src_pads);
  g_slist_free (link->sink_pads);
  gst_caps_unref (link->caps);
  gst_parse_link_free (link);  
}
static void
gst_parse_element_lock (GstElement *element, gboolean lock)
{
  GstPad *pad;
  GList *walk = (GList *) gst_element_get_pad_list (element);
  gboolean unlocked_peer = FALSE;
  
  if (gst_element_is_locked_state (element) == lock)
    return;
  /* check if we have an unlocked peer */
  while (walk) {
    pad = (GstPad *) GST_PAD_REALIZE (walk->data);
    walk = walk->next;
    if (GST_PAD_IS_SINK (pad) && GST_PAD_PEER (pad) &&
        !gst_element_is_locked_state (GST_PAD_PARENT (GST_PAD_PEER (pad)))) {
      unlocked_peer = TRUE;
      break;
    }
  }  
  
  if (!(lock && unlocked_peer)) {
    gst_element_set_locked_state (element, lock);
    if (!lock)
      gst_element_sync_state_with_parent (element);
  } else {
    return;
  }
  
  /* check if there are other pads to (un)lock */
  walk = (GList *) gst_element_get_pad_list (element);
  while (walk) {
    pad = (GstPad *) GST_PAD_REALIZE (walk->data);
    walk = walk->next;
    if (GST_PAD_IS_SRC (pad) && GST_PAD_PEER (pad)) {
      GstElement *next = GST_ELEMENT (GST_OBJECT_PARENT (GST_PAD_PEER (pad)));
      if (gst_element_is_locked_state (next) != lock)
        gst_parse_element_lock (next, lock);
    }
  }
}
static void
gst_parse_found_pad (GstElement *src, GstPad *pad, gpointer data)
{
  DelayedLink *link = (DelayedLink *) data;
  
  GST_CAT_INFO (GST_CAT_PIPELINE, "trying delayed linking %s:%s to %s:%s", 
                GST_ELEMENT_NAME (src), link->src_pad,
                GST_ELEMENT_NAME (link->sink), link->sink_pad);

  if (gst_element_link_pads_filtered (src, link->src_pad, link->sink, link->sink_pad, link->caps)) {
    /* do this here, we don't want to get any problems later on when unlocking states */
    GST_CAT_DEBUG (GST_CAT_PIPELINE, "delayed linking %s:%s to %s:%s worked", 
               	   GST_ELEMENT_NAME (src), link->src_pad,
               	   GST_ELEMENT_NAME (link->sink), link->sink_pad);
    g_signal_handler_disconnect (src, link->signal_id);
    g_free (link->src_pad);
    g_free (link->sink_pad);
    gst_caps_unref (link->caps);
    if (!gst_element_is_locked_state (src))
      gst_parse_element_lock (link->sink, FALSE);
    g_free (link);
  }
}
/* both padnames and the caps may be NULL */
static gboolean
gst_parse_perform_delayed_link (GstElement *src, const gchar *src_pad, 
                                GstElement *sink, const gchar *sink_pad, GstCaps *caps)
{
  GList *templs = gst_element_get_pad_template_list (src);
	 
  while (templs) {
    GstPadTemplate *templ = (GstPadTemplate *) templs->data;
    if ((GST_PAD_TEMPLATE_DIRECTION (templ) == GST_PAD_SRC) && (GST_PAD_TEMPLATE_PRESENCE(templ) == GST_PAD_SOMETIMES))
    {
      DelayedLink *data = g_new (DelayedLink, 1); 
      
      /* TODO: maybe we should check if src_pad matches this template's names */

      GST_CAT_DEBUG (GST_CAT_PIPELINE, "trying delayed link %s:%s to %s:%s", 
                     GST_ELEMENT_NAME (src), src_pad, GST_ELEMENT_NAME (sink), sink_pad);

      data->src_pad = g_strdup (src_pad);
      data->sink = sink;
      data->sink_pad = g_strdup (sink_pad);
      data->caps = gst_caps_ref (caps);
      data->signal_id = g_signal_connect (G_OBJECT (src), "new_pad", 
					  G_CALLBACK (gst_parse_found_pad), data);
      return TRUE;
    }
    templs = g_list_next (templs);
  }
  return FALSE;
}
/**
 * performs a link and frees the struct. src and sink elements must be given
 * return values   0 - link performed
 *                 1 - link delayed
 *                <0 - error
 */
static gint
gst_parse_perform_link (link_t *link, graph_t *graph)
{
  GstElement *src = link->src;
  GstElement *sink = link->sink;
  GSList *srcs = link->src_pads;
  GSList *sinks = link->sink_pads;
  g_assert (GST_IS_ELEMENT (src));
  g_assert (GST_IS_ELEMENT (sink));
  
  GST_CAT_INFO (GST_CAT_PIPELINE, "linking %s(%s):%u to %s(%s):%u with caps \"%s\"", 
                GST_ELEMENT_NAME (src), link->src_name ? link->src_name : "---", g_slist_length (srcs),
                GST_ELEMENT_NAME (sink), link->sink_name ? link->sink_name : "---", g_slist_length (sinks),
	        link->caps ? gst_caps_to_string (link->caps) : "-");

  if (!srcs || !sinks) {
    if (gst_element_link_pads_filtered (src, srcs ? (const gchar *) srcs->data : NULL,
                                        sink, sinks ? (const gchar *) sinks->data : NULL,
					link->caps)) {
      gst_parse_element_lock (sink, gst_element_is_locked_state (src));
      goto success;
    } else {
      if (gst_parse_perform_delayed_link (src, srcs ? (const gchar *) srcs->data : NULL,
                                          sink, sinks ? (const gchar *) sinks->data : NULL,
					  link->caps)) {
        gst_parse_element_lock (sink, TRUE);
	goto success;
      } else {
        goto error;
      }
    }
  }
  if (g_slist_length (link->src_pads) != g_slist_length (link->src_pads)) {
    goto error;
  }
  while (srcs && sinks) {
    const gchar *src_pad = (const gchar *) srcs->data;
    const gchar *sink_pad = (const gchar *) sinks->data;
    srcs = g_slist_next (srcs);
    sinks = g_slist_next (sinks);
    if (gst_element_link_pads_filtered (src, src_pad, sink, sink_pad, link->caps)) {
      gst_parse_element_lock (sink, gst_element_is_locked_state (src));
      continue;
    } else {
      if (gst_parse_perform_delayed_link (src, src_pad,
                                          sink, sink_pad,
					  link->caps)) {
        gst_parse_element_lock (sink, TRUE);
	continue;
      } else {
        goto error;
      }
    }
  }
  
success:
  gst_parse_free_link (link);
  return 0;
  
error:
  ERROR (GST_PARSE_ERROR_LINK, "could not link %s to %s", GST_ELEMENT_NAME (src), GST_ELEMENT_NAME (sink));
  gst_parse_free_link (link);
  return -1;
}


static int yylex (void *lvalp);
static int yyerror (const char *s);


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 526 "./grammar.y"
typedef union YYSTYPE {
    gchar *s;
    chain_t *c;
    link_t *l;
    GstElement *e;
    GSList *p;
    graph_t *g;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 635 "grammar.tab.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 647 "grammar.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  28
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   182

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  17
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  12
/* YYNRULES -- Number of rules. */
#define YYNRULES  35
/* YYNRULES -- Number of states. */
#define YYNSTATES  50

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   263

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    15,     2,     2,     2,     2,     2,     2,
      11,    12,     2,     2,    13,     2,    14,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    16,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     9,     2,    10,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned char yyprhs[] =
{
       0,     0,     3,     5,     8,     9,    12,    17,    22,    27,
      31,    35,    39,    44,    49,    54,    56,    59,    62,    66,
      68,    71,    73,    75,    76,    80,    82,    85,    88,    90,
      92,    95,    98,   101,   104,   105
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const yysigned_char yyrhs[] =
{
      28,     0,    -1,     3,    -1,    18,     7,    -1,    -1,    19,
       7,    -1,     9,    19,    27,    10,    -1,    11,    19,    27,
      12,    -1,     4,    19,    27,    12,    -1,     9,    19,    10,
      -1,    11,    19,    10,    -1,     4,    19,    12,    -1,     9,
      19,     1,    10,    -1,    11,    19,     1,    10,    -1,     4,
      19,     1,    12,    -1,     5,    -1,     5,    22,    -1,    13,
       3,    -1,    13,     3,    22,    -1,     6,    -1,     6,    22,
      -1,    23,    -1,    21,    -1,    -1,    24,     8,    24,    -1,
      25,    -1,    25,    26,    -1,    26,     1,    -1,    18,    -1,
      20,    -1,    27,    27,    -1,    25,    27,    -1,    27,    26,
      -1,    27,     1,    -1,    -1,    27,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   558,   558,   565,   570,   571,   573,   574,   575,   578,
     579,   580,   583,   584,   585,   590,   591,   595,   596,   599,
     600,   603,   604,   605,   608,   623,   624,   625,   628,   633,
     634,   673,   688,   718,   721,   724
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "IDENTIFIER", "BINREF", "PADREF", "REF", 
  "ASSIGNMENT", "LINK", "'{'", "'}'", "'('", "')'", "','", "'.'", "'!'", 
  "'='", "$accept", "element", "assignments", "bin", "pads", "padlist", 
  "reference", "linkpart", "link", "linklist", "chain", "graph", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   123,
     125,    40,    41,    44,    46,    33,    61
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    17,    18,    18,    19,    19,    20,    20,    20,    20,
      20,    20,    20,    20,    20,    21,    21,    22,    22,    23,
      23,    24,    24,    24,    25,    26,    26,    26,    27,    27,
      27,    27,    27,    27,    28,    28
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     2,     0,     2,     4,     4,     4,     3,
       3,     3,     4,     4,     4,     1,     2,     2,     3,     1,
       2,     1,     1,     0,     3,     1,     2,     2,     1,     1,
       2,     2,     2,     2,     0,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
      23,     2,     4,    15,    19,     4,     4,    28,    29,    22,
      21,     0,    23,     0,     0,     0,     0,    16,    20,     0,
       0,     3,    23,     0,    33,    25,     0,     0,     1,     0,
       5,    11,     0,    17,     0,     9,     0,     0,    10,     0,
      24,     0,    27,    14,     8,    18,    12,     6,    13,     7
};

/* YYDEFGOTO[NTERM-NUM]. */
static const yysigned_char yydefgoto[] =
{
      -1,     7,    15,     8,     9,    17,    10,    11,    25,    26,
      27,    14
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -12
static const short yypact[] =
{
     122,   -12,   -12,   -11,   -11,   -12,   -12,     4,   -12,   -12,
     -12,    -2,   171,    91,     9,    78,     7,   -12,   -12,   131,
     142,   -12,    -1,    27,   -12,   162,    40,    53,   -12,     0,
     -12,   -12,   100,   -11,    14,   -12,   153,    15,   -12,   112,
     -12,    66,   -12,   -12,   -12,   -12,   -12,   -12,   -12,   -12
};

/* YYPGOTO[NTERM-NUM].  */
static const yysigned_char yypgoto[] =
{
     -12,   -12,     2,   -12,   -12,    -4,   -12,    -8,     3,    -6,
       1,   -12
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -36
static const yysigned_char yytable[] =
{
      18,    13,    16,    12,     3,     4,    22,    19,    20,    28,
      33,    21,    43,    23,    40,    12,    32,     0,    12,    41,
      36,    39,    12,    12,    46,    48,    23,   -31,    24,    45,
       1,     2,     3,     4,     0,   -23,     5,   -31,     6,   -31,
     -32,    42,     0,   -32,   -32,   -32,   -32,     0,   -32,   -32,
     -32,   -32,   -32,   -30,    24,     0,     1,     2,     3,     4,
       0,   -23,     5,   -30,     6,   -30,   -26,    42,     0,   -26,
     -26,   -26,   -26,     0,   -26,   -26,   -26,   -26,   -26,    29,
       0,     1,     2,     3,     4,    30,   -23,     5,     0,     6,
      31,   -35,    24,     0,     1,     2,     3,     4,     0,   -23,
       5,    24,     6,     1,     2,     3,     4,     0,   -23,     5,
       0,     6,    44,    24,     0,     1,     2,     3,     4,     0,
     -23,     5,   -34,     6,    49,     1,     2,     3,     4,     0,
       0,     5,    34,     6,     1,     2,     3,     4,    30,   -23,
       5,    35,     6,    37,     0,     1,     2,     3,     4,    30,
     -23,     5,    38,     6,    24,     0,     1,     2,     3,     4,
       0,   -23,     5,    47,     6,     1,     2,     3,     4,     0,
     -23,     5,     0,     6,     1,     2,     3,     4,     0,     0,
       5,     0,     6
};

static const yysigned_char yycheck[] =
{
       4,     0,    13,     0,     5,     6,     8,     5,     6,     0,
       3,     7,    12,    12,    22,    12,    15,    -1,    15,    25,
      19,    20,    19,    20,    10,    10,    25,     0,     1,    33,
       3,     4,     5,     6,    -1,     8,     9,    10,    11,    12,
       0,     1,    -1,     3,     4,     5,     6,    -1,     8,     9,
      10,    11,    12,     0,     1,    -1,     3,     4,     5,     6,
      -1,     8,     9,    10,    11,    12,     0,     1,    -1,     3,
       4,     5,     6,    -1,     8,     9,    10,    11,    12,     1,
      -1,     3,     4,     5,     6,     7,     8,     9,    -1,    11,
      12,     0,     1,    -1,     3,     4,     5,     6,    -1,     8,
       9,     1,    11,     3,     4,     5,     6,    -1,     8,     9,
      -1,    11,    12,     1,    -1,     3,     4,     5,     6,    -1,
       8,     9,     0,    11,    12,     3,     4,     5,     6,    -1,
      -1,     9,     1,    11,     3,     4,     5,     6,     7,     8,
       9,    10,    11,     1,    -1,     3,     4,     5,     6,     7,
       8,     9,    10,    11,     1,    -1,     3,     4,     5,     6,
      -1,     8,     9,    10,    11,     3,     4,     5,     6,    -1,
       8,     9,    -1,    11,     3,     4,     5,     6,    -1,    -1,
       9,    -1,    11
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,     3,     4,     5,     6,     9,    11,    18,    20,    21,
      23,    24,    25,    27,    28,    19,    13,    22,    22,    19,
      19,     7,     8,    27,     1,    25,    26,    27,     0,     1,
       7,    12,    27,     3,     1,    10,    27,     1,    10,    27,
      24,    26,     1,    12,    12,    22,    10,    10,    10,    12
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  /* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;

  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 558 "./grammar.y"
    { yyval.e = gst_element_factory_make (yyvsp[0].s, NULL); 
						if (!yyval.e)
						  ERROR (GST_PARSE_ERROR_NO_SUCH_ELEMENT, "No element \"%s\"", yyvsp[0].s);
						gst_parse_strfree (yyvsp[0].s);
						if (!yyval.e)
						  YYERROR;
                                              ;}
    break;

  case 3:
#line 565 "./grammar.y"
    { gst_parse_element_set (yyvsp[0].s, yyvsp[-1].e, graph);
						yyval.e = yyvsp[-1].e;
	                                      ;}
    break;

  case 4:
#line 570 "./grammar.y"
    { yyval.p = NULL; ;}
    break;

  case 5:
#line 571 "./grammar.y"
    { yyval.p = g_slist_prepend (yyvsp[-1].p, yyvsp[0].s); ;}
    break;

  case 6:
#line 573 "./grammar.y"
    { GST_BIN_MAKE (yyval.c, "thread", yyvsp[-1].c, yyvsp[-2].p); ;}
    break;

  case 7:
#line 574 "./grammar.y"
    { GST_BIN_MAKE (yyval.c, "bin", yyvsp[-1].c, yyvsp[-2].p); ;}
    break;

  case 8:
#line 575 "./grammar.y"
    { GST_BIN_MAKE (yyval.c, yyvsp[-3].s, yyvsp[-1].c, yyvsp[-2].p); 
						gst_parse_strfree (yyvsp[-3].s);
					      ;}
    break;

  case 9:
#line 578 "./grammar.y"
    { GST_BIN_MAKE (yyval.c, "thread", NULL, yyvsp[-1].p); ;}
    break;

  case 10:
#line 579 "./grammar.y"
    { GST_BIN_MAKE (yyval.c, "thread", NULL, yyvsp[-1].p); ;}
    break;

  case 11:
#line 580 "./grammar.y"
    { GST_BIN_MAKE (yyval.c, yyvsp[-2].s, NULL, yyvsp[-1].p); 
						gst_parse_strfree (yyvsp[-2].s);
					      ;}
    break;

  case 12:
#line 583 "./grammar.y"
    { GST_BIN_MAKE (yyval.c, "thread", NULL, yyvsp[-2].p); ;}
    break;

  case 13:
#line 584 "./grammar.y"
    { GST_BIN_MAKE (yyval.c, "thread", NULL, yyvsp[-2].p); ;}
    break;

  case 14:
#line 585 "./grammar.y"
    { GST_BIN_MAKE (yyval.c, yyvsp[-3].s, NULL, yyvsp[-2].p); 
						gst_parse_strfree (yyvsp[-3].s);
					      ;}
    break;

  case 15:
#line 590 "./grammar.y"
    { yyval.p = g_slist_prepend (NULL, yyvsp[0].s); ;}
    break;

  case 16:
#line 591 "./grammar.y"
    { yyval.p = yyvsp[0].p;
						yyval.p = g_slist_prepend (yyval.p, yyvsp[-1].s);
					      ;}
    break;

  case 17:
#line 595 "./grammar.y"
    { yyval.p = g_slist_prepend (NULL, yyvsp[0].s); ;}
    break;

  case 18:
#line 596 "./grammar.y"
    { yyval.p = g_slist_prepend (yyvsp[0].p, yyvsp[-1].s); ;}
    break;

  case 19:
#line 599 "./grammar.y"
    { MAKE_REF (yyval.l, yyvsp[0].s, NULL); ;}
    break;

  case 20:
#line 600 "./grammar.y"
    { MAKE_REF (yyval.l, yyvsp[-1].s, yyvsp[0].p); ;}
    break;

  case 21:
#line 603 "./grammar.y"
    { yyval.l = yyvsp[0].l; ;}
    break;

  case 22:
#line 604 "./grammar.y"
    { MAKE_REF (yyval.l, NULL, yyvsp[0].p); ;}
    break;

  case 23:
#line 605 "./grammar.y"
    { MAKE_REF (yyval.l, NULL, NULL); ;}
    break;

  case 24:
#line 608 "./grammar.y"
    { yyval.l = yyvsp[-2].l;
						if (yyvsp[-1].s) {
						  yyval.l->caps = gst_caps_from_string (yyvsp[-1].s);
						  if (!yyval.l->caps)
						    ERROR (GST_PARSE_ERROR_LINK, "could not parse caps \"%s\"", yyvsp[-1].s);
						  gst_parse_strfree (yyvsp[-1].s);
						  gst_caps_ref(yyval.l->caps);
						  gst_caps_sink(yyval.l->caps);
						}
						yyval.l->sink_name = yyvsp[0].l->src_name;
						yyval.l->sink_pads = yyvsp[0].l->src_pads;
						gst_parse_link_free (yyvsp[0].l);
					      ;}
    break;

  case 25:
#line 623 "./grammar.y"
    { yyval.p = g_slist_prepend (NULL, yyvsp[0].l); ;}
    break;

  case 26:
#line 624 "./grammar.y"
    { yyval.p = g_slist_prepend (yyvsp[0].p, yyvsp[-1].l); ;}
    break;

  case 27:
#line 625 "./grammar.y"
    { yyval.p = yyvsp[-1].p; ;}
    break;

  case 28:
#line 628 "./grammar.y"
    { yyval.c = gst_parse_chain_new ();
						yyval.c->first = yyval.c->last = yyvsp[0].e;
						yyval.c->front = yyval.c->back = NULL;
						yyval.c->elements = g_slist_prepend (NULL, yyvsp[0].e);
					      ;}
    break;

  case 29:
#line 633 "./grammar.y"
    { yyval.c = yyvsp[0].c; ;}
    break;

  case 30:
#line 634 "./grammar.y"
    { if (yyvsp[-1].c->back && yyvsp[0].c->front) {
						  if (!yyvsp[-1].c->back->sink_name) {
						    ERROR (GST_PARSE_ERROR_LINK, "link without source element");
						    gst_parse_free_link (yyvsp[-1].c->back);
						  } else {
						    ((graph_t *) graph)->links = g_slist_prepend (((graph_t *) graph)->links, yyvsp[-1].c->back);
						  }
						  if (!yyvsp[0].c->front->src_name) {
						    ERROR (GST_PARSE_ERROR_LINK, "link without sink element");
						    gst_parse_free_link (yyvsp[0].c->front);
						  } else {
						    ((graph_t *) graph)->links = g_slist_prepend (((graph_t *) graph)->links, yyvsp[0].c->front);
						  }
						  yyvsp[-1].c->back = NULL;
						} else if (yyvsp[-1].c->back) {
						  if (!yyvsp[-1].c->back->sink_name) {
						    yyvsp[-1].c->back->sink = yyvsp[0].c->first;
						  }
						} else if (yyvsp[0].c->front) {
						  if (!yyvsp[0].c->front->src_name) {
						    yyvsp[0].c->front->src = yyvsp[-1].c->last;
						  }
						  yyvsp[-1].c->back = yyvsp[0].c->front;
						}
						
						if (yyvsp[-1].c->back) {
						  if (!yyvsp[-1].c->back->sink || !yyvsp[-1].c->back->src) {
						    ((graph_t *) graph)->links = g_slist_prepend (((graph_t *) graph)->links, yyvsp[-1].c->back);
						    yyvsp[-1].c->back = NULL;
						  } else {
						    gst_parse_perform_link (yyvsp[-1].c->back, (graph_t *) graph);
						  }
						}
						yyvsp[-1].c->last = yyvsp[0].c->last;
						yyvsp[-1].c->back = yyvsp[0].c->back;
						yyvsp[-1].c->elements = g_slist_concat (yyvsp[-1].c->elements, yyvsp[0].c->elements);
						gst_parse_chain_free (yyvsp[0].c);
						yyval.c = yyvsp[-1].c;
					      ;}
    break;

  case 31:
#line 673 "./grammar.y"
    { if (yyvsp[0].c->front) {
						  if (!yyvsp[0].c->front->src_name) {
						    ERROR (GST_PARSE_ERROR_LINK, "link without source element");
						    gst_parse_free_link (yyvsp[0].c->front);
						  } else {
						    ((graph_t *) graph)->links = g_slist_prepend (((graph_t *) graph)->links, yyvsp[0].c->front);
						  }
						}
						if (!yyvsp[-1].l->sink_name) {
						  yyvsp[-1].l->sink = yyvsp[0].c->first;
						}
						yyvsp[0].c->front = yyvsp[-1].l;
						yyval.c = yyvsp[0].c;
					      ;}
    break;

  case 32:
#line 688 "./grammar.y"
    { GSList *walk;
						if (yyvsp[-1].c->back) {
						  yyvsp[0].p = g_slist_prepend (yyvsp[0].p, yyvsp[-1].c->back);
						  yyvsp[-1].c->back = NULL;
						} else {
						  if (!((link_t *) yyvsp[0].p->data)->src_name) {
						    ((link_t *) yyvsp[0].p->data)->src = yyvsp[-1].c->last;
						  }						  
						}
						walk = yyvsp[0].p;
						while (walk) {
						  link_t *link = (link_t *) walk->data;
						  walk = walk->next;
						  if (!link->sink_name && walk) {
						    ERROR (GST_PARSE_ERROR_LINK, "link without sink element");
						    gst_parse_free_link (link);
						  } else if (!link->src_name && !link->src) {
						    ERROR (GST_PARSE_ERROR_LINK, "link without source element");
						    gst_parse_free_link (link);
						  } else {
						    if (walk) {
						      ((graph_t *) graph)->links = g_slist_prepend (((graph_t *) graph)->links, link);
						    } else {
						      yyvsp[-1].c->back = link;
						    }
						  }
						}
						g_slist_free (yyvsp[0].p);
						yyval.c = yyvsp[-1].c;
					      ;}
    break;

  case 33:
#line 718 "./grammar.y"
    { yyval.c = yyvsp[-1].c; ;}
    break;

  case 34:
#line 721 "./grammar.y"
    { ERROR (GST_PARSE_ERROR_EMPTY, "Empty pipeline not allowed");
						yyval.g = (graph_t *) graph;
					      ;}
    break;

  case 35:
#line 724 "./grammar.y"
    { yyval.g = (graph_t *) graph;
						if (yyvsp[0].c->front) {
						  if (!yyvsp[0].c->front->src_name) {
						    ERROR (GST_PARSE_ERROR_LINK, "link without source element");
						    gst_parse_free_link (yyvsp[0].c->front);
						  } else {
						    yyval.g->links = g_slist_prepend (yyval.g->links, yyvsp[0].c->front);
						  }
						  yyvsp[0].c->front = NULL;
						}
						if (yyvsp[0].c->back) {
						  if (!yyvsp[0].c->back->sink_name) {
						    ERROR (GST_PARSE_ERROR_LINK, "link without sink element");
						    gst_parse_free_link (yyvsp[0].c->back);
						  } else {
						    yyval.g->links = g_slist_prepend (yyval.g->links, yyvsp[0].c->back);
						  }
						  yyvsp[0].c->back = NULL;
						}
						yyval.g->chain = yyvsp[0].c;
					      ;}
    break;


    }

/* Line 999 of yacc.c.  */
#line 1888 "grammar.tab.c"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("syntax error, unexpected ") + 1;
	  yysize += yystrlen (yytname[yytype]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* Return failure if at end of input.  */
      if (yychar == YYEOF)
        {
	  /* Pop the error token.  */
          YYPOPSTACK;
	  /* Pop the rest of the stack.  */
	  while (yyss < yyssp)
	    {
	      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
	      yydestruct (yystos[*yyssp], yyvsp);
	      YYPOPSTACK;
	    }
	  YYABORT;
        }

      YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
      yydestruct (yytoken, &yylval);
      yychar = YYEMPTY;

    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*----------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action.  |
`----------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      yyvsp--;
      yystate = *--yyssp;

      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 747 "./grammar.y"


extern FILE *_gst_parse_yyin;
int _gst_parse_yylex (YYSTYPE *lvalp);

static int yylex (void *lvalp) {
    return _gst_parse_yylex ((YYSTYPE*) lvalp);
}

static int
yyerror (const char *s)
{
  /* FIXME: This should go into the GError somehow, but how? */
  g_warning ("error: %s\n", s);
  return -1;
}

int _gst_parse_yy_scan_string (char*);
GstElement *
_gst_parse_launch (const gchar *str, GError **error)
{
  graph_t g;
  gchar *dstr;
  GSList *walk;
  GstBin *bin = NULL;
  GstElement *ret;
  
  g_return_val_if_fail (str != NULL, NULL);

  g.chain = NULL;
  g.links = NULL;
  g.error = error;
  
#ifdef __GST_PARSE_TRACE
  GST_CAT_DEBUG (GST_CAT_PIPELINE, "TRACE: tracing enabled");
  __strings = __chains = __links = 0;
#endif /* __GST_PARSE_TRACE */

  dstr = g_strdup (str);
  _gst_parse_yy_scan_string (dstr);

#ifdef GST_DEBUG_ENABLED
  yydebug = 1;
#endif

  if (yyparse (&g) != 0) {
    SET_ERROR (error, GST_PARSE_ERROR_SYNTAX, "Unrecoverable syntax error while parsing pipeline");
    
    goto error1;
  }
  g_free (dstr);
  
  GST_CAT_INFO (GST_CAT_PIPELINE, "got %u elements and %u links", g.chain ? g_slist_length (g.chain->elements) : 0, g_slist_length (g.links));
  
  if (!g.chain) {
    ret = NULL;
  } else if (!(((chain_t *) g.chain)->elements->next)) {
    /* only one toplevel element */  
    ret = (GstElement *) ((chain_t *) g.chain)->elements->data;
    g_slist_free (((chain_t *) g.chain)->elements);
    if (GST_IS_BIN (ret))
      bin = GST_BIN (ret);
  } else {  
    /* put all elements in our bin */
    bin = GST_BIN (gst_element_factory_make ("pipeline", NULL));
    g_assert (bin);
    walk = g.chain->elements;
    while (walk) {
      gst_bin_add (bin, GST_ELEMENT (walk->data));
      walk = g_slist_next (walk);  
    }
    g_slist_free (g.chain->elements);
    ret = GST_ELEMENT (bin);
  }
  gst_parse_chain_free (g.chain);
  
  /* remove links */
  walk = g.links;
  while (walk) {
    link_t *l = (link_t *) walk->data;
    GstElement *sink;
    walk = g_slist_next (walk);
    if (!l->src) {
      if (l->src_name) {
        if (bin) {
          l->src = gst_bin_get_by_name_recurse_up (bin, l->src_name);
        } else {
          l->src = strcmp (GST_ELEMENT_NAME (ret), l->src_name) == 0 ? ret : NULL;
        }
      }
      if (!l->src) {
        SET_ERROR (error, GST_PARSE_ERROR_NO_SUCH_ELEMENT, "No element named \"%s\" - omitting link", l->src_name);
        gst_parse_free_link (l);
        continue;
      }
    }
    if (!l->sink) {
      if (l->sink_name) {
        if (bin) {
          l->sink = gst_bin_get_by_name_recurse_up (bin, l->sink_name);
        } else {
          l->sink = strcmp (GST_ELEMENT_NAME (ret), l->sink_name) == 0 ? ret : NULL;
        }
      }
      if (!l->sink) {
        SET_ERROR (error, GST_PARSE_ERROR_NO_SUCH_ELEMENT, "No element named \"%s\" - omitting link", l->sink_name);
        gst_parse_free_link (l);
        continue;
      }
    }
    sink = l->sink;
    gst_parse_perform_link (l, &g);
  }
  g_slist_free (g.links);

out:
#ifdef __GST_PARSE_TRACE
  GST_CAT_DEBUG (GST_CAT_PIPELINE, "TRACE: %u strings, %u chains and %u links left", __strings, __chains, __links);
  if (__strings || __chains || __links) {
    g_warning ("TRACE: %u strings, %u chains and %u links left", __strings, __chains, __links);
  }
#endif /* __GST_PARSE_TRACE */

  return ret;
  
error1:
  g_free (dstr);
  
  if (g.chain) {
    walk = g.chain->elements;
    while (walk) {
      gst_object_unref (GST_OBJECT (walk->data));
      walk = walk->next;
    }
    g_slist_free (g.chain->elements);
  }
  gst_parse_chain_free (g.chain);
  
  walk = g.links;
  while (walk) {
    gst_parse_free_link ((link_t *) walk->data);
    walk = walk->next;
  }
  g_slist_free (g.links);
  
  g_assert (*error);
  ret = NULL;
  
  goto out;
}

