// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_STRUCTURE_H
#define _GSTREAMERMM_STRUCTURE_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/clock.h>
#include <gstreamermm/enums.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _GstStructure GstStructure; }
#endif

namespace Gst
{

class Structure
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Structure CppObjectType;
  typedef GstStructure BaseObjectType;

  static GType get_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  Structure();

  explicit Structure(GstStructure* gobject, bool make_a_copy = true);

  Structure(const Structure& other);
  Structure& operator=(const Structure& other);

  ~Structure();

  void swap(Structure& other);

  ///Provides access to the underlying C instance.
  GstStructure*       gobj()       { return gobject_; }

  ///Provides access to the underlying C instance.
  const GstStructure* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  GstStructure* gobj_copy() const;

protected:
  GstStructure* gobject_;

private:


public:
  typedef sigc::slot<bool, GQuark, const GValue*> ForeachSlot;
  typedef sigc::slot<bool, GQuark, GValue*> MapSlot;

public:
  Structure(const Glib::ustring& name);

  
  int size() const;
  
  void clear();

  
  void set_field(const Glib::ustring& fieldname, const Glib::ValueBase& value);

  void get_field(const Glib::ustring& fieldname, Glib::ValueBase& value) const;

  
  void remove_field(const Glib::ustring& fieldname);
  
  GType get_field_type(const Glib::ustring& fieldname) const;

  bool foreach(const ForeachSlot& slot);

  
  bool has_field(const Glib::ustring& fieldname) const;
  
  bool has_field(const Glib::ustring& fieldname, GType type) const;

  bool get_boolean(const Glib::ustring& fieldname, Glib::ValueBase& value) const;

  bool get_int(const Glib::ustring& fieldname, Glib::ValueBase& value) const;

  bool get_uint(const Glib::ustring& fieldname, Glib::ValueBase& value) const;

  bool get_fourcc(const Glib::ustring& fieldname, Glib::ValueBase& value) const;

  bool get_double(const Glib::ustring& fieldname, Glib::ValueBase& value) const;

  bool get_string(const Glib::ustring& fieldname, Glib::ValueBase& value) const;

  bool get_date(const Glib::ustring& fieldname, Glib::Date& value) const;

  bool get_clock_time(const Glib::ustring& fieldname, Glib::ValueBase& value) const;

  bool get_enum(const Glib::ustring& fieldname, GType enumtype, Glib::ValueBase& value) const;

  bool get_fraction(const Glib::ustring& fieldname, int& value_numerator, int& value_denominator) const;

  bool map_in_place(const MapSlot& slot);

  static Structure create_from_string(const Glib::ustring& the_string);

  
  Glib::QueryQuark get_name_id() const;
  
  Glib::ustring get_name() const;
  
  bool has_name(const Glib::ustring& name) const;
  
  void set_name(const Glib::ustring& name);
  
  Glib::ustring to_string() const;
  
  Glib::ustring nth_field_name(guint index) const;
  

};

} //namespace Gst


namespace Gst
{

/** @relates Gst::Structure
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 */
inline void swap(Structure& lhs, Structure& rhs)
  { lhs.swap(rhs); }

} // namespace Gst

namespace Glib
{

/** A Glib::wrap() method for this object.
 * 
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gst::Structure
 */
Gst::Structure wrap(GstStructure* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gst::Structure> : public Glib::Value_Boxed<Gst::Structure>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _GSTREAMERMM_STRUCTURE_H */

