// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_BIN_H
#define _GSTREAMERMM_BIN_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/element.h>
#include <gstreamermm/enums.h>
#include <gstreamermm/childproxy.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstBin GstBin;
typedef struct _GstBinClass GstBinClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class Bin_Class; } // namespace Gst
namespace Gst
{

class Pad;


class Bin
: public Element,
  public ChildProxy
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Bin CppObjectType;
  typedef Bin_Class CppClassType;
  typedef GstBin BaseObjectType;
  typedef GstBinClass BaseClassType;

private:  friend class Bin_Class;
  static CppClassType bin_class_;

private:
  // noncopyable
  Bin(const Bin&);
  Bin& operator=(const Bin&);

protected:
  explicit Bin(const Glib::ConstructParams& construct_params);
  explicit Bin(GstBin* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Bin();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstBin*       gobj()       { return reinterpret_cast<GstBin*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstBin* gobj() const { return reinterpret_cast<GstBin*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstBin* gobj_copy();

private:

  
protected:
  Bin();

public:
  //TODO: Why doesn't this use _WRAP_CREATE()?
  static Glib::RefPtr<Bin> create(const Glib::ustring& name);

  //TODO: Why do these throw exceptions?
  //If there is a good reason for it, document that in comments and doxygen documentation. murrayc.
  Glib::RefPtr<Bin> add(const Glib::RefPtr<Element>& element);
  Glib::RefPtr<Bin> remove(const Glib::RefPtr<Element>& element);

  
  /** Gets the element with the given name from a bin. This
   * function recurses into child bins.
   * 
   * Returns: the Gst::Element with the given name, or <tt>0</tt>
   * @param name The element name to search for.
   * @return The Gst::Element with the given name, or <tt>0</tt>.
   */
  Glib::RefPtr<Element> get_element(const Glib::ustring& name);
  
  /** Gets the element with the given name from this bin. If the
   * element is not found, a recursion is performed on the parent bin.
   * 
   * Returns: the Gst::Element with the given name, or <tt>0</tt>
   * @param name The element name to search for.
   * @return The Gst::Element with the given name, or <tt>0</tt>.
   */
  Glib::RefPtr<Element> get_element_recurse_up(const Glib::ustring& name);
  
  /** Looks for an element inside the bin that implements the given
   * interface. If such an element is found, it returns the element.
   * You can cast this element to the given interface afterwards.  If you want
   * all elements that implement the interface, use
   * iterate_all_by_interface(). This function recurses into child bins.
   * 
   * MT safe.  Caller owns returned reference.
   * @param iface The Type of an interface.
   * @return A Gst::Element inside the bin implementing the interface.
   */
  Glib::RefPtr<Element> get_element(GType interface);
  
  /** Recursively looks for elements with an unconnected pad of the given
   * direction within the specified bin and returns an unconnected pad
   * if one is found, or <tt>0</tt> otherwise. If a pad is found, the caller
   * owns a reference to it and should use Gst::Object::unref() on the
   * pad when it is not needed any longer.
   * @param direction Whether to look for an unconnected source or sink pad.
   * @return Unconnected pad of the given direction, or <tt>0</tt>.
   * 
   * Since: 0.10.3.
   */
  Glib::RefPtr<Pad> find_unconnected_pad(PadDirection dir);

  
  /**
   * @par Prototype:
   * <tt>void on_my_%element_added(const Glib::RefPtr<Element>& element)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Element>& > signal_element_added();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%element_removed(const Glib::RefPtr<Element>& element)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Element>& > signal_element_removed();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The bin will handle Asynchronous state changes.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_async_handling() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The bin will handle Asynchronous state changes.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_async_handling() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_element_added(const Glib::RefPtr<Element>& element);
  virtual void on_element_removed(const Glib::RefPtr<Element>& element);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} //namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Bin
   */
  Glib::RefPtr<Gst::Bin> wrap(GstBin* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_BIN_H */

