// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_BUFFER_H
#define _GSTREAMERMM_BUFFER_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/miniobject.h>
#include <gstreamermm/wrap.h>
#include <gstreamermm/enums.h>
#include <gstreamermm/caps.h>
#include <gstreamermm/clock.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstBuffer GstBuffer;
typedef struct _GstBufferClass GstBufferClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class Buffer_Class; } // namespace Gst
namespace Gst
{


class Buffer : public MiniObject
{
protected:
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Buffer CppObjectType;
  typedef Buffer_Class CppClassType;
  typedef GstBuffer BaseObjectType;
  typedef GstBufferClass BaseClassType;

private:  friend class Buffer_Class;
  static CppClassType buffer_class_;

private:
  // noncopyable
  Buffer(const Buffer&);
  Buffer& operator=(const Buffer&);

protected:
  explicit Buffer(GstBuffer* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Buffer();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GstMiniObject.
  GstBuffer*       gobj()       { return reinterpret_cast<GstBuffer*>(gobject_); }

  ///Provides access to the underlying C GstMiniObject.
  const GstBuffer* gobj() const { return reinterpret_cast<GstBuffer*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstBuffer* gobj_copy();

private:


public:
  static Glib::RefPtr<Buffer> create(const guint& size);

  
  guint get_flags() const;
  
  bool is_set_flag(BufferFlag flag) const;
  
  void set_flag(BufferFlag flag);
  
  void unset_flag(BufferFlag flag);

  
  Glib::RefPtr<Buffer> copy() const;

  
  /** Copies the metadata from @a src into @a dest. The data, size and mallocdata
   * fields are not copied.
   * 
   *  @a flags indicate which fields will be copied. Use Gst::BUFFER_COPY_ALL to copy
   * all the metadata fields.
   * 
   * This function is typically called from a custom buffer copy function after
   * creating @a dest and setting the data, size, mallocdata.
   * 
   * Since: 0.10.13
   * @param src A source Gst::Buffer.
   * @param flags Flags indicating what metadata fields should be copied.
   */
  void copy_metadata(const Glib::RefPtr<Buffer>& source_buffer, BufferCopyFlags flags);

  
  /** Similar to gst_buffer_is_writable, but this only ensures that the
   * refcount of the buffer is 1, indicating that the caller is the sole
   * owner and can change the buffer metadata, such as caps and timestamps.
   * @return <tt>true</tt> if the metadata is writable.
   */
  bool is_metadata_writable() const;

  //This is not const because it sometimes returns the same buffer:
  
  Glib::RefPtr<Buffer> make_writable();

  //This is const because it always returns a new buffer:
  
  /** Similar to gst_buffer_make_writable, but does not ensure that the buffer
   * data array is writable. Instead, this just ensures that the returned buffer
   * is solely owned by the caller, by creating a subbuffer of the original
   * buffer if necessary.
   * 
   * After calling this function, @a buf should not be referenced anymore. The
   * result of this function has guaranteed writable metadata.
   * @return A new Gst::Buffer with writable metadata.
   */
  Glib::RefPtr<Buffer> make_metadata_writable() const;

  // TODO: Do we need to hand code this to throw an exception when the C API returns NULL ?
  
  /** Gets the media type of the buffer. This can be <tt>0</tt> if there
   * is no media type attached to this buffer.
   * 
   * Returns <tt>0</tt> if there were no caps on this buffer.
   * @return <tt>0</tt> if there were no caps on this buffer.
   */
  Glib::RefPtr<Caps> get_caps();
  
  /** Gets the media type of the buffer. This can be <tt>0</tt> if there
   * is no media type attached to this buffer.
   * 
   * Returns <tt>0</tt> if there were no caps on this buffer.
   * @return <tt>0</tt> if there were no caps on this buffer.
   */
  Glib::RefPtr<Caps const> get_caps() const;

  
  /** Sets the media type on the buffer. The refcount of the caps will
   * be increased and any previous caps on the buffer will be
   * unreffed.
   * @param caps A Gst::Caps.
   */
  void set_caps(const Glib::RefPtr<Caps>& caps);

  // TODO: Do we need to hand code this to throw an exception when the C API returns NULL ?
  
  /** Creates a sub-buffer from @a parent at @a offset and @a size.
   * This sub-buffer uses the actual memory space of the parent buffer.
   * This function will copy the offset and timestamp fields when the
   * offset is 0. If not, they will be set to Gst::CLOCK_TIME_NONE and 
   * Gst::BUFFER_OFFSET_NONE.
   * If @a offset equals 0 and @a size equals the total size of @a buffer, the
   * duration and offset end fields are also copied. If not they will be set
   * to Gst::CLOCK_TIME_NONE and Gst::BUFFER_OFFSET_NONE.
   * 
   * MT safe.
   * Returns <tt>0</tt> if the arguments were invalid.
   * @param offset The offset into parent Gst::Buffer at which the new sub-buffer 
   * begins.
   * @param size The size of the new Gst::Buffer sub-buffer, in bytes.
   * @return <tt>0</tt> if the arguments were invalid.
   */
  Glib::RefPtr<Buffer> create_sub(const guint& offset, const guint& size);
  
  /** Creates a sub-buffer from @a parent at @a offset and @a size.
   * This sub-buffer uses the actual memory space of the parent buffer.
   * This function will copy the offset and timestamp fields when the
   * offset is 0. If not, they will be set to Gst::CLOCK_TIME_NONE and 
   * Gst::BUFFER_OFFSET_NONE.
   * If @a offset equals 0 and @a size equals the total size of @a buffer, the
   * duration and offset end fields are also copied. If not they will be set
   * to Gst::CLOCK_TIME_NONE and Gst::BUFFER_OFFSET_NONE.
   * 
   * MT safe.
   * Returns <tt>0</tt> if the arguments were invalid.
   * @param offset The offset into parent Gst::Buffer at which the new sub-buffer 
   * begins.
   * @param size The size of the new Gst::Buffer sub-buffer, in bytes.
   * @return <tt>0</tt> if the arguments were invalid.
   */
  Glib::RefPtr<Buffer const> create_sub(const guint& offset, const guint& size) const;

  
  /** Determines whether a span() can be done without copying
   * the contents, that is, whether the data areas are contiguous sub-buffers of 
   * the same buffer.
   * 
   * MT safe.
   * @param buf2 The second Gst::Buffer.
   * @return <tt>true</tt> if the buffers are contiguous,
   * <tt>false</tt> if a copy would be required.
   */
  bool is_span_fast(const Glib::RefPtr<Buffer>& other_buffer) const;

  //This is const because it always returns a new buffer:
  
  /** Creates a new buffer that consists of part of buf1 and buf2.
   * Logically, buf1 and buf2 are concatenated into a single larger
   * buffer, and a new buffer is created at the given offset inside
   * this space, with a given length.
   * 
   * If the two source buffers are children of the same larger buffer,
   * and are contiguous, the new buffer will be a child of the shared
   * parent, and thus no copying is necessary. you can use
   * is_span_fast() to determine if a memcpy will be needed.
   * 
   * MT safe.
   * Returns <tt>0</tt> if the arguments are invalid.
   * @param offset The offset in the first buffer from where the new
   * buffer should start.
   * @param buf2 The second source Gst::Buffer to merge.
   * @param len The total length of the new buffer.
   * @return <tt>0</tt> if the arguments are invalid.
   */
  Glib::RefPtr<Buffer> span(const guint32& offset, const Glib::RefPtr<Buffer>& other_buffer, const guint32& len) const;

  
  /** Create a new buffer that is the concatenation of the two source
   * buffers, and unrefs the original source buffers.
   * 
   * If the buffers point to contiguous areas of memory, the buffer
   * is created without copying the data.
   * @param buf2 The second source Gst::Buffer.
   * @return The new Gst::Buffer which is the concatenation of the source buffers.
   */
  Glib::RefPtr<Buffer> join(const Glib::RefPtr<Buffer>& other_buffer);

  //This is const because it always returns a new buffer:
  
  /** Create a new buffer that is the concatenation of the two source
   * buffers, and unrefs the original source buffers.
   * 
   * If the buffers point to contiguous areas of memory, the buffer
   * is created without copying the data.
   * @param buf2 The second source Gst::Buffer.
   * @return The new Gst::Buffer which is the concatenation of the source buffers.
   */
  Glib::RefPtr<Buffer> join(const Glib::RefPtr<Buffer>& other_buffer) const;

  //This is const because it always returns a new buffer: (TODO: though maybe not: see the documentation. murrayc)
  
  /** Create a new buffer that is the concatenation of the two source
   * buffers.  The original source buffers will not be modified or
   * unref'd.  Make sure you unref the source buffers if they are not used
   * anymore afterwards.
   * 
   * If the buffers point to contiguous areas of memory, the buffer
   * is created without copying the data.
   * @param buf2 The second source Gst::Buffer to merge.
   * @return The new Gst::Buffer which is the concatenation of the source buffers.
   */
  Glib::RefPtr<Buffer> merge(const Glib::RefPtr<Buffer>& other_buffer) const;

   guint8* get_data() const;
    guint get_size() const;
    ClockTime get_timestamp() const;
    ClockTime get_duration() const;
    guint64 get_offset() const;
    guint64 get_offset_end() const;
    guint8* get_malloc_data() const;
 
  
public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

}//namespace Gst


namespace Gst
{
  /** @relates Gst::Buffer
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gst::Buffer> wrap(GstBuffer* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_BUFFER_H */

