// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_CHILDPROXY_H
#define _GSTREAMERMM_CHILDPROXY_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gstchildproxy.h>
#include <glibmm/interface.h>
#include <gstreamermm/object.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstChildProxy GstChildProxy;
typedef struct _GstChildProxyClass GstChildProxyClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class ChildProxy_Class; } // namespace Gst
namespace Gst
{

/** ChildProxy — Interface for multi child elements.
 * This interface abstracts handling of property sets for child elements.
 * Imagine elements such as mixers or polyphonic generators. They all have
 * multiple Pad or some kind of voice objects. The element acts as a parent
 * for those child objects. Each child has the same properties.
 *
 * By implementing this interface the child properties can be accessed from
 * the parent element by using child_proxy_get() and child_proxy_set().
 *
 * Property names are written as "child-name::property-name". The whole naming
 * scheme is recursive. Thus "child1::child2::property" is valid too, if
 * "child1" also implements the ChildProxy interface.
 */

class ChildProxy : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef ChildProxy CppObjectType;
  typedef ChildProxy_Class CppClassType;
  typedef GstChildProxy BaseObjectType;
  typedef GstChildProxyInterface BaseClassType;

private:
  friend class ChildProxy_Class;
  static CppClassType childproxy_class_;

  // noncopyable
  ChildProxy(const ChildProxy&);
  ChildProxy& operator=(const ChildProxy&);

protected:
  ChildProxy(); // you must derive from this class

  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit ChildProxy(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit ChildProxy(GstChildProxy* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~ChildProxy();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstChildProxy*       gobj()       { return reinterpret_cast<GstChildProxy*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GstChildProxy* gobj() const { return reinterpret_cast<GstChildProxy*>(gobject_); }

private:


public:
  
  /** Gets the number of child objects this parent contains.
   * @return The number of child objects
   * 
   * MT safe.
   */
  guint get_children_count();
  
  /** Looks up a child element by the given name.
   * 
   * Implementors can use Gst::Object together with Gst::Object::get_name()
   * @param name The childs name.
   * @return The child object or <tt>0</tt> if not found. Unref after usage.
   * 
   * MT safe.
   */
  Glib::RefPtr<Gst::Object> get_child(const Glib::ustring& name);
  
  /** Fetches a child by its number.
   * @param index The childs position in the child list.
   * @return The child object or <tt>0</tt> if not found (index too high). Unref
   * after usage.
   * 
   * MT safe.
   */
  Glib::RefPtr<Gst::Object> get_child(guint index);

  //TODO: should gst_child_proxy_lookup() be wrapped?

  void get_property(const Glib::ustring& name, Glib::ValueBase& value);
  void get_valist(const Glib::ustring& first_prop_name, va_list& var_args);
  void set_property(const Glib::ustring& name, const Glib::ValueBase& value);
  void set_valist(const Glib::ustring& first_prop_name, const va_list& var_args);
  void child_added(const Glib::RefPtr<Gst::Object>& child);
  void child_removed(const Glib::RefPtr<Gst::Object>& child);

 
  /**
   * @par Prototype:
   * <tt>void on_my_%child_added(const Glib::RefPtr<Gst::Object>& object)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Gst::Object>& > signal_child_added();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%child_removed(const Glib::RefPtr<Gst::Object>& object)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Gst::Object>& > signal_child_removed();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_child_added(const Glib::RefPtr<Gst::Object>& object);
  virtual void on_child_removed(const Glib::RefPtr<Gst::Object>& object);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::ChildProxy
   */
  Glib::RefPtr<Gst::ChildProxy> wrap(GstChildProxy* object, bool take_copy = false);

} // namespace Glib


#endif /* _GSTREAMERMM_CHILDPROXY_H */

