// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_STRUCTURE_H
#define _GSTREAMERMM_STRUCTURE_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/clock.h>
#include <gstreamermm/enums.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _GstStructure GstStructure; }
#endif

namespace Gst
{

/** Structure — Generic structure containing fields of names and values.
 * A Structure is a collection of key/value pairs. The keys are expressed as
 * GQuarks and the values can be of any GType.
 *
 * In addition to the key/value pairs, a Structure also has a name. The name
 * starts with a letter and can be folled by letters, numbers and any of
 * "/-_.:".
 *
 * Structure is used by various GStreamer subsystems to store information in a
 * flexible and extensible way. A Structure does not have a refcount because it
 * usually is part of a higher level object such as Caps. It provides a means
 * to enforce mutability using the refcount of the parent.
 *
 * Last reviewed on 2007-10-16 (0.10.15)
 */
class Structure
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Structure CppObjectType;
  typedef GstStructure BaseObjectType;

  static GType get_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  Structure();

  explicit Structure(GstStructure* gobject, bool make_a_copy = true);

  Structure(const Structure& other);
  Structure& operator=(const Structure& other);

  ~Structure();

  void swap(Structure& other);

  ///Provides access to the underlying C instance.
  GstStructure*       gobj()       { return gobject_; }

  ///Provides access to the underlying C instance.
  const GstStructure* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  GstStructure* gobj_copy() const;

protected:
  GstStructure* gobject_;

private:


public:
  /** For example,
   * bool on_foreach(const Glib::QueryQuark& id, const Glib::ValueBase& value);
   */
  typedef sigc::slot<bool, const Glib::QueryQuark&, const Glib::ValueBase&> SlotForeach;

  /** For example,
   * bool on_map(const Glib::QueryQuark& id, Glib::ValueBase& value);
   */
  typedef sigc::slot<bool, const Glib::QueryQuark&, Glib::ValueBase&> SlotMap;

public:
  Structure(const Glib::ustring& name);

  
  /** Get the number of fields in the structure.
   * @return The number of fields in the structure.
   */
  int get_size() const;
  
  /** Removes all fields in a GstStructure.
   */
  void remove_all_fields();

  
  /** Sets the field with the given name @a field to @a value.  If the field
   * does not exist, it is created.  If the field exists, the previous
   * value is replaced and freed.
   * @param fieldname The name of the field to set.
   * @param value The new value of the field.
   */
  void set_field(const Glib::ustring& fieldname, const Glib::ValueBase& value);

  void get_field(const Glib::ustring& fieldname, Glib::ValueBase& value) const;

  
  /** Removes the field with the given name.  If the field with the given
   * name does not exist, the structure is unchanged.
   * @param fieldname The name of the field to remove.
   */
  void remove_field(const Glib::ustring& fieldname);
  
  /** Finds the field with the given name, and returns the type of the
   * value it contains.  If the field is not found, G_TYPE_INVALID is
   * returned.
   * @param fieldname The name of the field.
   * @return The Value of the field.
   */
  GType get_field_type(const Glib::ustring& fieldname) const;

  bool foreach(const SlotForeach& slot);

  
  /** Check if @a structure contains a field named @a fieldname.
   * @param fieldname The name of a field.
   * @return <tt>true</tt> if the structure contains a field with the given name.
   */
  bool has_field(const Glib::ustring& fieldname) const;
  
  /** Check if @a structure contains a field named @a fieldname and with GType @a type.
   * @param fieldname The name of a field.
   * @param type The type of a value.
   * @return <tt>true</tt> if the structure contains a field with the given name and type.
   */
  bool has_field(const Glib::ustring& fieldname, GType type) const;

  /**
   */
  bool get_boolean(const Glib::ustring& fieldname, Glib::ValueBase& value) const;

  bool get_int(const Glib::ustring& fieldname, Glib::ValueBase& value) const;

  bool get_uint(const Glib::ustring& fieldname, Glib::ValueBase& value) const;

  bool get_fourcc(const Glib::ustring& fieldname, Glib::ValueBase& value) const;

  bool get_double(const Glib::ustring& fieldname, Glib::ValueBase& value) const;

  bool get_string(const Glib::ustring& fieldname, Glib::ValueBase& value) const;

  bool get_date(const Glib::ustring& fieldname, Glib::Date& value) const;

  bool get_clock_time(const Glib::ustring& fieldname, Glib::ValueBase& value) const;

  bool get_enum(const Glib::ustring& fieldname, GType enumtype, Glib::ValueBase& value) const;

  bool get_fraction(const Glib::ustring& fieldname, int& value_numerator, int& value_denominator) const;

  bool map_in_place(const SlotMap& slot);

  static Structure create_from_string(const Glib::ustring& the_string);

  
  /** Get the name of @a structure as a GQuark.
   * @return The quark representing the name of the structure.
   */
  Glib::QueryQuark get_name_id() const;
  
  /** Get the name of @a structure as a string.
   * @return The name of the structure.
   */
  Glib::ustring get_name() const;
  
  /** Checks if the structure has the given name
   * @param name Structure name to check for.
   * @return <tt>true</tt> if @a name matches the name of the structure.
   */
  bool has_name(const Glib::ustring& name) const;
  
  /** Sets the name of the structure to the given @a name.  The string
   * provided is copied before being used. It must not be empty, start with a
   * letter and can be followed by letters, numbers and any of "/-_.:".
   * @param name The new name of the structure.
   */
  void set_name(const Glib::ustring& name);
  
  /** Converts @a structure to a human-readable string representation.
   * @return A pointer to string allocated by Glib::malloc(). Glib::free() after
   * usage.
   */
  Glib::ustring to_string() const;
  
  /** Get the name of the given field number, counting from 0 onwards.
   * @param index The index to get the name of.
   * @return The name of the given field number.
   */
  Glib::ustring nth_field_name(guint index) const;
  

};

} //namespace Gst


namespace Gst
{

/** @relates Gst::Structure
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 */
inline void swap(Structure& lhs, Structure& rhs)
  { lhs.swap(rhs); }

} // namespace Gst

namespace Glib
{

/** A Glib::wrap() method for this object.
 * 
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gst::Structure
 */
Gst::Structure wrap(GstStructure* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gst::Structure> : public Glib::Value_Boxed<Gst::Structure>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _GSTREAMERMM_STRUCTURE_H */

