// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_BASESINK_H
#define _GSTREAMERMM_BASESINK_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/element.h>
#include <gstreamermm/buffer.h>
#include <gstreamermm/pad.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstBaseSink GstBaseSink;
typedef struct _GstBaseSinkClass GstBaseSinkClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class BaseSink_Class; } // namespace Gst
namespace Gst
{

/** Gst::BaseSink — Base class for sink elements.
 * Gst::BaseSink is the base class for sink elements in GStreamer, such as
 * xvimagesink or filesink. It is a layer on top of Gst::Element that provides
 * a simplified interface to plugin writers. Gst::BaseSink handles many details
 * for you, for example: preroll, clock synchronization, state changes,
 * activation in push or pull mode, and queries.
 *
 * In most cases, when writing sink elements, there is no need to implement
 * class methods from Gst::Element or to set functions on pads, because the
 * Gst::BaseSink infrastructure should be sufficient.
 *
 * TODO: correct paragraph below for C++ and include example from C API:
 *
 * Gst::BaseSink provides support for exactly one sink pad, which should be
 * named "sink". A sink implementation (subclass of Gst::BaseSink) should
 * install a pad template in its base_init function, like so:
 *
 * Gst::BaseSink will handle the prerolling correctly. This means that it will
 * return Gst::STATE_CHANGE_ASYNC from a state change to PAUSED until the first
 * buffer arrives in this element. The base class will call the
 * Gst::BaseSink::preroll_vfunc() vmethod with this preroll buffer and will
 * then commit the state change to the next asynchronously pending state.
 *
 * When the element is set to PLAYING, Gst::BaseSink will synchronise on the
 * clock using the times returned from get_times_vfunc(). If this function
 * returns Gst::CLOCK_TIME_NONE for the start time, no synchronisation will be
 * done.  Synchronisation can be disabled entirely by setting the object "sync"
 * property to FALSE.
 *
 * After synchronisation the virtual method Gst::BaseSink::render_vfunc() will
 * be called. Subclasses should minimally implement this method.
 *
 * Since GStreamer 0.10.3 subclasses that synchronise on the clock in the
 * render_vfunc() vmethod are supported as well. These classes typically
 * receive a buffer in the render method and can then potentially block on the
 * clock while rendering. A typical example is an audiosink. Since GStreamer
 * 0.10.11 these subclasses can use wait_preroll() to perform the blocking
 * wait.
 *
 * Upon receiving the EOS event in the PLAYING state, Gst::BaseSink will wait
 * for the clock to reach the time indicated by the stop time of the last
 * get_times_vfunc() call before posting an EOS message. When the element
 * receives EOS in PAUSED, preroll completes, the event is queued and an EOS
 * message is posted when going to PLAYING.
 *
 * Gst::BaseSink will internally use the Gst::EVENT_NEWSEGMENT events to
 * schedule synchronisation and clipping of buffers. Buffers that fall
 * completely outside of the current segment are dropped. Buffers that fall
 * partially in the segment are rendered (and prerolled). Subclasses should do
 * any subbuffer clipping themselves when needed.
 *
 * Gst::BaseSink will by default report the current playback position in
 * Gst::FORMAT_TIME based on the current clock time and segment information. If
 * no clock has been set on the element, the query will be forwarded upstream.
 *
 * The set_caps_vfunc() function will be called when the subclass should
 * configure itself to process a specific media type.
 *
 * The start_vfunc() and stop_vfunc() virtual methods will be called when
 * resources should be allocated. Any preroll_vfunc(), render_vfunc() and
 * set_caps_vfunc() function will be called between the start_vfunc() and
 * stop_vfunc() calls.
 *
 * The event_vfunc() virtual method will be called when an event is received by
 * Gst::BaseSink. Normally this method should only be overriden by very
 * specific elements (such as file sinks) which need to handle the newsegment
 * event specially.
 *
 * Gst::BaseSink provides an overridable buffer_alloc_vfunc() function that can
 * be used by sinks that want to do reverse negotiation or to provide custom
 * buffers (hardware buffers for example) to upstream elements.
 *
 * The unlock_vfunc() method is called when the elements should unblock any
 * blocking operations they perform in the render_vfunc() method. This is
 * mostly useful when the render_vfunc() method performs a blocking write on a
 * file descriptor, for example.
 *
 * The max-lateness property affects how the sink deals with buffers that
 * arrive too late in the sink. A buffer arrives too late in the sink when the
 * presentation time (as a combination of the last segment, buffer timestamp
 * and element base_time) plus the duration is before the current time of the
 * clock. If the frame is later than max-lateness, the sink will drop the
 * buffer without calling the render method. This feature is disabled if sync
 * is disabled, the get_times_vfunc() method does not return a valid start time
 * or max-lateness is set to -1 (the default). Subclasses can use
 * set_max_lateness() to configure the max-lateness value.
 *
 * The qos property will enable the quality-of-service features of the basesink
 * which gather statistics about the real-time performance of the clock
 * synchronisation. For each buffer received in the sink, statistics are
 * gathered and a QOS event is sent upstream with these numbers. This
 * information can then be used by upstream elements to reduce their processing
 * rate, for example.
 *
 * Since GStreamer 0.10.15 the async property can be used to instruct the sink
 * to never perform an ASYNC state change. This feature is mostly usable when
 * dealing with non-synchronized streams or sparse streams.
 *
 * Last reviewed on 2007-08-29 (0.10.15)
 */

class BaseSink
: public Element
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef BaseSink CppObjectType;
  typedef BaseSink_Class CppClassType;
  typedef GstBaseSink BaseObjectType;
  typedef GstBaseSinkClass BaseClassType;

private:  friend class BaseSink_Class;
  static CppClassType basesink_class_;

private:
  // noncopyable
  BaseSink(const BaseSink&);
  BaseSink& operator=(const BaseSink&);

protected:
  explicit BaseSink(const Glib::ConstructParams& construct_params);
  explicit BaseSink(GstBaseSink* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~BaseSink();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstBaseSink*       gobj()       { return reinterpret_cast<GstBaseSink*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstBaseSink* gobj() const { return reinterpret_cast<GstBaseSink*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstBaseSink* gobj_copy();

private:


public:
  
  /** Query the sink for the latency parameters. The latency will be queried from
   * the upstream elements. @a live will be <tt>true</tt> if @a sink is configured to
   * synchronize against the clock. @a upstream_live will be <tt>true</tt> if an upstream
   * element is live. 
   * 
   * If both @a live and @a upstream_live are <tt>true</tt>, the sink will want to compensate
   * for the latency introduced by the upstream elements by setting the
   *  @a min_latency to a strictly possitive value.
   * 
   * This function is mostly used by subclasses.
   * @param live If the sink is live.
   * @param upstream_live If an upstream element is live.
   * @param min_latency The min latency of the upstream elements.
   * @param max_latency The max latency of the upstream elements.
   * @return <tt>true</tt> if the query succeeded.
   * 
   * Since: 0.10.12.
   */
  bool query_latency(bool& live, bool& upstream_live, ClockTime& min_latency, ClockTime& max_latency);
  
  /** Get the currently configured latency.
   * @return The configured latency.
   * 
   * Since: 0.10.12.
   */
  ClockTime get_latency();
  
  /** If the Gst::BaseSinkClass::render method performs its own synchronisation against
   * the clock it must unblock when going from PLAYING to the PAUSED state and call
   * this method before continuing to render the remaining data.
   * 
   * This function will block until a state change to PLAYING happens (in which
   * case this function returns Gst::FLOW_OK) or the processing must be stopped due
   * to a state change to READY or a FLUSH event (in which case this function
   * Returns: Gst::FLOW_OK if the preroll completed and processing can
   * @return Gst::FLOW_OK if the preroll completed and processing can
   * continue. Any other return value should be returned from the render vmethod.
   */
  FlowReturn wait_preroll();
  
  ClockReturn wait_clock(ClockTime time, ClockTimeDiff& jitter);
  
  /** This function will block until @a time is reached. It is usually called by
   * subclasses that use their own internal synchronisation but want to let the
   * EOS be handled by the base class.
   * 
   * This function should only be called with the PREROLL_LOCK held, like when
   * receiving an EOS event in the ::event vmethod.
   * 
   * The @a time argument should be the running_time of when the EOS should happen
   * and will be adjusted with any latency and offset configured in the sink.
   * 
   * Since 0.10.15
   * @param time The running_time to be reached.
   * @param jitter The jitter to be filled with time diff (can be <tt>0</tt>).
   * @return Gst::FlowReturn.
   */
  FlowReturn wait_eos(ClockTime time, ClockTimeDiff& jitter);
  
  /** Configures @a sink to synchronize on the clock or not. When
   *  @a sync is <tt>false</tt>, incomming samples will be played as fast as
   * possible. If @a sync is <tt>true</tt>, the timestamps of the incomming
   * buffers will be used to schedule the exact render time of its
   * contents.
   * 
   * Since: 0.10.4
   * @param sync The new sync value.
   */
  void set_sync(bool sync);
  
  /** Checks if @a sink is currently configured to synchronize against the
   * clock.
   * @return <tt>true</tt> if the sink is configured to synchronize against the clock.
   * 
   * Since: 0.10.4.
   */
  bool get_sync();
  
  /** Sets the new max lateness value to @a max_lateness. This value is
   * used to decide if a buffer should be dropped or not based on the
   * buffer timestamp and the current clock time. A value of -1 means
   * an unlimited time.
   * 
   * Since: 0.10.4
   * @param max_lateness The new max lateness value.
   */
  void set_max_lateness(gint64 max_lateness);
  
  /** Gets the max lateness value. See gst_base_sink_set_max_lateness for
   * more details.
   * @return The maximum time in nanoseconds that a buffer can be late
   * before it is dropped and not rendered. A value of -1 means an
   * unlimited time.
   * 
   * Since: 0.10.4.
   */
  gint64 get_max_lateness();
  
  /** Configures @a sink to send Quality-of-Service events upstream.
   * 
   * Since: 0.10.5
   * @param enabled The new qos value.
   */
  void set_qos_enabled(bool enabled);
  
  /** Checks if @a sink is currently configured to send Quality-of-Service events
   * upstream.
   * @return <tt>true</tt> if the sink is configured to perform Quality-of-Service.
   * 
   * Since: 0.10.5.
   */
  bool is_qos_enabled();
  
  /** Configures @a sink to perform all state changes asynchronusly. When async is
   * disabled, the sink will immediatly go to PAUSED instead of waiting for a
   * preroll buffer. This feature is usefull if the sink does not synchronize
   * against the clock or when it is dealing with sparse streams.
   * 
   * Since: 0.10.15
   * @param enabled The new async value.
   */
  void set_async_enabled(bool enabled); 
  
  /** Checks if @a sink is currently configured to perform asynchronous state
   * changes to PAUSED.
   * @return <tt>true</tt> if the sink is configured to perform asynchronous state
   * changes.
   * 
   * Since: 0.10.15.
   */
  bool is_async_enabled();
  
  /** Adjust the synchronisation of @a sink with @a offset. A negative value will
   * render buffers earlier than their timestamp. A positive value will delay
   * rendering. This function can be used to fix playback of badly timestamped
   * buffers.
   * 
   * Since: 0.10.15
   * @param offset The new offset.
   */
  void set_ts_offset(ClockTimeDiff offset);
  
  /** Get the synchronisation offset of @a sink.
   * @return The synchronisation offset.
   * 
   * Since: 0.10.15.
   */
  ClockTimeDiff get_ts_offset();

  //TODO: Doesn't compile with GStreamer 0.10.20:
  //_WRAP_METHOD(void set_render_delay(ClockTime delay), gst_base_sink_set_render_delay)

  //TODO: Doesn't compile with GStreamer 0.10.20:
  //_WRAP_METHOD(ClockTime get_render_delay(), gst_base_sink_get_render_delay)

  
  /** Get the last buffer that arrived in the sink and was used for preroll or for
   * rendering. This property can be used to generate thumbnails.
   * 
   * The Gst::Caps on the buffer can be used to determine the type of the buffer.
   * @return A Gst::Buffer. gst_buffer_unref() after usage. This function returns
   * <tt>0</tt> when no buffer has arrived in the sink yet or when the sink is not in
   * PAUSED or PLAYING.
   * 
   * Since: 0.10.15.
   */
  Glib::RefPtr<Buffer> get_last_buffer();

  /** Gets the sink Gst::Pad object of the element.
   */
   Glib::RefPtr<Pad> get_sink_pad() const;
 
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Go asynchronously to PAUSED.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_async() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Go asynchronously to PAUSED.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_async() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The last buffer received in the sink.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Buffer> > property_last_buffer() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Maximum number of nanoseconds that a buffer can be late before it is dropped (-1 unlimited).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<gint64> property_max_lateness() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Maximum number of nanoseconds that a buffer can be late before it is dropped (-1 unlimited).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<gint64> property_max_lateness() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Number of buffers to queue during preroll.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_preroll_queue_len() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Number of buffers to queue during preroll.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_preroll_queue_len() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Generate Quality-of-Service events upstream.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_qos() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Generate Quality-of-Service events upstream.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_qos() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Sync on the clock.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_sync() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Sync on the clock.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_sync() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Timestamp offset in nanoseconds.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<gint64> property_ts_offset() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Timestamp offset in nanoseconds.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<gint64> property_ts_offset() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  /** Called to get sink pad caps from the subclass.
   */
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual Glib::RefPtr<Caps> get_caps_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED


  /** Notify subclass of changed caps.
   */
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool set_caps_vfunc(const Glib::RefPtr<Caps>& caps);
#endif //GLIBMM_VFUNCS_ENABLED


//TODO: #m4 __CONVERSION(`Glib::RefPtr<Buffer>&', `GstBuffer**', `*($3)')
  //_WRAP_VFUNC(FlowReturn buffer_alloc(guint64 offset, guint size, Glib::RefPtr<Buffer>& buffer), "buffer_alloc")

 
  /** Called to get the start and end times for synchronising the passed buffer
   * to the clock.
   */
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void get_times_vfunc(const Glib::RefPtr<Buffer>& buffer, ClockTime& start, ClockTime& end);
#endif //GLIBMM_VFUNCS_ENABLED


  /** Start processing. Ideal for opening resources in the subclass.
   */
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool start_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED


  /** Stop processing. Subclasses should use this to close resources.
   */
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool stop_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED


  /** Unlock any pending access to the resource. Subclasses should unblock any
   * blocked function ASAP.
   */
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool unlock_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED


  /** Override this to handle events arriving on the sink pad.
   */
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool event_vfunc(const Glib::RefPtr<Event>& event);
#endif //GLIBMM_VFUNCS_ENABLED


  /** Called to present the preroll buffer if desired.
   */
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual FlowReturn preroll_vfunc(const Glib::RefPtr<Buffer>& buffer);
#endif //GLIBMM_VFUNCS_ENABLED


  /** Called when a buffer should be presented or output, at the correct moment
   * if the Gst::BaseSink has been set to sync to the clock.
   */
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual FlowReturn render_vfunc(const Glib::RefPtr<Buffer>& buffer);
#endif //GLIBMM_VFUNCS_ENABLED


  /** Subclasses should override this when they need to perform special
   * processing when changing to the PLAYING state asynchronously. Called with
   * the OBJECT_LOCK held.
   */
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual StateChangeReturn async_play_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED


  /** Subclasses should override this when they can provide an alternate method
   * of spawning a thread to drive the pipeline in pull mode. Should start or
   * stop the pulling thread, depending on the value of the "active" argument.
   * Called after actually activating the sink pad in pull mode. The default
   * implementation starts a task on the sink pad. 
   */
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool activate_pull_vfunc(bool active);
#endif //GLIBMM_VFUNCS_ENABLED


  /** Only useful in pull mode, this vmethod will be called in response to
   * Gst::Pad::fixate_caps() being called on the sink pad. Implement if you
   * have ideas about what should be the default values for the caps you
   * support.
   */
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void fixate_vfunc(const Glib::RefPtr<Caps>& caps);
#endif //GLIBMM_VFUNCS_ENABLED


  /** Clear the previous unlock request. Subclasses should clear any state they
   * set during unlock_vfunc(), such as clearing command queues.
   */
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool unlock_stop_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} //namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::BaseSink
   */
  Glib::RefPtr<Gst::BaseSink> wrap(GstBaseSink* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_BASESINK_H */

