/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  GThumb
 *
 *  Copyright (C) 2009 Free Software Foundation, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PREFERENCES_H
#define PREFERENCES_H

#include <gthumb.h>

G_BEGIN_DECLS

#define PREF_IMAGE_PRINT_CAPTION           "/apps/gthumb/ext/image_print/caption"
#define PREF_IMAGE_PRINT_FONT_NAME         "/apps/gthumb/ext/image_print/font_name"
#define PREF_IMAGE_PRINT_HEADER_FONT_NAME  "/apps/gthumb/ext/image_print/header_font_name"
#define PREF_IMAGE_PRINT_FOOTER_FONT_NAME  "/apps/gthumb/ext/image_print/footer_font_name"
#define PREF_IMAGE_PRINT_HEADER            "/apps/gthumb/ext/image_print/header"
#define PREF_IMAGE_PRINT_FOOTER            "/apps/gthumb/ext/image_print/footer"
#define PREF_IMAGE_PRINT_N_ROWS            "/apps/gthumb/ext/image_print/n_rows"
#define PREF_IMAGE_PRINT_N_COLUMNS         "/apps/gthumb/ext/image_print/n_columns"
#define PREF_IMAGE_PRINT_UNIT              "/apps/gthumb/ext/image_print/unit"

#define DEFAULT_CAPTION_FONT_NAME "sans normal 10"
#define DEFAULT_HEADER_FONT_NAME  "sans bold 12"
#define DEFAULT_FOOTER_FONT_NAME  "sans normal 8"
#define DEFAULT_HEADER            ""
#define DEFAULT_FOOTER            ""

void ip__dlg_preferences_construct_cb (GtkWidget  *dialog,
				       GthBrowser *browser,
				       GtkBuilder *builder);
void ip__dlg_preferences_apply_cb     (GtkWidget  *dialog,
				       GthBrowser *browser,
				       GtkBuilder *builder);

G_END_DECLS

#endif /* PREFERENCES_H */
