/* The Cairo CSS Drawing Library.
 * Copyright (C) 2008 Robert Staudinger
 *
 * This  library is free  software; you can  redistribute it and/or
 * modify it  under  the terms  of the  GNU Lesser  General  Public
 * License  as published  by the Free  Software  Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed  in the hope that it will be useful,
 * but  WITHOUT ANY WARRANTY; without even  the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License  along  with  this library;  if not,  write to  the Free
 * Software Foundation, Inc., 51  Franklin St, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#include "ccd-block.h"

ccd_block_t *
ccd_block_new (void)
{
	ccd_block_t *self;

	self = g_new0 (ccd_block_t, 1);

	return self;
}

void
ccd_block_free (ccd_block_t *self)
{
	g_assert (self);

	g_free (self);
}

void
ccd_block_dump (ccd_block_t const *self)
{
	ccd_background_dump (&self->background);
	ccd_border_dump (&self->border);
}

