/* The Cairo CSS Drawing Library.
 * Copyright (C) 2008 Robert Staudinger
 *
 * This  library is free  software; you can  redistribute it and/or
 * modify it  under  the terms  of the  GNU Lesser  General  Public
 * License  as published  by the Free  Software  Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed  in the hope that it will be useful,
 * but  WITHOUT ANY WARRANTY; without even  the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License  along  with  this library;  if not,  write to  the Free
 * Software Foundation, Inc., 51  Franklin St, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#ifndef CCD_H
#define CCD_H

#include <glib.h>

G_BEGIN_DECLS

#include <ccd/ccd-features.h>
#include <ccd/ccd-function.h>
#include <ccd/ccd-background.h>
#include <ccd/ccd-border.h>
#include <ccd/ccd-color.h>
#include <ccd/ccd-function.h>
#include <ccd/ccd-node.h>
#include <ccd/ccd-style.h>
#include <ccd/ccd-stylesheet.h>

#ifdef CCD_WITH_GTK
#include <ccd/ccd-gtk-style.h>
#endif /* CCD_WITH_GTK */

#define XH(n_) (n_)
#define YH(n_) (n_ + 0.5)
#define XV(n_) (n_ + 0.5)
#define YV(n_) (n_)

void 		ccd_init	(ccd_node_class_t const *node_class, 
				 ccd_function_t const *vtable);
void 		ccd_shutdown	(void);

G_END_DECLS

#endif /* CCD_H */

