/* The Cairo CSS Drawing Library.
 * Copyright (C) 2008 Robert Staudinger
 *
 * This  library is free  software; you can  redistribute it and/or
 * modify it  under  the terms  of the  GNU Lesser  General  Public
 * License  as published  by the Free  Software  Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed  in the hope that it will be useful,
 * but  WITHOUT ANY WARRANTY; without even  the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License  along  with  this library;  if not,  write to  the Free
 * Software Foundation, Inc., 51  Franklin St, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#include "ccd-node.h"

static bool
is_a (ccd_node_t const	*self,
      char const	*type_name)
{
	return FALSE;
}

static ccd_node_t * 
get_container (ccd_node_t const *self)
{
	return NULL;
}

static ccd_node_t * 
get_base_style (ccd_node_t const *self)
{
	return NULL;
}

static char const * 
get_type (ccd_node_t const *self)
{
	return NULL;
}

static char const * 
get_id (ccd_node_t const *self)
{
	return NULL;
}

static char const * 
get_class (ccd_node_t const *self)
{
	return NULL;
}

static char const * 
get_pseudo_class (ccd_node_t const *self)
{
	return NULL;
}

static char * 
get_attribute (ccd_node_t const	*self,
	       char const	*name)
{
	return NULL;
}

static void
release (ccd_node_t *self)
{
	return;
}

static const ccd_node_class_t _default_node_class = {
	.is_a			= is_a,
	.get_container		= get_container,
	.get_base_style		= get_base_style,
	.get_id			= get_id,
	.get_type		= get_type,
	.get_class		= get_class,
	.get_pseudo_class	= get_pseudo_class,
	.get_attribute		= get_attribute,
	.release		= release
};

static ccd_node_class_t _node_class = {
	.is_a			= is_a,
	.get_container		= get_container,
	.get_base_style		= get_base_style,
	.get_id			= get_id,
	.get_type		= get_type,
	.get_class		= get_class,
	.get_pseudo_class	= get_pseudo_class,
	.get_attribute		= get_attribute,
	.release		= release
};

ccd_node_class_t const *
ccd_node_get_class (void)
{
	return &_node_class;
}

typedef void (*node_f) (void);
#define N_ELEMENTS(vtable_) (sizeof (vtable_) / sizeof (node_f))

void
ccd_node_set_class (ccd_node_class_t const *node_class)
{
	node_f		*node_vtable;
	node_f const	*new_node_vtable;

	g_return_if_fail (node_class);

	node_vtable = (node_f *) &_node_class;
	new_node_vtable = (node_f *) node_class;
	for (unsigned int i = 0; i < N_ELEMENTS (_node_class); i++) {
		/* Override only implemented methods. */
		if (new_node_vtable[i]) {
			node_vtable[i] = new_node_vtable[i];
		}
	}
}

void
ccd_node_reset_class (void)
{
	ccd_node_set_class (&_default_node_class);
}

