/* The Cairo CSS Drawing Library.
 * Copyright (C) 2008 Robert Staudinger
 *
 * This  library is free  software; you can  redistribute it and/or
 * modify it  under  the terms  of the  GNU Lesser  General  Public
 * License  as published  by the Free  Software  Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed  in the hope that it will be useful,
 * but  WITHOUT ANY WARRANTY; without even  the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License  along  with  this library;  if not,  write to  the Free
 * Software Foundation, Inc., 51  Franklin St, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#ifndef CCD_SELECTOR_H
#define CCD_SELECTOR_H

#include <stdbool.h>
#include <stdint.h>
#include <glib.h>
#include <ccd/ccd-features.h>
#include <ccd/ccd-block.h>
#include <ccd/ccd-node.h>
#include <ccd/ccd-style.h>

G_BEGIN_DECLS

#define CCD_SELECTOR_MAX_SPECIFICITY ((1 << 5) - 1)

typedef struct ccd_rule_set_ ccd_rule_set_t;
typedef struct ccd_selector_ ccd_selector_t;

typedef enum {
	CCD_ATTRIBUTE_SELECTOR_MATCH_EXISTS, 
	CCD_ATTRIBUTE_SELECTOR_MATCH_EQUALS
	/* more match types go here */
} ccd_attribute_selector_match_t;

ccd_selector_t * ccd_universal_selector_new	(void);
ccd_selector_t * ccd_type_selector_new		(char const *type_name);
ccd_selector_t * ccd_base_type_selector_new	(char const *type_name, unsigned int specificity_e);
ccd_selector_t * ccd_class_selector_new		(char const *class_name);
ccd_selector_t * ccd_id_selector_new		(char const *id);
ccd_selector_t * ccd_attribute_selector_new	(char const *name, char const *value, ccd_attribute_selector_match_t match);
ccd_selector_t * ccd_pseudo_class_selector_new	(char const *pseudo_class);

ccd_selector_t * ccd_selector_copy		(ccd_selector_t const *original);
ccd_selector_t * ccd_selector_copy_as_base	(ccd_selector_t const *original,
						 int specificity_e);

void ccd_selector_free	(ccd_selector_t *self);

void		 ccd_selector_refine		(ccd_selector_t *self, ccd_selector_t *selector);
ccd_selector_t * ccd_selector_append_child	(ccd_selector_t *self, ccd_selector_t *selector);
ccd_selector_t * ccd_selector_append_descendant	(ccd_selector_t *self, ccd_selector_t *selector);

bool ccd_selector_is_type	(ccd_selector_t const *self);
bool ccd_selector_is_class	(ccd_selector_t const *self);
bool ccd_selector_is_id		(ccd_selector_t const *self);

ccd_block_t const *	ccd_selector_get_block	(ccd_selector_t const *self);
void			ccd_selector_set_block	(ccd_selector_t *self, ccd_block_t const *block);

char const *		ccd_selector_get_key		(ccd_selector_t const *self);
uint32_t		ccd_selector_get_specificity	(ccd_selector_t const *self);
void			ccd_selector_get_specificity_values	(ccd_selector_t const *self, 
			unsigned int *a, unsigned int *b, unsigned int *c, unsigned int *d, unsigned int *e);

bool ccd_selector_query_apply (ccd_selector_t const *self, ccd_node_t const *node, 
			       ccd_style_t *style);
bool ccd_selector_apply (ccd_selector_t const *self, ccd_style_t *style);

void ccd_selector_dump (ccd_selector_t const *self);

G_END_DECLS

#endif /* CCD_SELECTOR_H */

