
/*
 * This example uses internal API.
 */

#include <gtk/gtk.h>
#include <ccd/ccd.h>

static void
draw_decorations (GtkAllocation	*allocation, 
		  cairo_t	*cr)
{
	cairo_move_to (cr, XV (30), YV (10));
	cairo_line_to (cr, XV (30), YV (20));
	cairo_stroke (cr);

	cairo_move_to (cr, XH (10), YH (30));
	cairo_line_to (cr, XH (20), YH (30));
	cairo_stroke (cr);

	cairo_move_to (cr, XV (allocation->width - 30), YV (10));
	cairo_line_to (cr, XV (allocation->width - 30), YV (20));
	cairo_stroke (cr);

	cairo_move_to (cr, XH (allocation->width - 20), YH (30));
	cairo_line_to (cr, XH (allocation->width - 10), YH (30));
	cairo_stroke (cr);

	cairo_move_to (cr, XH (allocation->width - 20), YH (allocation->height - 30));
	cairo_line_to (cr, XH (allocation->width - 10), YH (allocation->height - 30));
	cairo_stroke (cr);

	cairo_move_to (cr, XV (allocation->width - 30), YV (allocation->height - 20));
	cairo_line_to (cr, XV (allocation->width - 30), YV (allocation->height - 10));
	cairo_stroke (cr);

	cairo_move_to (cr, XV (30), YV (allocation->height - 20));
	cairo_line_to (cr, XV (30), YV (allocation->height - 10));
	cairo_stroke (cr);

	cairo_move_to (cr, XH (10), YH (allocation->height - 30));
	cairo_line_to (cr, XH (20), YH (allocation->height - 30));
	cairo_stroke (cr);
}

static void
draw_box (cairo_t	 *cr, 
	  double	  x,
	  double	  y,
	  double	  width,
	  double	  height)
{
	ccd_border_t border = {
		.left.width = 3, .left.style = CCD_BORDER_STYLE_SOLID, .left.color.red = 0, .left.color.green = 0, .left.color.blue = 0,
		.top.width = 10, .top.style = CCD_BORDER_STYLE_DOTTED, .top.color.red = 1, .top.color.green = 0, .top.color.blue = 0,
		.right.width = 1, .right.style = CCD_BORDER_STYLE_DASHED, .right.color.red = 0, .right.color.green = 0, .right.color.blue = 0,
		.bottom.width = 3, .bottom.style = CCD_BORDER_STYLE_SOLID, .bottom.color.red = 0, .bottom.color.green = 0, .bottom.color.blue = 0
	};

	ccd_border_draw (&border.left, &border.top, &border.right, &border.bottom, cr, x, y, width, height);
}

static gboolean
expose_cb (GtkWidget      *widget,
           GdkEventExpose *event,
           gpointer        user_data)
{
	cairo_t *cr;

	cr = gdk_cairo_create (widget->window);
	cairo_set_line_width (cr, 1.0);

	draw_decorations (&widget->allocation, cr);

	draw_box (cr, 30, 30, widget->allocation.width - 60, widget->allocation.height - 60);

	cairo_destroy (cr);

	return FALSE;
}

int
main (int	  argc,
      char	**argv)
{
	GtkWidget *window;

	gtk_init (&argc, &argv);

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_app_paintable (window, TRUE);
	gtk_widget_set_size_request (window, 70, 70);
	g_signal_connect (G_OBJECT (window), "expose-event", 
		G_CALLBACK (expose_cb), NULL);
	g_signal_connect (G_OBJECT (window), "delete-event", 
		G_CALLBACK (gtk_main_quit), NULL);

	gtk_widget_show_all (window);
	gtk_main ();

	return 0;
}

