//  Gtk.RadioMenuItem.cs - Gtk RadioMenuItem customizations
//
//  Authors:  John Luke  <jluke@cfl.rr.com>
//            Mike Kestner <mkestner@ximian.com>
//
//  Copyright (c) 2004 Novell, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the Lesser GNU General 
// Public License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this program; if not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.

namespace Gtk {

	using System;
	using System.Runtime.InteropServices;

	public partial class RadioMenuItem {

		public RadioMenuItem (string label) : base (IntPtr.Zero)
		{
			if (GetType() != typeof (RadioMenuItem)) {
				CreateNativeObject (new string [0], new GLib.Value [0]);
				AccelLabel al = new AccelLabel ("");
				al.TextWithMnemonic = label;
				al.SetAlignment (0.0f, 0.5f);
				Add (al);
				al.AccelWidget = this;
				return;
			}

			IntPtr label_as_native = GLib.Marshaller.StringToPtrGStrdup (label);
			Raw = gtk_radio_menu_item_new_with_mnemonic (IntPtr.Zero, label_as_native);
			GLib.Marshaller.Free (label_as_native);
		}


		[DllImport ("libgtk-win32-3.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_radio_menu_item_new_with_mnemonic(IntPtr group, IntPtr label);

		public RadioMenuItem (GLib.SList group, string label) : base (IntPtr.Zero)
		{
			if (GetType () != typeof (RadioMenuItem)) {
				CreateNativeObject (new string [0], new GLib.Value [0]);
				AccelLabel al = new AccelLabel ("");
				al.TextWithMnemonic = label;
				al.SetAlignment (0.0f, 0.5f);
				Add (al);
				al.AccelWidget = this;
				Group = group;
				return;
			}
			IntPtr native_label = GLib.Marshaller.StringToPtrGStrdup (label);
			Raw = gtk_radio_menu_item_new_with_mnemonic(group == null ? IntPtr.Zero : group.Handle, native_label);
			GLib.Marshaller.Free (native_label);
		}
	}
}
