%define ver      3.12.3

Summary: gtkhtml library
Name: gtkhtml
Version: %ver
Release: 1
Copyright: LGPL
Group: X11/Libraries
Source: ftp://ftp.gnome.org/pub/GNOME/sources/gtkhtml/gtkhtml-%{ver}.tar.gz
BuildRoot: /var/tmp/gtkhtml-%{PACKAGE_VERSION}-root
Provides: gtkhtml.so.0
Requires: gnome-print >= 0.25
Requires: gdk-pixbuf >= 0.8.0
Requires: gal >= 0.7.99.5
Requires: pspell
Requires: bonobo >= 0.32
Requires: GConf >= 0.9
Requires: libghttp >= 1.0
Requires: libglade

%description
This is GtkHTML, a lightweight HTML rendering/printing/editing engine.
It was originally based on KHTMLW, but is now being developed
independently of it.

%package devel
Summary: Libraries, includes, etc to develop gtkhtml applications
Group: X11/libraries
Requires: gtkhtml

%description devel
Libraries, include files, etc you can use to develop gtkhtml applications.




%prep
%setup -q

%build
# Needed for snapshot releases.
if [ ! -f configure ]; then
%ifarch alpha
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh --host=alpha-redhat-linux --prefix=%{_prefix} --sysconfdir=%{_sysconfdir} --with-bonobo
%else
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh --prefix=%{_prefix} --sysconfdir=%{_sysconfdir} --with-bonobo
%endif
else
%ifarch alpha
  CFLAGS="$RPM_OPT_FLAGS" ./configure --host=alpha-redhat-linux --prefix=%{_prefix} --sysconfdir=%{_sysconfdir} --with-bonobo
%else
  CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%{_prefix} --sysconfdir=%{_sysconfdir} --with-bonobo
%endif
fi

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT

# Note how DESTDIR is passed. Using prefix=$RPM_BUILD_ROOT%{_prefix} instaead
# nearly worked, but problems occured for /etc/CORBA/servers, where prefix
# was ignored completely.
make -k DESTDIR=$RPM_BUILD_ROOT prefix=%{_prefix} localedir=$RPM_BUILD_ROOT%{_datadir}/locale install


%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-, root, root)
%doc AUTHORS ChangeLog NEWS README COPYING TODO
%doc %{_datadir}/gnome/html/*
%config %{_sysconfdir}/CORBA/servers/*.gnorba
%{_bindir}/gtkhtml-properties-capplet
%{_bindir}/gnome-gtkhtml-editor
%{_bindir}/ebrowser
%{_libdir}/*.so.*
%{_libdir}/bonobo/plugin/*so
%{_datadir}/control-center/Documents/*.desktop
%{_datadir}/control-center/capplets/*.desktop
%{_datadir}/gnome/apps/Settings/Documents/*.desktop
%{_datadir}/gnome/ui/GNOME_GtkHTML_Editor.xml
%dir %{_datadir}/gtkhtml
%{_datadir}/gtkhtml/keybindingsrc.*
%{_datadir}/gtkhtml/*.idl
%{_datadir}/gtkhtml/*.glade
%{_datadir}/gtkhtml/icons
%{_datadir}/oaf/*.oaf
%{_datadir}/locale/*/LC_MESSAGES/*.mo

%files devel
%defattr(-, root, root)
%dir %{_includedir}/gtkhtml
%{_includedir}/gtkhtml/*.h
%{_libdir}/*.sh
%{_libdir}/*.so
%{_libdir}/*.a
%{_libdir}/*.la
#%{_libdir}/bonobo/plugin/*.a
#%{_libdir}/bonobo/plugin/*.la
