/*
 *  Copyright (C) 2005 Robert Staudinger
 *
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Library General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GME_DOM_ATTR_PRIVATE_H__
#define __GME_DOM_ATTR_PRIVATE_H__

#include <glib/gmacros.h>
#include <nsIDOMAttr.h>

#include "gme-dom-attr.h"
#include "gme-dom-node-private.h"

G_BEGIN_DECLS

struct _GmeDOMAttr {
	GmeDOMNode parent;
	nsIDOMAttr *attr;
	gboolean is_disposed;
};

struct _GmeDOMAttrClass {
	GmeDOMNodeClass parent;
	void (* dispose) (GObject *instance);
};

GmeDOMAttr* gme_dom_attr_new (nsIDOMAttr *attr);
void gme_dom_attr_private_set_wrapped_ptr (GmeDOMAttr *self, nsIDOMAttr *attr);

G_END_DECLS

#endif /* __GME_DOM_ATTR_PRIVATE_H__ */
