// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKSOURCEVIEWMM_SOURCEVIEW_H
#define _GTKSOURCEVIEWMM_SOURCEVIEW_H


#include <glibmm.h>

/* sourceview.h
 *
 * Copyright (C) 2004-2005 Jae Jang
 * Copyright (C) 2005-2006 Rob Page
 * Copyright (C) 2005-2006 Dodji Seketeli
 * Copyright (C) 2009, 2010 Krzesimir Nowak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/textview.h>
#include <gtksourceviewmm/sourcebuffer.h>
#include <gtksourceviewmm/sourcegutter.h>
#include <gtksourceviewmm/sourcecompletion.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkSourceView GtkSourceView;
typedef struct _GtkSourceViewClass GtkSourceViewClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace gtksourceview
{ class SourceView_Class; } // namespace gtksourceview
namespace gtksourceview
{

class SourceGutter;
class SourceCompletion;

/** @addtogroup gtksourceviewmmEnums Enums and Flags */

/** Defines a behaviour of smart Home/End keys.
 * @ingroup gtksourceviewmmEnums
 */
enum SourceSmartHomeEndType
{
  SOURCE_SMART_HOME_END_DISABLED,
  SOURCE_SMART_HOME_END_BEFORE,
  SOURCE_SMART_HOME_END_AFTER,
  SOURCE_SMART_HOME_END_ALWAYS
};

} // namespace gtksourceview


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<gtksourceview::SourceSmartHomeEndType> : public Glib::Value_Enum<gtksourceview::SourceSmartHomeEndType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace gtksourceview
{

/** @var SourceSmartHomeEndType SOURCE_SMART_HOME_END_DISABLED
 * Smart-home-end disabled.
 */
/** @var SourceSmartHomeEndType SOURCE_SMART_HOME_END_BEFORE
 * Move to the first/last non-whitespace character on the first press of the
 * HOME/END keys and to the beginning/end of the line on the second press.
 */
/** @var SourceSmartHomeEndType SOURCE_SMART_HOME_END_AFTER
 * Move to the beginning/end of the line on the first press of the HOME/END keys
 * and to the first/last non-whitespace character on the second press.
 */
/** @var SourceSmartHomeEndType SOURCE_SMART_HOME_END_ALWAYS
 * Always move to the first/last non-whitespace character when the HOME/END keys
 * are pressed.
 */

/** Determines what kind of whitespaces whould be drawn.
 * @ingroup gtksourceviewmmEnums
 * @par Bitwise operators:
 * <tt>%SourceDrawSpacesFlags operator|(SourceDrawSpacesFlags, SourceDrawSpacesFlags)</tt><br>
 * <tt>%SourceDrawSpacesFlags operator&(SourceDrawSpacesFlags, SourceDrawSpacesFlags)</tt><br>
 * <tt>%SourceDrawSpacesFlags operator^(SourceDrawSpacesFlags, SourceDrawSpacesFlags)</tt><br>
 * <tt>%SourceDrawSpacesFlags operator~(SourceDrawSpacesFlags)</tt><br>
 * <tt>%SourceDrawSpacesFlags& operator|=(SourceDrawSpacesFlags&, SourceDrawSpacesFlags)</tt><br>
 * <tt>%SourceDrawSpacesFlags& operator&=(SourceDrawSpacesFlags&, SourceDrawSpacesFlags)</tt><br>
 * <tt>%SourceDrawSpacesFlags& operator^=(SourceDrawSpacesFlags&, SourceDrawSpacesFlags)</tt><br>
 */
enum SourceDrawSpacesFlags
{
  SOURCE_DRAW_SPACES_SPACE = 1 << 0,
  SOURCE_DRAW_SPACES_TAB = 1 << 1,
  SOURCE_DRAW_SPACES_NEWLINE = 1 << 2,
  SOURCE_DRAW_SPACES_NBSP = 1 << 3,
  SOURCE_DRAW_SPACES_LEADING = 1 << 4,
  SOURCE_DRAW_SPACES_TEXT = 1 << 5,
  SOURCE_DRAW_SPACES_TRAILING = 1 << 6,
  SOURCE_DRAW_SPACES_ALL = 0x7F
};

/** @ingroup gtksourceviewmmEnums */
inline SourceDrawSpacesFlags operator|(SourceDrawSpacesFlags lhs, SourceDrawSpacesFlags rhs)
  { return static_cast<SourceDrawSpacesFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtksourceviewmmEnums */
inline SourceDrawSpacesFlags operator&(SourceDrawSpacesFlags lhs, SourceDrawSpacesFlags rhs)
  { return static_cast<SourceDrawSpacesFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtksourceviewmmEnums */
inline SourceDrawSpacesFlags operator^(SourceDrawSpacesFlags lhs, SourceDrawSpacesFlags rhs)
  { return static_cast<SourceDrawSpacesFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtksourceviewmmEnums */
inline SourceDrawSpacesFlags operator~(SourceDrawSpacesFlags flags)
  { return static_cast<SourceDrawSpacesFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gtksourceviewmmEnums */
inline SourceDrawSpacesFlags& operator|=(SourceDrawSpacesFlags& lhs, SourceDrawSpacesFlags rhs)
  { return (lhs = static_cast<SourceDrawSpacesFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtksourceviewmmEnums */
inline SourceDrawSpacesFlags& operator&=(SourceDrawSpacesFlags& lhs, SourceDrawSpacesFlags rhs)
  { return (lhs = static_cast<SourceDrawSpacesFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtksourceviewmmEnums */
inline SourceDrawSpacesFlags& operator^=(SourceDrawSpacesFlags& lhs, SourceDrawSpacesFlags rhs)
  { return (lhs = static_cast<SourceDrawSpacesFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace gtksourceview


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<gtksourceview::SourceDrawSpacesFlags> : public Glib::Value_Flags<gtksourceview::SourceDrawSpacesFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace gtksourceview
{

/** @var SourceDrawSpacesFlags SOURCE_DRAW_SPACES_SPACE
 * Whether the space character should be drawn.
 */
/** @var SourceDrawSpacesFlags SOURCE_DRAW_SPACES_TAB
 * Whether the tab character should be drawn.
 */
/** @var SourceDrawSpacesFlags SOURCE_DRAW_SPACES_NEWLINE
 * Whether the line breaks should be drawn.
 */
/** @var SourceDrawSpacesFlags SOURCE_DRAW_SPACES_NBSP
 * Whether the non-breaking whitespaces should be drawn.
 */
/** @var SourceDrawSpacesFlags SOURCE_DRAW_SPACES_ALL
 * Wheter all kind of whitespaces should be drawn.
 */

/** The view object.
 *
 * SourceView is the main object of the gtksourceviewmm library. It provides
 * a text view which has syntax highlighting, undo/redo and text marks. Use a
 * SourceBuffer to display text with a GtkSourceView.
 */

class SourceView : public Gtk::TextView
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef SourceView CppObjectType;
  typedef SourceView_Class CppClassType;
  typedef GtkSourceView BaseObjectType;
  typedef GtkSourceViewClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~SourceView();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class SourceView_Class;
  static CppClassType sourceview_class_;

  // noncopyable
  SourceView(const SourceView&);
  SourceView& operator=(const SourceView&);

protected:
  explicit SourceView(const Glib::ConstructParams& construct_params);
  explicit SourceView(GtkSourceView* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkSourceView*       gobj()       { return reinterpret_cast<GtkSourceView*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkSourceView* gobj() const { return reinterpret_cast<GtkSourceView*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_redo();
  virtual void on_undo();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:


public:
  /// The gutter position of the lines renderer.
  static const int gutter_position_lines = -30;
  /// The gutter position of the marks renderer.
  static const int gutter_position_marks = -20;

  /** Creates a new SourceView.
   *
   * An empty default buffer will be created for you. If you want to specify
   * your own buffer, consider the other constructor.
   *
   * @return A new SourceView.
   */
  explicit SourceView () ;

  /** Creates a new SourceView widget displaying the buffer @a buffer.
   *
   * One buffer can be shared among many widgets.
   *
   * @param buffer A SourceBuffer.
   *
   * @return: A new SourceView.
   **/
  explicit SourceView (const Glib::RefPtr<SourceBuffer> &buffer) ;

// TODO: remove these when breaking API/ABI? SourceView is derived from GtkObject, so it does not need to be accessed by Glib::RefPtr. krnowak
  
  static Glib::RefPtr<SourceView> create();

  
  static Glib::RefPtr<SourceView> create(const Glib::RefPtr<SourceBuffer> & buffer);


  /** Returns the GtkTextBuffer being displayed by this text view.
   *
   * @return A SourceBuffer.
   */
  Glib::RefPtr<const SourceBuffer> get_source_buffer () const ;

  /** Returns the GtkTextBuffer being displayed by this text view.
   *
   * @return A SourceBuffer.
   */
  Glib::RefPtr<SourceBuffer> get_source_buffer () ;

  /** Sets a source_buffer as the buffer being displayed by source view.
   *
   * The previous buffer displayed by the text view is unreferenced, and a
   * reference is added to buffer.
   *
   * @param source_buffer A SourceBuffer.
   */
  void set_source_buffer (const Glib::RefPtr<SourceBuffer> &source_buffer) ;

  
  /** If <tt>true</tt> line numbers will be displayed beside the text.
   * @param show Whether line numbers should be displayed.
   */
  void set_show_line_numbers(bool show=true);

  
  /** Returns whether line numbers are displayed beside the text.
   *
   * @return @c true if the line numbers are displayed.
   */
  bool get_show_line_numbers() const;

  
  /** Sets the width of tabulation in characters.
   * @param width Width of tab in characters.
   */
  void set_tab_width(guint width);

  
  /** Returns the width of tabulation in characters.
   *
   * @return Width of tab.
   */
  guint get_tab_width() const;

  
  /** If <tt>true</tt> auto indentation of text is enabled.
   * @param enable Whether to enable auto indentation.
   */
  void set_auto_indent(bool enable=true);

  
  /** Returns whether auto indentation of text is enabled.
   *
   * @return @c true if auto indentation is enabled.
   */
  bool get_auto_indent() const;

  
  /** If <tt>true</tt> any tabulator character inserted is replaced by a group
   * of space characters.
   * @param enable Whether to insert spaces instead of tabs.
   */
  void set_insert_spaces_instead_of_tabs(bool enable=true);

  
  /** Returns whether when inserting a tabulator character it should
   *  be replaced by a group of space characters.
   *
   * @return @c true if spaces are inserted instead of tabs.
   */
  bool get_insert_spaces_instead_of_tabs() const;

  
  /** If <tt>true</tt> a right margin is displayed
   * @param show Whether to show a right margin.
   */
  void set_show_right_margin(bool show = true);

  
  /** Returns whether a right margin is displayed.
   *
   * @return @c true if the right margin is shown.
   */
  bool get_show_right_margin() const;

  
  /** If @a highlight is @c true the current line is highlighted.
   *
   * @param highlight Whether to highlight the current line.
   */
  void set_highlight_current_line(bool highlight = true);

  
  /** Returns whether the current line is highlighted.
   *
   * @return @c true if the current line is highlighted.
   */
  bool get_highlight_current_line() const;

  
  /** Sets the position of the right margin.
   *
   * @param margin The width in characters where to position the right margin.
   */
  void set_right_margin_position(guint margin);

  
  /** Gets the position of the right margin.
   *
   * @return The position of the right margin.
   */
  guint get_right_margin_position() const;

  
  /** Set the desired movement of the cursor when HOME and END keys are pressed.
   *
   * @param smart_he The desired behavior among SourceSmartHomeEndType.
   */
  void set_smart_home_end(SourceSmartHomeEndType smart_he);

  
  /** Returns a SourceSmartHomeEndType end value specifying how the cursor will
   *  move when HOME and END keys are pressed.
   *
   * @return A SourceSmartHomeEndType value.
   */
  SourceSmartHomeEndType get_smart_home_end() const;

  
  /** If @c true line marks will be displayed beside the text.
   *
   * @param show Whether line marks should be displayed.
   *
   * @newin{2,2}
   */
  void set_show_line_marks(bool show = true);

  
  /** Returns whether line marks are displayed beside the text.
   *
   * @return @c true if the line marks are displayed.
   *
   * @newin{2,2}
   */
  bool get_show_line_marks() const;

  
  /** If @c true, when the tab key is pressed and there is a selection, the
   *  selected text is indented of one level instead of being replaced with
   *  the @\t characters. Shift+Tab unindents the selection.
   *
   * @param enable Whether to indent a block when tab is pressed.
   *
   * @newin{2,2}
   */
  void set_indent_on_tab(bool enable = true);

  
  /** Returns whether when the tab key is pressed the current selection
   *  should get indented instead of replaced with the @\t character.
   *
   * @return @c true if the selection is indented when tab is pressed.
   *
   * @newin{2,2}
   */
  bool get_indent_on_tab() const;

  
  /** Sets the number of spaces to use for each step of indent.
   *
   * If @a width is -1, the value of the SourceView::property_tab_width property
   * will be used.
   *
   * @param width Indent width in characters.
   */
  void set_indent_width(gint width);

  
  /** Returns the number of spaces to use for each step of indent.
   *
   * See set_indent_width() for details.
   *
   * @return Indent width.
   */
  gint get_indent_width() const;

  
  /** Set the @a priority for the given mark @a category.
   *
   * When there are multiple marks on the same line, marks of categories with
   * higher priorities will be drawn on top.
   *
   * @param category A mark category.
   * @param priority The priority for the category.
   *
   * @newin{2,2}
   */
  void set_mark_category_priority(const Glib::ustring& category, gint priority);

  
  /** Gets the priority which is associated with the given @a category.
   *
   * @param category A mark category.
   *
   * @return The priority or if @a category exists but no priority was set, it
   * defaults to 0.
   *
   * @newin{2,2}
   */
  gint get_mark_category_priority(const Glib::ustring& category) const;

#ifndef GTKSOURCEVIEWMM_DISABLE_DEPRECATED
  

  /** Associates a given @a pixbuf with a given mark @a category.
   *
   * If @a pixbuf is empty, the pixbuf is unset.
   *
   * @param category A mark category.
   * @param pixbuf A Gdk::Pixbuf or empty Glib::RefPtr.
   *
   * @deprecated Use set_mark_category_icon() instead.
   *
   * @newin{2,2}
   */
  void set_mark_category_pixbuf(const Glib::ustring& category, const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);

  
  /** Gets the pixbuf which is associated with the given mark @a category.
   *
   * @param category A mark category.
   *
   * @return Empty Glib::RefPtr.
   *
   * @deprecated Do not use it.
   *
   * @newin{2,2}
   */
  Glib::RefPtr<Gdk::Pixbuf> get_mark_category_pixbuf(const Glib::ustring& category);

  /** Gets the pixbuf which is associated with the given mark @a category.
   *
   * @param category A mark category.
   *
   * @return Empty Glib::RefPtr.
   *
   * @deprecated Do not use it.
   *
   * @newin{2,2}
   */
  Glib::RefPtr<const Gdk::Pixbuf> get_mark_category_pixbuf(const Glib::ustring& category) const;
#endif // GTKSOURCEVIEWMM_DISABLE_DEPRECATED

  
  /** Sets the icon to be used for @a category to @a pixbuf.
   *
   * @param category A mark category.
   * @param pixbuf A Gdk::Pixbuf or empty Glib::RefPtr.
   *
   * @newin{2,10}
   */
  void set_mark_category_icon(const Glib::ustring& category, const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);

  
  /** Sets the icon to be used for @a category to the stock item @a stock_id.
   *
   * @param category A mark category.
   * @param stock_id The stock id.
   *
   * @newin{2,10}
   */
  void set_mark_category_icon(const Glib::ustring& category, const Gtk::StockID& stock_id);

  
  /** Sets the icon to be used for @a category to the named theme item @a name.
   *
   * @param category A mark category.
   * @param name The themed icon name.
   *
   * @newin{2,10}
   */
  void set_mark_category_icon(const Glib::ustring& category, const Glib::ustring& name);

  /** Unsets the icon used for @a category.
   *
   * @param category A mark category.
   *
   * @newin{2,10}
   */
  void unset_mark_category_icon(const Glib::ustring& category);

  
  /** Sets given background @a color for mark @a category.
   *
   * @param category A mark category.
   * @param color Background color.
   *
   * @newin{2,10}
   */
  void set_mark_category_background(const Glib::ustring& category, const Gdk::Color& color);

  /** Unsets background for mark @a category.
   *
   * @param category A mark category.
   *
   * @newin{2,10}
   */
  void unset_mark_category_background(const Glib::ustring& category);

  
  /** Gets the background color associated with given @a category.
   *
   * @param category A mark category.
   * @param dest Destination Gdk::Color structure to fill in.
   *
   * @return @c true if background color for @a category was set and @a dest is
   * set to a valid color, or @c false otherwise.
   *
   * @newin{2,10}
   */
  bool get_mark_category_background(const Glib::ustring& category, Gdk::Color& dest) const;

  
  /** Set if and how the spaces should be visualized.
   *
   * Specifying @a flags as 0 will disable display of spaces.
   *
   * @param flags SourceDrawSpacesFlags specifing how white spaces should be
   * displayed.
   */
  void set_draw_spaces(SourceDrawSpacesFlags flags = SOURCE_DRAW_SPACES_ALL);

  
  /** Returns the SourceDrawSpacesFlags specifying if and how spaces should be
   *  displayed.
   *
   * @return The SourceDrawSpacesFlags, 0 if no spaces should be drawn.
   */
  SourceDrawSpacesFlags get_draw_spaces() const;

  /** Slot holding a function.
   *
   * @par Prototype:
   * <tt>Glib::ustring on_mark_tooltip(const Glib::RefPtr<SourceMark>& mark);</tt>
   *
   * @newin{2,10}
   */
  typedef sigc::slot<Glib::ustring, const Glib::RefPtr<SourceMark>& /* mark */> SlotMarkTooltip;

  
  /** Set a SlotMarkTooltip used to set tooltip on marks from the given mark
   *  @a category.
   *
   * If you also specified a function with
   * set_mark_category_tooltip_markup_func() the markup variant takes
   * precedence.
   *
   * @code
   * static Glib::ustring
   * tooltip_func (gtksourceview::SourceMark *mark)
   * {
   *   return get_tooltip_for_mark(mark);
   * }
   *
   * ...
   *
   * SourceView view;
   *
   * view->set_mark_category_tooltip_func("other-mark",
   *                                      sigc::ptr_fun(&tooltip_func));
   * @endcode
   *
   * @param category A mark category.
   * @param slot A SlotMarkTooltip.
   *
   * @newin{2,10}
   */
  void set_mark_category_tooltip_func(const Glib::ustring& category, const SlotMarkTooltip& slot);

  /** Set a SlotMarkTooltip used to set tooltip on marks from the given mark
   *  @a category.
   *
   * See set_mark_category_tooltip_func() for more information.
   *
   * @param category A mark category.
   * @param slot A SlotMarkTooltip.
   *
   * @newin{2,10}
   */
  void set_mark_category_tooltip_markup_func(const Glib::ustring& category, const SlotMarkTooltip& slot);

  /** Unsets a function used to set tooltip marks from the given mark
   *  @a category.
   *
   * @param category A mark category.
   *
   * @newin{2,10}
   */
  void unset_mark_category_tooltip_func(const Glib::ustring& category);

  
  /** Returns the SourceGutter object associated with @a window_type for this
   *  view.
   *
   * Only Gtk::TEXT_WINDOW_LEFT and Gtk::TEXT_WINDOW_RIGHT are supported,
   * respectively corresponding to the left and right gutter. The line numbers
   * and mark category icons are rendered in the gutter corresponding to
   * Gtk::TEXT_WINDOW_LEFT.
   *
   * @param window_type The gutter window type
   *
   * @return The SourceGutter.
   *
   * @newin{2,10}
   *
   */
  Glib::RefPtr<SourceGutter> get_gutter(Gtk::TextWindowType window_type);

  
  /** Returns the SourceGutter object associated with @a window_type for this
   *  view.
   *
   * Only Gtk::TEXT_WINDOW_LEFT and Gtk::TEXT_WINDOW_RIGHT are supported,
   * respectively corresponding to the left and right gutter. The line numbers
   * and mark category icons are rendered in the gutter corresponding to
   * Gtk::TEXT_WINDOW_LEFT.
   *
   * @param window_type The gutter window type
   *
   * @return The SourceGutter.
   *
   * @newin{2,10}
   *
   */
  Glib::RefPtr<const SourceGutter> get_gutter(Gtk::TextWindowType window_type) const;

  
  /** Gets the SourceCompletion associated with this view.
   *
   * @return The SourceCompletion associated with this view.
   *
   * @newin{2,10}
   */
  SourceCompletion* get_completion();

  
  /** Gets the SourceCompletion associated with this view.
   *
   * @return The SourceCompletion associated with this view.
   *
   * @newin{2,10}
   */
  const SourceCompletion* get_completion() const;

  /** Emitted when redo action is requested.
   *
   * @par Prototype:
   * <tt>void on_my_%redo()</tt>
   */

  Glib::SignalProxy0< void > signal_redo();


  /** Emitted when undo action is requested.
   *
   * @par Prototype:
   * <tt>void on_my_%undo()</tt>
   */

  Glib::SignalProxy0< void > signal_undo();

// TODO: remove no_default_handler when we will break API/ABI. krnowak

  /** Emitted when a line mark has been activated (for instance when there
   * was a button press in the line marks gutter).
   *
   * You can use @a iter to determine on which line the activation took place.
   *
   * @par Handler parameters:
   * iter A Gtk::TextIter.
   * event The GdkEvent that activated the event.
   *
   * @par Prototype:
   * <tt>void on_my_%line_mark_activated(Gtk::TextIter& mark, GdkEvent* event)</tt>
   */

  Glib::SignalProxy2< void,Gtk::TextIter&,GdkEvent* > signal_line_mark_activated();


  // these are keybinding signals, so we ignore them.
  
  
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to display line numbers.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_line_numbers() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to display line numbers.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_line_numbers() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to display line mark pixbufs.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_line_marks() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to display line mark pixbufs.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_line_marks() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Width of a tab character expressed in spaces.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_tab_width() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Width of a tab character expressed in spaces.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_tab_width() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Number of spaces to use for each step of indent.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_indent_width() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Number of spaces to use for each step of indent.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_indent_width() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to enable auto indentation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_auto_indent() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to enable auto indentation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_auto_indent() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to insert spaces instead of tabs.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_insert_spaces_instead_of_tabs() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to insert spaces instead of tabs.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_insert_spaces_instead_of_tabs() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to display the right margin.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_right_margin() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to display the right margin.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_right_margin() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Position of the right margin.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_right_margin_position() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Position of the right margin.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_right_margin_position() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** HOME and END keys move to first/last non whitespace characters on line before going to the start/end of the line.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<SourceSmartHomeEndType> property_smart_home_end() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** HOME and END keys move to first/last non whitespace characters on line before going to the start/end of the line.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<SourceSmartHomeEndType> property_smart_home_end() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to highlight the current line.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_highlight_current_line() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to highlight the current line.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_highlight_current_line() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to indent the selected text when the tab key is pressed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_indent_on_tab() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to indent the selected text when the tab key is pressed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_indent_on_tab() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Set if and how the spaces should be visualized.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<SourceDrawSpacesFlags> property_draw_spaces() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Set if and how the spaces should be visualized.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<SourceDrawSpacesFlags> property_draw_spaces() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} /* namespace gtksourceview */


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates gtksourceview::SourceView
   */
  gtksourceview::SourceView* wrap(GtkSourceView* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKSOURCEVIEWMM_SOURCEVIEW_H */

