// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKSOURCEVIEWMM_SOURCEITER_H
#define _GTKSOURCEVIEWMM_SOURCEITER_H


#include <glibmm.h>

/* sourceiter.h
 *
 * Copyright (C) 2004-2005 Jae Jang
 * Copyright (C) 2005-2006 Rob Page
 * Copyright (C) 2005-2006 Dodji Seketeli
 * Copyright (C) 2010 Krzesimir Nowak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/// \file
/// \brief SourceIter class

#include <gtkmm/textiter.h>


namespace gtksourceview
{

#ifndef GTKSOURCEVIEWMM_DISABLE_DEPRECATED
  /** @addtogroup gtksourceviewmmEnums Enums and Flags */

/**
 * @ingroup gtksourceviewmmEnums
 * @par Bitwise operators:
 * <tt>%SearchFlags operator|(SearchFlags, SearchFlags)</tt><br>
 * <tt>%SearchFlags operator&(SearchFlags, SearchFlags)</tt><br>
 * <tt>%SearchFlags operator^(SearchFlags, SearchFlags)</tt><br>
 * <tt>%SearchFlags operator~(SearchFlags)</tt><br>
 * <tt>%SearchFlags& operator|=(SearchFlags&, SearchFlags)</tt><br>
 * <tt>%SearchFlags& operator&=(SearchFlags&, SearchFlags)</tt><br>
 * <tt>%SearchFlags& operator^=(SearchFlags&, SearchFlags)</tt><br>
 */
enum SearchFlags
{
  SEARCH_VISIBLE_ONLY = 1 << 0,
  SEARCH_TEXT_ONLY = 1 << 1,
  SEARCH_CASE_INSENSITIVE = 1 << 2
};

/** @ingroup gtksourceviewmmEnums */
inline SearchFlags operator|(SearchFlags lhs, SearchFlags rhs)
  { return static_cast<SearchFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtksourceviewmmEnums */
inline SearchFlags operator&(SearchFlags lhs, SearchFlags rhs)
  { return static_cast<SearchFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtksourceviewmmEnums */
inline SearchFlags operator^(SearchFlags lhs, SearchFlags rhs)
  { return static_cast<SearchFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtksourceviewmmEnums */
inline SearchFlags operator~(SearchFlags flags)
  { return static_cast<SearchFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gtksourceviewmmEnums */
inline SearchFlags& operator|=(SearchFlags& lhs, SearchFlags rhs)
  { return (lhs = static_cast<SearchFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtksourceviewmmEnums */
inline SearchFlags& operator&=(SearchFlags& lhs, SearchFlags rhs)
  { return (lhs = static_cast<SearchFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtksourceviewmmEnums */
inline SearchFlags& operator^=(SearchFlags& lhs, SearchFlags rhs)
  { return (lhs = static_cast<SearchFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace gtksourceview


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<gtksourceview::SearchFlags> : public Glib::Value_Flags<gtksourceview::SearchFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace gtksourceview
{

#endif // GTKSOURCEVIEWMM_DISABLE_DEPRECATED
  /**
 * @ingroup gtksourceviewmmEnums
 * @par Bitwise operators:
 * <tt>%SourceSearchFlags operator|(SourceSearchFlags, SourceSearchFlags)</tt><br>
 * <tt>%SourceSearchFlags operator&(SourceSearchFlags, SourceSearchFlags)</tt><br>
 * <tt>%SourceSearchFlags operator^(SourceSearchFlags, SourceSearchFlags)</tt><br>
 * <tt>%SourceSearchFlags operator~(SourceSearchFlags)</tt><br>
 * <tt>%SourceSearchFlags& operator|=(SourceSearchFlags&, SourceSearchFlags)</tt><br>
 * <tt>%SourceSearchFlags& operator&=(SourceSearchFlags&, SourceSearchFlags)</tt><br>
 * <tt>%SourceSearchFlags& operator^=(SourceSearchFlags&, SourceSearchFlags)</tt><br>
 */
enum SourceSearchFlags
{
  SOURCE_SEARCH_VISIBLE_ONLY = 1 << 0,
  SOURCE_SEARCH_TEXT_ONLY = 1 << 1,
  SOURCE_SEARCH_CASE_INSENSITIVE = 1 << 2
};

/** @ingroup gtksourceviewmmEnums */
inline SourceSearchFlags operator|(SourceSearchFlags lhs, SourceSearchFlags rhs)
  { return static_cast<SourceSearchFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtksourceviewmmEnums */
inline SourceSearchFlags operator&(SourceSearchFlags lhs, SourceSearchFlags rhs)
  { return static_cast<SourceSearchFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtksourceviewmmEnums */
inline SourceSearchFlags operator^(SourceSearchFlags lhs, SourceSearchFlags rhs)
  { return static_cast<SourceSearchFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtksourceviewmmEnums */
inline SourceSearchFlags operator~(SourceSearchFlags flags)
  { return static_cast<SourceSearchFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gtksourceviewmmEnums */
inline SourceSearchFlags& operator|=(SourceSearchFlags& lhs, SourceSearchFlags rhs)
  { return (lhs = static_cast<SourceSearchFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtksourceviewmmEnums */
inline SourceSearchFlags& operator&=(SourceSearchFlags& lhs, SourceSearchFlags rhs)
  { return (lhs = static_cast<SourceSearchFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtksourceviewmmEnums */
inline SourceSearchFlags& operator^=(SourceSearchFlags& lhs, SourceSearchFlags rhs)
  { return (lhs = static_cast<SourceSearchFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace gtksourceview


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<gtksourceview::SourceSearchFlags> : public Glib::Value_Flags<gtksourceview::SourceSearchFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace gtksourceview
{


/// \brief an iterator type for gtksourceview::SourceBuffer.
///
/// it provides search features
class SourceIter : public Gtk::TextIter
{
    public:

        /// \name constructors
        /// @{
        SourceIter () ;
        SourceIter (const Gtk::TextIter &iter) ;
        SourceIter (const GtkTextIter* gobject) ;
        SourceIter (const SourceIter &a_iter) ;
        /// @}

        ~SourceIter () ;

#ifndef GTKSOURCEVIEWMM_DISABLE_DEPRECATED
        /// \brief search forward in the buffer
        ///
        /// \param a_str the string to search for
        /// \param a_flags search flags, to be combined with the '|' operator
        /// \param a_match_start out parameter. Points the the beginning
        ///        of the region that matches the search. This is applicable
        ///        if and only if the function returns true.
        /// \param a_match_end out parameter.  Points the the end
        ///        of the region that matches the search. This is applicable
        ///        if and only if the function returns true.
        /// \return true if the search was successful, false otherwise.
        bool forward_search (const Glib::ustring &a_str,
                             SearchFlags a_flags,
                             Gtk::TextIter &a_match_start,
                             Gtk::TextIter &a_match_end,
                             const Gtk::TextIter &a_limit) const ;

        /// \brief search backward in the buffer
        ///
        /// \param a_str the string to search for
        /// \param a_flags search flags, to be combined with the '|' operator
        /// \param a_match_start out parameter. Points the the beginning
        ///        of the region that matches the search. This is applicable
        ///        if and only if the function returns true.
        /// \param a_match_end out parameter.  Points the the end
        ///        of the region that matches the search. This is applicable
        ///         if and only if the function returns true.
        /// \return true if the search was successful, false otherwise.
        bool backward_search (const Glib::ustring &a_str,
                              SearchFlags a_flags,
                              Gtk::TextIter &a_match_start,
                              Gtk::TextIter &a_match_end,
                              const Gtk::TextIter &a_limit) const ;
#endif // GTKSOURCEVIEWMM_DISABLE_DEPRECATED

        /// \brief search forward in the buffer
        ///
        /// \param a_str the string to search for
        /// \param a_flags search flags, to be combined with the '|' operator
        /// \param a_match_start out parameter. Points the the beginning
        ///        of the region that matches the search. This is applicable
        ///        if and only if the function returns true.
        /// \param a_match_end out parameter.  Points the the end
        ///        of the region that matches the search. This is applicable
        ///        if and only if the function returns true.
        /// \return true if the search was successful, false otherwise.
        bool forward_search (const Glib::ustring &a_str,
                             SourceSearchFlags a_flags,
                             Gtk::TextIter &a_match_start,
                             Gtk::TextIter &a_match_end,
                             const Gtk::TextIter &a_limit) const ;

        /// \brief same as forward_search(), but searchs to the end.
        ///
        /// \param a_str the string to search for
        /// \param a_flags search flags, to be combined with the '|' operator
        /// \param a_match_start out parameter. Points the the beginning
        ///        of the region that matches the search. This is applicable
        ///        if and only if the function returns true.
        /// \param a_match_end out parameter.  Points the the end
        ///        of the region that matches the search. This is applicable
        ///        if and only if the function returns true.
        /// \return true if the search was successful, false otherwise.
        bool forward_search (const Glib::ustring &a_str,
                             SourceSearchFlags a_flags,
                             Gtk::TextIter &a_match_start,
                             Gtk::TextIter &a_match_end) const ;

        /// \brief search backward in the buffer
        ///
        /// \param a_str the string to search for
        /// \param a_flags search flags, to be combined with the '|' operator
        /// \param a_match_start out parameter. Points the the beginning
        ///        of the region that matches the search. This is applicable
        ///        if and only if the function returns true.
        /// \param a_match_end out parameter.  Points the the end
        ///        of the region that matches the search. This is applicable
        ///         if and only if the function returns true.
        /// \return true if the search was successful, false otherwise.
        bool backward_search (const Glib::ustring &a_str,
                              SourceSearchFlags a_flags,
                              Gtk::TextIter &a_match_start,
                              Gtk::TextIter &a_match_end,
                              const Gtk::TextIter &a_limit) const ;

        /// \brief same as backward_search(), but searchs to the start.
        ///
        /// \param a_str the string to search for
        /// \param a_flags search flags, to be combined with the '|' operator
        /// \param a_match_start out parameter. Points the the beginning
        ///        of the region that matches the search. This is applicable
        ///        if and only if the function returns true.
        /// \param a_match_end out parameter.  Points the the end
        ///        of the region that matches the search. This is applicable
        ///         if and only if the function returns true.
        /// \return true if the search was successful, false otherwise.
        bool backward_search (const Glib::ustring &a_str,
                              SourceSearchFlags a_flags,
                              Gtk::TextIter &a_match_start,
                              Gtk::TextIter &a_match_end) const ;

};//end class SourceIter


}//end namespace gtksourceview


#endif /* _GTKSOURCEVIEWMM_SOURCEITER_H */

