// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKSOURCEVIEWMM_SOURCELANGUAGEMANAGER_H
#define _GTKSOURCEVIEWMM_SOURCELANGUAGEMANAGER_H


#include <glibmm.h>

/* sourcelanguagemanager.h
 *
 * Copyright (C) 2004-2005 Jae Jang
 * Copyright (C) 2005-2006 Rob Page
 * Copyright (C) 2006 Dodji Seketeli
 * Copyright (C) 2009, 2010 Krzesimir Nowak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/// \file
/// \brief SourceLanguageManager class

#include <glibmm/object.h>
#include <gtksourceviewmm/sourcelanguage.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkSourceLanguageManager GtkSourceLanguageManager;
typedef struct _GtkSourceLanguageManagerClass GtkSourceLanguageManagerClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace gtksourceview
{ class SourceLanguageManager_Class; } // namespace gtksourceview
namespace gtksourceview
{


/** Class which provides access to SourceLanguages.
 *
 * SourceLanguageManager is a class which processes language description files
 * and creates and stores SourceLanguage objects, and provides API to access
 * them.
 *
 * Use get_default() to retrieve the default instance of SourceLanguageManager,
 * and guess_language() to get a SourceLanguage for given file name and content
 * type.
 */

class SourceLanguageManager : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef SourceLanguageManager CppObjectType;
  typedef SourceLanguageManager_Class CppClassType;
  typedef GtkSourceLanguageManager BaseObjectType;
  typedef GtkSourceLanguageManagerClass BaseClassType;

private:  friend class SourceLanguageManager_Class;
  static CppClassType sourcelanguagemanager_class_;

private:
  // noncopyable
  SourceLanguageManager(const SourceLanguageManager&);
  SourceLanguageManager& operator=(const SourceLanguageManager&);

protected:
  explicit SourceLanguageManager(const Glib::ConstructParams& construct_params);
  explicit SourceLanguageManager(GtkSourceLanguageManager* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~SourceLanguageManager();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkSourceLanguageManager*       gobj()       { return reinterpret_cast<GtkSourceLanguageManager*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkSourceLanguageManager* gobj() const { return reinterpret_cast<GtkSourceLanguageManager*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkSourceLanguageManager* gobj_copy();

private:

protected:
  SourceLanguageManager();

public:

  /** Creates a new language manager.
   *
   * If you do not need more than one language manager or a private language
   * manager instance then use get_default() instead.
   *
   * Returns: A SourceLanguageManager.
   */
  
  static Glib::RefPtr<SourceLanguageManager> create();


  /** Returns the default SourceLanguageManager instance.
   *
   * Returns: A SourceLanguageManager.
   */
  static Glib::RefPtr<SourceLanguageManager> get_default();

 
  // TODO: define own string array to use std::string, instead of Glib::ustring, when we break API/ABI. krnowak
  
  /** Gets the list directories where language manager looks for language files.
   *
   * @return An array containg a list of language files directories.
   */
  Glib::StringArrayHandle get_search_path() const;

 
  // TODO: see previous one. Also this is probably buggy, because we need NULL termination in C array and Glib::StringArrayHandle does not provide it - fixing it will break ABI. krnowak
  
  /** Sets the list of directories where the language manager looks for language
   *  files.
   *
   * @note At the moment this function can be called only before the language
   * files are loaded for the first time. In practice to set a custom search
   * path for a SourceLanguageManager, you have to call this function right
   * after creating it.
   *
   * @param dirs An empty string terminated array of strings.
   */
  void set_search_path(const Glib::StringArrayHandle& dirs);

  /** Resets the list of directories where the language manager looks for
   *  language files to default.
   *
   * @note At the moment this function can be called only before the language
   * files are loaded for the first time. In practice to set a custom search
   * path for a SourceLanguageManager, you have to call this function right
   * after creating it.
   */
  void reset_search_path();

  
  /** Returns the ids of the available languages.
   *
   * @return An array of string containing the ids of the available languages.
   */
  Glib::StringArrayHandle get_language_ids() const;

  
  /** Gets the SourceLanguage identified by the given @a id in the language
   *  manager.
   *
   * @param id A language id.
   *
   * @return A SourceLanguage, or empty Glib::RefPtr if there is no language
   * identified by the given @a id.
   */
  Glib::RefPtr<SourceLanguage> get_language(const Glib::ustring& id);

  
  /** Gets the SourceLanguage identified by the given @a id in the language
   *  manager.
   *
   * @param id A language id.
   *
   * @return A SourceLanguage, or empty Glib::RefPtr if there is no language
   * identified by the given @a id.
   */
  Glib::RefPtr<const SourceLanguage> get_language(const Glib::ustring& id) const;
  
// TODO: change filename parameter to std::string, when we break API/ABI.
  
  /** Picks a SourceLanguage for given file name and content type,
   *  according to the information in lang files.
   *
   * Either @a filename or @a content_type may be an empty string. This function
   * can be used as follows:
   *
   * @code
   * Glib::RefPtr<SourceLanguage> lang;
   * lang = lm->guess_language(filename, Glib::ustring());
   * buffer->set_language(lang);
   * @endcode
   *
   * or
   *
   * @code
   * Glib::RefPtr<SourceLanguage> lang;
   * bool result_uncertain = FALSE;
   * Glib::ustring content_type;
   *
   * content_type = Gio::content_type_guess(filename, 0, 0, &result_uncertain);
   * if (result_uncertain)
   * {
   *   content_type.clear();
   * }
   *
   * lang = lm->guess_language(filename, content_type);
   * buffer->set_language(lang);
   * @endcode
   *
   * etc. Use get_mime_types() and get_globs() if you need full control over
   * file -> language mapping.
   *
   * @param filename A filename, or empty string.
   * @param content_type A content type (as in GIO API), or empty string.
   *
   * @return A SourceLanguage, or empty Glib::RefPtr if there is no suitable
   * language for given @a filename and/or @a content_type.
   */
  Glib::RefPtr<SourceLanguage> guess_language(const Glib::ustring& filename, const Glib::ustring& content_type);

  /** Picks a SourceLanguage for given file name and content type,
   *  according to the information in lang files.
   *
   * Either @a filename or @a content_type may be an empty string. This function
   * can be used as follows:
   *
   * @code
   * Glib::RefPtr<SourceLanguageManager> lm = SourceLanguageManager::get_default();
   * Glib::RefPtr<SourceLanguage> lang;
   * Glib::RefPtr<SourceBuffer> buffer = SourceBuffer::create();
   * lang = lm->guess_language(filename, Glib::ustring());
   * buffer->set_language(lang);
   * // or just:
   * // Glib::RefPtr<SourceBuffer> buffer = SourceBuffer::create(lang);
   * @endcode
   *
   * or
   *
   * @code
   * Glib::RefPtr<SourceLanguage> lang;
   * Glib::RefPtr<SourceLanguageManager> lm = SourceLanguageManager::get_default();
   * Glib::RefPtr<SourceBuffer> buffer = SourceBuffer::create();
   * bool result_uncertain = FALSE;
   * Glib::ustring content_type;
   *
   * content_type = Gio::content_type_guess(filename, 0, 0, &result_uncertain);
   * if (result_uncertain)
   * {
   *   content_type.clear();
   * }
   *
   * lang = lm->guess_language(filename, content_type);
   * buffer->set_language(lang);
   * // or just:
   * // Glib::RefPtr<SourceBuffer> buffer = SourceBuffer::create(lang);
   * @endcode
   *
   * etc. Use SourceLanguage::get_mime_types() and SourceLanguage::get_globs()
   * if you need full control over file -> language mapping.
   *
   * @param filename A filename, or empty string.
   * @param content_type A content type (as in GIO API), or empty string.
   *
   * @return A SourceLanguage, or empty Glib::RefPtr if there is no suitable
   * language for given @a filename and/or @a content_type.
   */
  Glib::RefPtr<const SourceLanguage> guess_language(const Glib::ustring& filename, const Glib::ustring& content_type) const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} /* namespace gtksourceview */


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates gtksourceview::SourceLanguageManager
   */
  Glib::RefPtr<gtksourceview::SourceLanguageManager> wrap(GtkSourceLanguageManager* object, bool take_copy = false);
}


#endif /* _GTKSOURCEVIEWMM_SOURCELANGUAGEMANAGER_H */

