// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKSOURCEVIEWMM_SOURCEITER_H
#define _GTKSOURCEVIEWMM_SOURCEITER_H


#include <glibmm.h>

/* sourceiter.h
 *
 * Copyright (C) 2004-2005 Jae Jang
 * Copyright (C) 2005-2006 Rob Page
 * Copyright (C) 2005-2006 Dodji Seketeli
 * Copyright (C) 2010 Krzesimir Nowak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/textiter.h>


namespace gtksourceview
{

#ifndef GTKSOURCEVIEWMM_DISABLE_DEPRECATED
  /** @addtogroup gtksourceviewmmEnums gtksourceviewmm Enums and Flags */

/** Flags specifying how search has to be done.
   *
   * @deprecated Use SourceSearchFlags.
 * @ingroup gtksourceviewmmEnums
 * @par Bitwise operators:
 * <tt>%SearchFlags operator|(SearchFlags, SearchFlags)</tt><br>
 * <tt>%SearchFlags operator&(SearchFlags, SearchFlags)</tt><br>
 * <tt>%SearchFlags operator^(SearchFlags, SearchFlags)</tt><br>
 * <tt>%SearchFlags operator~(SearchFlags)</tt><br>
 * <tt>%SearchFlags& operator|=(SearchFlags&, SearchFlags)</tt><br>
 * <tt>%SearchFlags& operator&=(SearchFlags&, SearchFlags)</tt><br>
 * <tt>%SearchFlags& operator^=(SearchFlags&, SearchFlags)</tt><br>
 */
enum SearchFlags
{
  SEARCH_VISIBLE_ONLY = 1 << 0,
  SEARCH_TEXT_ONLY = 1 << 1,
  SEARCH_CASE_INSENSITIVE = 1 << 2
};

/** @ingroup gtksourceviewmmEnums */
inline SearchFlags operator|(SearchFlags lhs, SearchFlags rhs)
  { return static_cast<SearchFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtksourceviewmmEnums */
inline SearchFlags operator&(SearchFlags lhs, SearchFlags rhs)
  { return static_cast<SearchFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtksourceviewmmEnums */
inline SearchFlags operator^(SearchFlags lhs, SearchFlags rhs)
  { return static_cast<SearchFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtksourceviewmmEnums */
inline SearchFlags operator~(SearchFlags flags)
  { return static_cast<SearchFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gtksourceviewmmEnums */
inline SearchFlags& operator|=(SearchFlags& lhs, SearchFlags rhs)
  { return (lhs = static_cast<SearchFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtksourceviewmmEnums */
inline SearchFlags& operator&=(SearchFlags& lhs, SearchFlags rhs)
  { return (lhs = static_cast<SearchFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtksourceviewmmEnums */
inline SearchFlags& operator^=(SearchFlags& lhs, SearchFlags rhs)
  { return (lhs = static_cast<SearchFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace gtksourceview


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<gtksourceview::SearchFlags> : public Glib::Value_Flags<gtksourceview::SearchFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace gtksourceview
{

  /** @var SearchFlags SEARCH_VISIBLE_ONLY
   * No whitespaces?
   */
  /** @var SearchFlags SEARCH_TEXT_ONLY
   * Text only?
   */
  /** @var SearchFlags SEARCH_CASE_INSENSITIVE
   * Perform a case insensitive search.
   */
#endif // GTKSOURCEVIEWMM_DISABLE_DEPRECATED
  /** Flags specifying how search has to be done.
   *
   * @newin{2,10}
 * @ingroup gtksourceviewmmEnums
 * @par Bitwise operators:
 * <tt>%SourceSearchFlags operator|(SourceSearchFlags, SourceSearchFlags)</tt><br>
 * <tt>%SourceSearchFlags operator&(SourceSearchFlags, SourceSearchFlags)</tt><br>
 * <tt>%SourceSearchFlags operator^(SourceSearchFlags, SourceSearchFlags)</tt><br>
 * <tt>%SourceSearchFlags operator~(SourceSearchFlags)</tt><br>
 * <tt>%SourceSearchFlags& operator|=(SourceSearchFlags&, SourceSearchFlags)</tt><br>
 * <tt>%SourceSearchFlags& operator&=(SourceSearchFlags&, SourceSearchFlags)</tt><br>
 * <tt>%SourceSearchFlags& operator^=(SourceSearchFlags&, SourceSearchFlags)</tt><br>
 */
enum SourceSearchFlags
{
  SOURCE_SEARCH_VISIBLE_ONLY = 1 << 0,
  SOURCE_SEARCH_TEXT_ONLY = 1 << 1,
  SOURCE_SEARCH_CASE_INSENSITIVE = 1 << 2
};

/** @ingroup gtksourceviewmmEnums */
inline SourceSearchFlags operator|(SourceSearchFlags lhs, SourceSearchFlags rhs)
  { return static_cast<SourceSearchFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtksourceviewmmEnums */
inline SourceSearchFlags operator&(SourceSearchFlags lhs, SourceSearchFlags rhs)
  { return static_cast<SourceSearchFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtksourceviewmmEnums */
inline SourceSearchFlags operator^(SourceSearchFlags lhs, SourceSearchFlags rhs)
  { return static_cast<SourceSearchFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtksourceviewmmEnums */
inline SourceSearchFlags operator~(SourceSearchFlags flags)
  { return static_cast<SourceSearchFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gtksourceviewmmEnums */
inline SourceSearchFlags& operator|=(SourceSearchFlags& lhs, SourceSearchFlags rhs)
  { return (lhs = static_cast<SourceSearchFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtksourceviewmmEnums */
inline SourceSearchFlags& operator&=(SourceSearchFlags& lhs, SourceSearchFlags rhs)
  { return (lhs = static_cast<SourceSearchFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtksourceviewmmEnums */
inline SourceSearchFlags& operator^=(SourceSearchFlags& lhs, SourceSearchFlags rhs)
  { return (lhs = static_cast<SourceSearchFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace gtksourceview


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<gtksourceview::SourceSearchFlags> : public Glib::Value_Flags<gtksourceview::SourceSearchFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace gtksourceview
{

  /** @var SourceSearchFlags SOURCE_SEARCH_VISIBLE_ONLY
   * No whitespaces?
   */
  /** @var SourceSearchFlags SOURCE_SEARCH_TEXT_ONLY
   * Text only?
   */
  /** @var SourceSearchFlags SOURCE_SEARCH_CASE_INSENSITIVE
   * Perform a case insensitive search.
   */

/** An iterator type for SourceBuffer.
 *
 * Provides search features.
 */
class SourceIter : public Gtk::TextIter
{
public:

  /** Default constructor.
   *
   * @return New SourceIter.
   */
  SourceIter () ;

  /* Constructs SourceIter from Gtk::TextIter.
   *
   * @return New SourceIter.
   */
  SourceIter (const Gtk::TextIter &iter) ;

  /* Constructs SourceIter from C GtkTextIter.
   *
   * @return New SourceIter.
   */
  SourceIter (const GtkTextIter* gobject) ;

  /* Copy constructor.
   *
   * @return New SourceIter.
   */
  SourceIter (const SourceIter &a_iter) ;

  ~SourceIter () ;

#ifndef GTKSOURCEVIEWMM_DISABLE_DEPRECATED
  /** Searches forward for @a a_str.
   *
   * Any match is returned by setting @a a_match_start to the first character of
   * the match and @a a_match_end to the first character after the match. The
   * search will not continue past @a a_limit. Note that a search is a linear or
   * O(n) operation, so you may wish to use @a a_limit to avoid locking up your
   * UI on large buffers.
   *
   * If the SEARCH_VISIBLE_ONLY flag is present, the match may have invisible
   * text interspersed in @a a_str. i.e. @a a_str will be a
   * possibly-noncontiguous subsequence of the matched range. Similarly, if you
   * specify SEARCH_TEXT_ONLY, the match may have pixbufs or child widgets mixed
   * inside the matched range. If these flags are not given, the match must be
   * exact; the special @c 0xFFFC character in @a a_str will match embedded
   * pixbufs or child widgets. If you specify the SEARCH_CASE_INSENSITIVE flag,
   * the text will be matched regardless of what case it is in.
   *
   * Same as Gtk::TextIter::forward_search(), but supports case insensitive
   * searching.
   *
   * @param a_str A search string.
   * @param a_flags Flags affecting how the search is done.
   * @param a_match_start Return location for start of match.
   * @param a_match_end Return location for end of match.
   * @param a_limit Bound for the search.
   *
   * @return Whether a match was found
   *
   * @deprecated Use method using SourceSearchFlags.
   */
  bool forward_search (const Glib::ustring &a_str,
                       SearchFlags a_flags,
                       Gtk::TextIter &a_match_start,
                       Gtk::TextIter &a_match_end,
                       const Gtk::TextIter &a_limit) const ;

  /** Searches backward for @a a_str.
   *
   * Same as forward_search(), but backwards.
   *
   * @param a_str A search string.
   * @param a_flags Flags affecting how the search is done.
   * @param a_match_start Return location for start of match.
   * @param a_match_end Return location for end of match.
   * @param a_limit Bound for the search.
   *
   * @return Whether a match was found.
   *
   * @deprecated Use method using SourceSearchFlags.
   */
  bool backward_search (const Glib::ustring &a_str,
                        SearchFlags a_flags,
                        Gtk::TextIter &a_match_start,
                        Gtk::TextIter &a_match_end,
                        const Gtk::TextIter &a_limit) const ;
#endif // GTKSOURCEVIEWMM_DISABLE_DEPRECATED

  /** Searches forward for @a str.
   *
   * Any match is returned by setting @a match_start to the first character of
   * the match and @a match_end to the first character after the match. The
   * search will not continue past @a limit. Note that a search is a linear or
   * O(n) operation, so you may wish to use @a limit to avoid locking up your
   * UI on large buffers.
   *
   * If the SEARCH_VISIBLE_ONLY flag is present, the match may have invisible
   * text interspersed in @a str. i.e. @a str will be a
   * possibly-noncontiguous subsequence of the matched range. Similarly, if you
   * specify SEARCH_TEXT_ONLY, the match may have pixbufs or child widgets mixed
   * inside the matched range. If these flags are not given, the match must be
   * exact; the special @c 0xFFFC character in @a str will match embedded
   * pixbufs or child widgets. If you specify the SEARCH_CASE_INSENSITIVE flag,
   * the text will be matched regardless of what case it is in.
   *
   * Same as Gtk::TextIter::forward_search(), but supports case insensitive
   * searching.
   *
   * @param str A search string.
   * @param flags Flags affecting how the search is done.
   * @param match_start Return location for start of match.
   * @param match_end Return location for end of match.
   * @param limit Bound for the search.
   *
   * @return Whether a match was found
   *
   * @newin{2,10}
   */
  bool forward_search (const Glib::ustring& str,
                       SourceSearchFlags flags,
                       Gtk::TextIter& match_start,
                       Gtk::TextIter& match_end,
                       const Gtk::TextIter& limit) const ;

  /** Searches forward for @a str.
   *
   * Same as forward_search(), but searches to the
   * end.
   *
   * @param str A search string.
   * @param flags Flags affecting how the search is done.
   * @param match_start Return location for start of match.
   * @param match_end Return location for end of match.
   *
   * @return Whether a match was found.
   *
   * @newin{2,10}
   */
  bool forward_search (const Glib::ustring& str,
                       SourceSearchFlags flags,
                       Gtk::TextIter& match_start,
                       Gtk::TextIter& match_end) const ;

  /** Searches backward for @a str.
   *
   * Same as Same as forward_search(), but backwards.
   *
   * @param str A search string.
   * @param flags Flags affecting how the search is done.
   * @param match_start Return location for start of match.
   * @param match_end Return location for end of match.
   * @param limit Bound for the search.
   *
   * @return Whether a match was found.
   *
   * @newin{2,10}
   */
  bool backward_search (const Glib::ustring& str,
                        SourceSearchFlags flags,
                        Gtk::TextIter& match_start,
                        Gtk::TextIter& match_end,
                        const Gtk::TextIter& limit) const ;

  /** Searches backward for @a str.
   *
   * Same as backward_search(), but searches to the
   * start.
   *
   * @param str A search string.
   * @param flags Flags affecting how the search is done.
   * @param match_start Return location for start of match.
   * @param match_end Return location for end of match.
   *
   * @return Whether a match was found.
   *
   * @newin{2,10}
   */
  bool backward_search (const Glib::ustring& str,
                        SourceSearchFlags flags,
                        Gtk::TextIter& match_start,
                        Gtk::TextIter& match_end) const ;

};//end class SourceIter


}//end namespace gtksourceview


#endif /* _GTKSOURCEVIEWMM_SOURCEITER_H */

