// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKSOURCEVIEWMM_SOURCEVIEW_H
#define _GTKSOURCEVIEWMM_SOURCEVIEW_H


#include <glibmm.h>

/* sourceview.h
 *
 * Copyright (C) 2004-2005 Jae Jang
 * Copyright (C) 2005-2006 Rob Page
 * Copyright (C) 2005-2006 Dodji Seketeli
 * Copyright (C) 2009, 2010 Krzesimir Nowak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/textview.h>
#include <gtksourceviewmm/sourcebuffer.h>
#include <gtksourceviewmm/sourcegutter.h>
#include <gtksourceviewmm/sourcecompletion.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkSourceView GtkSourceView;
typedef struct _GtkSourceViewClass GtkSourceViewClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gsv
{ class SourceView_Class; } // namespace Gsv
namespace Gsv
{

class SourceCompletion;
class SourceGutter;
class SourceMarkCategory;

/** @addtogroup gtksourceviewmmEnums gtksourceviewmm Enums and Flags */

/** Defines a behaviour of smart Home/End keys.
 * @ingroup gtksourceviewmmEnums
 */
enum SourceSmartHomeEndType
{
  SOURCE_SMART_HOME_END_DISABLED,
  SOURCE_SMART_HOME_END_BEFORE,
  SOURCE_SMART_HOME_END_AFTER,
  SOURCE_SMART_HOME_END_ALWAYS
};

} // namespace Gsv


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gsv::SourceSmartHomeEndType> : public Glib::Value_Enum<Gsv::SourceSmartHomeEndType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gsv
{

/** @var SourceSmartHomeEndType SOURCE_SMART_HOME_END_DISABLED
 * Smart-home-end disabled.
 */
/** @var SourceSmartHomeEndType SOURCE_SMART_HOME_END_BEFORE
 * Move to the first/last non-whitespace character on the first press of the
 * HOME/END keys and to the beginning/end of the line on the second press.
 */
/** @var SourceSmartHomeEndType SOURCE_SMART_HOME_END_AFTER
 * Move to the beginning/end of the line on the first press of the HOME/END keys
 * and to the first/last non-whitespace character on the second press.
 */
/** @var SourceSmartHomeEndType SOURCE_SMART_HOME_END_ALWAYS
 * Always move to the first/last non-whitespace character when the HOME/END keys
 * are pressed.
 */

/** Determines what kind of whitespaces whould be drawn.
 * @ingroup gtksourceviewmmEnums
 * @par Bitwise operators:
 * <tt>%SourceDrawSpacesFlags operator|(SourceDrawSpacesFlags, SourceDrawSpacesFlags)</tt><br>
 * <tt>%SourceDrawSpacesFlags operator&(SourceDrawSpacesFlags, SourceDrawSpacesFlags)</tt><br>
 * <tt>%SourceDrawSpacesFlags operator^(SourceDrawSpacesFlags, SourceDrawSpacesFlags)</tt><br>
 * <tt>%SourceDrawSpacesFlags operator~(SourceDrawSpacesFlags)</tt><br>
 * <tt>%SourceDrawSpacesFlags& operator|=(SourceDrawSpacesFlags&, SourceDrawSpacesFlags)</tt><br>
 * <tt>%SourceDrawSpacesFlags& operator&=(SourceDrawSpacesFlags&, SourceDrawSpacesFlags)</tt><br>
 * <tt>%SourceDrawSpacesFlags& operator^=(SourceDrawSpacesFlags&, SourceDrawSpacesFlags)</tt><br>
 */
enum SourceDrawSpacesFlags
{
  SOURCE_DRAW_SPACES_SPACE = 1 << 0,
  SOURCE_DRAW_SPACES_TAB = 1 << 1,
  SOURCE_DRAW_SPACES_NEWLINE = 1 << 2,
  SOURCE_DRAW_SPACES_NBSP = 1 << 3,
  SOURCE_DRAW_SPACES_LEADING = 1 << 4,
  SOURCE_DRAW_SPACES_TEXT = 1 << 5,
  SOURCE_DRAW_SPACES_TRAILING = 1 << 6,
  SOURCE_DRAW_SPACES_ALL = 0x7F
};

/** @ingroup gtksourceviewmmEnums */
inline SourceDrawSpacesFlags operator|(SourceDrawSpacesFlags lhs, SourceDrawSpacesFlags rhs)
  { return static_cast<SourceDrawSpacesFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtksourceviewmmEnums */
inline SourceDrawSpacesFlags operator&(SourceDrawSpacesFlags lhs, SourceDrawSpacesFlags rhs)
  { return static_cast<SourceDrawSpacesFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtksourceviewmmEnums */
inline SourceDrawSpacesFlags operator^(SourceDrawSpacesFlags lhs, SourceDrawSpacesFlags rhs)
  { return static_cast<SourceDrawSpacesFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtksourceviewmmEnums */
inline SourceDrawSpacesFlags operator~(SourceDrawSpacesFlags flags)
  { return static_cast<SourceDrawSpacesFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gtksourceviewmmEnums */
inline SourceDrawSpacesFlags& operator|=(SourceDrawSpacesFlags& lhs, SourceDrawSpacesFlags rhs)
  { return (lhs = static_cast<SourceDrawSpacesFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtksourceviewmmEnums */
inline SourceDrawSpacesFlags& operator&=(SourceDrawSpacesFlags& lhs, SourceDrawSpacesFlags rhs)
  { return (lhs = static_cast<SourceDrawSpacesFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtksourceviewmmEnums */
inline SourceDrawSpacesFlags& operator^=(SourceDrawSpacesFlags& lhs, SourceDrawSpacesFlags rhs)
  { return (lhs = static_cast<SourceDrawSpacesFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gsv


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gsv::SourceDrawSpacesFlags> : public Glib::Value_Flags<Gsv::SourceDrawSpacesFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gsv
{

/** @var SourceDrawSpacesFlags SOURCE_DRAW_SPACES_SPACE
 * Whether the space character should be drawn.
 */
/** @var SourceDrawSpacesFlags SOURCE_DRAW_SPACES_TAB
 * Whether the tab character should be drawn.
 */
/** @var SourceDrawSpacesFlags SOURCE_DRAW_SPACES_NEWLINE
 * Whether the line breaks should be drawn.
 */
/** @var SourceDrawSpacesFlags SOURCE_DRAW_SPACES_NBSP
 * Whether the non-breaking whitespaces should be drawn.
 */
/** @var SourceDrawSpacesFlags SOURCE_DRAW_SPACES_ALL
 * Whether all kind of whitespaces should be drawn.
 */

/** The view object.
 *
 * SourceView is the main object of the gtksourceviewmm library. It provides
 * a text view which has syntax highlighting, undo/redo and text marks. Use a
 * SourceBuffer to display text with a GtkSourceView.
 */

class SourceView : public Gtk::TextView
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef SourceView CppObjectType;
  typedef SourceView_Class CppClassType;
  typedef GtkSourceView BaseObjectType;
  typedef GtkSourceViewClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~SourceView();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class SourceView_Class;
  static CppClassType sourceview_class_;

  // noncopyable
  SourceView(const SourceView&);
  SourceView& operator=(const SourceView&);

protected:
  explicit SourceView(const Glib::ConstructParams& construct_params);
  explicit SourceView(GtkSourceView* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkSourceView*       gobj()       { return reinterpret_cast<GtkSourceView*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkSourceView* gobj() const { return reinterpret_cast<GtkSourceView*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_redo();
  virtual void on_undo();
  virtual void on_line_mark_activated(Gtk::TextIter& mark, GdkEvent* event);


private:


public:
  /// The gutter position of the lines renderer.
  static const int gutter_position_lines = -30;
  /// The gutter position of the marks renderer.
  static const int gutter_position_marks = -20;

  /** Creates a new SourceView.
   *
   * An empty default buffer will be created for you. If you want to specify
   * your own buffer, consider the other constructor.
   *
   * @return A new SourceView.
   */
  explicit SourceView () ;

  /** Creates a new SourceView widget displaying the buffer @a buffer.
   *
   * One buffer can be shared among many widgets.
   *
   * @param buffer A SourceBuffer.
   *
   * @return: A new SourceView.
   **/
  explicit SourceView (const Glib::RefPtr<SourceBuffer> &buffer) ;

  /** Returns the GtkTextBuffer being displayed by this text view.
   *
   * @return A SourceBuffer.
   */
  Glib::RefPtr<const SourceBuffer> get_source_buffer () const ;

  /** Returns the GtkTextBuffer being displayed by this text view.
   *
   * @return A SourceBuffer.
   */
  Glib::RefPtr<SourceBuffer> get_source_buffer () ;

  /** Sets a source_buffer as the buffer being displayed by source view.
   *
   * The previous buffer displayed by the text view is unreferenced, and a
   * reference is added to buffer.
   *
   * @param source_buffer A SourceBuffer.
   */
  void set_source_buffer (const Glib::RefPtr<SourceBuffer> &source_buffer) ;

  
  /** If <tt>true</tt> line numbers will be displayed beside the text.
   * @param show Whether line numbers should be displayed.
   */
  void set_show_line_numbers(bool show=true);

  
  /** Returns whether line numbers are displayed beside the text.
   *
   * @return @c true if the line numbers are displayed.
   */
  bool get_show_line_numbers() const;

  
  /** Sets the width of tabulation in characters.
   * @param width Width of tab in characters.
   */
  void set_tab_width(guint width);

  
  /** Returns the width of tabulation in characters.
   *
   * @return Width of tab.
   */
  guint get_tab_width() const;

  
  /** If <tt>true</tt> auto indentation of text is enabled.
   * @param enable Whether to enable auto indentation.
   */
  void set_auto_indent(bool enable=true);

  
  /** Returns whether auto indentation of text is enabled.
   *
   * @return @c true if auto indentation is enabled.
   */
  bool get_auto_indent() const;

  
  /** If <tt>true</tt> any tabulator character inserted is replaced by a group
   * of space characters.
   * @param enable Whether to insert spaces instead of tabs.
   */
  void set_insert_spaces_instead_of_tabs(bool enable=true);

  
  /** Returns whether when inserting a tabulator character it should
   *  be replaced by a group of space characters.
   *
   * @return @c true if spaces are inserted instead of tabs.
   */
  bool get_insert_spaces_instead_of_tabs() const;

  
  /** If <tt>true</tt> a right margin is displayed.
   * @param show Whether to show a right margin.
   */
  void set_show_right_margin(bool show = true);

  
  /** Returns whether a right margin is displayed.
   *
   * @return @c true if the right margin is shown.
   */
  bool get_show_right_margin() const;

  
  /** If @a highlight is @c true the current line is highlighted.
   *
   * @param highlight Whether to highlight the current line.
   */
  void set_highlight_current_line(bool highlight = true);

  
  /** Returns whether the current line is highlighted.
   *
   * @return @c true if the current line is highlighted.
   */
  bool get_highlight_current_line() const;

  
  /** Sets the position of the right margin.
   *
   * @param margin The width in characters where to position the right margin.
   */
  void set_right_margin_position(guint margin);

  
  /** Gets the position of the right margin.
   *
   * @return The position of the right margin.
   */
  guint get_right_margin_position() const;

  
  /** Set the desired movement of the cursor when HOME and END keys are pressed.
   *
   * @param smart_he The desired behavior among SourceSmartHomeEndType.
   */
  void set_smart_home_end(SourceSmartHomeEndType smart_he);

  
  /** Returns a SourceSmartHomeEndType end value specifying how the cursor will
   *  move when HOME and END keys are pressed.
   *
   * @return A SourceSmartHomeEndType value.
   */
  SourceSmartHomeEndType get_smart_home_end() const;

  
  /** If @c true line marks will be displayed beside the text.
   *
   * @param show Whether line marks should be displayed.
   *
   * @newin{2,2}
   */
  void set_show_line_marks(bool show = true);

  
  /** Returns whether line marks are displayed beside the text.
   *
   * @return @c true if the line marks are displayed.
   *
   * @newin{2,2}
   */
  bool get_show_line_marks() const;

  
  /** If @c true, when the tab key is pressed and there is a selection, the
   *  selected text is indented of one level instead of being replaced with
   *  the @\t characters. Shift+Tab unindents the selection.
   *
   * @param enable Whether to indent a block when tab is pressed.
   *
   * @newin{2,2}
   */
  void set_indent_on_tab(bool enable = true);

  
  /** Returns whether when the tab key is pressed the current selection
   *  should get indented instead of replaced with the @\t character.
   *
   * @return @c true if the selection is indented when tab is pressed.
   *
   * @newin{2,2}
   */
  bool get_indent_on_tab() const;

  
  /** Sets the number of spaces to use for each step of indent.
   *
   * If @a width is -1, the value of the SourceView::property_tab_width property
   * will be used.
   *
   * @param width Indent width in characters.
   */
  void set_indent_width(gint width);

  
  /** Returns the number of spaces to use for each step of indent.
   *
   * See set_indent_width() for details.
   *
   * @return Indent width.
   */
  gint get_indent_width() const;

  
  /** Set if and how the spaces should be visualized.
   *
   * Specifying @a flags as 0 will disable display of spaces.
   *
   * @param flags SourceDrawSpacesFlags specifing how white spaces should be
   * displayed.
   */
  void set_draw_spaces(SourceDrawSpacesFlags flags = SOURCE_DRAW_SPACES_ALL);

  
  /** Returns the SourceDrawSpacesFlags specifying if and how spaces should be
   *  displayed.
   *
   * @return The SourceDrawSpacesFlags, 0 if no spaces should be drawn.
   */
  SourceDrawSpacesFlags get_draw_spaces() const;

 
  /** Determines the visual column at @a iter taking into consideration the indent
   *  width of @a view.
   *
   * @param iter: a position in this view.
   *
   * @return the visual column at @a iter.
   *
   * @newin{3,0}
   */
  guint get_visual_column(const Gtk::TextIter& iter) const;

  
  /** Returns the SourceGutter object associated with @a window_type for this
   *  view.
   *
   * Only Gtk::TEXT_WINDOW_LEFT and Gtk::TEXT_WINDOW_RIGHT are supported,
   * respectively corresponding to the left and right gutter. The line numbers
   * and mark category icons are rendered in the gutter corresponding to
   * Gtk::TEXT_WINDOW_LEFT.
   *
   * @param window_type The gutter window type
   *
   * @return The SourceGutter.
   *
   * @newin{2,10}
   *
   */
  Glib::RefPtr<SourceGutter> get_gutter(Gtk::TextWindowType window_type);

  
  /** Returns the SourceGutter object associated with @a window_type for this
   *  view.
   *
   * Only Gtk::TEXT_WINDOW_LEFT and Gtk::TEXT_WINDOW_RIGHT are supported,
   * respectively corresponding to the left and right gutter. The line numbers
   * and mark category icons are rendered in the gutter corresponding to
   * Gtk::TEXT_WINDOW_LEFT.
   *
   * @param window_type The gutter window type
   *
   * @return The SourceGutter.
   *
   * @newin{2,10}
   *
   */
  Glib::RefPtr<const SourceGutter> get_gutter(Gtk::TextWindowType window_type) const;

  
  /** Gets the SourceCompletion associated with this view.
   *
   * @return The SourceCompletion associated with this view.
   *
   * @newin{2,10}
   */
  Glib::RefPtr<SourceCompletion> get_completion();

  
  /** Gets the SourceCompletion associated with this view.
   *
   * @return The SourceCompletion associated with this view.
   *
   * @newin{2,10}
   */
  Glib::RefPtr<const SourceCompletion> get_completion() const;

  
  /** Get the source mark category object for @a category. A
   * Gtk::SourceMarkCategory is automatically created for the given category
   * if it does not exist yet.
   * @param category The category.
   * @return The Gtk::SourceMarkCategory object.
   */
  Glib::RefPtr<SourceMarkCategory> get_mark_category(const Glib::ustring& category);

  
  /** Get the source mark category object for @a category. A
   * Gtk::SourceMarkCategory is automatically created for the given category
   * if it does not exist yet.
   * @param category The category.
   * @return The Gtk::SourceMarkCategory object.
   */
  Glib::RefPtr<const SourceMarkCategory> get_mark_category(const Glib::ustring& category) const;

  /** Emitted when redo action is requested.
   *
   * @par Prototype:
   * <tt>void on_my_%redo()</tt>
   */

  Glib::SignalProxy0< void > signal_redo();


  /** Emitted when undo action is requested.
   *
   * @par Prototype:
   * <tt>void on_my_%undo()</tt>
   */

  Glib::SignalProxy0< void > signal_undo();


  /** Emitted when a line mark has been activated (for instance when there
   *  was a button press in the line marks gutter).
   *
   * You can use @a iter to determine on which line the activation took place.
   *
   * @par Handler parameters:
   * iter A Gtk::TextIter.
   * event The GdkEvent that activated the event.
   *
   * @par Prototype:
   * <tt>void on_my_%line_mark_activated(Gtk::TextIter& mark, GdkEvent* event)</tt>
   */

  Glib::SignalProxy2< void,Gtk::TextIter&,GdkEvent* > signal_line_mark_activated();


  /** Emitted when a the cursor was moved according to the smart home end setting.
   *
   * The signal is emitted after the cursor is moved, but during the
   * Gtk::TextView::move-cursor action. This can be used to find out whether the
   * cursor was moved by a normal home/end or by a smart home/end.
   *
   * @par Handler parameters:
   * iter A Gtk::TextIter
   * count The count
   *
   * @newin{3,0}
   *
   * @par Prototype:
   * <tt>void on_my_%smart_home_end(Gtk::TextIter& iter, int count)</tt>
   */

  Glib::SignalProxy2< void,Gtk::TextIter&,int > signal_smart_home_end();


  // these are keybinding signals, so we ignore them.
  
  
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to display line numbers.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_line_numbers() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to display line numbers.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_line_numbers() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to display line mark pixbufs.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_line_marks() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to display line mark pixbufs.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_line_marks() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Width of a tab character expressed in spaces.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_tab_width() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Width of a tab character expressed in spaces.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_tab_width() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Number of spaces to use for each step of indent.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_indent_width() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Number of spaces to use for each step of indent.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_indent_width() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to enable auto indentation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_auto_indent() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to enable auto indentation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_auto_indent() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to insert spaces instead of tabs.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_insert_spaces_instead_of_tabs() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to insert spaces instead of tabs.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_insert_spaces_instead_of_tabs() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to display the right margin.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_right_margin() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to display the right margin.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_right_margin() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Position of the right margin.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_right_margin_position() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Position of the right margin.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_right_margin_position() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** HOME and END keys move to first/last non whitespace characters on line before going to the start/end of the line.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<SourceSmartHomeEndType> property_smart_home_end() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** HOME and END keys move to first/last non whitespace characters on line before going to the start/end of the line.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<SourceSmartHomeEndType> property_smart_home_end() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to highlight the current line.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_highlight_current_line() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to highlight the current line.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_highlight_current_line() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to indent the selected text when the tab key is pressed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_indent_on_tab() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to indent the selected text when the tab key is pressed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_indent_on_tab() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Set if and how the spaces should be visualized.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<SourceDrawSpacesFlags> property_draw_spaces() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Set if and how the spaces should be visualized.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<SourceDrawSpacesFlags> property_draw_spaces() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The completion object associated with the view.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<SourceCompletion> > property_completion() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} /* namespace Gsv */


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gsv::SourceView
   */
  Gsv::SourceView* wrap(GtkSourceView* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKSOURCEVIEWMM_SOURCEVIEW_H */

