// Generated by gmmproc 2.49.2 -- DO NOT MODIFY!
#ifndef _GTKSOURCEVIEWMM_LANGUAGE_H
#define _GTKSOURCEVIEWMM_LANGUAGE_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* language.h
 *
 * Copyright (C) 2004-2005 Jae Jang
 * Copyright (C) 2005-2006 Rob Page
 * Copyright (C) 2006 Dodji Seketeli
 * Copyright (C) 2010, 2011 Krzesimir Nowak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <vector>

#include <glibmm/object.h>

#include <gtksourceviewmm/stylescheme.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkSourceLanguage = struct _GtkSourceLanguage;
using GtkSourceLanguageClass = struct _GtkSourceLanguageClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gsv
{ class Language_Class; } // namespace Gsv
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gsv
{

class LanguageManager ;


/** Object representing a syntax highlighted language.
 *
 * Language encapsulates syntax and highlighting styles for a particular
 * language. Use LanguageManager to obtain a Language instance, and
 * Buffer::set_language() to apply it to a Buffer.
 */

class Language : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = Language;
  using CppClassType = Language_Class;
  using BaseObjectType = GtkSourceLanguage;
  using BaseClassType = GtkSourceLanguageClass;

  // noncopyable
  Language(const Language&) = delete;
  Language& operator=(const Language&) = delete;

private:  friend class Language_Class;
  static CppClassType language_class_;

protected:
  explicit Language(const Glib::ConstructParams& construct_params);
  explicit Language(GtkSourceLanguage* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Language(Language&& src) noexcept;
  Language& operator=(Language&& src) noexcept;

  ~Language() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkSourceLanguage*       gobj()       { return reinterpret_cast<GtkSourceLanguage*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkSourceLanguage* gobj() const { return reinterpret_cast<GtkSourceLanguage*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkSourceLanguage* gobj_copy();

private:


public:

  
  /** Returns the ID of a language.
   *
   * The ID is not locale-dependent.
   *
   * @return The ID of a language.
   */
  Glib::ustring get_id() const;

  
  /** Returns the localized name of the language.
   *
   * @return The name of a language.
   */
  Glib::ustring get_name() const;

  
  /** Returns the localized section of the language.
   *
   * Each language belong to a section (ex. HTML belogs to the Markup section).
   *
   * @return The section of a language.
   */
  Glib::ustring get_section() const;

  
  /** Returns whether the language should be hidden from the user.
   *
   * @return @c true if the language should be hidden, @c false otherwise.
   */
  bool get_hidden() const;

 
  /** Returns the mime types associated to this language.
   *
   * This is just a utility wrapper around get_metadata() to retrieve the
   * "mimetypes" metadata property and split it into an array.
   *
   * @return An array containing the mime types.
   */
  std::vector<Glib::ustring> get_mime_types() const;

  
  /** Returns the globs associated to this language.
   *
   * This is just a utility wrapper around get_metadata() to retrieve the
   * "globs" metadata property and split it into an array.
   *
   * @return An array containing the globs.
   */
  std::vector<Glib::ustring> get_globs() const;

  
  /** Returns the ids of the styles defined by this language.
   *
   * @return An array containing ids of the styles defined by this language.
   */
  std::vector<Glib::ustring> get_style_ids() const;

  
  /** Returns the name of the style with ID @a style_id defined by this
   *  language.
   *
   * @param style_id A style ID.
   *
   * @return The name of the style with ID @a style_id defined by this language
   * or empty string if the style has no name or there is no style with ID
   * @a style_id defined by this language.
   */
  Glib::ustring get_style_name(const Glib::ustring& style_id) const;

  
  /** Returns metadata of a language.
   *
   * @param name Metadata property name.
   *
   * @return Value of property @a name stored in the metadata of language or
   * empty string if language doesn't contain that metadata property.
   */
  Glib::ustring get_metadata(const Glib::ustring& name) const;

  /** Language id.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< std::string > property_id() const;


  /** Language name.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< std::string > property_name() const;


  /** Language section.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< std::string > property_section() const;


  /** Whether the language should be hidden from the user.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_hidden() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} /* namespace Gsv */


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gsv::Language
   */
  Glib::RefPtr<Gsv::Language> wrap(GtkSourceLanguage* object, bool take_copy = false);
}


#endif /* _GTKSOURCEVIEWMM_LANGUAGE_H */

