/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* turing_table_editor.h - a Turing machine simulator.
 * Copyright (C) 2001-2002 German Poo-Caaman~o
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/* Edit states */
enum
{
	COLUMN_STATE,
	COLUMN_READ,
	COLUMN_WRITE,
	COLUMN_MOVE,
	COLUMN_NEW_STATE,
	COLUMN_COMMENTS,
	COLUMN_EDITABLE,
	COLUMN_MOVE_DATA,
	COLUMN_INDEX,
	NUM_COLUMNS
};

static char * rightarrow_xpm[] = {
"20 16 27 1",
" 	c None",
".	c #000000",
"+	c #00FFFF",
"@	c #00E7E7",
"#	c #00F5F5",
"$	c #00C4C4",
"%	c #009595",
"&	c #00FDFD",
"*	c #00F9F9",
"=	c #00CCCC",
"-	c #00A2A2",
";	c #00EFEF",
">	c #00C7C7",
",	c #00A8A8",
"'	c #00DDDD",
")	c #00A4A4",
"!	c #009696",
"~	c #008E8E",
"{	c #008F8F",
"]	c #00A5A5",
"^	c #00C3C3",
"/	c #007878",
"(	c #009E9E",
"_	c #007777",
":	c #00A7A7",
"<	c #006969",
"[	c #007676",
"                    ",
"                    ",
"             ..     ",
"             .+.    ",
"             .+@.   ",
"   ...........#$%.  ",
"   .&*+++++++#=$=-. ",
"   .;>=======$$==,,.",
"   .')!~~~~~{]^=~/. ",
"   ...........({_.  ",
"             .:<.   ",
"             .[.    ",
"             ..     ",
"                    ",
"                    ",
"                    "};

static char * leftarrow_xpm[] = {
"20 16 29 1",
" 	c None",
".	c #000000",
"+	c #EE0000",
"@	c #D90000",
"#	c #CE0000",
"$	c #C00000",
"%	c #EA0000",
"&	c #D70000",
"*	c #C60000",
"=	c #C10000",
"-	c #FF0000",
";	c #F40000",
">	c #C40000",
",	c #CF0000",
"'	c #BE0000",
")	c #C30000",
"!	c #CD0000",
"~	c #C50000",
"{	c #CC0000",
"]	c #AA0000",
"^	c #BC0000",
"/	c #B50000",
"(	c #AC0000",
"_	c #A70000",
":	c #8E0000",
"<	c #B20000",
"[	c #9A0000",
"}	c #A20000",
"|	c #930000",
"                    ",
"                    ",
"     ..             ",
"    .+.             ",
"   .+@.             ",
"  .+#$...........   ",
" .%&*=@-------;>.   ",
".+,'=)!~{{{{{{*].   ",
" .]$^/(_]]]]]]]:.   ",
"  .]<[...........   ",
"   .}|.             ",
"    .:.             ",
"     ..             ",
"                    ",
"                    ",
"                    "};

/* Interfaces of tree_editor */
GtkWidget * turing_table_editor_new (GtkTreeView ** tree, turing * tm);
void turing_table_editor_set_model (GtkTreeView * treeview_editor, turing * tm);

/* Internal tree_editor's functions */
static GtkTreeModel * turing_table_editor_model_new (turing * tm);
GtkTreeView * turing_table_editor_treeview_new (turing * tm);

static void turing_table_editor_add_columns (GtkTreeView * treeview, turing * tm);