(define-module (gnome gtk)
  :use-module (gnome gobject)
  :use-module (gnome gobject primitives)
  :use-module (oop goops))

(load-extension "libguile-gnome-gtk" "init_gnomegtk")

(%init-gnome-gtk)

(define gtktype:object (gtype-from-name "GtkObject"))
(define gtktype:widget (gtype-from-name "GtkWidget"))
(define gtktype:window (gtype-from-name "GtkWindow"))
(define gtktype:label  (gtype-from-name "GtkLabel"))
(define gtktype:misc   (gtype-from-name "GtkMisc"))

(define <gtk-object> (gtype->class gtktype:object))
(define <gtk-widget> (gtype->class gtktype:widget))
(define <gtk-window> (gtype->class gtktype:window))
(define <gtk-label>  (gtype->class gtktype:label))
(define <gtk-misc>  (gtype->class gtktype:misc))

(define (show-properties type)
  (let* ((properties (gobject-primitive-get-properties type)))
    (map (lambda (x)
	   (let* ((pspec-struct (gparam-primitive->pspec-struct x)))
	     (gparam-spec:name pspec-struct)))
	 (vector->list properties))))

(define-method (initialize (object <gtk-object>) initargs)
  (next-method)
  (%gtk-object-ref object) (%gtk-object-sink object))

(export gtktype:object gtktype:widget gtktype:window gtktype:label
	gtktype:misc show-properties
	<gtk-object> <gtk-widget> <gtk-window> <gtk-label>
	<gtk-misc>)
