

#include <time.h>
#include <stdio.h>

#include "plotutils.h"
#include "util.h"

static inline void start_time(guint* store)
{
  *store = clock();
}
static inline void check_time(const char* name, guint* store, guint* elapsed)
{
  guint now = clock();
  g_debug("   %s: %u clocks elapsed", name, now - *store);
  *elapsed += (now - *store);
}

static const guint NVALS = 200000;

static double* tmp_buf = 0;
static double* random_values = 0;
static double* duplicate_values = 0;
static double* ascending_values = 0;
static double* descending_values = 0;
static double* scratch_values = 0;

int doublecmp(const void* a, const void* b)
{
  if ((*(double*)a) > (*(double*)b))
    return 1;
  else if ((*(double*)a) < (*(double*)b))
    return -1;
  else 
    return 0;
}

void
run_bench(const char* name, double* xvalues)
{
  guint elapsed = 0;
  int i = 0;
  while (i < 10)
    {
      memcpy(tmp_buf, xvalues, sizeof(double)*NVALS);
      guint store;
      start_time(&store);
      PlotUtil::sort_axes(tmp_buf, scratch_values, NVALS);
      check_time(name, &store, &elapsed);
      ++i;
    }
  g_debug("Total %s: %u clocks, average %u (%g sec)", name, 
          elapsed, elapsed/10,
          (double)elapsed/(double)CLOCKS_PER_SEC/10.0);
}

int main(int argc, char** argv)
{
  printf("Preparing... ");

  tmp_buf = new double[NVALS];
  random_values = new double[NVALS];
  duplicate_values = new double[NVALS];
  ascending_values = new double[NVALS];
  descending_values = new double[NVALS];
  scratch_values = new double[NVALS];

  guint i = 0;
  while (i < NVALS)
    {
      random_values[i] = rand();
      ++i;
    }

  i = 0;
  while (i < NVALS)
    {
      duplicate_values[i] = 5.0;
      ++i;
    }
  
  i = 0;
  while (i < NVALS)
    {
      ascending_values[i] = i*5.0;
      ++i;
    }

  i = 0;
  while (i < NVALS)
    {
      descending_values[i] = i*-5.0;
      ++i;
    }

  i = 0;
  while (i < NVALS)
    {
      scratch_values[i] = i*5.0;
      ++i;
    }

  printf("done.\n");

  run_bench("Random", random_values);
  run_bench("Ascending", ascending_values);
  run_bench("Descending", descending_values);
  run_bench("Duplicate", duplicate_values);

  delete [] tmp_buf;
  delete [] random_values;
  delete [] duplicate_values;
  delete [] ascending_values;
  delete [] descending_values;
  delete [] scratch_values;
}
