/* Document.c generated by valac 0.12.0, the Vala compiler
 * generated from Document.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/*
 * GXml
 * Copyright (C) Richard Schwarting 2011 <aquarichy@gmail.com>
 *
 * GXml is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * GXml is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General
 * Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GXml. If not, see <http://www.gnu.org/licenses/>.
 */
/* TODO:
 * * later on, go over libxml2 docs for Tree and Node and Document, etc., and see if we're missing anything significant
 * * compare performance between libxml2 and GXml (should be a little different, but not too much)
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <libxml/xmlIO.h>
#include <libxml/xmlreader.h>
#include <libxml/xmlsave.h>


#define GXML_DOM_TYPE_INPUT_STREAM_BOX (gxml_dom_input_stream_box_get_type ())
typedef struct _GXmlDomInputStreamBox GXmlDomInputStreamBox;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GXML_DOM_TYPE_OUTPUT_STREAM_BOX (gxml_dom_output_stream_box_get_type ())
typedef struct _GXmlDomOutputStreamBox GXmlDomOutputStreamBox;

#define GXML_DOM_TYPE_XNODE (gxml_dom_xnode_get_type ())
#define GXML_DOM_XNODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_DOM_TYPE_XNODE, GXmlDomXNode))
#define GXML_DOM_XNODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_DOM_TYPE_XNODE, GXmlDomXNodeClass))
#define GXML_DOM_IS_XNODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_DOM_TYPE_XNODE))
#define GXML_DOM_IS_XNODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_DOM_TYPE_XNODE))
#define GXML_DOM_XNODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_DOM_TYPE_XNODE, GXmlDomXNodeClass))

typedef struct _GXmlDomXNode GXmlDomXNode;
typedef struct _GXmlDomXNodeClass GXmlDomXNodeClass;
typedef struct _GXmlDomXNodePrivate GXmlDomXNodePrivate;

#define GXML_DOM_TYPE_NODE_TYPE (gxml_dom_node_type_get_type ())

#define GXML_DOM_TYPE_NODE_LIST (gxml_dom_node_list_get_type ())
#define GXML_DOM_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_DOM_TYPE_NODE_LIST, GXmlDomNodeList))
#define GXML_DOM_IS_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_DOM_TYPE_NODE_LIST))
#define GXML_DOM_NODE_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_DOM_TYPE_NODE_LIST, GXmlDomNodeListIface))

typedef struct _GXmlDomNodeList GXmlDomNodeList;
typedef struct _GXmlDomNodeListIface GXmlDomNodeListIface;

#define GXML_DOM_TYPE_ATTR (gxml_dom_attr_get_type ())
#define GXML_DOM_ATTR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_DOM_TYPE_ATTR, GXmlDomAttr))
#define GXML_DOM_ATTR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_DOM_TYPE_ATTR, GXmlDomAttrClass))
#define GXML_DOM_IS_ATTR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_DOM_TYPE_ATTR))
#define GXML_DOM_IS_ATTR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_DOM_TYPE_ATTR))
#define GXML_DOM_ATTR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_DOM_TYPE_ATTR, GXmlDomAttrClass))

typedef struct _GXmlDomAttr GXmlDomAttr;
typedef struct _GXmlDomAttrClass GXmlDomAttrClass;

#define GXML_DOM_TYPE_DOCUMENT (gxml_dom_document_get_type ())
#define GXML_DOM_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_DOM_TYPE_DOCUMENT, GXmlDomDocument))
#define GXML_DOM_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_DOM_TYPE_DOCUMENT, GXmlDomDocumentClass))
#define GXML_DOM_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_DOM_TYPE_DOCUMENT))
#define GXML_DOM_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_DOM_TYPE_DOCUMENT))
#define GXML_DOM_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_DOM_TYPE_DOCUMENT, GXmlDomDocumentClass))

typedef struct _GXmlDomDocument GXmlDomDocument;
typedef struct _GXmlDomDocumentClass GXmlDomDocumentClass;
typedef struct _GXmlDomDocumentPrivate GXmlDomDocumentPrivate;

#define GXML_DOM_TYPE_DOCUMENT_TYPE (gxml_dom_document_type_get_type ())
#define GXML_DOM_DOCUMENT_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_DOM_TYPE_DOCUMENT_TYPE, GXmlDomDocumentType))
#define GXML_DOM_DOCUMENT_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_DOM_TYPE_DOCUMENT_TYPE, GXmlDomDocumentTypeClass))
#define GXML_DOM_IS_DOCUMENT_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_DOM_TYPE_DOCUMENT_TYPE))
#define GXML_DOM_IS_DOCUMENT_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_DOM_TYPE_DOCUMENT_TYPE))
#define GXML_DOM_DOCUMENT_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_DOM_TYPE_DOCUMENT_TYPE, GXmlDomDocumentTypeClass))

typedef struct _GXmlDomDocumentType GXmlDomDocumentType;
typedef struct _GXmlDomDocumentTypeClass GXmlDomDocumentTypeClass;

#define GXML_DOM_TYPE_IMPLEMENTATION (gxml_dom_implementation_get_type ())
#define GXML_DOM_IMPLEMENTATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_DOM_TYPE_IMPLEMENTATION, GXmlDomImplementation))
#define GXML_DOM_IMPLEMENTATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_DOM_TYPE_IMPLEMENTATION, GXmlDomImplementationClass))
#define GXML_DOM_IS_IMPLEMENTATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_DOM_TYPE_IMPLEMENTATION))
#define GXML_DOM_IS_IMPLEMENTATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_DOM_TYPE_IMPLEMENTATION))
#define GXML_DOM_IMPLEMENTATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_DOM_TYPE_IMPLEMENTATION, GXmlDomImplementationClass))

typedef struct _GXmlDomImplementation GXmlDomImplementation;
typedef struct _GXmlDomImplementationClass GXmlDomImplementationClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _gxml_dom_implementation_unref0(var) ((var == NULL) ? NULL : (var = (gxml_dom_implementation_unref (var), NULL)))

#define GXML_DOM_TYPE_BACKED_NODE (gxml_dom_backed_node_get_type ())
#define GXML_DOM_BACKED_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_DOM_TYPE_BACKED_NODE, GXmlDomBackedNode))
#define GXML_DOM_BACKED_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_DOM_TYPE_BACKED_NODE, GXmlDomBackedNodeClass))
#define GXML_DOM_IS_BACKED_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_DOM_TYPE_BACKED_NODE))
#define GXML_DOM_IS_BACKED_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_DOM_TYPE_BACKED_NODE))
#define GXML_DOM_BACKED_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_DOM_TYPE_BACKED_NODE, GXmlDomBackedNodeClass))

typedef struct _GXmlDomBackedNode GXmlDomBackedNode;
typedef struct _GXmlDomBackedNodeClass GXmlDomBackedNodeClass;

#define GXML_DOM_TYPE_ELEMENT (gxml_dom_element_get_type ())
#define GXML_DOM_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_DOM_TYPE_ELEMENT, GXmlDomElement))
#define GXML_DOM_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_DOM_TYPE_ELEMENT, GXmlDomElementClass))
#define GXML_DOM_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_DOM_TYPE_ELEMENT))
#define GXML_DOM_IS_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_DOM_TYPE_ELEMENT))
#define GXML_DOM_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_DOM_TYPE_ELEMENT, GXmlDomElementClass))

typedef struct _GXmlDomElement GXmlDomElement;
typedef struct _GXmlDomElementClass GXmlDomElementClass;

#define GXML_DOM_TYPE_CHARACTER_DATA (gxml_dom_character_data_get_type ())
#define GXML_DOM_CHARACTER_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_DOM_TYPE_CHARACTER_DATA, GXmlDomCharacterData))
#define GXML_DOM_CHARACTER_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_DOM_TYPE_CHARACTER_DATA, GXmlDomCharacterDataClass))
#define GXML_DOM_IS_CHARACTER_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_DOM_TYPE_CHARACTER_DATA))
#define GXML_DOM_IS_CHARACTER_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_DOM_TYPE_CHARACTER_DATA))
#define GXML_DOM_CHARACTER_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_DOM_TYPE_CHARACTER_DATA, GXmlDomCharacterDataClass))

typedef struct _GXmlDomCharacterData GXmlDomCharacterData;
typedef struct _GXmlDomCharacterDataClass GXmlDomCharacterDataClass;

#define GXML_DOM_TYPE_TEXT (gxml_dom_text_get_type ())
#define GXML_DOM_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_DOM_TYPE_TEXT, GXmlDomText))
#define GXML_DOM_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_DOM_TYPE_TEXT, GXmlDomTextClass))
#define GXML_DOM_IS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_DOM_TYPE_TEXT))
#define GXML_DOM_IS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_DOM_TYPE_TEXT))
#define GXML_DOM_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_DOM_TYPE_TEXT, GXmlDomTextClass))

typedef struct _GXmlDomText GXmlDomText;
typedef struct _GXmlDomTextClass GXmlDomTextClass;

#define GXML_DOM_TYPE_CDATA_SECTION (gxml_dom_cdata_section_get_type ())
#define GXML_DOM_CDATA_SECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_DOM_TYPE_CDATA_SECTION, GXmlDomCDATASection))
#define GXML_DOM_CDATA_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_DOM_TYPE_CDATA_SECTION, GXmlDomCDATASectionClass))
#define GXML_DOM_IS_CDATA_SECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_DOM_TYPE_CDATA_SECTION))
#define GXML_DOM_IS_CDATA_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_DOM_TYPE_CDATA_SECTION))
#define GXML_DOM_CDATA_SECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_DOM_TYPE_CDATA_SECTION, GXmlDomCDATASectionClass))

typedef struct _GXmlDomCDATASection GXmlDomCDATASection;
typedef struct _GXmlDomCDATASectionClass GXmlDomCDATASectionClass;

#define GXML_DOM_TYPE_COMMENT (gxml_dom_comment_get_type ())
#define GXML_DOM_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_DOM_TYPE_COMMENT, GXmlDomComment))
#define GXML_DOM_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_DOM_TYPE_COMMENT, GXmlDomCommentClass))
#define GXML_DOM_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_DOM_TYPE_COMMENT))
#define GXML_DOM_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_DOM_TYPE_COMMENT))
#define GXML_DOM_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_DOM_TYPE_COMMENT, GXmlDomCommentClass))

typedef struct _GXmlDomComment GXmlDomComment;
typedef struct _GXmlDomCommentClass GXmlDomCommentClass;

#define GXML_DOM_TYPE_DOCUMENT_FRAGMENT (gxml_dom_document_fragment_get_type ())
#define GXML_DOM_DOCUMENT_FRAGMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_DOM_TYPE_DOCUMENT_FRAGMENT, GXmlDomDocumentFragment))
#define GXML_DOM_DOCUMENT_FRAGMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_DOM_TYPE_DOCUMENT_FRAGMENT, GXmlDomDocumentFragmentClass))
#define GXML_DOM_IS_DOCUMENT_FRAGMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_DOM_TYPE_DOCUMENT_FRAGMENT))
#define GXML_DOM_IS_DOCUMENT_FRAGMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_DOM_TYPE_DOCUMENT_FRAGMENT))
#define GXML_DOM_DOCUMENT_FRAGMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_DOM_TYPE_DOCUMENT_FRAGMENT, GXmlDomDocumentFragmentClass))

typedef struct _GXmlDomDocumentFragment GXmlDomDocumentFragment;
typedef struct _GXmlDomDocumentFragmentClass GXmlDomDocumentFragmentClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _xmlFreeTextReader0(var) ((var == NULL) ? NULL : (var = (xmlFreeTextReader (var), NULL)))

#define GXML_DOM_TYPE_PROCESSING_INSTRUCTION (gxml_dom_processing_instruction_get_type ())
#define GXML_DOM_PROCESSING_INSTRUCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_DOM_TYPE_PROCESSING_INSTRUCTION, GXmlDomProcessingInstruction))
#define GXML_DOM_PROCESSING_INSTRUCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_DOM_TYPE_PROCESSING_INSTRUCTION, GXmlDomProcessingInstructionClass))
#define GXML_DOM_IS_PROCESSING_INSTRUCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_DOM_TYPE_PROCESSING_INSTRUCTION))
#define GXML_DOM_IS_PROCESSING_INSTRUCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_DOM_TYPE_PROCESSING_INSTRUCTION))
#define GXML_DOM_PROCESSING_INSTRUCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_DOM_TYPE_PROCESSING_INSTRUCTION, GXmlDomProcessingInstructionClass))

typedef struct _GXmlDomProcessingInstruction GXmlDomProcessingInstruction;
typedef struct _GXmlDomProcessingInstructionClass GXmlDomProcessingInstructionClass;

#define GXML_DOM_TYPE_ENTITY_REFERENCE (gxml_dom_entity_reference_get_type ())
#define GXML_DOM_ENTITY_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_DOM_TYPE_ENTITY_REFERENCE, GXmlDomEntityReference))
#define GXML_DOM_ENTITY_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_DOM_TYPE_ENTITY_REFERENCE, GXmlDomEntityReferenceClass))
#define GXML_DOM_IS_ENTITY_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_DOM_TYPE_ENTITY_REFERENCE))
#define GXML_DOM_IS_ENTITY_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_DOM_TYPE_ENTITY_REFERENCE))
#define GXML_DOM_ENTITY_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_DOM_TYPE_ENTITY_REFERENCE, GXmlDomEntityReferenceClass))

typedef struct _GXmlDomEntityReference GXmlDomEntityReference;
typedef struct _GXmlDomEntityReferenceClass GXmlDomEntityReferenceClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GXmlDomInputStreamBox {
	GInputStream* str;
	GCancellable* can;
};

struct _GXmlDomOutputStreamBox {
	GOutputStream* str;
	GCancellable* can;
};

typedef enum  {
	GXML_DOM_DOM_ERROR_INDEX_SIZE,
	GXML_DOM_DOM_ERROR_DOMSTRING_SIZE,
	GXML_DOM_DOM_ERROR_HIERARCHY_REQUEST,
	GXML_DOM_DOM_ERROR_WRONG_DOCUMENT,
	GXML_DOM_DOM_ERROR_INVALID_CHARACTER,
	GXML_DOM_DOM_ERROR_NO_DATA_ALLOWED,
	GXML_DOM_DOM_ERROR_NO_MODIFICATION_ALLOWED,
	GXML_DOM_DOM_ERROR_NOT_FOUND,
	GXML_DOM_DOM_ERROR_NOT_SUPPORTED,
	GXML_DOM_DOM_ERROR_INUSE_ATTRIBUTE,
	GXML_DOM_DOM_ERROR_DOM,
	GXML_DOM_DOM_ERROR_INVALID_DOC,
	GXML_DOM_DOM_ERROR_INVALID_ROOT
} GXmlDomDomError;
#define GXML_DOM_DOM_ERROR gxml_dom_dom_error_quark ()
typedef enum  {
	GXML_DOM_NODE_TYPE_X_UNKNOWN = 0,
	GXML_DOM_NODE_TYPE_ELEMENT = 1,
	GXML_DOM_NODE_TYPE_ATTRIBUTE,
	GXML_DOM_NODE_TYPE_TEXT,
	GXML_DOM_NODE_TYPE_CDATA_SECTION,
	GXML_DOM_NODE_TYPE_ENTITY_REFERENCE,
	GXML_DOM_NODE_TYPE_ENTITY,
	GXML_DOM_NODE_TYPE_PROCESSING_INSTRUCTION,
	GXML_DOM_NODE_TYPE_COMMENT,
	GXML_DOM_NODE_TYPE_DOCUMENT,
	GXML_DOM_NODE_TYPE_DOCUMENT_TYPE,
	GXML_DOM_NODE_TYPE_DOCUMENT_FRAGMENT,
	GXML_DOM_NODE_TYPE_NOTATION
} GXmlDomNodeType;

struct _GXmlDomNodeListIface {
	GTypeInterface parent_iface;
	GXmlDomXNode* (*item) (GXmlDomNodeList* self, gulong idx);
	void (*foreach) (GXmlDomNodeList* self, GFunc func, void* func_target);
	GXmlDomXNode* (*first) (GXmlDomNodeList* self);
	GXmlDomXNode* (*last) (GXmlDomNodeList* self);
	GXmlDomXNode* (*nth) (GXmlDomNodeList* self, gulong n);
	GXmlDomXNode* (*nth_data) (GXmlDomNodeList* self, gulong n);
	GXmlDomXNode* (*nth_prev) (GXmlDomNodeList* self, GXmlDomXNode* pivot, gulong n);
	gint (*find) (GXmlDomNodeList* self, GXmlDomXNode* target);
	gint (*find_custom) (GXmlDomNodeList* self, GXmlDomXNode* target, GCompareFunc cmp);
	gint (*position) (GXmlDomNodeList* self, GXmlDomXNode* target);
	gint (*index) (GXmlDomNodeList* self, GXmlDomXNode* target);
	GXmlDomXNode* (*insert_before) (GXmlDomNodeList* self, GXmlDomXNode* new_child, GXmlDomXNode* ref_child, GError** error);
	GXmlDomXNode* (*replace_child) (GXmlDomNodeList* self, GXmlDomXNode* new_child, GXmlDomXNode* old_child, GError** error);
	GXmlDomXNode* (*remove_child) (GXmlDomNodeList* self, GXmlDomXNode* old_child);
	GXmlDomXNode* (*append_child) (GXmlDomNodeList* self, GXmlDomXNode* new_child);
	gchar* (*to_string) (GXmlDomNodeList* self);
	gulong (*get_length) (GXmlDomNodeList* self);
	void (*set_length) (GXmlDomNodeList* self, gulong value);
};

struct _GXmlDomXNode {
	GObject parent_instance;
	GXmlDomXNodePrivate * priv;
};

struct _GXmlDomXNodeClass {
	GObjectClass parent_class;
	GXmlDomXNode* (*insert_before) (GXmlDomXNode* self, GXmlDomXNode* new_child, GXmlDomXNode* ref_child, GError** error);
	GXmlDomXNode* (*replace_child) (GXmlDomXNode* self, GXmlDomXNode* new_child, GXmlDomXNode* old_child, GError** error);
	GXmlDomXNode* (*remove_child) (GXmlDomXNode* self, GXmlDomXNode* old_child, GError** error);
	GXmlDomXNode* (*append_child) (GXmlDomXNode* self, GXmlDomXNode* new_child, GError** error);
	gboolean (*has_child_nodes) (GXmlDomXNode* self);
	GXmlDomXNode* (*clone_nodes) (GXmlDomXNode* self, gboolean deep);
	const gchar* (*get_node_value) (GXmlDomXNode* self);
	void (*set_node_value) (GXmlDomXNode* self, const gchar* value);
	const gchar* (*get_node_name) (GXmlDomXNode* self);
	void (*set_node_name) (GXmlDomXNode* self, const gchar* value);
	GXmlDomNodeType (*get_node_type) (GXmlDomXNode* self);
	void (*set_node_type) (GXmlDomXNode* self, GXmlDomNodeType value);
	GXmlDomXNode* (*get_parent_node) (GXmlDomXNode* self);
	void (*set_parent_node) (GXmlDomXNode* self, GXmlDomXNode* value);
	GXmlDomNodeList* (*get_child_nodes) (GXmlDomXNode* self);
	void (*set_child_nodes) (GXmlDomXNode* self, GXmlDomNodeList* value);
	GXmlDomXNode* (*get_first_child) (GXmlDomXNode* self);
	void (*set_first_child) (GXmlDomXNode* self, GXmlDomXNode* value);
	GXmlDomXNode* (*get_last_child) (GXmlDomXNode* self);
	void (*set_last_child) (GXmlDomXNode* self, GXmlDomXNode* value);
	GXmlDomXNode* (*get_previous_sibling) (GXmlDomXNode* self);
	void (*set_previous_sibling) (GXmlDomXNode* self, GXmlDomXNode* value);
	GXmlDomXNode* (*get_next_sibling) (GXmlDomXNode* self);
	void (*set_next_sibling) (GXmlDomXNode* self, GXmlDomXNode* value);
	GHashTable* (*get_attributes) (GXmlDomXNode* self);
	void (*set_attributes) (GXmlDomXNode* self, GHashTable* value);
};

struct _GXmlDomDocument {
	GXmlDomXNode parent_instance;
	GXmlDomDocumentPrivate * priv;
	GHashTable* node_dict;
	xmlDoc* xmldoc;
};

struct _GXmlDomDocumentClass {
	GXmlDomXNodeClass parent_class;
};

struct _GXmlDomDocumentPrivate {
	GXmlDomDocumentType* _doctype;
	GXmlDomImplementation* _implementation;
};


static gpointer gxml_dom_document_parent_class = NULL;

GType gxml_dom_input_stream_box_get_type (void) G_GNUC_CONST;
GXmlDomInputStreamBox* gxml_dom_input_stream_box_dup (const GXmlDomInputStreamBox* self);
void gxml_dom_input_stream_box_free (GXmlDomInputStreamBox* self);
void gxml_dom_input_stream_box_copy (const GXmlDomInputStreamBox* self, GXmlDomInputStreamBox* dest);
void gxml_dom_input_stream_box_destroy (GXmlDomInputStreamBox* self);
GType gxml_dom_output_stream_box_get_type (void) G_GNUC_CONST;
GXmlDomOutputStreamBox* gxml_dom_output_stream_box_dup (const GXmlDomOutputStreamBox* self);
void gxml_dom_output_stream_box_free (GXmlDomOutputStreamBox* self);
void gxml_dom_output_stream_box_copy (const GXmlDomOutputStreamBox* self, GXmlDomOutputStreamBox* dest);
void gxml_dom_output_stream_box_destroy (GXmlDomOutputStreamBox* self);
GType gxml_dom_xnode_get_type (void) G_GNUC_CONST;
GQuark gxml_dom_dom_error_quark (void);
GType gxml_dom_node_type_get_type (void) G_GNUC_CONST;
GType gxml_dom_node_list_get_type (void) G_GNUC_CONST;
GType gxml_dom_attr_get_type (void) G_GNUC_CONST;
GType gxml_dom_document_get_type (void) G_GNUC_CONST;
GType gxml_dom_document_type_get_type (void) G_GNUC_CONST;
gpointer gxml_dom_implementation_ref (gpointer instance);
void gxml_dom_implementation_unref (gpointer instance);
GParamSpec* gxml_dom_param_spec_implementation (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gxml_dom_value_set_implementation (GValue* value, gpointer v_object);
void gxml_dom_value_take_implementation (GValue* value, gpointer v_object);
gpointer gxml_dom_value_get_implementation (const GValue* value);
GType gxml_dom_implementation_get_type (void) G_GNUC_CONST;
#define GXML_DOM_DOCUMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GXML_DOM_TYPE_DOCUMENT, GXmlDomDocumentPrivate))
enum  {
	GXML_DOM_DOCUMENT_DUMMY_PROPERTY,
	GXML_DOM_DOCUMENT_NODE_NAME,
	GXML_DOM_DOCUMENT_DOCTYPE,
	GXML_DOM_DOCUMENT_IMPLEMENTATION,
	GXML_DOM_DOCUMENT_DOCUMENT_ELEMENT
};
static void _g_object_unref0_ (gpointer var);
GXmlDomXNode* gxml_dom_document_lookup_node (GXmlDomDocument* self, xmlNode* xmlnode);
GXmlDomElement* gxml_dom_element_new (xmlNode* node, GXmlDomDocument* doc);
GXmlDomElement* gxml_dom_element_construct (GType object_type, xmlNode* node, GXmlDomDocument* doc);
GType gxml_dom_backed_node_get_type (void) G_GNUC_CONST;
GType gxml_dom_element_get_type (void) G_GNUC_CONST;
GXmlDomText* gxml_dom_text_new (xmlNode* text_node, GXmlDomDocument* doc);
GXmlDomText* gxml_dom_text_construct (GType object_type, xmlNode* text_node, GXmlDomDocument* doc);
GType gxml_dom_character_data_get_type (void) G_GNUC_CONST;
GType gxml_dom_text_get_type (void) G_GNUC_CONST;
GXmlDomCDATASection* gxml_dom_cdata_section_new (xmlNode* cdata_node, GXmlDomDocument* doc);
GXmlDomCDATASection* gxml_dom_cdata_section_construct (GType object_type, xmlNode* cdata_node, GXmlDomDocument* doc);
GType gxml_dom_cdata_section_get_type (void) G_GNUC_CONST;
GXmlDomComment* gxml_dom_comment_new (xmlNode* comment_node, GXmlDomDocument* doc);
GXmlDomComment* gxml_dom_comment_construct (GType object_type, xmlNode* comment_node, GXmlDomDocument* doc);
GType gxml_dom_comment_get_type (void) G_GNUC_CONST;
GXmlDomDocumentFragment* gxml_dom_document_fragment_new (xmlNode* fragment_node, GXmlDomDocument* doc);
GXmlDomDocumentFragment* gxml_dom_document_fragment_construct (GType object_type, xmlNode* fragment_node, GXmlDomDocument* doc);
GType gxml_dom_document_fragment_get_type (void) G_GNUC_CONST;
static GXmlDomDocument* gxml_dom_document_new (xmlDoc* doc, GError** error);
static GXmlDomDocument* gxml_dom_document_construct (GType object_type, xmlDoc* doc, GError** error);
GXmlDomXNode* gxml_dom_xnode_new_for_document (void);
GXmlDomXNode* gxml_dom_xnode_construct_for_document (GType object_type);
void gxml_dom_xnode_set_owner_document (GXmlDomXNode* self, GXmlDomDocument* value);
static void gxml_dom_document_set_doctype (GXmlDomDocument* self, GXmlDomDocumentType* value);
GXmlDomDocumentType* gxml_dom_document_type_new (xmlDtd* int_subset, xmlDtd* ext_subset, GXmlDomDocument* doc);
GXmlDomDocumentType* gxml_dom_document_type_construct (GType object_type, xmlDtd* int_subset, xmlDtd* ext_subset, GXmlDomDocument* doc);
GXmlDomImplementation* gxml_dom_implementation_new (void);
GXmlDomImplementation* gxml_dom_implementation_construct (GType object_type);
static void gxml_dom_document_set_implementation (GXmlDomDocument* self, GXmlDomImplementation* value);
GXmlDomDocument* gxml_dom_document_new_for_path (const gchar* file_path, GError** error);
GXmlDomDocument* gxml_dom_document_construct_for_path (GType object_type, const gchar* file_path, GError** error);
gint _gxml_dom_document_iowrite (void* ctx, gchar* buf, int buf_length1, gint len);
gint _gxml_dom_document_iooutclose (void* ctx);
gint _gxml_dom_document_ioread (void* ctx, gchar* buf, int buf_length1, gint len);
gint _gxml_dom_document_ioinclose (void* ctx);
GXmlDomDocument* gxml_dom_document_new_for_file (GFile* fin, GError** error);
GXmlDomDocument* gxml_dom_document_construct_for_file (GType object_type, GFile* fin, GError** error);
GXmlDomDocument* gxml_dom_document_new_for_stream (GInputStream* instream, GError** error);
GXmlDomDocument* gxml_dom_document_construct_for_stream (GType object_type, GInputStream* instream, GError** error);
GXmlDomDocument* gxml_dom_document_new_from_string (const gchar* memory, GError** error);
GXmlDomDocument* gxml_dom_document_construct_from_string (GType object_type, const gchar* memory, GError** error);
void gxml_dom_document_save_to_path (GXmlDomDocument* self, const gchar* file_path);
void gxml_dom_document_save_to_stream (GXmlDomDocument* self, GOutputStream* outstream, GError** error);
GXmlDomElement* gxml_dom_document_create_element (GXmlDomDocument* self, const gchar* tag_name, GError** error);
GXmlDomDocumentFragment* gxml_dom_document_create_document_fragment (GXmlDomDocument* self);
GXmlDomText* gxml_dom_document_create_text_node (GXmlDomDocument* self, const gchar* data);
GXmlDomComment* gxml_dom_document_create_comment (GXmlDomDocument* self, const gchar* data);
GXmlDomCDATASection* gxml_dom_document_create_cdata_section (GXmlDomDocument* self, const gchar* data, GError** error);
static void gxml_dom_document_check_html (GXmlDomDocument* self, const gchar* feature, GError** error);
GType gxml_dom_processing_instruction_get_type (void) G_GNUC_CONST;
GXmlDomProcessingInstruction* gxml_dom_document_create_processing_instruction (GXmlDomDocument* self, const gchar* target, const gchar* data, GError** error);
static void gxml_dom_document_check_character_validity (GXmlDomDocument* self, const gchar* str, GError** error);
GXmlDomProcessingInstruction* gxml_dom_processing_instruction_new (const gchar* target, const gchar* data, GXmlDomDocument* doc);
GXmlDomProcessingInstruction* gxml_dom_processing_instruction_construct (GType object_type, const gchar* target, const gchar* data, GXmlDomDocument* doc);
GXmlDomAttr* gxml_dom_document_create_attribute (GXmlDomDocument* self, const gchar* name, GError** error);
GXmlDomAttr* gxml_dom_attr_new (xmlAttr* node, GXmlDomDocument* doc);
GXmlDomAttr* gxml_dom_attr_construct (GType object_type, xmlAttr* node, GXmlDomDocument* doc);
GType gxml_dom_entity_reference_get_type (void) G_GNUC_CONST;
GXmlDomEntityReference* gxml_dom_document_create_entity_reference (GXmlDomDocument* self, const gchar* name, GError** error);
GXmlDomEntityReference* gxml_dom_entity_reference_new (const gchar* refname, GXmlDomDocument* doc);
GXmlDomEntityReference* gxml_dom_entity_reference_construct (GType object_type, const gchar* refname, GXmlDomDocument* doc);
GList* gxml_dom_document_get_elements_by_tag_name (GXmlDomDocument* self, const gchar* tag_name);
GXmlDomElement* gxml_dom_document_get_document_element (GXmlDomDocument* self);
GList* gxml_dom_element_get_elements_by_tag_name (GXmlDomElement* self, const gchar* tag_name);
GXmlDomDocumentType* gxml_dom_document_get_doctype (GXmlDomDocument* self);
const gchar* gxml_dom_document_type_get_name (GXmlDomDocumentType* self);
GXmlDomImplementation* gxml_dom_document_get_implementation (GXmlDomDocument* self);
static void gxml_dom_document_set_document_element (GXmlDomDocument* self, GXmlDomElement* value);
static void gxml_dom_document_finalize (GObject* obj);
const gchar* gxml_dom_xnode_get_node_name (GXmlDomXNode* self);
static void _vala_gxml_dom_document_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void gxml_dom_xnode_set_node_name (GXmlDomXNode* self, const gchar* value);
static void _vala_gxml_dom_document_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void gxml_dom_input_stream_box_copy (const GXmlDomInputStreamBox* self, GXmlDomInputStreamBox* dest) {
	dest->str = _g_object_ref0 (self->str);
	dest->can = _g_object_ref0 (self->can);
}


void gxml_dom_input_stream_box_destroy (GXmlDomInputStreamBox* self) {
	_g_object_unref0 ((*self).str);
	_g_object_unref0 ((*self).can);
}


GXmlDomInputStreamBox* gxml_dom_input_stream_box_dup (const GXmlDomInputStreamBox* self) {
	GXmlDomInputStreamBox* dup;
	dup = g_new0 (GXmlDomInputStreamBox, 1);
	gxml_dom_input_stream_box_copy (self, dup);
	return dup;
}


void gxml_dom_input_stream_box_free (GXmlDomInputStreamBox* self) {
	gxml_dom_input_stream_box_destroy (self);
	g_free (self);
}


GType gxml_dom_input_stream_box_get_type (void) {
	static volatile gsize gxml_dom_input_stream_box_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_dom_input_stream_box_type_id__volatile)) {
		GType gxml_dom_input_stream_box_type_id;
		gxml_dom_input_stream_box_type_id = g_boxed_type_register_static ("GXmlDomInputStreamBox", (GBoxedCopyFunc) gxml_dom_input_stream_box_dup, (GBoxedFreeFunc) gxml_dom_input_stream_box_free);
		g_once_init_leave (&gxml_dom_input_stream_box_type_id__volatile, gxml_dom_input_stream_box_type_id);
	}
	return gxml_dom_input_stream_box_type_id__volatile;
}


void gxml_dom_output_stream_box_copy (const GXmlDomOutputStreamBox* self, GXmlDomOutputStreamBox* dest) {
	dest->str = _g_object_ref0 (self->str);
	dest->can = _g_object_ref0 (self->can);
}


void gxml_dom_output_stream_box_destroy (GXmlDomOutputStreamBox* self) {
	_g_object_unref0 ((*self).str);
	_g_object_unref0 ((*self).can);
}


GXmlDomOutputStreamBox* gxml_dom_output_stream_box_dup (const GXmlDomOutputStreamBox* self) {
	GXmlDomOutputStreamBox* dup;
	dup = g_new0 (GXmlDomOutputStreamBox, 1);
	gxml_dom_output_stream_box_copy (self, dup);
	return dup;
}


void gxml_dom_output_stream_box_free (GXmlDomOutputStreamBox* self) {
	gxml_dom_output_stream_box_destroy (self);
	g_free (self);
}


GType gxml_dom_output_stream_box_get_type (void) {
	static volatile gsize gxml_dom_output_stream_box_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_dom_output_stream_box_type_id__volatile)) {
		GType gxml_dom_output_stream_box_type_id;
		gxml_dom_output_stream_box_type_id = g_boxed_type_register_static ("GXmlDomOutputStreamBox", (GBoxedCopyFunc) gxml_dom_output_stream_box_dup, (GBoxedFreeFunc) gxml_dom_output_stream_box_free);
		g_once_init_leave (&gxml_dom_output_stream_box_type_id__volatile, gxml_dom_output_stream_box_type_id);
	}
	return gxml_dom_output_stream_box_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


/** Private methods */
GXmlDomXNode* gxml_dom_document_lookup_node (GXmlDomDocument* self, xmlNode* xmlnode) {
	GXmlDomXNode* result = NULL;
	GXmlDomXNode* domnode = NULL;
	gconstpointer _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (xmlnode == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = g_hash_table_lookup (self->node_dict, xmlnode);
	domnode = (GXmlDomXNode*) _tmp0_;
	if (domnode == NULL) {
		gconstpointer _tmp11_ = NULL;
		switch ((GXmlDomNodeType) xmlnode->type) {
			case GXML_DOM_NODE_TYPE_ELEMENT:
			{
				GXmlDomElement* _tmp1_ = NULL;
				GXmlDomElement* _tmp2_;
				_tmp1_ = gxml_dom_element_new (xmlnode, self);
				_tmp2_ = _tmp1_;
				_g_object_unref0 (_tmp2_);
				break;
			}
			case GXML_DOM_NODE_TYPE_TEXT:
			{
				GXmlDomText* _tmp3_ = NULL;
				GXmlDomText* _tmp4_;
				_tmp3_ = gxml_dom_text_new (xmlnode, self);
				_tmp4_ = _tmp3_;
				_g_object_unref0 (_tmp4_);
				break;
			}
			case GXML_DOM_NODE_TYPE_CDATA_SECTION:
			{
				GXmlDomCDATASection* _tmp5_ = NULL;
				GXmlDomCDATASection* _tmp6_;
				_tmp5_ = gxml_dom_cdata_section_new (xmlnode, self);
				_tmp6_ = _tmp5_;
				_g_object_unref0 (_tmp6_);
				break;
			}
			case GXML_DOM_NODE_TYPE_COMMENT:
			{
				GXmlDomComment* _tmp7_ = NULL;
				GXmlDomComment* _tmp8_;
				_tmp7_ = gxml_dom_comment_new (xmlnode, self);
				_tmp8_ = _tmp7_;
				_g_object_unref0 (_tmp8_);
				break;
			}
			case GXML_DOM_NODE_TYPE_DOCUMENT_FRAGMENT:
			{
				GXmlDomDocumentFragment* _tmp9_ = NULL;
				GXmlDomDocumentFragment* _tmp10_;
				_tmp9_ = gxml_dom_document_fragment_new (xmlnode, self);
				_tmp10_ = _tmp9_;
				_g_object_unref0 (_tmp10_);
				break;
			}
			case GXML_DOM_NODE_TYPE_ENTITY_REFERENCE:
			{
				break;
			}
			case GXML_DOM_NODE_TYPE_ENTITY:
			{
				break;
			}
			case GXML_DOM_NODE_TYPE_PROCESSING_INSTRUCTION:
			{
				break;
			}
			case GXML_DOM_NODE_TYPE_DOCUMENT_TYPE:
			{
				break;
			}
			case GXML_DOM_NODE_TYPE_NOTATION:
			{
				break;
			}
			case GXML_DOM_NODE_TYPE_ATTRIBUTE:
			{
				break;
			}
			case GXML_DOM_NODE_TYPE_DOCUMENT:
			{
				break;
			}
			default:
			break;
		}
		_tmp11_ = g_hash_table_lookup (self->node_dict, xmlnode);
		domnode = (GXmlDomXNode*) _tmp11_;
	}
	result = domnode;
	return result;
}


/** Constructor */
static GXmlDomDocument* gxml_dom_document_construct (GType object_type, xmlDoc* doc, GError** error) {
	GXmlDomDocument * self = NULL;
	xmlNode* root = NULL;
	xmlNode* _tmp0_ = NULL;
	gboolean _tmp3_ = FALSE;
	GXmlDomImplementation* _tmp6_ = NULL;
	GXmlDomImplementation* _tmp7_;
	GError * _inner_error_ = NULL;
	_tmp0_ = xmlDocGetRootElement (doc);
	root = _tmp0_;
	if (doc == NULL) {
		GError* _tmp1_ = NULL;
		_tmp1_ = g_error_new_literal (GXML_DOM_DOM_ERROR, GXML_DOM_DOM_ERROR_INVALID_DOC, "Failed to parse document.");
		_inner_error_ = _tmp1_;
		if (_inner_error_->domain == GXML_DOM_DOM_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (root == NULL) {
		GError* _tmp2_ = NULL;
		_tmp2_ = g_error_new_literal (GXML_DOM_DOM_ERROR, GXML_DOM_DOM_ERROR_INVALID_ROOT, "Could not obtain root for document.");
		_inner_error_ = _tmp2_;
		if (_inner_error_->domain == GXML_DOM_DOM_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	self = (GXmlDomDocument*) gxml_dom_xnode_construct_for_document (object_type);
	gxml_dom_xnode_set_owner_document ((GXmlDomXNode*) self, self);
	self->xmldoc = doc;
	if (doc->intSubset == NULL) {
		_tmp3_ = doc->extSubset == NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gxml_dom_document_set_doctype (self, NULL);
	} else {
		GXmlDomDocumentType* _tmp4_ = NULL;
		GXmlDomDocumentType* _tmp5_;
		_tmp4_ = gxml_dom_document_type_new (doc->intSubset, doc->extSubset, self);
		_tmp5_ = _tmp4_;
		gxml_dom_document_set_doctype (self, _tmp5_);
		_g_object_unref0 (_tmp5_);
	}
	_tmp6_ = gxml_dom_implementation_new ();
	_tmp7_ = _tmp6_;
	gxml_dom_document_set_implementation (self, _tmp7_);
	_gxml_dom_implementation_unref0 (_tmp7_);
	return self;
}


static GXmlDomDocument* gxml_dom_document_new (xmlDoc* doc, GError** error) {
	return gxml_dom_document_construct (GXML_DOM_TYPE_DOCUMENT, doc, error);
}


/**
 * Creates a Document from the file at file_path.
 *
 * @throws DomError When a Document cannot be constructed for the specified file.
 */
GXmlDomDocument* gxml_dom_document_construct_for_path (GType object_type, const gchar* file_path, GError** error) {
	GXmlDomDocument * self = NULL;
	xmlDoc* _tmp0_ = NULL;
	xmlDoc* doc;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file_path != NULL, NULL);
	_tmp0_ = xmlParseFile (file_path);
	doc = _tmp0_;
	self = (GXmlDomDocument*) gxml_dom_document_construct (object_type, doc, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GXML_DOM_DOM_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


GXmlDomDocument* gxml_dom_document_new_for_path (const gchar* file_path, GError** error) {
	return gxml_dom_document_construct_for_path (GXML_DOM_TYPE_DOCUMENT, file_path, error);
}


gint _gxml_dom_document_iowrite (void* ctx, gchar* buf, int buf_length1, gint len) {
	gint result = 0;
	GXmlDomOutputStreamBox* box;
	GOutputStream* _tmp0_;
	GOutputStream* outstream;
	gint bytes_writ;
	gssize _tmp1_;
	gssize _tmp2_;
	GError * _inner_error_ = NULL;
	box = (GXmlDomOutputStreamBox*) ctx;
	_tmp0_ = _g_object_ref0 ((*box).str);
	outstream = _tmp0_;
	bytes_writ = -1;
	_tmp1_ = g_output_stream_write (outstream, (guint8*) buf, (gsize) buf_length1, (*box).can, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch1_g_io_error;
		}
		_g_object_unref0 (outstream);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	bytes_writ = (gint) _tmp2_;
	goto __finally1;
	__catch1_g_io_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		bytes_writ = -1;
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (outstream);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = bytes_writ;
	_g_object_unref0 (outstream);
	return result;
}


gint _gxml_dom_document_iooutclose (void* ctx) {
	gint result = 0;
	GXmlDomOutputStreamBox* box;
	GOutputStream* _tmp0_;
	GOutputStream* outstream;
	gint success;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
	box = (GXmlDomOutputStreamBox*) ctx;
	_tmp0_ = _g_object_ref0 ((*box).str);
	outstream = _tmp0_;
	success = -1;
	_tmp1_ = g_output_stream_close (outstream, (*box).can, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		goto __catch2_g_error;
	}
	if (_tmp2_) {
		success = 0;
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		success = -1;
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (outstream);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = success;
	_g_object_unref0 (outstream);
	return result;
}


gint _gxml_dom_document_ioread (void* ctx, gchar* buf, int buf_length1, gint len) {
	gint result = 0;
	GXmlDomInputStreamBox* box;
	GInputStream* _tmp0_;
	GInputStream* instream;
	gint bytes_read;
	gssize _tmp1_;
	gssize _tmp2_;
	GError * _inner_error_ = NULL;
	box = (GXmlDomInputStreamBox*) ctx;
	_tmp0_ = _g_object_ref0 ((*box).str);
	instream = _tmp0_;
	bytes_read = -1;
	_tmp1_ = g_input_stream_read (instream, (guint8*) buf, (gsize) buf_length1, (*box).can, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch3_g_io_error;
		}
		_g_object_unref0 (instream);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	bytes_read = (gint) _tmp2_;
	goto __finally3;
	__catch3_g_io_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		bytes_read = -1;
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (instream);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = bytes_read;
	_g_object_unref0 (instream);
	return result;
}


gint _gxml_dom_document_ioinclose (void* ctx) {
	gint result = 0;
	GXmlDomInputStreamBox* box;
	GInputStream* _tmp0_;
	GInputStream* instream;
	gint success;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
	box = (GXmlDomInputStreamBox*) ctx;
	_tmp0_ = _g_object_ref0 ((*box).str);
	instream = _tmp0_;
	success = -1;
	_tmp1_ = g_input_stream_close (instream, (*box).can, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		goto __catch4_g_error;
	}
	if (_tmp2_) {
		success = 0;
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		success = -1;
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (instream);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = success;
	_g_object_unref0 (instream);
	return result;
}


/**
 * Creates a Document from the File fin.
 *
 * @throws DomError When a Document cannot be constructed for the specified file.
 */
GXmlDomDocument* gxml_dom_document_construct_for_file (GType object_type, GFile* fin, GError** error) {
	GXmlDomDocument * self = NULL;
	GInputStream* instream = NULL;
	GFileInputStream* _tmp0_ = NULL;
	GFileInputStream* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (fin != NULL, NULL);
	_tmp0_ = g_file_read (fin, NULL, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch5_g_error;
	}
	_g_object_unref0 (instream);
	instream = (GInputStream*) _tmp1_;
	goto __finally5;
	__catch5_g_error:
	{
		GError * e;
		GError* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = g_error_new_literal (GXML_DOM_DOM_ERROR, GXML_DOM_DOM_ERROR_INVALID_DOC, e->message);
		_inner_error_ = _tmp2_;
		_g_error_free0 (e);
		goto __finally5;
	}
	__finally5:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GXML_DOM_DOM_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (instream);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (instream);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	self = (GXmlDomDocument*) gxml_dom_document_construct_for_stream (object_type, instream, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GXML_DOM_DOM_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (instream);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (instream);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_object_unref0 (instream);
	return self;
}


GXmlDomDocument* gxml_dom_document_new_for_file (GFile* fin, GError** error) {
	return gxml_dom_document_construct_for_file (GXML_DOM_TYPE_DOCUMENT, fin, error);
}


/**
 * Creates a Document from data provided through the InputStream instream.
 *
 * @throws DomError When a Document cannot be constructed for the specified stream.
 */
GXmlDomDocument* gxml_dom_document_construct_for_stream (GType object_type, GInputStream* instream, GError** error) {
	GXmlDomDocument * self = NULL;
	GCancellable* _tmp0_ = NULL;
	GCancellable* can;
	GInputStream* _tmp1_;
	GCancellable* _tmp2_;
	GXmlDomInputStreamBox _tmp3_ = {0};
	GXmlDomInputStreamBox box;
	xmlTextReader* _tmp4_ = NULL;
	xmlTextReader* reader;
	xmlDoc* _tmp5_ = NULL;
	xmlDoc* doc;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (instream != NULL, NULL);
	_tmp0_ = g_cancellable_new ();
	can = _tmp0_;
	_tmp1_ = _g_object_ref0 (instream);
	_tmp2_ = _g_object_ref0 (can);
	_tmp3_.str = _tmp1_;
	_tmp3_.can = _tmp2_;
	box = _tmp3_;
	_tmp4_ = xmlReaderForIO ((xmlInputReadCallback) _gxml_dom_document_ioread, (xmlInputCloseCallback) _gxml_dom_document_ioinclose, &box, "", NULL, 0);
	reader = _tmp4_;
	xmlTextReaderRead (reader);
	xmlTextReaderExpand (reader);
	_tmp5_ = xmlTextReaderCurrentDoc (reader);
	doc = _tmp5_;
	self = (GXmlDomDocument*) gxml_dom_document_construct (object_type, doc, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GXML_DOM_DOM_ERROR) {
			g_propagate_error (error, _inner_error_);
			_xmlFreeTextReader0 (reader);
			gxml_dom_input_stream_box_destroy (&box);
			_g_object_unref0 (can);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_xmlFreeTextReader0 (reader);
			gxml_dom_input_stream_box_destroy (&box);
			_g_object_unref0 (can);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_xmlFreeTextReader0 (reader);
	gxml_dom_input_stream_box_destroy (&box);
	_g_object_unref0 (can);
	return self;
}


GXmlDomDocument* gxml_dom_document_new_for_stream (GInputStream* instream, GError** error) {
	return gxml_dom_document_construct_for_stream (GXML_DOM_TYPE_DOCUMENT, instream, error);
}


/**
 * Creates a Document from data found in memory.
 *
 * @throws DomError When a Document cannot be constructed for the specified data.
 */
GXmlDomDocument* gxml_dom_document_construct_from_string (GType object_type, const gchar* memory, GError** error) {
	GXmlDomDocument * self = NULL;
	gint _tmp0_;
	xmlDoc* _tmp1_ = NULL;
	xmlDoc* doc;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (memory != NULL, NULL);
	_tmp0_ = strlen (memory);
	_tmp1_ = xmlParseMemory (memory, (gint) _tmp0_);
	doc = _tmp1_;
	self = (GXmlDomDocument*) gxml_dom_document_construct (object_type, doc, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GXML_DOM_DOM_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


GXmlDomDocument* gxml_dom_document_new_from_string (const gchar* memory, GError** error) {
	return gxml_dom_document_construct_from_string (GXML_DOM_TYPE_DOCUMENT, memory, error);
}


/**
 * Saves a Document to the file at path file_path
 */
void gxml_dom_document_save_to_path (GXmlDomDocument* self, const gchar* file_path) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (file_path != NULL);
	xmlSaveFile (file_path, self->xmldoc);
}


/**
 * Saves a Document to the OutputStream outstream.
 */
void gxml_dom_document_save_to_stream (GXmlDomDocument* self, GOutputStream* outstream, GError** error) {
	GCancellable* _tmp0_ = NULL;
	GCancellable* can;
	GOutputStream* _tmp1_;
	GCancellable* _tmp2_;
	GXmlDomOutputStreamBox _tmp3_ = {0};
	GXmlDomOutputStreamBox box;
	xmlSaveCtxt* _tmp4_ = NULL;
	xmlSaveCtxt* ctxt;
	g_return_if_fail (self != NULL);
	g_return_if_fail (outstream != NULL);
	_tmp0_ = g_cancellable_new ();
	can = _tmp0_;
	_tmp1_ = _g_object_ref0 (outstream);
	_tmp2_ = _g_object_ref0 (can);
	_tmp3_.str = _tmp1_;
	_tmp3_.can = _tmp2_;
	box = _tmp3_;
	_tmp4_ = xmlSaveToIO ((xmlOutputWriteCallback) _gxml_dom_document_iowrite, (xmlOutputCloseCallback) _gxml_dom_document_iooutclose, &box, NULL, 0);
	ctxt = _tmp4_;
	xmlSaveDoc (ctxt, self->xmldoc);
	xmlSaveFlush (ctxt);
	gxml_dom_output_stream_box_destroy (&box);
	_g_object_unref0 (can);
}


/**
 * Creates an empty Element node with the tag name
 * tag_name. XML example: {{{<Person></Person>}}}
 */
GXmlDomElement* gxml_dom_document_create_element (GXmlDomDocument* self, const gchar* tag_name, GError** error) {
	GXmlDomElement* result = NULL;
	xmlNode* _tmp0_ = NULL;
	xmlNode* xmlelem;
	GXmlDomElement* _tmp1_ = NULL;
	GXmlDomElement* new_elem;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag_name != NULL, NULL);
	_tmp0_ = xmlNewDocNode (self->xmldoc, NULL, tag_name, NULL);
	xmlelem = _tmp0_;
	_tmp1_ = gxml_dom_element_new (xmlelem, self);
	new_elem = _tmp1_;
	result = new_elem;
	return result;
}


/**
 * Creates a DocumentFragment.
 */
GXmlDomDocumentFragment* gxml_dom_document_create_document_fragment (GXmlDomDocument* self) {
	GXmlDomDocumentFragment* result = NULL;
	xmlNode* _tmp0_ = NULL;
	GXmlDomDocumentFragment* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = xmlNewDocFragment (self->xmldoc);
	_tmp1_ = gxml_dom_document_fragment_new (_tmp0_, self);
	result = _tmp1_;
	return result;
}


/**
 * Creates a text node containing the text in data.
 * XML example:
 * {{{<someElement>Text is contained here.</someElement>}}}
 */
GXmlDomText* gxml_dom_document_create_text_node (GXmlDomDocument* self, const gchar* data) {
	GXmlDomText* result = NULL;
	xmlNode* _tmp0_ = NULL;
	GXmlDomText* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = xmlNewDocText (self->xmldoc, data);
	_tmp1_ = gxml_dom_text_new (_tmp0_, self);
	result = _tmp1_;
	return result;
}


/**
 * Creates an XML comment with data. XML example: {{{<!-- data -->}}}
 */
GXmlDomComment* gxml_dom_document_create_comment (GXmlDomDocument* self, const gchar* data) {
	GXmlDomComment* result = NULL;
	xmlNode* _tmp0_ = NULL;
	GXmlDomComment* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = xmlNewDocComment (self->xmldoc, data);
	_tmp1_ = gxml_dom_comment_new (_tmp0_, self);
	result = _tmp1_;
	return result;
}


/**
 * Creates a CDATA section containing data. XML
 * example:
 * {{{ <![CDATA[Here contains non-XML data, like
 * code, or something that requires a lot of special
 * XML entities.]]>. }}}
 */
GXmlDomCDATASection* gxml_dom_document_create_cdata_section (GXmlDomDocument* self, const gchar* data, GError** error) {
	GXmlDomCDATASection* result = NULL;
	gint _tmp0_;
	xmlNode* _tmp1_ = NULL;
	GXmlDomCDATASection* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	gxml_dom_document_check_html (self, "CDATA section", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GXML_DOM_DOM_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = strlen (data);
	_tmp1_ = xmlNewCDataBlock (self->xmldoc, data, (gint) _tmp0_);
	_tmp2_ = gxml_dom_cdata_section_new (_tmp1_, self);
	result = _tmp2_;
	return result;
}


/**
 * Creates a Processing Instructions. XML example:
 * {{{<?pi_target processing instruction data?>
 * <?xml-stylesheet href="style.xsl" type="text/xml"?>}}}
 */
GXmlDomProcessingInstruction* gxml_dom_document_create_processing_instruction (GXmlDomDocument* self, const gchar* target, const gchar* data, GError** error) {
	GXmlDomProcessingInstruction* result = NULL;
	GXmlDomProcessingInstruction* _tmp0_ = NULL;
	GXmlDomProcessingInstruction* pi;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (target != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	gxml_dom_document_check_html (self, "processing instructions", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GXML_DOM_DOM_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	gxml_dom_document_check_character_validity (self, target, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GXML_DOM_DOM_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	gxml_dom_document_check_character_validity (self, data, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GXML_DOM_DOM_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = gxml_dom_processing_instruction_new (target, data, self);
	pi = _tmp0_;
	result = pi;
	return result;
}


/**
 * Creates an Attr attribute with name, usually to be associated with an Element.
 */
GXmlDomAttr* gxml_dom_document_create_attribute (GXmlDomDocument* self, const gchar* name, GError** error) {
	GXmlDomAttr* result = NULL;
	xmlAttr* _tmp0_ = NULL;
	GXmlDomAttr* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	gxml_dom_document_check_character_validity (self, name, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GXML_DOM_DOM_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = xmlNewDocProp (self->xmldoc, name, "");
	_tmp1_ = gxml_dom_attr_new (_tmp0_, self);
	result = _tmp1_;
	return result;
}


/**
 * Creates an entity reference. XML example:
 * {{{&name;
 * &apos;}}}
 */
GXmlDomEntityReference* gxml_dom_document_create_entity_reference (GXmlDomDocument* self, const gchar* name, GError** error) {
	GXmlDomEntityReference* result = NULL;
	GXmlDomEntityReference* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	gxml_dom_document_check_html (self, "entity reference", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GXML_DOM_DOM_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	gxml_dom_document_check_character_validity (self, name, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GXML_DOM_DOM_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = gxml_dom_entity_reference_new (name, self);
	result = _tmp0_;
	return result;
}


/**
 * Obtains a list of ELements with the given tag name
 * tag_name contained within this document.
 *
 * This list is updated as new elements are added to
 * the document.
 */
GList* gxml_dom_document_get_elements_by_tag_name (GXmlDomDocument* self, const gchar* tag_name) {
	GList* result = NULL;
	GXmlDomElement* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag_name != NULL, NULL);
	_tmp0_ = gxml_dom_document_get_document_element (self);
	_tmp1_ = gxml_dom_element_get_elements_by_tag_name (_tmp0_, tag_name);
	result = _tmp1_;
	return result;
}


static void gxml_dom_document_check_html (GXmlDomDocument* self, const gchar* feature, GError** error) {
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (feature != NULL);
	if (self->priv->_doctype != NULL) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = gxml_dom_document_type_get_name (self->priv->_doctype);
		_tmp0_ = g_strcmp0 (_tmp1_, "html") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		GError* _tmp4_ = NULL;
		GError* _tmp5_;
		_tmp2_ = g_strdup_printf ("HTML documents do not support '%s'", feature);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_error_new_literal (GXML_DOM_DOM_ERROR, GXML_DOM_DOM_ERROR_NOT_SUPPORTED, _tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		_inner_error_ = _tmp5_;
		if (_inner_error_->domain == GXML_DOM_DOM_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void gxml_dom_document_check_character_validity (GXmlDomDocument* self, const gchar* str, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (str != NULL);
	if (FALSE == FALSE) {
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		GError* _tmp2_ = NULL;
		GError* _tmp3_;
		_tmp0_ = g_strdup_printf ("'%s' contains invalid characters.", str);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_error_new_literal (GXML_DOM_DOM_ERROR, GXML_DOM_DOM_ERROR_INVALID_CHARACTER, _tmp1_);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp1_);
		_inner_error_ = _tmp3_;
		if (_inner_error_->domain == GXML_DOM_DOM_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static const gchar* gxml_dom_document_real_get_node_name (GXmlDomXNode* base) {
	const gchar* result;
	GXmlDomDocument* self;
	self = (GXmlDomDocument*) base;
	result = "#document";
	return result;
}


static void gxml_dom_document_real_set_node_name (GXmlDomXNode* base, const gchar* value) {
	GXmlDomDocument* self;
	self = (GXmlDomDocument*) base;
	g_object_notify ((GObject *) self, "node-name");
}


GXmlDomDocumentType* gxml_dom_document_get_doctype (GXmlDomDocument* self) {
	GXmlDomDocumentType* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_doctype;
	return result;
}


static void gxml_dom_document_set_doctype (GXmlDomDocument* self, GXmlDomDocumentType* value) {
	GXmlDomDocumentType* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_doctype);
	self->priv->_doctype = _tmp0_;
	g_object_notify ((GObject *) self, "doctype");
}


GXmlDomImplementation* gxml_dom_document_get_implementation (GXmlDomDocument* self) {
	GXmlDomImplementation* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_implementation;
	return result;
}


static gpointer _gxml_dom_implementation_ref0 (gpointer self) {
	return self ? gxml_dom_implementation_ref (self) : NULL;
}


static void gxml_dom_document_set_implementation (GXmlDomDocument* self, GXmlDomImplementation* value) {
	GXmlDomImplementation* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _gxml_dom_implementation_ref0 (value);
	_gxml_dom_implementation_unref0 (self->priv->_implementation);
	self->priv->_implementation = _tmp0_;
	g_object_notify ((GObject *) self, "implementation");
}


GXmlDomElement* gxml_dom_document_get_document_element (GXmlDomDocument* self) {
	GXmlDomElement* result;
	xmlNode* _tmp0_ = NULL;
	GXmlDomXNode* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = xmlDocGetRootElement (self->xmldoc);
	_tmp1_ = gxml_dom_document_lookup_node (self, _tmp0_);
	result = GXML_DOM_ELEMENT (_tmp1_);
	return result;
}


static void gxml_dom_document_set_document_element (GXmlDomDocument* self, GXmlDomElement* value) {
	g_return_if_fail (self != NULL);
	g_object_notify ((GObject *) self, "document-element");
}


static void gxml_dom_document_class_init (GXmlDomDocumentClass * klass) {
	gxml_dom_document_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GXmlDomDocumentPrivate));
	GXML_DOM_XNODE_CLASS (klass)->get_node_name = gxml_dom_document_real_get_node_name;
	GXML_DOM_XNODE_CLASS (klass)->set_node_name = gxml_dom_document_real_set_node_name;
	G_OBJECT_CLASS (klass)->get_property = _vala_gxml_dom_document_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gxml_dom_document_set_property;
	G_OBJECT_CLASS (klass)->finalize = gxml_dom_document_finalize;
	/**
	 * Provides the name for this node. For documents, it is always "#document".
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GXML_DOM_DOCUMENT_NODE_NAME, "node-name");
	/**
	 * The Document Type Definition (DTD) defining this document. This may be null.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_DOM_DOCUMENT_DOCTYPE, g_param_spec_object ("doctype", "doctype", "doctype", GXML_DOM_TYPE_DOCUMENT_TYPE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * Describes the features of the DOM implementation behind this document.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_DOM_DOCUMENT_IMPLEMENTATION, gxml_dom_param_spec_implementation ("implementation", "implementation", "implementation", GXML_DOM_TYPE_IMPLEMENTATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * The root node of the document's node tree.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_DOM_DOCUMENT_DOCUMENT_ELEMENT, g_param_spec_object ("document-element", "document-element", "document-element", GXML_DOM_TYPE_ELEMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gxml_dom_document_instance_init (GXmlDomDocument * self) {
	GHashTable* _tmp0_ = NULL;
	self->priv = GXML_DOM_DOCUMENT_GET_PRIVATE (self);
	_tmp0_ = g_hash_table_new_full (g_direct_hash, g_direct_equal, NULL, _g_object_unref0_);
	self->node_dict = _tmp0_;
}


static void gxml_dom_document_finalize (GObject* obj) {
	GXmlDomDocument * self;
	self = GXML_DOM_DOCUMENT (obj);
	_g_hash_table_unref0 (self->node_dict);
	_g_object_unref0 (self->priv->_doctype);
	_gxml_dom_implementation_unref0 (self->priv->_implementation);
	G_OBJECT_CLASS (gxml_dom_document_parent_class)->finalize (obj);
}


/**
 * Represents an XML Document as a tree of nodes. The Document has a document element, which is the root of the tree. A Document can have its type defined by a DocumentType.
 * For more, see: [[http://www.w3.org/TR/DOM-Level-1/level-one-core.html#i-Document]]
 */
GType gxml_dom_document_get_type (void) {
	static volatile gsize gxml_dom_document_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_dom_document_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlDomDocumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gxml_dom_document_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GXmlDomDocument), 0, (GInstanceInitFunc) gxml_dom_document_instance_init, NULL };
		GType gxml_dom_document_type_id;
		gxml_dom_document_type_id = g_type_register_static (GXML_DOM_TYPE_XNODE, "GXmlDomDocument", &g_define_type_info, 0);
		g_once_init_leave (&gxml_dom_document_type_id__volatile, gxml_dom_document_type_id);
	}
	return gxml_dom_document_type_id__volatile;
}


static void _vala_gxml_dom_document_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GXmlDomDocument * self;
	self = GXML_DOM_DOCUMENT (object);
	switch (property_id) {
		case GXML_DOM_DOCUMENT_NODE_NAME:
		g_value_set_string (value, gxml_dom_xnode_get_node_name ((GXmlDomXNode*) self));
		break;
		case GXML_DOM_DOCUMENT_DOCTYPE:
		g_value_set_object (value, gxml_dom_document_get_doctype (self));
		break;
		case GXML_DOM_DOCUMENT_IMPLEMENTATION:
		gxml_dom_value_set_implementation (value, gxml_dom_document_get_implementation (self));
		break;
		case GXML_DOM_DOCUMENT_DOCUMENT_ELEMENT:
		g_value_set_object (value, gxml_dom_document_get_document_element (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gxml_dom_document_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GXmlDomDocument * self;
	self = GXML_DOM_DOCUMENT (object);
	switch (property_id) {
		case GXML_DOM_DOCUMENT_NODE_NAME:
		gxml_dom_xnode_set_node_name ((GXmlDomXNode*) self, g_value_get_string (value));
		break;
		case GXML_DOM_DOCUMENT_DOCTYPE:
		gxml_dom_document_set_doctype (self, g_value_get_object (value));
		break;
		case GXML_DOM_DOCUMENT_IMPLEMENTATION:
		gxml_dom_document_set_implementation (self, gxml_dom_value_get_implementation (value));
		break;
		case GXML_DOM_DOCUMENT_DOCUMENT_ELEMENT:
		gxml_dom_document_set_document_element (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



