/* Enumeration.c generated by valac 0.28.1, the Vala compiler
 * generated from Enumeration.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 2 -*- */
/* Serializable.vala
 *
 + Copyright (C) 2013  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>


#define GXML_TYPE_ENUMERATION (gxml_enumeration_get_type ())
#define GXML_ENUMERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ENUMERATION, GXmlEnumeration))
#define GXML_ENUMERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_ENUMERATION, GXmlEnumerationClass))
#define GXML_IS_ENUMERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ENUMERATION))
#define GXML_IS_ENUMERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_ENUMERATION))
#define GXML_ENUMERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_ENUMERATION, GXmlEnumerationClass))

typedef struct _GXmlEnumeration GXmlEnumeration;
typedef struct _GXmlEnumerationClass GXmlEnumerationClass;
typedef struct _GXmlEnumerationPrivate GXmlEnumerationPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
typedef struct _GXmlParamSpecEnumeration GXmlParamSpecEnumeration;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GXmlEnumeration {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GXmlEnumerationPrivate * priv;
};

struct _GXmlEnumerationClass {
	GTypeClass parent_class;
	void (*finalize) (GXmlEnumeration *self);
};

typedef enum  {
	GXML_ENUMERATION_ERROR_INVALID_VALUE,
	GXML_ENUMERATION_ERROR_INVALID_TEXT
} GXmlEnumerationError;
#define GXML_ENUMERATION_ERROR gxml_enumeration_error_quark ()
struct _GXmlParamSpecEnumeration {
	GParamSpec parent_instance;
};


static gpointer gxml_enumeration_parent_class = NULL;

gpointer gxml_enumeration_ref (gpointer instance);
void gxml_enumeration_unref (gpointer instance);
GParamSpec* gxml_param_spec_enumeration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gxml_value_set_enumeration (GValue* value, gpointer v_object);
void gxml_value_take_enumeration (GValue* value, gpointer v_object);
gpointer gxml_value_get_enumeration (const GValue* value);
GType gxml_enumeration_get_type (void) G_GNUC_CONST;
enum  {
	GXML_ENUMERATION_DUMMY_PROPERTY
};
gchar* gxml_enumeration_get_nick (GType enumeration, gint val, GError** error);
gchar* gxml_enumeration_get_string (GType enumeration, gint val, gboolean use_nick, gboolean camelcase, GError** error);
gchar* gxml_enumeration_get_nick_camelcase (GType enumeration, gint val, GError** error);
void gxml_init_init (void);
static GEnumValue* _g_enum_value_dup (GEnumValue* self);
GQuark gxml_enumeration_error_quark (void);
GEnumValue* gxml_enumeration_parse (GType enumeration, const gchar* val, GError** error);
GEnumValue* gxml_enumeration_to_array (GType enumeration, int* result_length1);
GEnumValue* gxml_enumeration_parse_integer (GType enumeration, gint val);
static GEnumValue* _vala_array_dup2 (GEnumValue* self, int length);
gchar** gxml_enumeration_to_string_array (GType enumeration, int* result_length1, GError** error);
static GEnumValue* _vala_array_dup3 (GEnumValue* self, int length);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
GXmlEnumeration* gxml_enumeration_new (void);
GXmlEnumeration* gxml_enumeration_construct (GType object_type);
static void gxml_enumeration_finalize (GXmlEnumeration* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
 * Introspect an enumeration to get value's nick name.
 *
 * Returns: an string representing an enumeration's value.
 *
 * @param enumeration a {@link GLib.Type} of type {@link GLib.Type.ENUM}
 * @param val an integer to parse an enum value of type @enumeration.
 */
gchar* gxml_enumeration_get_nick (GType enumeration, gint val, GError** error) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	GType _tmp1_ = 0UL;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp1_ = enumeration;
	_tmp2_ = val;
	_tmp3_ = gxml_enumeration_get_string (_tmp1_, _tmp2_, TRUE, FALSE, &_inner_error_);
	_tmp0_ = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp4_;
	_g_free0 (_tmp0_);
	return result;
}


/**
 * Introspect an enumeration to get value's nick name and transform
 * to camel case representation.
 *
 * Returns: an string representing an enumeration's value.
 *
 * @param enumeration a {@link GLib.Type} of type {@link GLib.Type.ENUM}
 * @param val an integer to parse an enum value of type @param enumeration.
 */
gchar* gxml_enumeration_get_nick_camelcase (GType enumeration, gint val, GError** error) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	GType _tmp1_ = 0UL;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp1_ = enumeration;
	_tmp2_ = val;
	_tmp3_ = gxml_enumeration_get_string (_tmp1_, _tmp2_, FALSE, TRUE, &_inner_error_);
	_tmp0_ = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp4_;
	_g_free0 (_tmp0_);
	return result;
}


/**
 * Transform enumeration's value to its string representation.
 *
 * Returns: an string representing an enumeration's value.
 *
 * @param enumeration a {@link GLib.Type} of type {@link GLib.Type.ENUM}
 * @param val an integer to parse an enum value of type @enumeration.
 * @param use_nick makes to returns value's nick name in {@link GLib.EnumClass}
 * @param camelcase makes to returns value's nick name in {@link GLib.EnumClass}
 * as camel case representation. If @use_nick is set this take no effect.
 */
static GEnumValue* _g_enum_value_dup (GEnumValue* self) {
	GEnumValue* dup;
	dup = g_new0 (GEnumValue, 1);
	memcpy (dup, self, sizeof (GEnumValue));
	return dup;
}


static gpointer __g_enum_value_dup0 (gpointer self) {
	return self ? _g_enum_value_dup (self) : NULL;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


gchar* gxml_enumeration_get_string (GType enumeration, gint val, gboolean use_nick, gboolean camelcase, GError** error) {
	gchar* result = NULL;
	GType _tmp0_ = 0UL;
	gboolean _tmp1_ = FALSE;
	gchar* camel = NULL;
	gchar* _tmp2_ = NULL;
	GEnumClass* enumc = NULL;
	GType _tmp3_ = 0UL;
	GTypeClass* _tmp4_ = NULL;
	GEnumValue* enumv = NULL;
	GEnumClass* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	GEnumValue* _tmp7_ = NULL;
	GEnumValue* _tmp8_ = NULL;
	GEnumValue* _tmp9_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	GError * _inner_error_ = NULL;
	_tmp0_ = enumeration;
	_tmp1_ = g_type_is_a (_tmp0_, G_TYPE_ENUM);
	_vala_return_val_if_fail (_tmp1_, "enumeration.is_a (Type.ENUM)", NULL);
	gxml_init_init ();
	_tmp2_ = g_strdup ("");
	camel = _tmp2_;
	_tmp3_ = enumeration;
	_tmp4_ = g_type_class_ref (_tmp3_);
	enumc = (GEnumClass*) _tmp4_;
	_tmp5_ = enumc;
	_tmp6_ = val;
	_tmp7_ = g_enum_get_value (_tmp5_, _tmp6_);
	_tmp8_ = __g_enum_value_dup0 (_tmp7_);
	enumv = _tmp8_;
	_tmp9_ = enumv;
	if (_tmp9_ == NULL) {
		const gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		_tmp10_ = _ ("value is invalid");
		_tmp11_ = g_error_new_literal (GXML_ENUMERATION_ERROR, GXML_ENUMERATION_ERROR_INVALID_VALUE, _tmp10_);
		_inner_error_ = _tmp11_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (enumv);
		_g_type_class_unref0 (enumc);
		_g_free0 (camel);
		return NULL;
	}
	_tmp13_ = use_nick;
	if (_tmp13_) {
		GEnumValue* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		_tmp14_ = enumv;
		_tmp15_ = (*_tmp14_).value_nick;
		_tmp12_ = _tmp15_ != NULL;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		GEnumValue* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		_tmp16_ = enumv;
		_tmp17_ = (*_tmp16_).value_nick;
		_tmp18_ = g_strdup (_tmp17_);
		result = _tmp18_;
		_g_free0 (enumv);
		_g_type_class_unref0 (enumc);
		_g_free0 (camel);
		return result;
	}
	_tmp20_ = camelcase;
	if (_tmp20_) {
		GEnumValue* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		_tmp21_ = enumv;
		_tmp22_ = (*_tmp21_).value_nick;
		_tmp19_ = _tmp22_ != NULL;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		gchar** sp = NULL;
		GEnumValue* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		gchar** _tmp25_ = NULL;
		gchar** _tmp26_ = NULL;
		gint sp_length1 = 0;
		gint _sp_size_ = 0;
		gchar** _tmp27_ = NULL;
		gint _tmp27__length1 = 0;
		_tmp23_ = enumv;
		_tmp24_ = (*_tmp23_).value_nick;
		_tmp26_ = _tmp25_ = g_strsplit (_tmp24_, "-", 0);
		sp = _tmp26_;
		sp_length1 = _vala_array_length (_tmp25_);
		_sp_size_ = sp_length1;
		_tmp27_ = sp;
		_tmp27__length1 = sp_length1;
		{
			gchar** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
			s_collection = _tmp27_;
			s_collection_length1 = _tmp27__length1;
			for (s_it = 0; s_it < _tmp27__length1; s_it = s_it + 1) {
				gchar* _tmp28_ = NULL;
				gchar* s = NULL;
				_tmp28_ = g_strdup (s_collection[s_it]);
				s = _tmp28_;
				{
					const gchar* _tmp29_ = NULL;
					const gchar* _tmp30_ = NULL;
					gchar _tmp31_ = '\0';
					gchar* _tmp32_ = NULL;
					gchar* _tmp33_ = NULL;
					gchar* _tmp34_ = NULL;
					gchar* _tmp35_ = NULL;
					const gchar* _tmp36_ = NULL;
					const gchar* _tmp37_ = NULL;
					gint _tmp38_ = 0;
					gint _tmp39_ = 0;
					gchar* _tmp40_ = NULL;
					gchar* _tmp41_ = NULL;
					const gchar* _tmp42_ = NULL;
					gchar* _tmp43_ = NULL;
					gchar* _tmp44_ = NULL;
					gchar* _tmp45_ = NULL;
					_tmp29_ = camel;
					_tmp30_ = s;
					_tmp31_ = string_get (_tmp30_, (glong) 0);
					_tmp32_ = g_strdup_printf ("%c", _tmp31_);
					_tmp33_ = _tmp32_;
					_tmp34_ = g_utf8_strup (_tmp33_, (gssize) (-1));
					_tmp35_ = _tmp34_;
					_tmp36_ = s;
					_tmp37_ = s;
					_tmp38_ = strlen (_tmp37_);
					_tmp39_ = _tmp38_;
					_tmp40_ = string_slice (_tmp36_, (glong) 1, (glong) _tmp39_);
					_tmp41_ = _tmp40_;
					_tmp42_ = string_to_string (_tmp41_);
					_tmp43_ = g_strconcat (_tmp35_, _tmp42_, NULL);
					_tmp44_ = _tmp43_;
					_tmp45_ = g_strconcat (_tmp29_, _tmp44_, NULL);
					_g_free0 (camel);
					camel = _tmp45_;
					_g_free0 (_tmp44_);
					_g_free0 (_tmp41_);
					_g_free0 (_tmp35_);
					_g_free0 (_tmp33_);
					_g_free0 (s);
				}
			}
		}
		sp = (_vala_array_free (sp, sp_length1, (GDestroyNotify) g_free), NULL);
	} else {
		GEnumValue* _tmp46_ = NULL;
		const gchar* _tmp47_ = NULL;
		gchar* _tmp48_ = NULL;
		_tmp46_ = enumv;
		_tmp47_ = (*_tmp46_).value_name;
		_tmp48_ = g_strdup (_tmp47_);
		_g_free0 (camel);
		camel = _tmp48_;
	}
	result = camel;
	_g_free0 (enumv);
	_g_type_class_unref0 (enumc);
	return result;
}


/**
 * Parse @val to an enumeration's value.
 * 
 * Returns: an {@link GLib.EnumValue} representing an enumeration's value.
 * 
 * @param enumeration a {@link GLib.Type} of type {@link GLib.Type.ENUM}
 * @param val a string to parse an enum value of type @param enumeration.
 * as camel case representation. If @use_nick is set this take no effect.
 */
GEnumValue* gxml_enumeration_parse (GType enumeration, const gchar* val, GError** error) {
	GEnumValue* result = NULL;
	GType _tmp0_ = 0UL;
	gboolean _tmp1_ = FALSE;
	GEnumClass* enumc = NULL;
	GType _tmp2_ = 0UL;
	GTypeClass* _tmp3_ = NULL;
	GEnumValue* enumv = NULL;
	GEnumClass* _tmp4_ = NULL;
	GEnumValue* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	GEnumValue* _tmp33_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (val != NULL, NULL);
	_tmp0_ = enumeration;
	_tmp1_ = g_type_is_a (_tmp0_, G_TYPE_ENUM);
	_vala_return_val_if_fail (_tmp1_, "enumeration.is_a (Type.ENUM)", NULL);
	gxml_init_init ();
	_tmp2_ = enumeration;
	_tmp3_ = g_type_class_ref (_tmp2_);
	enumc = (GEnumClass*) _tmp3_;
	enumv = NULL;
	_tmp4_ = enumc;
	_tmp5_ = _tmp4_->values;
	_tmp5__length1 = _tmp4_->n_values;
	{
		GEnumValue* ev_collection = NULL;
		gint ev_collection_length1 = 0;
		gint _ev_collection_size_ = 0;
		gint ev_it = 0;
		ev_collection = _tmp5_;
		ev_collection_length1 = _tmp5__length1;
		for (ev_it = 0; ev_it < _tmp5__length1; ev_it = ev_it + 1) {
			GEnumValue ev = {0};
			ev = ev_collection[ev_it];
			{
				const gchar* _tmp6_ = NULL;
				GEnumValue _tmp7_ = {0};
				const gchar* _tmp8_ = NULL;
				const gchar* _tmp11_ = NULL;
				GEnumValue _tmp12_ = {0};
				const gchar* _tmp13_ = NULL;
				gchar* nick = NULL;
				GType _tmp16_ = 0UL;
				GEnumValue _tmp17_ = {0};
				gint _tmp18_ = 0;
				gchar* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				const gchar* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
				gchar* _tmp26_ = NULL;
				const gchar* _tmp27_ = NULL;
				gchar* _tmp28_ = NULL;
				gchar* _tmp29_ = NULL;
				gboolean _tmp30_ = FALSE;
				_tmp6_ = val;
				_tmp7_ = ev;
				_tmp8_ = _tmp7_.value_name;
				if (g_strcmp0 (_tmp6_, _tmp8_) == 0) {
					GEnumValue _tmp9_ = {0};
					GEnumValue* _tmp10_ = NULL;
					_tmp9_ = ev;
					_tmp10_ = __g_enum_value_dup0 (&_tmp9_);
					_g_free0 (enumv);
					enumv = _tmp10_;
				}
				_tmp11_ = val;
				_tmp12_ = ev;
				_tmp13_ = _tmp12_.value_nick;
				if (g_strcmp0 (_tmp11_, _tmp13_) == 0) {
					GEnumValue _tmp14_ = {0};
					GEnumValue* _tmp15_ = NULL;
					_tmp14_ = ev;
					_tmp15_ = __g_enum_value_dup0 (&_tmp14_);
					_g_free0 (enumv);
					enumv = _tmp15_;
				}
				_tmp16_ = enumeration;
				_tmp17_ = ev;
				_tmp18_ = _tmp17_.value;
				_tmp19_ = gxml_enumeration_get_nick_camelcase (_tmp16_, _tmp18_, &_inner_error_);
				nick = _tmp19_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (enumv);
					_g_type_class_unref0 (enumc);
					return NULL;
				}
				_tmp20_ = val;
				_tmp21_ = nick;
				if (g_strcmp0 (_tmp20_, _tmp21_) == 0) {
					GEnumValue _tmp22_ = {0};
					GEnumValue* _tmp23_ = NULL;
					_tmp22_ = ev;
					_tmp23_ = __g_enum_value_dup0 (&_tmp22_);
					_g_free0 (enumv);
					enumv = _tmp23_;
				}
				_tmp24_ = val;
				_tmp25_ = g_utf8_strdown (_tmp24_, (gssize) (-1));
				_tmp26_ = _tmp25_;
				_tmp27_ = nick;
				_tmp28_ = g_utf8_strdown (_tmp27_, (gssize) (-1));
				_tmp29_ = _tmp28_;
				_tmp30_ = g_strcmp0 (_tmp26_, _tmp29_) == 0;
				_g_free0 (_tmp29_);
				_g_free0 (_tmp26_);
				if (_tmp30_) {
					GEnumValue _tmp31_ = {0};
					GEnumValue* _tmp32_ = NULL;
					_tmp31_ = ev;
					_tmp32_ = __g_enum_value_dup0 (&_tmp31_);
					_g_free0 (enumv);
					enumv = _tmp32_;
				}
				_g_free0 (nick);
			}
		}
	}
	_tmp33_ = enumv;
	if (_tmp33_ == NULL) {
		const gchar* _tmp34_ = NULL;
		GType _tmp35_ = 0UL;
		const gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		GError* _tmp39_ = NULL;
		GError* _tmp40_ = NULL;
		_tmp34_ = _ ("text cannot be parsed to enumeration type:");
		_tmp35_ = enumeration;
		_tmp36_ = g_type_name (_tmp35_);
		_tmp37_ = g_strconcat (_tmp34_, _tmp36_, NULL);
		_tmp38_ = _tmp37_;
		_tmp39_ = g_error_new_literal (GXML_ENUMERATION_ERROR, GXML_ENUMERATION_ERROR_INVALID_TEXT, _tmp38_);
		_tmp40_ = _tmp39_;
		_g_free0 (_tmp38_);
		_inner_error_ = _tmp40_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (enumv);
		_g_type_class_unref0 (enumc);
		return NULL;
	}
	result = enumv;
	_g_type_class_unref0 (enumc);
	return result;
}


/**
 * Transform an enumeration in an array of {@link GLib.EnumValue}.
 * 
 * Returns: an array of {@link GLib.EnumValue} representing an enumeration.
 * 
 * @param enumeration a {@link GLib.Type} of type {@link GLib.Type.ENUM}
 */
GEnumValue* gxml_enumeration_to_array (GType enumeration, int* result_length1) {
	GEnumValue* result = NULL;
	GType _tmp0_ = 0UL;
	gboolean _tmp1_ = FALSE;
	GEnumClass* enumc = NULL;
	GType _tmp2_ = 0UL;
	GTypeClass* _tmp3_ = NULL;
	GEnumValue* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	GEnumValue* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	_tmp0_ = enumeration;
	_tmp1_ = g_type_is_a (_tmp0_, G_TYPE_ENUM);
	_vala_return_val_if_fail (_tmp1_, "enumeration.is_a (Type.ENUM)", NULL);
	gxml_init_init ();
	_tmp2_ = enumeration;
	_tmp3_ = g_type_class_ref (_tmp2_);
	enumc = (GEnumClass*) _tmp3_;
	_tmp4_ = enumc->values;
	_tmp4__length1 = enumc->n_values;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	_g_type_class_unref0 (enumc);
	return result;
}


/**
 * From a integer valuer calculates a valid {@link GLib.EnumValue} for a
 * {@link GLib.Type}. 
 *
 * Returns: a {@link GLib.EnumValue} or null if fails.
 *
 * @param enumeration a {@link GLib.Type} of type {@link GLib.Type.ENUM}
 * @param val an integer in a valid range in the enumeration.
 */
static GEnumValue* _vala_array_dup2 (GEnumValue* self, int length) {
	return g_memdup (self, length * sizeof (GEnumValue));
}


GEnumValue* gxml_enumeration_parse_integer (GType enumeration, gint val) {
	GEnumValue* result = NULL;
	GType _tmp0_ = 0UL;
	gboolean _tmp1_ = FALSE;
	GEnumValue* vals = NULL;
	GType _tmp2_ = 0UL;
	gint _tmp3_ = 0;
	GEnumValue* _tmp4_ = NULL;
	GEnumValue* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint vals_length1 = 0;
	gint _vals_size_ = 0;
	GEnumValue* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gxml_init_init ();
	_tmp0_ = enumeration;
	_tmp1_ = g_type_is_a (_tmp0_, G_TYPE_ENUM);
	if (!_tmp1_) {
		result = NULL;
		return result;
	}
	_tmp2_ = enumeration;
	_tmp4_ = gxml_enumeration_to_array (_tmp2_, &_tmp3_);
	_tmp5_ = (_tmp4_ != NULL) ? _vala_array_dup2 (_tmp4_, _tmp3_) : ((gpointer) _tmp4_);
	_tmp5__length1 = _tmp3_;
	vals = _tmp5_;
	vals_length1 = _tmp5__length1;
	_vals_size_ = vals_length1;
	_tmp6_ = vals;
	_tmp6__length1 = vals_length1;
	if (_tmp6_ == NULL) {
		result = NULL;
		vals = (g_free (vals), NULL);
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_ = 0;
				GEnumValue* _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				GEnumValue e = {0};
				GEnumValue* _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				gint _tmp12_ = 0;
				GEnumValue _tmp13_ = {0};
				GEnumValue _tmp14_ = {0};
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				if (!_tmp7_) {
					gint _tmp8_ = 0;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = i;
				_tmp10_ = vals;
				_tmp10__length1 = vals_length1;
				if (!(_tmp9_ < _tmp10__length1)) {
					break;
				}
				_tmp11_ = vals;
				_tmp11__length1 = vals_length1;
				_tmp12_ = i;
				_tmp13_ = _tmp11_[_tmp12_];
				e = _tmp13_;
				_tmp14_ = e;
				_tmp15_ = _tmp14_.value;
				_tmp16_ = val;
				if (_tmp15_ == _tmp16_) {
					GEnumValue* _tmp17_ = NULL;
					_tmp17_ = __g_enum_value_dup0 (&e);
					result = _tmp17_;
					vals = (g_free (vals), NULL);
					return result;
				}
			}
		}
	}
	result = NULL;
	vals = (g_free (vals), NULL);
	return result;
}


/**
 * Transform an enumeration in an array of strings representing enumeration values.
 *
 * Returns: an array of strings representing an enumeration.
 *
 * @param enumeration a {@link GLib.Type} of type {@link GLib.Type.ENUM}
 */
static GEnumValue* _vala_array_dup3 (GEnumValue* self, int length) {
	return g_memdup (self, length * sizeof (GEnumValue));
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gchar** gxml_enumeration_to_string_array (GType enumeration, int* result_length1, GError** error) {
	gchar** result = NULL;
	GType _tmp0_ = 0UL;
	gboolean _tmp1_ = FALSE;
	GEnumValue* vals = NULL;
	GType _tmp2_ = 0UL;
	gint _tmp3_ = 0;
	GEnumValue* _tmp4_ = NULL;
	GEnumValue* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint vals_length1 = 0;
	gint _vals_size_ = 0;
	gchar** s = NULL;
	gchar** _tmp6_ = NULL;
	gint s_length1 = 0;
	gint _s_size_ = 0;
	gchar** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	GError * _inner_error_ = NULL;
	_tmp0_ = enumeration;
	_tmp1_ = g_type_is_a (_tmp0_, G_TYPE_ENUM);
	_vala_return_val_if_fail (_tmp1_, "enumeration.is_a (Type.ENUM)", NULL);
	gxml_init_init ();
	_tmp2_ = enumeration;
	_tmp4_ = gxml_enumeration_to_array (_tmp2_, &_tmp3_);
	_tmp5_ = (_tmp4_ != NULL) ? _vala_array_dup3 (_tmp4_, _tmp3_) : ((gpointer) _tmp4_);
	_tmp5__length1 = _tmp3_;
	vals = _tmp5_;
	vals_length1 = _tmp5__length1;
	_vals_size_ = vals_length1;
	_tmp6_ = g_new0 (gchar*, 0 + 1);
	s = _tmp6_;
	s_length1 = 0;
	_s_size_ = s_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_ = 0;
				GEnumValue* _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				gchar* _tmp11_ = NULL;
				GType _tmp12_ = 0UL;
				GEnumValue* _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp14_ = 0;
				GEnumValue _tmp15_ = {0};
				gint _tmp16_ = 0;
				gchar* _tmp17_ = NULL;
				gchar** _tmp18_ = NULL;
				gint _tmp18__length1 = 0;
				gchar* _tmp19_ = NULL;
				if (!_tmp7_) {
					gint _tmp8_ = 0;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = i;
				_tmp10_ = vals;
				_tmp10__length1 = vals_length1;
				if (!(_tmp9_ < _tmp10__length1)) {
					break;
				}
				_tmp12_ = enumeration;
				_tmp13_ = vals;
				_tmp13__length1 = vals_length1;
				_tmp14_ = i;
				_tmp15_ = _tmp13_[_tmp14_];
				_tmp16_ = _tmp15_.value;
				_tmp17_ = gxml_enumeration_get_nick_camelcase (_tmp12_, _tmp16_, &_inner_error_);
				_tmp11_ = _tmp17_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					s = (_vala_array_free (s, s_length1, (GDestroyNotify) g_free), NULL);
					vals = (g_free (vals), NULL);
					return NULL;
				}
				_tmp18_ = s;
				_tmp18__length1 = s_length1;
				_tmp19_ = _tmp11_;
				_tmp11_ = NULL;
				_vala_array_add2 (&s, &s_length1, &_s_size_, _tmp19_);
				_g_free0 (_tmp11_);
			}
		}
	}
	_tmp20_ = s;
	_tmp20__length1 = s_length1;
	if (result_length1) {
		*result_length1 = _tmp20__length1;
	}
	result = _tmp20_;
	vals = (g_free (vals), NULL);
	return result;
}


GXmlEnumeration* gxml_enumeration_construct (GType object_type) {
	GXmlEnumeration* self = NULL;
	self = (GXmlEnumeration*) g_type_create_instance (object_type);
	return self;
}


GXmlEnumeration* gxml_enumeration_new (void) {
	return gxml_enumeration_construct (GXML_TYPE_ENUMERATION);
}


static void gxml_value_enumeration_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gxml_value_enumeration_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gxml_enumeration_unref (value->data[0].v_pointer);
	}
}


static void gxml_value_enumeration_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gxml_enumeration_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gxml_value_enumeration_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gxml_value_enumeration_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GXmlEnumeration* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gxml_enumeration_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gxml_value_enumeration_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GXmlEnumeration** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gxml_enumeration_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* gxml_param_spec_enumeration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GXmlParamSpecEnumeration* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GXML_TYPE_ENUMERATION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer gxml_value_get_enumeration (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GXML_TYPE_ENUMERATION), NULL);
	return value->data[0].v_pointer;
}


void gxml_value_set_enumeration (GValue* value, gpointer v_object) {
	GXmlEnumeration* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GXML_TYPE_ENUMERATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GXML_TYPE_ENUMERATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gxml_enumeration_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gxml_enumeration_unref (old);
	}
}


void gxml_value_take_enumeration (GValue* value, gpointer v_object) {
	GXmlEnumeration* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GXML_TYPE_ENUMERATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GXML_TYPE_ENUMERATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gxml_enumeration_unref (old);
	}
}


static void gxml_enumeration_class_init (GXmlEnumerationClass * klass) {
	gxml_enumeration_parent_class = g_type_class_peek_parent (klass);
	((GXmlEnumerationClass *) klass)->finalize = gxml_enumeration_finalize;
}


static void gxml_enumeration_instance_init (GXmlEnumeration * self) {
	self->ref_count = 1;
}


static void gxml_enumeration_finalize (GXmlEnumeration* obj) {
	GXmlEnumeration * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GXML_TYPE_ENUMERATION, GXmlEnumeration);
	g_signal_handlers_destroy (self);
}


/**
 * Convenient static methods for enumeration serialization to string.
 * 
 * Enumerations have a set of utility methods to better represent on
 * serialisation/deserialization.
 * 
 * Enumerations could be converted to string using its definition on {@link GLib.EnumClass},
 * by taking its nick name directly or converting to its camel case representation.
 * 
 * Any enumeration value type in a <code>GLib.Object</code>'s property could be
 * deserialized from its definition given on {@link GLib.EnumClass} (name and
 * nick) or from its camel case representation.
 */
GType gxml_enumeration_get_type (void) {
	static volatile gsize gxml_enumeration_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_enumeration_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gxml_value_enumeration_init, gxml_value_enumeration_free_value, gxml_value_enumeration_copy_value, gxml_value_enumeration_peek_pointer, "p", gxml_value_enumeration_collect_value, "p", gxml_value_enumeration_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GXmlEnumerationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gxml_enumeration_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GXmlEnumeration), 0, (GInstanceInitFunc) gxml_enumeration_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gxml_enumeration_type_id;
		gxml_enumeration_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GXmlEnumeration", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gxml_enumeration_type_id__volatile, gxml_enumeration_type_id);
	}
	return gxml_enumeration_type_id__volatile;
}


gpointer gxml_enumeration_ref (gpointer instance) {
	GXmlEnumeration* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void gxml_enumeration_unref (gpointer instance) {
	GXmlEnumeration* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GXML_ENUMERATION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


GQuark gxml_enumeration_error_quark (void) {
	return g_quark_from_static_string ("gxml_enumeration_error-quark");
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



