/* Serializable.c generated by valac 0.28.1, the Vala compiler
 * generated from Serializable.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */
/* Serializable.vala
 *
 * Copyright (C) 2013-2015  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>


#define GXML_TYPE_SERIALIZABLE (gxml_serializable_get_type ())
#define GXML_SERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE, GXmlSerializable))
#define GXML_IS_SERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE))
#define GXML_SERIALIZABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_SERIALIZABLE, GXmlSerializableIface))

typedef struct _GXmlSerializable GXmlSerializable;
typedef struct _GXmlSerializableIface GXmlSerializableIface;

#define GXML_TYPE_NODE (gxml_node_get_type ())
#define GXML_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NODE, GXmlNode))
#define GXML_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NODE))
#define GXML_NODE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NODE, GXmlNodeIface))

typedef struct _GXmlNode GXmlNode;
typedef struct _GXmlNodeIface GXmlNodeIface;

#define GXML_TYPE_ELEMENT_LIST (gxml_element_list_get_type ())
#define GXML_ELEMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ELEMENT_LIST, GXmlElementList))
#define GXML_ELEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_ELEMENT_LIST, GXmlElementListClass))
#define GXML_IS_ELEMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ELEMENT_LIST))
#define GXML_IS_ELEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_ELEMENT_LIST))
#define GXML_ELEMENT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_ELEMENT_LIST, GXmlElementListClass))

typedef struct _GXmlElementList GXmlElementList;
typedef struct _GXmlElementListClass GXmlElementListClass;

#define GXML_TYPE_NAMESPACE (gxml_namespace_get_type ())
#define GXML_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NAMESPACE, GXmlNamespace))
#define GXML_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NAMESPACE))
#define GXML_NAMESPACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NAMESPACE, GXmlNamespaceIface))

typedef struct _GXmlNamespace GXmlNamespace;
typedef struct _GXmlNamespaceIface GXmlNamespaceIface;

#define GXML_TYPE_NODE_TYPE (gxml_node_type_get_type ())

#define GXML_TYPE_DOCUMENT (gxml_document_get_type ())
#define GXML_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOCUMENT, GXmlDocument))
#define GXML_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOCUMENT))
#define GXML_DOCUMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOCUMENT, GXmlDocumentIface))

typedef struct _GXmlDocument GXmlDocument;
typedef struct _GXmlDocumentIface GXmlDocumentIface;

#define GXML_TYPE_ATTRIBUTE (gxml_attribute_get_type ())
#define GXML_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ATTRIBUTE, GXmlAttribute))
#define GXML_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ATTRIBUTE))
#define GXML_ATTRIBUTE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_ATTRIBUTE, GXmlAttributeIface))

typedef struct _GXmlAttribute GXmlAttribute;
typedef struct _GXmlAttributeIface GXmlAttributeIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_param_spec_unref0(var) ((var == NULL) ? NULL : (var = (g_param_spec_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _GXmlNamespaceIface {
	GTypeInterface parent_iface;
	gchar* (*get_uri) (GXmlNamespace* self);
	gchar* (*get_prefix) (GXmlNamespace* self);
};

typedef enum  {
	GXML_NODE_TYPE_X_UNKNOWN = 0,
	GXML_NODE_TYPE_ELEMENT = 1,
	GXML_NODE_TYPE_ATTRIBUTE,
	GXML_NODE_TYPE_TEXT,
	GXML_NODE_TYPE_CDATA_SECTION,
	GXML_NODE_TYPE_ENTITY_REFERENCE,
	GXML_NODE_TYPE_ENTITY,
	GXML_NODE_TYPE_PROCESSING_INSTRUCTION,
	GXML_NODE_TYPE_COMMENT,
	GXML_NODE_TYPE_DOCUMENT,
	GXML_NODE_TYPE_DOCUMENT_TYPE,
	GXML_NODE_TYPE_DOCUMENT_FRAGMENT,
	GXML_NODE_TYPE_NOTATION
} GXmlNodeType;

struct _GXmlDocumentIface {
	GTypeInterface parent_iface;
	GXmlNode* (*create_element) (GXmlDocument* self, const gchar* name, GError** error);
	GXmlNode* (*create_text) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_comment) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_cdata) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_pi) (GXmlDocument* self, const gchar* target, const gchar* data);
	gboolean (*save) (GXmlDocument* self, GCancellable* cancellable, GError** error);
	gboolean (*save_as) (GXmlDocument* self, GFile* f, GCancellable* cancellable, GError** error);
	gboolean (*get_indent) (GXmlDocument* self);
	void (*set_indent) (GXmlDocument* self, gboolean value);
	gboolean (*get_ns_top) (GXmlDocument* self);
	void (*set_ns_top) (GXmlDocument* self, gboolean value);
	gboolean (*get_prefix_default_ns) (GXmlDocument* self);
	void (*set_prefix_default_ns) (GXmlDocument* self, gboolean value);
	gboolean (*get_backup) (GXmlDocument* self);
	void (*set_backup) (GXmlDocument* self, gboolean value);
	GXmlNode* (*get_root) (GXmlDocument* self);
	GFile* (*get_file) (GXmlDocument* self);
	void (*set_file) (GXmlDocument* self, GFile* value);
};

struct _GXmlNodeIface {
	GTypeInterface parent_iface;
	GXmlNode* (*get) (GXmlNode* self, const gchar* key);
	GXmlElementList* (*get_elements_by_property_value) (GXmlNode* self, const gchar* property, const gchar* value);
	gchar* (*to_string) (GXmlNode* self);
	gboolean (*set_namespace) (GXmlNode* self, const gchar* uri, const gchar* prefix);
	gchar* (*ns_prefix) (GXmlNode* self);
	gchar* (*ns_uri) (GXmlNode* self);
	GeeList* (*get_namespaces) (GXmlNode* self);
	GeeBidirList* (*get_childs) (GXmlNode* self);
	GeeBidirList* (*get_children) (GXmlNode* self);
	GeeMap* (*get_attrs) (GXmlNode* self);
	gchar* (*get_name) (GXmlNode* self);
	gchar* (*get_value) (GXmlNode* self);
	void (*set_value) (GXmlNode* self, const gchar* value);
	GXmlNodeType (*get_type_node) (GXmlNode* self);
	GXmlDocument* (*get_document) (GXmlNode* self);
	GXmlNode* (*get_parent) (GXmlNode* self);
};

struct _GXmlAttributeIface {
	GTypeInterface parent_iface;
	GXmlNamespace* (*get_namespace) (GXmlAttribute* self);
	void (*set_namespace) (GXmlAttribute* self, GXmlNamespace* value);
	gchar* (*get_prefix) (GXmlAttribute* self);
};

struct _GXmlSerializableIface {
	GTypeInterface parent_iface;
	gboolean (*get_enable_unknown_serializable_property) (GXmlSerializable* self);
	gboolean (*set_default_namespace) (GXmlSerializable* self, GXmlNode* node);
	gboolean (*serialize_use_xml_node_value) (GXmlSerializable* self);
	gchar* (*node_name) (GXmlSerializable* self);
	gboolean (*property_use_nick) (GXmlSerializable* self);
	GXmlNode* (*serialize) (GXmlSerializable* self, GXmlNode* node, GError** error);
	GXmlNode* (*serialize_property) (GXmlSerializable* self, GXmlNode* element, GParamSpec* prop, GError** error);
	gboolean (*deserialize) (GXmlSerializable* self, GXmlNode* node, GError** error);
	gboolean (*deserialize_property) (GXmlSerializable* self, GXmlNode* property_node, GError** error);
	GParamSpec* (*find_property_spec) (GXmlSerializable* self, const gchar* property_name);
	GParamSpec* (*default_find_property_spec) (GXmlSerializable* self, const gchar* property_name);
	GParamSpec** (*list_serializable_properties) (GXmlSerializable* self, int* result_length1);
	GParamSpec** (*default_list_serializable_properties) (GXmlSerializable* self, int* result_length1);
	GeeMap* (*get_unknown_serializable_properties) (GXmlSerializable* self);
	GeeCollection* (*get_unknown_serializable_nodes) (GXmlSerializable* self);
	gchar* (*get_serialized_xml_node_value) (GXmlSerializable* self);
	void (*set_serialized_xml_node_value) (GXmlSerializable* self, const gchar* value);
};

typedef enum  {
	GXML_SERIALIZABLE_ERROR_UNSUPPORTED_TYPE_ERROR,
	GXML_SERIALIZABLE_ERROR_STR_TO_VALUE_ERROR
} GXmlSerializableError;
#define GXML_SERIALIZABLE_ERROR gxml_serializable_error_quark ()
/**
   * Errors from {@link Serializable}.
   */


GType gxml_element_list_get_type (void) G_GNUC_CONST;
GType gxml_namespace_get_type (void) G_GNUC_CONST;
GType gxml_node_type_get_type (void) G_GNUC_CONST;
GType gxml_document_get_type (void) G_GNUC_CONST;
GType gxml_node_get_type (void) G_GNUC_CONST;
GType gxml_attribute_get_type (void) G_GNUC_CONST;
GType gxml_serializable_get_type (void) G_GNUC_CONST;
gboolean gxml_serializable_get_enable_unknown_serializable_property (GXmlSerializable* self);
gboolean gxml_serializable_set_default_namespace (GXmlSerializable* self, GXmlNode* node);
gboolean gxml_serializable_serialize_use_xml_node_value (GXmlSerializable* self);
gchar* gxml_serializable_node_name (GXmlSerializable* self);
gboolean gxml_serializable_property_use_nick (GXmlSerializable* self);
GXmlNode* gxml_serializable_serialize (GXmlSerializable* self, GXmlNode* node, GError** error);
GXmlNode* gxml_serializable_serialize_property (GXmlSerializable* self, GXmlNode* element, GParamSpec* prop, GError** error);
gboolean gxml_serializable_deserialize (GXmlSerializable* self, GXmlNode* node, GError** error);
gboolean gxml_serializable_deserialize_property (GXmlSerializable* self, GXmlNode* property_node, GError** error);
GParamSpec* gxml_serializable_find_property_spec (GXmlSerializable* self, const gchar* property_name);
GParamSpec* gxml_serializable_default_find_property_spec (GXmlSerializable* self, const gchar* property_name);
static GParamSpec* gxml_serializable_real_default_find_property_spec (GXmlSerializable* self, const gchar* property_name);
GParamSpec** gxml_serializable_list_serializable_properties (GXmlSerializable* self, int* result_length1);
GParamSpec** gxml_serializable_default_list_serializable_properties (GXmlSerializable* self, int* result_length1);
static GParamSpec** gxml_serializable_real_default_list_serializable_properties (GXmlSerializable* self, int* result_length1);
static void _g_free0_ (gpointer var);
static void _g_param_spec_unref0_ (gpointer var);
static void _vala_array_add1 (GParamSpec*** array, int* length, int* size, GParamSpec* value);
GQuark gxml_serializable_error_quark (void);
gboolean gxml_serializable_string_to_gvalue (const gchar* str, GValue* dest, GError** error);
gchar* gxml_serializable_gvalue_to_string (GValue* val, GError** error);
GeeMap* gxml_serializable_get_unknown_serializable_properties (GXmlSerializable* self);
GeeCollection* gxml_serializable_get_unknown_serializable_nodes (GXmlSerializable* self);
gchar* gxml_serializable_get_serialized_xml_node_value (GXmlSerializable* self);
void gxml_serializable_set_serialized_xml_node_value (GXmlSerializable* self, const gchar* value);
static void g_cclosure_user_marshal_VOID__OBJECT_G_PARAM_SPEC_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_G_PARAM_SPEC (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
    * Return false if you want to ignore unknown properties and {@link GXml.Node}'s
    * not in your class definition.
    *
    * Take care, disabling this feature you can lost data on serialization, because any unknown
    * property or element will be discarted.
    */
gboolean gxml_serializable_get_enable_unknown_serializable_property (GXmlSerializable* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->get_enable_unknown_serializable_property (self);
}


/**
     * Used to set specific namespace for an {@link GXml.Element}.
     *
     * By default no namspace prefix is added to {@link GXml.Element} on serialized. Implementors
     * must consider override this methodk if this node should have a namespace.
     */
gboolean gxml_serializable_set_default_namespace (GXmlSerializable* self, GXmlNode* node) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->set_default_namespace (self, node);
}


/**
      * Used to check {@link GXml.Element}'s contents must be deseralized.
      *
      * By default GXml's implementations doesn't deseriaze/serialize XML node contents.
      * In order to enable it, you must override {@link serialize_use_xml_node_value}
      * method to return true and store XML node's content to {@link serialized_xml_node_value}
      * property.
      *
      * Implementors could set up methods to provide a clean easy to use API to set
      * nodes contents. In most cases, users would like to set a value through a getter
      * or setter or through a property in the class. If you use a property, you should
      * add it to {@link ignored_serializable_properties} in order to see its value
      * in a XML node property.
      *
     */
gboolean gxml_serializable_serialize_use_xml_node_value (GXmlSerializable* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->serialize_use_xml_node_value (self);
}


/**
      * Defines the way to set Node name.
      */
gchar* gxml_serializable_node_name (GXmlSerializable* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->node_name (self);
}


/**
      * Defines the way to set Node's property name, by using
      * it's nick instead of default name.
      *
      * When serialize a class property, by default it uses its name given  on class
      * declaration, but is less common to see XML node properties with names like
      * "your_property", but more common is to use "YourProperty". In order
      * to use this kind of names, your implementation should use properties' nick
      * name and override {@link property_use_nick} method to return true. This should
      * instruct your code to use this method to use property's nick name. This is
      * the default in GXml default implementations.
      */
gboolean gxml_serializable_property_use_nick (GXmlSerializable* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->property_use_nick (self);
}


/**
     * Serialize this object.
     *
     * This method must call serialize_property() recursivally on all properties
     * to serialize.
     *
     * @param node an {@link GXml.Node} object to serialize to.
     */
GXmlNode* gxml_serializable_serialize (GXmlSerializable* self, GXmlNode* node, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->serialize (self, node, error);
}


/**
     * Serialize a property @prop on a {@link GXml.Element}.
     *
     * This method is called recursivally by {@link serialize} method over all properties
     * to be serialized.
     */
GXmlNode* gxml_serializable_serialize_property (GXmlSerializable* self, GXmlNode* element, GParamSpec* prop, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->serialize_property (self, element, prop, error);
}


/**
     * Deserialize this object.
     *
     * @param node {@link GXml.Node} used to deserialize from.
     */
gboolean gxml_serializable_deserialize (GXmlSerializable* self, GXmlNode* node, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->deserialize (self, node, error);
}


/**
     * Handles deserializing individual properties.
     *
     * Interface method to handle deserialization of an
     * individual property.  The implementing class
     * receives a description of the property and the
     * {@link GXml.Node} that contains the content.  The
     * implementing {@link GXml.Serializable} object can extract
     * the data from the {@link GXml.Node} and store it in its
     * property itself. Note that the {@link GXml.Node} may be
     * as simple as a {@link GXml.Text} that stores the data as a
     * string.
     *
     * Implementors:
     * Use Serializable.get_property_value in order to allow derived classes to
     * override the properties to serialize.
     *
     * @param property_node the {@link GXml.Node} encapsulating data to deserialize
     * @return `true` if the property was handled, `false` if {@link GXml.Serialization} should handle it.
     */
gboolean gxml_serializable_deserialize_property (GXmlSerializable* self, GXmlNode* property_node, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->deserialize_property (self, property_node, error);
}


/**
     * Handles finding the {@link GLib.ParamSpec} for a given property.
     *
     * {@link GXml.Serialization} uses {@link GLib.ObjectClass.find_property}
     * (as well as {@link GLib.ObjectClass.list_properties},
     * {@link GLib.Object.get_property}, and
     * {@link GLib.Object.set_property}) to manage serialization
     * of properties.  {@link GXml.Serializable} gives the
     * implementing class an opportunity to override
     * {@link GLib.ObjectClass.find_property} to control
     * what properties exist for {@link GXml.Serialization}'s
     * purposes.
     *
     * For instance, if an object has private data fields
     * that are not installed public properties, but that
     * should be serialized, {@link GLib.ObjectClass.find_property} can be defined
     * to return a {@link GLib.ParamSpec} for non-installed
     * properties.  Other {@link GXml.Serializable} functions
     * should be consistent with it.
     *
     * An implementing class might wish to maintain such
     * {@link GLib.ParamSpec} s separately, rather than creating new
     * ones for each call.
     *
     * @param property_name the name of a property to obtain a {@link GLib.ParamSpec} for
     * @return a {@link GLib.ParamSpec} describing the named property
     */
GParamSpec* gxml_serializable_find_property_spec (GXmlSerializable* self, const gchar* property_name) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->find_property_spec (self, property_name);
}


/**
     * Default implementation for {@link Serializable.find_property_spec}
     *
     */
static gpointer _g_param_spec_ref0 (gpointer self) {
	return self ? g_param_spec_ref (self) : NULL;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static GParamSpec* gxml_serializable_real_default_find_property_spec (GXmlSerializable* self, const gchar* property_name) {
	GParamSpec* result = NULL;
	GParamSpec** props = NULL;
	gint _tmp0_ = 0;
	GParamSpec** _tmp1_ = NULL;
	gint props_length1 = 0;
	gint _props_size_ = 0;
	GParamSpec** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	g_return_val_if_fail (property_name != NULL, NULL);
	_tmp1_ = gxml_serializable_list_serializable_properties (self, &_tmp0_);
	props = _tmp1_;
	props_length1 = _tmp0_;
	_props_size_ = props_length1;
	_tmp2_ = props;
	_tmp2__length1 = props_length1;
	{
		GParamSpec** spec_collection = NULL;
		gint spec_collection_length1 = 0;
		gint _spec_collection_size_ = 0;
		gint spec_it = 0;
		spec_collection = _tmp2_;
		spec_collection_length1 = _tmp2__length1;
		for (spec_it = 0; spec_it < _tmp2__length1; spec_it = spec_it + 1) {
			GParamSpec* _tmp3_ = NULL;
			GParamSpec* spec = NULL;
			_tmp3_ = _g_param_spec_ref0 (spec_collection[spec_it]);
			spec = _tmp3_;
			{
				GParamSpec* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_ = NULL;
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				GParamSpec* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				gboolean _tmp23_ = FALSE;
				_tmp4_ = spec;
				_tmp5_ = _tmp4_->name;
				_tmp6_ = g_utf8_strdown (_tmp5_, (gssize) (-1));
				_tmp7_ = _tmp6_;
				_tmp8_ = property_name;
				_tmp9_ = g_utf8_strdown (_tmp8_, (gssize) (-1));
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strcmp0 (_tmp7_, _tmp10_) == 0;
				_g_free0 (_tmp10_);
				_g_free0 (_tmp7_);
				if (_tmp11_) {
					result = spec;
					props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_param_spec_unref), NULL);
					return result;
				}
				_tmp12_ = gxml_serializable_property_use_nick (self);
				if (_tmp12_) {
					GParamSpec* _tmp13_ = NULL;
					const gchar* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
					gchar* _tmp16_ = NULL;
					const gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					gboolean _tmp20_ = FALSE;
					_tmp13_ = spec;
					_tmp14_ = g_param_spec_get_nick (_tmp13_);
					_tmp15_ = g_utf8_strdown (_tmp14_, (gssize) (-1));
					_tmp16_ = _tmp15_;
					_tmp17_ = property_name;
					_tmp18_ = g_utf8_strdown (_tmp17_, (gssize) (-1));
					_tmp19_ = _tmp18_;
					_tmp20_ = g_strcmp0 (_tmp16_, _tmp19_) == 0;
					_g_free0 (_tmp19_);
					_g_free0 (_tmp16_);
					if (_tmp20_) {
						result = spec;
						props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_param_spec_unref), NULL);
						return result;
					}
				}
				_tmp21_ = spec;
				_tmp22_ = _tmp21_->name;
				_tmp23_ = string_contains (_tmp22_, "-");
				if (_tmp23_) {
					gchar** sp = NULL;
					GParamSpec* _tmp24_ = NULL;
					const gchar* _tmp25_ = NULL;
					gchar** _tmp26_ = NULL;
					gchar** _tmp27_ = NULL;
					gint sp_length1 = 0;
					gint _sp_size_ = 0;
					gchar* n = NULL;
					gchar* _tmp28_ = NULL;
					gchar** _tmp29_ = NULL;
					gint _tmp29__length1 = 0;
					const gchar* _tmp48_ = NULL;
					gchar* _tmp49_ = NULL;
					gchar* _tmp50_ = NULL;
					const gchar* _tmp51_ = NULL;
					gchar* _tmp52_ = NULL;
					gchar* _tmp53_ = NULL;
					gboolean _tmp54_ = FALSE;
					_tmp24_ = spec;
					_tmp25_ = _tmp24_->name;
					_tmp27_ = _tmp26_ = g_strsplit (_tmp25_, "-", 0);
					sp = _tmp27_;
					sp_length1 = _vala_array_length (_tmp26_);
					_sp_size_ = sp_length1;
					_tmp28_ = g_strdup ("");
					n = _tmp28_;
					_tmp29_ = sp;
					_tmp29__length1 = sp_length1;
					{
						gchar** s_collection = NULL;
						gint s_collection_length1 = 0;
						gint _s_collection_size_ = 0;
						gint s_it = 0;
						s_collection = _tmp29_;
						s_collection_length1 = _tmp29__length1;
						for (s_it = 0; s_it < _tmp29__length1; s_it = s_it + 1) {
							gchar* _tmp30_ = NULL;
							gchar* s = NULL;
							_tmp30_ = g_strdup (s_collection[s_it]);
							s = _tmp30_;
							{
								const gchar* _tmp31_ = NULL;
								const gchar* _tmp32_ = NULL;
								gchar _tmp33_ = '\0';
								gchar* _tmp34_ = NULL;
								gchar* _tmp35_ = NULL;
								gchar* _tmp36_ = NULL;
								gchar* _tmp37_ = NULL;
								const gchar* _tmp38_ = NULL;
								const gchar* _tmp39_ = NULL;
								gint _tmp40_ = 0;
								gint _tmp41_ = 0;
								gchar* _tmp42_ = NULL;
								gchar* _tmp43_ = NULL;
								const gchar* _tmp44_ = NULL;
								gchar* _tmp45_ = NULL;
								gchar* _tmp46_ = NULL;
								gchar* _tmp47_ = NULL;
								_tmp31_ = n;
								_tmp32_ = s;
								_tmp33_ = string_get (_tmp32_, (glong) 0);
								_tmp34_ = g_strdup_printf ("%c", _tmp33_);
								_tmp35_ = _tmp34_;
								_tmp36_ = g_utf8_strup (_tmp35_, (gssize) (-1));
								_tmp37_ = _tmp36_;
								_tmp38_ = s;
								_tmp39_ = s;
								_tmp40_ = strlen (_tmp39_);
								_tmp41_ = _tmp40_;
								_tmp42_ = string_slice (_tmp38_, (glong) 1, (glong) _tmp41_);
								_tmp43_ = _tmp42_;
								_tmp44_ = string_to_string (_tmp43_);
								_tmp45_ = g_strconcat (_tmp37_, _tmp44_, NULL);
								_tmp46_ = _tmp45_;
								_tmp47_ = g_strconcat (_tmp31_, _tmp46_, NULL);
								_g_free0 (n);
								n = _tmp47_;
								_g_free0 (_tmp46_);
								_g_free0 (_tmp43_);
								_g_free0 (_tmp37_);
								_g_free0 (_tmp35_);
								_g_free0 (s);
							}
						}
					}
					_tmp48_ = n;
					_tmp49_ = g_utf8_strdown (_tmp48_, (gssize) (-1));
					_tmp50_ = _tmp49_;
					_tmp51_ = property_name;
					_tmp52_ = g_utf8_strdown (_tmp51_, (gssize) (-1));
					_tmp53_ = _tmp52_;
					_tmp54_ = g_strcmp0 (_tmp50_, _tmp53_) == 0;
					_g_free0 (_tmp53_);
					_g_free0 (_tmp50_);
					if (_tmp54_) {
						result = spec;
						_g_free0 (n);
						sp = (_vala_array_free (sp, sp_length1, (GDestroyNotify) g_free), NULL);
						props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_param_spec_unref), NULL);
						return result;
					}
					_g_free0 (n);
					sp = (_vala_array_free (sp, sp_length1, (GDestroyNotify) g_free), NULL);
				}
				_g_param_spec_unref0 (spec);
			}
		}
	}
	result = NULL;
	props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	return result;
}


GParamSpec* gxml_serializable_default_find_property_spec (GXmlSerializable* self, const gchar* property_name) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->default_find_property_spec (self, property_name);
}


/**
     * List the known properties for an object's class
     *
     * Class {@link GXml.Serialization} uses
     * {@link GLib.ObjectClass.list_properties} (as well as
     * {@link GLib.ObjectClass.find_property},
     * {@link GLib.Object.get_property}, and {@link GLib.Object.set_property})
     * to manage serialization of an object's properties.
     * {@link GXml.Serializable} gives an implementing class an
     * opportunity to override
     * {@link GLib.ObjectClass.list_properties} to control which
     * properties exist for {@link GXml.Serialization}'s purposes.
     *
     * For instance, if an object has private data fields
     * that are not installed public properties, but that
     * should be serialized, list_properties can be
     * defined to return a list of {@link GLib.ParamSpec} s covering
     * all the "properties" to serialize.  Other
     * {@link GXml.Serializable} functions should be consistent
     * with it.
     *
     * An implementing class might wish to maintain such
     * {@link GLib.ParamSpec} s separately, rather than creating new
     * ones for each call.
     *
     * @return an array of {@link GLib.ParamSpec} of "properties" for the object.
     */
GParamSpec** gxml_serializable_list_serializable_properties (GXmlSerializable* self, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->list_serializable_properties (self, result_length1);
}


/**
     * Default implementation for {@link Serializable.list_serializable_properties}
     *
     */
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_param_spec_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_param_spec_unref (var), NULL));
}


static void _vala_array_add1 (GParamSpec*** array, int* length, int* size, GParamSpec* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GParamSpec*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static GParamSpec** gxml_serializable_real_default_list_serializable_properties (GXmlSerializable* self, int* result_length1) {
	GParamSpec** result = NULL;
	GParamSpec** props = NULL;
	GParamSpec** _tmp0_ = NULL;
	gint props_length1 = 0;
	gint _props_size_ = 0;
	GHashTable* l = NULL;
	GHashFunc _tmp1_ = NULL;
	GEqualFunc _tmp2_ = NULL;
	GHashTable* _tmp3_ = NULL;
	GHashTable* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GObjectClass* _tmp6_ = NULL;
	GParamSpec* _tmp7_ = NULL;
	GParamSpec* _tmp8_ = NULL;
	GHashTable* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GObjectClass* _tmp11_ = NULL;
	GParamSpec* _tmp12_ = NULL;
	GParamSpec* _tmp13_ = NULL;
	GHashTable* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	GObjectClass* _tmp16_ = NULL;
	GParamSpec* _tmp17_ = NULL;
	GParamSpec* _tmp18_ = NULL;
	GHashTable* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	GObjectClass* _tmp21_ = NULL;
	GParamSpec* _tmp22_ = NULL;
	GParamSpec* _tmp23_ = NULL;
	GObjectClass* _tmp24_ = NULL;
	guint _tmp25_;
	GParamSpec** _tmp26_ = NULL;
	GParamSpec** _tmp35_ = NULL;
	gint _tmp35__length1 = 0;
	_tmp0_ = g_new0 (GParamSpec*, 0 + 1);
	props = _tmp0_;
	props_length1 = 0;
	_props_size_ = props_length1;
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_param_spec_unref0_);
	l = _tmp3_;
	_tmp4_ = l;
	_tmp5_ = g_strdup ("ignored-serializable-properties");
	_tmp6_ = G_OBJECT_GET_CLASS ((GObject*) self);
	_tmp7_ = g_object_class_find_property (_tmp6_, "ignored-serializable-properties");
	_tmp8_ = _g_param_spec_ref0 (_tmp7_);
	g_hash_table_insert (_tmp4_, _tmp5_, _tmp8_);
	_tmp9_ = l;
	_tmp10_ = g_strdup ("unknown-serializable-properties");
	_tmp11_ = G_OBJECT_GET_CLASS ((GObject*) self);
	_tmp12_ = g_object_class_find_property (_tmp11_, "unknown-serializable-properties");
	_tmp13_ = _g_param_spec_ref0 (_tmp12_);
	g_hash_table_insert (_tmp9_, _tmp10_, _tmp13_);
	_tmp14_ = l;
	_tmp15_ = g_strdup ("unknown-serializable-nodes");
	_tmp16_ = G_OBJECT_GET_CLASS ((GObject*) self);
	_tmp17_ = g_object_class_find_property (_tmp16_, "unknown-serializable-nodes");
	_tmp18_ = _g_param_spec_ref0 (_tmp17_);
	g_hash_table_insert (_tmp14_, _tmp15_, _tmp18_);
	_tmp19_ = l;
	_tmp20_ = g_strdup ("serialized-xml-node-value");
	_tmp21_ = G_OBJECT_GET_CLASS ((GObject*) self);
	_tmp22_ = g_object_class_find_property (_tmp21_, "serialized-xml-node-value");
	_tmp23_ = _g_param_spec_ref0 (_tmp22_);
	g_hash_table_insert (_tmp19_, _tmp20_, _tmp23_);
	_tmp24_ = G_OBJECT_GET_CLASS ((GObject*) self);
	_tmp26_ = g_object_class_list_properties (_tmp24_, &_tmp25_);
	{
		GParamSpec** spec_collection = NULL;
		gint spec_collection_length1 = 0;
		gint _spec_collection_size_ = 0;
		gint spec_it = 0;
		spec_collection = _tmp26_;
		spec_collection_length1 = _tmp25_;
		for (spec_it = 0; spec_it < _tmp25_; spec_it = spec_it + 1) {
			GParamSpec* _tmp27_ = NULL;
			GParamSpec* spec = NULL;
			_tmp27_ = _g_param_spec_ref0 (spec_collection[spec_it]);
			spec = _tmp27_;
			{
				GHashTable* _tmp28_ = NULL;
				GParamSpec* _tmp29_ = NULL;
				const gchar* _tmp30_ = NULL;
				gboolean _tmp31_ = FALSE;
				_tmp28_ = l;
				_tmp29_ = spec;
				_tmp30_ = _tmp29_->name;
				_tmp31_ = g_hash_table_contains (_tmp28_, _tmp30_);
				if (!_tmp31_) {
					GParamSpec** _tmp32_ = NULL;
					gint _tmp32__length1 = 0;
					GParamSpec* _tmp33_ = NULL;
					GParamSpec* _tmp34_ = NULL;
					_tmp32_ = props;
					_tmp32__length1 = props_length1;
					_tmp33_ = spec;
					_tmp34_ = _g_param_spec_ref0 (_tmp33_);
					_vala_array_add1 (&props, &props_length1, &_props_size_, _tmp34_);
				}
				_g_param_spec_unref0 (spec);
			}
		}
	}
	_tmp35_ = props;
	_tmp35__length1 = props_length1;
	if (result_length1) {
		*result_length1 = _tmp35__length1;
	}
	result = _tmp35_;
	_g_hash_table_unref0 (l);
	return result;
}


GParamSpec** gxml_serializable_default_list_serializable_properties (GXmlSerializable* self, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->default_list_serializable_properties (self, result_length1);
}


/**
      * Transforms a string into another type hosted by {@link GLib.Value}.
      *
      * A utility function that handles converting a string
      * representation of a value into the type specified by the
      * supplied #GValue dest.  A #GXmlSerializableError will be
      * set if the string cannot be parsed into the desired type.
      * 
      * {@link Serializable} interface support a number of data types to convert
      * from its string representation. These are supported types:
      * 
      * a. integers: int8, int64, uint, long, ulong, char, uchar
      * a. boolean
      * a. floats: float, double
      * a. enumerations
      *
      * @param str the string to transform into the given #GValue object
      * @param dest the #GValue out parameter that will contain the parsed value from the string
      * @return `true` if parsing succeeded, otherwise `false`
      */
static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}


static gboolean bool_try_parse (const gchar* str, gboolean* _result_) {
	gboolean _vala_result = FALSE;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	if (g_strcmp0 (_tmp0_, "true") == 0) {
		_vala_result = TRUE;
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	} else {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = str;
		if (g_strcmp0 (_tmp1_, "false") == 0) {
			_vala_result = FALSE;
			result = TRUE;
			if (_result_) {
				*_result_ = _vala_result;
			}
			return result;
		} else {
			_vala_result = FALSE;
			result = FALSE;
			if (_result_) {
				*_result_ = _vala_result;
			}
			return result;
		}
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
}


gboolean gxml_serializable_string_to_gvalue (const gchar* str, GValue* dest, GError** error) {
	gboolean result = FALSE;
	GType t = 0UL;
	GType _tmp0_ = 0UL;
	GValue dest2 = {0};
	GType _tmp1_ = 0UL;
	GValue _tmp2_ = {0};
	gboolean ret = FALSE;
	gboolean _tmp3_ = FALSE;
	GType _tmp4_ = 0UL;
	gboolean _tmp62_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (str != NULL, FALSE);
	g_return_val_if_fail (dest != NULL, FALSE);
	_tmp0_ = G_VALUE_TYPE (dest);
	t = _tmp0_;
	_tmp1_ = t;
	g_value_init (&_tmp2_, _tmp1_);
	dest2 = _tmp2_;
	ret = FALSE;
	_tmp4_ = t;
	if (_tmp4_ == G_TYPE_INT64) {
		_tmp3_ = TRUE;
	} else {
		GType _tmp5_ = 0UL;
		_tmp5_ = t;
		_tmp3_ = _tmp5_ == G_TYPE_UINT64;
	}
	if (_tmp3_) {
		gint64 val = 0LL;
		const gchar* _tmp6_ = NULL;
		gdouble _tmp7_ = 0.0;
		gint64 _tmp8_ = 0LL;
		_tmp6_ = str;
		_tmp7_ = double_parse (_tmp6_);
		val = (gint64) _tmp7_;
		_tmp8_ = val;
		g_value_set_int64 (&dest2, _tmp8_);
		ret = TRUE;
	} else {
		GType _tmp9_ = 0UL;
		_tmp9_ = t;
		if (_tmp9_ == G_TYPE_INT) {
			gint val = 0;
			const gchar* _tmp10_ = NULL;
			gdouble _tmp11_ = 0.0;
			gint _tmp12_ = 0;
			_tmp10_ = str;
			_tmp11_ = double_parse (_tmp10_);
			val = (gint) _tmp11_;
			_tmp12_ = val;
			g_value_set_int (&dest2, _tmp12_);
			ret = TRUE;
		} else {
			GType _tmp13_ = 0UL;
			_tmp13_ = t;
			if (_tmp13_ == G_TYPE_LONG) {
				glong val = 0L;
				const gchar* _tmp14_ = NULL;
				gdouble _tmp15_ = 0.0;
				glong _tmp16_ = 0L;
				_tmp14_ = str;
				_tmp15_ = double_parse (_tmp14_);
				val = (glong) _tmp15_;
				_tmp16_ = val;
				g_value_set_long (&dest2, _tmp16_);
				ret = TRUE;
			} else {
				GType _tmp17_ = 0UL;
				_tmp17_ = t;
				if (_tmp17_ == G_TYPE_UINT) {
					guint val = 0U;
					const gchar* _tmp18_ = NULL;
					gdouble _tmp19_ = 0.0;
					guint _tmp20_ = 0U;
					_tmp18_ = str;
					_tmp19_ = double_parse (_tmp18_);
					val = (guint) _tmp19_;
					_tmp20_ = val;
					g_value_set_uint (&dest2, _tmp20_);
					ret = TRUE;
				} else {
					GType _tmp21_ = 0UL;
					_tmp21_ = t;
					if (_tmp21_ == G_TYPE_ULONG) {
						gulong val = 0UL;
						const gchar* _tmp22_ = NULL;
						gdouble _tmp23_ = 0.0;
						gulong _tmp24_ = 0UL;
						_tmp22_ = str;
						_tmp23_ = double_parse (_tmp22_);
						val = (gulong) _tmp23_;
						_tmp24_ = val;
						g_value_set_ulong (&dest2, _tmp24_);
						ret = TRUE;
					} else {
						GType _tmp25_ = 0UL;
						_tmp25_ = t;
						if (_tmp25_ == G_TYPE_BOOLEAN) {
							gboolean val = FALSE;
							const gchar* _tmp26_ = NULL;
							gchar* _tmp27_ = NULL;
							gchar* _tmp28_ = NULL;
							gboolean _tmp29_ = FALSE;
							gboolean _tmp30_ = FALSE;
							gboolean _tmp31_ = FALSE;
							gboolean _tmp32_ = FALSE;
							_tmp26_ = str;
							_tmp27_ = g_utf8_strdown (_tmp26_, (gssize) (-1));
							_tmp28_ = _tmp27_;
							_tmp30_ = bool_try_parse (_tmp28_, &_tmp29_);
							val = _tmp29_;
							ret = _tmp30_;
							_tmp31_ = ret;
							_tmp32_ = _tmp31_;
							_g_free0 (_tmp28_);
							if (_tmp32_) {
								gboolean _tmp33_ = FALSE;
								_tmp33_ = val;
								g_value_set_boolean (&dest2, _tmp33_);
							}
						} else {
							GType _tmp34_ = 0UL;
							_tmp34_ = t;
							if (_tmp34_ == G_TYPE_FLOAT) {
								gfloat val = 0.0F;
								const gchar* _tmp35_ = NULL;
								gdouble _tmp36_ = 0.0;
								gfloat _tmp37_ = 0.0F;
								_tmp35_ = str;
								_tmp36_ = double_parse (_tmp35_);
								val = (gfloat) _tmp36_;
								_tmp37_ = val;
								g_value_set_float (&dest2, _tmp37_);
								ret = TRUE;
							} else {
								GType _tmp38_ = 0UL;
								_tmp38_ = t;
								if (_tmp38_ == G_TYPE_DOUBLE) {
									gdouble val = 0.0;
									const gchar* _tmp39_ = NULL;
									gdouble _tmp40_ = 0.0;
									gdouble _tmp41_ = 0.0;
									_tmp39_ = str;
									_tmp40_ = double_parse (_tmp39_);
									val = (gdouble) _tmp40_;
									_tmp41_ = val;
									g_value_set_double (&dest2, _tmp41_);
									ret = TRUE;
								} else {
									GType _tmp42_ = 0UL;
									_tmp42_ = t;
									if (_tmp42_ == G_TYPE_STRING) {
										const gchar* _tmp43_ = NULL;
										_tmp43_ = str;
										g_value_set_string (&dest2, _tmp43_);
										ret = TRUE;
									} else {
										GType _tmp44_ = 0UL;
										_tmp44_ = t;
										if (_tmp44_ == G_TYPE_CHAR) {
											gchar val = '\0';
											const gchar* _tmp45_ = NULL;
											gdouble _tmp46_ = 0.0;
											gchar _tmp47_ = '\0';
											_tmp45_ = str;
											_tmp46_ = double_parse (_tmp45_);
											val = (gchar) _tmp46_;
											_tmp47_ = val;
											g_value_set_char (&dest2, _tmp47_);
											ret = TRUE;
										} else {
											GType _tmp48_ = 0UL;
											_tmp48_ = t;
											if (_tmp48_ == G_TYPE_UCHAR) {
												guchar val = '\0';
												const gchar* _tmp49_ = NULL;
												gdouble _tmp50_ = 0.0;
												guchar _tmp51_ = '\0';
												_tmp49_ = str;
												_tmp50_ = double_parse (_tmp49_);
												val = (guchar) _tmp50_;
												_tmp51_ = val;
												g_value_set_uchar (&dest2, _tmp51_);
												ret = TRUE;
											} else {
												GType _tmp52_ = 0UL;
												_tmp52_ = t;
												if (_tmp52_ == G_TYPE_BOXED) {
												} else {
													GType _tmp53_ = 0UL;
													gboolean _tmp54_ = FALSE;
													_tmp53_ = t;
													_tmp54_ = G_TYPE_IS_ENUM (_tmp53_);
													if (_tmp54_) {
														gint val = 0;
														const gchar* _tmp55_ = NULL;
														gdouble _tmp56_ = 0.0;
														gint _tmp57_ = 0;
														_tmp55_ = str;
														_tmp56_ = double_parse (_tmp55_);
														val = (gint) _tmp56_;
														_tmp57_ = val;
														g_value_set_enum (&dest2, _tmp57_);
														ret = TRUE;
													} else {
														GType _tmp58_ = 0UL;
														gboolean _tmp59_ = FALSE;
														_tmp58_ = t;
														_tmp59_ = G_TYPE_IS_FLAGS (_tmp58_);
														if (_tmp59_) {
														} else {
															GType _tmp60_ = 0UL;
															gboolean _tmp61_ = FALSE;
															_tmp60_ = t;
															_tmp61_ = G_TYPE_IS_OBJECT (_tmp60_);
															if (_tmp61_) {
															} else {
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp62_ = ret;
	if (_tmp62_ == TRUE) {
		GValue _tmp63_ = {0};
		GValue _tmp64_ = {0};
		_tmp63_ = dest2;
		if (G_IS_VALUE (&_tmp63_)) {
			g_value_init (&_tmp64_, G_VALUE_TYPE (&_tmp63_));
			g_value_copy (&_tmp63_, &_tmp64_);
		} else {
			_tmp64_ = _tmp63_;
		}
		G_IS_VALUE (dest) ? (g_value_unset (dest), NULL) : NULL;
		*dest = _tmp64_;
		result = TRUE;
		G_IS_VALUE (&dest2) ? (g_value_unset (&dest2), NULL) : NULL;
		return result;
	} else {
		const gchar* _tmp65_ = NULL;
		const gchar* _tmp66_ = NULL;
		GType _tmp67_ = 0UL;
		const gchar* _tmp68_ = NULL;
		GError* _tmp69_ = NULL;
		_tmp65_ = _ ("Transformation Error on '%s' or Unsupported type: '%s'");
		_tmp66_ = str;
		_tmp67_ = t;
		_tmp68_ = g_type_name (_tmp67_);
		_tmp69_ = g_error_new (GXML_SERIALIZABLE_ERROR, GXML_SERIALIZABLE_ERROR_UNSUPPORTED_TYPE_ERROR, _tmp65_, _tmp66_, _tmp68_);
		_inner_error_ = _tmp69_;
		if (_inner_error_->domain == GXML_SERIALIZABLE_ERROR) {
			g_propagate_error (error, _inner_error_);
			G_IS_VALUE (&dest2) ? (g_value_unset (&dest2), NULL) : NULL;
			return FALSE;
		} else {
			G_IS_VALUE (&dest2) ? (g_value_unset (&dest2), NULL) : NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	G_IS_VALUE (&dest2) ? (g_value_unset (&dest2), NULL) : NULL;
}


/**
     * Transforms a {@link GLib.Value} to its string representation.
     *
     * By default use {@link GLib.Value} standard transformations.
     *
     */
gchar* gxml_serializable_gvalue_to_string (GValue* val, GError** error) {
	gchar* result = NULL;
	GValue ret = {0};
	GValue _tmp0_ = {0};
	GType _tmp1_ = 0UL;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (val != NULL, NULL);
	g_value_init (&_tmp0_, G_TYPE_STRING);
	g_value_set_string (&_tmp0_, "");
	ret = _tmp0_;
	_tmp1_ = G_VALUE_TYPE (val);
	_tmp2_ = g_value_type_transformable (_tmp1_, G_TYPE_STRING);
	if (_tmp2_) {
		gchar* _tmp3_ = NULL;
		g_value_transform (val, &ret);
		_tmp3_ = g_value_dup_string (&ret);
		result = _tmp3_;
		G_IS_VALUE (&ret) ? (g_value_unset (&ret), NULL) : NULL;
		return result;
	} else {
		const gchar* _tmp4_ = NULL;
		GType _tmp5_ = 0UL;
		const gchar* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		_tmp4_ = _ ("Can't transform '%s' to string");
		_tmp5_ = G_VALUE_TYPE (val);
		_tmp6_ = g_type_name (_tmp5_);
		_tmp7_ = g_error_new (GXML_SERIALIZABLE_ERROR, GXML_SERIALIZABLE_ERROR_UNSUPPORTED_TYPE_ERROR, _tmp4_, _tmp6_);
		_inner_error_ = _tmp7_;
		if (_inner_error_->domain == GXML_SERIALIZABLE_ERROR) {
			g_propagate_error (error, _inner_error_);
			G_IS_VALUE (&ret) ? (g_value_unset (&ret), NULL) : NULL;
			return NULL;
		} else {
			G_IS_VALUE (&ret) ? (g_value_unset (&ret), NULL) : NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	G_IS_VALUE (&ret) ? (g_value_unset (&ret), NULL) : NULL;
}


GeeMap* gxml_serializable_get_unknown_serializable_properties (GXmlSerializable* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->get_unknown_serializable_properties (self);
}


GeeCollection* gxml_serializable_get_unknown_serializable_nodes (GXmlSerializable* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->get_unknown_serializable_nodes (self);
}


gchar* gxml_serializable_get_serialized_xml_node_value (GXmlSerializable* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->get_serialized_xml_node_value (self);
}


void gxml_serializable_set_serialized_xml_node_value (GXmlSerializable* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	GXML_SERIALIZABLE_GET_INTERFACE (self)->set_serialized_xml_node_value (self, value);
}


static void g_cclosure_user_marshal_VOID__OBJECT_G_PARAM_SPEC_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_G_PARAM_SPEC_POINTER) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_G_PARAM_SPEC_POINTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_G_PARAM_SPEC_POINTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_param (param_values + 2), g_value_get_pointer (param_values + 3), data2);
}


static void g_cclosure_user_marshal_VOID__OBJECT_G_PARAM_SPEC (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_G_PARAM_SPEC) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_G_PARAM_SPEC callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_G_PARAM_SPEC) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_param (param_values + 2), data2);
}


static void gxml_serializable_base_init (GXmlSerializableIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		     * On deserialization stores any {@link GXml.Attribute} not used on this
		     * object, but exists in current XML file.
		     *
		     * Node's name is used as key to find stored {@link GXml.Attribute}, key is
		     * case sensitive.
		     *
		     * XML allows great flexibility, providing different ways to represent the same
		     * information. This is a problem when you try to deserialize them.
		     *
		     * In order to deserialize correctly, you must create your XML, both by
		     * serializing a {@link Serializable} object or by hand writing. By using the
		     * former, you can add extra information, like attributes, but most of
		     * them could be ignored or lost on deserialization/serialization process. To
		     * avoid data lost, you can override {@link get_enable_unknown_serializable_property}
		     * method in order to return true, your implementation or the ones in GXml, will
		     * store all unknown attributes on deserialization and must serialize
		     * again back to the XML file. Even you are allowed to get this unknown objects
		     * by iterating on {@link unknown_serializable_properties} collection, if you know
		     * attribute's name, use it to retrieve it.
		     *
		     * This property is ignored on serialisation.
		     */
		g_object_interface_install_property (iface, g_param_spec_object ("unknown-serializable-properties", "unknown-serializable-properties", "unknown-serializable-properties", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		/**
		     * On deserialization stores any {@link GXml.Node} not used on this
		     * object, but exists in current XML file.
		     *
		     * XML allows great flexibility, providing different ways to represent the same
		     * information. This is a problem when you try to deserialize them.
		     *
		     * In order to deserialize correctly, you must create your XML, both by
		     * serializing a {@link Serializable} object or by hand writing. By using the
		     * former, you can add extra information, like nodes or contents in known nodes,
		     * but most of them could be ignored or lost on deserialization/serialization process.
		     * To avoid data lost, you can override {@link get_enable_unknown_serializable_property}
		     * method in order to return true, your implementation or the ones in GXml, will
		     * store all unknown properties and nodes on deserialization and must serialize
		     * again back to the XML file. Even you are allowed to get this unknown objects
		     * by iterating on {@link Serializable.unknown_serializable_nodes} hash table.
		     *
		     * This property is ignored on serialisation.
		     */
		g_object_interface_install_property (iface, g_param_spec_object ("unknown-serializable-nodes", "unknown-serializable-nodes", "unknown-serializable-nodes", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		/**
		     * Used to add content in an {@link GXml.Element}.
		     *
		     * By default no contents is serialized/deseralized. Implementors must implement
		     * {@link Serializable.serialize_use_xml_node_value} function returning
		     * true in order to use this property.
		     *
		     * This property is ignored by default. Implementors must implement
		     * {@link serialize_use_xml_node_value} to return true and add a
		     * set and get function to get/set this value, in order to use your own API.
		     *
		     * This property is ignored on serialisation.
		     */
		g_object_interface_install_property (iface, g_param_spec_string ("serialized-xml-node-value", "serialized-xml-node-value", "serialized-xml-node-value", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		/**
		     * Signal to serialize unknown properties. Any new node must be added to
		     * @param element before return the new @param node added.
		     *
		     * @param element a {@link GXml.Node} to add attribute or child nodes to
		     * @param prop a {@link GLib.ParamSpec} describing attribute to serialize
		     * @param node set to the {@link GXml.Node} representing this attribute
		     */
		g_signal_new ("serialize_unknown_property", GXML_TYPE_SERIALIZABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_G_PARAM_SPEC_POINTER, G_TYPE_NONE, 3, GXML_TYPE_NODE, G_TYPE_PARAM, G_TYPE_POINTER);
		/**
		     * Signal to serialize unknown properties. Any new node must be added to
		     * @param element before return the new @node added.
		     * 
		     * @param element a {@link GXml.Node} to add attribute or child nodes to
		     * @param prop a {@link GLib.ParamSpec} describing attribute to serialize
		     * @param node set to the {@link GXml.Node} representing this attribute
		     */
		g_signal_new ("serialize_unknown_property_type", GXML_TYPE_SERIALIZABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_G_PARAM_SPEC_POINTER, G_TYPE_NONE, 3, GXML_TYPE_NODE, G_TYPE_PARAM, G_TYPE_POINTER);
		/**
		     * Signal to deserialize unknown properties.
		     *
		     * @param node a {@link GXml.Node} to get attribute from
		     * @param prop a {@link GLib.ParamSpec} describing attribute to deserialize
		     */
		g_signal_new ("deserialize_unknown_property", GXML_TYPE_SERIALIZABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_G_PARAM_SPEC, G_TYPE_NONE, 2, GXML_TYPE_NODE, G_TYPE_PARAM);
		/**
		     * Signal to deserialize unknown properties' type.
		     *
		     * @param node a {@link GXml.Node} to get attribute from
		     * @param prop a {@link GLib.ParamSpec} describing attribute to deserialize
		     */
		g_signal_new ("deserialize_unknown_property_type", GXML_TYPE_SERIALIZABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_G_PARAM_SPEC, G_TYPE_NONE, 2, GXML_TYPE_NODE, G_TYPE_PARAM);
		iface->default_find_property_spec = gxml_serializable_real_default_find_property_spec;
		iface->default_list_serializable_properties = gxml_serializable_real_default_list_serializable_properties;
	}
}


/**
   * Serialization framework. Base interface.
   *
   * Implementors of this interface, could define or override the way you want to 
   * represent your class in a XML file.
   */
GType gxml_serializable_get_type (void) {
	static volatile gsize gxml_serializable_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_serializable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlSerializableIface), (GBaseInitFunc) gxml_serializable_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gxml_serializable_type_id;
		gxml_serializable_type_id = g_type_register_static (G_TYPE_INTERFACE, "GXmlSerializable", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gxml_serializable_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gxml_serializable_type_id__volatile, gxml_serializable_type_id);
	}
	return gxml_serializable_type_id__volatile;
}


GQuark gxml_serializable_error_quark (void) {
	return g_quark_from_static_string ("gxml_serializable_error-quark");
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



