/* libxml-CharacterData.c generated by valac 0.28.1, the Vala compiler
 * generated from libxml-CharacterData.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 2 -*- */
/* CharacterData.vala
 *
 * Copyright (C) 2011-2013  Richard Schwarting <aquarichy@gmail.com>
 * Copyright (C) 2011,2015  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Authors:
 *      Richard Schwarting <aquarichy@gmail.com>
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <libxml/tree.h>


#define GXML_TYPE_NODE (gxml_node_get_type ())
#define GXML_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NODE, GXmlNode))
#define GXML_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NODE))
#define GXML_NODE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NODE, GXmlNodeIface))

typedef struct _GXmlNode GXmlNode;
typedef struct _GXmlNodeIface GXmlNodeIface;

#define GXML_TYPE_ELEMENT_LIST (gxml_element_list_get_type ())
#define GXML_ELEMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ELEMENT_LIST, GXmlElementList))
#define GXML_ELEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_ELEMENT_LIST, GXmlElementListClass))
#define GXML_IS_ELEMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ELEMENT_LIST))
#define GXML_IS_ELEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_ELEMENT_LIST))
#define GXML_ELEMENT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_ELEMENT_LIST, GXmlElementListClass))

typedef struct _GXmlElementList GXmlElementList;
typedef struct _GXmlElementListClass GXmlElementListClass;

#define GXML_TYPE_NAMESPACE (gxml_namespace_get_type ())
#define GXML_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NAMESPACE, GXmlNamespace))
#define GXML_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NAMESPACE))
#define GXML_NAMESPACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NAMESPACE, GXmlNamespaceIface))

typedef struct _GXmlNamespace GXmlNamespace;
typedef struct _GXmlNamespaceIface GXmlNamespaceIface;

#define GXML_TYPE_NODE_TYPE (gxml_node_type_get_type ())

#define GXML_TYPE_DOCUMENT (gxml_document_get_type ())
#define GXML_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOCUMENT, GXmlDocument))
#define GXML_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOCUMENT))
#define GXML_DOCUMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOCUMENT, GXmlDocumentIface))

typedef struct _GXmlDocument GXmlDocument;
typedef struct _GXmlDocumentIface GXmlDocumentIface;

#define GXML_TYPE_XNODE (gxml_xnode_get_type ())
#define GXML_XNODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_XNODE, GXmlxNode))
#define GXML_XNODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_XNODE, GXmlxNodeClass))
#define GXML_IS_XNODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_XNODE))
#define GXML_IS_XNODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_XNODE))
#define GXML_XNODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_XNODE, GXmlxNodeClass))

typedef struct _GXmlxNode GXmlxNode;
typedef struct _GXmlxNodeClass GXmlxNodeClass;
typedef struct _GXmlxNodePrivate GXmlxNodePrivate;

#define GXML_TYPE_NAMESPACE_ATTR (gxml_namespace_attr_get_type ())
#define GXML_NAMESPACE_ATTR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NAMESPACE_ATTR, GXmlNamespaceAttr))
#define GXML_NAMESPACE_ATTR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_NAMESPACE_ATTR, GXmlNamespaceAttrClass))
#define GXML_IS_NAMESPACE_ATTR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NAMESPACE_ATTR))
#define GXML_IS_NAMESPACE_ATTR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_NAMESPACE_ATTR))
#define GXML_NAMESPACE_ATTR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_NAMESPACE_ATTR, GXmlNamespaceAttrClass))

typedef struct _GXmlNamespaceAttr GXmlNamespaceAttr;
typedef struct _GXmlNamespaceAttrClass GXmlNamespaceAttrClass;

#define GXML_TYPE_XNODE_LIST (gxml_xnode_list_get_type ())
#define GXML_XNODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_XNODE_LIST, GXmlxNodeList))
#define GXML_IS_XNODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_XNODE_LIST))
#define GXML_XNODE_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_XNODE_LIST, GXmlxNodeListIface))

typedef struct _GXmlxNodeList GXmlxNodeList;
typedef struct _GXmlxNodeListIface GXmlxNodeListIface;

#define GXML_TYPE_ABSTRACT_NAMED_ATTR_MAP (gxml_abstract_named_attr_map_get_type ())
#define GXML_ABSTRACT_NAMED_ATTR_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ABSTRACT_NAMED_ATTR_MAP, GXmlAbstractNamedAttrMap))
#define GXML_ABSTRACT_NAMED_ATTR_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_ABSTRACT_NAMED_ATTR_MAP, GXmlAbstractNamedAttrMapClass))
#define GXML_IS_ABSTRACT_NAMED_ATTR_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ABSTRACT_NAMED_ATTR_MAP))
#define GXML_IS_ABSTRACT_NAMED_ATTR_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_ABSTRACT_NAMED_ATTR_MAP))
#define GXML_ABSTRACT_NAMED_ATTR_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_ABSTRACT_NAMED_ATTR_MAP, GXmlAbstractNamedAttrMapClass))

typedef struct _GXmlAbstractNamedAttrMap GXmlAbstractNamedAttrMap;
typedef struct _GXmlAbstractNamedAttrMapClass GXmlAbstractNamedAttrMapClass;

#define GXML_TYPE_NAMED_ATTR_MAP (gxml_named_attr_map_get_type ())
#define GXML_NAMED_ATTR_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NAMED_ATTR_MAP, GXmlNamedAttrMap))
#define GXML_NAMED_ATTR_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_NAMED_ATTR_MAP, GXmlNamedAttrMapClass))
#define GXML_IS_NAMED_ATTR_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NAMED_ATTR_MAP))
#define GXML_IS_NAMED_ATTR_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_NAMED_ATTR_MAP))
#define GXML_NAMED_ATTR_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_NAMED_ATTR_MAP, GXmlNamedAttrMapClass))

typedef struct _GXmlNamedAttrMap GXmlNamedAttrMap;
typedef struct _GXmlNamedAttrMapClass GXmlNamedAttrMapClass;

#define GXML_TYPE_ABSTRACT_NAMESPACE_ATTR_NODE_LIST (gxml_abstract_namespace_attr_node_list_get_type ())
#define GXML_ABSTRACT_NAMESPACE_ATTR_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ABSTRACT_NAMESPACE_ATTR_NODE_LIST, GXmlAbstractNamespaceAttrNodeList))
#define GXML_ABSTRACT_NAMESPACE_ATTR_NODE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_ABSTRACT_NAMESPACE_ATTR_NODE_LIST, GXmlAbstractNamespaceAttrNodeListClass))
#define GXML_IS_ABSTRACT_NAMESPACE_ATTR_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ABSTRACT_NAMESPACE_ATTR_NODE_LIST))
#define GXML_IS_ABSTRACT_NAMESPACE_ATTR_NODE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_ABSTRACT_NAMESPACE_ATTR_NODE_LIST))
#define GXML_ABSTRACT_NAMESPACE_ATTR_NODE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_ABSTRACT_NAMESPACE_ATTR_NODE_LIST, GXmlAbstractNamespaceAttrNodeListClass))

typedef struct _GXmlAbstractNamespaceAttrNodeList GXmlAbstractNamespaceAttrNodeList;
typedef struct _GXmlAbstractNamespaceAttrNodeListClass GXmlAbstractNamespaceAttrNodeListClass;

#define GXML_TYPE_NAMESPACE_ATTR_NODE_LIST (gxml_namespace_attr_node_list_get_type ())
#define GXML_NAMESPACE_ATTR_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NAMESPACE_ATTR_NODE_LIST, GXmlNamespaceAttrNodeList))
#define GXML_NAMESPACE_ATTR_NODE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_NAMESPACE_ATTR_NODE_LIST, GXmlNamespaceAttrNodeListClass))
#define GXML_IS_NAMESPACE_ATTR_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NAMESPACE_ATTR_NODE_LIST))
#define GXML_IS_NAMESPACE_ATTR_NODE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_NAMESPACE_ATTR_NODE_LIST))
#define GXML_NAMESPACE_ATTR_NODE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_NAMESPACE_ATTR_NODE_LIST, GXmlNamespaceAttrNodeListClass))

typedef struct _GXmlNamespaceAttrNodeList GXmlNamespaceAttrNodeList;
typedef struct _GXmlNamespaceAttrNodeListClass GXmlNamespaceAttrNodeListClass;

#define GXML_TYPE_BACKED_NODE (gxml_backed_node_get_type ())
#define GXML_BACKED_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_BACKED_NODE, GXmlBackedNode))
#define GXML_BACKED_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_BACKED_NODE, GXmlBackedNodeClass))
#define GXML_IS_BACKED_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_BACKED_NODE))
#define GXML_IS_BACKED_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_BACKED_NODE))
#define GXML_BACKED_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_BACKED_NODE, GXmlBackedNodeClass))

typedef struct _GXmlBackedNode GXmlBackedNode;
typedef struct _GXmlBackedNodeClass GXmlBackedNodeClass;
typedef struct _GXmlBackedNodePrivate GXmlBackedNodePrivate;

#define GXML_TYPE_XCHARACTER_DATA (gxml_xcharacter_data_get_type ())
#define GXML_XCHARACTER_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_XCHARACTER_DATA, GXmlxCharacterData))
#define GXML_XCHARACTER_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_XCHARACTER_DATA, GXmlxCharacterDataClass))
#define GXML_IS_XCHARACTER_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_XCHARACTER_DATA))
#define GXML_IS_XCHARACTER_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_XCHARACTER_DATA))
#define GXML_XCHARACTER_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_XCHARACTER_DATA, GXmlxCharacterDataClass))

typedef struct _GXmlxCharacterData GXmlxCharacterData;
typedef struct _GXmlxCharacterDataClass GXmlxCharacterDataClass;
typedef struct _GXmlxCharacterDataPrivate GXmlxCharacterDataPrivate;

#define GXML_TYPE_XDOCUMENT (gxml_xdocument_get_type ())
#define GXML_XDOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_XDOCUMENT, GXmlxDocument))
#define GXML_XDOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_XDOCUMENT, GXmlxDocumentClass))
#define GXML_IS_XDOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_XDOCUMENT))
#define GXML_IS_XDOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_XDOCUMENT))
#define GXML_XDOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_XDOCUMENT, GXmlxDocumentClass))

typedef struct _GXmlxDocument GXmlxDocument;
typedef struct _GXmlxDocumentClass GXmlxDocumentClass;

#define GXML_TYPE_DOM_EXCEPTION (gxml_dom_exception_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GXmlNamespaceIface {
	GTypeInterface parent_iface;
	gchar* (*get_uri) (GXmlNamespace* self);
	gchar* (*get_prefix) (GXmlNamespace* self);
};

typedef enum  {
	GXML_NODE_TYPE_X_UNKNOWN = 0,
	GXML_NODE_TYPE_ELEMENT = 1,
	GXML_NODE_TYPE_ATTRIBUTE,
	GXML_NODE_TYPE_TEXT,
	GXML_NODE_TYPE_CDATA_SECTION,
	GXML_NODE_TYPE_ENTITY_REFERENCE,
	GXML_NODE_TYPE_ENTITY,
	GXML_NODE_TYPE_PROCESSING_INSTRUCTION,
	GXML_NODE_TYPE_COMMENT,
	GXML_NODE_TYPE_DOCUMENT,
	GXML_NODE_TYPE_DOCUMENT_TYPE,
	GXML_NODE_TYPE_DOCUMENT_FRAGMENT,
	GXML_NODE_TYPE_NOTATION
} GXmlNodeType;

struct _GXmlDocumentIface {
	GTypeInterface parent_iface;
	GXmlNode* (*create_element) (GXmlDocument* self, const gchar* name, GError** error);
	GXmlNode* (*create_text) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_comment) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_cdata) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_pi) (GXmlDocument* self, const gchar* target, const gchar* data);
	gboolean (*save) (GXmlDocument* self, GCancellable* cancellable, GError** error);
	gboolean (*save_as) (GXmlDocument* self, GFile* f, GCancellable* cancellable, GError** error);
	gboolean (*get_indent) (GXmlDocument* self);
	void (*set_indent) (GXmlDocument* self, gboolean value);
	gboolean (*get_ns_top) (GXmlDocument* self);
	void (*set_ns_top) (GXmlDocument* self, gboolean value);
	gboolean (*get_prefix_default_ns) (GXmlDocument* self);
	void (*set_prefix_default_ns) (GXmlDocument* self, gboolean value);
	gboolean (*get_backup) (GXmlDocument* self);
	void (*set_backup) (GXmlDocument* self, gboolean value);
	GXmlNode* (*get_root) (GXmlDocument* self);
	GFile* (*get_file) (GXmlDocument* self);
	void (*set_file) (GXmlDocument* self, GFile* value);
};

struct _GXmlNodeIface {
	GTypeInterface parent_iface;
	GXmlNode* (*get) (GXmlNode* self, const gchar* key);
	GXmlElementList* (*get_elements_by_property_value) (GXmlNode* self, const gchar* property, const gchar* value);
	gchar* (*to_string) (GXmlNode* self);
	gboolean (*set_namespace) (GXmlNode* self, const gchar* uri, const gchar* prefix);
	gchar* (*ns_prefix) (GXmlNode* self);
	gchar* (*ns_uri) (GXmlNode* self);
	GeeList* (*get_namespaces) (GXmlNode* self);
	GeeBidirList* (*get_childs) (GXmlNode* self);
	GeeBidirList* (*get_children) (GXmlNode* self);
	GeeMap* (*get_attrs) (GXmlNode* self);
	gchar* (*get_name) (GXmlNode* self);
	gchar* (*get_value) (GXmlNode* self);
	void (*set_value) (GXmlNode* self, const gchar* value);
	GXmlNodeType (*get_type_node) (GXmlNode* self);
	GXmlDocument* (*get_document) (GXmlNode* self);
	GXmlNode* (*get_parent) (GXmlNode* self);
};

struct _GXmlxNodeListIface {
	GTypeInterface parent_iface;
	GXmlxNode* (*item) (GXmlxNodeList* self, gulong idx);
	GXmlxNode* (*insert_before) (GXmlxNodeList* self, GXmlxNode* new_child, GXmlxNode* ref_child);
	GXmlxNode* (*replace_child) (GXmlxNodeList* self, GXmlxNode* new_child, GXmlxNode* old_child);
	GXmlxNode* (*remove_child) (GXmlxNodeList* self, GXmlxNode* old_child);
	GXmlxNode* (*append_child) (GXmlxNodeList* self, GXmlxNode* new_child);
	gchar* (*to_string) (GXmlxNodeList* self, gboolean in_line);
	GXmlxNode* (*first) (GXmlxNodeList* self);
	GXmlxNode* (*last) (GXmlxNodeList* self);
	GXmlxNode* (*get) (GXmlxNodeList* self, gint n);
	gulong (*get_length) (GXmlxNodeList* self);
	void (*set_length) (GXmlxNodeList* self, gulong value);
};

struct _GXmlxNode {
	GObject parent_instance;
	GXmlxNodePrivate * priv;
	GXmlxNodeList* _child_nodes;
	GXmlNamedAttrMap* _attributes;
	GXmlNamespaceAttrNodeList* _namespace_definitions;
};

struct _GXmlxNodeClass {
	GObjectClass parent_class;
	GXmlNamespaceAttr* (*add_namespace_attr) (GXmlxNode* self, const gchar* uri, const gchar* namespace_prefix);
	gboolean (*set_namespace) (GXmlxNode* self, const gchar* uri, const gchar* namespace_prefix);
	GXmlxNode* (*insert_before) (GXmlxNode* self, GXmlxNode* new_child, GXmlxNode* ref_child);
	GXmlxNode* (*replace_child) (GXmlxNode* self, GXmlxNode* new_child, GXmlxNode* old_child);
	GXmlxNode* (*remove_child) (GXmlxNode* self, GXmlxNode* old_child);
	GXmlxNode* (*append_child) (GXmlxNode* self, GXmlxNode* new_child);
	gboolean (*has_child_nodes) (GXmlxNode* self);
	GXmlxNode* (*clone_node) (GXmlxNode* self, gboolean deep);
	gchar* (*stringify) (GXmlxNode* self, gboolean format, gint level);
	gchar* (*to_string) (GXmlxNode* self);
	GeeList* (*get_namespace_definitions) (GXmlxNode* self);
	void (*set_namespace_definitions) (GXmlxNode* self, GeeList* value);
	const gchar* (*get_namespace_uri) (GXmlxNode* self);
	void (*set_namespace_uri) (GXmlxNode* self, const gchar* value);
	const gchar* (*get_namespace_prefix) (GXmlxNode* self);
	void (*set_namespace_prefix) (GXmlxNode* self, const gchar* value);
	const gchar* (*get_local_name) (GXmlxNode* self);
	void (*set_local_name) (GXmlxNode* self, const gchar* value);
	const gchar* (*get_node_name) (GXmlxNode* self);
	void (*set_node_name) (GXmlxNode* self, const gchar* value);
	const gchar* (*get_node_value) (GXmlxNode* self);
	void (*set_node_value) (GXmlxNode* self, const gchar* value);
	GXmlNodeType (*get_node_type) (GXmlxNode* self);
	void (*set_node_type) (GXmlxNode* self, GXmlNodeType value);
	GXmlxNode* (*get_parent_node) (GXmlxNode* self);
	void (*set_parent_node) (GXmlxNode* self, GXmlxNode* value);
	GXmlxNodeList* (*get_child_nodes) (GXmlxNode* self);
	void (*set_child_nodes) (GXmlxNode* self, GXmlxNodeList* value);
	GXmlxNode* (*get_first_child) (GXmlxNode* self);
	void (*set_first_child) (GXmlxNode* self, GXmlxNode* value);
	GXmlxNode* (*get_last_child) (GXmlxNode* self);
	void (*set_last_child) (GXmlxNode* self, GXmlxNode* value);
	GXmlxNode* (*get_previous_sibling) (GXmlxNode* self);
	void (*set_previous_sibling) (GXmlxNode* self, GXmlxNode* value);
	GXmlxNode* (*get_next_sibling) (GXmlxNode* self);
	void (*set_next_sibling) (GXmlxNode* self, GXmlxNode* value);
	GXmlNamedAttrMap* (*get_attributes) (GXmlxNode* self);
	void (*set_attributes) (GXmlxNode* self, GXmlNamedAttrMap* value);
	GeeList* (*get_namespaces) (GXmlxNode* self);
	GeeBidirList* (*get_children) (GXmlxNode* self);
	GeeMap* (*get_attrs) (GXmlxNode* self);
	gchar* (*get_name) (GXmlxNode* self);
	gchar* (*get_value) (GXmlxNode* self);
	void (*set_value) (GXmlxNode* self, const gchar* value);
	GXmlNode* (*get_parent) (GXmlxNode* self);
};

struct _GXmlBackedNode {
	GXmlxNode parent_instance;
	GXmlBackedNodePrivate * priv;
	xmlNode* node;
};

struct _GXmlBackedNodeClass {
	GXmlxNodeClass parent_class;
};

struct _GXmlxCharacterData {
	GXmlBackedNode parent_instance;
	GXmlxCharacterDataPrivate * priv;
};

struct _GXmlxCharacterDataClass {
	GXmlBackedNodeClass parent_class;
};

typedef enum  {
	GXML_DOM_EXCEPTION_NONE,
	GXML_DOM_EXCEPTION_INDEX_SIZE,
	GXML_DOM_EXCEPTION_DOMSTRING_SIZE,
	GXML_DOM_EXCEPTION_HIERARCHY_REQUEST,
	GXML_DOM_EXCEPTION_WRONG_DOCUMENT,
	GXML_DOM_EXCEPTION_INVALID_CHARACTER,
	GXML_DOM_EXCEPTION_NO_DATA_ALLOWED,
	GXML_DOM_EXCEPTION_NO_MODIFICATION_ALLOWED,
	GXML_DOM_EXCEPTION_NOT_FOUND,
	GXML_DOM_EXCEPTION_NOT_SUPPORTED,
	GXML_DOM_EXCEPTION_INUSE_ATTRIBUTE,
	GXML_DOM_EXCEPTION_DOM,
	GXML_DOM_EXCEPTION_INVALID_DOC,
	GXML_DOM_EXCEPTION_INVALID_ROOT,
	GXML_DOM_EXCEPTION_NAMESPACE,
	GXML_DOM_EXCEPTION_X_OTHER
} GXmlDomException;


static gpointer gxml_xcharacter_data_parent_class = NULL;

GType gxml_element_list_get_type (void) G_GNUC_CONST;
GType gxml_namespace_get_type (void) G_GNUC_CONST;
GType gxml_node_type_get_type (void) G_GNUC_CONST;
GType gxml_document_get_type (void) G_GNUC_CONST;
GType gxml_node_get_type (void) G_GNUC_CONST;
GType gxml_xnode_get_type (void) G_GNUC_CONST;
GType gxml_namespace_attr_get_type (void) G_GNUC_CONST;
GType gxml_xnode_list_get_type (void) G_GNUC_CONST;
GType gxml_abstract_named_attr_map_get_type (void) G_GNUC_CONST;
GType gxml_named_attr_map_get_type (void) G_GNUC_CONST;
GType gxml_abstract_namespace_attr_node_list_get_type (void) G_GNUC_CONST;
GType gxml_namespace_attr_node_list_get_type (void) G_GNUC_CONST;
GType gxml_backed_node_get_type (void) G_GNUC_CONST;
GType gxml_xcharacter_data_get_type (void) G_GNUC_CONST;
enum  {
	GXML_XCHARACTER_DATA_DUMMY_PROPERTY,
	GXML_XCHARACTER_DATA_DATA,
	GXML_XCHARACTER_DATA_LENGTH
};
GType gxml_xdocument_get_type (void) G_GNUC_CONST;
GXmlxCharacterData* gxml_xcharacter_data_new (xmlNode* char_node, GXmlxDocument* doc);
GXmlxCharacterData* gxml_xcharacter_data_construct (GType object_type, xmlNode* char_node, GXmlxDocument* doc);
GXmlBackedNode* gxml_backed_node_new (xmlNode* node, GXmlxDocument* owner);
GXmlBackedNode* gxml_backed_node_construct (GType object_type, xmlNode* node, GXmlxDocument* owner);
gboolean gxml_xcharacter_data_check_index_size (GXmlxCharacterData* self, const gchar* method, gint length, gulong offset, gulong* count);
GType gxml_dom_exception_get_type (void) G_GNUC_CONST;
void gxml_warning (GXmlDomException ex, const gchar* message) G_GNUC_DEPRECATED;
gchar* gxml_xcharacter_data_substring_data (GXmlxCharacterData* self, gulong offset, gulong count);
const gchar* gxml_xcharacter_data_get_data (GXmlxCharacterData* self);
void gxml_xcharacter_data_append_data (GXmlxCharacterData* self, const gchar* new_segment);
void gxml_xcharacter_data_set_data (GXmlxCharacterData* self, const gchar* value);
void gxml_xcharacter_data_insert_data (GXmlxCharacterData* self, gulong offset, const gchar* new_segment);
void gxml_xcharacter_data_delete_data (GXmlxCharacterData* self, gulong offset, gulong count);
void gxml_xcharacter_data_replace_data (GXmlxCharacterData* self, gulong offset, gulong count, const gchar* new_segment);
const gchar* gxml_xnode_get_node_value (GXmlxNode* self);
gboolean gxml_xnode_check_read_only (GXmlxNode* self);
void gxml_xnode_set_node_value (GXmlxNode* self, const gchar* value);
gulong gxml_xcharacter_data_get_length (GXmlxCharacterData* self);
static void gxml_xcharacter_data_set_length (GXmlxCharacterData* self, gulong value);
static void _vala_gxml_xcharacter_data_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gxml_xcharacter_data_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GXmlxCharacterData* gxml_xcharacter_data_construct (GType object_type, xmlNode* char_node, GXmlxDocument* doc) {
	GXmlxCharacterData * self = NULL;
	xmlNode* _tmp0_ = NULL;
	GXmlxDocument* _tmp1_ = NULL;
	g_return_val_if_fail (doc != NULL, NULL);
	_tmp0_ = char_node;
	_tmp1_ = doc;
	self = (GXmlxCharacterData*) gxml_backed_node_construct (object_type, _tmp0_, _tmp1_);
	return self;
}


GXmlxCharacterData* gxml_xcharacter_data_new (xmlNode* char_node, GXmlxDocument* doc) {
	return gxml_xcharacter_data_construct (GXML_TYPE_XCHARACTER_DATA, char_node, doc);
}


gboolean gxml_xcharacter_data_check_index_size (GXmlxCharacterData* self, const gchar* method, gint length, gulong offset, gulong* count) {
	gboolean result = FALSE;
	gulong _tmp0_ = 0UL;
	gulong* _tmp6_ = NULL;
	gulong* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (method != NULL, FALSE);
	_tmp0_ = offset;
	if (_tmp0_ < ((gulong) 0)) {
		const gchar* _tmp1_ = NULL;
		gulong _tmp2_ = 0UL;
		gint _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp1_ = method;
		_tmp2_ = offset;
		_tmp3_ = length;
		_tmp4_ = g_strdup_printf ("%s called with offset '%lu' for data of length '%lu'", _tmp1_, _tmp2_, (gulong) _tmp3_);
		_tmp5_ = _tmp4_;
		gxml_warning (GXML_DOM_EXCEPTION_INDEX_SIZE, _tmp5_);
		_g_free0 (_tmp5_);
		result = FALSE;
		return result;
	}
	_tmp6_ = count;
	if ((*_tmp6_) < ((gulong) 0)) {
		const gchar* _tmp7_ = NULL;
		gulong* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp7_ = method;
		_tmp8_ = count;
		_tmp9_ = g_strdup_printf ("%s called with count '%lu'", _tmp7_, *_tmp8_);
		_tmp10_ = _tmp9_;
		gxml_warning (GXML_DOM_EXCEPTION_INDEX_SIZE, _tmp10_);
		_g_free0 (_tmp10_);
		result = FALSE;
		return result;
	}
	_tmp11_ = count;
	if (_tmp11_ != NULL) {
		gint _tmp12_ = 0;
		gulong _tmp13_ = 0UL;
		gulong* _tmp14_ = NULL;
		_tmp12_ = length;
		_tmp13_ = offset;
		_tmp14_ = count;
		if (((gulong) _tmp12_) < (_tmp13_ + (*_tmp14_))) {
			const gchar* _tmp15_ = NULL;
			gulong _tmp16_ = 0UL;
			gulong* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			_tmp15_ = method;
			_tmp16_ = offset;
			_tmp17_ = count;
			_tmp18_ = length;
			_tmp19_ = g_strdup_printf ("%s called with offset '%lu' and count '%lu' for data of length '%lu'", _tmp15_, _tmp16_, *_tmp17_, (gulong) _tmp18_);
			_tmp20_ = _tmp19_;
			gxml_warning (GXML_DOM_EXCEPTION_INDEX_SIZE, _tmp20_);
			_g_free0 (_tmp20_);
			result = FALSE;
			return result;
		}
	} else {
		gint _tmp21_ = 0;
		gulong _tmp22_ = 0UL;
		_tmp21_ = length;
		_tmp22_ = offset;
		if (((gulong) _tmp21_) < _tmp22_) {
			const gchar* _tmp23_ = NULL;
			gulong _tmp24_ = 0UL;
			gint _tmp25_ = 0;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			_tmp23_ = method;
			_tmp24_ = offset;
			_tmp25_ = length;
			_tmp26_ = g_strdup_printf ("%s called with offset '%lu' for data of length '%lu'", _tmp23_, _tmp24_, (gulong) _tmp25_);
			_tmp27_ = _tmp26_;
			gxml_warning (GXML_DOM_EXCEPTION_INDEX_SIZE, _tmp27_);
			_g_free0 (_tmp27_);
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}


/**
 * Retrieves a substring of the character data
 * count-characters long, starting from the character
 * at offset.
 *
 * Version: DOM Level 1 Core<<BR>>
 * URL: [[http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-6531BCCF]]
 */
static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


gchar* gxml_xcharacter_data_substring_data (GXmlxCharacterData* self, gulong offset, gulong count) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gulong _tmp4_ = 0UL;
	gulong _tmp5_ = 0UL;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gulong _tmp10_ = 0UL;
	gulong _tmp11_ = 0UL;
	gchar* _tmp12_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gxml_xcharacter_data_get_data (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = offset;
	_tmp5_ = count;
	_tmp6_ = gxml_xcharacter_data_check_index_size (self, "substring_data", _tmp3_, _tmp4_, &_tmp5_);
	if (!_tmp6_) {
		gchar* _tmp7_ = NULL;
		_tmp7_ = g_strdup ("");
		result = _tmp7_;
		return result;
	}
	_tmp8_ = gxml_xcharacter_data_get_data (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = offset;
	_tmp11_ = count;
	_tmp12_ = string_substring (_tmp9_, (glong) _tmp10_, (glong) _tmp11_);
	result = _tmp12_;
	return result;
}


/**
 * Appends `new_segment` to the end of the character data.
 *
 * Version: DOM Level 1 Core<<BR>>
 * URL: [[http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-32791A2F]]
 *
 * @param new_segment The new data that will be appended at the end
 */
void gxml_xcharacter_data_append_data (GXmlxCharacterData* self, const gchar* new_segment) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_segment != NULL);
	_tmp0_ = gxml_xcharacter_data_get_data (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = new_segment;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	gxml_xcharacter_data_set_data (self, _tmp4_);
	_g_free0 (_tmp4_);
}


/**
 * Inserts `new_segment` into the character data at `offset`.
 *
 * Version: DOM Level 1 Core<<BR>>
 * URL: [[http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-3EDB695F]]
 *
 * @param offset The index where the new data will be inserted
 * @param new_segment The new data to be inserted
 */
void gxml_xcharacter_data_insert_data (GXmlxCharacterData* self, gulong offset, const gchar* new_segment) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gulong _tmp4_ = 0UL;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gulong _tmp8_ = 0UL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gulong _tmp14_ = 0UL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_segment != NULL);
	_tmp0_ = gxml_xcharacter_data_get_data (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = offset;
	_tmp5_ = gxml_xcharacter_data_check_index_size (self, "insert_data", _tmp3_, _tmp4_, NULL);
	if (!_tmp5_) {
		return;
	}
	_tmp6_ = gxml_xcharacter_data_get_data (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = offset;
	_tmp9_ = string_substring (_tmp7_, (glong) 0, (glong) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = new_segment;
	_tmp12_ = gxml_xcharacter_data_get_data (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = offset;
	_tmp15_ = string_substring (_tmp13_, (glong) _tmp14_, (glong) (-1));
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat (_tmp10_, _tmp11_, _tmp16_, NULL);
	_tmp18_ = _tmp17_;
	gxml_xcharacter_data_set_data (self, _tmp18_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp10_);
}


/**
 * Deletes a range of characters, `count`-characters long, starting from `offset`.
 *
 * Version: DOM Level 1 Core<<BR>>
 * URL: [[http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-7C603781]]
 *
 * @param offset The index of the first character in the range to be deleted
 * @param count The length in characters of the range to be deleted
 */
void gxml_xcharacter_data_delete_data (GXmlxCharacterData* self, gulong offset, gulong count) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gulong _tmp4_ = 0UL;
	gulong _tmp5_ = 0UL;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gulong _tmp9_ = 0UL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gulong _tmp14_ = 0UL;
	gulong _tmp15_ = 0UL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gxml_xcharacter_data_get_data (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = offset;
	_tmp5_ = count;
	_tmp6_ = gxml_xcharacter_data_check_index_size (self, "delete_data", _tmp3_, _tmp4_, &_tmp5_);
	if (!_tmp6_) {
		return;
	}
	_tmp7_ = gxml_xcharacter_data_get_data (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = offset;
	_tmp10_ = string_substring (_tmp8_, (glong) 0, (glong) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = gxml_xcharacter_data_get_data (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = offset;
	_tmp15_ = count;
	_tmp16_ = string_substring (_tmp13_, (glong) (_tmp14_ + _tmp15_), (glong) (-1));
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat (_tmp11_, _tmp17_, NULL);
	_tmp19_ = _tmp18_;
	gxml_xcharacter_data_set_data (self, _tmp19_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp11_);
}


/**
 * Replaces a range of characters, `count`-characters
 * long, starting at `offset`, with `new_segment`.
 *
 * Version: DOM Level 1 Core<<BR>>
 * URL: [[http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-E5CBA7FB]]
 *
 * @param offset The index of the first character in the range that will be replaced
 * @param count The length in characters of the range that will be replaced
 * @param new_segment The text that will be added
 */
void gxml_xcharacter_data_replace_data (GXmlxCharacterData* self, gulong offset, gulong count, const gchar* new_segment) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gulong _tmp4_ = 0UL;
	gulong _tmp5_ = 0UL;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gulong _tmp9_ = 0UL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gulong _tmp15_ = 0UL;
	gulong _tmp16_ = 0UL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_segment != NULL);
	_tmp0_ = gxml_xcharacter_data_get_data (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = offset;
	_tmp5_ = count;
	_tmp6_ = gxml_xcharacter_data_check_index_size (self, "replace_data", _tmp3_, _tmp4_, &_tmp5_);
	if (!_tmp6_) {
		return;
	}
	_tmp7_ = gxml_xcharacter_data_get_data (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = offset;
	_tmp10_ = string_substring (_tmp8_, (glong) 0, (glong) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = new_segment;
	_tmp13_ = gxml_xcharacter_data_get_data (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = offset;
	_tmp16_ = count;
	_tmp17_ = string_substring (_tmp14_, (glong) (_tmp15_ + _tmp16_), (glong) (-1));
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat (_tmp11_, _tmp12_, _tmp18_, NULL);
	_tmp20_ = _tmp19_;
	gxml_xcharacter_data_set_data (self, _tmp20_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp11_);
}


const gchar* gxml_xcharacter_data_get_data (GXmlxCharacterData* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gxml_xnode_get_node_value ((GXmlxNode*) self);
	_tmp1_ = _tmp0_;
	result = _tmp1_;
	return result;
}


void gxml_xcharacter_data_set_data (GXmlxCharacterData* self, const gchar* value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = gxml_xnode_check_read_only ((GXmlxNode*) self);
	if (!_tmp0_) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = value;
		gxml_xnode_set_node_value ((GXmlxNode*) self, _tmp1_);
	}
	g_object_notify ((GObject *) self, "data");
}


gulong gxml_xcharacter_data_get_length (GXmlxCharacterData* self) {
	gulong result;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, 0UL);
	_tmp0_ = gxml_xcharacter_data_get_data (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	result = (gulong) _tmp3_;
	return result;
}


static void gxml_xcharacter_data_set_length (GXmlxCharacterData* self, gulong value) {
	g_return_if_fail (self != NULL);
	g_object_notify ((GObject *) self, "length");
}


static void gxml_xcharacter_data_class_init (GXmlxCharacterDataClass * klass) {
	gxml_xcharacter_data_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_gxml_xcharacter_data_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gxml_xcharacter_data_set_property;
	/**
	 * The character data in string form for the node.
	 * Generally equivalent to node_value.
	 *
	 * Version: DOM Level 1 Core<<BR>>
	 * URL: [[http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-72AB8359]]
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_XCHARACTER_DATA_DATA, g_param_spec_string ("data", "data", "data", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The number of characters.
	 *
	 * Version: DOM Level 1 Core<<BR>>
	 * URL: [[http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-7D61178C]]
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_XCHARACTER_DATA_LENGTH, g_param_spec_ulong ("length", "length", "length", 0, G_MAXULONG, 0UL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gxml_xcharacter_data_instance_init (GXmlxCharacterData * self) {
}


/**
 * CharacterData defines an interface for manipulating XML character data.
 *
 * It is used by the {@link GXml.xCDATASection},
 * {@link GXml.Text}, and {@link GXml.Comment} node types.
 *
 * Version: DOM Level 1 Core<<BR>>
 * URL: [[http://www.w3.org/TR/DOM-Level-1/level-one-core.html#ID-FF21A306]]
 */
GType gxml_xcharacter_data_get_type (void) {
	static volatile gsize gxml_xcharacter_data_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_xcharacter_data_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlxCharacterDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gxml_xcharacter_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GXmlxCharacterData), 0, (GInstanceInitFunc) gxml_xcharacter_data_instance_init, NULL };
		GType gxml_xcharacter_data_type_id;
		gxml_xcharacter_data_type_id = g_type_register_static (GXML_TYPE_BACKED_NODE, "GXmlxCharacterData", &g_define_type_info, 0);
		g_once_init_leave (&gxml_xcharacter_data_type_id__volatile, gxml_xcharacter_data_type_id);
	}
	return gxml_xcharacter_data_type_id__volatile;
}


static void _vala_gxml_xcharacter_data_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GXmlxCharacterData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GXML_TYPE_XCHARACTER_DATA, GXmlxCharacterData);
	switch (property_id) {
		case GXML_XCHARACTER_DATA_DATA:
		g_value_set_string (value, gxml_xcharacter_data_get_data (self));
		break;
		case GXML_XCHARACTER_DATA_LENGTH:
		g_value_set_ulong (value, gxml_xcharacter_data_get_length (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gxml_xcharacter_data_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GXmlxCharacterData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GXML_TYPE_XCHARACTER_DATA, GXmlxCharacterData);
	switch (property_id) {
		case GXML_XCHARACTER_DATA_DATA:
		gxml_xcharacter_data_set_data (self, g_value_get_string (value));
		break;
		case GXML_XCHARACTER_DATA_LENGTH:
		gxml_xcharacter_data_set_length (self, g_value_get_ulong (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



