/* libxml-NodeList.c generated by valac 0.28.1, the Vala compiler
 * generated from libxml-NodeList.vala, do not modify */

/* NodeList.vala
 *
 * Copyright (C) 2011-2013  Richard Schwarting <aquarichy@gmail.com>
 * Copyright (C) 2013-2015  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Authors:
 *      Richard Schwarting <aquarichy@gmail.com>
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define GXML_TYPE_XNODE_LIST (gxml_xnode_list_get_type ())
#define GXML_XNODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_XNODE_LIST, GXmlxNodeList))
#define GXML_IS_XNODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_XNODE_LIST))
#define GXML_XNODE_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_XNODE_LIST, GXmlxNodeListIface))

typedef struct _GXmlxNodeList GXmlxNodeList;
typedef struct _GXmlxNodeListIface GXmlxNodeListIface;

#define GXML_TYPE_XNODE (gxml_xnode_get_type ())
#define GXML_XNODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_XNODE, GXmlxNode))
#define GXML_XNODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_XNODE, GXmlxNodeClass))
#define GXML_IS_XNODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_XNODE))
#define GXML_IS_XNODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_XNODE))
#define GXML_XNODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_XNODE, GXmlxNodeClass))

typedef struct _GXmlxNode GXmlxNode;
typedef struct _GXmlxNodeClass GXmlxNodeClass;

struct _GXmlxNodeListIface {
	GTypeInterface parent_iface;
	GXmlxNode* (*item) (GXmlxNodeList* self, gulong idx);
	GXmlxNode* (*insert_before) (GXmlxNodeList* self, GXmlxNode* new_child, GXmlxNode* ref_child);
	GXmlxNode* (*replace_child) (GXmlxNodeList* self, GXmlxNode* new_child, GXmlxNode* old_child);
	GXmlxNode* (*remove_child) (GXmlxNodeList* self, GXmlxNode* old_child);
	GXmlxNode* (*append_child) (GXmlxNodeList* self, GXmlxNode* new_child);
	gchar* (*to_string) (GXmlxNodeList* self, gboolean in_line);
	GXmlxNode* (*first) (GXmlxNodeList* self);
	GXmlxNode* (*last) (GXmlxNodeList* self);
	GXmlxNode* (*get) (GXmlxNodeList* self, gint n);
	gulong (*get_length) (GXmlxNodeList* self);
	void (*set_length) (GXmlxNodeList* self, gulong value);
};



GType gxml_xnode_get_type (void) G_GNUC_CONST;
GType gxml_xnode_list_get_type (void) G_GNUC_CONST;
GXmlxNode* gxml_xnode_list_item (GXmlxNodeList* self, gulong idx);
GXmlxNode* gxml_xnode_list_insert_before (GXmlxNodeList* self, GXmlxNode* new_child, GXmlxNode* ref_child);
GXmlxNode* gxml_xnode_list_replace_child (GXmlxNodeList* self, GXmlxNode* new_child, GXmlxNode* old_child);
GXmlxNode* gxml_xnode_list_remove_child (GXmlxNodeList* self, GXmlxNode* old_child);
GXmlxNode* gxml_xnode_list_append_child (GXmlxNodeList* self, GXmlxNode* new_child);
gchar* gxml_xnode_list_to_string (GXmlxNodeList* self, gboolean in_line);
GXmlxNode* gxml_xnode_list_first (GXmlxNodeList* self);
GXmlxNode* gxml_xnode_list_last (GXmlxNodeList* self);
GXmlxNode* gxml_xnode_list_get (GXmlxNodeList* self, gint n);
gulong gxml_xnode_list_get_length (GXmlxNodeList* self);
void gxml_xnode_list_set_length (GXmlxNodeList* self, gulong value);


/**
 * Access the idx'th item in the list.
 *
 * Version: DOM Level 1 Core<<BR>>
 * URL: [[http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#method-item]]
 */
GXmlxNode* gxml_xnode_list_item (GXmlxNodeList* self, gulong idx) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_XNODE_LIST_GET_INTERFACE (self)->item (self, idx);
}


GXmlxNode* gxml_xnode_list_insert_before (GXmlxNodeList* self, GXmlxNode* new_child, GXmlxNode* ref_child) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_XNODE_LIST_GET_INTERFACE (self)->insert_before (self, new_child, ref_child);
}


GXmlxNode* gxml_xnode_list_replace_child (GXmlxNodeList* self, GXmlxNode* new_child, GXmlxNode* old_child) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_XNODE_LIST_GET_INTERFACE (self)->replace_child (self, new_child, old_child);
}


GXmlxNode* gxml_xnode_list_remove_child (GXmlxNodeList* self, GXmlxNode* old_child) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_XNODE_LIST_GET_INTERFACE (self)->remove_child (self, old_child);
}


GXmlxNode* gxml_xnode_list_append_child (GXmlxNodeList* self, GXmlxNode* new_child) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_XNODE_LIST_GET_INTERFACE (self)->append_child (self, new_child);
}


/**
 * Creates an XML string representation of the nodes in the list.
 *
 * #todo: write a test
 *
 * @param in_line Whether to parse and expand entities or not
 *
 * @return The list as an XML string
 */
gchar* gxml_xnode_list_to_string (GXmlxNodeList* self, gboolean in_line) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_XNODE_LIST_GET_INTERFACE (self)->to_string (self, in_line);
}


/**
 * Retrieve the first node in the list.  Like {@link GLib.List.first}.
 */
GXmlxNode* gxml_xnode_list_first (GXmlxNodeList* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_XNODE_LIST_GET_INTERFACE (self)->first (self);
}


/**
 * Retrieve the last node in the list.  Like {@link GLib.List.last}.
 */
GXmlxNode* gxml_xnode_list_last (GXmlxNodeList* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_XNODE_LIST_GET_INTERFACE (self)->last (self);
}


/**
 * Obtain the n'th item in the list. Like {@link GLib.List.nth}.
 *
 * @param n The index of the item to access
 */
GXmlxNode* gxml_xnode_list_get (GXmlxNodeList* self, gint n) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_XNODE_LIST_GET_INTERFACE (self)->get (self, n);
}


gulong gxml_xnode_list_get_length (GXmlxNodeList* self) {
	g_return_val_if_fail (self != NULL, 0UL);
	return GXML_XNODE_LIST_GET_INTERFACE (self)->get_length (self);
}


void gxml_xnode_list_set_length (GXmlxNodeList* self, gulong value) {
	g_return_if_fail (self != NULL);
	GXML_XNODE_LIST_GET_INTERFACE (self)->set_length (self, value);
}


static void gxml_xnode_list_base_init (GXmlxNodeListIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		 * The number of nodes contained within this list
		 *
		 * Version: DOM Level 1 Core<<BR>>
		 * URL: [[http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#attribute-length]]
		 */
		g_object_interface_install_property (iface, g_param_spec_ulong ("length", "length", "length", 0, G_MAXULONG, 0UL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	}
}


/**
 * DOM API. Interface to access a list of nodes.
   *
   * A live list used to store {@link GXml.xNode}s.
 *
 * Usually contains the children of a {@link GXml.xNode}, or
 * the results of {@link GXml.xElement.get_elements_by_tag_name}.
 * {@link GXml.NodeList} implements both the DOM Level 1 Core API for
 * a NodeList, as well as the {@link GLib.List} API, to make
 * it more accessible and familiar to GLib programmers.
 * Implementing classes also implement {@link Gee.Iterable}, to make
 * iteration in supporting languages (like Vala) nice and
 * easy.
 *
 * Version: DOM Level 1 Core<<BR>>
 * URL: [[http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-536297177]]
 */
GType gxml_xnode_list_get_type (void) {
	static volatile gsize gxml_xnode_list_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_xnode_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlxNodeListIface), (GBaseInitFunc) gxml_xnode_list_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gxml_xnode_list_type_id;
		gxml_xnode_list_type_id = g_type_register_static (G_TYPE_INTERFACE, "GXmlxNodeList", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gxml_xnode_list_type_id, G_TYPE_OBJECT);
		g_type_interface_add_prerequisite (gxml_xnode_list_type_id, GEE_TYPE_ITERABLE);
		g_type_interface_add_prerequisite (gxml_xnode_list_type_id, GEE_TYPE_COLLECTION);
		g_once_init_leave (&gxml_xnode_list_type_id__volatile, gxml_xnode_list_type_id);
	}
	return gxml_xnode_list_type_id__volatile;
}



