/* SerializableProperty.c generated by valac 0.34.6, the Vala compiler
 * generated from SerializableProperty.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */
/* SerializableProperty.vala
 *
 * Copyright (C) 2015  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define GXML_TYPE_SERIALIZABLE_PROPERTY (gxml_serializable_property_get_type ())
#define GXML_SERIALIZABLE_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE_PROPERTY, GXmlSerializableProperty))
#define GXML_IS_SERIALIZABLE_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE_PROPERTY))
#define GXML_SERIALIZABLE_PROPERTY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_SERIALIZABLE_PROPERTY, GXmlSerializablePropertyIface))

typedef struct _GXmlSerializableProperty GXmlSerializableProperty;
typedef struct _GXmlSerializablePropertyIface GXmlSerializablePropertyIface;

#define GXML_TYPE_NODE (gxml_node_get_type ())
#define GXML_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NODE, GXmlNode))
#define GXML_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NODE))
#define GXML_NODE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NODE, GXmlNodeIface))

typedef struct _GXmlNode GXmlNode;
typedef struct _GXmlNodeIface GXmlNodeIface;

#define GXML_TYPE_ELEMENT_LIST (gxml_element_list_get_type ())
#define GXML_ELEMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ELEMENT_LIST, GXmlElementList))
#define GXML_ELEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_ELEMENT_LIST, GXmlElementListClass))
#define GXML_IS_ELEMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ELEMENT_LIST))
#define GXML_IS_ELEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_ELEMENT_LIST))
#define GXML_ELEMENT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_ELEMENT_LIST, GXmlElementListClass))

typedef struct _GXmlElementList GXmlElementList;
typedef struct _GXmlElementListClass GXmlElementListClass;

#define GXML_TYPE_NAMESPACE (gxml_namespace_get_type ())
#define GXML_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NAMESPACE, GXmlNamespace))
#define GXML_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NAMESPACE))
#define GXML_NAMESPACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NAMESPACE, GXmlNamespaceIface))

typedef struct _GXmlNamespace GXmlNamespace;
typedef struct _GXmlNamespaceIface GXmlNamespaceIface;

#define GXML_TYPE_NODE_TYPE (gxml_node_type_get_type ())

#define GXML_TYPE_DOCUMENT (gxml_document_get_type ())
#define GXML_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOCUMENT, GXmlDocument))
#define GXML_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOCUMENT))
#define GXML_DOCUMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOCUMENT, GXmlDocumentIface))

typedef struct _GXmlDocument GXmlDocument;
typedef struct _GXmlDocumentIface GXmlDocumentIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GXML_TYPE_ELEMENT (gxml_element_get_type ())
#define GXML_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ELEMENT, GXmlElement))
#define GXML_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ELEMENT))
#define GXML_ELEMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_ELEMENT, GXmlElementIface))

typedef struct _GXmlElement GXmlElement;
typedef struct _GXmlElementIface GXmlElementIface;

#define GXML_TYPE_ATTRIBUTE (gxml_attribute_get_type ())
#define GXML_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ATTRIBUTE, GXmlAttribute))
#define GXML_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ATTRIBUTE))
#define GXML_ATTRIBUTE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_ATTRIBUTE, GXmlAttributeIface))

typedef struct _GXmlAttribute GXmlAttribute;
typedef struct _GXmlAttributeIface GXmlAttributeIface;

struct _GXmlNamespaceIface {
	GTypeInterface parent_iface;
	gchar* (*get_uri) (GXmlNamespace* self);
	gchar* (*get_prefix) (GXmlNamespace* self);
};

typedef enum  {
	GXML_NODE_TYPE_INVALID = 0,
	GXML_NODE_TYPE_ELEMENT = 1,
	GXML_NODE_TYPE_ATTRIBUTE,
	GXML_NODE_TYPE_TEXT,
	GXML_NODE_TYPE_CDATA_SECTION,
	GXML_NODE_TYPE_ENTITY_REFERENCE,
	GXML_NODE_TYPE_ENTITY,
	GXML_NODE_TYPE_PROCESSING_INSTRUCTION,
	GXML_NODE_TYPE_COMMENT,
	GXML_NODE_TYPE_DOCUMENT,
	GXML_NODE_TYPE_DOCUMENT_TYPE,
	GXML_NODE_TYPE_DOCUMENT_FRAGMENT,
	GXML_NODE_TYPE_NOTATION
} GXmlNodeType;

struct _GXmlDocumentIface {
	GTypeInterface parent_iface;
	GXmlNode* (*create_element) (GXmlDocument* self, const gchar* name, GError** error);
	GXmlNode* (*create_text) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_comment) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_cdata) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_pi) (GXmlDocument* self, const gchar* target, const gchar* data);
	gboolean (*save) (GXmlDocument* self, GCancellable* cancellable, GError** error);
	gboolean (*save_as) (GXmlDocument* self, GFile* f, GCancellable* cancellable, GError** error);
	gboolean (*get_indent) (GXmlDocument* self);
	void (*set_indent) (GXmlDocument* self, gboolean value);
	gboolean (*get_ns_top) (GXmlDocument* self);
	void (*set_ns_top) (GXmlDocument* self, gboolean value);
	gboolean (*get_prefix_default_ns) (GXmlDocument* self);
	void (*set_prefix_default_ns) (GXmlDocument* self, gboolean value);
	gboolean (*get_backup) (GXmlDocument* self);
	void (*set_backup) (GXmlDocument* self, gboolean value);
	GXmlNode* (*get_root) (GXmlDocument* self);
	GFile* (*get_file) (GXmlDocument* self);
	void (*set_file) (GXmlDocument* self, GFile* value);
};

struct _GXmlNodeIface {
	GTypeInterface parent_iface;
	GXmlNode* (*get) (GXmlNode* self, const gchar* key);
	GXmlElementList* (*get_elements_by_property_value) (GXmlNode* self, const gchar* property, const gchar* value);
	GXmlElementList* (*get_elements_by_name) (GXmlNode* self, const gchar* name);
	GXmlElementList* (*get_elements_by_name_ns) (GXmlNode* self, const gchar* name, const gchar* ns);
	gchar* (*to_string) (GXmlNode* self);
	gboolean (*set_namespace) (GXmlNode* self, const gchar* uri, const gchar* prefix);
	gchar* (*ns_prefix) (GXmlNode* self);
	gchar* (*ns_uri) (GXmlNode* self);
	GeeList* (*get_namespaces) (GXmlNode* self);
	GeeBidirList* (*get_children_nodes) (GXmlNode* self);
	GeeMap* (*get_attrs) (GXmlNode* self);
	gchar* (*get_name) (GXmlNode* self);
	gchar* (*get_value) (GXmlNode* self);
	void (*set_value) (GXmlNode* self, const gchar* value);
	GXmlNodeType (*get_type_node) (GXmlNode* self);
	GXmlDocument* (*get_document) (GXmlNode* self);
	GXmlNode* (*get_parent) (GXmlNode* self);
};

struct _GXmlSerializablePropertyIface {
	GTypeInterface parent_iface;
	gchar* (*get_serializable_property_value) (GXmlSerializableProperty* self);
	void (*set_serializable_property_value) (GXmlSerializableProperty* self, const gchar* val);
	gboolean (*deserialize_property) (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error);
	GXmlNode* (*serialize_property) (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error);
};

struct _GXmlElementIface {
	GTypeInterface parent_iface;
	void (*normalize) (GXmlElement* self);
	void (*set_attr) (GXmlElement* self, const gchar* name, const gchar* value);
	GXmlNode* (*get_attr) (GXmlElement* self, const gchar* name);
	void (*remove_attr) (GXmlElement* self, const gchar* name);
	void (*remove_ns_attr) (GXmlElement* self, const gchar* name, const gchar* uri);
	void (*set_ns_attr) (GXmlElement* self, const gchar* ns, const gchar* name, const gchar* value);
	GXmlNode* (*get_ns_attr) (GXmlElement* self, const gchar* name, const gchar* uri);
	gchar* (*get_tag_name) (GXmlElement* self);
	gchar* (*get_content) (GXmlElement* self);
	void (*set_content) (GXmlElement* self, const gchar* value);
};

struct _GXmlAttributeIface {
	GTypeInterface parent_iface;
	GXmlNamespace* (*get_namespace) (GXmlAttribute* self);
	void (*set_namespace) (GXmlAttribute* self, GXmlNamespace* value);
	gchar* (*get_prefix) (GXmlAttribute* self);
};



GType gxml_element_list_get_type (void) G_GNUC_CONST;
GType gxml_namespace_get_type (void) G_GNUC_CONST;
GType gxml_node_type_get_type (void) G_GNUC_CONST;
GType gxml_document_get_type (void) G_GNUC_CONST;
GType gxml_node_get_type (void) G_GNUC_CONST;
GType gxml_serializable_property_get_type (void) G_GNUC_CONST;
gchar* gxml_serializable_property_get_serializable_property_value (GXmlSerializableProperty* self);
void gxml_serializable_property_set_serializable_property_value (GXmlSerializableProperty* self, const gchar* val);
gboolean gxml_serializable_property_deserialize_property (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error);
static gboolean gxml_serializable_property_real_deserialize_property (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error);
gboolean gxml_serializable_property_default_serializable_property_deserialize_property (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error);
GXmlNode* gxml_serializable_property_serialize_property (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error);
static GXmlNode* gxml_serializable_property_real_serialize_property (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error);
GXmlNode* gxml_serializable_property_default_serializable_property_serialize_property (GXmlSerializableProperty* self, GXmlNode* element, GParamSpec* prop, gboolean nick, GError** error);
GType gxml_element_get_type (void) G_GNUC_CONST;
void gxml_element_set_attr (GXmlElement* self, const gchar* name, const gchar* value);
GType gxml_attribute_get_type (void) G_GNUC_CONST;
gchar* gxml_node_get_name (GXmlNode* self);
gchar* gxml_node_get_value (GXmlNode* self);


/**
  * Value to be set to a {@link GXml.Attribute}, to be added to a {@link GXml.Element}
  */
gchar* gxml_serializable_property_get_serializable_property_value (GXmlSerializableProperty* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_PROPERTY_GET_INTERFACE (self)->get_serializable_property_value (self);
}


/**
  * Set value to be set to a {@link GXml.Attribute}, to be added to a {@link GXml.Element}
  *
  * If value is set to @null then the property will be ignored by default and no
  * property will be set to given {@link GXml.Element}.
  *
  * Some implementations stores the value without any convertion at all; then if the value,
  * from XML property, makes no sense for the property type, you should take care
  * to use the provided API from them to convert it.
  */
void gxml_serializable_property_set_serializable_property_value (GXmlSerializableProperty* self, const gchar* val) {
	g_return_if_fail (self != NULL);
	GXML_SERIALIZABLE_PROPERTY_GET_INTERFACE (self)->set_serializable_property_value (self, val);
}


/**
   * Tryies to deserialize from a {@link GXml.Node} searching a {@link GXml.Attribute}
   * with the name provided in @param prop or its nick if @nick is true,
   * if not set, then {@link GLib.ParamSpec} name should used. If @param nick is set to true,
   * then {@link GLib.ParamSpec} nick is used as name.
   */
static gboolean gxml_serializable_property_real_deserialize_property (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GXmlNode* _tmp1_ = NULL;
	GParamSpec* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (property_node != NULL, FALSE);
	g_return_val_if_fail (prop != NULL, FALSE);
	_tmp1_ = property_node;
	_tmp2_ = prop;
	_tmp3_ = nick;
	_tmp4_ = gxml_serializable_property_default_serializable_property_deserialize_property (self, _tmp1_, _tmp2_, _tmp3_, &_inner_error_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_propagate_error (error, _inner_error_);
		return _tmp5_;
	}
	result = _tmp0_;
	return result;
}


gboolean gxml_serializable_property_deserialize_property (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_PROPERTY_GET_INTERFACE (self)->deserialize_property (self, property_node, prop, nick, error);
}


/**
   * Serialization method to add a {@link GXml.Attribute} to a {@link GXml.Element}, using {@link GLib.ParamSpec}
   * name or nick, if @param nick is set to true, as the attribute's name.
   *
   * If {@link GXml.SerializableProperty.get_serializable_property_value} returns null
   * given {@link GXml.Node} should not be modified.
   */
static GXmlNode* gxml_serializable_property_real_serialize_property (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error) {
	GXmlNode* result = NULL;
	GXmlNode* _tmp0_ = NULL;
	GXmlNode* _tmp1_ = NULL;
	GParamSpec* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GXmlNode* _tmp4_ = NULL;
	GXmlNode* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (property_node != NULL, NULL);
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp1_ = property_node;
	_tmp2_ = prop;
	_tmp3_ = nick;
	_tmp4_ = gxml_serializable_property_default_serializable_property_serialize_property (self, _tmp1_, _tmp2_, _tmp3_, &_inner_error_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp5_;
	_g_object_unref0 (_tmp0_);
	return result;
}


GXmlNode* gxml_serializable_property_serialize_property (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_PROPERTY_GET_INTERFACE (self)->serialize_property (self, property_node, prop, nick, error);
}


/**
   * Default serialization method to add a {@link GXml.Attribute} to a {@link GXml.Element}
   *
   * If {@link GXml.SerializableProperty.get_serializable_property_value} returns null
   * given {@link GXml.Node} is not modified.
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GXmlNode* gxml_serializable_property_default_serializable_property_serialize_property (GXmlSerializableProperty* self, GXmlNode* element, GParamSpec* prop, gboolean nick, GError** error) {
	GXmlNode* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gchar* name = NULL;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	GXmlNode* _tmp19_ = NULL;
	GXmlNode* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	GXmlNode* _tmp27_ = NULL;
	GXmlNode* _tmp28_ = NULL;
	g_return_val_if_fail (element != NULL, NULL);
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp0_ = gxml_serializable_property_get_serializable_property_value (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ == NULL;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		GXmlNode* _tmp3_ = NULL;
		GXmlNode* _tmp4_ = NULL;
		_tmp3_ = element;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = g_strdup ("");
	name = _tmp5_;
	_tmp8_ = nick;
	if (_tmp8_) {
		GParamSpec* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		_tmp9_ = prop;
		_tmp10_ = g_param_spec_get_nick (_tmp9_);
		_tmp7_ = _tmp10_ != NULL;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		GParamSpec* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		_tmp11_ = prop;
		_tmp12_ = g_param_spec_get_nick (_tmp11_);
		_tmp6_ = g_strcmp0 (_tmp12_, "") != 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GParamSpec* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		_tmp13_ = prop;
		_tmp14_ = g_param_spec_get_nick (_tmp13_);
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (name);
		name = _tmp15_;
	} else {
		GParamSpec* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		_tmp16_ = prop;
		_tmp17_ = g_param_spec_get_name (_tmp16_);
		_tmp18_ = g_strdup (_tmp17_);
		_g_free0 (name);
		name = _tmp18_;
	}
	_tmp19_ = element;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, GXML_TYPE_ELEMENT)) {
		const gchar* _tmp20_ = NULL;
		GXmlNode* _tmp21_ = NULL;
		GXmlNode* _tmp22_ = NULL;
		_tmp20_ = _ ("Trying to serialize to a non GXmlElement!");
		g_warning ("SerializableProperty.vala:91: %s", _tmp20_);
		_tmp21_ = element;
		_tmp22_ = _g_object_ref0 (_tmp21_);
		result = _tmp22_;
		_g_free0 (name);
		return result;
	}
	_tmp23_ = element;
	_tmp24_ = name;
	_tmp25_ = gxml_serializable_property_get_serializable_property_value (self);
	_tmp26_ = _tmp25_;
	gxml_element_set_attr (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GXML_TYPE_ELEMENT, GXmlElement), _tmp24_, _tmp26_);
	_g_free0 (_tmp26_);
	_tmp27_ = element;
	_tmp28_ = _g_object_ref0 (_tmp27_);
	result = _tmp28_;
	_g_free0 (name);
	return result;
}


/**
   * Tryies to deserialize from a {@link GXml.Node} searching a {@link GXml.Attribute}
   * with the name in @param prop or from its nick if @nick is true.
   */
gboolean gxml_serializable_property_default_serializable_property_deserialize_property (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error) {
	gboolean result = FALSE;
	GXmlAttribute* attr = NULL;
	GXmlNode* _tmp0_ = NULL;
	GXmlAttribute* _tmp3_ = NULL;
	GXmlAttribute* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gchar* name = NULL;
	gchar* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	GXmlAttribute* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gboolean _tmp35_ = FALSE;
	g_return_val_if_fail (property_node != NULL, FALSE);
	g_return_val_if_fail (prop != NULL, FALSE);
	attr = NULL;
	_tmp0_ = property_node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GXML_TYPE_ATTRIBUTE)) {
		GXmlNode* _tmp1_ = NULL;
		GXmlAttribute* _tmp2_ = NULL;
		_tmp1_ = property_node;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GXML_TYPE_ATTRIBUTE, GXmlAttribute));
		_g_object_unref0 (attr);
		attr = _tmp2_;
	}
	_tmp3_ = attr;
	if (_tmp3_ == NULL) {
		result = FALSE;
		_g_object_unref0 (attr);
		return result;
	}
	_tmp4_ = attr;
	_tmp5_ = gxml_node_get_name ((GXmlNode*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_ == NULL;
	_g_free0 (_tmp7_);
	if (_tmp8_) {
		const gchar* _tmp9_ = NULL;
		GType _tmp10_ = 0UL;
		const gchar* _tmp11_ = NULL;
		_tmp9_ = _ ("XML Attribute name is not set, when deserializing to: %s");
		_tmp10_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
		_tmp11_ = g_type_name (_tmp10_);
		g_warning (_tmp9_, _tmp11_);
		result = FALSE;
		_g_object_unref0 (attr);
		return result;
	}
	_tmp12_ = g_strdup ("");
	name = _tmp12_;
	_tmp15_ = nick;
	if (_tmp15_) {
		GParamSpec* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		_tmp16_ = prop;
		_tmp17_ = g_param_spec_get_nick (_tmp16_);
		_tmp14_ = _tmp17_ != NULL;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		GParamSpec* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		_tmp18_ = prop;
		_tmp19_ = g_param_spec_get_nick (_tmp18_);
		_tmp13_ = g_strcmp0 (_tmp19_, "") != 0;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		GParamSpec* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		_tmp20_ = prop;
		_tmp21_ = g_param_spec_get_nick (_tmp20_);
		_tmp22_ = g_strdup (_tmp21_);
		_g_free0 (name);
		name = _tmp22_;
	} else {
		GParamSpec* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		_tmp23_ = prop;
		_tmp24_ = g_param_spec_get_name (_tmp23_);
		_tmp25_ = g_strdup (_tmp24_);
		_g_free0 (name);
		name = _tmp25_;
	}
	_tmp26_ = attr;
	_tmp27_ = gxml_node_get_name ((GXmlNode*) _tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = _tmp28_;
	_tmp30_ = g_utf8_strdown (_tmp29_, (gssize) -1);
	_tmp31_ = _tmp30_;
	_tmp32_ = name;
	_tmp33_ = g_utf8_strdown (_tmp32_, (gssize) -1);
	_tmp34_ = _tmp33_;
	_tmp35_ = g_strcmp0 (_tmp31_, _tmp34_) == 0;
	_g_free0 (_tmp34_);
	_g_free0 (_tmp31_);
	_g_free0 (_tmp29_);
	if (_tmp35_) {
		GXmlAttribute* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		_tmp36_ = attr;
		_tmp37_ = gxml_node_get_value ((GXmlNode*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = _tmp38_;
		gxml_serializable_property_set_serializable_property_value (self, _tmp39_);
		_g_free0 (_tmp39_);
	}
	result = TRUE;
	_g_free0 (name);
	_g_object_unref0 (attr);
	return result;
}


static void gxml_serializable_property_base_init (GXmlSerializablePropertyIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		iface->deserialize_property = gxml_serializable_property_real_deserialize_property;
		iface->serialize_property = gxml_serializable_property_real_serialize_property;
	}
}


/**
 * Represent any property to be added as a {@link GXml.Attribute} to a {@link GXml.Element}
 *
 * The actual value stored and returned by {@link GXml.SerializableProperty.get_serializable_property_value}
 * is the actual string in the XML property, this means may the value could differ from the spected value
 * on some implementations like {@link GXml.SerializableInt}. Take a look in each implementations about
 * retured values.
 *
 * Implementations of {@link GXml.SerializableProperty}, could be used to provide more flexibility
 * when parsing {@link GXml.Attribute} properties values and to exclude to be serialized if they have not
 * been created in the holding objects.
 */
GType gxml_serializable_property_get_type (void) {
	static volatile gsize gxml_serializable_property_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_serializable_property_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlSerializablePropertyIface), (GBaseInitFunc) gxml_serializable_property_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gxml_serializable_property_type_id;
		gxml_serializable_property_type_id = g_type_register_static (G_TYPE_INTERFACE, "GXmlSerializableProperty", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gxml_serializable_property_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gxml_serializable_property_type_id__volatile, gxml_serializable_property_type_id);
	}
	return gxml_serializable_property_type_id__volatile;
}



