/* gxml-0.14.vapi generated by valac 0.34.7, do not modify. */

[CCode (gir_namespace = "GXml", gir_version = "0.14")]
namespace GXml {
	/**
	 * Base class for collections implemeting {@link GomCollection}, priving basic
	 * infrastructure.
	 *
	 * Collections properties should be initialized with current container element
	 * in order to be able to add new references to elements. Use {@link initialize_element}
	 * to set parent element and {@link search} to find elements for collection.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public abstract class BaseCollection : GLib.Object {
		/**
		 * Element used to refer of containier element. You should define it at construction time
		 * our set it as a construction property.
		 */
		protected GXml.GomElement _element;
		/**
		 * Local name of {@link DomElement} objects of {@link element}, which could be
		 * contained in this collection.
		 *
		 * Used when reading to add elements to collection. You can set it at construction time,
		 * by, for example, instantaiting a object of the type {@link GomCollection.items_type}
		 * then use {@link GomElement.local_name}'s value.
		 */
		protected string _items_name;
		/**
		 * Objects' type to be referenced by this collection and to deserialize objects.
		 * Derived classes, can initilize this value at constructor or as construct property.
		 *
		 * Used when reading and at initialization time, to know {@link GomElement.local_name}
		 * at runtime.
		 */
		protected GLib.Type _items_type;
		/**
		 * A collection of node's index refered. Don't modify it manually.
		 */
		protected GLib.Queue<int> _nodes_index;
		public BaseCollection ();
		/**
		 * Adds an {@link DomElement} of type {@link GomObject} as a child of
		 * {@link element}.
		 *
		 * Object is always added as a child of {@link element}
		 * but just added to collection if {@link validate_append} returns true;
		 */
		public void append (GXml.DomElement node) throws GLib.Error;
		/**
		 * {@inheritDoc}
		 */
		public void initialize (GLib.Type items_type) throws GLib.Error;
		/**
		 * Initialize an {@link GomCollection} to use an element as children's parent.
		 * Searchs for all nodes, calling {@link GomCollection.search}
		 * with {@link GomCollection.items_type}, using its
		 * {@link DomElement.local_name} to find it.
		 *
		 * Implemenation classes, should initialize collection to hold a {@link GomElement}
		 * derived type using {@link GomCollection.initialize}.
		 */
		public void initialize_element (GXml.GomElement e) throws GLib.Error;
		/**
		 * Search for all child nodes in {@link element} of type {@link GomElement}
		 * with a {@link GomElement.local_name} equal to {@link GomCollection.items_name},
		 * to add it to collection.
		 *
		 * Implementations could add additional restrictions to add element to collection.
		 */
		public void search () throws GLib.Error;
		/**
		 * {@inheritDoc}
		 */
		public abstract bool validate_append (int index, GXml.DomElement element) throws GLib.Error;
		/**
		 * {@inheritDoc}
		 */
		public GXml.GomElement element { get; set construct; }
		/**
		 * {@inheritDoc}
		 */
		public string items_name { get; }
		/**
		 * {@inheritDoc}
		 */
		public GLib.Type items_type { get; set construct; }
		/**
		 * {@inheritDoc}
		 */
		public GLib.Queue<int> nodes_index { get; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class DomCustomEventInit : GXml.DomEventInit {
		public DomCustomEventInit ();
		public GLib.Value? detail { get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class DomElementList : Gee.ArrayList<GXml.DomElement>, GXml.DomHTMLCollection {
		public DomElementList ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class DomErrorName : GLib.Object {
		public DomErrorName ();
		public int get_code (string error_name);
		public string get_name (int error_code);
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class DomEventInit : GLib.Object {
		public DomEventInit ();
		public bool bubbles { get; set; }
		public bool cancelable { get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class DomMutationObserverInit : GLib.Object {
		public DomMutationObserverInit ();
		public Gee.List<string> attribute_filter { get; set; }
		public bool attribute_old_value { get; set; }
		public bool attributes { get; set; }
		public bool character_data { get; set; }
		public bool character_data_old_value { get; set; }
		public bool child_list { get; set; }
		public bool subtree { get; set; }
	}
	/**
	 * No implemented jet. This can lead to API changes in future versions.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class DomNodeFilter : GLib.Object {
		public delegate int AcceptNode (GXml.Node node);
		public const int FILTER_ACCEPT;
		public const int FILTER_REJECT;
		public const int FILTER_SKIP;
		public const int SHOW_ALL;
		public const int SHOW_ATTRIBUTE;
		public const int SHOW_CDATA_SECTION;
		public const int SHOW_COMMENT;
		public const int SHOW_DOCUMENT;
		public const int SHOW_DOCUMENT_FRAGMENT;
		public const int SHOW_DOCUMENT_TYPE;
		public const int SHOW_ELEMENT;
		public const int SHOW_ENTITY;
		public const int SHOW_ENTITY_REFERENCE;
		public const int SHOW_NOTATION;
		public const int SHOW_PROCESSING_INSTRUCTION;
		public const int SHOW_TEXT;
		public DomNodeFilter ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class DomTimeStamp : GLib.Object {
		public DomTimeStamp ();
		public string to_string ();
		public GLib.DateTime time { get; set; }
	}
	/**
	 * Convenient class for a list of {@link GXml.Element} objects based on
	 * {@link Gee.ArrayList}, with good support for bindings.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class ElementList : Gee.ArrayList<GXml.Element>, GXml.DomHTMLCollection {
		public ElementList ();
	}
	/**
	 * Convenient static methods for enumeration serialization to string.
	 * 
	 * Enumerations have a set of utility methods to better represent on
	 * serialisation/deserialization.
	 * 
	 * Enumerations could be converted to string using its definition on {@link GLib.EnumClass},
	 * by taking its nick name directly or converting to its camel case representation.
	 * 
	 * Any enumeration value type in a <code>GLib.Object</code>'s property could be
	 * deserialized from its definition given on {@link GLib.EnumClass} (name and
	 * nick) or from its camel case representation.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class Enumeration {
		public Enumeration ();
		/**
		 * Introspect an enumeration to get value's nick name.
		 *
		 * Returns: an string representing an enumeration's value.
		 *
		 * @param enumeration a {@link GLib.Type} of type {@link GLib.Type.ENUM}
		 * @param val an integer to parse an enum value of type @enumeration.
		 */
		public static string get_nick (GLib.Type enumeration, int val) throws GLib.Error;
		/**
		 * Introspect an enumeration to get value's nick name and transform
		 * to camel case representation.
		 *
		 * Returns: an string representing an enumeration's value.
		 *
		 * @param enumeration a {@link GLib.Type} of type {@link GLib.Type.ENUM}
		 * @param val an integer to parse an enum value of type @param enumeration.
		 */
		public static string get_nick_camelcase (GLib.Type enumeration, int val) throws GLib.Error;
		/**
		 * Transform enumeration's value to its string representation.
		 *
		 * Returns: an string representing an enumeration's value.
		 *
		 * @param enumeration a {@link GLib.Type} of type {@link GLib.Type.ENUM}
		 * @param val an integer to parse an enum value of type @enumeration.
		 * @param use_nick makes to returns value's nick name in {@link GLib.EnumClass}
		 * @param camelcase makes to returns value's nick name in {@link GLib.EnumClass}
		 * as camel case representation. If @use_nick is set this take no effect.
		 */
		public static string get_string (GLib.Type enumeration, int val, bool use_nick = false, bool camelcase = false) throws GLib.Error;
		/**
		 * Parse @val to an enumeration's value.
		 * 
		 * Returns: an {@link GLib.EnumValue} representing an enumeration's value.
		 * 
		 * @param enumeration a {@link GLib.Type} of type {@link GLib.Type.ENUM}
		 * @param val a string to parse an enum value of type @param enumeration.
		 * as camel case representation. If @use_nick is set this take no effect.
		 */
		public static GLib.EnumValue? parse (GLib.Type enumeration, string val) throws GLib.Error;
		/**
		 * From a integer valuer calculates a valid {@link GLib.EnumValue} for a
		 * {@link GLib.Type}. 
		 *
		 * Returns: a {@link GLib.EnumValue} or null if fails.
		 *
		 * @param enumeration a {@link GLib.Type} of type {@link GLib.Type.ENUM}
		 * @param val an integer in a valid range in the enumeration.
		 */
		public static GLib.EnumValue? parse_integer (GLib.Type enumeration, int val);
		/**
		 * Transform an enumeration in an array of {@link GLib.EnumValue}.
		 * 
		 * Returns: an array of {@link GLib.EnumValue} representing an enumeration.
		 * 
		 * @param enumeration a {@link GLib.Type} of type {@link GLib.Type.ENUM}
		 */
		public static unowned GLib.EnumValue[] to_array (GLib.Type enumeration);
		/**
		 * Transform an enumeration in an array of strings representing enumeration values.
		 *
		 * Returns: an array of strings representing an enumeration.
		 *
		 * @param enumeration a {@link GLib.Type} of type {@link GLib.Type.ENUM}
		 */
		public static string[] to_string_array (GLib.Type enumeration) throws GLib.Error;
	}
	/**
	 * Class implemeting {@link GXml.Attribute} interface, not tied to libxml-2.0 library.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GAttribute : GXml.GNode, GXml.Attribute, GXml.DomAttr {
		public GAttribute (GXml.GDocument doc, Xml.Attr* node);
		public override Gee.List<GXml.Namespace> namespaces { owned get; }
		public override GXml.Node parent { owned get; }
	}
	/**
	 * Class implemeting {@link GXml.CDATA} interface, not tied to libxml-2.0 library.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GCDATA : GXml.GNode, GXml.CDATA {
		public GCDATA (GXml.GDocument doc, Xml.Node* node);
		public override string name { owned get; }
	}
	/**
	 * Base class for character data
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GCharacterData : GXml.GNonDocumentChildNode, GXml.Character, GXml.DomCharacterData {
		public GCharacterData ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GChildNode : GXml.GNode, GXml.DomChildNode {
		public GChildNode ();
	}
	/**
	 * Class implemeting {@link GXml.Comment} interface, not tied to libxml-2.0 library.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GComment : GXml.GCharacterData, GXml.Comment, GXml.DomComment {
		public GComment (GXml.GDocument doc, Xml.Node* node);
		public override string name { owned get; }
	}
	/**
	 * Class implemeting {@link GXml.Document} interface, not tied to libxml-2.0 library.
	 *
	 * This class use {@link Xml.TextWriter} to write down XML documents using
	 * its contained {@link GXml.Node} children or other XML structures.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GDocument : GXml.GNode, GXml.Document, GXml.DomParentNode, GXml.DomNonElementParentNode, GXml.DomDocument, GXml.DomXMLDocument, GXml.XPathContext {
		protected Xml.Buffer _buffer;
		protected string _character_set;
		protected string _compat_mode;
		protected GXml.DomEvent _constructor;
		protected string _content_type;
		protected GXml.GImplementation _implementation;
		protected string _origin;
		protected string _url;
		protected Xml.Doc* doc;
		public GDocument ();
		public GDocument.from_doc (Xml.Doc doc);
		public GDocument.from_file (GLib.File file, int options = 0, GLib.Cancellable? cancel = null) throws GLib.Error;
		public GDocument.from_path (string path, int options = 0) throws GLib.Error;
		public GDocument.from_stream (GLib.InputStream istream) throws GLib.Error;
		public GDocument.from_string (string str, int options = 0) throws GLib.Error;
		public GDocument.from_uri (string uri, int options = 0) throws GLib.Error;
		/**
		 * Uses libxml2 internal dump to memory function over owned 
		 */
		public string libxml_to_string ();
		public virtual bool save (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual bool save_as (GLib.File f, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public override bool set_namespace (string uri, string? prefix);
		public override string to_string ();
		public override Gee.Map<string,GXml.Node> attrs { owned get; }
		public override Gee.BidirList<GXml.Node> children_nodes { owned get; }
		public override GXml.Document document { get; }
		public override Gee.List<GXml.Namespace> namespaces { owned get; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GDocumentFragment : GXml.GDocument, GXml.DomDocumentFragment {
		public GDocumentFragment (GXml.GDocument d);
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GDocumentType : GXml.GChildNode, GXml.DomNode, GXml.DomChildNode, GXml.DomDocumentType {
		protected string _name;
		protected string _public_id;
		protected string _system_id;
		public GDocumentType ();
		public GDocumentType.with_ids (string name, string public_id, string system_id);
		public GDocumentType.with_name (string name);
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GDomCustomEvent : GXml.GDomEvent {
		protected GLib.Value? _detail;
		public GDomCustomEvent ();
		public void init_custom_event (string type, bool bubbles, bool cancelable, GLib.Value? detail);
		public GLib.Value? detail { get; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GDomEvent : GLib.Object, GXml.DomEvent {
		protected bool _bubbles;
		protected bool _cancelable;
		protected GXml.DomEventTarget _current_target;
		protected bool _default_prevented;
		protected string _etype;
		protected GXml.DomEvent.Phase _event_phase;
		protected GXml.DomEventTarget _event_target;
		protected GXml.DomEvent.Flags _flags;
		protected bool _is_trusted;
		protected GXml.DomTimeStamp _time_stamp;
		public GDomEvent ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GDomHTMLCollection : Gee.ArrayList<GXml.DomElement>, GXml.DomHTMLCollection {
		public GDomHTMLCollection ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GDomNodeIterator : GLib.Object, GXml.DomNodeIterator {
		protected GXml.DomNodeFilter _filter;
		protected bool _pointer_before_reference_node;
		protected GXml.DomNode _reference_node;
		protected GXml.DomNode _root;
		protected int _what_to_show;
		public GDomNodeIterator (GXml.DomNode n, int what_to_show, GXml.DomNodeFilter filter);
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GDomRange : GLib.Object, GXml.DomRange {
		protected bool _collapse;
		protected GXml.DomNode _common_ancestor_container;
		protected GXml.DomDocument _document;
		protected GXml.DomNode _end_container;
		protected int _end_offset;
		protected GXml.DomNode _start_container;
		protected int _start_offset;
		public GDomRange (GXml.DomDocument doc);
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GDomSettableTokenList : GXml.GDomTokenList, GXml.DomSettableTokenList {
		public GDomSettableTokenList (GXml.DomElement e, string? attr);
	}
	/**
	 * List of string tokens.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GDomTokenList : Gee.ArrayList<string>, GXml.DomTokenList {
		protected string _attr;
		protected GXml.DomElement _element;
		public GDomTokenList (GXml.DomElement e, string? attr);
		public void update ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GDomTreeWalker : GLib.Object, GXml.DomTreeWalker {
		protected GXml.DomNode _current_node;
		protected GXml.DomNodeFilter? _filter;
		protected GXml.DomNode _root;
		protected int _what_to_show;
		public GDomTreeWalker (GXml.DomNode r, int w, GXml.DomNodeFilter f);
	}
	/**
	 * Class implemeting {@link GXml.Element} interface, not tied to libxml-2.0 library.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GElement : GXml.GNonDocumentChildNode, GXml.DomParentNode, GXml.DomElement, GXml.Element, GXml.XPathContext {
		public GElement (GXml.GDocument doc, Xml.Node* node);
		public override string to_string ();
		public override string value { owned get; set; }
	}
	/**
	 * Implementation of {@link Gee.AbstractMap} to handle {@link Xml.Node} attributes
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GHashMapAttr : Gee.AbstractMap<string,GXml.Node>, GXml.DomNamedNodeMap {
		public class Entry : Gee.Map.Entry<string,GXml.Node> {
			public Entry (GXml.GDocument doc, Xml.Attr* attr);
			public override string key { get; }
			public override bool read_only { get; }
			public override GXml.Node value { get; set; }
		}
		public class Iterator : GLib.Object, Gee.MapIterator<string,GXml.Node> {
			public Iterator (GXml.GDocument doc, Xml.Node* node);
		}
		public GHashMapAttr (GXml.GDocument doc, Xml.Node* node);
		public override void clear ();
		public override GXml.Node @get (string key);
		public override bool has (string key, GXml.Node value);
		public override bool has_key (string key);
		public override Gee.MapIterator<string,GXml.Node> map_iterator ();
		public override void @set (string key, GXml.Node value);
		public override bool unset (string key, out GXml.Node value = null);
		public override Gee.Set<Gee.Map.Entry<string,GXml.Node>> entries { owned get; }
		public override Gee.Set<string> keys { owned get; }
		public override bool read_only { get; }
		public override int size { get; }
		public override Gee.Collection<GXml.Node> values { owned get; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GImplementation : GLib.Object, GXml.DomImplementation {
		public GImplementation ();
	}
	/**
	 * A {@link Gee.AbstractBidirList} implementation to access {@link Xml.Node} collection
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GListChildren : Gee.AbstractBidirList<GXml.Node>, GXml.DomNodeList, GXml.DomHTMLCollection {
		public class Iterator : GLib.Object, Gee.Traversable<GXml.Node>, Gee.Iterator<GXml.Node>, Gee.BidirIterator<GXml.Node>, Gee.ListIterator<GXml.Node>, Gee.BidirListIterator<GXml.Node> {
			public Iterator (GXml.GDocument doc, Xml.Node* node);
		}
		public GListChildren (GXml.GDocument doc, Xml.Node* node);
		public override bool add (GXml.Node item);
		public override new Gee.BidirListIterator<GXml.Node> bidir_list_iterator ();
		public override void clear ();
		public override bool contains (GXml.Node item);
		public override GXml.Node @get (int index);
		public override int index_of (GXml.Node item);
		/**
		 * Insert @item before @index
		 */
		public override void insert (int index, GXml.Node item);
		public override Gee.Iterator<GXml.Node> iterator ();
		public override Gee.ListIterator<GXml.Node> list_iterator ();
		public override bool remove (GXml.Node item);
		/**
		 * Removes a node at @index. This method never returns a valid pointer.
		 */
		public override GXml.Node remove_at (int index);
		/**
		 * This method is ignored by default.
		 */
		public override void @set (int index, GXml.Node item);
		public override Gee.List<GXml.Node>? slice (int start, int stop);
		public override bool read_only { get; }
		public override int size { get; }
	}
	/**
	 * A {@link Gee.AbstractList} implementation to access {@link Xml.Ns} namespaces collection
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GListNamespaces : Gee.AbstractList<GXml.Namespace> {
		public class Iterator : GLib.Object, Gee.Traversable<GXml.Namespace>, Gee.Iterator<GXml.Namespace>, Gee.ListIterator<GXml.Namespace> {
			public Iterator (Xml.Node* node);
		}
		public GListNamespaces (GXml.GDocument doc, Xml.Node* node);
		public override bool add (GXml.Namespace item);
		public override void clear ();
		public override bool contains (GXml.Namespace item);
		public override new GXml.Namespace @get (int index);
		public override int index_of (GXml.Namespace item);
		public override void insert (int index, GXml.Namespace item);
		public override Gee.Iterator<GXml.Namespace> iterator ();
		public override Gee.ListIterator<GXml.Namespace> list_iterator ();
		public override bool remove (GXml.Namespace item);
		public override GXml.Namespace remove_at (int index);
		public override new void @set (int index, GXml.Namespace item);
		public override Gee.List<GXml.Namespace>? slice (int start, int stop);
		public override bool read_only { get; }
		public override int size { get; }
	}
	/**
	 * Class implemeting {@link GXml.Namespace}
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GNamespace : GLib.Object, GXml.Namespace {
		public GNamespace (Xml.Ns* ns);
		public Xml.Ns* get_internal_ns ();
	}
	/**
	 * Base interface providing basic functionalities to all GXml interfaces.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public abstract class GNode : GLib.Object, GXml.DomEventTarget, GXml.DomNode, GXml.Node {
		protected string _base_uri;
		protected GXml.GDocument _doc;
		protected Xml.Node* _node;
		public GNode ();
		public Xml.Node* get_internal_node ();
		public virtual bool set_namespace (string uri, string? prefix);
		public static GXml.Node to_gnode (GXml.GDocument doc, Xml.Node* node);
		public virtual string to_string ();
		public virtual Gee.Map<string,GXml.Node> attrs { owned get; }
		public virtual Gee.BidirList<GXml.Node> children_nodes { owned get; }
		public virtual GXml.Document document { get; }
		public virtual string name { owned get; }
		public virtual Gee.List<GXml.Namespace> namespaces { owned get; }
		public virtual GXml.Node parent { owned get; }
		public virtual GXml.NodeType type_node { get; }
		public virtual string value { owned get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GNonDocumentChildNode : GXml.GChildNode, GXml.DomNonDocumentTypeChildNode {
		public GNonDocumentChildNode ();
	}
	/**
	 * Class implemeting {@link GXml.ProcessingInstruction} interface, not tied to libxml-2.0 library.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GProcessingInstruction : GXml.GCharacterData, GXml.ProcessingInstruction, GXml.DomProcessingInstruction {
		public GProcessingInstruction (GXml.GDocument doc, Xml.Node* node);
	}
	/**
	 * Class implemeting {@link GXml.Text} interface, not tied to libxml-2.0 library.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GText : GXml.GCharacterData, GXml.Text, GXml.DomText {
		public GText (GXml.GDocument doc, Xml.Node* node);
		public override string name { owned get; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GXPathObject : GLib.Object, GXml.XPathObject {
		public GXPathObject (GXml.GDocument document, Xml.XPath.Object* pointer);
	}
	/**
	 * A class impementing {@link GomCollection} to store references to
	 * child {@link DomElement} of {@link GomCollection.element}, using an index.
	 *
	 * {{{
	 *   public class YourObject : GomElement {
	 *    [Description (nick="::Name")]
	 *    public string name { get; set; }
	 *   }
	 *   public class YourList : GomArrayList {
	 *    construct {
	 *      try { initialize (typeof (YourObject)); }
	 *      catch (GLib.Error e) {
	 *        warning ("Initialization error for collection type: %s : %s"
	 *             .printf (get_type ().name(), e.message));
	 *      }
	 *    }
	 *   }
	 * }}}
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomArrayList : GXml.BaseCollection, GXml.GomCollection {
		public GomArrayList ();
	}
	/**
	 * Convenient class to handle a {@link GomElement}'s attribute
	 * using a list of pre-defined and unmutable values.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomArrayString : GXml.GomBaseProperty {
		protected string _value;
		protected string[] _values;
		public GomArrayString ();
		public unowned string[] get_values ();
		/**
		 * Convenient method to initialize array of values from an array of strings.
		 * Values are taken and should not be freed after call initialization.
		 */
		public void initialize_strings (owned string[] strs);
		/**
		 * Returns true if current value in attribute is included
		 * in the array of values.
		 */
		public bool is_valid_value ();
		/**
		 * Check if string is in array
		 */
		public bool search (string str);
		/**
		 * Select one string from array at index:
		 */
		public void select (int index);
		/**
		 * {inheritDoc}
		 */
		public override string? value { owned get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomAttr : GXml.GomNode, GXml.DomAttr {
		protected string _namespace_uri;
		public GomAttr (GXml.DomElement element, string name, string value);
		public GomAttr.@namespace (GXml.DomElement element, string namespace_uri, string? prefix, string name, string value);
	}
	/**
	 * Base class for properties implementing {@link GomProperty} interface.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public abstract class GomBaseProperty : GLib.Object, GXml.GomProperty {
		public GomBaseProperty ();
		/**
		 * Takes a string and check if it can be valid for this property.
		 */
		public virtual bool validate_value (string val);
		/**
		 * {@inheritDoc}
		 */
		public abstract string? value { owned get; set; }
	}
	/**
	 * Convenient class to handle {@link GomElement}'s attributes
	 * using a boolean ('true' and 'false') as sources of values.
	 *
	 * Property is represented as a string, using 'true' or 'false'.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomBoolean : GXml.GomBaseProperty {
		protected bool _value;
		public GomBoolean ();
		/**
		 * Retrive current value.
		 */
		public bool get_boolean ();
		/**
		 * Sets current value.
		 */
		public void set_boolean (bool value);
		public override string? value { owned get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomCharacterData : GXml.GomNode, GXml.DomNonDocumentTypeChildNode, GXml.DomChildNode, GXml.DomCharacterData {
		public GomCharacterData ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomComment : GXml.GomCharacterData, GXml.DomComment {
		public GomComment (GXml.DomDocument doc, string data);
	}
	/**
	 * Convenient class to handle {@link GomElement}'s attributes
	 * using a {@link GLib.Date} as sources of values.
	 *
	 * Property is represented as a string using a %Y-%m-%d format
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomDate : GXml.GomBaseProperty {
		protected GLib.Date _value;
		public GomDate ();
		/**
		 * Retrives current value.
		 */
		public GLib.Date get_date ();
		/**
		 * Sets current value.
		 */
		public void set_date (GLib.Date date);
		public override string? value { owned get; set; }
	}
	/**
	 * Convenient class to handle {@link GomElement}'s attributes
	 * using a {@link GLib.DateTime} as sources of values.
	 *
	 * Timestamp is considered in local time.
	 *
	 * Property is represented as a string using a {@link GomDateTime.format}
	 * and {@link GLib.DateTime.format} method. If {@link GomDateTime.format}
	 * is not set '%FT%T' format is used by default.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomDateTime : GXml.GomBaseProperty {
		protected GLib.DateTime _value;
		public GomDateTime ();
		/**
		 * Retrives current value.
		 */
		public GLib.DateTime get_datetime ();
		/**
		 * Sets current value.
		 */
		public void set_datetime (GLib.DateTime dt);
		public string format { get; set; }
		public override string? value { owned get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomDocument : GXml.GomNode, GXml.DomParentNode, GXml.DomNonElementParentNode, GXml.DomDocument, GXml.DomXMLDocument {
		protected string _character_set;
		protected string _compat_mode;
		protected GXml.DomEvent _constructor;
		protected string _content_type;
		protected GXml.DomImplementation _implementation;
		protected string _origin;
		protected string _url;
		public GomDocument ();
		/**
		 * Creates a document parsing a file.
		 */
		public GomDocument.from_file (GLib.File file) throws GLib.Error;
		public GomDocument.from_path (string path) throws GLib.Error;
		/**
		 * Creates a document parsing a stream.
		 */
		public GomDocument.from_stream (GLib.InputStream stream) throws GLib.Error;
		/**
		 * Creates a document parsing a string.
		 */
		public GomDocument.from_string (string str) throws GLib.Error;
		/**
		 * Creates a document parsing a URI file.
		 */
		public GomDocument.from_uri (string uri) throws GLib.Error;
		/**
		 * Reads a file contents and parse it to document.
		 */
		public void read_from_file (GLib.File file) throws GLib.Error;
		/**
		 * Reads a string and parse it to document.
		 */
		public void read_from_string (string str) throws GLib.Error;
		/**
		 * Writes a dump XML representation of document to a file.
		 */
		public void write_file (GLib.File file) throws GLib.Error;
		/**
		 * Writes a dump XML representation of document to a stream.
		 */
		public void write_stream (GLib.OutputStream stream) throws GLib.Error;
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomDocumentFragment : GXml.GomNode, GXml.DomParentNode, GXml.DomNonElementParentNode, GXml.DomDocumentFragment {
		public GomDocumentFragment (GXml.DomDocument doc);
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomDocumentType : GXml.GomNode, GXml.DomNode, GXml.DomChildNode, GXml.DomDocumentType {
		protected string _name;
		protected string _public_id;
		protected string _system_id;
		public GomDocumentType ();
		public GomDocumentType.with_ids (GXml.DomDocument doc, string name, string public_id, string system_id);
		public GomDocumentType.with_name (GXml.DomDocument doc, string name);
	}
	/**
	 * Convenient class to handle {@link GomElement}'s attributes
	 * using double pressition floats as sources of values.
	 *
	 * Property is represented as a string.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomDouble : GXml.GomBaseProperty {
		protected double _value;
		public GomDouble ();
		/**
		 * Retrive current value.
		 */
		public double get_double ();
		/**
		 * Sets current value.
		 */
		public void set_double (double value);
		/**
		 * Set number of decimals to write out as {@link GomElement}'s property.
		 * Default is 4.
		 */
		public uint decimals { get; set; }
		public override string? value { owned get; set; }
	}
	/**
	 * A GXml Object Model (GOM) implementation of {@link GomElement}.It can be used
	 * transparently as {@link DomElement} in a XML tree.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomElement : GXml.GomNode, GXml.DomChildNode, GXml.DomNonDocumentTypeChildNode, GXml.DomParentNode, GXml.DomElement, GXml.GomObject {
		/**
		 * Holds attributes in current node, using attribute's name as key
		 * and it's value as value. Appends namespace prefix to attribute's name as
		 * key if a namespaced attribute.
		 */
		public class Attributes : Gee.HashMap<string,string>, GXml.DomNamedNodeMap {
			/**
			 * Holds {@link GomElement} refrence to attributes' parent element.
			 * Derived classes should not modify, but set at construction time.
			 */
			protected GXml.GomElement _element;
			public Attributes (GXml.GomElement element);
		}
		/**
		 * Reference to {@link Attributes} for element's attributes.
		 * Derived classes should avoid to modify it.
		 */
		protected GXml.GomElement.Attributes _attributes;
		/**
		 * Use this field to set node's namespace URI. Can used to set it at construction time.
		 */
		protected string _namespace_uri;
		public GomElement ();
		/**
		 * Convenient function to initialize, at construction time, a {@link GomElement}
		 * using given local name. If {@link GomElement.initialize_with_namespace}
		 * has been called in any base class, this method just change elment node's name
		 * and keeps previous namespace and prefix.
		 *
		 * No {@link DomDocument} is set by default, if this is a top level element in a
		 * document, you can call {@link DomNode.owner_document} to set one if not set
		 * already.
		 *
		 * Any instance properties of type {@link GomElement} or {@link GomCollection}
		 * should be initialized using {@link GomObject.set_instance_property}
		 */
		public void initialize (string local_name);
		/**
		 * Convenient function to initialize, at construction time, a {@link GomElement}
		 * using given local name and document.
		 */
		public void initialize_document (GXml.DomDocument doc, string local_name);
		/**
		 * Convenient function to initialize, at construction time, a {@link GomElement}
		 * using given local name, document and namespace.
		 */
		public void initialize_document_with_namespace (GXml.DomDocument doc, string? namespace_uri, string? prefix, string local_name);
		/**
		 * Convenient function to initialize, at construction time, a {@link GomElement}
		 * using given local name and namespace.
		 */
		public void initialize_with_namespace (string? namespace_uri, string? prefix, string local_name);
		public new string? lookup_namespace_uri (string? prefix);
		public new string? lookup_prefix (string? nspace);
		/**
		 * Parses an XML file, deserializing it over {@link GomElement}.
		 */
		public void read_from_file (GLib.File f, GLib.Cancellable? cancellable = null) throws GLib.Error;
		/**
		 * Parses an XML over a {@link GLib.InputStream}, deserializing it over {@link GomElement}.
		 */
		public void read_from_stream (GLib.InputStream istream, GLib.Cancellable? cancellable = null) throws GLib.Error;
		/**
		 * Parses an XML string, deserializing it over {@link GomElement}.
		 */
		public void read_from_string (string str) throws GLib.Error;
		/**
		 * Parsing a URI file.
		 */
		public void read_from_uri (string uri) throws GLib.Error;
		/**
		 * Uses element's {@link GomDocument} to write an XML to a file, serializing it.
		 */
		public void write_file (GLib.File f) throws GLib.Error;
		/**
		 * Uses element's {@link GomDocument} to write an XML to a stream, serializing it.
		 */
		public void write_stream (GLib.OutputStream stream) throws GLib.Error;
		/**
		 * Serialize {@link GomElement} to a string.
		 */
		public string write_string () throws GLib.Error;
	}
	/**
	 * Convenient class to handle {@link GomElement}'s attributes
	 * using a {@link GLib.Type.ENUM} as a source of values.
	 *
	 * Enumeration is represented as a string, using its name, independent of
	 * value possition in enumeration.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomEnum : GXml.GomBaseProperty {
		protected GLib.Type _enum_type;
		protected int _value;
		public GomEnum ();
		/**
		 * Retrive current value.
		 */
		public int get_enum ();
		/**
		 * Convenient method to initialize internal enum type.
		 */
		public void initialize_enum (GLib.Type enum_type);
		/**
		 * Sets current value.
		 */
		public void set_enum (int value);
		/**
		 * Enum type used by property.
		 */
		public GLib.Type enum_type { get; set construct; }
		public override string? value { owned get; set; }
	}
	/**
	 * Convenient class to handle {@link GomElement}'s attributes
	 * using floats as sources of values.
	 *
	 * Property is represented as a string.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomFloat : GXml.GomDouble {
		public GomFloat ();
		/**
		 * Retrive current value.
		 */
		public float get_float ();
		/**
		 * Sets current value.
		 */
		public void set_float (float value);
	}
	/**
	 * A class impementing {@link GomCollection} to store references to
	 * child {@link DomElement} of {@link GomCollection.element}, using an attribute in
	 * items as key or {@link MappeableElement.get_map_key} method if implemented
	 * by items to be added. If key is not defined in node, it is not added; but
	 * keeps it as a child node of actual {@link GomCollection.element}.
	 *
	 * If {@link GomElement} to be added is of type {@link GomCollection.items_type}
	 * and implements {@link MappeableElement}, you should set {@link GomHashMap.attribute_key}
	 * to null in order to use returned value of {@link MappeableElement.get_map_key}
	 * as key.
	 *
	 * {{{
	 *   public class YourObject : GomElement {
	 *    [Description (nick="::Name")]
	 *    public string name { get; set; }
	 *   }
	 *   public class YourList : GomHashMap {
	 *    construct {
	 *      try { initialize_with_key (typeof (YourObject),"Name"); }
	 *      catch (GLib.Error e) {
	 *        warning ("Initialization error for collection type: %s : %s"
	 *             .printf (get_type ().name(), e.message));
	 *      }
	 *    }
	 *   }
	 * }}}
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomHashMap : GXml.BaseCollection, GXml.GomCollection {
		/**
		 * Element's attribute name used to refer of container's element.
		 * You should define it at construction time
		 * our set it as a construction property.
		 */
		protected string _attribute_key;
		/**
		 * A hashtable with all keys as string to node's index refered. Don't modify it manually.
		 */
		protected GLib.HashTable<string,int> _hashtable;
		public GomHashMap ();
		/**
		 * Returns an {@link DomElement} in the collection using a string key.
		 */
		public new GXml.DomElement? @get (string key);
		/**
		 * Returns list of keys used in collection.
		 */
		public GLib.List<string> get_keys ();
		/**
		 * Returns true if @key is used in collection.
		 */
		public bool has_key (string key);
		/**
		 * Convenient function to initialize a {@link GomHashMap} collection, using
		 * given element, items' type and name.
		 */
		public void initialize_element_with_key (GXml.GomElement element, GLib.Type items_type, string attribute_key) throws GLib.Error;
		/**
		 * Convenient function to initialize a {@link GomHashMap} collection, using
		 * given element, items' type and name.
		 *
		 * Using this method at construction time of derived classes.
		 */
		public void initialize_with_key (GLib.Type items_type, string attribute_key) throws GLib.Error;
		/**
		 * An attribute's name in items to be added and used to retrieve elements
		 * as key.
		 */
		public string attribute_key { get; set construct; }
	}
	/**
	 * A class impementing {@link GomCollection} to store references to
	 * child {@link DomElement} of {@link GomCollection.element}, using two attributes in
	 * items as primary and secondary keys or {@link MappeableElementPairKey.get_map_primary_key}
	 * and {@link MappeableElementPairKey.get_map_secondary_key} methods if
	 * {@link MappeableElementPairKey} is implemented
	 * by items to be added. If one or both keys are not defined in node,
	 * it is not added; but keeps it as a child node of actual
	 * {@link GomCollection.element}.
	 *
	 * If {@link GomElement} to be added is of type {@link GomCollection.items_type}
	 * and implements {@link MappeableElementPairKey}, you should set
	 * {@link attribute_primary_key} and {@link attribute_secondary_key}
	 * to null in order to use returned value of {@link MappeableElementPairKey.get_map_primary_key}
	 * and {@link MappeableElementPairKey.get_map_secondary_key}
	 * as keys.
	 *
	 * {{{
	 *   public class YourObject : GomElement {
	 *    [Description (nick="::Name")]
	 *    public string name { get; set; }
	 *    public string code { get; set; }
	 *   }
	 *   public class YourList : GomHashPairedMap {
	 *    construct {
	 *      try { initialize_with_key (typeof (YourObject),"Name"); }
	 *      catch (GLib.Error e) {
	 *        warning ("Initialization error for collection type: %s : %s"
	 *             .printf (get_type ().name(), e.message));
	 *      }
	 *    }
	 *   }
	 * }}}
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomHashPairedMap : GXml.BaseCollection, GXml.GomCollection {
		/**
		 * Element's attribute name used to refer of container's element as primery key.
		 * You should define it at construction time
		 * our set it as a construction property.
		 */
		protected string _attribute_primary_key;
		/**
		 * Element's attribute name used to refer of container's element as secondary key.
		 * You should define it at construction time
		 * our set it as a construction property.
		 */
		protected string _attribute_secondary_key;
		/**
		 * A hashtable with all keys as string to node's index refered. Don't modify it manually.
		 */
		protected GLib.HashTable<string,GLib.HashTable<string,int>> _hashtable;
		public GomHashPairedMap ();
		/**
		 * Returns an {@link DomElement} in the collection using given string keys.
		 */
		public new GXml.DomElement? @get (string primary_key, string secondary_key);
		/**
		 * Returns list of primary keys used in collection.
		 */
		public GLib.List<string> get_primary_keys ();
		/**
		 * Returns list of secondary keys used in collection with @pkey as primary key.
		 */
		public GLib.List<string> get_secondary_keys (string pkey);
		/**
		 * Returns true if @key is used in collection as primery key.
		 */
		public bool has_primary_key (string key);
		/**
		 * Returns true if @key is used in collection as secondary key
		 * with @pkey as primary.
		 */
		public bool has_secondary_key (string pkey, string key);
		/**
		 * Convenient function to initialize a {@link GomHashMap} collection, using
		 * given element, items' type and name.
		 */
		public void initialize_element_with_keys (GXml.GomElement element, GLib.Type items_type, string attribute_primary_key, string attribute_secondary_key) throws GLib.Error;
		/**
		 * Convenient function to initialize a {@link GomHashMap} collection, using
		 * given element, items' type and name.
		 *
		 * Using this method at construction time of derived classes.
		 */
		public void initialize_with_keys (GLib.Type items_type, string attribute_primary_key, string attribute_secondary_key) throws GLib.Error;
		/**
		 * An attribute's name in items to be added and used to retrieve elements
		 * as primary key.
		 */
		public string attribute_primary_key { get; set construct; }
		/**
		 * An attribute's name in items to be added and used to retrieve elements
		 * as secondary key.
		 */
		public string attribute_secondary_key { get; set construct; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomImplementation : GLib.Object, GXml.DomImplementation {
		public GomImplementation ();
	}
	/**
	 * Convenient class to handle {@link GomElement}'s attributes
	 * using a integers as sources of values.
	 *
	 * Property is represented as a string.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomInt : GXml.GomBaseProperty {
		protected int _value;
		public GomInt ();
		/**
		 * Retrive current value.
		 */
		public int get_integer ();
		/**
		 * Sets current value.
		 */
		public void set_integer (int value);
		public override string? value { owned get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomNode : GLib.Object, GXml.DomEventTarget, GXml.DomNode {
		/**
		 * Use this field to set node's base URI. Can be set at construction time.
		 *
		 * See [[https://www.w3.org/TR/dom/#concept-node-base-url]]
		 */
		protected string _base_uri;
		/**
		 * Use this field to set node's child nodes. Derived classes should avoid to modify it.
		 */
		protected GXml.GomNodeList _child_nodes;
		protected GXml.DomDocument _document;
		/**
		 * Use this field to set node's local name. Can be set at construction time.
		 */
		protected string _local_name;
		/**
		 * Use this field to set node's Type. Derived classes should avoid to modify it.
		 */
		protected GXml.DomNode.NodeType _node_type;
		/**
		 * Use this field to hold node's value. Can be set at construction time.
		 */
		protected string _node_value;
		/**
		 * Use this field to holding node's parent node. Derived classes should avoid to modify it.
		 */
		protected GXml.DomNode _parent;
		/**
		 * Use this field to set node's prefix. Can be set at construction time.
		 */
		protected string _prefix;
		public GomNode ();
	}
	/**
	 * List of {@link DomNode} implementing {@link DomNodeList}
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomNodeList : Gee.ArrayList<GXml.DomNode>, GXml.DomNodeList {
		public GomNodeList ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomProcessingInstruction : GXml.GomCharacterData, GXml.DomProcessingInstruction {
		public GomProcessingInstruction (GXml.DomDocument doc, string target, string data);
	}
	/**
	 * Convenient class to handle {@link GomElement}'s attributes
	 * using validated string using Regular Expressions.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomString : GXml.GomBaseProperty {
		protected string _value;
		public GomString ();
		public override string? value { owned get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomText : GXml.GomCharacterData, GXml.DomText {
		public GomText (GXml.DomDocument doc, string data);
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdAnnotation : GXml.GomElement {
		public GomXsdAnnotation ();
	}
	/**
	 * Convenient class to handle a {@link GomElement}'s attribute
	 * using a list of pre-defined and unmutable values, taken from
	 * an {@link IXsdSimpleType} definition
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdArrayString : GXml.GomArrayString {
		protected string _simple_type;
		protected GLib.File _source;
		public GomXsdArrayString ();
		/**
		 * Load list of strings from a {@link GLib.File}, parsing using an
		 * {@link GomXsdSchema} object and searching for {@link IXsdSimpleType}
		 * definition with name {@link simple_type}.
		 */
		public void load () throws GLib.Error;
		/**
		 * Name of {@link IXsdSimpleType} to use as source.
		 */
		public string simple_type { get; set; }
		/**
		 * A {@link GLib.File} source to read from, simple type definitions in
		 * an XSD file type.
		 */
		public GLib.File source { get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdAttribute : GXml.GomXsdBaseAttribute {
		public GomXsdAttribute ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdAttributeGroup : GXml.GomXsdBaseAttribute {
		public GomXsdAttributeGroup ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdBaseAttribute : GXml.GomElement {
		public GomXsdBaseAttribute ();
		public GXml.GomXsdAnnotation anotation { get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdBaseContent : GXml.GomElement {
		public GomXsdBaseContent ();
		public GXml.GomXsdAnnotation anotation { get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdBaseType : GXml.GomElement {
		public GomXsdBaseType ();
		public GXml.GomXsdAnnotation anotation { get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdComplexContent : GXml.GomXsdBaseContent {
		public GomXsdComplexContent ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdComplexType : GXml.GomXsdBaseType {
		protected GXml.GomXsdList _group_attributes;
		protected GXml.GomXsdList _type_attributes;
		public GomXsdComplexType ();
		/**
		 * attribute name = abstract
		 */
		public bool @abstract { get; set; }
		/**
		 * (#all | List of (extension | restriction))
		 */
		public string block { get; set; }
		/**
		 * A {@link GomXsdComplexType} or {@link GomXsdSimpleType}
		 */
		public GXml.GomXsdBaseContent content_type { get; set; }
		/**
		 * defaultAttributesApply
		 */
		public bool default_attributes_apply { get; set; }
		/**
		 * (#all | List of (extension | restriction))
		 */
		public string final { get; set; }
		/**
		 * List of group {@link GomXsdAttribute} definitions
		 */
		public GXml.GomXsdList group_attributes { get; }
		public bool mixed { get; set; }
		public string name { get; set; }
		/**
		 * List of type {@link GomXsdAttribute} definitions
		 */
		public GXml.GomXsdList type_attributes { get; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdElement : GXml.GomElement {
		public GomXsdElement ();
		/**
		 * attribute name = abstract
		 */
		[Description (nick = "::abstract")]
		public bool @abstract { get; set; }
		[Description (nick = "::annotation")]
		public GXml.GomXsdAnnotation anotation { get; set; }
		/**
		 * (#all | List of (extension | restriction | substitution))
		 */
		[Description (nick = "::block")]
		public string block { get; set; }
		[Description (nick = "::ComplexType")]
		public GXml.GomXsdComplexType complex_type { get; set; }
		[Description (nick = "::default")]
		public string @default { get; set; }
		/**
		 * (#all | List of (extension | restriction))
		 */
		[Description (nick = "::final")]
		public string final { get; set; }
		[Description (nick = "::fixed")]
		public string fixed { get; set; }
		/**
		 * (qualified | unqualified)
		 */
		[Description (nick = "::form")]
		public string form { get; set; }
		/**
		 * (nonNegativeInteger | unbounded)  : 1
		 */
		[Description (nick = "::maxOccurs")]
		public string max_occurs { get; set; }
		/**
		 * nonNegativeInteger : 1
		 */
		[Description (nick = "::minOccurs")]
		public string min_occurs { get; set; }
		[Description (nick = "::name")]
		public string name { get; set; }
		[Description (nick = "::nillable")]
		public bool nillable { get; set; }
		/**
		 * attribute name = 'type'
		 */
		[Description (nick = "::type")]
		public string object_type { get; set; }
		[Description (nick = "::ref")]
		public string @ref { get; set; }
		[Description (nick = "::SimpleType")]
		public GXml.GomXsdSimpleType simple_type { get; set; }
		/**
		 * substitutionGroup
		 */
		[Description (nick = "::substitutionGroup")]
		public GXml.DomTokenList substitution_group { get; set; }
		/**
		 * targetNamespace
		 */
		[Description (nick = "::targetNamespace")]
		public string target_namespace { get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdExtension : GXml.GomElement {
		public GomXsdExtension ();
		[Description (nick = "::base")]
		public string @base { get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdList : GXml.GomArrayList {
		public GomXsdList ();
		public int index_of (GXml.DomElement element);
		public void remove (int index);
		public int length { get; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdListComplexTypes : GXml.GomXsdList {
		public GomXsdListComplexTypes ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdListElements : GXml.GomXsdList {
		public GomXsdListElements ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdListSimpleTypes : GXml.GomXsdList {
		public GomXsdListSimpleTypes ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdListTypeRestrictionEnumerations : GXml.GomXsdList {
		public GomXsdListTypeRestrictionEnumerations ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdListTypeRestrictionWhiteSpaces : GXml.GomXsdList {
		public GomXsdListTypeRestrictionWhiteSpaces ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdOpenContent : GXml.GomXsdBaseContent {
		public GomXsdOpenContent ();
	}
	/**
	 * Reference interfaces for XSD support.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdSchema : GXml.GomElement {
		public GomXsdSchema ();
		public GXml.GomXsdListComplexTypes complex_type_definitions { get; set; }
		public GXml.GomXsdListElements element_definitions { get; set; }
		public GXml.GomXsdListSimpleTypes simple_type_definitions { get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdSimpleContent : GXml.GomXsdBaseContent {
		public GomXsdSimpleContent ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdSimpleType : GXml.GomElement {
		public GomXsdSimpleType ();
		public GXml.GomXsdAnnotation annotation { get; set; }
		/**
		 * (#all | List of (list | union | restriction | extension))
		 */
		[Description (nick = "::final")]
		public string final { get; set; }
		public GXml.GomXsdTypeList list { get; set; }
		[Description (nick = "::name")]
		public string name { get; set; }
		public GXml.GomXsdTypeRestriction restriction { get; set; }
		public GXml.GomXsdTypeUnion union { get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdTypeDefinition : GXml.GomElement {
		public GomXsdTypeDefinition ();
		public GXml.GomXsdAnnotation annotation { get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdTypeList : GXml.GomXsdTypeDefinition {
		public GomXsdTypeList ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdTypeRestriction : GXml.GomXsdTypeDefinition {
		public GomXsdTypeRestriction ();
		[Description (nick = "::base")]
		public string @base { get; set; }
		public GXml.GomXsdListTypeRestrictionEnumerations enumerations { get; set; }
		public GXml.GomXsdSimpleType simple_type { get; set; }
		public GXml.GomXsdListTypeRestrictionWhiteSpaces white_spaces { get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdTypeRestrictionAssertion : GXml.GomXsdTypeRestrictionDef {
		public GomXsdTypeRestrictionAssertion ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdTypeRestrictionDef : GXml.GomElement {
		public GomXsdTypeRestrictionDef ();
		public GXml.GomXsdAnnotation annotation { get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdTypeRestrictionEnumeration : GXml.GomXsdTypeRestrictionDef {
		public GomXsdTypeRestrictionEnumeration ();
		[Description (nick = "::value")]
		public string value { get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdTypeRestrictionExplicitTimezone : GXml.GomXsdTypeRestrictionDef {
		public GomXsdTypeRestrictionExplicitTimezone ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdTypeRestrictionFractionDigits : GXml.GomXsdTypeRestrictionDef {
		public GomXsdTypeRestrictionFractionDigits ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdTypeRestrictionLength : GXml.GomXsdTypeRestrictionDef {
		public GomXsdTypeRestrictionLength ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdTypeRestrictionMaxExclusive : GXml.GomXsdTypeRestrictionDef {
		public GomXsdTypeRestrictionMaxExclusive ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdTypeRestrictionMaxInclusive : GXml.GomXsdTypeRestrictionDef {
		public GomXsdTypeRestrictionMaxInclusive ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdTypeRestrictionMaxLength : GXml.GomXsdTypeRestrictionDef {
		public GomXsdTypeRestrictionMaxLength ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdTypeRestrictionMinExclusive : GXml.GomXsdTypeRestrictionDef {
		public GomXsdTypeRestrictionMinExclusive ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdTypeRestrictionMinInclusive : GXml.GomXsdTypeRestrictionDef {
		public GomXsdTypeRestrictionMinInclusive ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdTypeRestrictionMinLength : GXml.GomXsdTypeRestrictionDef {
		public GomXsdTypeRestrictionMinLength ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdTypeRestrictionPattern : GXml.GomXsdTypeRestrictionDef {
		public GomXsdTypeRestrictionPattern ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdTypeRestrictionTotalDigits : GXml.GomXsdTypeRestrictionDef {
		public GomXsdTypeRestrictionTotalDigits ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdTypeRestrictionWhiteSpace : GXml.GomXsdTypeRestrictionDef {
		public class Fixed : GXml.GomBoolean {
			public Fixed ();
		}
		public GomXsdTypeRestrictionWhiteSpace ();
		[Description (nick = "::fixed")]
		public GXml.GomXsdTypeRestrictionWhiteSpace.Fixed fixed { get; set; }
		/**
		 * (collapse | preserve | replace)
		 */
		[Description (nick = "::value")]
		public string value { get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class GomXsdTypeUnion : GXml.GomXsdTypeDefinition {
		public GomXsdTypeUnion ();
	}
	/**
	 * HML parsing suport. Document handling
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class HtmlDocument : GXml.GDocument {
		public HtmlDocument ();
		public HtmlDocument.from_file (GLib.File file, int options = 0, GLib.Cancellable? cancel = null) throws GLib.Error;
		public HtmlDocument.from_path (string path, int options = 0) throws GLib.Error;
		public HtmlDocument.from_string (string html, int options = 0);
		public HtmlDocument.from_uri (string uri, int options = 0) throws GLib.Error;
		public static int default_options { get; }
	}
	/**
	 * Convenient class for a list of {@link GXml.Node} objects based on
	 * {@link Gee.ArrayList}, with good support for bindings.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class NodeList : Gee.ArrayList<GXml.Node> {
		public NodeList ();
		public new GXml.Node @get (int index);
		public new GXml.Node[] to_array ();
	}
	/**
	 * Serializable Framework. A {@link Serializable} objects container based on {@link Gee.ArrayList}.
	 * 
	 * It is derived  It implements {@link Serializable} and {@link SerializableCollection}
	 * interfaces.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class SerializableArrayList<G> : Gee.ArrayList<G>, GXml.Serializable, GXml.SerializableCollection {
		protected bool _deserialized;
		protected GXml.Node _node;
		public SerializableArrayList ();
		public bool default_deserialize (GXml.Node node) throws GLib.Error;
		public bool default_deserialize_property (GXml.Node property_node) throws GLib.Error;
		public GXml.Node? default_serialize (GXml.Node node) throws GLib.Error;
		public GXml.Node? default_serialize_property (GXml.Node element, GLib.ParamSpec prop) throws GLib.Error;
		public virtual bool deserialize (GXml.Node node) throws GLib.Error;
		public virtual bool deserialize_children () throws GLib.Error;
		public virtual bool deserialize_node (GXml.Node node) throws GLib.Error;
		public virtual bool deserialize_proceed ();
		public virtual bool deserialize_property (GXml.Node property_node) throws GLib.Error;
		public virtual bool deserialized ();
		public virtual GLib.ParamSpec? find_property_spec (string property_name);
		public virtual GLib.ParamSpec[] list_serializable_properties ();
		public virtual string node_name ();
		public virtual bool property_use_nick ();
		public virtual GXml.Node? serialize (GXml.Node node) throws GLib.Error;
		public virtual GXml.Node? serialize_property (GXml.Node element, GLib.ParamSpec prop) throws GLib.Error;
		public virtual bool serialize_use_xml_node_value ();
		public virtual bool set_default_namespace (GXml.Node node);
		public GLib.HashTable<string,GLib.ParamSpec> ignored_serializable_properties { get; protected set; }
		protected GLib.ParamSpec[] properties { get; set; }
	}
	/**
	 * Represent any boolean property to be added as a {@link GXml.Attribute} to a {@link GXml.Element}
	 *
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class SerializableBool : GLib.Object, GXml.SerializableProperty {
		public SerializableBool ();
		/**
		 * Parse the stored value, from the XML property, to a {@link int}. This parsing
		 * may is different from the actual stored string. If can't be parsed to a valid
		 * boolean, this method will always return false.
		 */
		public bool get_value ();
		/**
		 * Given boolean value is parsed to string and then stored.
		 */
		public void set_value (bool val);
		/**
		 * Parse actual stored string to a boolean and returns the result. See {@link get_value}
		 */
		public string to_string ();
	}
	/**
	 * Any {@link GXml.Serializable} class having a collection managed list of
	 * {@link GXml.Node} must implement this abstract class.
	 * 
	 * Gee Serializable clases requires to be initialized with required typed objects to contain 
	 * its collections and Serializable interface don't know required type. Then you must use this
	 * function to initialize any Serializable collection objects in order to serialize/deserialize
	 * all {@link GXml.Node} to given clases.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public abstract class SerializableContainer : GXml.SerializableObjectModel {
		public SerializableContainer ();
		/**
		 * Implementors must implement this function and initialize any Serializable container.
		 */
		public abstract void init_containers ();
	}
	/**
	 * Represent any real double value property to be added as a
	 * {@link GXml.Attribute} to a {@link GXml.Element}
	 *
	 * This object can be used when the property could be removed from
	 * serialization, specially if missing on XML have some
	 * missing and avoidable.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class SerializableDouble : GLib.Object, GXml.SerializableProperty {
		protected int _fraction;
		protected string _val;
		public SerializableDouble ();
		public string format (string f);
		public int get_fraction ();
		public double get_value ();
		public void set_fraction (int fraction);
		public void set_value (double val);
		public string to_string ();
	}
	/**
	 * Serializable Framework. A {@link Serializable} objects container based on Gee interfaces with dual key.
	 * 
	 * It implements {@link Serializable} and {@link SerializableCollection} interfaces, it is iterable as
	 * other Gee collections.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class SerializableDualKeyMap<P,S,V> : GLib.Object, Gee.Traversable<V>, GXml.Serializable, GXml.SerializableCollection {
		protected bool _deserialized;
		protected GXml.Node _node;
		protected Gee.HashMultiMap<P,Gee.HashMap<S,V>> storage;
		public SerializableDualKeyMap ();
		public bool default_deserialize (GXml.Node node) throws GLib.Error;
		public bool default_deserialize_property (GXml.Node property_node) throws GLib.Error;
		public GXml.Node? default_serialize (GXml.Node node) throws GLib.Error;
		public GXml.Node? default_serialize_property (GXml.Node element, GLib.ParamSpec prop) throws GLib.Error;
		public virtual bool deserialize (GXml.Node node) throws GLib.Error;
		public virtual bool deserialize_children () throws GLib.Error;
		public virtual bool deserialize_node (GXml.Node node) throws GLib.Error;
		public virtual bool deserialize_proceed ();
		public virtual bool deserialize_property (GXml.Node property_node) throws GLib.Error;
		public virtual bool deserialized ();
		public virtual GLib.ParamSpec? find_property_spec (string property_name);
		public new V @get (P primary_key, S secondary_key);
		public virtual bool get_enable_unknown_serializable_property ();
		public virtual GLib.ParamSpec[] list_serializable_properties ();
		public virtual string node_name ();
		public virtual bool property_use_nick ();
		public Gee.Collection<S> secondary_keys (P key);
		public virtual GXml.Node? serialize (GXml.Node node) throws GLib.Error;
		public virtual GXml.Node? serialize_property (GXml.Node element, GLib.ParamSpec prop) throws GLib.Error;
		public virtual bool serialize_use_xml_node_value ();
		public new void @set (P primary_key, S secundary_key, V val);
		public virtual bool set_default_namespace (GXml.Node node);
		public Gee.Collection<V> values ();
		public Gee.Collection<V> values_for_key (P primary_key);
		public GLib.HashTable<string,GLib.ParamSpec> ignored_serializable_properties { get; protected set; }
		public GLib.Type primary_key_type { get; }
		public Gee.Collection<P> primary_keys { owned get; }
		protected GLib.ParamSpec[] properties { get; set; }
		public GLib.Type secondary_key_type { get; }
		public int size { get; }
		public GLib.Type value_type { get; }
	}
	/**
	 * Represent any value as string but a list of enum values by default to select from.
	 * property to be added as a {@link GXml.Attribute} to a {@link GXml.Element}.
	 *
	 * This class makes easy to create enumerations with its representation to string,
	 * but limited to the actual values of the enumeration, making it flexible for
	 * values not supported now but possible because some extensions. Can be added
	 * an extension element in the enumeration and return it when the supported values
	 * are not met with the string representation in the property.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class SerializableEnum : GLib.Object, GXml.SerializableProperty {
		protected GLib.Type _enumtype;
		protected string _val;
		public SerializableEnum ();
		public GLib.Type get_enum_type ();
		public void parse (string str) throws GLib.Error;
		public void parse_integer (int v) throws GLib.Error;
		public void set_enum_type (GLib.Type type);
		public int to_integer () throws GLib.Error;
		public string to_string ();
		public SerializableEnum.with_enum (GLib.Type type);
	}
	/**
	 * Represent any float property to be added as a {@link GXml.Attribute} to a {@link GXml.Element}
	 *
	 * This object can be used when the property could be removed from serialization, specially if missing
	 * on XML have some missing and avoidable.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class SerializableFloat : GXml.SerializableDouble {
		public SerializableFloat ();
		/**
		 * Parse the stored value, from the XML property, to a {@link int}. This parsing
		 * may is different from the actual stored string.
		 *
		 * The stored value, is parsed using to double value and then
		 * casted to an float before return, this make flexible on stored values
		 * in XML and parsed without errors, but they could defere from the value
		 * returned by this method.
		 */
		public new float get_value ();
		/**
		 * Given float number is parsed to string and then stored.
		 */
		public new void set_value (float val);
	}
	/**
	 * Serializable Framework. A {@link Serializable} objects container based on {@link Gee.HashMap}.
	 * 
	 * It uses a key and value store implementing {@link Gee.HashMap} interface.
	 * It implements {@link Serializable} and {@link SerializableCollection} interfaces.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class SerializableHashMap<K,V> : Gee.HashMap<K,V>, GXml.Serializable, GXml.SerializableCollection {
		protected bool _deserialized;
		protected GXml.Node _node;
		public SerializableHashMap ();
		public bool default_deserialize (GXml.Node node) throws GLib.Error;
		public bool default_deserialize_property (GXml.Node property_node) throws GLib.Error;
		public GXml.Node? default_serialize (GXml.Node node) throws GLib.Error;
		public GXml.Node? default_serialize_property (GXml.Node element, GLib.ParamSpec prop) throws GLib.Error;
		public virtual bool deserialize (GXml.Node node) throws GLib.Error;
		public virtual bool deserialize_children () throws GLib.Error;
		public virtual bool deserialize_node (GXml.Node node) throws GLib.Error;
		public virtual bool deserialize_proceed ();
		public virtual bool deserialize_property (GXml.Node property_node) throws GLib.Error;
		public virtual bool deserialized ();
		public virtual GLib.ParamSpec? find_property_spec (string property_name);
		public virtual bool get_enable_unknown_serializable_property ();
		public virtual GLib.ParamSpec[] list_serializable_properties ();
		public virtual string node_name ();
		public virtual bool property_use_nick ();
		public virtual GXml.Node? serialize (GXml.Node node) throws GLib.Error;
		public virtual GXml.Node? serialize_property (GXml.Node element, GLib.ParamSpec prop) throws GLib.Error;
		public virtual bool serialize_use_xml_node_value ();
		public virtual bool set_default_namespace (GXml.Node node);
		public GLib.HashTable<string,GLib.ParamSpec> ignored_serializable_properties { get; protected set; }
		protected GLib.ParamSpec[] properties { get; set; }
	}
	/**
	 * Represent any boolean property to be added as a {@link GXml.Attribute} to a {@link GXml.Element} 
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class SerializableInt : GXml.SerializableDouble {
		public SerializableInt ();
		/**
		 * Parse the stored value, from the XML property, to a {@link int}. This parsing
		 * may is different from the actual stored string.
		 *
		 * The stored value, is parsed as double value and then
		 * casted to an integer before return, this make flexible on stored values
		 * in XML and parsed without errors, but they could defere from the value
		 * returned by this method.
		 */
		public new int get_value ();
		/**
		 * Given integer is parsed to string and then stored.
		 */
		public new void set_value (int val);
	}
	/**
	 * Object Model is an {@link Serializable} implementation using {@link Element}
	 * to represent {@link GLib.Object} class objects.
	 * 
	 * This implementation consider each object as a XML node, represented in GXml 
	 * as a {@link GXml.Element} and its properties is represented by {@link GXml.Attribute}.
	 * Each property, if it is a {@link Serializable} object, is represented as child
	 * {@link Element}.
	 * 
	 * If a object's value property must be represented as a XML node content, 
	 * then it requires to override {@link Serializable.serialize_use_xml_node_value}
	 * and set value at {@link Serializable.serialized_xml_node_value}.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public abstract class SerializableObjectModel : GLib.Object, GXml.Serializable {
		protected GXml.Node _node;
		public SerializableObjectModel ();
		public bool default_deserialize (GXml.Node node) throws GLib.Error;
		public bool default_deserialize_property (GXml.Node property_node) throws GLib.Error;
		public string default_node_name ();
		public GXml.Node? default_serialize (GXml.Node node) throws GLib.Error;
		public GXml.Node? default_serialize_property (GXml.Element element, GLib.ParamSpec prop) throws GLib.Error;
		public virtual bool deserialize (GXml.Node node) throws GLib.Error;
		public virtual bool deserialize_property (GXml.Node property_node) throws GLib.Error;
		public virtual GLib.ParamSpec? find_property_spec (string property_name);
		public virtual bool get_enable_unknown_serializable_property ();
		public virtual GLib.ParamSpec[] list_serializable_properties ();
		public virtual string node_name ();
		public virtual bool property_use_nick ();
		public virtual GXml.Node? serialize (GXml.Node node) throws GLib.Error;
		public virtual GXml.Node? serialize_property (GXml.Node element, GLib.ParamSpec prop) throws GLib.Error;
		public virtual bool serialize_use_xml_node_value ();
		public virtual bool set_default_namespace (GXml.Node node);
		public abstract string to_string ();
		public GLib.HashTable<string,GLib.ParamSpec> ignored_serializable_properties { get; protected set; }
		protected GLib.ParamSpec[] properties { get; set; }
	}
	/**
	 * Serializable Framework. A {@link Serializable} objects container based on {@link Gee.TreeMap}.
	 * 
	 * It uses a key and value store implementing {@link Gee.TreeMap} interface.
	 * It implements {@link Serializable} and {@link SerializableCollection} interfaces.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class SerializableTreeMap<K,V> : Gee.TreeMap<K,V>, GXml.Serializable, GXml.SerializableCollection {
		protected bool _deserialized;
		protected GXml.Node _node;
		public SerializableTreeMap ();
		public bool default_deserialize (GXml.Node node) throws GLib.Error;
		public bool default_deserialize_property (GXml.Node property_node) throws GLib.Error;
		public GXml.Node? default_serialize (GXml.Node node) throws GLib.Error;
		public GXml.Node? default_serialize_property (GXml.Node element, GLib.ParamSpec prop) throws GLib.Error;
		public virtual bool deserialize (GXml.Node node) throws GLib.Error;
		public virtual bool deserialize_children () throws GLib.Error;
		public virtual bool deserialize_node (GXml.Node node) throws GLib.Error;
		public virtual bool deserialize_proceed ();
		public virtual bool deserialize_property (GXml.Node property_node) throws GLib.Error;
		public virtual bool deserialized ();
		public virtual GLib.ParamSpec? find_property_spec (string property_name);
		public virtual GLib.ParamSpec[] list_serializable_properties ();
		public virtual string node_name ();
		public virtual bool property_use_nick ();
		public virtual GXml.Node? serialize (GXml.Node node) throws GLib.Error;
		public virtual GXml.Node? serialize_property (GXml.Node element, GLib.ParamSpec prop) throws GLib.Error;
		public virtual bool serialize_use_xml_node_value ();
		public virtual bool set_default_namespace (GXml.Node node);
		public GLib.HashTable<string,GLib.ParamSpec> ignored_serializable_properties { get; protected set; }
		protected GLib.ParamSpec[] properties { get; set; }
	}
	/**
	 * Represent any value as string but a list of options by default to select from.
	 * property to be added as a {@link GXml.Attribute} to a {@link GXml.Element}.
	 *
	 * All values are stored in an array to get access to it by its position using
	 * {@link SerializableValueList.get_value_at}.
	 *
	 * Is recommended to initilize your list from a fixed array to avoid to have a list
	 * for each object in memory, do it by initialize the internal variable
	 * {@link GXml.SerializableValueList._vals}, at construct {} clause to point a fixed
	 * array of strings.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class SerializableValueList : GLib.Object, GXml.SerializableProperty {
		protected string[] _vals;
		protected Gee.ArrayList<string> extra;
		public SerializableValueList ();
		/**
		 * Add a list of string values to select from.
		 * 
		 * This values are added to the ones already defined at construct time.s
		 */
		public virtual void add_values (string[] vals);
		/**
		 * Get the string value at a given index. This operation does not change
		 * the actual value.
		 */
		public virtual string? get_value_at (int index);
		/**
		 * Return a {@link Gee.List} with all possible selection strings.
		 *
		 * If no values where defined at construction time and no values
		 * have been added, then this will return an empty list.
		 */
		public virtual Gee.List<string> get_values ();
		/**
		 * Get an array of string values in list.
		 *
		 * If no values were defined at construction time and
		 * no values were added this return null
		 */
		public virtual string[] get_values_array ();
		/**
		 * Checks if the actual value is in the values list.
		 */
		public virtual bool is_value ();
		/**
		 * Sets actual value to the one at a given position.
		 */
		public virtual void select_value_at (int index);
		public string to_string ();
	}
	/**
	 * Class implemeting {@link GXml.Attribute} interface, not tied to libxml-2.0 library.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class TAttribute : GXml.TNode, GXml.Attribute {
		protected Gee.ArrayList<GXml.Node> _namespaces;
		public TAttribute (GXml.Document d, string name, string value);
		public override Gee.List<GXml.Namespace> namespaces { owned get; }
	}
	/**
	 * Class implemeting {@link GXml.CDATA} interface, not tied to libxml-2.0 library.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class TCDATA : GXml.TNode, GXml.CDATA {
		public TCDATA (GXml.Document d, string text);
		public override string value { owned get; set; }
	}
	/**
	 * Class implemeting {@link GXml.Comment} interface, not tied to libxml-2.0 library.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class TComment : GXml.TNode, GXml.Comment {
		public TComment (GXml.Document doc, string text);
		public override string value { owned get; set; }
	}
	/**
	 * Class implemeting {@link GXml.Document} interface, not tied to libxml-2.0 library.
	 *
	 * This class use {@link Xml.TextWriter} to write down XML documents using
	 * its contained {@link GXml.Node} children or other XML structures.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class TDocument : GXml.TNode, GXml.Document {
		/**
		 * Enum for {@link Xml.TextReader} flag on parsing.
		 */
		public enum ReadType {
			NEXT,
			CONTINUE,
			STOP
		}
		/**
		 * Delegate function to control parsing of XML documents. Return {@link ReadType.NEXT}
		 * to skip all children nodes of current {@link GXml.Node}; {@link ReadType.CONTINUE}
		 * continue parsing nodes or {@link ReadType.STOP} to stop reading.
		 *
		 * While you get the current {@link Xml.TextReader} used in parsing, you can control
		 * next action to take depending on current node.
		 */
		public delegate GXml.TDocument.ReadType ReadTypeFunc (GXml.Node node, Xml.TextReader tr);
		protected Gee.ArrayList<GXml.Node> _children;
		protected Gee.ArrayList<GXml.Node> _namespaces;
		public TDocument ();
		public TDocument.from_file (GLib.File file);
		public TDocument.from_file_with_readtype_func (GLib.File file, GXml.TDocument.ReadTypeFunc func);
		public TDocument.from_path (string path);
		public TDocument.from_path_with_readtype_func (string path, GXml.TDocument.ReadTypeFunc func);
		public TDocument.from_stream (GLib.InputStream stream);
		public TDocument.from_stream_with_readtype_func (GLib.InputStream stream, GXml.TDocument.ReadTypeFunc func);
		public TDocument.from_string (string str);
		public TDocument.from_string_with_readtype_func (string str, GXml.TDocument.ReadTypeFunc func);
		public TDocument.from_uri (string uri);
		public TDocument.from_uri_with_readtype_func (string uri, GXml.TDocument.ReadTypeFunc func);
		/**
		 * Read a {@link GXml.Document} from a {@link GLib.File}, parsing is controller
		 * using {@link ReadTypeFunc}, if null it parse all nodes.
		 */
		public static void read_doc (GXml.Document doc, GLib.File file, GXml.TDocument.ReadTypeFunc? rtfunc = null) throws GLib.Error;
		/**
		 * Reads document from {@link GLib.InputStream} objects.
		 */
		public static void read_doc_stream (GXml.Document doc, GLib.InputStream istream, GXml.TDocument.ReadTypeFunc? rtfunc = null) throws GLib.Error;
		/**
		 * Parse current node in {@link Xml.TextReader}.
		 *
		 * Returns: a {@link GXml.Node} respresenting current parsed one.
		 */
		public static GXml.TDocument.ReadType read_node (GXml.Node node, Xml.TextReader tr, GXml.TDocument.ReadTypeFunc? rntfunc = null) throws GLib.Error;
		[Version (deprecated = true, deprecated_since = "0.8.1", replacement = "save_as")]
		public bool save_to (GLib.File f, GLib.Cancellable? cancellable = null) throws GLib.Error;
		/**
		 * {@inheritDoc}
		 *
		 * All namespaces are stored at {@link GXml.Node.namespaces} owned by
		 * this {@link GXml.TDocument}.
		 *
		 * First namespace at list, is considered default one for the document. If
		 * you haven't declared a namespace for this document or for its root element,
		 * and you define one for a child node, this one is added for the first time
		 * to document's namespaces, then this becomes the default namespace. To avoid
		 * this, you should set a namespace for documento or its root, then children.
		 *
		 * Default {@link GXml.Namespace} for a document is the first
		 */
		public override bool set_namespace (string uri, string? prefix);
		public static void start_node (GXml.Document doc, Xml.TextWriter tw, GXml.Node node, bool root, ref Gee.ArrayList<string> declared_ns) throws GLib.Error;
		public override string to_string ();
		public static bool tw_save_as (GXml.Document doc, GLib.File f, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public static void write_document (GXml.Document doc, Xml.TextWriter tw) throws GLib.Error;
		public override Gee.BidirList<GXml.Node> children_nodes { owned get; }
		public override GXml.Document document { get; }
		public override Gee.List<GXml.Namespace> namespaces { owned get; }
	}
	/**
	 * Class implemeting {@link GXml.Element} interface, not tied to libxml-2.0 library.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class TElement : GXml.TNode, GXml.Element {
		protected Gee.HashMap<string,GXml.Node> _attrs;
		protected GXml.TNode.TChildrenList _children;
		protected Gee.ArrayList<GXml.Node> _namespaces;
		public TElement (GXml.Document d, string name);
		public override Gee.Map<string,GXml.Node> attrs { owned get; }
		public override Gee.BidirList<GXml.Node> children_nodes { owned get; }
		public override Gee.List<GXml.Namespace> namespaces { owned get; }
		public override string value { owned get; set; }
	}
	/**
	 * Class implemeting {@link GXml.Namespace}, not tied to libxml-2.0 library.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class TNamespace : GXml.TNode, GXml.Namespace {
		public TNamespace (GXml.Document d, string uri, string? prefix);
	}
	/**
	 * Base node abstract class implemeting {@link GXml.Node} interface, not tied to libxml-2.0 library.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public abstract class TNode : GLib.Object, GXml.Node {
		protected class TChildrenList : Gee.AbstractBidirList<GXml.Node> {
			public TChildrenList (GXml.Node e);
			public override bool add (GXml.Node item);
			public override Gee.BidirListIterator<GXml.Node> bidir_list_iterator ();
			public override void clear ();
			public override bool contains (GXml.Node item);
			public override new GXml.Node @get (int index);
			public override int index_of (GXml.Node item);
			public override void insert (int index, GXml.Node item);
			public override Gee.Iterator<GXml.Node> iterator ();
			public override Gee.ListIterator<GXml.Node> list_iterator ();
			public override bool remove (GXml.Node item);
			public override GXml.Node remove_at (int index);
			public override new void @set (int index, GXml.Node item);
			public override Gee.List<GXml.Node>? slice (int start, int stop);
			public override bool read_only { get; }
			public override int size { get; }
		}
		protected GXml.Document _doc;
		protected string _name;
		protected GXml.NodeType _node_type;
		protected GXml.Node _parent;
		protected string _value;
		public TNode ();
		public virtual bool set_namespace (string uri, string? prefix);
		public virtual void set_parent (GXml.Node node);
		public virtual string to_string ();
		public virtual Gee.Map<string,GXml.Node> attrs { owned get; }
		public virtual Gee.BidirList<GXml.Node> children_nodes { owned get; }
		public virtual GXml.Document document { get; }
		public virtual string name { owned get; }
		public virtual Gee.List<GXml.Namespace> namespaces { owned get; }
		public virtual GXml.Node parent { owned get; }
		public virtual GXml.NodeType type_node { get; }
		public virtual string value { owned get; set; }
	}
	/**
	 * Class implemeting {@link GXml.ProcessingInstruction} interface, not tied to libxml-2.0 library.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class TProcessingInstruction : GXml.TNode, GXml.ProcessingInstruction {
		public TProcessingInstruction (GXml.Document doc, string target, string data);
		public override string value { owned get; set; }
	}
	/**
	 * Class implemeting {@link GXml.Text} interface, not tied to libxml-2.0 library.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class TText : GXml.TNode, GXml.Text {
		public TText (GXml.Document d, string text);
		public override string value { owned get; set; }
	}
	/**
	 * {@link Parser} implementation using libxml2 engine
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public class XParser : GLib.Object, GXml.Parser {
		public XParser (GXml.DomNode node);
		/**
		 * Creates a new {@link DomElement} and append it as a child of parent: for current
		 * read node, only if parent: have a property as {@link GomCollection} type and current
		 * node have same local name as collection {@link GomCollection.items_name}
		 *
		 * Returns: true if element is set to a new object, it is set as a child of parent:
		 * and has been added to a parent:'s collection property.
		 */
		public bool add_element_collection (GXml.DomNode parent, out GXml.DomNode element) throws GLib.Error;
		/**
		 * Creates a new {@link DomElement} and append it as a child of parent.
		 */
		public GXml.DomElement? create_element (GXml.DomNode parent) throws GLib.Error;
		/**
		 * Check if current node found by parser, is a {@link DomDocument}
		 */
		public bool current_is_document ();
		/**
		 * Check if current node found by parser, is a {@link DomElement}
		 */
		public bool current_is_element ();
		/**
		 * Check if current node has childs.
		 */
		public bool current_is_empty_element ();
		/**
		 * Returns current node's local name, found by parser.
		 */
		public string current_node_name ();
		/**
		 * Use parser to go to next parsed node.
		 */
		public bool move_next_node () throws GLib.Error;
		/**
		 * Reads current found element
		 */
		public bool read_child_element (GXml.DomNode parent) throws GLib.Error;
		/**
		 * Creates a new {@link DomNode} and append it to
		 * parent: depending on current node's type found by parser.
		 *
		 * If current found node is a {@link DomElement}, it is not parsed.
		 * If you want to parse it use {@link read_element} method.
		 *
		 * Returns: true if node has been created and appended to parent.
		 */
		public bool read_child_node (GXml.DomNode parent) throws GLib.Error;
		/**
		 * Iterates in all child nodes and append them to node.
		 */
		public void read_child_nodes (GXml.DomNode parent) throws GLib.Error;
		/**
		 * Reads a {@link DomElement}
		 */
		public void read_element (GXml.DomElement element) throws GLib.Error;
		/**
		 * Creates a new {@link DomElement} and append it as a child of parent: for current
		 * read node, only if parent: have a property as {@link DomElement} type and current
		 * node have same local name as property element.
		 *
		 * Returns: true if element is set to a new object and it is set as a child of parent:
		 * as a property.
		 */
		public bool read_element_property (GXml.DomNode parent, out GXml.DomNode element) throws GLib.Error;
		/**
		 * Reads a node using current parser.
		 */
		public void read_node (GXml.DomNode node) throws GLib.Error;
	}
	/**
	 * Interface to handle XML tags properties.
	 *
	 * Its features relays on {@link GXml.Node} interface inplementation to access
	 * {@link GXml.Element} properties.
	 *
	 * Attribute's name could be get from {@link GXml.Node.name} property. Its value
	 * should be get from {@link GXml.Node.value} property.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface Attribute : GLib.Object, GXml.Node {
		public abstract GXml.Namespace? @namespace { owned get; set; }
		public abstract string? prefix { owned get; }
	}
	/**
	 * CDATA sections in XML documents.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface CDATA : GLib.Object, GXml.Node {
		/**
		 * This should be implemented by returning {@link GXml.Node.value}
		 */
		public abstract string str { owned get; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface Character : GLib.Object, GXml.Node {
		public abstract string str { owned get; set; }
	}
	/**
	 * Representation of comments nodes in any {@link GXml.Node}
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface Comment : GLib.Object, GXml.Node {
		/**
		 * This should be implemented by returning {@link GXml.Node.value}
		 */
		public abstract string str { owned get; set; }
	}
	/**
	 * Interface to handle XML documents.
	 *
	 * Provides basic interfaces to read and create XML documents.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface Document : GLib.Object, GXml.Node {
		/**
		 * Creates a new {@link GXml.CDATA}.
		 *
		 * Is a matter of you to add as a child to any other
		 * {@link GXml.Node}, like a {@link GXml.Element} node.
		 */
		public abstract GXml.Node create_cdata (string text);
		/**
		 * Creates a new {@link GXml.Comment}.
		 *
		 * Is a matter of you to add as a child to any other
		 * {@link GXml.Node}, like a {@link GXml.Element} node.
		 */
		public abstract GXml.Node create_comment (string text);
		/**
		 * This method should create a new {@link GXml.Element}.
		 *
		 * Is a matter of you to add as a child to any other
		 * {@link GXml.Node}.
		 */
		public abstract GXml.Node create_element (string name) throws GLib.Error;
		/**
		 * Creates a new {@link GXml.ProcessingInstruction}.
		 *
		 * Is a matter of you to add as a child to any other
		 * {@link GXml.Node}, like a {@link GXml.Element} node.
		 */
		public abstract GXml.Node create_pi (string target, string data);
		/**
		 * Creates a new {@link GXml.Text}.
		 *
		 * Is a matter of you to add as a child to any other
		 * {@link GXml.Node}, like a {@link GXml.Element} node.
		 */
		public abstract GXml.Node create_text (string text);
		/**
		 * Creates a new {@link GXml.Document} using default implementation class.
		 *
		 * As an interface you can create your own implementation of it, but if 
		 * default one is required use this.
		 */
		public static GXml.Document new_default ();
		/**
		 * Creates a new {@link GXml.Document} from a {@link GLib.File} using default implementation class.
		 *
		 * As an interface you can create your own implementation of it, but if 
		 * default one is required use this.
		 */
		public static GXml.Document new_default_for_file (GLib.File f) throws GLib.Error;
		/**
		 * Creates a new {@link GXml.Document} from a file path using default implementation class.
		 *
		 * As an interface you can create your own implementation of it, but if 
		 * default one is required use this.
		 */
		public static GXml.Document new_default_for_path (string path) throws GLib.Error;
		/**
		 * Save this {@link GXml.Document} to {@link GXml.Document.file}
		 *
		 * If {@link GXml.Document.file} doesn't exists, it creates a new file to save to.
		 */
		public abstract bool save (GLib.Cancellable? cancellable = null) throws GLib.Error;
		/**
		 * Save this {@link GXml.Document} to given {@link GLib.File}
		 */
		public abstract bool save_as (GLib.File f, GLib.Cancellable? cancellable = null) throws GLib.Error;
		/**
		 * Controls if writting to a {@link GLib.File} creates a backup, by default
		 * is true;
		 */
		public abstract bool backup { get; set; }
		/**
		 * Stores a {@link GLib.File} to save/read XML documents to/from.
		 */
		public abstract GLib.File file { get; set; }
		/**
		 * Controls if writting this documents should use indent.
		 */
		public abstract bool indent { get; set; }
		/**
		 * Controls if writting this documentsshould use namespaces
		 * declaration at root {@link GXml.Element}.
		 *
		 * This removes full declaration at childs nodes, because they
		 * are just prefixed if a prefix was defined for namespace apply.
		 */
		public abstract bool ns_top { get; set; }
		/**
		 * Controls if writting this document should use default namespace's prefix
		 * to prefix root's childs {@link GXml.Element}.
		 *
		 * This removes prefix on childs using default namespace. Default namespace
		 * is the first one found in {@link GXml.Node.namespaces} for this document.
		 */
		public abstract bool prefix_default_ns { get; set; }
		/**
		 * XML document root node as a {@link GXml.Element}.
		 */
		public abstract GXml.Node root { owned get; }
	}
	/**
	 * Interface to represent Document type definitions.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DocumentType : GLib.Object, GXml.Node {
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DomAttr : GLib.Object {
		public abstract string local_name { owned get; }
		public abstract string name { owned get; }
		public abstract string? namespace_uri { owned get; }
		public abstract string? prefix { owned get; }
		public virtual bool specified { get; }
		public abstract string value { owned get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DomCharacterData : GLib.Object, GXml.DomNode, GXml.DomNonDocumentTypeChildNode, GXml.DomChildNode {
		public virtual void append_data (string data);
		public virtual void delete_data (int offset, int count) throws GLib.Error;
		public virtual void insert_data (int offset, string data) throws GLib.Error;
		public virtual new void replace_data (int offset, int count, string data) throws GLib.Error;
		public virtual string substring_data (int offset, int count) throws GLib.Error;
		/**
		 * Null is an empty string.
		 */
		public abstract string data { owned get; set; }
		public virtual int length { get; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DomChildNode : GLib.Object {
		public abstract void remove ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DomComment : GXml.DomCharacterData {
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DomCustomEvent : GLib.Object, GXml.DomEvent {
		public abstract void init_custom_event (string type, bool bubbles, bool cancelable, GLib.Value? detail);
		public abstract GLib.Value? detail { get; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DomDocument : GLib.Object, GXml.DomNode, GXml.DomParentNode, GXml.DomNonElementParentNode {
		public abstract GXml.DomNode adopt_node (GXml.DomNode node) throws GLib.Error;
		public abstract GXml.DomComment create_comment (string data) throws GLib.Error;
		public abstract GXml.DomDocumentFragment create_document_fragment ();
		public abstract GXml.DomElement create_element (string local_name) throws GLib.Error;
		public abstract GXml.DomElement create_element_ns (string? @namespace, string qualified_name) throws GLib.Error;
		/**
		 * No implemented jet. This can lead to API changes in future versions.
		 */
		public abstract GXml.DomEvent create_event (string @interface) throws GLib.Error;
		/**
		 * No implemented jet. This can lead to API changes in future versions.
		 */
		public abstract GXml.DomNodeIterator create_node_iterator (GXml.DomNode root, int whatToShow = (int) 0xFFFFFFFF, GXml.DomNodeFilter? filter = null);
		public abstract GXml.DomProcessingInstruction create_processing_instruction (string target, string data) throws GLib.Error;
		/**
		 * No implemented jet. This can lead to API changes in future versions.
		 */
		public abstract GXml.DomRange create_range ();
		public abstract GXml.DomText create_text_node (string data) throws GLib.Error;
		/**
		 * No implemented jet. This can lead to API changes in future versions.
		 */
		public abstract GXml.DomTreeWalker create_tree_walker (GXml.DomNode root, int what_to_show = (int) 0xFFFFFFFF, GXml.DomNodeFilter? filter = null);
		public abstract GXml.DomHTMLCollection get_elements_by_class_name (string classNames);
		public abstract GXml.DomHTMLCollection get_elements_by_tag_name (string local_name);
		public abstract GXml.DomHTMLCollection get_elements_by_tag_name_ns (string? @namespace, string local_name);
		public abstract GXml.DomNode import_node (GXml.DomNode node, bool deep = false) throws GLib.Error;
		public abstract string character_set { get; }
		public abstract string compat_mode { get; }
		public abstract string content_type { get; }
		public abstract GXml.DomDocumentType? doctype { owned get; }
		public abstract GXml.DomElement? document_element { owned get; }
		public abstract string document_uri { get; }
		public abstract GXml.DomImplementation implementation { get; }
		public abstract string origin { get; }
		public abstract string url { get; }
	}
	/**
	 * No implemented jet. This can lead to API changes in future versions.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DomDocumentFragment : GLib.Object, GXml.DomNode, GXml.DomParentNode, GXml.DomNonElementParentNode {
	}
	/**
	 * No implemented jet. This can lead to API changes in future versions.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DomDocumentType : GLib.Object, GXml.DomNode, GXml.DomChildNode {
		public abstract string name { get; }
		public abstract string public_id { get; }
		public abstract string system_id { get; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DomElement : GLib.Object, GXml.DomNode, GXml.DomChildNode, GXml.DomNonDocumentTypeChildNode, GXml.DomParentNode {
		public abstract string? get_attribute (string name);
		public abstract string? get_attribute_ns (string? @namespace, string local_name);
		public abstract GXml.DomHTMLCollection get_elements_by_class_name (string class_names);
		public abstract GXml.DomHTMLCollection get_elements_by_tag_name (string local_name);
		public abstract GXml.DomHTMLCollection get_elements_by_tag_name_ns (string? @namespace, string local_name);
		public abstract bool has_attribute (string name);
		public abstract bool has_attribute_ns (string? @namespace, string local_name);
		public abstract void remove_attribute (string name);
		public abstract void remove_attribute_ns (string? @namespace, string local_name);
		public abstract void set_attribute (string name, string value) throws GLib.Error;
		/**
		 * Set an attribute value to this element. If it doesn't exists yet, it is added
		 * to the list of attributes, unless it is an namespace redefinition.
		 *
		 * To set a namespace declaration [[http://www.w3.org/2000/xmlns]] namespace and xmlns
		 * as prefix. For default namespaces, use xmlns as name without prefix. Namespace
		 * URI will be the one provided as value.
		 *
		 * @param namespace attribute namespace
		 * @param name a prefixed attribute name or xmlns for default namespace declaration
		 * @param value a value for the attribute or URI for namespace declaration
		 */
		public abstract void set_attribute_ns (string? @namespace, string name, string value) throws GLib.Error;
		public abstract GXml.DomNamedNodeMap attributes { owned get; }
		public abstract GXml.DomTokenList class_list { owned get; }
		public abstract string? class_name { owned get; set; }
		public abstract string? id { owned get; set; }
		public abstract string local_name { owned get; }
		/**
		 * Returns default namespace's uri defined in node or first found.
		 */
		public abstract string? namespace_uri { owned get; }
		/**
		 * Returns default namespace's prefix defined in node or first found.
		 */
		public abstract string? prefix { owned get; }
		public abstract string tag_name { owned get; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DomEvent : GLib.Object {
		[Flags]
		public enum Flags {
			STOP_PROPAGATION_FLAG,
			STOP_IMMEDIATE_PROPAGATION_FLAG,
			CANCELED_FLAG,
			INITIALIZED_FLAG,
			DISPATCH_FLAG
		}
		public enum Phase {
			NONE,
			CAPTURING_PHASE,
			AT_TARGET,
			BUBBLING_PHASE
		}
		public abstract void init_event (string type, bool bubbles, bool cancelable);
		public abstract void prevent_default ();
		public abstract void stop_immediate_propagation ();
		public abstract void stop_propagation ();
		public abstract bool bubbles { get; }
		public abstract bool cancelable { get; }
		public abstract GXml.DomEventTarget? current_target { get; }
		public abstract bool default_prevented { get; }
		public abstract string etype { get; }
		public abstract GXml.DomEvent.Phase event_phase { get; }
		public abstract GXml.DomEventTarget? event_target { get; }
		public abstract bool is_trusted { get; }
		public abstract GXml.DomTimeStamp time_stamp { get; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DomEventListener : GLib.Object {
		public abstract void handle_event (GXml.DomEvent event);
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DomEventTarget : GLib.Object {
		public abstract void add_event_listener (string type, GXml.DomEventListener? callback, bool capture = false);
		public abstract bool dispatch_event (GXml.DomEvent event) throws GLib.Error;
		public abstract void remove_event_listener (string type, GXml.DomEventListener? callback, bool capture = false);
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DomHTMLCollection : GLib.Object, Gee.BidirList<GXml.DomElement> {
		public abstract new GXml.DomElement? get_element (int index);
		public virtual GXml.DomElement? item (int index);
		public virtual GXml.DomElement? named_item (string name);
		public virtual new GXml.DomElement[] to_array ();
		public virtual int length { get; }
	}
	/**
	 * No implemented jet. This can lead to API changes in future versions.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DomImplementation : GLib.Object {
		public abstract GXml.DomXMLDocument create_document (string? nspace, string? qualified_name, GXml.DomDocumentType? doctype = null) throws GLib.Error;
		public abstract GXml.DomDocumentType create_document_type (string qualified_name, string public_id, string system_id) throws GLib.Error;
		public abstract GXml.Document create_html_document (string title);
		public virtual bool has_feature ();
	}
	/**
	 * Implementators should use constructor with one argument {@link GXml.DomMutationCallback}
	 * to use internally.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DomMutationObserver : GLib.Object {
		public abstract void disconnect ();
		public abstract void observe (GXml.Node target, GXml.DomMutationObserverInit options);
		public abstract Gee.List<GXml.DomMutationRecord> take_records ();
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DomMutationRecord : GLib.Object {
		public abstract GXml.DomNodeList added_nodes { get; set; }
		public abstract string? attribute_name { get; }
		public abstract string? attribute_namespace { get; }
		public abstract string mtype { get; }
		public abstract GXml.DomNode? next_sibling { get; }
		public abstract string? old_value { get; }
		public abstract GXml.DomNode? previous_sibling { get; }
		public abstract GXml.DomNodeList removed_nodes { get; set; }
		public abstract GXml.DomNode target { get; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DomNamedNodeMap : GLib.Object, Gee.Map<string,GXml.DomNode> {
		public abstract GXml.DomNode? get_named_item (string name);
		public abstract GXml.DomNode? get_named_item_ns (string namespace_uri, string local_name) throws GLib.Error;
		public abstract GXml.DomNode? item (int index);
		public abstract GXml.DomNode? remove_named_item (string name) throws GLib.Error;
		public abstract GXml.DomNode? remove_named_item_ns (string namespace_uri, string localName) throws GLib.Error;
		public abstract GXml.DomNode? set_named_item (GXml.DomNode node) throws GLib.Error;
		public abstract GXml.DomNode? set_named_item_ns (GXml.DomNode node) throws GLib.Error;
		public abstract int length { get; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DomNode : GLib.Object, GXml.DomEventTarget {
		[Flags]
		public enum DocumentPosition {
			NONE,
			DISCONNECTED,
			PRECEDING,
			FOLLOWING,
			CONTAINS,
			CONTAINED_BY,
			IMPLEMENTATION_SPECIFIC
		}
		public enum NodeType {
			INVALID,
			ELEMENT_NODE,
			ATTRIBUTE_NODE,
			TEXT_NODE,
			CDATA_SECTION_NODE,
			ENTITY_REFERENCE_NODE,
			ENTITY_NODE,
			PROCESSING_INSTRUCTION_NODE,
			COMMENT_NODE,
			DOCUMENT_NODE,
			DOCUMENT_TYPE_NODE,
			DOCUMENT_FRAGMENT_NODE,
			NOTATION_NODE
		}
		public abstract GXml.DomNode append_child (GXml.DomNode node) throws GLib.Error;
		public virtual GXml.DomNode clone_node (bool deep = false) throws GLib.Error;
		public abstract GXml.DomNode.DocumentPosition compare_document_position (GXml.DomNode other);
		public abstract bool contains (GXml.DomNode? other);
		/**
		 * Copy a {@link GXml.DomNode} relaying on {@link GXml.DomDocument} to other {@link GXml.DomNode}.
		 *
		 * {@link node} could belongs from different {@link GXml.DomDocument}, while source is a node
		 * belonging to given document.
		 *
		 * Only {@link GXml.DomElement} objects are supported. For attributes, use
		 * {@link GXml.DomElement.set_attribute} method, passing source's name and value as arguments.
		 *
		 * @param doc a {@link GXml.DomDocument} owning destiny node
		 * @param node a {@link GXml.DomElement} to copy nodes to
		 * @param source a {@link GXml.DomElement} to copy nodes from, it could be holded by different {@link GXml.DomDocument}
		 */
		public static bool copy (GXml.DomDocument doc, GXml.DomNode node, GXml.DomNode source, bool deep) throws GLib.Error;
		public abstract bool has_child_nodes ();
		public abstract GXml.DomNode insert_before (GXml.DomNode node, GXml.DomNode? child) throws GLib.Error;
		public abstract bool is_default_namespace (string? nspace);
		public abstract bool is_equal_node (GXml.DomNode? node);
		public abstract string? lookup_namespace_uri (string? prefix);
		public abstract string? lookup_prefix (string? nspace);
		public abstract void normalize ();
		public abstract GXml.DomNode remove_child (GXml.DomNode child) throws GLib.Error;
		public abstract GXml.DomNode replace_child (GXml.DomNode node, GXml.DomNode child) throws GLib.Error;
		public abstract string? base_uri { get; }
		public abstract GXml.DomNodeList child_nodes { owned get; }
		public abstract GXml.DomNode? first_child { owned get; }
		public abstract GXml.DomNode? last_child { owned get; }
		public abstract GXml.DomNode? next_sibling { owned get; }
		public abstract string node_name { owned get; }
		public abstract GXml.DomNode.NodeType node_type { get; }
		public abstract string? node_value { owned get; set; }
		public abstract GXml.DomDocument? owner_document { get; set construct; }
		public abstract GXml.DomElement? parent_element { owned get; }
		public abstract GXml.DomNode? parent_node { owned get; }
		public abstract GXml.DomNode? previous_sibling { owned get; }
		public abstract string? text_content { owned get; set; }
	}
	/**
	 * No implemented jet. This can lead to API changes in future versions.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DomNodeIterator {
		public abstract void detach ();
		public abstract GXml.DomNode? next_node ();
		public abstract GXml.DomNode? previous_node ();
		public abstract GXml.DomNodeFilter? filter { get; }
		public abstract bool pointer_before_reference_node { get; }
		public abstract GXml.DomNode reference_node { get; }
		public abstract GXml.DomNode root { get; }
		public abstract int what_to_show { get; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DomNodeList : GLib.Object, Gee.BidirList<GXml.DomNode> {
		public abstract GXml.DomNode? item (int index);
		public abstract int length { get; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DomNonDocumentTypeChildNode : GLib.Object {
		public abstract GXml.DomElement? next_element_sibling { get; }
		public abstract GXml.DomElement? previous_element_sibling { get; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DomNonElementParentNode : GLib.Object {
		public abstract GXml.DomElement? get_element_by_id (string element_id) throws GLib.Error;
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DomParentNode : GLib.Object {
		/**
		 * Search all child {@link GXml.Element} with a given property's name and with
		 * value contained in text.
		 */
		public virtual GXml.DomElementList get_elements_by_property_value (string property, string value);
		public abstract GXml.DomElement? query_selector (string selectors) throws GLib.Error;
		public abstract GXml.DomNodeList query_selector_all (string selectors) throws GLib.Error;
		public abstract int child_element_count { get; }
		public abstract GXml.DomHTMLCollection children { owned get; }
		public abstract GXml.DomElement? first_element_child { owned get; }
		public abstract GXml.DomElement? last_element_child { owned get; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DomProcessingInstruction : GXml.DomCharacterData {
		public abstract string target { owned get; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DomRange : GLib.Object {
		public enum BoundaryPoints {
			START_TO_START,
			START_TO_END,
			END_TO_END,
			END_TO_START
		}
		public abstract GXml.DomDocumentFragment? clone_contents () throws GLib.Error;
		public abstract GXml.DomRange clone_range ();
		public abstract void collapse (bool to_start = false) throws GLib.Error;
		public abstract int compare_boundary_points (GXml.DomRange.BoundaryPoints how, GXml.DomRange sourceRange) throws GLib.Error;
		public abstract short compare_point (GXml.DomNode node, int offset);
		public abstract void delete_contents () throws GLib.Error;
		public abstract void detach ();
		public abstract GXml.DomDocumentFragment? extract_contents () throws GLib.Error;
		public abstract void insert_node (GXml.DomNode node);
		public abstract bool intersects_node (GXml.DomNode node);
		public abstract bool is_point_in_range (GXml.DomNode node, int offset);
		public abstract void select_node (GXml.DomNode node) throws GLib.Error;
		public abstract void select_node_contents (GXml.DomNode node) throws GLib.Error;
		public abstract void set_end (GXml.DomNode node, int offset) throws GLib.Error;
		public abstract void set_end_after (GXml.DomNode node) throws GLib.Error;
		public abstract void set_end_before (GXml.DomNode node) throws GLib.Error;
		public abstract void set_start (GXml.DomNode node, int offset) throws GLib.Error;
		public abstract void set_start_after (GXml.DomNode node) throws GLib.Error;
		public abstract void set_start_before (GXml.DomNode node) throws GLib.Error;
		public abstract void surround_contents (GXml.DomNode newParent);
		public abstract string to_string ();
		public abstract bool collapsed { get; }
		public abstract GXml.DomNode common_ancestor_container { get; }
		public abstract GXml.DomNode end_container { get; }
		public abstract int end_offset { get; }
		public abstract GXml.DomNode start_container { get; }
		public abstract int start_offset { get; }
	}
	/**
	 * No implemented jet. This can lead to API changes in future versions.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DomSettableTokenList : GXml.DomTokenList {
		public abstract string value { owned get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DomText : GXml.DomCharacterData {
		public virtual GXml.DomText split_text (int offset) throws GLib.Error;
		public virtual string whole_text { owned get; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DomTokenList : GLib.Object, Gee.BidirList<string> {
		public abstract void add (string[] tokens) throws GLib.Error;
		public abstract bool contains (string token) throws GLib.Error;
		public abstract string? item (int index);
		public abstract void remove (string[] tokens);
		public abstract string to_string ();
		/**
		 * If auto is true, adds token if not present and removing if it is, @force value
		 * is taken in account. If auto is false, then @force is considered; if true adds
		 * token, if false removes it.
		 */
		public abstract bool toggle (string token, bool force = false, bool auto = true) throws GLib.Error;
		public abstract int length { get; }
	}
	/**
	 * No implemented jet. This can lead to API changes in future versions.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DomTreeWalker : GLib.Object {
		public abstract GXml.DomNode? firstChild ();
		public abstract GXml.DomNode? lastChild ();
		public abstract GXml.DomNode? nextNode ();
		public abstract GXml.DomNode? nextSibling ();
		public abstract GXml.DomNode? parentNode ();
		public abstract GXml.DomNode? previousNode ();
		public abstract GXml.DomNode? previousSibling ();
		public abstract GXml.DomNode current_node { get; }
		public abstract GXml.DomNodeFilter? filter { get; }
		public abstract GXml.DomNode root { get; }
		public abstract int what_to_show { get; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface DomXMLDocument : GLib.Object, GXml.DomDocument {
	}
	/**
	 * Interface to access XML document's tags, properties and content.
	 *
	 * Provides methods to create new XML tags properties and its values, and 
	 * access to tag's contents.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface Element : GLib.Object, GXml.Node {
		/**
		 * Search for a {@link GXml.Attribute} with given name.
		 *
		 * All attributes could be get using {@link GXml.Node.attrs} property.
		 */
		public abstract GXml.Node? get_attr (string name);
		/**
		 * Search for a {@link GXml.Attribute} with a given name and namespace uri.
		 *
		 * To get a attibute from {@link GXml.Node.attrs} with a given namespace
		 * prefix, use "prefix:name".
		 */
		public abstract GXml.Node? get_ns_attr (string name, string uri);
		/**
		 * This merges all adjacent {@link GXml.Text} nodes that are
		 * descendants of this {@link GXml.Element}.
		 */
		public abstract void normalize ();
		/**
		 * Search for a {@link GXml.Attribute} with given name and removes it.
		 */
		public abstract void remove_attr (string name);
		/**
		 * Search for a {@link GXml.Attribute} with given name and namespace and removes it.
		 */
		public abstract void remove_ns_attr (string name, string uri);
		/**
		 * Add a new {@link GXml.Attribute} to this {@link GXml.Element}.
		 *
		 * You should provide a name and a value.
		 */
		public abstract void set_attr (string name, string value);
		/**
		 * Set an {@link GXml.Attribute} with a given name, value and namespace.
		 */
		public abstract void set_ns_attr (string ns, string name, string value);
		/**
		 * This should be just a different name for {@link GXml.Node.value}.
		 */
		public abstract string content { owned get; set; }
		/**
		 * This should be just a different name for {@link GXml.Node.name}.
		 */
		public abstract string tag_name { owned get; }
	}
	/**
	 * An interface to keep references to {@link DomElement} in a {@link element}
	 * child nodes. Only {@link GomObject} are supported.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface GomCollection : GLib.Object {
		/**
		 * Adds a {@link DomElement} node to this collection. Depending on type of
		 * collection, this method will take information from node to initialize
		 * how to find it.
		 */
		public abstract void append (GXml.DomElement node) throws GLib.Error;
		/**
		 * Creates a new instance of {@link items_type}, with same
		 * {@link DomNode.owner_document} than {@link element}. New instance
		 * is not set as a child of collection's {@link element}; to do so,
		 * use {@link append}
		 *
		 * Returns: a new instance object or null if type is not a {@link GomElement} or no parent has been set
		 */
		public virtual GXml.GomElement? create_item ();
		/**
		 * Gets a child {@link DomElement} of {@link element} referenced in
		 * {@link nodes_index}.
		 */
		public virtual GXml.DomElement? get_item (int index) throws GLib.Error;
		/**
		 * Initialize collection to use a given {@link GomElement} derived type.
		 * Internally, this method create an instance of given type to initialize
		 * {@link items_type} and {@link items_name}.
		 *
		 * This method can be used at construction time of classes implementing
		 * {@link GomCollection} to initialize object type to refer in collection.
		 */
		public abstract void initialize (GLib.Type t) throws GLib.Error;
		/**
		 * Search and add references to all {@link GomObject} nodes as child of
		 * {@link element} with same, case insensitive, name of {@link items_name}
		 */
		public abstract void search () throws GLib.Error;
		/**
		 * Validate if given node and index, should be added to collection.
		 *
		 * Implementations should use this method to perform any action before
		 * element is added to collection, like setup internal pointers to given
		 * index, in order to get access to referenced node.
		 *
		 * Return: true if node and index should be added to collection.
		 */
		public abstract bool validate_append (int index, GXml.DomElement element) throws GLib.Error;
		/**
		 * A {@link GomElement} with all child elements in collection.
		 */
		public abstract GXml.GomElement element { get; set construct; }
		/**
		 * Local name of {@link DomElement} objects of {@link element}, which could be
		 * contained in this collection.
		 *
		 * Used when reading to add elements to collection.
		 */
		public abstract string items_name { get; }
		/**
		 * A {@link GLib.Type} of {@link DomElement} child objects of {@link element},
		 * which could be contained in this collection.
		 *
		 * Type should be an {@link GomObject}.
		 */
		public abstract GLib.Type items_type { get; set construct; }
		/**
		 * Number of items referenced in {@link nodes_index}
		 */
		public virtual int length { get; }
		/**
		 * A list of child {@link DomElement} objects of {@link element}
		 */
		public abstract GLib.Queue<int> nodes_index { get; }
	}
	/**
	 * A GXml Object Model (GOM) represents a {@link DomElement}. It has attributes
	 * and children. All object's properties are handled as attributes if they are
	 * basic types like integers, strings, enums and others; {@link SerializableProperty}
	 * objects are handled as attributes too. If object's attribute is a {@link GLib.Object}
	 * it is handled as node's child, but only if it is a {@link GomElement} object,
	 * other wise it is ignored when this object is used as {@link DomNode} in XML
	 * documents.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface GomObject : GLib.Object, GXml.DomNode, GXml.DomElement {
		/**
		 * Utility method to remove all instances of a property being child elements
		 * of object. Is useful if you have a {@link GomElement} property, it should be
		 * just one child of this type and you want to overwrite it.
		 *
		 * In this example you have defined an element MyClass to be child of
		 * MyParentClass, but it should have just one element, once you set child_elements
		 * it calls {@link clean_property_elements} using property's canonicals name.
		 *
		 * {{{
		 *  public class MyClass : GomElement {
		 *    public string name { get; set; }
		 *  }
		 *  public class MyParentClass : GomElement {
		 *    private Myclass _child_elements = null;
		 *    public MyClass child_elements {
		 *      get { return _child_elements; }
		 *      set {
		 *        try {
		 *          clean_property_elements ("child-elements");
		 *          _child_elements = value;
		 *          append_child (_child_elements);
		 *        } catch (GLib.Error e) {
		 *          warning (e.message);
		 *        }
		 *      }
		 *    }
		 *  }
		 * }}}
		 *
		 * @param name property name to search value type, use canonical names.
		 *
		 * @throws DomError if property is not a {@link GomElement}.
		 */
		public virtual void clean_property_elements (string name) throws GLib.Error;
		/**
		 * From a given property name of type {@link GomElement}, search all
		 * child nodes with node's local name equal to property.
		 */
		public virtual GXml.DomElementList find_elements (string name);
		/**
		 * Returns a {@link GomObject} or a {@link GomCollection} property's
		 * {@link GLib.ParamSpec} based on given name. This method is
		 * case insensitive.
		 *
		 * This method will check if nick's name is equal than given name
		 * in order to avoid use canonical names like "your-name" if your
		 * property is your_name; so you can se nick to "YourName" to find
		 * and instantiate it.
		 */
		public virtual GLib.ParamSpec? find_object_property_name (string pname);
		/**
		 * Returns property's {@link GLib.ParamSpec} based on given nick. This function is
		 * case insensitive.
		 */
		public virtual GLib.ParamSpec? find_property_name (string pname);
		/**
		 * Search for properties in objects, it should be
		 * an {@link GLib.Object}'s property. If found a
		 * property with given name its value is returned
		 * as string representation.
		 *
		 * If property is a {@link GomProperty}
		 * returned value is a string representation according
		 * with object implementation.
		 *
		 * If given property name is not found, then {@link DomElement.get_attribute}
		 * is called.
		 *
		 * By default all {@link GLib.Object} are children of
		 * this object, see {@link get_child}
		 */
		public virtual string? get_attribute (string name);
		/**
		 * Search a {@link GLib.Object} property with given name
		 * and returns it, if it is a {@link DomElement}. If not found,
		 * {@link DomElement.get_elements_by_tag_name} is called, returning
		 * first node found. Tag name to use, is the given name parameter.
		 *
		 * @param name a name of this object's property of type {@link DomElement} or
		 * first {@link DomNode} with that name in child nodes.
		 *
		 */
		public virtual GXml.DomElement? get_child (string name);
		/**
		 * Returns a list with all properties' nick with "::" prefix. Nick name,
		 * with "::" prefix will be used on serialization to an attribute's name.
		 */
		public virtual GLib.List<GLib.ParamSpec> get_properties_list ();
		/**
		 * Returns a list of names for all {@link DomElement}
		 * present as object's properties.
		 */
		public virtual GLib.List<GLib.ParamSpec> get_property_element_list ();
		/**
		 * Returns an string representation of an Object's property.
		 */
		public virtual string? get_property_string (GLib.ParamSpec prop);
		/**
		 * Search for a property and set it to null if possible returning true,
		 * if value can't be removed or located, returns false without change.
		 */
		public virtual bool remove_attribute (string name);
		/**
		 * Search for a {@link GLib.Object} property with
		 * given name, if found, given string representation
		 * is used as value to property, using any required
		 * transformation from string.
		 *
		 * By default all {@link GLib.Object} are children of
		 * this object.
		 */
		public virtual bool set_attribute (string name, string val);
		/**
		 * Convenient method to set an instance of given property's
		 * name and initialize according to have same {@link DomNode.owner_document}
		 * and set its {@link DomNode.parent_node} to this appending it as a child.
		 * If property is a {@link GomCollection} it is initialize to use
		 * this as its {@link GomCollection.element}.
		 *
		 * Instance is set ot object's property.
		 *
		 * Property should be a {@link GomElement} or {@link GomCollection}
		 *
		 * While an object could be created and set to a Object's property, it
		 * is not correctly initialized by default. This method helps in the process.
		 *
		 * If Object's property has been set, this method overwrite it.
		 *
		 * {{{
		 * class NodeA : GomObject {
		 *   construct { try { initialize ("NodeA"); } catch { warning ("Can't initialize); }
		 * }
		 * class NodeB : GomObject {
		 *   public NodeA node { get; set; }
		 * }
		 *
		 * var nb = new NodeB ();
		 * nb.create_instance_property ("node");
		 * assert (nb.node != null);
		 * }}}
		 *
		 * Returns: true if property has been set and initialized, false otherwise.
		 */
		public virtual bool set_instance_property (string name);
	}
	/**
	 * An interface for {@link GomObject}'s properties translated to
	 * {@link DomElement} attributes. If object is instantiated it is
	 * written, if not is just ingnored.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface GomProperty : GLib.Object {
		/**
		 * Takes a string and check if it is a valid value for property
		 */
		public abstract bool validate_value (string val);
		/**
		 * Attribute's value in the parent {@link DomElement} using a string.
		 *
		 * Implementation should take care to validate value before to set or
		 * parse from XML document.
		 */
		public abstract string? value { owned get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdAnnotation : GLib.Object {
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdAttribute : GLib.Object {
		public const string SCHEMA_NODE_NAME;
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdAttributeGroup : GLib.Object {
		public const string SCHEMA_NODE_NAME;
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdBaseAttribute : GLib.Object {
		public abstract GXml.IXsdAnnotation anotation { get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdBaseContent : GLib.Object {
		public abstract GXml.IXsdAnnotation anotation { get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdBaseType : GLib.Object {
		public abstract GXml.IXsdAnnotation anotation { get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdComplexContent : GLib.Object, GXml.IXsdBaseContent {
		public const string SCHEMA_NODE_NAME;
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdComplexType : GLib.Object, GXml.DomElement, GXml.IXsdBaseType {
		public const string SCHEMA_NODE_NAME;
		/**
		 * attribute name = abstract
		 */
		public abstract bool @abstract { get; set; }
		/**
		 * (#all | List of (extension | restriction))
		 */
		public abstract string block { get; set; }
		/**
		 * A {@link IXsdComplexType} or {@link IXsdSimpleType}
		 */
		public abstract GXml.IXsdBaseContent content_type { get; set; }
		/**
		 * defaultAttributesApply
		 */
		public abstract bool default_attributes_apply { get; set; }
		/**
		 * (#all | List of (extension | restriction))
		 */
		public abstract string final { get; set; }
		/**
		 * List of {@link IXsdAttributeGroup} definitions
		 */
		public abstract GXml.IXsdListAttributesGroup group_attributes { get; }
		public abstract bool mixed { get; set; }
		public abstract string name { get; set; }
		/**
		 * List of {@link IXsdAttribute} definitions
		 */
		public abstract GXml.IXsdListAttributes type_attributes { get; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdElement : GLib.Object, GXml.DomElement {
		public const string SCHEMA_NODE_NAME;
		/**
		 * attribute name = abstract
		 */
		public abstract bool @abstract { get; set; }
		public abstract GXml.IXsdAnnotation anotation { get; set; }
		/**
		 * (#all | List of (extension | restriction | substitution))
		 */
		public abstract string block { get; set; }
		public abstract GXml.IXsdComplexType complex_type { get; set; }
		public abstract string @default { get; set; }
		/**
		 * (#all | List of (extension | restriction))
		 */
		public abstract string final { get; set; }
		public abstract string fixed { get; set; }
		/**
		 * (qualified | unqualified)
		 */
		public abstract string form { get; set; }
		public abstract string? id { get; set; }
		/**
		 * (nonNegativeInteger | unbounded)  : 1
		 */
		public abstract string maxOccurs { get; set; }
		/**
		 * nonNegativeInteger : 1
		 */
		public abstract string minOccurs { get; set; }
		public abstract string name { get; set; }
		public abstract bool nillable { get; set; }
		/**
		 * attribute name = 'type'
		 */
		public abstract string object_type { get; set; }
		public abstract string @ref { get; set; }
		public abstract GXml.IXsdSimpleType simple_type { get; set; }
		/**
		 * substitutionGroup
		 */
		public abstract GXml.DomTokenList substitution_group { get; set; }
		/**
		 * targetNamespace
		 */
		public abstract string target_namespace { get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdExtension : GLib.Object, GXml.DomElement {
		public const string SCHEMA_NODE_NAME;
		public abstract string @base { get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdList : GLib.Object, GXml.GomCollection {
		public abstract void append (GXml.DomElement element);
		public abstract GXml.DomElement? get_item (int index);
		public abstract int index_of (GXml.DomElement element);
		public abstract void remove (int index);
		public abstract GXml.DomElement element { get; set construct; }
		public abstract GLib.Type items_name { get; set construct; }
		public abstract GLib.Type items_type { get; set construct; }
		public abstract int length { get; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdListAttributes : GLib.Object, GXml.IXsdList {
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdListAttributesGroup : GLib.Object, GXml.IXsdList {
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdListComplexTypes : GLib.Object, GXml.IXsdList {
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdListElements : GLib.Object, GXml.IXsdList {
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdListSimpleTypes : GLib.Object, GXml.IXsdList {
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdListTypeRestrictionEnumerations : GLib.Object, GXml.IXsdList {
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdListTypeRestrictionWhiteSpaces : GLib.Object, GXml.IXsdList {
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdOpenContent : GLib.Object, GXml.IXsdBaseContent {
	}
	/**
	 * Reference interfaces for XSD support.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdSchema : GLib.Object, GXml.DomElement {
		public const string SCHEMA_NAMESPACE_PREFIX;
		public const string SCHEMA_NAMESPACE_URI;
		public const string SCHEMA_NODE_NAME;
		public abstract GXml.IXsdListComplexTypes complex_type_definitions { get; set; }
		public abstract GXml.IXsdListElements element_definitions { get; set; }
		public abstract GXml.IXsdListSimpleTypes simple_type_definitions { get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdSimpleContent : GLib.Object, GXml.IXsdBaseContent {
		public const string SCHEMA_NODE_NAME;
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdSimpleType : GLib.Object, GXml.DomElement, GXml.IXsdBaseType {
		public const string SCHEMA_NODE_NAME;
		public abstract GXml.IXsdAnnotation annotation { get; set; }
		/**
		 * (#all | List of (list | union | restriction | extension))
		 */
		public abstract string final { get; set; }
		public abstract string id { get; set; }
		public abstract GXml.IXsdTypeList list { get; set; }
		public abstract string name { get; set; }
		public abstract GXml.IXsdTypeRestriction restriction { get; set; }
		public abstract GXml.IXsdTypeUnion union { get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdTypeDef : GLib.Object {
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdTypeList : GLib.Object, GXml.IXsdTypeDef {
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdTypeRestriction : GLib.Object, GXml.IXsdTypeDef {
		public const string SCHEMA_NODE_NAME;
		public abstract string @base { get; set; }
		public abstract GXml.IXsdListTypeRestrictionEnumerations enumerations { get; set; }
		public abstract string id { get; set; }
		public abstract GXml.IXsdSimpleType simple_type { get; set; }
		public abstract GXml.IXsdListTypeRestrictionWhiteSpaces white_spaces { get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdTypeRestrictionAssertion : GLib.Object, GXml.IXsdTypeRestrictionDef {
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdTypeRestrictionDef : GLib.Object {
		public abstract GXml.IXsdAnnotation annotation { get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdTypeRestrictionEnumeration : GLib.Object, GXml.IXsdTypeRestrictionDef {
		public const string SCHEMA_NODE_NAME;
		public abstract string id { get; set; }
		public abstract string value { get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdTypeRestrictionExplicitTimezone : GLib.Object, GXml.IXsdTypeRestrictionDef {
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdTypeRestrictionFractionDigits : GLib.Object, GXml.IXsdTypeRestrictionDef {
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdTypeRestrictionLength : GLib.Object, GXml.IXsdTypeRestrictionDef {
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdTypeRestrictionMaxExclusive : GLib.Object, GXml.IXsdTypeRestrictionDef {
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdTypeRestrictionMaxInclusive : GLib.Object, GXml.IXsdTypeRestrictionDef {
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdTypeRestrictionMaxLength : GLib.Object, GXml.IXsdTypeRestrictionDef {
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdTypeRestrictionMinExclusive : GLib.Object, GXml.IXsdTypeRestrictionDef {
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdTypeRestrictionMinInclusive : GLib.Object, GXml.IXsdTypeRestrictionDef {
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdTypeRestrictionMinLength : GLib.Object, GXml.IXsdTypeRestrictionDef {
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdTypeRestrictionPattern : GLib.Object, GXml.IXsdTypeRestrictionDef {
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdTypeRestrictionTotalDigits : GLib.Object, GXml.IXsdTypeRestrictionDef {
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdTypeRestrictionWhiteSpace : GLib.Object, GXml.IXsdTypeRestrictionDef {
		public const string SCHEMA_NODE_NAME;
		public abstract bool fixed { get; set; }
		public abstract string id { get; set; }
		/**
		 * (collapse | preserve | replace)
		 */
		public abstract string value { get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface IXsdTypeUnion : GLib.Object, GXml.IXsdTypeDef {
	}
	/**
	 * Inteface to be implemented by {@link GomElement} derived classes
	 * in order to provide a string to be used in {@link GomHashMap} as key.
	 *
	 * If {@link GomHashMap} has set its {@link GomHashMap.attribute_key}
	 * its value has precedence over this method.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface MappeableElement : GLib.Object, GXml.DomElement {
		public abstract string get_map_key ();
	}
	/**
	 * Inteface to be implemented by {@link GomElement} derived classes
	 * in order to provide a string to be used in {@link GomHashMap} as key.
	 *
	 * If {@link GomHashMap} has set its {@link GomHashMap.attribute_key}
	 * its value has precedence over this method.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface MappeableElementPairKey : GLib.Object, GXml.DomElement {
		public abstract string get_map_primary_key ();
		public abstract string get_map_secondary_key ();
	}
	/**
	 * Interface to handle XML Namespaces.
	 *
	 * Basic information for a XML document's namespaces and applied to a given
	 * {@link GXml.Node}.
	 *
	 * Namespace management is a matter of this or other libraries, implementing
	 * this interfaces.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface Namespace : GLib.Object {
		/**
		 * Read-only property to get namespace's prefix.
		 *
		 * Prefix should be added to {@link GXml.Element} or {@link GXml.Attribute}
		 * name in order to apply a given namespace, unless it is the default.
		 */
		public abstract string? prefix { owned get; }
		/**
		 * Read-only property to get namespace's URI.
		 */
		public abstract string? uri { owned get; }
	}
	/**
	 * Base interface providing basic functionalities to all GXml interfaces.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface Node : GLib.Object {
		/**
		 * Copy a {@link GXml.Node} relaying on {@link GXml.Document} to other {@link GXml.Node}.
		 *
		 * {@link node} could belongs from different {@link GXml.Document}, while source is a node
		 * belonging to given document.
		 *
		 * Only {@link GXml.Element} objects are supported. For attributes, use
		 * {@link GXml.Element.set_attr} method, passing source's name and value as arguments.
		 *
		 * @param doc a {@link GXml.Document} owning destiny node
		 * @param node a {@link GXml.Element} to copy nodes to
		 * @param source a {@link GXml.Element} to copy nodes from, it could be holded by different {@link GXml.Document}
		 */
		public static bool copy (GXml.Document doc, GXml.Node node, GXml.Node source, bool deep);
		/**
		 * Get first child with given name, or null. 
		 */
		public virtual new GXml.Node? @get (string key);
		/**
		 * Search all child {@link GXml.Element} with a given name.
		 */
		public virtual GXml.ElementList get_elements_by_name (string name);
		/**
		 * Search all child {@link GXml.Element} with a given name and namespace URI.
		 */
		public virtual GXml.ElementList get_elements_by_name_ns (string name, string? ns);
		/**
		 * Search all child {@link GXml.Element} with a given property's name and with
		 * value contained in text.
		 */
		public virtual GXml.ElementList get_elements_by_property_value (string property, string value);
		/**
		 * Node's defaults namespace's prefix.
		 *
		 * This allways returns first {@link GXml.Namespace}'s prefix in {@link GXml.Node}'s
		 * namespaces collection.
		 */
		public virtual string ns_prefix ();
		/**
		 * Node's defaults namespace's URI.
		 *
		 * This allways returns first {@link GXml.Namespace}'s URI in {@link GXml.Node}'s
		 * namespaces collection.
		 */
		public virtual string ns_uri ();
		/**
		 * Set a namespace to this node.
		 *
		 * Search for existing document's namespaces and applies it if found or creates
		 * a new one, appending to document's namespaces collection.
		 */
		public abstract bool set_namespace (string uri, string? prefix);
		/**
		 * Node's string representation.
		 */
		public abstract string to_string ();
		/**
		 * Attributes in this {@link GXml.Node}.
		 */
		public abstract Gee.Map<string,GXml.Node> attrs { owned get; }
		/**
		 * Collection of {@link GXml.Node} as children.
		 *
		 * Depends on {@link GXml.Node} type, this children could be different, like,
		 * elements, element's contents or properties.
		 */
		public abstract Gee.BidirList<GXml.Node> children_nodes { owned get; }
		/**
		 * Node's XML document holding this node.
		 */
		public abstract GXml.Document document { get; }
		/**
		 * Node's name. The meaning differs, depending on node's type.
		 */
		public abstract string name { owned get; }
		/**
		 * Collection of Namespaces applied to this {@link GXml.Node}.
		 */
		public abstract Gee.List<GXml.Namespace> namespaces { owned get; }
		/**
		 * Node's XML document holding this node.
		 */
		public abstract GXml.Node parent { owned get; }
		/**
		 * Node's type as a enumeration.
		 */
		public abstract GXml.NodeType type_node { get; }
		/**
		 * Node's value. The meaning differs, depending on node's type.
		 */
		public abstract string value { owned get; set; }
	}
	/**
	 * Interface to handle notation elements
	 *
	 * Used in defining {@link GXml.DocumentType}s to declare the format of
	 * {@link GXml.Entity} and {@link GXml.ProcessingInstruction}s.
	 *
	 * Used collectively in defining DocumentTypes. A Notation can
	 * declare the format of unparsed entities or
	 * ProcessingInstruction targets.
	 * For more, see: [[http://www.w3.org/TR/DOM-Level-1/level-one-core.html#ID-5431D1B9]]
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface Notation : GLib.Object, GXml.Node {
		public abstract string? external_id { get; }
		public abstract string? public_id { get; }
	}
	/**
	 * XML parser engine for {@link DomDocument} implementations.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface Parser : GLib.Object {
		/**
		 * Writes a {@link GXml.DomDocument} to a {@link GLib.OutputStream}
		 */
		public virtual void read_file (GLib.File file, GLib.Cancellable? cancellable) throws GLib.Error;
		/**
		 * Read a {@link GXml.DomDocument} from a {@link GLib.InputStream}
		 */
		public abstract void read_stream (GLib.InputStream stream, GLib.Cancellable? cancellable) throws GLib.Error;
		/**
		 * Read a {@link GXml.DomDocument} from a {@link GLib.File}
		 */
		public abstract void read_string (string str, GLib.Cancellable? cancellable) throws GLib.Error;
		/**
		 * Writes a {@link GXml.DomDocument} to a {@link GLib.File}
		 */
		public virtual void write_file (GLib.File file, GLib.Cancellable? cancellable) throws GLib.Error;
		/**
		 * Writes a {@link GXml.DomDocument} to a {@link GLib.OutputStream}
		 */
		public abstract void write_stream (GLib.OutputStream stream, GLib.Cancellable? cancellable) throws GLib.Error;
		/**
		 * Writes a {@link GXml.DomDocument} to a string
		 */
		public abstract string write_string () throws GLib.Error;
		/**
		 * Controls if, when writing to a file, a backup should
		 * be created.
		 */
		public abstract bool backup { get; set; }
		/**
		 * Controls if, when writing, identation should be used.
		 */
		public abstract bool indent { get; set; }
		/**
		 * A {@link GXml.DomDocument} to read to or write from
		 */
		public abstract GXml.DomNode node { get; }
	}
	/**
	 * Interface for XML Processing Instruction sections.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface ProcessingInstruction : GLib.Object, GXml.Node {
		/**
		 * The data used by the target, like {{{href="style.xsl" type="text/xml"}}}
		 */
		public abstract string data { owned get; set; }
		/**
		 * The target for the processing instruction, like "xml-stylesheet".
		 */
		public abstract string target { owned get; }
	}
	/**
	 * Serialization framework. Base interface.
	 *
	 * Implementors of this interface, could define or override the way you want to 
	 * represent your class in a XML file.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface Serializable : GLib.Object {
		/**
		 * Default implementation for {@link Serializable.find_property_spec}
		 *
		 */
		public virtual GLib.ParamSpec? default_find_property_spec (string property_name);
		/**
		 * Default implementation for {@link Serializable.list_serializable_properties}
		 *
		 */
		public virtual GLib.ParamSpec[] default_list_serializable_properties ();
		/**
		 * Deserialize this object.
		 *
		 * @param node {@link GXml.Node} used to deserialize from.
		 */
		public abstract bool deserialize (GXml.Node node) throws GLib.Error;
		/**
		 * Handles deserializing individual properties.
		 *
		 * Interface method to handle deserialization of an
		 * individual property.  The implementing class
		 * receives a description of the property and the
		 * {@link GXml.Node} that contains the content.  The
		 * implementing {@link GXml.Serializable} object can extract
		 * the data from the {@link GXml.Node} and store it in its
		 * property itself. Note that the {@link GXml.Node} may be
		 * as simple as a {@link GXml.Text} that stores the data as a
		 * string.
		 *
		 * Implementors:
		 * Use Serializable.get_property_value in order to allow derived classes to
		 * override the properties to serialize.
		 *
		 * @param property_node the {@link GXml.Node} encapsulating data to deserialize
		 * @return `true` if the property was handled.
		 */
		public abstract bool deserialize_property (GXml.Node property_node) throws GLib.Error;
		/**
		 * Handles finding the {@link GLib.ParamSpec} for a given property, it should
		 * a serializable property, see {@link list_serializable_properties}.
		 *
		 * @param property_name the name of a property to obtain a {@link GLib.ParamSpec} for
		 * @return a {@link GLib.ParamSpec} describing the named property
		 */
		public abstract GLib.ParamSpec? find_property_spec (string property_name);
		/**
		 * Return false if you want to ignore unknown properties and {@link GXml.Node}'s
		 * not in your class definition.
		 *
		 * Take care, disabling this feature you can lost data on serialization, because any unknown
		 * property or element will be discarted.
		 */
		public abstract bool get_enable_unknown_serializable_property ();
		/**
		 * Transforms a {@link GLib.Value} to its string representation.
		 *
		 * By default use {@link GLib.Value} standard transformations.
		 *
		 */
		public static string gvalue_to_string (GLib.Value val) throws GXml.SerializableError;
		/**
		 * List the known properties for an object's class to be de/seriablizable.
		 *
		 * @return an array of {@link GLib.ParamSpec} of "properties" for the object.
		 */
		public abstract GLib.ParamSpec[] list_serializable_properties ();
		/**
		 * Defines the way to set Node name.
		 */
		public abstract string node_name ();
		/**
		 * Defines the way to set Node's property name, by using
		 * it's nick instead of default name.
		 *
		 * When serialize a class property, by default it uses its name given  on class
		 * declaration, but is less common to see XML node properties with names like
		 * "your_property", but more common is to use "YourProperty". In order
		 * to use this kind of names, your implementation should use properties' nick
		 * name and override {@link property_use_nick} method to return true. This should
		 * instruct your code to use this method to use property's nick name. This is
		 * the default in GXml default implementations.
		 */
		public abstract bool property_use_nick ();
		/**
		 * Serialize this object.
		 *
		 * This method must call serialize_property() recursivally on all properties
		 * to serialize.
		 *
		 * @param node an {@link GXml.Node} object to serialize to.
		 */
		public abstract GXml.Node? serialize (GXml.Node node) throws GLib.Error;
		/**
		 * Serialize a property @prop on a {@link GXml.Element}.
		 *
		 * This method is called recursivally by {@link serialize} method over all properties
		 * to be serialized.
		 */
		public abstract GXml.Node? serialize_property (GXml.Node element, GLib.ParamSpec prop) throws GLib.Error;
		/**
		 * Used to check {@link GXml.Element}'s contents must be deseralized.
		 *
		 * By default GXml's implementations doesn't deseriaze/serialize XML node contents.
		 * In order to enable it, you must override {@link serialize_use_xml_node_value}
		 * method to return true and store XML node's content to {@link serialized_xml_node_value}
		 * property.
		 *
		 * Implementors could set up methods to provide a clean easy to use API to set
		 * nodes contents. In most cases, users would like to set a value through a getter
		 * or setter or through a property in the class.
		 *
		 */
		public abstract bool serialize_use_xml_node_value ();
		/**
		 * Used to set specific namespace for an {@link GXml.Element}.
		 *
		 * By default no namspace prefix is added to {@link GXml.Element} on serialized. Implementors
		 * must consider override this methodk if this node should have a namespace.
		 */
		public abstract bool set_default_namespace (GXml.Node node);
		/**
		 * Transforms a string into another type hosted by {@link GLib.Value}.
		 *
		 * A utility function that handles converting a string
		 * representation of a value into the type specified by the
		 * supplied #GValue dest.  A #GXmlSerializableError will be
		 * set if the string cannot be parsed into the desired type.
		 *
		 * {@link Serializable} interface support a number of data types to convert
		 * from its string representation. These are supported types:
		 *
		 * a. integers: int8, int64, uint, long, ulong, char, uchar
		 * a. boolean
		 * a. floats: float, double
		 * a. enumerations
		 *
		 * @param str the string to transform into the given #GValue object
		 * @param dest the #GValue out parameter that will contain the parsed value from the string
		 * @return `true` if parsing succeeded, otherwise `false`
		 */
		public static bool string_to_gvalue (string str, ref GLib.Value dest) throws GXml.SerializableError;
		/**
		 * Used to add content in an {@link GXml.Element}.
		 *
		 * By default no contents is serialized/deseralized. Implementors must implement
		 * {@link Serializable.serialize_use_xml_node_value} function returning
		 * true in order to use this property.
		 *
		 * This property is ignored by default. Implementors must implement
		 * {@link serialize_use_xml_node_value} to return true and add a
		 * set and get function to get/set this value, in order to use your own API.
		 *
		 * This property is ignored on serialisation.
		 */
		public abstract string? serialized_xml_node_value { owned get; protected set; }
		/**
		 * On deserialization stores any {@link GXml.Node} not used on this
		 * object, but exists in current XML file.
		 *
		 * XML allows great flexibility, providing different ways to represent the same
		 * information. This is a problem when you try to deserialize them.
		 *
		 * In order to deserialize correctly, you must create your XML, both by
		 * serializing a {@link Serializable} object or by hand writing. By using the
		 * former, you can add extra information, like nodes or contents in known nodes,
		 * but most of them could be ignored or lost on deserialization/serialization process.
		 * To avoid data lost, you can override {@link get_enable_unknown_serializable_property}
		 * method in order to return true, your implementation or the ones in GXml, will
		 * store all unknown properties and nodes on deserialization and must serialize
		 * again back to the XML file. Even you are allowed to get this unknown objects
		 * by iterating on {@link Serializable.unknown_serializable_nodes} hash table.
		 *
		 * This property is ignored on serialisation.
		 */
		public abstract Gee.Collection<GXml.Node> unknown_serializable_nodes { owned get; }
		/**
		 * On deserialization stores any {@link GXml.Attribute} not used on this
		 * object, but exists in current XML file.
		 *
		 * Node's name is used as key to find stored {@link GXml.Attribute}, key is
		 * case sensitive.
		 *
		 * XML allows great flexibility, providing different ways to represent the same
		 * information. This is a problem when you try to deserialize them.
		 *
		 * In order to deserialize correctly, you must create your XML, both by
		 * serializing a {@link Serializable} object or by hand writing. By using the
		 * former, you can add extra information, like attributes, but most of
		 * them could be ignored or lost on deserialization/serialization process. To
		 * avoid data lost, you can override {@link get_enable_unknown_serializable_property}
		 * method in order to return true, your implementation or the ones in GXml, will
		 * store all unknown attributes on deserialization and must serialize
		 * again back to the XML file. Even you are allowed to get this unknown objects
		 * by iterating on {@link unknown_serializable_properties} collection, if you know
		 * attribute's name, use it to retrieve it.
		 *
		 * This property is ignored on serialisation.
		 */
		public abstract Gee.Map<string,GXml.Attribute> unknown_serializable_properties { owned get; }
		/**
		 * Signal to deserialize unknown properties.
		 *
		 * @param node a {@link GXml.Node} to get attribute from
		 * @param prop a {@link GLib.ParamSpec} describing attribute to deserialize
		 */
		public signal void deserialize_unknown_property (GXml.Node node, GLib.ParamSpec prop);
		/**
		 * Signal to deserialize unknown properties' type.
		 *
		 * @param node a {@link GXml.Node} to get attribute from
		 * @param prop a {@link GLib.ParamSpec} describing attribute to deserialize
		 */
		public signal void deserialize_unknown_property_type (GXml.Node node, GLib.ParamSpec prop);
		/**
		 * Signal to serialize unknown properties. Any new node must be added to
		 * @param element before return the new @param node added.
		 *
		 * @param element a {@link GXml.Node} to add attribute or child nodes to
		 * @param prop a {@link GLib.ParamSpec} describing attribute to serialize
		 * @param node set to the {@link GXml.Node} representing this attribute
		 */
		public signal void serialize_unknown_property (GXml.Node element, GLib.ParamSpec prop, out GXml.Node node);
		/**
		 * Signal to serialize unknown properties. Any new node must be added to
		 * @param element before return the new @node added.
		 * 
		 * @param element a {@link GXml.Node} to add attribute or child nodes to
		 * @param prop a {@link GLib.ParamSpec} describing attribute to serialize
		 * @param node set to the {@link GXml.Node} representing this attribute
		 */
		public signal void serialize_unknown_property_type (GXml.Node element, GLib.ParamSpec prop, out GXml.Node node);
	}
	/**
	 * Serializable Framework. interface to be implemented by any collection of {@link Serializable} objects.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface SerializableCollection : GLib.Object, Gee.Traversable<GXml.Serializable>, GXml.Serializable {
		/**
		 * Executes a deserialization from all children nodes in a {@link GXml.Node}. After this operation
		 * {@link GXml.SerializableCollection.deserialized} should return true.
		 *
		 * This could unref existing objects in collection.
		 */
		public abstract bool deserialize_children () throws GLib.Error;
		/**
		 * Executes a deserialization from a {@link GXml.Node}. After this operation
		 * {@link GXml.SerializableCollection.deserialized} should return true.
		 *
		 * This could unref existing objects in collection.
		 */
		public abstract bool deserialize_node (GXml.Node node) throws GLib.Error;
		/**
		 * Returns true if the collection should be deserialized from a {@link GXml.Node}'s children
		 * when {@link GXml.Serializable.deserialize} is called. For large collection of nodes
		 * this could impact in performance; return false and use {@link GXml.SerializableCollection.deserialize_children}
		 * when you need to deserialize all nodes to access them.
		 */
		public abstract bool deserialize_proceed ();
		/**
		 * Returns true if the collection was deserialized from a {@link GXml.Node}'s children.
		 */
		public abstract bool deserialized ();
		/**
		 * Convenient function to detect Serializable Collections.
		 */
		public virtual bool is_collection ();
	}
	/**
	 * Serializable Framework. Interface to get two keys to be used to store {@link Serializable} objects.
	 * 
	 * This interface must be implemented by classes derived from {@link GXml.SerializableDualKeyMap}.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface SerializableMapDualKey<P,S> : GLib.Object {
		/**
		 * Implement this function to return the value to be used as primary key on
		 * {@link SerializableDualKeyMap} containers.
		 */
		public abstract P get_map_primary_key ();
		/**
		 * Implement this function to return the value to be used as secondary key on
		 * {@link SerializableDualKeyMap} containers.
		 */
		public abstract S get_map_secondary_key ();
	}
	/**
	 * Serializable Framework. Interface to get one key to be used to store {@link Serializable} objects.
	 * 
	 * This interface must be implemented by classes derived from {@link SerializableTreeMap}
	 * and {@link SerializableHashMap}.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface SerializableMapKey<K> : GLib.Object {
		/**
		 * Implement this function to return the value to be used as key on {@link SerializableTreeMap}
		 * and {@link SerializableHashMap} containers.
		 */
		public abstract K get_map_key ();
	}
	/**
	 * Represent any property to be added as a {@link GXml.Attribute} to a {@link GXml.Element}
	 *
	 * The actual value stored and returned by {@link GXml.SerializableProperty.get_serializable_property_value}
	 * is the actual string in the XML property, this means may the value could differ from the spected value
	 * on some implementations like {@link GXml.SerializableInt}. Take a look in each implementations about
	 * retured values.
	 *
	 * Implementations of {@link GXml.SerializableProperty}, could be used to provide more flexibility
	 * when parsing {@link GXml.Attribute} properties values and to exclude to be serialized if they have not
	 * been created in the holding objects.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface SerializableProperty : GLib.Object {
		/**
		 * Tryies to deserialize from a {@link GXml.Node} searching a {@link GXml.Attribute}
		 * with the name in @param prop or from its nick if @nick is true.
		 */
		public bool default_serializable_property_deserialize_property (GXml.Node property_node, GLib.ParamSpec prop, bool nick) throws GLib.Error;
		/**
		 * Default serialization method to add a {@link GXml.Attribute} to a {@link GXml.Element}
		 *
		 * If {@link GXml.SerializableProperty.get_serializable_property_value} returns null
		 * given {@link GXml.Node} is not modified.
		 */
		public GXml.Node? default_serializable_property_serialize_property (GXml.Node element, GLib.ParamSpec prop, bool nick) throws GLib.Error;
		/**
		 * Tryies to deserialize from a {@link GXml.Node} searching a {@link GXml.Attribute}
		 * with the name provided in @param prop or its nick if @nick is true,
		 * if not set, then {@link GLib.ParamSpec} name should used. If @param nick is set to true,
		 * then {@link GLib.ParamSpec} nick is used as name.
		 */
		public virtual bool deserialize_property (GXml.Node property_node, GLib.ParamSpec prop, bool nick) throws GLib.Error;
		/**
		 * Value to be set to a {@link GXml.Attribute}, to be added to a {@link GXml.Element}
		 */
		public abstract string get_serializable_property_value ();
		/**
		 * Serialization method to add a {@link GXml.Attribute} to a {@link GXml.Element}, using {@link GLib.ParamSpec}
		 * name or nick, if @param nick is set to true, as the attribute's name.
		 *
		 * If {@link GXml.SerializableProperty.get_serializable_property_value} returns null
		 * given {@link GXml.Node} should not be modified.
		 */
		public virtual GXml.Node? serialize_property (GXml.Node property_node, GLib.ParamSpec prop, bool nick) throws GLib.Error;
		/**
		 * Set value to be set to a {@link GXml.Attribute}, to be added to a {@link GXml.Element}
		 *
		 * If value is set to @null then the property will be ignored by default and no
		 * property will be set to given {@link GXml.Element}.
		 *
		 * Some implementations stores the value without any convertion at all; then if the value,
		 * from XML property, makes no sense for the property type, you should take care
		 * to use the provided API from them to convert it.
		 */
		public abstract void set_serializable_property_value (string? val);
	}
	/**
	 * Representation of text nodes in any {@link GXml.Node}
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface Text : GLib.Object, GXml.Node {
		/**
		 * This should be implemented by returning {@link GXml.Node.value}
		 */
		public abstract string str { owned get; set; }
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface XPathContext : GLib.Object {
		/**
		 * Evaluate XPath expression.
		 *
		 * This method evaluates provided expression, registers provided namespaces in resolver and returns an {@link GXml.XPathObject}.
		 *
		 * Throw {@link GXml.XPathError} if one of provided namespaces is invalid.
		 */
		public abstract GXml.XPathObject evaluate (string expression, Gee.List<GXml.Namespace>? resolver = null) throws GXml.XPathError;
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public interface XPathObject : GLib.Object {
		/**
		 *
		 */
		public abstract bool boolean_value { get; }
		/**
		 *
		 */
		public abstract GXml.DomHTMLCollection nodeset { get; }
		/**
		 *
		 */
		public abstract double number_value { get; }
		/**
		 *
		 */
		public abstract GXml.XPathObjectType object_type { get; }
		/**
		 *
		 */
		public abstract string string_value { get; }
	}
	/**
	 * Enumerates possible NodeTypes.
	 *
	 * For more, see: [[http://www.w3.org/TR/DOM-Level-1/level-one-core.html#ID-1950641247]]
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public enum NodeType {
		INVALID,
		ELEMENT,
		ATTRIBUTE,
		TEXT,
		CDATA_SECTION,
		ENTITY_REFERENCE,
		ENTITY,
		PROCESSING_INSTRUCTION,
		COMMENT,
		DOCUMENT,
		DOCUMENT_TYPE,
		DOCUMENT_FRAGMENT,
		NOTATION
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public enum XPathObjectType {
		UNDEFINED,
		NODESET,
		BOOLEAN,
		NUMBER,
		STRING,
		POINT,
		RANGE,
		LOCATIONSET,
		USERS,
		XSLT_TREE
	}
	/**
	 * Errors for documents handling reading/writing
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public errordomain DocumentError {
		INVALID_DOCUMENT_ERROR,
		INVALID_FILE
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public errordomain DomError {
		INDEX_SIZE_ERROR,
		DOMSTRING_SIZE_ERROR,
		HIERARCHY_REQUEST_ERROR,
		WRONG_DOCUMENT_ERROR,
		INVALID_CHARACTER_ERROR,
		NO_DATA_ALLOWED_ERROR,
		NO_MODIFICATION_ALLOWED_ERROR,
		NOT_FOUND_ERROR,
		NOT_SUPPORTED_ERROR,
		INUSE_ATTRIBUTE_ERROR,
		INVALID_STATE_ERROR,
		SYNTAX_ERROR,
		INVALID_MODIFICATION_ERROR,
		NAMESPACE_ERROR,
		INVALID_ACCESS_ERROR,
		VALIDATION_ERROR,
		TYPE_MISMATCH_ERROR,
		SECURITY_ERROR,
		NETWORK_ERROR,
		ABORT_ERROR,
		URL_MISMATCH_ERROR,
		QUOTA_EXCEEDED_ERROR,
		TIME_OUT_ERROR,
		INVALID_NODE_TYPE_ERROR,
		DATA_CLONE_ERROR
	}
	/**
	 * Errors when de/serializing enumerations.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public errordomain EnumerationError {
		/**
		 * Given value is invalid in enumeration, when transform to string.
		 */
		INVALID_VALUE,
		/**
		 * Given text to transform to an enumeration's value.
		 */
		INVALID_TEXT
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public errordomain Error {
		NOT_SUPPORTED,
		PARSER,
		WRITER
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public errordomain IXsdSchemaError {
		INVALIDATION_ERROR
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public errordomain ParserError {
		INVALID_DATA_ERROR,
		INVALID_FILE_ERROR,
		INVALID_STREAM_ERROR
	}
	/**
	 * Errors when de/serializing enumerations as a set of string when using {@link GXml.SerializableEnum}
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public errordomain SerializableEnumError {
		INVALID_VALUE_ERROR,
		PARSE_ERROR
	}
	/**
	 * Errors from {@link Serializable}.
	 */
	[CCode (cheader_filename = "gxml/gxml.h")]
	public errordomain SerializableError {
		/**
		 * An object with a known {@link GLib.Type} that we do not support was encountered.
		 */
		UNSUPPORTED_TYPE_ERROR,
		STR_TO_VALUE_ERROR
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public errordomain XPathError {
		EXPRESSION_OK,
		NUMBER_ERROR,
		UNFINISHED_LITERAL_ERROR,
		START_LITERAL_ERROR,
		VARIABLE_REF_ERROR,
		UNDEF_VARIABLE_ERROR,
		INVALID_PREDICATE_ERROR,
		EXPR_ERROR,
		UNCLOSED_ERROR,
		UNKNOWN_FUNC_ERROR,
		INVALID_OPERAND,
		INVALID_TYPE,
		INVALID_ARITY,
		INVALID_CTXT_SIZE,
		INVALID_CTXT_POSITION,
		MEMORY_ERROR,
		XPTR_SYNTAX_ERROR,
		XPTR_RESOURCE_ERROR,
		XPTR_SUB_RESOURCE_ERROR,
		UNDEF_PREFIX_ERROR,
		ENCODING_ERROR,
		INVALID_CHAR_ERROR,
		INVALID_CTXT
	}
	[CCode (cheader_filename = "gxml/gxml.h")]
	public delegate void DomMutationCallback (Gee.List<GXml.DomMutationRecord> mutations, GXml.DomMutationObserver observer);
}
