/* Document.c generated by valac 0.39.3.9-ecb8a, the Vala compiler
 * generated from Document.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; c-basic-offset: 0; tab-width: 2 -*- */
/* ObjectModel.vala
 *
 * Copyright (C) 2015  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define GXML_TYPE_NODE (gxml_node_get_type ())
#define GXML_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NODE, GXmlNode))
#define GXML_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NODE))
#define GXML_NODE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NODE, GXmlNodeIface))

typedef struct _GXmlNode GXmlNode;
typedef struct _GXmlNodeIface GXmlNodeIface;

#define GXML_TYPE_ELEMENT_LIST (gxml_element_list_get_type ())
#define GXML_ELEMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ELEMENT_LIST, GXmlElementList))
#define GXML_ELEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_ELEMENT_LIST, GXmlElementListClass))
#define GXML_IS_ELEMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ELEMENT_LIST))
#define GXML_IS_ELEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_ELEMENT_LIST))
#define GXML_ELEMENT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_ELEMENT_LIST, GXmlElementListClass))

typedef struct _GXmlElementList GXmlElementList;
typedef struct _GXmlElementListClass GXmlElementListClass;

#define GXML_TYPE_NAMESPACE (gxml_namespace_get_type ())
#define GXML_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NAMESPACE, GXmlNamespace))
#define GXML_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NAMESPACE))
#define GXML_NAMESPACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NAMESPACE, GXmlNamespaceIface))

typedef struct _GXmlNamespace GXmlNamespace;
typedef struct _GXmlNamespaceIface GXmlNamespaceIface;

#define GXML_TYPE_NODE_TYPE (gxml_node_type_get_type ())

#define GXML_TYPE_DOCUMENT (gxml_document_get_type ())
#define GXML_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOCUMENT, GXmlDocument))
#define GXML_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOCUMENT))
#define GXML_DOCUMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOCUMENT, GXmlDocumentIface))

typedef struct _GXmlDocument GXmlDocument;
typedef struct _GXmlDocumentIface GXmlDocumentIface;

#define GXML_TYPE_GNODE (gxml_gnode_get_type ())
#define GXML_GNODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_GNODE, GXmlGNode))
#define GXML_GNODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_GNODE, GXmlGNodeClass))
#define GXML_IS_GNODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_GNODE))
#define GXML_IS_GNODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_GNODE))
#define GXML_GNODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_GNODE, GXmlGNodeClass))

typedef struct _GXmlGNode GXmlGNode;
typedef struct _GXmlGNodeClass GXmlGNodeClass;

#define GXML_TYPE_GDOCUMENT (gxml_gdocument_get_type ())
#define GXML_GDOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_GDOCUMENT, GXmlGDocument))
#define GXML_GDOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_GDOCUMENT, GXmlGDocumentClass))
#define GXML_IS_GDOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_GDOCUMENT))
#define GXML_IS_GDOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_GDOCUMENT))
#define GXML_GDOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_GDOCUMENT, GXmlGDocumentClass))

typedef struct _GXmlGDocument GXmlGDocument;
typedef struct _GXmlGDocumentClass GXmlGDocumentClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

/**
 * Errors for documents handling {@link GXml.Document} reading/writing
 */
typedef enum  {
	GXML_DOCUMENT_ERROR_INVALID_DOCUMENT_ERROR,
	GXML_DOCUMENT_ERROR_INVALID_FILE
} GXmlDocumentError;
#define GXML_DOCUMENT_ERROR gxml_document_error_quark ()
struct _GXmlNamespaceIface {
	GTypeInterface parent_iface;
	gchar* (*get_uri) (GXmlNamespace* self);
	gchar* (*get_prefix) (GXmlNamespace* self);
};

typedef enum  {
	GXML_NODE_TYPE_INVALID = 0,
	GXML_NODE_TYPE_ELEMENT = 1,
	GXML_NODE_TYPE_ATTRIBUTE,
	GXML_NODE_TYPE_TEXT,
	GXML_NODE_TYPE_CDATA_SECTION,
	GXML_NODE_TYPE_ENTITY_REFERENCE,
	GXML_NODE_TYPE_ENTITY,
	GXML_NODE_TYPE_PROCESSING_INSTRUCTION,
	GXML_NODE_TYPE_COMMENT,
	GXML_NODE_TYPE_DOCUMENT,
	GXML_NODE_TYPE_DOCUMENT_TYPE,
	GXML_NODE_TYPE_DOCUMENT_FRAGMENT,
	GXML_NODE_TYPE_NOTATION
} GXmlNodeType;

struct _GXmlNodeIface {
	GTypeInterface parent_iface;
	GXmlNode* (*get) (GXmlNode* self, const gchar* key);
	GXmlElementList* (*get_elements_by_property_value) (GXmlNode* self, const gchar* property, const gchar* value);
	GXmlElementList* (*get_elements_by_name) (GXmlNode* self, const gchar* name);
	GXmlElementList* (*get_elements_by_name_ns) (GXmlNode* self, const gchar* name, const gchar* ns);
	gchar* (*to_string) (GXmlNode* self);
	gboolean (*set_namespace) (GXmlNode* self, const gchar* uri, const gchar* prefix);
	gchar* (*ns_prefix) (GXmlNode* self);
	gchar* (*ns_uri) (GXmlNode* self);
	GeeList* (*get_namespaces) (GXmlNode* self);
	GeeBidirList* (*get_children_nodes) (GXmlNode* self);
	GeeMap* (*get_attrs) (GXmlNode* self);
	gchar* (*get_name) (GXmlNode* self);
	gchar* (*get_value) (GXmlNode* self);
	void (*set_value) (GXmlNode* self, const gchar* value);
	GXmlNodeType (*get_type_node) (GXmlNode* self);
	GXmlDocument* (*get_document) (GXmlNode* self);
	GXmlNode* (*get_parent) (GXmlNode* self);
};

struct _GXmlDocumentIface {
	GTypeInterface parent_iface;
	GXmlNode* (*create_element) (GXmlDocument* self, const gchar* name, GError** error);
	GXmlNode* (*create_text) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_comment) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_cdata) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_pi) (GXmlDocument* self, const gchar* target, const gchar* data);
	gboolean (*save) (GXmlDocument* self, GCancellable* cancellable, GError** error);
	gboolean (*save_as) (GXmlDocument* self, GFile* f, GCancellable* cancellable, GError** error);
	gboolean (*get_indent) (GXmlDocument* self);
	void (*set_indent) (GXmlDocument* self, gboolean value);
	gboolean (*get_ns_top) (GXmlDocument* self);
	void (*set_ns_top) (GXmlDocument* self, gboolean value);
	gboolean (*get_prefix_default_ns) (GXmlDocument* self);
	void (*set_prefix_default_ns) (GXmlDocument* self, gboolean value);
	gboolean (*get_backup) (GXmlDocument* self);
	void (*set_backup) (GXmlDocument* self, gboolean value);
	GXmlNode* (*get_root) (GXmlDocument* self);
	GFile* (*get_file) (GXmlDocument* self);
	void (*set_file) (GXmlDocument* self, GFile* value);
};



GQuark gxml_document_error_quark (void);
GType gxml_element_list_get_type (void) G_GNUC_CONST;
GType gxml_namespace_get_type (void) G_GNUC_CONST;
GType gxml_node_type_get_type (void) G_GNUC_CONST;
GType gxml_node_get_type (void) G_GNUC_CONST;
GType gxml_document_get_type (void) G_GNUC_CONST;
GXmlNode* gxml_document_create_element (GXmlDocument* self, 
                                        const gchar* name, 
                                        GError** error);
GXmlNode* gxml_document_create_text (GXmlDocument* self, 
                                     const gchar* text);
GXmlNode* gxml_document_create_comment (GXmlDocument* self, 
                                        const gchar* text);
GXmlNode* gxml_document_create_cdata (GXmlDocument* self, 
                                      const gchar* text);
GXmlNode* gxml_document_create_pi (GXmlDocument* self, 
                                   const gchar* target, 
                                   const gchar* data);
gboolean gxml_document_save (GXmlDocument* self, 
                             GCancellable* cancellable, 
                             GError** error);
gboolean gxml_document_save_as (GXmlDocument* self, 
                                GFile* f, 
                                GCancellable* cancellable, 
                                GError** error);
GXmlDocument* gxml_document_new_default (void);
GXmlGDocument* gxml_gdocument_new (void);
GXmlGDocument* gxml_gdocument_construct (GType object_type);
GType gxml_gnode_get_type (void) G_GNUC_CONST;
GType gxml_gdocument_get_type (void) G_GNUC_CONST;
GXmlDocument* gxml_document_new_default_for_path (const gchar* path, 
                                                  GError** error);
GXmlDocument* gxml_document_new_default_for_file (GFile* f, 
                                                  GError** error);
GXmlGDocument* gxml_gdocument_new_from_path (const gchar* path, 
                                             gint options, 
                                             GError** error);
GXmlGDocument* gxml_gdocument_construct_from_path (GType object_type, 
                                                   const gchar* path, 
                                                   gint options, 
                                                   GError** error);
void gxml_document_set_file (GXmlDocument* self, 
                             GFile* value);
gboolean gxml_document_get_indent (GXmlDocument* self);
void gxml_document_set_indent (GXmlDocument* self, 
                               gboolean value);
gboolean gxml_document_get_ns_top (GXmlDocument* self);
void gxml_document_set_ns_top (GXmlDocument* self, 
                               gboolean value);
gboolean gxml_document_get_prefix_default_ns (GXmlDocument* self);
void gxml_document_set_prefix_default_ns (GXmlDocument* self, 
                                          gboolean value);
gboolean gxml_document_get_backup (GXmlDocument* self);
void gxml_document_set_backup (GXmlDocument* self, 
                               gboolean value);
GXmlNode* gxml_document_get_root (GXmlDocument* self);
GFile* gxml_document_get_file (GXmlDocument* self);


GQuark
gxml_document_error_quark (void)
{
	return g_quark_from_static_string ("gxml_document_error-quark");
}


/**
   * This method should create a new {@link GXml.Element}.
   *
   * Is a matter of you to add as a child to any other
   * {@link GXml.Node}.
   */
GXmlNode*
gxml_document_create_element (GXmlDocument* self, 
                              const gchar* name, 
                              GError** error)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOCUMENT_GET_INTERFACE (self)->create_element (self, name, error);
}


/**
   * Creates a new {@link GXml.Text}.
   *
   * Is a matter of you to add as a child to any other
   * {@link GXml.Node}, like a {@link GXml.Element} node.
   */
GXmlNode*
gxml_document_create_text (GXmlDocument* self, 
                           const gchar* text)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOCUMENT_GET_INTERFACE (self)->create_text (self, text);
}


/**
   * Creates a new {@link GXml.Comment}.
   *
   * Is a matter of you to add as a child to any other
   * {@link GXml.Node}, like a {@link GXml.Element} node.
   */
GXmlNode*
gxml_document_create_comment (GXmlDocument* self, 
                              const gchar* text)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOCUMENT_GET_INTERFACE (self)->create_comment (self, text);
}


/**
   * Creates a new {@link GXml.CDATA}.
   *
   * Is a matter of you to add as a child to any other
   * {@link GXml.Node}, like a {@link GXml.Element} node.
   */
GXmlNode*
gxml_document_create_cdata (GXmlDocument* self, 
                            const gchar* text)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOCUMENT_GET_INTERFACE (self)->create_cdata (self, text);
}


/**
   * Creates a new {@link GXml.ProcessingInstruction}.
   *
   * Is a matter of you to add as a child to any other
   * {@link GXml.Node}, like a {@link GXml.Element} node.
   */
GXmlNode*
gxml_document_create_pi (GXmlDocument* self, 
                         const gchar* target, 
                         const gchar* data)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOCUMENT_GET_INTERFACE (self)->create_pi (self, target, data);
}


/**
   * Save this {@link GXml.Document} to {@link GXml.Document.file}
   *
   * If {@link GXml.Document.file} doesn't exists, it creates a new file to save to.
   */
gboolean
gxml_document_save (GXmlDocument* self, 
                    GCancellable* cancellable, 
                    GError** error)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_DOCUMENT_GET_INTERFACE (self)->save (self, cancellable, error);
}


/**
   * Save this {@link GXml.Document} to given {@link GLib.File}
   */
gboolean
gxml_document_save_as (GXmlDocument* self, 
                       GFile* f, 
                       GCancellable* cancellable, 
                       GError** error)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_DOCUMENT_GET_INTERFACE (self)->save_as (self, f, cancellable, error);
}


/**
   * Creates a new {@link GXml.Document} using default implementation class.
   *
   * As an interface you can create your own implementation of it, but if 
   * default one is required use this.
   */
GXmlDocument*
gxml_document_new_default (void)
{
	GXmlDocument* result = NULL;
	GXmlGDocument* _tmp0_;
	_tmp0_ = gxml_gdocument_new ();
	result = (GXmlDocument*) _tmp0_;
	return result;
}


/**
   * Creates a new {@link GXml.Document} from a file path using default implementation class.
   *
   * As an interface you can create your own implementation of it, but if 
   * default one is required use this.
   */
GXmlDocument*
gxml_document_new_default_for_path (const gchar* path, 
                                    GError** error)
{
	GXmlDocument* result = NULL;
	GFile* f = NULL;
	GFile* _tmp0_;
	GXmlDocument* _tmp1_ = NULL;
	GXmlDocument* _tmp2_;
	GXmlDocument* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = g_file_new_for_path (path);
	f = _tmp0_;
	_tmp2_ = gxml_document_new_default_for_file (f, &_inner_error_);
	_tmp1_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (f);
		return NULL;
	}
	_tmp3_ = _tmp1_;
	_tmp1_ = NULL;
	result = _tmp3_;
	_g_object_unref0 (_tmp1_);
	_g_object_unref0 (f);
	return result;
}


/**
   * Creates a new {@link GXml.Document} from a {@link GLib.File} using default implementation class.
   *
   * As an interface you can create your own implementation of it, but if 
   * default one is required use this.
   */
GXmlDocument*
gxml_document_new_default_for_file (GFile* f, 
                                    GError** error)
{
	GXmlDocument* result = NULL;
	GXmlGDocument* d = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GXmlGDocument* _tmp2_;
	GXmlGDocument* _tmp3_;
	GXmlGDocument* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (f != NULL, NULL);
	_tmp0_ = g_file_get_path (f);
	_tmp1_ = _tmp0_;
	_tmp2_ = gxml_gdocument_new_from_path (_tmp1_, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	d = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	if (!g_file_query_exists (f, NULL)) {
		GError* _tmp4_;
		_tmp4_ = g_error_new_literal (GXML_DOCUMENT_ERROR, GXML_DOCUMENT_ERROR_INVALID_FILE, _ ("Invalid file"));
		_inner_error_ = _tmp4_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (d);
		return NULL;
	}
	_tmp5_ = d;
	gxml_document_set_file ((GXmlDocument*) _tmp5_, f);
	result = (GXmlDocument*) d;
	return result;
}


gboolean
gxml_document_get_indent (GXmlDocument* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_DOCUMENT_GET_INTERFACE (self)->get_indent (self);
}


void
gxml_document_set_indent (GXmlDocument* self, 
                          gboolean value)
{
	g_return_if_fail (self != NULL);
	GXML_DOCUMENT_GET_INTERFACE (self)->set_indent (self, value);
}


gboolean
gxml_document_get_ns_top (GXmlDocument* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_DOCUMENT_GET_INTERFACE (self)->get_ns_top (self);
}


void
gxml_document_set_ns_top (GXmlDocument* self, 
                          gboolean value)
{
	g_return_if_fail (self != NULL);
	GXML_DOCUMENT_GET_INTERFACE (self)->set_ns_top (self, value);
}


gboolean
gxml_document_get_prefix_default_ns (GXmlDocument* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_DOCUMENT_GET_INTERFACE (self)->get_prefix_default_ns (self);
}


void
gxml_document_set_prefix_default_ns (GXmlDocument* self, 
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	GXML_DOCUMENT_GET_INTERFACE (self)->set_prefix_default_ns (self, value);
}


gboolean
gxml_document_get_backup (GXmlDocument* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_DOCUMENT_GET_INTERFACE (self)->get_backup (self);
}


void
gxml_document_set_backup (GXmlDocument* self, 
                          gboolean value)
{
	g_return_if_fail (self != NULL);
	GXML_DOCUMENT_GET_INTERFACE (self)->set_backup (self, value);
}


GXmlNode*
gxml_document_get_root (GXmlDocument* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOCUMENT_GET_INTERFACE (self)->get_root (self);
}


GFile*
gxml_document_get_file (GXmlDocument* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOCUMENT_GET_INTERFACE (self)->get_file (self);
}


void
gxml_document_set_file (GXmlDocument* self, 
                        GFile* value)
{
	g_return_if_fail (self != NULL);
	GXML_DOCUMENT_GET_INTERFACE (self)->set_file (self, value);
}


static void
gxml_document_base_init (GXmlDocumentIface * iface)
{
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		   * Controls if writting this documents should use indent.
		   */
		g_object_interface_install_property (iface, g_param_spec_boolean ("indent", "indent", "indent", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		/**
		   * Controls if writting this documentsshould use namespaces
		   * declaration at root {@link GXml.Element}.
		   *
		   * This removes full declaration at childs nodes, because they
		   * are just prefixed if a prefix was defined for namespace apply.
		   */
		g_object_interface_install_property (iface, g_param_spec_boolean ("ns-top", "ns-top", "ns-top", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		/**
		   * Controls if writting this document should use default namespace's prefix
		   * to prefix root's childs {@link GXml.Element}.
		   *
		   * This removes prefix on childs using default namespace. Default namespace
		   * is the first one found in {@link GXml.Node.namespaces} for this document.
		   */
		g_object_interface_install_property (iface, g_param_spec_boolean ("prefix-default-ns", "prefix-default-ns", "prefix-default-ns", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		/**
		   * Controls if writting to a {@link GLib.File} creates a backup, by default
		   * is true;
		   */
		g_object_interface_install_property (iface, g_param_spec_boolean ("backup", "backup", "backup", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		/**
		   * XML document root node as a {@link GXml.Element}.
		   */
		g_object_interface_install_property (iface, g_param_spec_object ("root", "root", "root", GXML_TYPE_NODE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		/**
		   * Stores a {@link GLib.File} to save/read XML documents to/from.
		   */
		g_object_interface_install_property (iface, g_param_spec_object ("file", "file", "file", g_file_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	}
}


/**
 * Interface to handle XML documents.
 *
 * Provides basic interfaces to read and create XML documents.
 */
GType
gxml_document_get_type (void)
{
	static volatile gsize gxml_document_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_document_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlDocumentIface), (GBaseInitFunc) gxml_document_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gxml_document_type_id;
		gxml_document_type_id = g_type_register_static (G_TYPE_INTERFACE, "GXmlDocument", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gxml_document_type_id, G_TYPE_OBJECT);
		g_type_interface_add_prerequisite (gxml_document_type_id, GXML_TYPE_NODE);
		g_once_init_leave (&gxml_document_type_id__volatile, gxml_document_type_id);
	}
	return gxml_document_type_id__volatile;
}



