/* SerializableObjectModel.c generated by valac 0.39.3.9-ecb8a, the Vala compiler
 * generated from SerializableObjectModel.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; c-basic-offset: 0; tab-width: 2 -*- */
/* ObjectModel.vala
 *
 * Copyright (C) 2013-2015  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define GXML_TYPE_SERIALIZABLE (gxml_serializable_get_type ())
#define GXML_SERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE, GXmlSerializable))
#define GXML_IS_SERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE))
#define GXML_SERIALIZABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_SERIALIZABLE, GXmlSerializableIface))

typedef struct _GXmlSerializable GXmlSerializable;
typedef struct _GXmlSerializableIface GXmlSerializableIface;

#define GXML_TYPE_NODE (gxml_node_get_type ())
#define GXML_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NODE, GXmlNode))
#define GXML_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NODE))
#define GXML_NODE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NODE, GXmlNodeIface))

typedef struct _GXmlNode GXmlNode;
typedef struct _GXmlNodeIface GXmlNodeIface;

#define GXML_TYPE_ELEMENT_LIST (gxml_element_list_get_type ())
#define GXML_ELEMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ELEMENT_LIST, GXmlElementList))
#define GXML_ELEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_ELEMENT_LIST, GXmlElementListClass))
#define GXML_IS_ELEMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ELEMENT_LIST))
#define GXML_IS_ELEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_ELEMENT_LIST))
#define GXML_ELEMENT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_ELEMENT_LIST, GXmlElementListClass))

typedef struct _GXmlElementList GXmlElementList;
typedef struct _GXmlElementListClass GXmlElementListClass;

#define GXML_TYPE_NAMESPACE (gxml_namespace_get_type ())
#define GXML_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NAMESPACE, GXmlNamespace))
#define GXML_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NAMESPACE))
#define GXML_NAMESPACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NAMESPACE, GXmlNamespaceIface))

typedef struct _GXmlNamespace GXmlNamespace;
typedef struct _GXmlNamespaceIface GXmlNamespaceIface;

#define GXML_TYPE_NODE_TYPE (gxml_node_type_get_type ())

#define GXML_TYPE_DOCUMENT (gxml_document_get_type ())
#define GXML_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOCUMENT, GXmlDocument))
#define GXML_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOCUMENT))
#define GXML_DOCUMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOCUMENT, GXmlDocumentIface))

typedef struct _GXmlDocument GXmlDocument;
typedef struct _GXmlDocumentIface GXmlDocumentIface;

#define GXML_TYPE_ATTRIBUTE (gxml_attribute_get_type ())
#define GXML_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ATTRIBUTE, GXmlAttribute))
#define GXML_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ATTRIBUTE))
#define GXML_ATTRIBUTE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_ATTRIBUTE, GXmlAttributeIface))

typedef struct _GXmlAttribute GXmlAttribute;
typedef struct _GXmlAttributeIface GXmlAttributeIface;

#define GXML_TYPE_SERIALIZABLE_OBJECT_MODEL (gxml_serializable_object_model_get_type ())
#define GXML_SERIALIZABLE_OBJECT_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE_OBJECT_MODEL, GXmlSerializableObjectModel))
#define GXML_SERIALIZABLE_OBJECT_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_SERIALIZABLE_OBJECT_MODEL, GXmlSerializableObjectModelClass))
#define GXML_IS_SERIALIZABLE_OBJECT_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE_OBJECT_MODEL))
#define GXML_IS_SERIALIZABLE_OBJECT_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_SERIALIZABLE_OBJECT_MODEL))
#define GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_SERIALIZABLE_OBJECT_MODEL, GXmlSerializableObjectModelClass))

typedef struct _GXmlSerializableObjectModel GXmlSerializableObjectModel;
typedef struct _GXmlSerializableObjectModelClass GXmlSerializableObjectModelClass;
typedef struct _GXmlSerializableObjectModelPrivate GXmlSerializableObjectModelPrivate;
enum  {
	GXML_SERIALIZABLE_OBJECT_MODEL_0_PROPERTY,
	GXML_SERIALIZABLE_OBJECT_MODEL_IGNORED_SERIALIZABLE_PROPERTIES_PROPERTY,
	GXML_SERIALIZABLE_OBJECT_MODEL_SERIALIZED_XML_NODE_VALUE_PROPERTY,
	GXML_SERIALIZABLE_OBJECT_MODEL_UNKNOWN_SERIALIZABLE_PROPERTIES_PROPERTY,
	GXML_SERIALIZABLE_OBJECT_MODEL_UNKNOWN_SERIALIZABLE_NODES_PROPERTY,
	GXML_SERIALIZABLE_OBJECT_MODEL_NUM_PROPERTIES
};
static GParamSpec* gxml_serializable_object_model_properties[GXML_SERIALIZABLE_OBJECT_MODEL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GXML_TYPE_ELEMENT (gxml_element_get_type ())
#define GXML_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ELEMENT, GXmlElement))
#define GXML_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ELEMENT))
#define GXML_ELEMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_ELEMENT, GXmlElementIface))

typedef struct _GXmlElement GXmlElement;
typedef struct _GXmlElementIface GXmlElementIface;
#define _g_param_spec_unref0(var) ((var == NULL) ? NULL : (var = (g_param_spec_unref (var), NULL)))

#define GXML_TYPE_TEXT (gxml_text_get_type ())
#define GXML_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_TEXT, GXmlText))
#define GXML_IS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_TEXT))
#define GXML_TEXT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_TEXT, GXmlTextIface))

typedef struct _GXmlText GXmlText;
typedef struct _GXmlTextIface GXmlTextIface;

#define GXML_TYPE_SERIALIZABLE_PROPERTY (gxml_serializable_property_get_type ())
#define GXML_SERIALIZABLE_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE_PROPERTY, GXmlSerializableProperty))
#define GXML_IS_SERIALIZABLE_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE_PROPERTY))
#define GXML_SERIALIZABLE_PROPERTY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_SERIALIZABLE_PROPERTY, GXmlSerializablePropertyIface))

typedef struct _GXmlSerializableProperty GXmlSerializableProperty;
typedef struct _GXmlSerializablePropertyIface GXmlSerializablePropertyIface;

#define GXML_TYPE_SERIALIZABLE_COLLECTION (gxml_serializable_collection_get_type ())
#define GXML_SERIALIZABLE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE_COLLECTION, GXmlSerializableCollection))
#define GXML_IS_SERIALIZABLE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE_COLLECTION))
#define GXML_SERIALIZABLE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_SERIALIZABLE_COLLECTION, GXmlSerializableCollectionIface))

typedef struct _GXmlSerializableCollection GXmlSerializableCollection;
typedef struct _GXmlSerializableCollectionIface GXmlSerializableCollectionIface;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GXML_TYPE_SERIALIZABLE_CONTAINER (gxml_serializable_container_get_type ())
#define GXML_SERIALIZABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE_CONTAINER, GXmlSerializableContainer))
#define GXML_SERIALIZABLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_SERIALIZABLE_CONTAINER, GXmlSerializableContainerClass))
#define GXML_IS_SERIALIZABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE_CONTAINER))
#define GXML_IS_SERIALIZABLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_SERIALIZABLE_CONTAINER))
#define GXML_SERIALIZABLE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_SERIALIZABLE_CONTAINER, GXmlSerializableContainerClass))

typedef struct _GXmlSerializableContainer GXmlSerializableContainer;
typedef struct _GXmlSerializableContainerClass GXmlSerializableContainerClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GXmlNamespaceIface {
	GTypeInterface parent_iface;
	gchar* (*get_uri) (GXmlNamespace* self);
	gchar* (*get_prefix) (GXmlNamespace* self);
};

typedef enum  {
	GXML_NODE_TYPE_INVALID = 0,
	GXML_NODE_TYPE_ELEMENT = 1,
	GXML_NODE_TYPE_ATTRIBUTE,
	GXML_NODE_TYPE_TEXT,
	GXML_NODE_TYPE_CDATA_SECTION,
	GXML_NODE_TYPE_ENTITY_REFERENCE,
	GXML_NODE_TYPE_ENTITY,
	GXML_NODE_TYPE_PROCESSING_INSTRUCTION,
	GXML_NODE_TYPE_COMMENT,
	GXML_NODE_TYPE_DOCUMENT,
	GXML_NODE_TYPE_DOCUMENT_TYPE,
	GXML_NODE_TYPE_DOCUMENT_FRAGMENT,
	GXML_NODE_TYPE_NOTATION
} GXmlNodeType;

struct _GXmlDocumentIface {
	GTypeInterface parent_iface;
	GXmlNode* (*create_element) (GXmlDocument* self, const gchar* name, GError** error);
	GXmlNode* (*create_text) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_comment) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_cdata) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_pi) (GXmlDocument* self, const gchar* target, const gchar* data);
	gboolean (*save) (GXmlDocument* self, GCancellable* cancellable, GError** error);
	gboolean (*save_as) (GXmlDocument* self, GFile* f, GCancellable* cancellable, GError** error);
	gboolean (*get_indent) (GXmlDocument* self);
	void (*set_indent) (GXmlDocument* self, gboolean value);
	gboolean (*get_ns_top) (GXmlDocument* self);
	void (*set_ns_top) (GXmlDocument* self, gboolean value);
	gboolean (*get_prefix_default_ns) (GXmlDocument* self);
	void (*set_prefix_default_ns) (GXmlDocument* self, gboolean value);
	gboolean (*get_backup) (GXmlDocument* self);
	void (*set_backup) (GXmlDocument* self, gboolean value);
	GXmlNode* (*get_root) (GXmlDocument* self);
	GFile* (*get_file) (GXmlDocument* self);
	void (*set_file) (GXmlDocument* self, GFile* value);
};

struct _GXmlNodeIface {
	GTypeInterface parent_iface;
	GXmlNode* (*get) (GXmlNode* self, const gchar* key);
	GXmlElementList* (*get_elements_by_property_value) (GXmlNode* self, const gchar* property, const gchar* value);
	GXmlElementList* (*get_elements_by_name) (GXmlNode* self, const gchar* name);
	GXmlElementList* (*get_elements_by_name_ns) (GXmlNode* self, const gchar* name, const gchar* ns);
	gchar* (*to_string) (GXmlNode* self);
	gboolean (*set_namespace) (GXmlNode* self, const gchar* uri, const gchar* prefix);
	gchar* (*ns_prefix) (GXmlNode* self);
	gchar* (*ns_uri) (GXmlNode* self);
	GeeList* (*get_namespaces) (GXmlNode* self);
	GeeBidirList* (*get_children_nodes) (GXmlNode* self);
	GeeMap* (*get_attrs) (GXmlNode* self);
	gchar* (*get_name) (GXmlNode* self);
	gchar* (*get_value) (GXmlNode* self);
	void (*set_value) (GXmlNode* self, const gchar* value);
	GXmlNodeType (*get_type_node) (GXmlNode* self);
	GXmlDocument* (*get_document) (GXmlNode* self);
	GXmlNode* (*get_parent) (GXmlNode* self);
};

struct _GXmlAttributeIface {
	GTypeInterface parent_iface;
	GXmlNamespace* (*get_namespace) (GXmlAttribute* self);
	void (*set_namespace) (GXmlAttribute* self, GXmlNamespace* value);
	gchar* (*get_prefix) (GXmlAttribute* self);
};

struct _GXmlSerializableIface {
	GTypeInterface parent_iface;
	gboolean (*get_enable_unknown_serializable_property) (GXmlSerializable* self);
	gboolean (*set_default_namespace) (GXmlSerializable* self, GXmlNode* node);
	gboolean (*serialize_use_xml_node_value) (GXmlSerializable* self);
	gchar* (*node_name) (GXmlSerializable* self);
	gboolean (*property_use_nick) (GXmlSerializable* self);
	GXmlNode* (*serialize) (GXmlSerializable* self, GXmlNode* node, GError** error);
	GXmlNode* (*serialize_property) (GXmlSerializable* self, GXmlNode* element, GParamSpec* prop, GError** error);
	gboolean (*deserialize) (GXmlSerializable* self, GXmlNode* node, GError** error);
	gboolean (*deserialize_property) (GXmlSerializable* self, GXmlNode* property_node, GError** error);
	GParamSpec* (*find_property_spec) (GXmlSerializable* self, const gchar* property_name);
	GParamSpec* (*default_find_property_spec) (GXmlSerializable* self, const gchar* property_name);
	GParamSpec** (*list_serializable_properties) (GXmlSerializable* self, int* result_length1);
	GParamSpec** (*default_list_serializable_properties) (GXmlSerializable* self, int* result_length1);
	GeeMap* (*get_unknown_serializable_properties) (GXmlSerializable* self);
	GeeCollection* (*get_unknown_serializable_nodes) (GXmlSerializable* self);
	gchar* (*get_serialized_xml_node_value) (GXmlSerializable* self);
	void (*set_serialized_xml_node_value) (GXmlSerializable* self, const gchar* value);
};

struct _GXmlSerializableObjectModel {
	GObject parent_instance;
	GXmlSerializableObjectModelPrivate * priv;
	GXmlNode* _node;
};

struct _GXmlSerializableObjectModelClass {
	GObjectClass parent_class;
	gboolean (*get_enable_unknown_serializable_property) (GXmlSerializableObjectModel* self);
	gboolean (*serialize_use_xml_node_value) (GXmlSerializableObjectModel* self);
	gboolean (*property_use_nick) (GXmlSerializableObjectModel* self);
	gboolean (*set_default_namespace) (GXmlSerializableObjectModel* self, GXmlNode* node);
	gchar* (*node_name) (GXmlSerializableObjectModel* self);
	GParamSpec* (*find_property_spec) (GXmlSerializableObjectModel* self, const gchar* property_name);
	GParamSpec** (*list_serializable_properties) (GXmlSerializableObjectModel* self, int* result_length1);
	GXmlNode* (*serialize) (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error);
	GXmlNode* (*serialize_property) (GXmlSerializableObjectModel* self, GXmlNode* element, GParamSpec* prop, GError** error);
	gboolean (*deserialize) (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error);
	gboolean (*deserialize_property) (GXmlSerializableObjectModel* self, GXmlNode* property_node, GError** error);
	gchar* (*to_string) (GXmlSerializableObjectModel* self);
};

struct _GXmlSerializableObjectModelPrivate {
	GHashTable* _ignored_serializable_properties;
	gchar* _serialized_xml_node_value;
};

struct _GXmlElementIface {
	GTypeInterface parent_iface;
	void (*normalize) (GXmlElement* self);
	void (*set_attr) (GXmlElement* self, const gchar* name, const gchar* value);
	GXmlNode* (*get_attr) (GXmlElement* self, const gchar* name);
	void (*remove_attr) (GXmlElement* self, const gchar* name);
	void (*remove_ns_attr) (GXmlElement* self, const gchar* name, const gchar* uri);
	void (*set_ns_attr) (GXmlElement* self, const gchar* ns, const gchar* name, const gchar* value);
	GXmlNode* (*get_ns_attr) (GXmlElement* self, const gchar* name, const gchar* uri);
	gchar* (*get_tag_name) (GXmlElement* self);
	gchar* (*get_content) (GXmlElement* self);
	void (*set_content) (GXmlElement* self, const gchar* value);
};

struct _GXmlTextIface {
	GTypeInterface parent_iface;
	gchar* (*get_str) (GXmlText* self);
	void (*set_str) (GXmlText* self, const gchar* value);
};

struct _GXmlSerializablePropertyIface {
	GTypeInterface parent_iface;
	gchar* (*get_serializable_property_value) (GXmlSerializableProperty* self);
	void (*set_serializable_property_value) (GXmlSerializableProperty* self, const gchar* val);
	gboolean (*deserialize_property) (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error);
	GXmlNode* (*serialize_property) (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error);
};

struct _GXmlSerializableCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*deserialize_proceed) (GXmlSerializableCollection* self);
	gboolean (*deserialized) (GXmlSerializableCollection* self);
	gboolean (*deserialize_node) (GXmlSerializableCollection* self, GXmlNode* node, GError** error);
	gboolean (*deserialize_children) (GXmlSerializableCollection* self, GError** error);
	gboolean (*is_collection) (GXmlSerializableCollection* self);
};

typedef enum  {
	GXML_ENUMERATION_ERROR_INVALID_VALUE,
	GXML_ENUMERATION_ERROR_INVALID_TEXT
} GXmlEnumerationError;
#define GXML_ENUMERATION_ERROR gxml_enumeration_error_quark ()
typedef enum  {
	GXML_SERIALIZABLE_ERROR_UNSUPPORTED_TYPE_ERROR,
	GXML_SERIALIZABLE_ERROR_STR_TO_VALUE_ERROR
} GXmlSerializableError;
#define GXML_SERIALIZABLE_ERROR gxml_serializable_error_quark ()

static gpointer gxml_serializable_object_model_parent_class = NULL;
static GXmlSerializableIface * gxml_serializable_object_model_gxml_serializable_parent_iface = NULL;

GType gxml_element_list_get_type (void) G_GNUC_CONST;
GType gxml_namespace_get_type (void) G_GNUC_CONST;
GType gxml_node_type_get_type (void) G_GNUC_CONST;
GType gxml_document_get_type (void) G_GNUC_CONST;
GType gxml_node_get_type (void) G_GNUC_CONST;
GType gxml_attribute_get_type (void) G_GNUC_CONST;
GType gxml_serializable_get_type (void) G_GNUC_CONST;
GType gxml_serializable_object_model_get_type (void) G_GNUC_CONST;
#define GXML_SERIALIZABLE_OBJECT_MODEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GXML_TYPE_SERIALIZABLE_OBJECT_MODEL, GXmlSerializableObjectModelPrivate))
gboolean gxml_serializable_object_model_get_enable_unknown_serializable_property (GXmlSerializableObjectModel* self);
static gboolean gxml_serializable_object_model_real_get_enable_unknown_serializable_property (GXmlSerializableObjectModel* self);
gboolean gxml_serializable_object_model_serialize_use_xml_node_value (GXmlSerializableObjectModel* self);
static gboolean gxml_serializable_object_model_real_serialize_use_xml_node_value (GXmlSerializableObjectModel* self);
gboolean gxml_serializable_object_model_property_use_nick (GXmlSerializableObjectModel* self);
static gboolean gxml_serializable_object_model_real_property_use_nick (GXmlSerializableObjectModel* self);
gboolean gxml_serializable_object_model_set_default_namespace (GXmlSerializableObjectModel* self, 
                                                               GXmlNode* node);
static gboolean gxml_serializable_object_model_real_set_default_namespace (GXmlSerializableObjectModel* self, 
                                                                    GXmlNode* node);
gchar* gxml_serializable_object_model_node_name (GXmlSerializableObjectModel* self);
static gchar* gxml_serializable_object_model_real_node_name (GXmlSerializableObjectModel* self);
gchar* gxml_serializable_object_model_default_node_name (GXmlSerializableObjectModel* self);
GParamSpec* gxml_serializable_object_model_find_property_spec (GXmlSerializableObjectModel* self, 
                                                               const gchar* property_name);
static GParamSpec* gxml_serializable_object_model_real_find_property_spec (GXmlSerializableObjectModel* self, 
                                                                    const gchar* property_name);
GParamSpec* gxml_serializable_default_find_property_spec (GXmlSerializable* self, 
                                                          const gchar* property_name);
GParamSpec** gxml_serializable_object_model_list_serializable_properties (GXmlSerializableObjectModel* self, 
                                                                          int* result_length1);
static GParamSpec** gxml_serializable_object_model_real_list_serializable_properties (GXmlSerializableObjectModel* self, 
                                                                               int* result_length1);
GParamSpec** gxml_serializable_default_list_serializable_properties (GXmlSerializable* self, 
                                                                     int* result_length1);
GXmlNode* gxml_serializable_object_model_serialize (GXmlSerializableObjectModel* self, 
                                                    GXmlNode* node, 
                                                    GError** error);
static GXmlNode* gxml_serializable_object_model_real_serialize (GXmlSerializableObjectModel* self, 
                                                         GXmlNode* node, 
                                                         GError** error);
GType gxml_element_get_type (void) G_GNUC_CONST;
GXmlNode* gxml_serializable_object_model_default_serialize (GXmlSerializableObjectModel* self, 
                                                            GXmlNode* node, 
                                                            GError** error);
gchar* gxml_node_get_name (GXmlNode* self);
GXmlDocument* gxml_node_get_document (GXmlNode* self);
GXmlNode* gxml_document_create_element (GXmlDocument* self, 
                                        const gchar* name, 
                                        GError** error);
GeeBidirList* gxml_node_get_children_nodes (GXmlNode* self);
GXmlNode* gxml_serializable_object_model_serialize_property (GXmlSerializableObjectModel* self, 
                                                             GXmlNode* element, 
                                                             GParamSpec* prop, 
                                                             GError** error);
GeeMap* gxml_serializable_get_unknown_serializable_properties (GXmlSerializable* self);
void gxml_element_set_attr (GXmlElement* self, 
                            const gchar* name, 
                            const gchar* value);
gchar* gxml_node_get_value (GXmlNode* self);
GeeCollection* gxml_serializable_get_unknown_serializable_nodes (GXmlSerializable* self);
gboolean gxml_node_copy (GXmlDocument* doc, 
                         GXmlNode* node, 
                         GXmlNode* source, 
                         gboolean deep);
GType gxml_text_get_type (void) G_GNUC_CONST;
GXmlNode* gxml_document_create_text (GXmlDocument* self, 
                                     const gchar* text);
gchar* gxml_serializable_get_serialized_xml_node_value (GXmlSerializable* self);
static GXmlNode* gxml_serializable_object_model_real_serialize_property (GXmlSerializableObjectModel* self, 
                                                                  GXmlNode* element, 
                                                                  GParamSpec* prop, 
                                                                  GError** error);
GXmlNode* gxml_serializable_object_model_default_serialize_property (GXmlSerializableObjectModel* self, 
                                                                     GXmlElement* element, 
                                                                     GParamSpec* prop, 
                                                                     GError** error);
GType gxml_serializable_property_get_type (void) G_GNUC_CONST;
GXmlNode* gxml_serializable_property_serialize_property (GXmlSerializableProperty* self, 
                                                         GXmlNode* property_node, 
                                                         GParamSpec* prop, 
                                                         gboolean nick, 
                                                         GError** error);
GType gxml_serializable_collection_get_type (void) G_GNUC_CONST;
gboolean gxml_serializable_collection_deserialized (GXmlSerializableCollection* self);
gboolean gxml_serializable_collection_deserialize_children (GXmlSerializableCollection* self, 
                                                            GError** error);
GXmlNode* gxml_serializable_serialize (GXmlSerializable* self, 
                                       GXmlNode* node, 
                                       GError** error);
gchar* gxml_enumeration_get_nick_camelcase (GType enumeration, 
                                            gint val, 
                                            GError** error);
GQuark gxml_enumeration_error_quark (void);
GXmlNode* gxml_element_get_attr (GXmlElement* self, 
                                 const gchar* name);
void gxml_node_set_value (GXmlNode* self, 
                          const gchar* value);
gboolean gxml_serializable_object_model_deserialize (GXmlSerializableObjectModel* self, 
                                                     GXmlNode* node, 
                                                     GError** error);
static gboolean gxml_serializable_object_model_real_deserialize (GXmlSerializableObjectModel* self, 
                                                          GXmlNode* node, 
                                                          GError** error);
gboolean gxml_serializable_object_model_default_deserialize (GXmlSerializableObjectModel* self, 
                                                             GXmlNode* node, 
                                                             GError** error);
GXmlNode* gxml_document_get_root (GXmlDocument* self);
GeeMap* gxml_node_get_attrs (GXmlNode* self);
gboolean gxml_serializable_object_model_deserialize_property (GXmlSerializableObjectModel* self, 
                                                              GXmlNode* property_node, 
                                                              GError** error);
GType gxml_serializable_container_get_type (void) G_GNUC_CONST;
void gxml_serializable_container_init_containers (GXmlSerializableContainer* self);
gchar* gxml_serializable_node_name (GXmlSerializable* self);
gboolean gxml_serializable_deserialize (GXmlSerializable* self, 
                                        GXmlNode* node, 
                                        GError** error);
static gboolean gxml_serializable_object_model_real_deserialize_property (GXmlSerializableObjectModel* self, 
                                                                   GXmlNode* property_node, 
                                                                   GError** error);
gboolean gxml_serializable_object_model_default_deserialize_property (GXmlSerializableObjectModel* self, 
                                                                      GXmlNode* property_node, 
                                                                      GError** error);
void gxml_serializable_set_serialized_xml_node_value (GXmlSerializable* self, 
                                                      const gchar* value);
GXmlNode* gxml_node_get_parent (GXmlNode* self);
gboolean gxml_serializable_property_deserialize_property (GXmlSerializableProperty* self, 
                                                          GXmlNode* property_node, 
                                                          GParamSpec* prop, 
                                                          gboolean nick, 
                                                          GError** error);
GEnumValue* gxml_enumeration_parse (GType enumeration, 
                                    const gchar* val, 
                                    GError** error);
GQuark gxml_serializable_error_quark (void);
gboolean gxml_serializable_string_to_gvalue (const gchar* str, 
                                             GValue* dest, 
                                             GError** error);
gchar* gxml_serializable_object_model_to_string (GXmlSerializableObjectModel* self);
static gchar* gxml_serializable_object_model_real_to_string (GXmlSerializableObjectModel* self);
GXmlSerializableObjectModel* gxml_serializable_object_model_construct (GType object_type);
GHashTable* gxml_serializable_object_model_get_ignored_serializable_properties (GXmlSerializableObjectModel* self);
void gxml_serializable_object_model_set_ignored_serializable_properties (GXmlSerializableObjectModel* self, 
                                                                         GHashTable* value);
static void _vala_array_add3 (gchar** * array, 
                       int* length, 
                       int* size, 
                       gchar* value);
static void _vala_array_add4 (gchar** * array, 
                       int* length, 
                       int* size, 
                       gchar* value);
static void _vala_array_add5 (gchar** * array, 
                       int* length, 
                       int* size, 
                       gchar* value);
static GObject * gxml_serializable_object_model_constructor (GType type, 
                                                      guint n_construct_properties, 
                                                      GObjectConstructParam * construct_properties);
void gxml_init_init (void);
static void gxml_serializable_object_model_finalize (GObject * obj);
static void _vala_gxml_serializable_object_model_get_property (GObject * object, 
                                                        guint property_id, 
                                                        GValue * value, 
                                                        GParamSpec * pspec);
static void _vala_gxml_serializable_object_model_set_property (GObject * object, 
                                                        guint property_id, 
                                                        const GValue * value, 
                                                        GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, 
                          gint array_length, 
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, 
                       gint array_length, 
                       GDestroyNotify destroy_func);


static gboolean
gxml_serializable_object_model_real_get_enable_unknown_serializable_property (GXmlSerializableObjectModel* self)
{
	gboolean result = FALSE;
	result = FALSE;
	return result;
}


gboolean
gxml_serializable_object_model_get_enable_unknown_serializable_property (GXmlSerializableObjectModel* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->get_enable_unknown_serializable_property (self);
}


static gboolean
gxml_serializable_object_model_real_serialize_use_xml_node_value (GXmlSerializableObjectModel* self)
{
	gboolean result = FALSE;
	result = FALSE;
	return result;
}


gboolean
gxml_serializable_object_model_serialize_use_xml_node_value (GXmlSerializableObjectModel* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->serialize_use_xml_node_value (self);
}


static gboolean
gxml_serializable_object_model_real_property_use_nick (GXmlSerializableObjectModel* self)
{
	gboolean result = FALSE;
	result = FALSE;
	return result;
}


gboolean
gxml_serializable_object_model_property_use_nick (GXmlSerializableObjectModel* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->property_use_nick (self);
}


static gboolean
gxml_serializable_object_model_real_set_default_namespace (GXmlSerializableObjectModel* self, 
                                                           GXmlNode* node)
{
	gboolean result = FALSE;
	g_return_val_if_fail (node != NULL, FALSE);
	result = TRUE;
	return result;
}


gboolean
gxml_serializable_object_model_set_default_namespace (GXmlSerializableObjectModel* self, 
                                                      GXmlNode* node)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->set_default_namespace (self, node);
}


static gchar*
gxml_serializable_object_model_real_node_name (GXmlSerializableObjectModel* self)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	_tmp0_ = gxml_serializable_object_model_default_node_name (self);
	result = _tmp0_;
	return result;
}


gchar*
gxml_serializable_object_model_node_name (GXmlSerializableObjectModel* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->node_name (self);
}


gchar*
gxml_serializable_object_model_default_node_name (GXmlSerializableObjectModel* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) self));
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) -1);
	result = _tmp1_;
	return result;
}


static GParamSpec*
gxml_serializable_object_model_real_find_property_spec (GXmlSerializableObjectModel* self, 
                                                        const gchar* property_name)
{
	GParamSpec* result = NULL;
	GParamSpec* _tmp0_;
	g_return_val_if_fail (property_name != NULL, NULL);
	_tmp0_ = gxml_serializable_default_find_property_spec ((GXmlSerializable*) self, property_name);
	result = _tmp0_;
	return result;
}


GParamSpec*
gxml_serializable_object_model_find_property_spec (GXmlSerializableObjectModel* self, 
                                                   const gchar* property_name)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->find_property_spec (self, property_name);
}


static GParamSpec**
gxml_serializable_object_model_real_list_serializable_properties (GXmlSerializableObjectModel* self, 
                                                                  int* result_length1)
{
	GParamSpec** result = NULL;
	gint _tmp0_;
	GParamSpec** _tmp1_;
	GParamSpec** _tmp2_;
	gint _tmp2__length1;
	_tmp1_ = gxml_serializable_default_list_serializable_properties ((GXmlSerializable*) self, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}


GParamSpec**
gxml_serializable_object_model_list_serializable_properties (GXmlSerializableObjectModel* self, 
                                                             int* result_length1)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->list_serializable_properties (self, result_length1);
}


static GXmlNode*
gxml_serializable_object_model_real_serialize (GXmlSerializableObjectModel* self, 
                                               GXmlNode* node, 
                                               GError** error)
{
	GXmlNode* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GXmlNode* _tmp2_ = NULL;
	GXmlNode* _tmp3_;
	GXmlNode* _tmp4_;
	GXmlNode* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = gxml_serializable_object_model_node_name (self);
	_tmp1_ = _tmp0_;
	_vala_return_val_if_fail (_tmp1_ != NULL, "node_name () != null", NULL);
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (node, GXML_TYPE_DOCUMENT) || G_TYPE_CHECK_INSTANCE_TYPE (node, GXML_TYPE_ELEMENT), "node is GXml.Document || node is GXml.Element", NULL);
	_tmp3_ = gxml_serializable_object_model_default_serialize (self, node, &_inner_error_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp1_);
	_tmp2_ = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp5_ = _tmp2_;
	_tmp2_ = NULL;
	result = _tmp5_;
	_g_object_unref0 (_tmp2_);
	return result;
}


GXmlNode*
gxml_serializable_object_model_serialize (GXmlSerializableObjectModel* self, 
                                          GXmlNode* node, 
                                          GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gxml_serializable_object_model_node_name (self);
	_tmp1_ = _tmp0_;
	_vala_return_val_if_fail (_tmp1_ != NULL, "node_name () != null", NULL);
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (node, GXML_TYPE_DOCUMENT) || G_TYPE_CHECK_INSTANCE_TYPE (node, GXML_TYPE_ELEMENT), "node is GXml.Document || node is GXml.Element", NULL);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->serialize (self, node, error);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static gpointer
_g_param_spec_ref0 (gpointer self)
{
	return self ? g_param_spec_ref (self) : NULL;
}


GXmlNode*
gxml_serializable_object_model_default_serialize (GXmlSerializableObjectModel* self, 
                                                  GXmlNode* node, 
                                                  GError** error)
{
	GXmlNode* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GXmlDocument* doc = NULL;
	GXmlNode* _tmp7_ = NULL;
	GXmlDocument* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GXmlNode* _tmp11_;
	GXmlNode* _tmp12_;
	GXmlElement* element = NULL;
	GXmlElement* _tmp13_;
	GeeBidirList* _tmp14_;
	GeeBidirList* _tmp15_;
	GeeBidirList* _tmp16_;
	GXmlElement* _tmp17_;
	GXmlElement* _tmp18_;
	gint _tmp19_;
	GParamSpec** _tmp20_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = gxml_node_get_name (node);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_vala_assert (_tmp2_ != NULL, "node.name != null");
	_g_free0 (_tmp2_);
	if (G_TYPE_CHECK_INSTANCE_TYPE (node, GXML_TYPE_DOCUMENT)) {
		GXmlDocument* _tmp3_;
		_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (node, GXML_TYPE_DOCUMENT, GXmlDocument));
		_g_object_unref0 (doc);
		doc = _tmp3_;
	} else {
		GXmlDocument* _tmp4_;
		GXmlDocument* _tmp5_;
		GXmlDocument* _tmp6_;
		_tmp4_ = gxml_node_get_document (node);
		_tmp5_ = _tmp4_;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (doc);
		doc = _tmp6_;
	}
	_tmp8_ = doc;
	_tmp9_ = gxml_serializable_object_model_node_name (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = gxml_document_create_element (_tmp8_, _tmp10_, &_inner_error_);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	_tmp7_ = _tmp12_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (doc);
		return NULL;
	}
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GXML_TYPE_ELEMENT, GXmlElement));
	element = _tmp13_;
	_tmp14_ = gxml_node_get_children_nodes (node);
	_tmp15_ = _tmp14_;
	_tmp16_ = _tmp15_;
	_tmp17_ = element;
	gee_collection_add ((GeeCollection*) _tmp16_, (GXmlNode*) _tmp17_);
	_g_object_unref0 (_tmp16_);
	_tmp18_ = element;
	gxml_serializable_object_model_set_default_namespace (self, (GXmlNode*) _tmp18_);
	_tmp20_ = gxml_serializable_object_model_list_serializable_properties (self, &_tmp19_);
	{
		GParamSpec** spec_collection = NULL;
		gint spec_collection_length1 = 0;
		gint _spec_collection_size_ = 0;
		gint spec_it = 0;
		spec_collection = _tmp20_;
		spec_collection_length1 = _tmp19_;
		for (spec_it = 0; spec_it < _tmp19_; spec_it = spec_it + 1) {
			GParamSpec* _tmp21_;
			GParamSpec* spec = NULL;
			_tmp21_ = _g_param_spec_ref0 (spec_collection[spec_it]);
			spec = _tmp21_;
			{
				GXmlElement* _tmp22_;
				GParamSpec* _tmp23_;
				GXmlNode* _tmp24_;
				GXmlNode* _tmp25_;
				_tmp22_ = element;
				_tmp23_ = spec;
				_tmp24_ = gxml_serializable_object_model_serialize_property (self, (GXmlNode*) _tmp22_, _tmp23_, &_inner_error_);
				_tmp25_ = _tmp24_;
				_g_object_unref0 (_tmp25_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_param_spec_unref0 (spec);
					spec_collection = (_vala_array_free (spec_collection, spec_collection_length1, (GDestroyNotify) g_param_spec_unref), NULL);
					_g_object_unref0 (element);
					_g_object_unref0 (_tmp7_);
					_g_object_unref0 (doc);
					return NULL;
				}
				_g_param_spec_unref0 (spec);
			}
		}
		spec_collection = (_vala_array_free (spec_collection, spec_collection_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	}
	if (gxml_serializable_object_model_get_enable_unknown_serializable_property (self)) {
		{
			GeeIterator* _attr_it = NULL;
			GeeMap* _tmp26_;
			GeeMap* _tmp27_;
			GeeMap* _tmp28_;
			GeeCollection* _tmp29_;
			GeeCollection* _tmp30_;
			GeeCollection* _tmp31_;
			GeeIterator* _tmp32_;
			GeeIterator* _tmp33_;
			_tmp26_ = gxml_serializable_get_unknown_serializable_properties ((GXmlSerializable*) self);
			_tmp27_ = _tmp26_;
			_tmp28_ = _tmp27_;
			_tmp29_ = gee_map_get_values (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = _tmp30_;
			_tmp32_ = gee_iterable_iterator ((GeeIterable*) _tmp31_);
			_tmp33_ = _tmp32_;
			_g_object_unref0 (_tmp31_);
			_g_object_unref0 (_tmp28_);
			_attr_it = _tmp33_;
			while (TRUE) {
				GeeIterator* _tmp34_;
				GXmlAttribute* attr = NULL;
				GeeIterator* _tmp35_;
				gpointer _tmp36_;
				GXmlElement* _tmp37_;
				GXmlAttribute* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				GXmlAttribute* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				_tmp34_ = _attr_it;
				if (!gee_iterator_next (_tmp34_)) {
					break;
				}
				_tmp35_ = _attr_it;
				_tmp36_ = gee_iterator_get (_tmp35_);
				attr = (GXmlAttribute*) _tmp36_;
				_tmp37_ = element;
				_tmp38_ = attr;
				_tmp39_ = gxml_node_get_name ((GXmlNode*) _tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = _tmp40_;
				_tmp42_ = attr;
				_tmp43_ = gxml_node_get_value ((GXmlNode*) _tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = _tmp44_;
				gxml_element_set_attr (_tmp37_, _tmp41_, _tmp45_);
				_g_free0 (_tmp45_);
				_g_free0 (_tmp41_);
				_g_object_unref0 (attr);
			}
			_g_object_unref0 (_attr_it);
		}
		{
			GeeIterator* _n_it = NULL;
			GeeCollection* _tmp46_;
			GeeCollection* _tmp47_;
			GeeCollection* _tmp48_;
			GeeIterator* _tmp49_;
			GeeIterator* _tmp50_;
			_tmp46_ = gxml_serializable_get_unknown_serializable_nodes ((GXmlSerializable*) self);
			_tmp47_ = _tmp46_;
			_tmp48_ = _tmp47_;
			_tmp49_ = gee_iterable_iterator ((GeeIterable*) _tmp48_);
			_tmp50_ = _tmp49_;
			_g_object_unref0 (_tmp48_);
			_n_it = _tmp50_;
			while (TRUE) {
				GeeIterator* _tmp51_;
				GXmlNode* n = NULL;
				GeeIterator* _tmp52_;
				gpointer _tmp53_;
				GXmlNode* _tmp54_;
				gboolean _tmp71_ = FALSE;
				GXmlNode* _tmp72_;
				_tmp51_ = _n_it;
				if (!gee_iterator_next (_tmp51_)) {
					break;
				}
				_tmp52_ = _n_it;
				_tmp53_ = gee_iterator_get (_tmp52_);
				n = (GXmlNode*) _tmp53_;
				_tmp54_ = n;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp54_, GXML_TYPE_ELEMENT)) {
					GXmlNode* e = NULL;
					GXmlDocument* _tmp55_;
					GXmlNode* _tmp56_;
					gchar* _tmp57_;
					gchar* _tmp58_;
					gchar* _tmp59_;
					GXmlNode* _tmp60_;
					GXmlNode* _tmp61_;
					GXmlDocument* _tmp62_;
					GXmlDocument* _tmp63_;
					GXmlNode* _tmp64_;
					GXmlNode* _tmp65_;
					GXmlElement* _tmp66_;
					GeeBidirList* _tmp67_;
					GeeBidirList* _tmp68_;
					GeeBidirList* _tmp69_;
					GXmlNode* _tmp70_;
					_tmp55_ = doc;
					_tmp56_ = n;
					_tmp57_ = gxml_node_get_name (_tmp56_);
					_tmp58_ = _tmp57_;
					_tmp59_ = _tmp58_;
					_tmp60_ = gxml_document_create_element (_tmp55_, _tmp59_, &_inner_error_);
					_tmp61_ = _tmp60_;
					_g_free0 (_tmp59_);
					e = _tmp61_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (n);
						_g_object_unref0 (_n_it);
						_g_object_unref0 (element);
						_g_object_unref0 (_tmp7_);
						_g_object_unref0 (doc);
						return NULL;
					}
					_tmp62_ = gxml_node_get_document (node);
					_tmp63_ = _tmp62_;
					_tmp64_ = e;
					_tmp65_ = n;
					gxml_node_copy (_tmp63_, _tmp64_, _tmp65_, TRUE);
					_tmp66_ = element;
					_tmp67_ = gxml_node_get_children_nodes ((GXmlNode*) _tmp66_);
					_tmp68_ = _tmp67_;
					_tmp69_ = _tmp68_;
					_tmp70_ = e;
					gee_collection_add ((GeeCollection*) _tmp69_, _tmp70_);
					_g_object_unref0 (_tmp69_);
					_g_object_unref0 (e);
				}
				_tmp72_ = n;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp72_, GXML_TYPE_TEXT)) {
					_tmp71_ = !gxml_serializable_object_model_serialize_use_xml_node_value (self);
				} else {
					_tmp71_ = FALSE;
				}
				if (_tmp71_) {
					GXmlNode* _tmp73_;
					gchar* _tmp74_;
					gchar* _tmp75_;
					gchar* _tmp76_;
					gboolean _tmp77_;
					GXmlNode* t = NULL;
					GXmlDocument* _tmp78_;
					GXmlNode* _tmp79_;
					gchar* _tmp80_;
					gchar* _tmp81_;
					gchar* _tmp82_;
					const gchar* _tmp83_;
					GXmlNode* _tmp84_;
					GXmlNode* _tmp85_;
					GXmlElement* _tmp86_;
					GeeBidirList* _tmp87_;
					GeeBidirList* _tmp88_;
					GeeBidirList* _tmp89_;
					GXmlNode* _tmp90_;
					_tmp73_ = n;
					_tmp74_ = gxml_node_get_value (_tmp73_);
					_tmp75_ = _tmp74_;
					_tmp76_ = _tmp75_;
					_tmp77_ = g_strcmp0 (_tmp76_, "") == 0;
					_g_free0 (_tmp76_);
					if (_tmp77_) {
						_g_object_unref0 (n);
						continue;
					}
					_tmp78_ = doc;
					_tmp79_ = n;
					_tmp80_ = gxml_node_get_value (_tmp79_);
					_tmp81_ = _tmp80_;
					_tmp82_ = _tmp81_;
					_tmp83_ = g_strstrip (_tmp82_);
					_tmp84_ = gxml_document_create_text (_tmp78_, _tmp83_);
					_tmp85_ = _tmp84_;
					_g_free0 (_tmp82_);
					t = _tmp85_;
					_tmp86_ = element;
					_tmp87_ = gxml_node_get_children_nodes ((GXmlNode*) _tmp86_);
					_tmp88_ = _tmp87_;
					_tmp89_ = _tmp88_;
					_tmp90_ = t;
					gee_collection_add ((GeeCollection*) _tmp89_, _tmp90_);
					_g_object_unref0 (_tmp89_);
					_g_object_unref0 (t);
				}
				_g_object_unref0 (n);
			}
			_g_object_unref0 (_n_it);
		}
	}
	if (gxml_serializable_object_model_serialize_use_xml_node_value (self)) {
		gchar* txt = NULL;
		gchar* _tmp91_;
		gchar* _tmp92_;
		gchar* _tmp93_;
		gchar* _tmp94_;
		gboolean _tmp95_;
		GXmlNode* t = NULL;
		GXmlDocument* _tmp98_;
		const gchar* _tmp99_;
		GXmlNode* _tmp100_;
		GXmlElement* _tmp101_;
		GeeBidirList* _tmp102_;
		GeeBidirList* _tmp103_;
		GeeBidirList* _tmp104_;
		GXmlNode* _tmp105_;
		_tmp91_ = g_strdup ("");
		txt = _tmp91_;
		_tmp92_ = gxml_serializable_get_serialized_xml_node_value ((GXmlSerializable*) self);
		_tmp93_ = _tmp92_;
		_tmp94_ = _tmp93_;
		_tmp95_ = _tmp94_ != NULL;
		_g_free0 (_tmp94_);
		if (_tmp95_) {
			gchar* _tmp96_;
			gchar* _tmp97_;
			_tmp96_ = gxml_serializable_get_serialized_xml_node_value ((GXmlSerializable*) self);
			_tmp97_ = _tmp96_;
			_g_free0 (txt);
			txt = _tmp97_;
		}
		_tmp98_ = doc;
		_tmp99_ = txt;
		_tmp100_ = gxml_document_create_text (_tmp98_, _tmp99_);
		t = _tmp100_;
		_tmp101_ = element;
		_tmp102_ = gxml_node_get_children_nodes ((GXmlNode*) _tmp101_);
		_tmp103_ = _tmp102_;
		_tmp104_ = _tmp103_;
		_tmp105_ = t;
		gee_collection_add ((GeeCollection*) _tmp104_, _tmp105_);
		_g_object_unref0 (_tmp104_);
		_g_object_unref0 (t);
		_g_free0 (txt);
	}
	result = (GXmlNode*) element;
	_g_object_unref0 (_tmp7_);
	_g_object_unref0 (doc);
	return result;
}


static GXmlNode*
gxml_serializable_object_model_real_serialize_property (GXmlSerializableObjectModel* self, 
                                                        GXmlNode* element, 
                                                        GParamSpec* prop, 
                                                        GError** error)
{
	GXmlNode* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (element != NULL, NULL);
	g_return_val_if_fail (prop != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (element, GXML_TYPE_ELEMENT)) {
		GXmlNode* _tmp0_ = NULL;
		GXmlNode* _tmp1_;
		GXmlNode* _tmp2_;
		_tmp1_ = gxml_serializable_object_model_default_serialize_property (self, G_TYPE_CHECK_INSTANCE_CAST (element, GXML_TYPE_ELEMENT, GXmlElement), prop, &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp2_;
		_g_object_unref0 (_tmp0_);
		return result;
	}
	result = NULL;
	return result;
}


GXmlNode*
gxml_serializable_object_model_serialize_property (GXmlSerializableObjectModel* self, 
                                                   GXmlNode* element, 
                                                   GParamSpec* prop, 
                                                   GError** error)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->serialize_property (self, element, prop, error);
}


GXmlNode*
gxml_serializable_object_model_default_serialize_property (GXmlSerializableObjectModel* self, 
                                                           GXmlElement* element, 
                                                           GParamSpec* prop, 
                                                           GError** error)
{
	GXmlNode* result = NULL;
	gboolean _tmp0_ = FALSE;
	GType _tmp1_;
	GValue oval = {0};
	GType _tmp21_;
	const gchar* _tmp27_;
	gchar* val = NULL;
	gchar* _tmp28_;
	GType _tmp29_;
	gchar* attr_name = NULL;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	GXmlNode* attr = NULL;
	const gchar* _tmp46_;
	GXmlNode* _tmp47_;
	GXmlNode* _tmp48_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (element != NULL, NULL);
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp1_ = prop->value_type;
	if (g_type_is_a (_tmp1_, GXML_TYPE_SERIALIZABLE)) {
		_tmp0_ = TRUE;
	} else {
		GType _tmp2_;
		_tmp2_ = prop->value_type;
		_tmp0_ = g_type_is_a (_tmp2_, GXML_TYPE_SERIALIZABLE_PROPERTY);
	}
	if (_tmp0_) {
		GValue v = {0};
		GValue _tmp3_ = {0};
		const gchar* _tmp4_;
		GObject* obj = NULL;
		GObject* _tmp5_;
		GObject* _tmp6_;
		GObject* _tmp7_;
		g_value_init (&_tmp3_, G_TYPE_OBJECT);
		v = _tmp3_;
		_tmp4_ = prop->name;
		g_object_get_property ((GObject*) self, _tmp4_, &v);
		_tmp5_ = g_value_get_object (&v);
		_tmp6_ = _g_object_ref0 (_tmp5_);
		obj = _tmp6_;
		_tmp7_ = obj;
		if (_tmp7_ != NULL) {
			GObject* _tmp8_;
			GObject* _tmp13_;
			GObject* _tmp16_;
			_tmp8_ = obj;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, GXML_TYPE_SERIALIZABLE_PROPERTY)) {
				GXmlNode* _tmp9_ = NULL;
				GObject* _tmp10_;
				GXmlNode* _tmp11_;
				GXmlNode* _tmp12_;
				_tmp10_ = obj;
				_tmp11_ = gxml_serializable_property_serialize_property (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GXML_TYPE_SERIALIZABLE_PROPERTY, GXmlSerializableProperty), (GXmlNode*) element, prop, gxml_serializable_object_model_property_use_nick (self), &_inner_error_);
				_tmp9_ = _tmp11_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (obj);
					G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
					return NULL;
				}
				_tmp12_ = _tmp9_;
				_tmp9_ = NULL;
				result = _tmp12_;
				_g_object_unref0 (_tmp9_);
				_g_object_unref0 (obj);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
				return result;
			}
			_tmp13_ = obj;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, GXML_TYPE_SERIALIZABLE_COLLECTION)) {
				GObject* _tmp14_;
				_tmp14_ = obj;
				if (!gxml_serializable_collection_deserialized (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, GXML_TYPE_SERIALIZABLE_COLLECTION) ? ((GXmlSerializableCollection*) _tmp14_) : NULL)) {
					GObject* _tmp15_;
					_tmp15_ = obj;
					gxml_serializable_collection_deserialize_children (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, GXML_TYPE_SERIALIZABLE_COLLECTION) ? ((GXmlSerializableCollection*) _tmp15_) : NULL, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (obj);
						G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
						return NULL;
					}
				}
			}
			_tmp16_ = obj;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, GXML_TYPE_SERIALIZABLE)) {
				GXmlNode* _tmp17_ = NULL;
				GObject* _tmp18_;
				GXmlNode* _tmp19_;
				GXmlNode* _tmp20_;
				_tmp18_ = obj;
				_tmp19_ = gxml_serializable_serialize (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GXML_TYPE_SERIALIZABLE, GXmlSerializable), (GXmlNode*) element, &_inner_error_);
				_tmp17_ = _tmp19_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (obj);
					G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
					return NULL;
				}
				_tmp20_ = _tmp17_;
				_tmp17_ = NULL;
				result = _tmp20_;
				_g_object_unref0 (_tmp17_);
				_g_object_unref0 (obj);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
				return result;
			}
		}
		_g_object_unref0 (obj);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	}
	_tmp21_ = prop->value_type;
	if (g_type_is_a (_tmp21_, G_TYPE_ENUM)) {
		GValue _tmp22_ = {0};
		GValue _tmp23_;
		g_value_init (&_tmp22_, G_TYPE_INT);
		G_IS_VALUE (&oval) ? (g_value_unset (&oval), NULL) : NULL;
		oval = _tmp22_;
		_tmp23_ = oval;
	} else {
		GType _tmp24_;
		GValue _tmp25_ = {0};
		GValue _tmp26_;
		_tmp24_ = prop->value_type;
		g_value_init (&_tmp25_, _tmp24_);
		G_IS_VALUE (&oval) ? (g_value_unset (&oval), NULL) : NULL;
		oval = _tmp25_;
		_tmp26_ = oval;
	}
	_tmp27_ = prop->name;
	g_object_get_property ((GObject*) self, _tmp27_, &oval);
	_tmp28_ = g_strdup ("");
	val = _tmp28_;
	_tmp29_ = prop->value_type;
	if (g_type_is_a (_tmp29_, G_TYPE_ENUM)) {
		{
			gchar* _tmp30_ = NULL;
			GType _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			_tmp31_ = prop->value_type;
			_tmp32_ = gxml_enumeration_get_nick_camelcase (_tmp31_, g_value_get_int (&oval), &_inner_error_);
			_tmp30_ = _tmp32_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == GXML_ENUMERATION_ERROR) {
					goto __catch1_gxml_enumeration_error;
				}
				goto __finally1;
			}
			_tmp33_ = _tmp30_;
			_tmp30_ = NULL;
			_g_free0 (val);
			val = _tmp33_;
			_g_free0 (_tmp30_);
		}
		goto __finally1;
		__catch1_gxml_enumeration_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_free0 (val);
			val = NULL;
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (val);
			G_IS_VALUE (&oval) ? (g_value_unset (&oval), NULL) : NULL;
			return NULL;
		}
	} else {
		GType _tmp34_;
		_tmp34_ = prop->value_type;
		if (g_value_type_transformable (_tmp34_, G_TYPE_STRING)) {
			GValue rval = {0};
			GValue _tmp35_ = {0};
			gchar* _tmp36_;
			g_value_init (&_tmp35_, G_TYPE_STRING);
			rval = _tmp35_;
			g_value_transform (&oval, &rval);
			_tmp36_ = g_value_dup_string (&rval);
			_g_free0 (val);
			val = _tmp36_;
			G_IS_VALUE (&rval) ? (g_value_unset (&rval), NULL) : NULL;
		} else {
			GXmlNode* node = NULL;
			GXmlNode* _tmp37_ = NULL;
			node = NULL;
			g_signal_emit_by_name ((GXmlSerializable*) self, "serialize-unknown-property", (GXmlNode*) element, prop, &_tmp37_);
			_g_object_unref0 (node);
			node = _tmp37_;
			result = node;
			_g_free0 (val);
			G_IS_VALUE (&oval) ? (g_value_unset (&oval), NULL) : NULL;
			return result;
		}
	}
	if (gxml_serializable_object_model_property_use_nick (self)) {
		const gchar* _tmp40_;
		_tmp40_ = g_param_spec_get_nick (prop);
		_tmp39_ = _tmp40_ != NULL;
	} else {
		_tmp39_ = FALSE;
	}
	if (_tmp39_) {
		const gchar* _tmp41_;
		_tmp41_ = g_param_spec_get_nick (prop);
		_tmp38_ = g_strcmp0 (_tmp41_, "") != 0;
	} else {
		_tmp38_ = FALSE;
	}
	if (_tmp38_) {
		const gchar* _tmp42_;
		gchar* _tmp43_;
		_tmp42_ = g_param_spec_get_nick (prop);
		_tmp43_ = g_strdup (_tmp42_);
		_g_free0 (attr_name);
		attr_name = _tmp43_;
	} else {
		const gchar* _tmp44_;
		gchar* _tmp45_;
		_tmp44_ = g_param_spec_get_name (prop);
		_tmp45_ = g_strdup (_tmp44_);
		_g_free0 (attr_name);
		attr_name = _tmp45_;
	}
	_tmp46_ = attr_name;
	_tmp47_ = gxml_element_get_attr (element, _tmp46_);
	attr = _tmp47_;
	_tmp48_ = attr;
	if (_tmp48_ == NULL) {
		const gchar* _tmp49_;
		_tmp49_ = val;
		if (_tmp49_ != NULL) {
			const gchar* _tmp50_;
			const gchar* _tmp51_;
			_tmp50_ = attr_name;
			_tmp51_ = val;
			gxml_element_set_attr (element, _tmp50_, _tmp51_);
		}
	} else {
		GXmlNode* _tmp52_;
		const gchar* _tmp53_;
		_tmp52_ = attr;
		_tmp53_ = val;
		gxml_node_set_value (_tmp52_, _tmp53_);
	}
	result = attr;
	_g_free0 (attr_name);
	_g_free0 (val);
	G_IS_VALUE (&oval) ? (g_value_unset (&oval), NULL) : NULL;
	return result;
}


static gboolean
gxml_serializable_object_model_real_deserialize (GXmlSerializableObjectModel* self, 
                                                 GXmlNode* node, 
                                                 GError** error)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = gxml_serializable_object_model_node_name (self);
	_tmp1_ = _tmp0_;
	_vala_return_val_if_fail (_tmp1_ != NULL, "node_name () != null", FALSE);
	_tmp3_ = gxml_serializable_object_model_default_deserialize (self, node, &_inner_error_);
	_g_free0 (_tmp1_);
	_tmp2_ = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		g_propagate_error (error, _inner_error_);
		return _tmp4_;
	}
	result = _tmp2_;
	return result;
}


gboolean
gxml_serializable_object_model_deserialize (GXmlSerializableObjectModel* self, 
                                            GXmlNode* node, 
                                            GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gxml_serializable_object_model_node_name (self);
	_tmp1_ = _tmp0_;
	_vala_return_val_if_fail (_tmp1_ != NULL, "node_name () != null", FALSE);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->deserialize (self, node, error);
}


gboolean
gxml_serializable_object_model_default_deserialize (GXmlSerializableObjectModel* self, 
                                                    GXmlNode* node, 
                                                    GError** error)
{
	gboolean result = FALSE;
	GXmlDocument* doc = NULL;
	GXmlElement* element = NULL;
	GXmlElement* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gboolean _tmp15_;
	GXmlElement* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gboolean _tmp29_;
	GeeHashMap* cnodes = NULL;
	GeeHashMap* _tmp56_;
	GeeHashMap* cns = NULL;
	GeeHashMap* _tmp57_;
	gint _tmp58_;
	GParamSpec** _tmp59_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_TYPE (node, GXML_TYPE_DOCUMENT)) {
		GXmlDocument* _tmp0_;
		GXmlDocument* _tmp1_;
		GXmlNode* _tmp2_;
		GXmlNode* _tmp3_;
		GXmlNode* _tmp4_;
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (node, GXML_TYPE_DOCUMENT, GXmlDocument));
		_g_object_unref0 (doc);
		doc = _tmp0_;
		_tmp1_ = doc;
		_tmp2_ = gxml_document_get_root (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		g_return_val_if_fail (_tmp4_ != NULL, FALSE);
		_g_object_unref0 (_tmp4_);
	} else {
		GXmlDocument* _tmp5_;
		GXmlDocument* _tmp6_;
		GXmlDocument* _tmp7_;
		_tmp5_ = gxml_node_get_document (node);
		_tmp6_ = _tmp5_;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (doc);
		doc = _tmp7_;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (node, GXML_TYPE_ELEMENT)) {
		GXmlElement* _tmp8_;
		_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (node, GXML_TYPE_ELEMENT, GXmlElement));
		_g_object_unref0 (element);
		element = _tmp8_;
	} else {
		GXmlDocument* _tmp9_;
		GXmlNode* _tmp10_;
		GXmlNode* _tmp11_;
		_tmp9_ = doc;
		_tmp10_ = gxml_document_get_root (_tmp9_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (element);
		element = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GXML_TYPE_ELEMENT, GXmlElement);
	}
	_tmp12_ = element;
	g_return_val_if_fail (_tmp12_ != NULL, FALSE);
	_tmp13_ = gxml_serializable_object_model_node_name (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_ == NULL;
	_g_free0 (_tmp14_);
	if (_tmp15_) {
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp16_ = g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) self));
		_tmp17_ = g_strdup_printf (_ ("WARNING: Object type '%s' has no Node Name defined"), _tmp16_);
		_tmp18_ = _tmp17_;
		g_warning ("SerializableObjectModel.vala:322: %s", _tmp18_);
		_g_free0 (_tmp18_);
		result = FALSE;
		_g_object_unref0 (element);
		_g_object_unref0 (doc);
		return result;
	}
	_tmp19_ = element;
	_tmp20_ = gxml_node_get_name ((GXmlNode*) _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = _tmp21_;
	_tmp23_ = g_utf8_strdown (_tmp22_, (gssize) -1);
	_tmp24_ = _tmp23_;
	_tmp25_ = gxml_serializable_object_model_node_name (self);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_utf8_strdown (_tmp26_, (gssize) -1);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_strcmp0 (_tmp24_, _tmp28_) != 0;
	_g_free0 (_tmp28_);
	_g_free0 (_tmp26_);
	_g_free0 (_tmp24_);
	_g_free0 (_tmp22_);
	if (_tmp29_) {
		GXmlElement* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		_tmp30_ = element;
		_tmp31_ = gxml_node_get_name ((GXmlNode*) _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = _tmp32_;
		_tmp34_ = g_utf8_strdown (_tmp33_, (gssize) -1);
		_tmp35_ = _tmp34_;
		_tmp36_ = gxml_serializable_object_model_node_name (self);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_utf8_strdown (_tmp37_, (gssize) -1);
		_tmp39_ = _tmp38_;
		_tmp40_ = g_strdup_printf (_ ("Actual node's name is '%s' expected '%s'"), _tmp35_, _tmp39_);
		_tmp41_ = _tmp40_;
		g_warning ("SerializableObjectModel.vala:326: %s", _tmp41_);
		_g_free0 (_tmp41_);
		_g_free0 (_tmp39_);
		_g_free0 (_tmp37_);
		_g_free0 (_tmp35_);
		_g_free0 (_tmp33_);
	}
	{
		GeeIterator* _attr_it = NULL;
		GXmlElement* _tmp42_;
		GeeMap* _tmp43_;
		GeeMap* _tmp44_;
		GeeMap* _tmp45_;
		GeeCollection* _tmp46_;
		GeeCollection* _tmp47_;
		GeeCollection* _tmp48_;
		GeeIterator* _tmp49_;
		GeeIterator* _tmp50_;
		_tmp42_ = element;
		_tmp43_ = gxml_node_get_attrs ((GXmlNode*) _tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = _tmp44_;
		_tmp46_ = gee_map_get_values (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = _tmp47_;
		_tmp49_ = gee_iterable_iterator ((GeeIterable*) _tmp48_);
		_tmp50_ = _tmp49_;
		_g_object_unref0 (_tmp48_);
		_g_object_unref0 (_tmp45_);
		_attr_it = _tmp50_;
		while (TRUE) {
			GeeIterator* _tmp51_;
			GXmlNode* attr = NULL;
			GeeIterator* _tmp52_;
			gpointer _tmp53_;
			GXmlNode* _tmp54_;
			_tmp51_ = _attr_it;
			if (!gee_iterator_next (_tmp51_)) {
				break;
			}
			_tmp52_ = _attr_it;
			_tmp53_ = gee_iterator_get (_tmp52_);
			attr = (GXmlNode*) _tmp53_;
			_tmp54_ = attr;
			gxml_serializable_object_model_deserialize_property (self, _tmp54_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gboolean _tmp55_ = FALSE;
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (attr);
				_g_object_unref0 (_attr_it);
				_g_object_unref0 (element);
				_g_object_unref0 (doc);
				return _tmp55_;
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
	if (g_type_is_a (G_TYPE_FROM_INSTANCE ((GObject*) self), GXML_TYPE_SERIALIZABLE_CONTAINER)) {
		gxml_serializable_container_init_containers (G_TYPE_CHECK_INSTANCE_CAST (self, GXML_TYPE_SERIALIZABLE_CONTAINER, GXmlSerializableContainer));
	}
	_tmp56_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_PARAM, (GBoxedCopyFunc) g_param_spec_ref, (GDestroyNotify) g_param_spec_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	cnodes = _tmp56_;
	_tmp57_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GXML_TYPE_SERIALIZABLE_COLLECTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	cns = _tmp57_;
	_tmp59_ = gxml_serializable_object_model_list_serializable_properties (self, &_tmp58_);
	{
		GParamSpec** spec_collection = NULL;
		gint spec_collection_length1 = 0;
		gint _spec_collection_size_ = 0;
		gint spec_it = 0;
		spec_collection = _tmp59_;
		spec_collection_length1 = _tmp58_;
		for (spec_it = 0; spec_it < _tmp58_; spec_it = spec_it + 1) {
			GParamSpec* _tmp60_;
			GParamSpec* spec = NULL;
			_tmp60_ = _g_param_spec_ref0 (spec_collection[spec_it]);
			spec = _tmp60_;
			{
				GParamSpec* _tmp61_;
				GType _tmp62_;
				_tmp61_ = spec;
				_tmp62_ = _tmp61_->value_type;
				if (g_type_is_a (_tmp62_, GXML_TYPE_SERIALIZABLE)) {
					GParamSpec* _tmp63_;
					GType _tmp64_;
					_tmp63_ = spec;
					_tmp64_ = _tmp63_->value_type;
					if (g_type_is_a (_tmp64_, GXML_TYPE_SERIALIZABLE_COLLECTION)) {
						GValue vo = {0};
						GParamSpec* _tmp65_;
						GType _tmp66_;
						GValue _tmp67_ = {0};
						GParamSpec* _tmp68_;
						const gchar* _tmp69_;
						GObject* objv = NULL;
						GObject* _tmp70_;
						GObject* _tmp71_;
						GObject* _tmp72_;
						_tmp65_ = spec;
						_tmp66_ = _tmp65_->value_type;
						g_value_init (&_tmp67_, _tmp66_);
						vo = _tmp67_;
						_tmp68_ = spec;
						_tmp69_ = _tmp68_->name;
						g_object_get_property ((GObject*) self, _tmp69_, &vo);
						_tmp70_ = g_value_get_object (&vo);
						_tmp71_ = _g_object_ref0 (_tmp70_);
						objv = _tmp71_;
						_tmp72_ = objv;
						if (_tmp72_ != NULL) {
							gchar* nname = NULL;
							GObject* _tmp73_;
							gchar* _tmp74_;
							GObject* _tmp75_;
							GXmlElement* _tmp76_;
							GeeHashMap* _tmp78_;
							const gchar* _tmp79_;
							GParamSpec* _tmp80_;
							GeeHashMap* _tmp81_;
							const gchar* _tmp82_;
							gchar* _tmp83_;
							gchar* _tmp84_;
							GObject* _tmp85_;
							_tmp73_ = objv;
							_tmp74_ = gxml_serializable_node_name (G_TYPE_CHECK_INSTANCE_TYPE (_tmp73_, GXML_TYPE_SERIALIZABLE) ? ((GXmlSerializable*) _tmp73_) : NULL);
							nname = _tmp74_;
							_tmp75_ = objv;
							_tmp76_ = element;
							gxml_serializable_deserialize (G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, GXML_TYPE_SERIALIZABLE, GXmlSerializable), (GXmlNode*) _tmp76_, &_inner_error_);
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								gboolean _tmp77_ = FALSE;
								g_propagate_error (error, _inner_error_);
								_g_free0 (nname);
								_g_object_unref0 (objv);
								G_IS_VALUE (&vo) ? (g_value_unset (&vo), NULL) : NULL;
								_g_param_spec_unref0 (spec);
								spec_collection = (_vala_array_free (spec_collection, spec_collection_length1, (GDestroyNotify) g_param_spec_unref), NULL);
								_g_object_unref0 (cns);
								_g_object_unref0 (cnodes);
								_g_object_unref0 (element);
								_g_object_unref0 (doc);
								return _tmp77_;
							}
							_tmp78_ = cnodes;
							_tmp79_ = nname;
							_tmp80_ = spec;
							gee_abstract_map_set ((GeeAbstractMap*) _tmp78_, _tmp79_, _tmp80_);
							_tmp81_ = cns;
							_tmp82_ = nname;
							_tmp83_ = g_utf8_strdown (_tmp82_, (gssize) -1);
							_tmp84_ = _tmp83_;
							_tmp85_ = objv;
							gee_abstract_map_set ((GeeAbstractMap*) _tmp81_, _tmp84_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp85_, GXML_TYPE_SERIALIZABLE_COLLECTION) ? ((GXmlSerializableCollection*) _tmp85_) : NULL);
							_g_free0 (_tmp84_);
							_g_free0 (nname);
						}
						_g_object_unref0 (objv);
						G_IS_VALUE (&vo) ? (g_value_unset (&vo), NULL) : NULL;
					}
				}
				_g_param_spec_unref0 (spec);
			}
		}
		spec_collection = (_vala_array_free (spec_collection, spec_collection_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	}
	{
		GeeBidirList* _n_list = NULL;
		GXmlElement* _tmp86_;
		GeeBidirList* _tmp87_;
		GeeBidirList* _tmp88_;
		gint _n_size = 0;
		GeeBidirList* _tmp89_;
		gint _tmp90_;
		gint _tmp91_;
		gint _n_index = 0;
		_tmp86_ = element;
		_tmp87_ = gxml_node_get_children_nodes ((GXmlNode*) _tmp86_);
		_tmp88_ = _tmp87_;
		_n_list = _tmp88_;
		_tmp89_ = _n_list;
		_tmp90_ = gee_collection_get_size ((GeeCollection*) _tmp89_);
		_tmp91_ = _tmp90_;
		_n_size = _tmp91_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp92_;
			gint _tmp93_;
			gint _tmp94_;
			GXmlNode* n = NULL;
			GeeBidirList* _tmp95_;
			gint _tmp96_;
			gpointer _tmp97_;
			GXmlNode* _tmp98_;
			gchar* _tmp99_;
			gchar* _tmp100_;
			gchar* _tmp101_;
			gboolean _tmp102_;
			GeeHashMap* _tmp103_;
			GXmlNode* _tmp104_;
			gchar* _tmp105_;
			gchar* _tmp106_;
			gchar* _tmp107_;
			gboolean _tmp108_;
			GXmlNode* _tmp109_;
			_tmp92_ = _n_index;
			_n_index = _tmp92_ + 1;
			_tmp93_ = _n_index;
			_tmp94_ = _n_size;
			if (!(_tmp93_ < _tmp94_)) {
				break;
			}
			_tmp95_ = _n_list;
			_tmp96_ = _n_index;
			_tmp97_ = gee_list_get ((GeeList*) _tmp95_, _tmp96_);
			n = (GXmlNode*) _tmp97_;
			_tmp98_ = n;
			_tmp99_ = gxml_node_get_name (_tmp98_);
			_tmp100_ = _tmp99_;
			_tmp101_ = _tmp100_;
			_tmp102_ = _tmp101_ == NULL;
			_g_free0 (_tmp101_);
			if (_tmp102_) {
				g_warning ("SerializableObjectModel.vala:375: Child node name is null");
				_g_object_unref0 (n);
				continue;
			}
			_tmp103_ = cnodes;
			_tmp104_ = n;
			_tmp105_ = gxml_node_get_name (_tmp104_);
			_tmp106_ = _tmp105_;
			_tmp107_ = _tmp106_;
			_tmp108_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp103_, _tmp107_);
			_g_free0 (_tmp107_);
			if (_tmp108_) {
				_g_object_unref0 (n);
				continue;
			}
			_tmp109_ = n;
			gxml_serializable_object_model_deserialize_property (self, _tmp109_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gboolean _tmp110_ = FALSE;
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (n);
				_g_object_unref0 (_n_list);
				_g_object_unref0 (cns);
				_g_object_unref0 (cnodes);
				_g_object_unref0 (element);
				_g_object_unref0 (doc);
				return _tmp110_;
			}
			_g_object_unref0 (n);
		}
		_g_object_unref0 (_n_list);
	}
	result = TRUE;
	_g_object_unref0 (cns);
	_g_object_unref0 (cnodes);
	_g_object_unref0 (element);
	_g_object_unref0 (doc);
	return result;
}


static gboolean
gxml_serializable_object_model_real_deserialize_property (GXmlSerializableObjectModel* self, 
                                                          GXmlNode* property_node, 
                                                          GError** error)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (property_node != NULL, FALSE);
	_tmp0_ = gxml_serializable_object_model_default_deserialize_property (self, property_node, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_propagate_error (error, _inner_error_);
		return _tmp1_;
	}
	result = _tmp0_;
	return result;
}


gboolean
gxml_serializable_object_model_deserialize_property (GXmlSerializableObjectModel* self, 
                                                     GXmlNode* property_node, 
                                                     GError** error)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->deserialize_property (self, property_node, error);
}


gboolean
gxml_serializable_object_model_default_deserialize_property (GXmlSerializableObjectModel* self, 
                                                             GXmlNode* property_node, 
                                                             GError** error)
{
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GParamSpec* prop = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GParamSpec* _tmp3_;
	GParamSpec* _tmp4_;
	GParamSpec* _tmp5_;
	gboolean _tmp13_ = FALSE;
	GParamSpec* _tmp14_;
	GType _tmp15_;
	GParamSpec* _tmp95_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (property_node != NULL, FALSE);
	ret = FALSE;
	_tmp0_ = gxml_node_get_name (property_node);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gxml_serializable_object_model_find_property_spec (self, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	prop = _tmp4_;
	_tmp5_ = prop;
	if (_tmp5_ == NULL) {
		gboolean _tmp6_ = FALSE;
		if (G_TYPE_CHECK_INSTANCE_TYPE (property_node, GXML_TYPE_TEXT)) {
			_tmp6_ = gxml_serializable_object_model_serialize_use_xml_node_value (self);
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp7_ = gxml_node_get_value (property_node);
			_tmp8_ = _tmp7_;
			_tmp9_ = _tmp8_;
			gxml_serializable_set_serialized_xml_node_value ((GXmlSerializable*) self, _tmp9_);
			_g_free0 (_tmp9_);
		}
		if (gxml_serializable_object_model_get_enable_unknown_serializable_property (self)) {
			GXmlNode* _tmp10_;
			_tmp10_ = self->_node;
			if (_tmp10_ == NULL) {
				GXmlNode* _tmp11_;
				GXmlNode* _tmp12_;
				_tmp11_ = gxml_node_get_parent (property_node);
				_tmp12_ = _tmp11_;
				_g_object_unref0 (self->_node);
				self->_node = _tmp12_;
			}
		}
		result = TRUE;
		_g_param_spec_unref0 (prop);
		return result;
	}
	_tmp14_ = prop;
	_tmp15_ = _tmp14_->value_type;
	if (g_type_is_a (_tmp15_, GXML_TYPE_SERIALIZABLE)) {
		_tmp13_ = TRUE;
	} else {
		GParamSpec* _tmp16_;
		GType _tmp17_;
		_tmp16_ = prop;
		_tmp17_ = _tmp16_->value_type;
		_tmp13_ = g_type_is_a (_tmp17_, GXML_TYPE_SERIALIZABLE_PROPERTY);
	}
	if (_tmp13_) {
		GValue vobj = {0};
		GValue _tmp18_ = {0};
		GParamSpec* _tmp19_;
		const gchar* _tmp20_;
		GObject* object = NULL;
		GObject* _tmp21_;
		GObject* _tmp22_;
		GObject* _tmp23_;
		g_value_init (&_tmp18_, G_TYPE_OBJECT);
		vobj = _tmp18_;
		_tmp19_ = prop;
		_tmp20_ = _tmp19_->name;
		g_object_get_property ((GObject*) self, _tmp20_, &vobj);
		object = NULL;
		_tmp21_ = g_value_get_object (&vobj);
		_tmp22_ = _g_object_ref0 (_tmp21_);
		_g_object_unref0 (object);
		object = _tmp22_;
		_tmp23_ = object;
		if (_tmp23_ == NULL) {
			GParamSpec* _tmp24_;
			GType _tmp25_;
			_tmp24_ = prop;
			_tmp25_ = _tmp24_->value_type;
			if (g_type_is_a (_tmp25_, GXML_TYPE_SERIALIZABLE_PROPERTY)) {
				GObject* obj = NULL;
				GParamSpec* _tmp26_;
				GType _tmp27_;
				GObject* _tmp28_;
				GObject* _tmp29_;
				GObject* _tmp30_;
				GParamSpec* _tmp31_;
				GParamSpec* _tmp33_;
				const gchar* _tmp34_;
				GObject* _tmp35_;
				GValue _tmp36_ = {0};
				_tmp26_ = prop;
				_tmp27_ = _tmp26_->value_type;
				_tmp28_ = g_object_new (_tmp27_, NULL);
				_tmp29_ = G_IS_INITIALLY_UNOWNED (_tmp28_) ? g_object_ref_sink (_tmp28_) : _tmp28_;
				obj = _tmp29_;
				_tmp30_ = obj;
				_tmp31_ = prop;
				gxml_serializable_property_deserialize_property (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GXML_TYPE_SERIALIZABLE_PROPERTY, GXmlSerializableProperty), property_node, _tmp31_, gxml_serializable_object_model_property_use_nick (self), &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					gboolean _tmp32_ = FALSE;
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (obj);
					_g_object_unref0 (object);
					G_IS_VALUE (&vobj) ? (g_value_unset (&vobj), NULL) : NULL;
					_g_param_spec_unref0 (prop);
					return _tmp32_;
				}
				_tmp33_ = prop;
				_tmp34_ = _tmp33_->name;
				_tmp35_ = obj;
				g_value_init (&_tmp36_, G_TYPE_OBJECT);
				g_value_set_object (&_tmp36_, _tmp35_);
				g_object_set_property ((GObject*) self, _tmp34_, &_tmp36_);
				G_IS_VALUE (&_tmp36_) ? (g_value_unset (&_tmp36_), NULL) : NULL;
				_g_object_unref0 (obj);
			} else {
				GParamSpec* _tmp37_;
				GType _tmp38_;
				_tmp37_ = prop;
				_tmp38_ = _tmp37_->value_type;
				if (g_type_is_a (_tmp38_, GXML_TYPE_SERIALIZABLE)) {
					GObject* obj = NULL;
					GParamSpec* _tmp39_;
					GType _tmp40_;
					GObject* _tmp41_;
					GObject* _tmp42_;
					GObject* _tmp43_;
					GParamSpec* _tmp45_;
					const gchar* _tmp46_;
					GObject* _tmp47_;
					GValue _tmp48_ = {0};
					_tmp39_ = prop;
					_tmp40_ = _tmp39_->value_type;
					_tmp41_ = g_object_new (_tmp40_, NULL);
					_tmp42_ = G_IS_INITIALLY_UNOWNED (_tmp41_) ? g_object_ref_sink (_tmp41_) : _tmp41_;
					obj = _tmp42_;
					_tmp43_ = obj;
					gxml_serializable_deserialize (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, GXML_TYPE_SERIALIZABLE, GXmlSerializable), property_node, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						gboolean _tmp44_ = FALSE;
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (obj);
						_g_object_unref0 (object);
						G_IS_VALUE (&vobj) ? (g_value_unset (&vobj), NULL) : NULL;
						_g_param_spec_unref0 (prop);
						return _tmp44_;
					}
					_tmp45_ = prop;
					_tmp46_ = _tmp45_->name;
					_tmp47_ = obj;
					g_value_init (&_tmp48_, G_TYPE_OBJECT);
					g_value_set_object (&_tmp48_, _tmp47_);
					g_object_set_property ((GObject*) self, _tmp46_, &_tmp48_);
					G_IS_VALUE (&_tmp48_) ? (g_value_unset (&_tmp48_), NULL) : NULL;
					_g_object_unref0 (obj);
				}
			}
		} else {
			GObject* _tmp49_;
			_tmp49_ = object;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp49_, GXML_TYPE_SERIALIZABLE_PROPERTY)) {
				GObject* _tmp50_;
				GParamSpec* _tmp51_;
				_tmp50_ = object;
				_tmp51_ = prop;
				gxml_serializable_property_deserialize_property (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, GXML_TYPE_SERIALIZABLE_PROPERTY, GXmlSerializableProperty), property_node, _tmp51_, gxml_serializable_object_model_property_use_nick (self), &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					gboolean _tmp52_ = FALSE;
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (object);
					G_IS_VALUE (&vobj) ? (g_value_unset (&vobj), NULL) : NULL;
					_g_param_spec_unref0 (prop);
					return _tmp52_;
				}
			} else {
				GObject* _tmp53_;
				_tmp53_ = object;
				gxml_serializable_deserialize (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, GXML_TYPE_SERIALIZABLE, GXmlSerializable), property_node, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					gboolean _tmp54_ = FALSE;
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (object);
					G_IS_VALUE (&vobj) ? (g_value_unset (&vobj), NULL) : NULL;
					_g_param_spec_unref0 (prop);
					return _tmp54_;
				}
			}
		}
		result = TRUE;
		_g_object_unref0 (object);
		G_IS_VALUE (&vobj) ? (g_value_unset (&vobj), NULL) : NULL;
		_g_param_spec_unref0 (prop);
		return result;
	} else {
		GValue val = {0};
		GParamSpec* _tmp55_;
		GType _tmp56_;
		_tmp55_ = prop;
		_tmp56_ = _tmp55_->value_type;
		if (_tmp56_ == G_TYPE_ENUM) {
			GValue _tmp57_ = {0};
			GValue _tmp58_;
			g_value_init (&_tmp57_, G_TYPE_INT);
			G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			val = _tmp57_;
			_tmp58_ = val;
		} else {
			GParamSpec* _tmp59_;
			GType _tmp60_;
			GValue _tmp61_ = {0};
			GValue _tmp62_;
			_tmp59_ = prop;
			_tmp60_ = _tmp59_->value_type;
			g_value_init (&_tmp61_, _tmp60_);
			G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			val = _tmp61_;
			_tmp62_ = val;
		}
		if (G_TYPE_CHECK_INSTANCE_TYPE (property_node, GXML_TYPE_ATTRIBUTE)) {
			GParamSpec* _tmp63_;
			GType _tmp64_;
			GParamSpec* _tmp92_;
			const gchar* _tmp93_;
			GValue _tmp94_;
			_tmp63_ = prop;
			_tmp64_ = _tmp63_->value_type;
			if (g_type_is_a (_tmp64_, G_TYPE_ENUM)) {
				GEnumValue env = {0};
				{
					GEnumValue* _tmp65_ = NULL;
					GParamSpec* _tmp66_;
					GType _tmp67_;
					gchar* _tmp68_;
					gchar* _tmp69_;
					gchar* _tmp70_;
					GEnumValue* _tmp71_;
					GEnumValue* _tmp72_;
					GEnumValue* _tmp73_;
					GEnumValue* _tmp74_;
					GEnumValue _tmp75_;
					gint _tmp76_;
					_tmp66_ = prop;
					_tmp67_ = _tmp66_->value_type;
					_tmp68_ = gxml_node_get_value (property_node);
					_tmp69_ = _tmp68_;
					_tmp70_ = _tmp69_;
					_tmp71_ = gxml_enumeration_parse (_tmp67_, _tmp70_, &_inner_error_);
					_tmp72_ = _tmp71_;
					_g_free0 (_tmp70_);
					_tmp65_ = _tmp72_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == GXML_ENUMERATION_ERROR) {
							goto __catch2_gxml_enumeration_error;
						}
						goto __finally2;
					}
					_tmp73_ = _tmp65_;
					_tmp65_ = NULL;
					_tmp74_ = _tmp73_;
					env = *_tmp74_;
					_g_free0 (_tmp74_);
					_tmp75_ = env;
					_tmp76_ = _tmp75_.value;
					g_value_set_enum (&val, _tmp76_);
					_g_free0 (_tmp65_);
				}
				goto __finally2;
				__catch2_gxml_enumeration_error:
				{
					GError* e = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (e);
				}
				__finally2:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					gboolean _tmp77_ = FALSE;
					g_propagate_error (error, _inner_error_);
					G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
					_g_param_spec_unref0 (prop);
					return _tmp77_;
				}
			} else {
				GValue ptmp = {0};
				GValue _tmp78_ = {0};
				gchar* _tmp79_;
				gchar* _tmp80_;
				gchar* _tmp81_;
				GParamSpec* _tmp82_;
				GType _tmp83_;
				g_value_init (&_tmp78_, G_TYPE_STRING);
				ptmp = _tmp78_;
				_tmp79_ = gxml_node_get_value (property_node);
				_tmp80_ = _tmp79_;
				_tmp81_ = _tmp80_;
				g_value_set_string (&ptmp, _tmp81_);
				_g_free0 (_tmp81_);
				_tmp82_ = prop;
				_tmp83_ = _tmp82_->value_type;
				if (g_value_type_transformable (G_TYPE_STRING, _tmp83_)) {
					gboolean _tmp84_;
					_tmp84_ = g_value_transform (&ptmp, &val);
					ret = _tmp84_;
				} else {
					gboolean _tmp85_ = FALSE;
					gchar* _tmp86_;
					gchar* _tmp87_;
					gchar* _tmp88_;
					gboolean _tmp89_;
					gboolean _tmp90_;
					_tmp86_ = gxml_node_get_value (property_node);
					_tmp87_ = _tmp86_;
					_tmp88_ = _tmp87_;
					_tmp89_ = gxml_serializable_string_to_gvalue (_tmp88_, &val, &_inner_error_);
					_tmp90_ = _tmp89_;
					_g_free0 (_tmp88_);
					_tmp85_ = _tmp90_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						gboolean _tmp91_ = FALSE;
						g_propagate_error (error, _inner_error_);
						G_IS_VALUE (&ptmp) ? (g_value_unset (&ptmp), NULL) : NULL;
						G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
						_g_param_spec_unref0 (prop);
						return _tmp91_;
					}
					ret = _tmp85_;
				}
				G_IS_VALUE (&ptmp) ? (g_value_unset (&ptmp), NULL) : NULL;
			}
			_tmp92_ = prop;
			_tmp93_ = _tmp92_->name;
			_tmp94_ = val;
			g_object_set_property ((GObject*) self, _tmp93_, &_tmp94_);
			result = ret;
			G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			_g_param_spec_unref0 (prop);
			return result;
		}
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	}
	_tmp95_ = prop;
	g_signal_emit_by_name ((GXmlSerializable*) self, "deserialize-unknown-property", property_node, _tmp95_);
	result = TRUE;
	_g_param_spec_unref0 (prop);
	return result;
}


static gchar*
gxml_serializable_object_model_real_to_string (GXmlSerializableObjectModel* self)
{
	g_critical ("Type `%s' does not implement abstract method `gxml_serializable_object_model_to_string'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gchar*
gxml_serializable_object_model_to_string (GXmlSerializableObjectModel* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->to_string (self);
}


GXmlSerializableObjectModel*
gxml_serializable_object_model_construct (GType object_type)
{
	GXmlSerializableObjectModel * self = NULL;
	self = (GXmlSerializableObjectModel*) g_object_new (object_type, NULL);
	return self;
}


GHashTable*
gxml_serializable_object_model_get_ignored_serializable_properties (GXmlSerializableObjectModel* self)
{
	GHashTable* result;
	GHashTable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ignored_serializable_properties;
	result = _tmp0_;
	return result;
}


static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}


void
gxml_serializable_object_model_set_ignored_serializable_properties (GXmlSerializableObjectModel* self, 
                                                                    GHashTable* value)
{
	g_return_if_fail (self != NULL);
	if (gxml_serializable_object_model_get_ignored_serializable_properties (self) != value) {
		GHashTable* _tmp0_;
		_tmp0_ = _g_hash_table_ref0 (value);
		_g_hash_table_unref0 (self->priv->_ignored_serializable_properties);
		self->priv->_ignored_serializable_properties = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gxml_serializable_object_model_properties[GXML_SERIALIZABLE_OBJECT_MODEL_IGNORED_SERIALIZABLE_PROPERTIES_PROPERTY]);
	}
}


static gchar*
gxml_serializable_object_model_real_get_serialized_xml_node_value (GXmlSerializable* base)
{
	gchar* result;
	GXmlSerializableObjectModel* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (GXmlSerializableObjectModel*) base;
	_tmp0_ = self->priv->_serialized_xml_node_value;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void
gxml_serializable_object_model_real_set_serialized_xml_node_value (GXmlSerializable* base, 
                                                                   const gchar* value)
{
	GXmlSerializableObjectModel* self;
	self = (GXmlSerializableObjectModel*) base;
	if (g_strcmp0 (value, gxml_serializable_object_model_real_get_serialized_xml_node_value (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_serialized_xml_node_value);
		self->priv->_serialized_xml_node_value = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gxml_serializable_object_model_properties[GXML_SERIALIZABLE_OBJECT_MODEL_SERIALIZED_XML_NODE_VALUE_PROPERTY]);
	}
}


static GeeMap*
gxml_serializable_object_model_real_get_unknown_serializable_properties (GXmlSerializable* base)
{
	GeeMap* result;
	GXmlSerializableObjectModel* self;
	GeeHashMap* m = NULL;
	GeeHashMap* _tmp0_;
	GXmlNode* _tmp1_;
	GParamSpec** props = NULL;
	gint _tmp2_;
	GParamSpec** _tmp3_;
	gint props_length1;
	gint _props_size_;
	gboolean found = FALSE;
	self = (GXmlSerializableObjectModel*) base;
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GXML_TYPE_ATTRIBUTE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	m = _tmp0_;
	_tmp1_ = self->_node;
	if (_tmp1_ == NULL) {
		result = (GeeMap*) m;
		return result;
	}
	_tmp3_ = gxml_serializable_object_model_list_serializable_properties (self, &_tmp2_);
	props = _tmp3_;
	props_length1 = _tmp2_;
	_props_size_ = props_length1;
	found = FALSE;
	{
		GeeIterator* _a_it = NULL;
		GXmlNode* _tmp4_;
		GeeMap* _tmp5_;
		GeeMap* _tmp6_;
		GeeMap* _tmp7_;
		GeeCollection* _tmp8_;
		GeeCollection* _tmp9_;
		GeeCollection* _tmp10_;
		GeeIterator* _tmp11_;
		GeeIterator* _tmp12_;
		_tmp4_ = self->_node;
		_tmp5_ = gxml_node_get_attrs (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = gee_map_get_values (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		_tmp11_ = gee_iterable_iterator ((GeeIterable*) _tmp10_);
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp10_);
		_g_object_unref0 (_tmp7_);
		_a_it = _tmp12_;
		while (TRUE) {
			GeeIterator* _tmp13_;
			GXmlNode* a = NULL;
			GeeIterator* _tmp14_;
			gpointer _tmp15_;
			gboolean _tmp46_;
			_tmp13_ = _a_it;
			if (!gee_iterator_next (_tmp13_)) {
				break;
			}
			_tmp14_ = _a_it;
			_tmp15_ = gee_iterator_get (_tmp14_);
			a = (GXmlNode*) _tmp15_;
			found = FALSE;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp16_ = FALSE;
					_tmp16_ = TRUE;
					while (TRUE) {
						gint _tmp18_;
						GParamSpec** _tmp19_;
						gint _tmp19__length1;
						GParamSpec* p = NULL;
						GParamSpec** _tmp20_;
						gint _tmp20__length1;
						gint _tmp21_;
						GParamSpec* _tmp22_;
						GParamSpec* _tmp23_;
						gboolean _tmp24_ = FALSE;
						GXmlNode* _tmp25_;
						gchar* _tmp26_;
						gchar* _tmp27_;
						gchar* _tmp28_;
						gchar* _tmp29_;
						gchar* _tmp30_;
						GParamSpec* _tmp31_;
						const gchar* _tmp32_;
						gchar* _tmp33_;
						gchar* _tmp34_;
						gboolean _tmp35_;
						if (!_tmp16_) {
							gint _tmp17_;
							_tmp17_ = i;
							i = _tmp17_ + 1;
						}
						_tmp16_ = FALSE;
						_tmp18_ = i;
						_tmp19_ = props;
						_tmp19__length1 = props_length1;
						if (!(_tmp18_ < _tmp19__length1)) {
							break;
						}
						_tmp20_ = props;
						_tmp20__length1 = props_length1;
						_tmp21_ = i;
						_tmp22_ = _tmp20_[_tmp21_];
						_tmp23_ = _g_param_spec_ref0 (_tmp22_);
						p = _tmp23_;
						_tmp25_ = a;
						_tmp26_ = gxml_node_get_name (_tmp25_);
						_tmp27_ = _tmp26_;
						_tmp28_ = _tmp27_;
						_tmp29_ = g_utf8_strdown (_tmp28_, (gssize) -1);
						_tmp30_ = _tmp29_;
						_tmp31_ = p;
						_tmp32_ = g_param_spec_get_name (_tmp31_);
						_tmp33_ = g_utf8_strdown (_tmp32_, (gssize) -1);
						_tmp34_ = _tmp33_;
						_tmp35_ = g_strcmp0 (_tmp30_, _tmp34_) == 0;
						_g_free0 (_tmp34_);
						_g_free0 (_tmp30_);
						_g_free0 (_tmp28_);
						if (_tmp35_) {
							_tmp24_ = TRUE;
						} else {
							GXmlNode* _tmp36_;
							gchar* _tmp37_;
							gchar* _tmp38_;
							gchar* _tmp39_;
							gchar* _tmp40_;
							gchar* _tmp41_;
							GParamSpec* _tmp42_;
							const gchar* _tmp43_;
							gchar* _tmp44_;
							gchar* _tmp45_;
							_tmp36_ = a;
							_tmp37_ = gxml_node_get_name (_tmp36_);
							_tmp38_ = _tmp37_;
							_tmp39_ = _tmp38_;
							_tmp40_ = g_utf8_strdown (_tmp39_, (gssize) -1);
							_tmp41_ = _tmp40_;
							_tmp42_ = p;
							_tmp43_ = g_param_spec_get_nick (_tmp42_);
							_tmp44_ = g_utf8_strdown (_tmp43_, (gssize) -1);
							_tmp45_ = _tmp44_;
							_tmp24_ = g_strcmp0 (_tmp41_, _tmp45_) == 0;
							_g_free0 (_tmp45_);
							_g_free0 (_tmp41_);
							_g_free0 (_tmp39_);
						}
						if (_tmp24_) {
							found = TRUE;
						}
						_g_param_spec_unref0 (p);
					}
				}
			}
			_tmp46_ = found;
			if (!_tmp46_) {
				GeeHashMap* _tmp47_;
				GXmlNode* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				GXmlNode* _tmp52_;
				_tmp47_ = m;
				_tmp48_ = a;
				_tmp49_ = gxml_node_get_name (_tmp48_);
				_tmp50_ = _tmp49_;
				_tmp51_ = _tmp50_;
				_tmp52_ = a;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp47_, _tmp51_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp52_, GXML_TYPE_ATTRIBUTE) ? ((GXmlAttribute*) _tmp52_) : NULL);
				_g_free0 (_tmp51_);
			}
			_g_object_unref0 (a);
		}
		_g_object_unref0 (_a_it);
	}
	result = (GeeMap*) m;
	props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	return result;
}


static void
_vala_array_add3 (gchar** * array, 
                  int* length, 
                  int* size, 
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add4 (gchar** * array, 
                  int* length, 
                  int* size, 
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add5 (gchar** * array, 
                  int* length, 
                  int* size, 
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static GeeCollection*
gxml_serializable_object_model_real_get_unknown_serializable_nodes (GXmlSerializable* base)
{
	GeeCollection* result;
	GXmlSerializableObjectModel* self;
	GeeArrayList* l = NULL;
	GeeArrayList* _tmp0_;
	GXmlNode* _tmp1_;
	GParamSpec** oprops = NULL;
	gint _tmp2_;
	GParamSpec** _tmp3_;
	gint oprops_length1;
	gint _oprops_size_;
	gchar** props = NULL;
	gchar** _tmp4_;
	gint props_length1;
	gint _props_size_;
	GParamSpec** _tmp5_;
	gint _tmp5__length1;
	gboolean found = FALSE;
	self = (GXmlSerializableObjectModel*) base;
	_tmp0_ = gee_array_list_new (GXML_TYPE_NODE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	l = _tmp0_;
	_tmp1_ = self->_node;
	if (_tmp1_ == NULL) {
		result = (GeeCollection*) l;
		return result;
	}
	_tmp3_ = gxml_serializable_object_model_list_serializable_properties (self, &_tmp2_);
	oprops = _tmp3_;
	oprops_length1 = _tmp2_;
	_oprops_size_ = oprops_length1;
	_tmp4_ = g_new0 (gchar*, 0 + 1);
	props = _tmp4_;
	props_length1 = 0;
	_props_size_ = props_length1;
	_tmp5_ = oprops;
	_tmp5__length1 = oprops_length1;
	{
		GParamSpec** op_collection = NULL;
		gint op_collection_length1 = 0;
		gint _op_collection_size_ = 0;
		gint op_it = 0;
		op_collection = _tmp5_;
		op_collection_length1 = _tmp5__length1;
		for (op_it = 0; op_it < _tmp5__length1; op_it = op_it + 1) {
			GParamSpec* _tmp6_;
			GParamSpec* op = NULL;
			_tmp6_ = _g_param_spec_ref0 (op_collection[op_it]);
			op = _tmp6_;
			{
				GParamSpec* _tmp7_;
				GType _tmp8_;
				_tmp7_ = op;
				_tmp8_ = _tmp7_->value_type;
				if (g_type_is_a (_tmp8_, GXML_TYPE_SERIALIZABLE_COLLECTION)) {
					GValue v = {0};
					GParamSpec* _tmp9_;
					GType _tmp10_;
					GValue _tmp11_ = {0};
					GParamSpec* _tmp12_;
					const gchar* _tmp13_;
					GObject* obj = NULL;
					GObject* _tmp14_;
					GObject* _tmp15_;
					GObject* _tmp16_;
					_tmp9_ = op;
					_tmp10_ = _tmp9_->value_type;
					g_value_init (&_tmp11_, _tmp10_);
					v = _tmp11_;
					_tmp12_ = op;
					_tmp13_ = g_param_spec_get_name (_tmp12_);
					g_object_get_property ((GObject*) self, _tmp13_, &v);
					_tmp14_ = g_value_get_object (&v);
					_tmp15_ = _g_object_ref0 (_tmp14_);
					obj = _tmp15_;
					_tmp16_ = obj;
					if (_tmp16_ != NULL) {
						gchar** _tmp17_;
						gint _tmp17__length1;
						GObject* _tmp18_;
						gchar* _tmp19_;
						_tmp17_ = props;
						_tmp17__length1 = props_length1;
						_tmp18_ = obj;
						_tmp19_ = gxml_serializable_node_name (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, GXML_TYPE_SERIALIZABLE) ? ((GXmlSerializable*) _tmp18_) : NULL);
						_vala_array_add3 (&props, &props_length1, &_props_size_, _tmp19_);
						_g_object_unref0 (obj);
						G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
						_g_param_spec_unref0 (op);
						continue;
					}
					_g_object_unref0 (obj);
					G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
				}
				if (gxml_serializable_object_model_property_use_nick (self)) {
					gchar** _tmp20_;
					gint _tmp20__length1;
					GParamSpec* _tmp21_;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp20_ = props;
					_tmp20__length1 = props_length1;
					_tmp21_ = op;
					_tmp22_ = g_param_spec_get_nick (_tmp21_);
					_tmp23_ = g_utf8_strdown (_tmp22_, (gssize) -1);
					_vala_array_add4 (&props, &props_length1, &_props_size_, _tmp23_);
				} else {
					gchar** _tmp24_;
					gint _tmp24__length1;
					GParamSpec* _tmp25_;
					const gchar* _tmp26_;
					gchar* _tmp27_;
					_tmp24_ = props;
					_tmp24__length1 = props_length1;
					_tmp25_ = op;
					_tmp26_ = g_param_spec_get_name (_tmp25_);
					_tmp27_ = g_utf8_strdown (_tmp26_, (gssize) -1);
					_vala_array_add5 (&props, &props_length1, &_props_size_, _tmp27_);
				}
				_g_param_spec_unref0 (op);
			}
		}
	}
	found = FALSE;
	{
		GeeBidirList* _n_list = NULL;
		GXmlNode* _tmp28_;
		GeeBidirList* _tmp29_;
		GeeBidirList* _tmp30_;
		gint _n_size = 0;
		GeeBidirList* _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		gint _n_index = 0;
		_tmp28_ = self->_node;
		_tmp29_ = gxml_node_get_children_nodes (_tmp28_);
		_tmp30_ = _tmp29_;
		_n_list = _tmp30_;
		_tmp31_ = _n_list;
		_tmp32_ = gee_collection_get_size ((GeeCollection*) _tmp31_);
		_tmp33_ = _tmp32_;
		_n_size = _tmp33_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp34_;
			gint _tmp35_;
			gint _tmp36_;
			GXmlNode* n = NULL;
			GeeBidirList* _tmp37_;
			gint _tmp38_;
			gpointer _tmp39_;
			GXmlNode* _tmp40_;
			gchar** _tmp41_;
			gint _tmp41__length1;
			gboolean _tmp51_;
			_tmp34_ = _n_index;
			_n_index = _tmp34_ + 1;
			_tmp35_ = _n_index;
			_tmp36_ = _n_size;
			if (!(_tmp35_ < _tmp36_)) {
				break;
			}
			_tmp37_ = _n_list;
			_tmp38_ = _n_index;
			_tmp39_ = gee_list_get ((GeeList*) _tmp37_, _tmp38_);
			n = (GXmlNode*) _tmp39_;
			_tmp40_ = n;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp40_, GXML_TYPE_TEXT)) {
				if (gxml_serializable_object_model_serialize_use_xml_node_value (self)) {
					_g_object_unref0 (n);
					continue;
				}
			}
			found = FALSE;
			_tmp41_ = props;
			_tmp41__length1 = props_length1;
			{
				gchar** p_collection = NULL;
				gint p_collection_length1 = 0;
				gint _p_collection_size_ = 0;
				gint p_it = 0;
				p_collection = _tmp41_;
				p_collection_length1 = _tmp41__length1;
				for (p_it = 0; p_it < _tmp41__length1; p_it = p_it + 1) {
					gchar* _tmp42_;
					gchar* p = NULL;
					_tmp42_ = g_strdup (p_collection[p_it]);
					p = _tmp42_;
					{
						GXmlNode* _tmp43_;
						gchar* _tmp44_;
						gchar* _tmp45_;
						gchar* _tmp46_;
						gchar* _tmp47_;
						gchar* _tmp48_;
						const gchar* _tmp49_;
						gboolean _tmp50_;
						_tmp43_ = n;
						_tmp44_ = gxml_node_get_name (_tmp43_);
						_tmp45_ = _tmp44_;
						_tmp46_ = _tmp45_;
						_tmp47_ = g_utf8_strdown (_tmp46_, (gssize) -1);
						_tmp48_ = _tmp47_;
						_tmp49_ = p;
						_tmp50_ = g_strcmp0 (_tmp48_, _tmp49_) == 0;
						_g_free0 (_tmp48_);
						_g_free0 (_tmp46_);
						if (_tmp50_) {
							found = TRUE;
						}
						_g_free0 (p);
					}
				}
			}
			_tmp51_ = found;
			if (!_tmp51_) {
				GeeArrayList* _tmp52_;
				GXmlNode* _tmp53_;
				_tmp52_ = l;
				_tmp53_ = n;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp52_, _tmp53_);
			}
			_g_object_unref0 (n);
		}
		_g_object_unref0 (_n_list);
	}
	result = (GeeCollection*) l;
	props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
	oprops = (_vala_array_free (oprops, oprops_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	return result;
}


static GObject *
gxml_serializable_object_model_constructor (GType type, 
                                            guint n_construct_properties, 
                                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GXmlSerializableObjectModel * self;
	parent_class = G_OBJECT_CLASS (gxml_serializable_object_model_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GXML_TYPE_SERIALIZABLE_OBJECT_MODEL, GXmlSerializableObjectModel);
	gxml_init_init ();
	return obj;
}


static void
gxml_serializable_object_model_class_init (GXmlSerializableObjectModelClass * klass)
{
	gxml_serializable_object_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GXmlSerializableObjectModelPrivate));
	((GXmlSerializableObjectModelClass *) klass)->get_enable_unknown_serializable_property = (gboolean (*) (GXmlSerializableObjectModel *)) gxml_serializable_object_model_real_get_enable_unknown_serializable_property;
	((GXmlSerializableObjectModelClass *) klass)->serialize_use_xml_node_value = (gboolean (*) (GXmlSerializableObjectModel *)) gxml_serializable_object_model_real_serialize_use_xml_node_value;
	((GXmlSerializableObjectModelClass *) klass)->property_use_nick = (gboolean (*) (GXmlSerializableObjectModel *)) gxml_serializable_object_model_real_property_use_nick;
	((GXmlSerializableObjectModelClass *) klass)->set_default_namespace = (gboolean (*) (GXmlSerializableObjectModel *, GXmlNode*)) gxml_serializable_object_model_real_set_default_namespace;
	((GXmlSerializableObjectModelClass *) klass)->node_name = (gchar* (*) (GXmlSerializableObjectModel *)) gxml_serializable_object_model_real_node_name;
	((GXmlSerializableObjectModelClass *) klass)->find_property_spec = (GParamSpec* (*) (GXmlSerializableObjectModel *, const gchar*)) gxml_serializable_object_model_real_find_property_spec;
	((GXmlSerializableObjectModelClass *) klass)->list_serializable_properties = (GParamSpec** (*) (GXmlSerializableObjectModel *, int*)) gxml_serializable_object_model_real_list_serializable_properties;
	((GXmlSerializableObjectModelClass *) klass)->serialize = (GXmlNode* (*) (GXmlSerializableObjectModel *, GXmlNode*, GError**)) gxml_serializable_object_model_real_serialize;
	((GXmlSerializableObjectModelClass *) klass)->serialize_property = (GXmlNode* (*) (GXmlSerializableObjectModel *, GXmlNode*, GParamSpec*, GError**)) gxml_serializable_object_model_real_serialize_property;
	((GXmlSerializableObjectModelClass *) klass)->deserialize = (gboolean (*) (GXmlSerializableObjectModel *, GXmlNode*, GError**)) gxml_serializable_object_model_real_deserialize;
	((GXmlSerializableObjectModelClass *) klass)->deserialize_property = (gboolean (*) (GXmlSerializableObjectModel *, GXmlNode*, GError**)) gxml_serializable_object_model_real_deserialize_property;
	((GXmlSerializableObjectModelClass *) klass)->to_string = (gchar* (*) (GXmlSerializableObjectModel *)) gxml_serializable_object_model_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_gxml_serializable_object_model_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gxml_serializable_object_model_set_property;
	G_OBJECT_CLASS (klass)->constructor = gxml_serializable_object_model_constructor;
	G_OBJECT_CLASS (klass)->finalize = gxml_serializable_object_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_SERIALIZABLE_OBJECT_MODEL_IGNORED_SERIALIZABLE_PROPERTIES_PROPERTY, gxml_serializable_object_model_properties[GXML_SERIALIZABLE_OBJECT_MODEL_IGNORED_SERIALIZABLE_PROPERTIES_PROPERTY] = g_param_spec_boxed ("ignored-serializable-properties", "ignored-serializable-properties", "ignored-serializable-properties", G_TYPE_HASH_TABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_SERIALIZABLE_OBJECT_MODEL_SERIALIZED_XML_NODE_VALUE_PROPERTY, gxml_serializable_object_model_properties[GXML_SERIALIZABLE_OBJECT_MODEL_SERIALIZED_XML_NODE_VALUE_PROPERTY] = g_param_spec_string ("serialized-xml-node-value", "serialized-xml-node-value", "serialized-xml-node-value", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * All unknown nodes, will be stored in a per-object {@link GXml.Document}
	   * in its {@link GXml.Element} root. Then, all unknown properties will be
	   * stored as properties in document's root and all unknown childs {@link GXml.Node}
	   * as root's childs.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_SERIALIZABLE_OBJECT_MODEL_UNKNOWN_SERIALIZABLE_PROPERTIES_PROPERTY, gxml_serializable_object_model_properties[GXML_SERIALIZABLE_OBJECT_MODEL_UNKNOWN_SERIALIZABLE_PROPERTIES_PROPERTY] = g_param_spec_object ("unknown-serializable-properties", "unknown-serializable-properties", "unknown-serializable-properties", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_SERIALIZABLE_OBJECT_MODEL_UNKNOWN_SERIALIZABLE_NODES_PROPERTY, gxml_serializable_object_model_properties[GXML_SERIALIZABLE_OBJECT_MODEL_UNKNOWN_SERIALIZABLE_NODES_PROPERTY] = g_param_spec_object ("unknown-serializable-nodes", "unknown-serializable-nodes", "unknown-serializable-nodes", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void
gxml_serializable_object_model_gxml_serializable_interface_init (GXmlSerializableIface * iface)
{
	gxml_serializable_object_model_gxml_serializable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_enable_unknown_serializable_property = (gboolean (*) (GXmlSerializable *)) gxml_serializable_object_model_get_enable_unknown_serializable_property;
	iface->serialize_use_xml_node_value = (gboolean (*) (GXmlSerializable *)) gxml_serializable_object_model_serialize_use_xml_node_value;
	iface->property_use_nick = (gboolean (*) (GXmlSerializable *)) gxml_serializable_object_model_property_use_nick;
	iface->set_default_namespace = (gboolean (*) (GXmlSerializable *, GXmlNode*)) gxml_serializable_object_model_set_default_namespace;
	iface->node_name = (gchar* (*) (GXmlSerializable *)) gxml_serializable_object_model_node_name;
	iface->find_property_spec = (GParamSpec* (*) (GXmlSerializable *, const gchar*)) gxml_serializable_object_model_find_property_spec;
	iface->list_serializable_properties = (GParamSpec** (*) (GXmlSerializable *, int*)) gxml_serializable_object_model_list_serializable_properties;
	iface->serialize = (GXmlNode* (*) (GXmlSerializable *, GXmlNode*, GError**)) gxml_serializable_object_model_serialize;
	iface->serialize_property = (GXmlNode* (*) (GXmlSerializable *, GXmlNode*, GParamSpec*, GError**)) gxml_serializable_object_model_serialize_property;
	iface->deserialize = (gboolean (*) (GXmlSerializable *, GXmlNode*, GError**)) gxml_serializable_object_model_deserialize;
	iface->deserialize_property = (gboolean (*) (GXmlSerializable *, GXmlNode*, GError**)) gxml_serializable_object_model_deserialize_property;
	iface->get_serialized_xml_node_value = gxml_serializable_object_model_real_get_serialized_xml_node_value;
	iface->set_serialized_xml_node_value = gxml_serializable_object_model_real_set_serialized_xml_node_value;
	iface->get_unknown_serializable_properties = gxml_serializable_object_model_real_get_unknown_serializable_properties;
	iface->get_unknown_serializable_nodes = gxml_serializable_object_model_real_get_unknown_serializable_nodes;
}


static void
gxml_serializable_object_model_instance_init (GXmlSerializableObjectModel * self)
{
	self->priv = GXML_SERIALIZABLE_OBJECT_MODEL_GET_PRIVATE (self);
	self->_node = NULL;
	self->priv->_serialized_xml_node_value = NULL;
}


static void
gxml_serializable_object_model_finalize (GObject * obj)
{
	GXmlSerializableObjectModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GXML_TYPE_SERIALIZABLE_OBJECT_MODEL, GXmlSerializableObjectModel);
	_g_object_unref0 (self->_node);
	_g_hash_table_unref0 (self->priv->_ignored_serializable_properties);
	_g_free0 (self->priv->_serialized_xml_node_value);
	G_OBJECT_CLASS (gxml_serializable_object_model_parent_class)->finalize (obj);
}


/**
 * Object Model is an {@link Serializable} implementation using {@link Element}
 * to represent {@link GLib.Object} class objects. It requires to dump to a {@link GXml.Document}
 * or parse a pre-parsed XML tree {@link GXml.Document}. See {@link GXml.GomDocument} to avoid
 * pre/post parsing processes.
 * 
 * This implementation consider each object as a XML node, represented in GXml 
 * as a {@link GXml.Element} and its properties is represented by {@link GXml.Attribute}.
 * Each property, if it is a {@link Serializable} object, is represented as child
 * {@link Element}.
 * 
 * If a object's value property must be represented as a XML node content, 
 * then it requires to override {@link Serializable.serialize_use_xml_node_value}
 * and set value at {@link Serializable.serialized_xml_node_value}.
 */
GType
gxml_serializable_object_model_get_type (void)
{
	static volatile gsize gxml_serializable_object_model_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_serializable_object_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlSerializableObjectModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gxml_serializable_object_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GXmlSerializableObjectModel), 0, (GInstanceInitFunc) gxml_serializable_object_model_instance_init, NULL };
		static const GInterfaceInfo gxml_serializable_info = { (GInterfaceInitFunc) gxml_serializable_object_model_gxml_serializable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gxml_serializable_object_model_type_id;
		gxml_serializable_object_model_type_id = g_type_register_static (G_TYPE_OBJECT, "GXmlSerializableObjectModel", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (gxml_serializable_object_model_type_id, GXML_TYPE_SERIALIZABLE, &gxml_serializable_info);
		g_once_init_leave (&gxml_serializable_object_model_type_id__volatile, gxml_serializable_object_model_type_id);
	}
	return gxml_serializable_object_model_type_id__volatile;
}


static void
_vala_gxml_serializable_object_model_get_property (GObject * object, 
                                                   guint property_id, 
                                                   GValue * value, 
                                                   GParamSpec * pspec)
{
	GXmlSerializableObjectModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GXML_TYPE_SERIALIZABLE_OBJECT_MODEL, GXmlSerializableObjectModel);
	switch (property_id) {
		case GXML_SERIALIZABLE_OBJECT_MODEL_IGNORED_SERIALIZABLE_PROPERTIES_PROPERTY:
		g_value_set_boxed (value, gxml_serializable_object_model_get_ignored_serializable_properties (self));
		break;
		case GXML_SERIALIZABLE_OBJECT_MODEL_SERIALIZED_XML_NODE_VALUE_PROPERTY:
		g_value_take_string (value, gxml_serializable_get_serialized_xml_node_value ((GXmlSerializable*) self));
		break;
		case GXML_SERIALIZABLE_OBJECT_MODEL_UNKNOWN_SERIALIZABLE_PROPERTIES_PROPERTY:
		g_value_take_object (value, gxml_serializable_get_unknown_serializable_properties ((GXmlSerializable*) self));
		break;
		case GXML_SERIALIZABLE_OBJECT_MODEL_UNKNOWN_SERIALIZABLE_NODES_PROPERTY:
		g_value_take_object (value, gxml_serializable_get_unknown_serializable_nodes ((GXmlSerializable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_gxml_serializable_object_model_set_property (GObject * object, 
                                                   guint property_id, 
                                                   const GValue * value, 
                                                   GParamSpec * pspec)
{
	GXmlSerializableObjectModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GXML_TYPE_SERIALIZABLE_OBJECT_MODEL, GXmlSerializableObjectModel);
	switch (property_id) {
		case GXML_SERIALIZABLE_OBJECT_MODEL_IGNORED_SERIALIZABLE_PROPERTIES_PROPERTY:
		gxml_serializable_object_model_set_ignored_serializable_properties (self, g_value_get_boxed (value));
		break;
		case GXML_SERIALIZABLE_OBJECT_MODEL_SERIALIZED_XML_NODE_VALUE_PROPERTY:
		gxml_serializable_set_serialized_xml_node_value ((GXmlSerializable*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_array_destroy (gpointer array, 
                     gint array_length, 
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array, 
                  gint array_length, 
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



