/* SerializableValueList.c generated by valac 0.39.3.9-ecb8a, the Vala compiler
 * generated from SerializableValueList.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */
/* SerializableValueList.vala
 *
 * Copyright (C) 2015  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>


#define GXML_TYPE_SERIALIZABLE_PROPERTY (gxml_serializable_property_get_type ())
#define GXML_SERIALIZABLE_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE_PROPERTY, GXmlSerializableProperty))
#define GXML_IS_SERIALIZABLE_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE_PROPERTY))
#define GXML_SERIALIZABLE_PROPERTY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_SERIALIZABLE_PROPERTY, GXmlSerializablePropertyIface))

typedef struct _GXmlSerializableProperty GXmlSerializableProperty;
typedef struct _GXmlSerializablePropertyIface GXmlSerializablePropertyIface;

#define GXML_TYPE_NODE (gxml_node_get_type ())
#define GXML_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NODE, GXmlNode))
#define GXML_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NODE))
#define GXML_NODE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NODE, GXmlNodeIface))

typedef struct _GXmlNode GXmlNode;
typedef struct _GXmlNodeIface GXmlNodeIface;

#define GXML_TYPE_ELEMENT_LIST (gxml_element_list_get_type ())
#define GXML_ELEMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ELEMENT_LIST, GXmlElementList))
#define GXML_ELEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_ELEMENT_LIST, GXmlElementListClass))
#define GXML_IS_ELEMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ELEMENT_LIST))
#define GXML_IS_ELEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_ELEMENT_LIST))
#define GXML_ELEMENT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_ELEMENT_LIST, GXmlElementListClass))

typedef struct _GXmlElementList GXmlElementList;
typedef struct _GXmlElementListClass GXmlElementListClass;

#define GXML_TYPE_NAMESPACE (gxml_namespace_get_type ())
#define GXML_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NAMESPACE, GXmlNamespace))
#define GXML_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NAMESPACE))
#define GXML_NAMESPACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NAMESPACE, GXmlNamespaceIface))

typedef struct _GXmlNamespace GXmlNamespace;
typedef struct _GXmlNamespaceIface GXmlNamespaceIface;

#define GXML_TYPE_NODE_TYPE (gxml_node_type_get_type ())

#define GXML_TYPE_DOCUMENT (gxml_document_get_type ())
#define GXML_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOCUMENT, GXmlDocument))
#define GXML_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOCUMENT))
#define GXML_DOCUMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOCUMENT, GXmlDocumentIface))

typedef struct _GXmlDocument GXmlDocument;
typedef struct _GXmlDocumentIface GXmlDocumentIface;

#define GXML_TYPE_SERIALIZABLE_VALUE_LIST (gxml_serializable_value_list_get_type ())
#define GXML_SERIALIZABLE_VALUE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE_VALUE_LIST, GXmlSerializableValueList))
#define GXML_SERIALIZABLE_VALUE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_SERIALIZABLE_VALUE_LIST, GXmlSerializableValueListClass))
#define GXML_IS_SERIALIZABLE_VALUE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE_VALUE_LIST))
#define GXML_IS_SERIALIZABLE_VALUE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_SERIALIZABLE_VALUE_LIST))
#define GXML_SERIALIZABLE_VALUE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_SERIALIZABLE_VALUE_LIST, GXmlSerializableValueListClass))

typedef struct _GXmlSerializableValueList GXmlSerializableValueList;
typedef struct _GXmlSerializableValueListClass GXmlSerializableValueListClass;
typedef struct _GXmlSerializableValueListPrivate GXmlSerializableValueListPrivate;
enum  {
	GXML_SERIALIZABLE_VALUE_LIST_0_PROPERTY,
	GXML_SERIALIZABLE_VALUE_LIST_NUM_PROPERTIES
};
static GParamSpec* gxml_serializable_value_list_properties[GXML_SERIALIZABLE_VALUE_LIST_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GXmlNamespaceIface {
	GTypeInterface parent_iface;
	gchar* (*get_uri) (GXmlNamespace* self);
	gchar* (*get_prefix) (GXmlNamespace* self);
};

typedef enum  {
	GXML_NODE_TYPE_INVALID = 0,
	GXML_NODE_TYPE_ELEMENT = 1,
	GXML_NODE_TYPE_ATTRIBUTE,
	GXML_NODE_TYPE_TEXT,
	GXML_NODE_TYPE_CDATA_SECTION,
	GXML_NODE_TYPE_ENTITY_REFERENCE,
	GXML_NODE_TYPE_ENTITY,
	GXML_NODE_TYPE_PROCESSING_INSTRUCTION,
	GXML_NODE_TYPE_COMMENT,
	GXML_NODE_TYPE_DOCUMENT,
	GXML_NODE_TYPE_DOCUMENT_TYPE,
	GXML_NODE_TYPE_DOCUMENT_FRAGMENT,
	GXML_NODE_TYPE_NOTATION
} GXmlNodeType;

struct _GXmlDocumentIface {
	GTypeInterface parent_iface;
	GXmlNode* (*create_element) (GXmlDocument* self, const gchar* name, GError** error);
	GXmlNode* (*create_text) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_comment) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_cdata) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_pi) (GXmlDocument* self, const gchar* target, const gchar* data);
	gboolean (*save) (GXmlDocument* self, GCancellable* cancellable, GError** error);
	gboolean (*save_as) (GXmlDocument* self, GFile* f, GCancellable* cancellable, GError** error);
	gboolean (*get_indent) (GXmlDocument* self);
	void (*set_indent) (GXmlDocument* self, gboolean value);
	gboolean (*get_ns_top) (GXmlDocument* self);
	void (*set_ns_top) (GXmlDocument* self, gboolean value);
	gboolean (*get_prefix_default_ns) (GXmlDocument* self);
	void (*set_prefix_default_ns) (GXmlDocument* self, gboolean value);
	gboolean (*get_backup) (GXmlDocument* self);
	void (*set_backup) (GXmlDocument* self, gboolean value);
	GXmlNode* (*get_root) (GXmlDocument* self);
	GFile* (*get_file) (GXmlDocument* self);
	void (*set_file) (GXmlDocument* self, GFile* value);
};

struct _GXmlNodeIface {
	GTypeInterface parent_iface;
	GXmlNode* (*get) (GXmlNode* self, const gchar* key);
	GXmlElementList* (*get_elements_by_property_value) (GXmlNode* self, const gchar* property, const gchar* value);
	GXmlElementList* (*get_elements_by_name) (GXmlNode* self, const gchar* name);
	GXmlElementList* (*get_elements_by_name_ns) (GXmlNode* self, const gchar* name, const gchar* ns);
	gchar* (*to_string) (GXmlNode* self);
	gboolean (*set_namespace) (GXmlNode* self, const gchar* uri, const gchar* prefix);
	gchar* (*ns_prefix) (GXmlNode* self);
	gchar* (*ns_uri) (GXmlNode* self);
	GeeList* (*get_namespaces) (GXmlNode* self);
	GeeBidirList* (*get_children_nodes) (GXmlNode* self);
	GeeMap* (*get_attrs) (GXmlNode* self);
	gchar* (*get_name) (GXmlNode* self);
	gchar* (*get_value) (GXmlNode* self);
	void (*set_value) (GXmlNode* self, const gchar* value);
	GXmlNodeType (*get_type_node) (GXmlNode* self);
	GXmlDocument* (*get_document) (GXmlNode* self);
	GXmlNode* (*get_parent) (GXmlNode* self);
};

struct _GXmlSerializablePropertyIface {
	GTypeInterface parent_iface;
	gchar* (*get_serializable_property_value) (GXmlSerializableProperty* self);
	void (*set_serializable_property_value) (GXmlSerializableProperty* self, const gchar* val);
	gboolean (*deserialize_property) (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error);
	GXmlNode* (*serialize_property) (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error);
};

struct _GXmlSerializableValueList {
	GObject parent_instance;
	GXmlSerializableValueListPrivate * priv;
	gchar** _vals;
	gint _vals_length1;
	GeeArrayList* extra;
};

struct _GXmlSerializableValueListClass {
	GObjectClass parent_class;
	GeeList* (*get_values) (GXmlSerializableValueList* self);
	void (*add_values) (GXmlSerializableValueList* self, gchar** vals, int vals_length1);
	gchar* (*get_value_at) (GXmlSerializableValueList* self, gint index);
	void (*select_value_at) (GXmlSerializableValueList* self, gint index);
	gchar** (*get_values_array) (GXmlSerializableValueList* self, int* result_length1);
	gboolean (*is_value) (GXmlSerializableValueList* self);
};

struct _GXmlSerializableValueListPrivate {
	gchar* _val;
};


static gpointer gxml_serializable_value_list_parent_class = NULL;
static GXmlSerializablePropertyIface * gxml_serializable_value_list_gxml_serializable_property_parent_iface = NULL;

GType gxml_element_list_get_type (void) G_GNUC_CONST;
GType gxml_namespace_get_type (void) G_GNUC_CONST;
GType gxml_node_type_get_type (void) G_GNUC_CONST;
GType gxml_document_get_type (void) G_GNUC_CONST;
GType gxml_node_get_type (void) G_GNUC_CONST;
GType gxml_serializable_property_get_type (void) G_GNUC_CONST;
GType gxml_serializable_value_list_get_type (void) G_GNUC_CONST;
#define GXML_SERIALIZABLE_VALUE_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GXML_TYPE_SERIALIZABLE_VALUE_LIST, GXmlSerializableValueListPrivate))
GeeList* gxml_serializable_value_list_get_values (GXmlSerializableValueList* self);
static GeeList* gxml_serializable_value_list_real_get_values (GXmlSerializableValueList* self);
void gxml_serializable_value_list_add_values (GXmlSerializableValueList* self, 
                                              gchar** vals, 
                                              int vals_length1);
static void gxml_serializable_value_list_real_add_values (GXmlSerializableValueList* self, 
                                                   gchar** vals, 
                                                   int vals_length1);
gchar* gxml_serializable_value_list_get_value_at (GXmlSerializableValueList* self, 
                                                  gint index);
static gchar* gxml_serializable_value_list_real_get_value_at (GXmlSerializableValueList* self, 
                                                       gint index);
void gxml_serializable_value_list_select_value_at (GXmlSerializableValueList* self, 
                                                   gint index);
static void gxml_serializable_value_list_real_select_value_at (GXmlSerializableValueList* self, 
                                                        gint index);
gchar** gxml_serializable_value_list_get_values_array (GXmlSerializableValueList* self, 
                                                       int* result_length1);
static gchar** gxml_serializable_value_list_real_get_values_array (GXmlSerializableValueList* self, 
                                                            int* result_length1);
gboolean gxml_serializable_value_list_is_value (GXmlSerializableValueList* self);
static gboolean gxml_serializable_value_list_real_is_value (GXmlSerializableValueList* self);
static gchar* gxml_serializable_value_list_real_get_serializable_property_value (GXmlSerializableProperty* base);
static void gxml_serializable_value_list_real_set_serializable_property_value (GXmlSerializableProperty* base, 
                                                                        const gchar* val);
gchar* gxml_serializable_value_list_to_string (GXmlSerializableValueList* self);
GXmlSerializableValueList* gxml_serializable_value_list_new (void);
GXmlSerializableValueList* gxml_serializable_value_list_construct (GType object_type);
static GObject * gxml_serializable_value_list_constructor (GType type, 
                                                    guint n_construct_properties, 
                                                    GObjectConstructParam * construct_properties);
void gxml_init_init (void);
static void gxml_serializable_value_list_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, 
                          gint array_length, 
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, 
                       gint array_length, 
                       GDestroyNotify destroy_func);


/**
   * Return a {@link Gee.List} with all possible selection strings.
   *
   * If no values where defined at construction time and no values
   * have been added, then this will return an empty list.
   */
static GeeList*
gxml_serializable_value_list_real_get_values (GXmlSerializableValueList* self)
{
	GeeList* result = NULL;
	GeeArrayList* l = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	l = _tmp0_;
	_tmp1_ = self->extra;
	if (_tmp1_ != NULL) {
		GeeArrayList* _tmp2_;
		GeeArrayList* _tmp3_;
		_tmp2_ = l;
		_tmp3_ = self->extra;
		gee_array_list_add_all (_tmp2_, (GeeCollection*) _tmp3_);
	}
	_tmp4_ = self->_vals;
	_tmp4__length1 = self->_vals_length1;
	if (_tmp4_ == NULL) {
		result = (GeeList*) l;
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_;
				gchar** _tmp8_;
				gint _tmp8__length1;
				GeeArrayList* _tmp9_;
				gchar** _tmp10_;
				gint _tmp10__length1;
				gint _tmp11_;
				const gchar* _tmp12_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = self->_vals;
				_tmp8__length1 = self->_vals_length1;
				if (!(_tmp7_ < _tmp8__length1)) {
					break;
				}
				_tmp9_ = l;
				_tmp10_ = self->_vals;
				_tmp10__length1 = self->_vals_length1;
				_tmp11_ = i;
				_tmp12_ = _tmp10_[_tmp11_];
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp12_);
			}
		}
	}
	result = (GeeList*) l;
	return result;
}


GeeList*
gxml_serializable_value_list_get_values (GXmlSerializableValueList* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_VALUE_LIST_GET_CLASS (self)->get_values (self);
}


/**
   * Add a list of string values to select from.
   * 
   * This values are added to the ones already defined at construct time.s
   */
static void
gxml_serializable_value_list_real_add_values (GXmlSerializableValueList* self, 
                                              gchar** vals, 
                                              int vals_length1)
{
	GeeArrayList* _tmp0_;
	_tmp0_ = self->extra;
	if (_tmp0_ == NULL) {
		GeeArrayList* _tmp1_;
		_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		_g_object_unref0 (self->extra);
		self->extra = _tmp1_;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_;
				GeeArrayList* _tmp5_;
				gint _tmp6_;
				const gchar* _tmp7_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				if (!(_tmp4_ < vals_length1)) {
					break;
				}
				_tmp5_ = self->extra;
				_tmp6_ = i;
				_tmp7_ = vals[_tmp6_];
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp7_);
			}
		}
	}
}


void
gxml_serializable_value_list_add_values (GXmlSerializableValueList* self, 
                                         gchar** vals, 
                                         int vals_length1)
{
	g_return_if_fail (self != NULL);
	GXML_SERIALIZABLE_VALUE_LIST_GET_CLASS (self)->add_values (self, vals, vals_length1);
}


/**
   * Get the string value at a given index. This operation does not change
   * the actual value.
   */
static gchar*
gxml_serializable_value_list_real_get_value_at (GXmlSerializableValueList* self, 
                                                gint index)
{
	gchar* result = NULL;
	GeeList* v = NULL;
	GeeList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GeeList* _tmp9_;
	gpointer _tmp10_;
	_tmp0_ = gxml_serializable_value_list_get_values (self);
	v = _tmp0_;
	if (index < 0) {
		_tmp2_ = TRUE;
	} else {
		GeeList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = v;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp2_ = index > _tmp5_;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		GeeList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = v;
		_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp1_ = !(index < _tmp8_);
	}
	if (_tmp1_) {
		result = NULL;
		_g_object_unref0 (v);
		return result;
	}
	_tmp9_ = v;
	_tmp10_ = gee_list_get (_tmp9_, index);
	result = (gchar*) _tmp10_;
	_g_object_unref0 (v);
	return result;
}


gchar*
gxml_serializable_value_list_get_value_at (GXmlSerializableValueList* self, 
                                           gint index)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_VALUE_LIST_GET_CLASS (self)->get_value_at (self, index);
}


/**
   * Sets actual value to the one at a given position.
   */
static void
gxml_serializable_value_list_real_select_value_at (GXmlSerializableValueList* self, 
                                                   gint index)
{
	gchar* _tmp0_;
	_tmp0_ = gxml_serializable_value_list_get_value_at (self, index);
	_g_free0 (self->priv->_val);
	self->priv->_val = _tmp0_;
}


void
gxml_serializable_value_list_select_value_at (GXmlSerializableValueList* self, 
                                              gint index)
{
	g_return_if_fail (self != NULL);
	GXML_SERIALIZABLE_VALUE_LIST_GET_CLASS (self)->select_value_at (self, index);
}


/**
   * Get an array of string values in list.
   *
   * If no values were defined at construction time and
   * no values were added this return null
   */
static gchar**
gxml_serializable_value_list_real_get_values_array (GXmlSerializableValueList* self, 
                                                    int* result_length1)
{
	gchar** result = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	gint _tmp2_;
	gpointer* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	_tmp0_ = gxml_serializable_value_list_get_values (self);
	_tmp1_ = _tmp0_;
	_tmp3_ = gee_collection_to_array ((GeeCollection*) _tmp1_, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	_g_object_unref0 (_tmp1_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	return result;
}


gchar**
gxml_serializable_value_list_get_values_array (GXmlSerializableValueList* self, 
                                               int* result_length1)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_VALUE_LIST_GET_CLASS (self)->get_values_array (self, result_length1);
}


/**
   * Checks if the actual value is in the values list.
   */
static gboolean
gxml_serializable_value_list_real_is_value (GXmlSerializableValueList* self)
{
	gboolean result = FALSE;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	_tmp0_ = gxml_serializable_value_list_get_values (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_val;
	_tmp3_ = gee_collection_contains ((GeeCollection*) _tmp1_, _tmp2_);
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}


gboolean
gxml_serializable_value_list_is_value (GXmlSerializableValueList* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_VALUE_LIST_GET_CLASS (self)->is_value (self);
}


static gchar*
gxml_serializable_value_list_real_get_serializable_property_value (GXmlSerializableProperty* base)
{
	GXmlSerializableValueList * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (GXmlSerializableValueList*) base;
	_tmp0_ = self->priv->_val;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void
gxml_serializable_value_list_real_set_serializable_property_value (GXmlSerializableProperty* base, 
                                                                   const gchar* val)
{
	GXmlSerializableValueList * self;
	gchar* _tmp0_;
	self = (GXmlSerializableValueList*) base;
	_tmp0_ = g_strdup (val);
	_g_free0 (self->priv->_val);
	self->priv->_val = _tmp0_;
}


gchar*
gxml_serializable_value_list_to_string (GXmlSerializableValueList* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_val;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


GXmlSerializableValueList*
gxml_serializable_value_list_construct (GType object_type)
{
	GXmlSerializableValueList * self = NULL;
	self = (GXmlSerializableValueList*) g_object_new (object_type, NULL);
	return self;
}


GXmlSerializableValueList*
gxml_serializable_value_list_new (void)
{
	return gxml_serializable_value_list_construct (GXML_TYPE_SERIALIZABLE_VALUE_LIST);
}


static GObject *
gxml_serializable_value_list_constructor (GType type, 
                                          guint n_construct_properties, 
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GXmlSerializableValueList * self;
	parent_class = G_OBJECT_CLASS (gxml_serializable_value_list_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GXML_TYPE_SERIALIZABLE_VALUE_LIST, GXmlSerializableValueList);
	gxml_init_init ();
	return obj;
}


static void
gxml_serializable_value_list_class_init (GXmlSerializableValueListClass * klass)
{
	gxml_serializable_value_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GXmlSerializableValueListPrivate));
	((GXmlSerializableValueListClass *) klass)->get_values = (GeeList* (*) (GXmlSerializableValueList *)) gxml_serializable_value_list_real_get_values;
	((GXmlSerializableValueListClass *) klass)->add_values = (void (*) (GXmlSerializableValueList *, gchar**, int)) gxml_serializable_value_list_real_add_values;
	((GXmlSerializableValueListClass *) klass)->get_value_at = (gchar* (*) (GXmlSerializableValueList *, gint)) gxml_serializable_value_list_real_get_value_at;
	((GXmlSerializableValueListClass *) klass)->select_value_at = (void (*) (GXmlSerializableValueList *, gint)) gxml_serializable_value_list_real_select_value_at;
	((GXmlSerializableValueListClass *) klass)->get_values_array = (gchar** (*) (GXmlSerializableValueList *, int*)) gxml_serializable_value_list_real_get_values_array;
	((GXmlSerializableValueListClass *) klass)->is_value = (gboolean (*) (GXmlSerializableValueList *)) gxml_serializable_value_list_real_is_value;
	G_OBJECT_CLASS (klass)->constructor = gxml_serializable_value_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = gxml_serializable_value_list_finalize;
}


static void
gxml_serializable_value_list_gxml_serializable_property_interface_init (GXmlSerializablePropertyIface * iface)
{
	gxml_serializable_value_list_gxml_serializable_property_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_serializable_property_value = (gchar* (*) (GXmlSerializableProperty *)) gxml_serializable_value_list_real_get_serializable_property_value;
	iface->set_serializable_property_value = (void (*) (GXmlSerializableProperty *, const gchar*)) gxml_serializable_value_list_real_set_serializable_property_value;
}


static void
gxml_serializable_value_list_instance_init (GXmlSerializableValueList * self)
{
	self->priv = GXML_SERIALIZABLE_VALUE_LIST_GET_PRIVATE (self);
	self->priv->_val = NULL;
	self->_vals = NULL;
	self->_vals_length1 = 0;
	self->extra = NULL;
}


static void
gxml_serializable_value_list_finalize (GObject * obj)
{
	GXmlSerializableValueList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GXML_TYPE_SERIALIZABLE_VALUE_LIST, GXmlSerializableValueList);
	_g_free0 (self->priv->_val);
	self->_vals = (_vala_array_free (self->_vals, self->_vals_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->extra);
	G_OBJECT_CLASS (gxml_serializable_value_list_parent_class)->finalize (obj);
}


/**
 * Represent any value as string but a list of options by default to select from.
 * property to be added as a {@link GXml.Attribute} to a {@link GXml.Element}.
 *
 * All values are stored in an array to get access to it by its position using
 * {@link SerializableValueList.get_value_at}.
 *
 * Is recommended to initilize your list from a fixed array to avoid to have a list
 * for each object in memory, do it by initialize the internal variable
 * {@link GXml.SerializableValueList._vals}, at construct {} clause to point a fixed
 * array of strings.
 */
GType
gxml_serializable_value_list_get_type (void)
{
	static volatile gsize gxml_serializable_value_list_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_serializable_value_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlSerializableValueListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gxml_serializable_value_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GXmlSerializableValueList), 0, (GInstanceInitFunc) gxml_serializable_value_list_instance_init, NULL };
		static const GInterfaceInfo gxml_serializable_property_info = { (GInterfaceInitFunc) gxml_serializable_value_list_gxml_serializable_property_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gxml_serializable_value_list_type_id;
		gxml_serializable_value_list_type_id = g_type_register_static (G_TYPE_OBJECT, "GXmlSerializableValueList", &g_define_type_info, 0);
		g_type_add_interface_static (gxml_serializable_value_list_type_id, GXML_TYPE_SERIALIZABLE_PROPERTY, &gxml_serializable_property_info);
		g_once_init_leave (&gxml_serializable_value_list_type_id__volatile, gxml_serializable_value_list_type_id);
	}
	return gxml_serializable_value_list_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array, 
                     gint array_length, 
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array, 
                  gint array_length, 
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



