/* DomElement.c generated by valac 0.44.3, the Vala compiler
 * generated from DomElement.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */
/*
 *
 * Copyright (C) 2016  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <gio/gio.h>

#define GXML_TYPE_DOM_ELEMENT (gxml_dom_element_get_type ())
#define GXML_DOM_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_ELEMENT, GXmlDomElement))
#define GXML_IS_DOM_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_ELEMENT))
#define GXML_DOM_ELEMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOM_ELEMENT, GXmlDomElementIface))

typedef struct _GXmlDomElement GXmlDomElement;
typedef struct _GXmlDomElementIface GXmlDomElementIface;

#define GXML_TYPE_DOM_NODE (gxml_dom_node_get_type ())
#define GXML_DOM_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_NODE, GXmlDomNode))
#define GXML_IS_DOM_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_NODE))
#define GXML_DOM_NODE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOM_NODE, GXmlDomNodeIface))

typedef struct _GXmlDomNode GXmlDomNode;
typedef struct _GXmlDomNodeIface GXmlDomNodeIface;

#define GXML_TYPE_DOM_EVENT_TARGET (gxml_dom_event_target_get_type ())
#define GXML_DOM_EVENT_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_EVENT_TARGET, GXmlDomEventTarget))
#define GXML_IS_DOM_EVENT_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_EVENT_TARGET))
#define GXML_DOM_EVENT_TARGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOM_EVENT_TARGET, GXmlDomEventTargetIface))

typedef struct _GXmlDomEventTarget GXmlDomEventTarget;
typedef struct _GXmlDomEventTargetIface GXmlDomEventTargetIface;

#define GXML_TYPE_DOM_EVENT_LISTENER (gxml_dom_event_listener_get_type ())
#define GXML_DOM_EVENT_LISTENER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_EVENT_LISTENER, GXmlDomEventListener))
#define GXML_IS_DOM_EVENT_LISTENER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_EVENT_LISTENER))
#define GXML_DOM_EVENT_LISTENER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOM_EVENT_LISTENER, GXmlDomEventListenerIface))

typedef struct _GXmlDomEventListener GXmlDomEventListener;
typedef struct _GXmlDomEventListenerIface GXmlDomEventListenerIface;

#define GXML_TYPE_DOM_EVENT (gxml_dom_event_get_type ())
#define GXML_DOM_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_EVENT, GXmlDomEvent))
#define GXML_IS_DOM_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_EVENT))
#define GXML_DOM_EVENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOM_EVENT, GXmlDomEventIface))

typedef struct _GXmlDomEvent GXmlDomEvent;
typedef struct _GXmlDomEventIface GXmlDomEventIface;

#define GXML_TYPE_DOM_TIME_STAMP (gxml_dom_time_stamp_get_type ())
#define GXML_DOM_TIME_STAMP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_TIME_STAMP, GXmlDomTimeStamp))
#define GXML_DOM_TIME_STAMP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_DOM_TIME_STAMP, GXmlDomTimeStampClass))
#define GXML_IS_DOM_TIME_STAMP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_TIME_STAMP))
#define GXML_IS_DOM_TIME_STAMP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_DOM_TIME_STAMP))
#define GXML_DOM_TIME_STAMP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_DOM_TIME_STAMP, GXmlDomTimeStampClass))

typedef struct _GXmlDomTimeStamp GXmlDomTimeStamp;
typedef struct _GXmlDomTimeStampClass GXmlDomTimeStampClass;
typedef enum  {
	GXML_DOM_EVENT_PHASE_NONE = 0,
	GXML_DOM_EVENT_PHASE_CAPTURING_PHASE,
	GXML_DOM_EVENT_PHASE_AT_TARGET,
	GXML_DOM_EVENT_PHASE_BUBBLING_PHASE
} GXmlDomEventPhase;

#define GXML_DOM_EVENT_TYPE_PHASE (gxml_dom_event_phase_get_type ())
typedef enum  {
	GXML_DOM_NODE_DOCUMENT_POSITION_NONE = 1 << 0,
	GXML_DOM_NODE_DOCUMENT_POSITION_DISCONNECTED = 1 << 1,
	GXML_DOM_NODE_DOCUMENT_POSITION_PRECEDING = 1 << 2,
	GXML_DOM_NODE_DOCUMENT_POSITION_FOLLOWING = 1 << 3,
	GXML_DOM_NODE_DOCUMENT_POSITION_CONTAINS = 1 << 4,
	GXML_DOM_NODE_DOCUMENT_POSITION_CONTAINED_BY = 1 << 5,
	GXML_DOM_NODE_DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = 1 << 6
} GXmlDomNodeDocumentPosition;

#define GXML_DOM_NODE_TYPE_DOCUMENT_POSITION (gxml_dom_node_document_position_get_type ())
typedef enum  {
	GXML_DOM_NODE_NODE_TYPE_INVALID = 0,
	GXML_DOM_NODE_NODE_TYPE_ELEMENT_NODE = 1,
	GXML_DOM_NODE_NODE_TYPE_ATTRIBUTE_NODE,
	GXML_DOM_NODE_NODE_TYPE_TEXT_NODE,
	GXML_DOM_NODE_NODE_TYPE_CDATA_SECTION_NODE,
	GXML_DOM_NODE_NODE_TYPE_ENTITY_REFERENCE_NODE,
	GXML_DOM_NODE_NODE_TYPE_ENTITY_NODE,
	GXML_DOM_NODE_NODE_TYPE_PROCESSING_INSTRUCTION_NODE,
	GXML_DOM_NODE_NODE_TYPE_COMMENT_NODE,
	GXML_DOM_NODE_NODE_TYPE_DOCUMENT_NODE,
	GXML_DOM_NODE_NODE_TYPE_DOCUMENT_TYPE_NODE,
	GXML_DOM_NODE_NODE_TYPE_DOCUMENT_FRAGMENT_NODE,
	GXML_DOM_NODE_NODE_TYPE_NOTATION_NODE
} GXmlDomNodeNodeType;

#define GXML_DOM_NODE_TYPE_NODE_TYPE (gxml_dom_node_node_type_get_type ())

#define GXML_TYPE_DOM_DOCUMENT (gxml_dom_document_get_type ())
#define GXML_DOM_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_DOCUMENT, GXmlDomDocument))
#define GXML_IS_DOM_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_DOCUMENT))
#define GXML_DOM_DOCUMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOM_DOCUMENT, GXmlDomDocumentIface))

typedef struct _GXmlDomDocument GXmlDomDocument;
typedef struct _GXmlDomDocumentIface GXmlDomDocumentIface;

#define GXML_TYPE_DOM_PARENT_NODE (gxml_dom_parent_node_get_type ())
#define GXML_DOM_PARENT_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_PARENT_NODE, GXmlDomParentNode))
#define GXML_IS_DOM_PARENT_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_PARENT_NODE))
#define GXML_DOM_PARENT_NODE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOM_PARENT_NODE, GXmlDomParentNodeIface))

typedef struct _GXmlDomParentNode GXmlDomParentNode;
typedef struct _GXmlDomParentNodeIface GXmlDomParentNodeIface;

#define GXML_TYPE_DOM_NODE_LIST (gxml_dom_node_list_get_type ())
#define GXML_DOM_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_NODE_LIST, GXmlDomNodeList))
#define GXML_IS_DOM_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_NODE_LIST))
#define GXML_DOM_NODE_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOM_NODE_LIST, GXmlDomNodeListIface))

typedef struct _GXmlDomNodeList GXmlDomNodeList;
typedef struct _GXmlDomNodeListIface GXmlDomNodeListIface;

#define GXML_TYPE_DOM_ELEMENT_LIST (gxml_dom_element_list_get_type ())
#define GXML_DOM_ELEMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_ELEMENT_LIST, GXmlDomElementList))
#define GXML_DOM_ELEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_DOM_ELEMENT_LIST, GXmlDomElementListClass))
#define GXML_IS_DOM_ELEMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_ELEMENT_LIST))
#define GXML_IS_DOM_ELEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_DOM_ELEMENT_LIST))
#define GXML_DOM_ELEMENT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_DOM_ELEMENT_LIST, GXmlDomElementListClass))

typedef struct _GXmlDomElementList GXmlDomElementList;
typedef struct _GXmlDomElementListClass GXmlDomElementListClass;

#define GXML_TYPE_DOM_HTML_COLLECTION (gxml_dom_html_collection_get_type ())
#define GXML_DOM_HTML_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_HTML_COLLECTION, GXmlDomHTMLCollection))
#define GXML_IS_DOM_HTML_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_HTML_COLLECTION))
#define GXML_DOM_HTML_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOM_HTML_COLLECTION, GXmlDomHTMLCollectionIface))

typedef struct _GXmlDomHTMLCollection GXmlDomHTMLCollection;
typedef struct _GXmlDomHTMLCollectionIface GXmlDomHTMLCollectionIface;

#define GXML_TYPE_DOM_NON_ELEMENT_PARENT_NODE (gxml_dom_non_element_parent_node_get_type ())
#define GXML_DOM_NON_ELEMENT_PARENT_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_NON_ELEMENT_PARENT_NODE, GXmlDomNonElementParentNode))
#define GXML_IS_DOM_NON_ELEMENT_PARENT_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_NON_ELEMENT_PARENT_NODE))
#define GXML_DOM_NON_ELEMENT_PARENT_NODE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOM_NON_ELEMENT_PARENT_NODE, GXmlDomNonElementParentNodeIface))

typedef struct _GXmlDomNonElementParentNode GXmlDomNonElementParentNode;
typedef struct _GXmlDomNonElementParentNodeIface GXmlDomNonElementParentNodeIface;

#define GXML_TYPE_DOM_DOCUMENT_FRAGMENT (gxml_dom_document_fragment_get_type ())
#define GXML_DOM_DOCUMENT_FRAGMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_DOCUMENT_FRAGMENT, GXmlDomDocumentFragment))
#define GXML_IS_DOM_DOCUMENT_FRAGMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_DOCUMENT_FRAGMENT))
#define GXML_DOM_DOCUMENT_FRAGMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOM_DOCUMENT_FRAGMENT, GXmlDomDocumentFragmentIface))

typedef struct _GXmlDomDocumentFragment GXmlDomDocumentFragment;
typedef struct _GXmlDomDocumentFragmentIface GXmlDomDocumentFragmentIface;

#define GXML_TYPE_DOM_TEXT (gxml_dom_text_get_type ())
#define GXML_DOM_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_TEXT, GXmlDomText))
#define GXML_IS_DOM_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_TEXT))
#define GXML_DOM_TEXT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOM_TEXT, GXmlDomTextIface))

typedef struct _GXmlDomText GXmlDomText;
typedef struct _GXmlDomTextIface GXmlDomTextIface;

#define GXML_TYPE_DOM_CHARACTER_DATA (gxml_dom_character_data_get_type ())
#define GXML_DOM_CHARACTER_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_CHARACTER_DATA, GXmlDomCharacterData))
#define GXML_IS_DOM_CHARACTER_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_CHARACTER_DATA))
#define GXML_DOM_CHARACTER_DATA_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOM_CHARACTER_DATA, GXmlDomCharacterDataIface))

typedef struct _GXmlDomCharacterData GXmlDomCharacterData;
typedef struct _GXmlDomCharacterDataIface GXmlDomCharacterDataIface;

#define GXML_TYPE_DOM_NON_DOCUMENT_TYPE_CHILD_NODE (gxml_dom_non_document_type_child_node_get_type ())
#define GXML_DOM_NON_DOCUMENT_TYPE_CHILD_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_NON_DOCUMENT_TYPE_CHILD_NODE, GXmlDomNonDocumentTypeChildNode))
#define GXML_IS_DOM_NON_DOCUMENT_TYPE_CHILD_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_NON_DOCUMENT_TYPE_CHILD_NODE))
#define GXML_DOM_NON_DOCUMENT_TYPE_CHILD_NODE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOM_NON_DOCUMENT_TYPE_CHILD_NODE, GXmlDomNonDocumentTypeChildNodeIface))

typedef struct _GXmlDomNonDocumentTypeChildNode GXmlDomNonDocumentTypeChildNode;
typedef struct _GXmlDomNonDocumentTypeChildNodeIface GXmlDomNonDocumentTypeChildNodeIface;

#define GXML_TYPE_DOM_CHILD_NODE (gxml_dom_child_node_get_type ())
#define GXML_DOM_CHILD_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_CHILD_NODE, GXmlDomChildNode))
#define GXML_IS_DOM_CHILD_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_CHILD_NODE))
#define GXML_DOM_CHILD_NODE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOM_CHILD_NODE, GXmlDomChildNodeIface))

typedef struct _GXmlDomChildNode GXmlDomChildNode;
typedef struct _GXmlDomChildNodeIface GXmlDomChildNodeIface;

#define GXML_TYPE_DOM_COMMENT (gxml_dom_comment_get_type ())
#define GXML_DOM_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_COMMENT, GXmlDomComment))
#define GXML_IS_DOM_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_COMMENT))
#define GXML_DOM_COMMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOM_COMMENT, GXmlDomCommentIface))

typedef struct _GXmlDomComment GXmlDomComment;
typedef struct _GXmlDomCommentIface GXmlDomCommentIface;

#define GXML_TYPE_DOM_PROCESSING_INSTRUCTION (gxml_dom_processing_instruction_get_type ())
#define GXML_DOM_PROCESSING_INSTRUCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_PROCESSING_INSTRUCTION, GXmlDomProcessingInstruction))
#define GXML_IS_DOM_PROCESSING_INSTRUCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_PROCESSING_INSTRUCTION))
#define GXML_DOM_PROCESSING_INSTRUCTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOM_PROCESSING_INSTRUCTION, GXmlDomProcessingInstructionIface))

typedef struct _GXmlDomProcessingInstruction GXmlDomProcessingInstruction;
typedef struct _GXmlDomProcessingInstructionIface GXmlDomProcessingInstructionIface;

#define GXML_TYPE_DOM_RANGE (gxml_dom_range_get_type ())
#define GXML_DOM_RANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_RANGE, GXmlDomRange))
#define GXML_IS_DOM_RANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_RANGE))
#define GXML_DOM_RANGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOM_RANGE, GXmlDomRangeIface))

typedef struct _GXmlDomRange GXmlDomRange;
typedef struct _GXmlDomRangeIface GXmlDomRangeIface;
typedef enum  {
	GXML_DOM_RANGE_BOUNDARY_POINTS_START_TO_START = 0,
	GXML_DOM_RANGE_BOUNDARY_POINTS_START_TO_END,
	GXML_DOM_RANGE_BOUNDARY_POINTS_END_TO_END,
	GXML_DOM_RANGE_BOUNDARY_POINTS_END_TO_START
} GXmlDomRangeBoundaryPoints;

#define GXML_DOM_RANGE_TYPE_BOUNDARY_POINTS (gxml_dom_range_boundary_points_get_type ())

#define GXML_TYPE_DOM_NODE_FILTER (gxml_dom_node_filter_get_type ())
#define GXML_DOM_NODE_FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_NODE_FILTER, GXmlDomNodeFilter))
#define GXML_DOM_NODE_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_DOM_NODE_FILTER, GXmlDomNodeFilterClass))
#define GXML_IS_DOM_NODE_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_NODE_FILTER))
#define GXML_IS_DOM_NODE_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_DOM_NODE_FILTER))
#define GXML_DOM_NODE_FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_DOM_NODE_FILTER, GXmlDomNodeFilterClass))

typedef struct _GXmlDomNodeFilter GXmlDomNodeFilter;
typedef struct _GXmlDomNodeFilterClass GXmlDomNodeFilterClass;

#define GXML_TYPE_DOM_NODE_ITERATOR (gxml_dom_node_iterator_get_type ())
#define GXML_DOM_NODE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_NODE_ITERATOR, GXmlDomNodeIterator))
#define GXML_IS_DOM_NODE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_NODE_ITERATOR))
#define GXML_DOM_NODE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOM_NODE_ITERATOR, GXmlDomNodeIteratorIface))

typedef struct _GXmlDomNodeIterator GXmlDomNodeIterator;
typedef struct _GXmlDomNodeIteratorIface GXmlDomNodeIteratorIface;

#define GXML_TYPE_DOM_TREE_WALKER (gxml_dom_tree_walker_get_type ())
#define GXML_DOM_TREE_WALKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_TREE_WALKER, GXmlDomTreeWalker))
#define GXML_IS_DOM_TREE_WALKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_TREE_WALKER))
#define GXML_DOM_TREE_WALKER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOM_TREE_WALKER, GXmlDomTreeWalkerIface))

typedef struct _GXmlDomTreeWalker GXmlDomTreeWalker;
typedef struct _GXmlDomTreeWalkerIface GXmlDomTreeWalkerIface;

#define GXML_TYPE_PARSER (gxml_parser_get_type ())
#define GXML_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_PARSER, GXmlParser))
#define GXML_IS_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_PARSER))
#define GXML_PARSER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_PARSER, GXmlParserIface))

typedef struct _GXmlParser GXmlParser;
typedef struct _GXmlParserIface GXmlParserIface;

#define GXML_TYPE_DOM_IMPLEMENTATION (gxml_dom_implementation_get_type ())
#define GXML_DOM_IMPLEMENTATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_IMPLEMENTATION, GXmlDomImplementation))
#define GXML_IS_DOM_IMPLEMENTATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_IMPLEMENTATION))
#define GXML_DOM_IMPLEMENTATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOM_IMPLEMENTATION, GXmlDomImplementationIface))

typedef struct _GXmlDomImplementation GXmlDomImplementation;
typedef struct _GXmlDomImplementationIface GXmlDomImplementationIface;

#define GXML_TYPE_DOM_DOCUMENT_TYPE (gxml_dom_document_type_get_type ())
#define GXML_DOM_DOCUMENT_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_DOCUMENT_TYPE, GXmlDomDocumentType))
#define GXML_IS_DOM_DOCUMENT_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_DOCUMENT_TYPE))
#define GXML_DOM_DOCUMENT_TYPE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOM_DOCUMENT_TYPE, GXmlDomDocumentTypeIface))

typedef struct _GXmlDomDocumentType GXmlDomDocumentType;
typedef struct _GXmlDomDocumentTypeIface GXmlDomDocumentTypeIface;

#define GXML_TYPE_DOM_XML_DOCUMENT (gxml_dom_xml_document_get_type ())
#define GXML_DOM_XML_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_XML_DOCUMENT, GXmlDomXMLDocument))
#define GXML_IS_DOM_XML_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_XML_DOCUMENT))
#define GXML_DOM_XML_DOCUMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOM_XML_DOCUMENT, GXmlDomXMLDocumentIface))

typedef struct _GXmlDomXMLDocument GXmlDomXMLDocument;
typedef struct _GXmlDomXMLDocumentIface GXmlDomXMLDocumentIface;

#define GXML_TYPE_DOCUMENT (gxml_document_get_type ())
#define GXML_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOCUMENT, GXmlDocument))
#define GXML_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOCUMENT))
#define GXML_DOCUMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOCUMENT, GXmlDocumentIface))

typedef struct _GXmlDocument GXmlDocument;
typedef struct _GXmlDocumentIface GXmlDocumentIface;

#define GXML_TYPE_NODE (gxml_node_get_type ())
#define GXML_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NODE, GXmlNode))
#define GXML_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NODE))
#define GXML_NODE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NODE, GXmlNodeIface))

typedef struct _GXmlNode GXmlNode;
typedef struct _GXmlNodeIface GXmlNodeIface;

#define GXML_TYPE_ELEMENT_LIST (gxml_element_list_get_type ())
#define GXML_ELEMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ELEMENT_LIST, GXmlElementList))
#define GXML_ELEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_ELEMENT_LIST, GXmlElementListClass))
#define GXML_IS_ELEMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ELEMENT_LIST))
#define GXML_IS_ELEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_ELEMENT_LIST))
#define GXML_ELEMENT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_ELEMENT_LIST, GXmlElementListClass))

typedef struct _GXmlElementList GXmlElementList;
typedef struct _GXmlElementListClass GXmlElementListClass;

#define GXML_TYPE_NAMESPACE (gxml_namespace_get_type ())
#define GXML_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NAMESPACE, GXmlNamespace))
#define GXML_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NAMESPACE))
#define GXML_NAMESPACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NAMESPACE, GXmlNamespaceIface))

typedef struct _GXmlNamespace GXmlNamespace;
typedef struct _GXmlNamespaceIface GXmlNamespaceIface;
typedef enum  {
	GXML_NODE_TYPE_INVALID = 0,
	GXML_NODE_TYPE_ELEMENT = 1,
	GXML_NODE_TYPE_ATTRIBUTE,
	GXML_NODE_TYPE_TEXT,
	GXML_NODE_TYPE_CDATA_SECTION,
	GXML_NODE_TYPE_ENTITY_REFERENCE,
	GXML_NODE_TYPE_ENTITY,
	GXML_NODE_TYPE_PROCESSING_INSTRUCTION,
	GXML_NODE_TYPE_COMMENT,
	GXML_NODE_TYPE_DOCUMENT,
	GXML_NODE_TYPE_DOCUMENT_TYPE,
	GXML_NODE_TYPE_DOCUMENT_FRAGMENT,
	GXML_NODE_TYPE_NOTATION
} GXmlNodeType;

#define GXML_TYPE_NODE_TYPE (gxml_node_type_get_type ())

#define GXML_TYPE_DOM_TOKEN_LIST (gxml_dom_token_list_get_type ())
#define GXML_DOM_TOKEN_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_TOKEN_LIST, GXmlDomTokenList))
#define GXML_IS_DOM_TOKEN_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_TOKEN_LIST))
#define GXML_DOM_TOKEN_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOM_TOKEN_LIST, GXmlDomTokenListIface))

typedef struct _GXmlDomTokenList GXmlDomTokenList;
typedef struct _GXmlDomTokenListIface GXmlDomTokenListIface;

#define GXML_TYPE_DOM_NAMED_NODE_MAP (gxml_dom_named_node_map_get_type ())
#define GXML_DOM_NAMED_NODE_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_NAMED_NODE_MAP, GXmlDomNamedNodeMap))
#define GXML_IS_DOM_NAMED_NODE_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_NAMED_NODE_MAP))
#define GXML_DOM_NAMED_NODE_MAP_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOM_NAMED_NODE_MAP, GXmlDomNamedNodeMapIface))

typedef struct _GXmlDomNamedNodeMap GXmlDomNamedNodeMap;
typedef struct _GXmlDomNamedNodeMapIface GXmlDomNamedNodeMapIface;

#define GXML_TYPE_CSS_SELECTOR_PARSER (gxml_css_selector_parser_get_type ())
#define GXML_CSS_SELECTOR_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_CSS_SELECTOR_PARSER, GXmlCssSelectorParser))
#define GXML_CSS_SELECTOR_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_CSS_SELECTOR_PARSER, GXmlCssSelectorParserClass))
#define GXML_IS_CSS_SELECTOR_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_CSS_SELECTOR_PARSER))
#define GXML_IS_CSS_SELECTOR_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_CSS_SELECTOR_PARSER))
#define GXML_CSS_SELECTOR_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_CSS_SELECTOR_PARSER, GXmlCssSelectorParserClass))

typedef struct _GXmlCssSelectorParser GXmlCssSelectorParser;
typedef struct _GXmlCssSelectorParserClass GXmlCssSelectorParserClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GxmlDomElementReadFromUriAsyncData GxmlDomElementReadFromUriAsyncData;
typedef struct _GxmlDomElementReadFromFileAsyncData GxmlDomElementReadFromFileAsyncData;
typedef struct _GxmlDomElementReadFromStreamAsyncData GxmlDomElementReadFromStreamAsyncData;
typedef struct _GxmlDomElementReadFromStringAsyncData GxmlDomElementReadFromStringAsyncData;
typedef struct _GxmlDomElementWriteStringAsyncData GxmlDomElementWriteStringAsyncData;
typedef struct _GxmlDomElementWriteFileAsyncData GxmlDomElementWriteFileAsyncData;
typedef struct _GxmlDomElementWriteStreamAsyncData GxmlDomElementWriteStreamAsyncData;
typedef struct _GxmlDomElementCreateStreamAsyncData GxmlDomElementCreateStreamAsyncData;
typedef struct _GXmlDomElementListPrivate GXmlDomElementListPrivate;
enum  {
	GXML_DOM_ELEMENT_LIST_0_PROPERTY,
	GXML_DOM_ELEMENT_LIST_NUM_PROPERTIES
};
static GParamSpec* gxml_dom_element_list_properties[GXML_DOM_ELEMENT_LIST_NUM_PROPERTIES];

struct _GXmlDomEventIface {
	GTypeInterface parent_iface;
	void (*stop_propagation) (GXmlDomEvent* self);
	void (*stop_immediate_propagation) (GXmlDomEvent* self);
	void (*prevent_default) (GXmlDomEvent* self);
	void (*init_event) (GXmlDomEvent* self, const gchar* type, gboolean bubbles, gboolean cancelable);
	const gchar* (*get_etype) (GXmlDomEvent* self);
	GXmlDomEventTarget* (*get_event_target) (GXmlDomEvent* self);
	GXmlDomEventTarget* (*get_current_target) (GXmlDomEvent* self);
	gboolean (*get_bubbles) (GXmlDomEvent* self);
	gboolean (*get_cancelable) (GXmlDomEvent* self);
	gboolean (*get_is_trusted) (GXmlDomEvent* self);
	GXmlDomTimeStamp* (*get_time_stamp) (GXmlDomEvent* self);
	gboolean (*get_default_prevented) (GXmlDomEvent* self);
	GXmlDomEventPhase (*get_event_phase) (GXmlDomEvent* self);
};

struct _GXmlDomEventListenerIface {
	GTypeInterface parent_iface;
	void (*handle_event) (GXmlDomEventListener* self, GXmlDomEvent* event);
};

struct _GXmlDomEventTargetIface {
	GTypeInterface parent_iface;
	void (*add_event_listener) (GXmlDomEventTarget* self, const gchar* type, GXmlDomEventListener* callback, gboolean capture);
	void (*remove_event_listener) (GXmlDomEventTarget* self, const gchar* type, GXmlDomEventListener* callback, gboolean capture);
	gboolean (*dispatch_event) (GXmlDomEventTarget* self, GXmlDomEvent* event, GError** error);
};

struct _GXmlDomNodeListIface {
	GTypeInterface parent_iface;
	GXmlDomNode* (*item) (GXmlDomNodeList* self, gint index);
	gint (*get_length) (GXmlDomNodeList* self);
};

struct _GXmlDomHTMLCollectionIface {
	GTypeInterface parent_iface;
	GXmlDomElement* (*get_element) (GXmlDomHTMLCollection* self, gint index);
	GXmlDomElement** (*to_array) (GXmlDomHTMLCollection* self, gint* result_length1);
	GXmlDomElement* (*item) (GXmlDomHTMLCollection* self, gint index);
	GXmlDomElement* (*named_item) (GXmlDomHTMLCollection* self, const gchar* name);
	gint (*get_length) (GXmlDomHTMLCollection* self);
};

struct _GXmlDomParentNodeIface {
	GTypeInterface parent_iface;
	GXmlDomElement* (*query_selector) (GXmlDomParentNode* self, const gchar* selectors, GError** error);
	GXmlDomNodeList* (*query_selector_all) (GXmlDomParentNode* self, const gchar* selectors, GError** error);
	GXmlDomElementList* (*get_elements_by_property_value) (GXmlDomParentNode* self, const gchar* property, const gchar* value);
	GXmlDomHTMLCollection* (*get_children) (GXmlDomParentNode* self);
	GXmlDomElement* (*get_first_element_child) (GXmlDomParentNode* self);
	GXmlDomElement* (*get_last_element_child) (GXmlDomParentNode* self);
	gint (*get_child_element_count) (GXmlDomParentNode* self);
};

struct _GXmlDomNonElementParentNodeIface {
	GTypeInterface parent_iface;
	GXmlDomElement* (*get_element_by_id) (GXmlDomNonElementParentNode* self, const gchar* element_id, GError** error);
};

struct _GXmlDomDocumentFragmentIface {
	GTypeInterface parent_iface;
};

struct _GXmlDomNonDocumentTypeChildNodeIface {
	GTypeInterface parent_iface;
	GXmlDomElement* (*get_previous_element_sibling) (GXmlDomNonDocumentTypeChildNode* self);
	GXmlDomElement* (*get_next_element_sibling) (GXmlDomNonDocumentTypeChildNode* self);
};

struct _GXmlDomChildNodeIface {
	GTypeInterface parent_iface;
	void (*remove) (GXmlDomChildNode* self);
};

struct _GXmlDomCharacterDataIface {
	GTypeInterface parent_iface;
	gchar* (*substring_data) (GXmlDomCharacterData* self, gint offset, gint count, GError** error);
	void (*append_data) (GXmlDomCharacterData* self, const gchar* data);
	void (*insert_data) (GXmlDomCharacterData* self, gint offset, const gchar* data, GError** error);
	void (*delete_data) (GXmlDomCharacterData* self, gint offset, gint count, GError** error);
	void (*replace_data) (GXmlDomCharacterData* self, gint offset, gint count, const gchar* data, GError** error);
	gchar* (*get_data) (GXmlDomCharacterData* self);
	void (*set_data) (GXmlDomCharacterData* self, const gchar* value);
	gint (*get_length) (GXmlDomCharacterData* self);
};

struct _GXmlDomTextIface {
	GTypeInterface parent_iface;
	GXmlDomText* (*split_text) (GXmlDomText* self, gint offset, GError** error);
	gchar* (*get_whole_text) (GXmlDomText* self);
};

struct _GXmlDomCommentIface {
	GTypeInterface parent_iface;
};

struct _GXmlDomProcessingInstructionIface {
	GTypeInterface parent_iface;
	gchar* (*get_target) (GXmlDomProcessingInstruction* self);
};

struct _GXmlDomRangeIface {
	GTypeInterface parent_iface;
	void (*set_start) (GXmlDomRange* self, GXmlDomNode* node, gint offset, GError** error);
	void (*set_end) (GXmlDomRange* self, GXmlDomNode* node, gint offset, GError** error);
	void (*set_start_before) (GXmlDomRange* self, GXmlDomNode* node, GError** error);
	void (*set_start_after) (GXmlDomRange* self, GXmlDomNode* node, GError** error);
	void (*set_end_before) (GXmlDomRange* self, GXmlDomNode* node, GError** error);
	void (*set_end_after) (GXmlDomRange* self, GXmlDomNode* node, GError** error);
	void (*collapse) (GXmlDomRange* self, gboolean to_start, GError** error);
	void (*select_node) (GXmlDomRange* self, GXmlDomNode* node, GError** error);
	void (*select_node_contents) (GXmlDomRange* self, GXmlDomNode* node, GError** error);
	gint (*compare_boundary_points) (GXmlDomRange* self, GXmlDomRangeBoundaryPoints how, GXmlDomRange* sourceRange, GError** error);
	void (*delete_contents) (GXmlDomRange* self, GError** error);
	GXmlDomDocumentFragment* (*extract_contents) (GXmlDomRange* self, GError** error);
	GXmlDomDocumentFragment* (*clone_contents) (GXmlDomRange* self, GError** error);
	void (*insert_node) (GXmlDomRange* self, GXmlDomNode* node);
	void (*surround_contents) (GXmlDomRange* self, GXmlDomNode* newParent);
	GXmlDomRange* (*clone_range) (GXmlDomRange* self);
	void (*detach) (GXmlDomRange* self);
	gboolean (*is_point_in_range) (GXmlDomRange* self, GXmlDomNode* node, gint offset);
	gshort (*compare_point) (GXmlDomRange* self, GXmlDomNode* node, gint offset);
	gboolean (*intersects_node) (GXmlDomRange* self, GXmlDomNode* node);
	gchar* (*to_string) (GXmlDomRange* self);
	GXmlDomNode* (*get_start_container) (GXmlDomRange* self);
	gint (*get_start_offset) (GXmlDomRange* self);
	GXmlDomNode* (*get_end_container) (GXmlDomRange* self);
	gint (*get_end_offset) (GXmlDomRange* self);
	gboolean (*get_collapsed) (GXmlDomRange* self);
	GXmlDomNode* (*get_common_ancestor_container) (GXmlDomRange* self);
};

struct _GXmlDomNodeIteratorIface {
	GTypeInterface parent_iface;
	GXmlDomNode* (*next_node) (GXmlDomNodeIterator* self);
	GXmlDomNode* (*previous_node) (GXmlDomNodeIterator* self);
	void (*detach) (GXmlDomNodeIterator* self);
	GXmlDomNode* (*get_root) (GXmlDomNodeIterator* self);
	GXmlDomNode* (*get_reference_node) (GXmlDomNodeIterator* self);
	gboolean (*get_pointer_before_reference_node) (GXmlDomNodeIterator* self);
	gint (*get_what_to_show) (GXmlDomNodeIterator* self);
	GXmlDomNodeFilter* (*get_filter) (GXmlDomNodeIterator* self);
};

struct _GXmlDomTreeWalkerIface {
	GTypeInterface parent_iface;
	GXmlDomNode* (*parent_node) (GXmlDomTreeWalker* self);
	GXmlDomNode* (*first_child) (GXmlDomTreeWalker* self);
	GXmlDomNode* (*last_child) (GXmlDomTreeWalker* self);
	GXmlDomNode* (*previous_sibling) (GXmlDomTreeWalker* self);
	GXmlDomNode* (*next_sibling) (GXmlDomTreeWalker* self);
	GXmlDomNode* (*previous_node) (GXmlDomTreeWalker* self);
	GXmlDomNode* (*next_node) (GXmlDomTreeWalker* self);
	GXmlDomNode* (*get_root) (GXmlDomTreeWalker* self);
	gint (*get_what_to_show) (GXmlDomTreeWalker* self);
	GXmlDomNodeFilter* (*get_filter) (GXmlDomTreeWalker* self);
	GXmlDomNode* (*get_current_node) (GXmlDomTreeWalker* self);
};

struct _GXmlParserIface {
	GTypeInterface parent_iface;
	void (*write_file) (GXmlParser* self, GFile* file, GError** error);
	void (*write_file_async) (GXmlParser* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*write_file_finish) (GXmlParser* self, GAsyncResult* _res_, GError** error);
	gchar* (*write_string) (GXmlParser* self, GError** error);
	void (*write_string_async) (GXmlParser* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar* (*write_string_finish) (GXmlParser* self, GAsyncResult* _res_, GError** error);
	void (*write_stream) (GXmlParser* self, GOutputStream* stream, GError** error);
	void (*write_stream_async) (GXmlParser* self, GOutputStream* stream, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*write_stream_finish) (GXmlParser* self, GAsyncResult* _res_, GError** error);
	void (*read_file) (GXmlParser* self, GFile* file, GError** error);
	void (*read_file_async) (GXmlParser* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*read_file_finish) (GXmlParser* self, GAsyncResult* _res_, GError** error);
	void (*read_stream) (GXmlParser* self, GInputStream* stream, GError** error);
	void (*read_stream_async) (GXmlParser* self, GInputStream* stream, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*read_stream_finish) (GXmlParser* self, GAsyncResult* _res_, GError** error);
	void (*read_string) (GXmlParser* self, const gchar* str, GError** error);
	void (*read_string_async) (GXmlParser* self, const gchar* str, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*read_string_finish) (GXmlParser* self, GAsyncResult* _res_, GError** error);
	GInputStream* (*create_stream) (GXmlParser* self, GError** error);
	void (*create_stream_async) (GXmlParser* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GInputStream* (*create_stream_finish) (GXmlParser* self, GAsyncResult* _res_, GError** error);
	void (*read_child_nodes) (GXmlParser* self, GXmlDomNode* parent, GError** error);
	void (*read_child_nodes_async) (GXmlParser* self, GXmlDomNode* parent, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*read_child_nodes_finish) (GXmlParser* self, GAsyncResult* _res_, GError** error);
	gboolean (*read_child_node) (GXmlParser* self, GXmlDomNode* parent, GError** error);
	gboolean (*read_child_element) (GXmlParser* self, GXmlDomNode* parent, GError** error);
	gboolean (*read_element_property) (GXmlParser* self, GXmlDomNode* parent, GXmlDomNode* * element, GError** error);
	gboolean (*add_element_collection) (GXmlParser* self, GXmlDomNode* parent, GXmlDomNode* * element, GError** error);
	void (*read_child_nodes_stream) (GXmlParser* self, GInputStream* istream, GError** error);
	void (*read_child_nodes_string) (GXmlParser* self, const gchar* str, GError** error);
	gchar* (*read_unparsed) (GXmlParser* self, GError** error);
	gboolean (*move_next_node) (GXmlParser* self, GError** error);
	gboolean (*current_is_empty_element) (GXmlParser* self);
	gboolean (*current_is_element) (GXmlParser* self);
	gboolean (*current_is_document) (GXmlParser* self);
	gchar* (*current_node_name) (GXmlParser* self);
	GXmlDomElement* (*create_element) (GXmlParser* self, GXmlDomNode* parent, GError** error);
	void (*read_element) (GXmlParser* self, GXmlDomElement* element, GError** error);
	gboolean (*get_backup) (GXmlParser* self);
	void (*set_backup) (GXmlParser* self, gboolean value);
	gboolean (*get_indent) (GXmlParser* self);
	void (*set_indent) (GXmlParser* self, gboolean value);
	GCancellable* (*get_cancellable) (GXmlParser* self);
	void (*set_cancellable) (GXmlParser* self, GCancellable* value);
	GXmlDomNode* (*get_node) (GXmlParser* self);
};

struct _GXmlDomDocumentTypeIface {
	GTypeInterface parent_iface;
	const gchar* (*get_name) (GXmlDomDocumentType* self);
	const gchar* (*get_public_id) (GXmlDomDocumentType* self);
	const gchar* (*get_system_id) (GXmlDomDocumentType* self);
};

struct _GXmlDomXMLDocumentIface {
	GTypeInterface parent_iface;
};

struct _GXmlNamespaceIface {
	GTypeInterface parent_iface;
	gchar* (*get_uri) (GXmlNamespace* self);
	gchar* (*get_prefix) (GXmlNamespace* self);
};

struct _GXmlNodeIface {
	GTypeInterface parent_iface;
	GXmlNode* (*get) (GXmlNode* self, const gchar* key);
	GXmlElementList* (*get_elements_by_property_value) (GXmlNode* self, const gchar* property, const gchar* value);
	GXmlElementList* (*get_elements_by_name) (GXmlNode* self, const gchar* name);
	GXmlElementList* (*get_elements_by_name_ns) (GXmlNode* self, const gchar* name, const gchar* ns);
	gchar* (*to_string) (GXmlNode* self);
	gboolean (*set_namespace) (GXmlNode* self, const gchar* uri, const gchar* prefix);
	gchar* (*ns_prefix) (GXmlNode* self);
	gchar* (*ns_uri) (GXmlNode* self);
	GeeList* (*get_namespaces) (GXmlNode* self);
	GeeBidirList* (*get_children_nodes) (GXmlNode* self);
	GeeMap* (*get_attrs) (GXmlNode* self);
	gchar* (*get_name) (GXmlNode* self);
	gchar* (*get_value) (GXmlNode* self);
	void (*set_value) (GXmlNode* self, const gchar* value);
	GXmlNodeType (*get_type_node) (GXmlNode* self);
	GXmlDocument* (*get_document) (GXmlNode* self);
	GXmlNode* (*get_parent) (GXmlNode* self);
};

struct _GXmlDocumentIface {
	GTypeInterface parent_iface;
	GXmlNode* (*create_element) (GXmlDocument* self, const gchar* name, GError** error);
	GXmlNode* (*create_text) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_comment) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_cdata) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_pi) (GXmlDocument* self, const gchar* target, const gchar* data);
	gboolean (*save) (GXmlDocument* self, GCancellable* cancellable, GError** error);
	gboolean (*save_as) (GXmlDocument* self, GFile* f, GCancellable* cancellable, GError** error);
	gboolean (*get_indent) (GXmlDocument* self);
	void (*set_indent) (GXmlDocument* self, gboolean value);
	gboolean (*get_ns_top) (GXmlDocument* self);
	void (*set_ns_top) (GXmlDocument* self, gboolean value);
	gboolean (*get_prefix_default_ns) (GXmlDocument* self);
	void (*set_prefix_default_ns) (GXmlDocument* self, gboolean value);
	gboolean (*get_backup) (GXmlDocument* self);
	void (*set_backup) (GXmlDocument* self, gboolean value);
	GXmlNode* (*get_root) (GXmlDocument* self);
	GFile* (*get_file) (GXmlDocument* self);
	void (*set_file) (GXmlDocument* self, GFile* value);
};

struct _GXmlDomImplementationIface {
	GTypeInterface parent_iface;
	GXmlDomDocumentType* (*create_document_type) (GXmlDomImplementation* self, const gchar* qualified_name, const gchar* public_id, const gchar* system_id, GError** error);
	GXmlDomXMLDocument* (*create_document) (GXmlDomImplementation* self, const gchar* nspace, const gchar* qualified_name, GXmlDomDocumentType* doctype, GError** error);
	GXmlDocument* (*create_html_document) (GXmlDomImplementation* self, const gchar* title);
	gboolean (*has_feature) (GXmlDomImplementation* self);
};

struct _GXmlDomDocumentIface {
	GTypeInterface parent_iface;
	GXmlDomHTMLCollection* (*get_elements_by_tag_name) (GXmlDomDocument* self, const gchar* local_name);
	GXmlDomHTMLCollection* (*get_elements_by_tag_name_ns) (GXmlDomDocument* self, const gchar* namespace, const gchar* local_name);
	GXmlDomHTMLCollection* (*get_elements_by_class_name) (GXmlDomDocument* self, const gchar* classNames);
	GXmlDomElement* (*create_element) (GXmlDomDocument* self, const gchar* local_name, GError** error);
	GXmlDomElement* (*create_element_ns) (GXmlDomDocument* self, const gchar* namespace, const gchar* qualified_name, GError** error);
	GXmlDomDocumentFragment* (*create_document_fragment) (GXmlDomDocument* self);
	GXmlDomText* (*create_text_node) (GXmlDomDocument* self, const gchar* data, GError** error);
	GXmlDomComment* (*create_comment) (GXmlDomDocument* self, const gchar* data, GError** error);
	GXmlDomProcessingInstruction* (*create_processing_instruction) (GXmlDomDocument* self, const gchar* target, const gchar* data, GError** error);
	GXmlDomNode* (*import_node) (GXmlDomDocument* self, GXmlDomNode* node, gboolean deep, GError** error);
	GXmlDomNode* (*adopt_node) (GXmlDomDocument* self, GXmlDomNode* node, GError** error);
	GXmlDomEvent* (*create_event) (GXmlDomDocument* self, const gchar* interface, GError** error);
	GXmlDomRange* (*create_range) (GXmlDomDocument* self);
	GXmlDomNodeIterator* (*create_node_iterator) (GXmlDomDocument* self, GXmlDomNode* root, gint whatToShow, GXmlDomNodeFilter* filter);
	GXmlDomTreeWalker* (*create_tree_walker) (GXmlDomDocument* self, GXmlDomNode* root, gint what_to_show, GXmlDomNodeFilter* filter);
	void (*write_file) (GXmlDomDocument* self, GFile* file, GCancellable* cancellable, GError** error);
	void (*write_file_async) (GXmlDomDocument* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*write_file_finish) (GXmlDomDocument* self, GAsyncResult* _res_, GError** error);
	void (*write_stream) (GXmlDomDocument* self, GOutputStream* stream, GCancellable* cancellable, GError** error);
	void (*write_stream_async) (GXmlDomDocument* self, GOutputStream* stream, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*write_stream_finish) (GXmlDomDocument* self, GAsyncResult* _res_, GError** error);
	GInputStream* (*create_stream) (GXmlDomDocument* self, GError** error);
	void (*create_stream_async) (GXmlDomDocument* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GInputStream* (*create_stream_finish) (GXmlDomDocument* self, GAsyncResult* _res_, GError** error);
	gchar* (*write_string) (GXmlDomDocument* self, GCancellable* cancellable, GError** error);
	void (*write_string_async) (GXmlDomDocument* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar* (*write_string_finish) (GXmlDomDocument* self, GAsyncResult* _res_, GError** error);
	void (*read_from_file) (GXmlDomDocument* self, GFile* file, GCancellable* cancellable, GError** error);
	void (*read_from_file_async) (GXmlDomDocument* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*read_from_file_finish) (GXmlDomDocument* self, GAsyncResult* _res_, GError** error);
	void (*read_from_string) (GXmlDomDocument* self, const gchar* str, GCancellable* cancellable, GError** error);
	void (*read_from_string_async) (GXmlDomDocument* self, const gchar* str, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*read_from_string_finish) (GXmlDomDocument* self, GAsyncResult* _res_, GError** error);
	void (*read_from_stream) (GXmlDomDocument* self, GInputStream* stream, GCancellable* cancellable, GError** error);
	void (*read_from_stream_async) (GXmlDomDocument* self, GInputStream* stream, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*read_from_stream_finish) (GXmlDomDocument* self, GAsyncResult* _res_, GError** error);
	GXmlParser* (*get_xml_parser) (GXmlDomDocument* self);
	void (*set_xml_parser) (GXmlDomDocument* self, GXmlParser* parser);
	GXmlDomImplementation* (*get_implementation) (GXmlDomDocument* self);
	const gchar* (*get_url) (GXmlDomDocument* self);
	const gchar* (*get_document_uri) (GXmlDomDocument* self);
	const gchar* (*get_origin) (GXmlDomDocument* self);
	const gchar* (*get_compat_mode) (GXmlDomDocument* self);
	const gchar* (*get_character_set) (GXmlDomDocument* self);
	const gchar* (*get_content_type) (GXmlDomDocument* self);
	GXmlDomDocumentType* (*get_doctype) (GXmlDomDocument* self);
	GXmlDomElement* (*get_document_element) (GXmlDomDocument* self);
};

struct _GXmlDomNodeIface {
	GTypeInterface parent_iface;
	gboolean (*has_child_nodes) (GXmlDomNode* self);
	void (*normalize) (GXmlDomNode* self);
	gboolean (*is_equal_node) (GXmlDomNode* self, GXmlDomNode* node);
	GXmlDomNodeDocumentPosition (*compare_document_position) (GXmlDomNode* self, GXmlDomNode* other);
	gboolean (*contains) (GXmlDomNode* self, GXmlDomNode* other);
	gchar* (*lookup_prefix) (GXmlDomNode* self, const gchar* nspace);
	gchar* (*lookup_namespace_uri) (GXmlDomNode* self, const gchar* prefix);
	gboolean (*is_default_namespace) (GXmlDomNode* self, const gchar* nspace);
	GXmlDomNode* (*insert_before) (GXmlDomNode* self, GXmlDomNode* node, GXmlDomNode* child, GError** error);
	GXmlDomNode* (*append_child) (GXmlDomNode* self, GXmlDomNode* node, GError** error);
	GXmlDomNode* (*replace_child) (GXmlDomNode* self, GXmlDomNode* node, GXmlDomNode* child, GError** error);
	GXmlDomNode* (*remove_child) (GXmlDomNode* self, GXmlDomNode* child, GError** error);
	GXmlDomNode* (*clone_node) (GXmlDomNode* self, gboolean deep, GError** error);
	GXmlDomNodeNodeType (*get_node_type) (GXmlDomNode* self);
	gchar* (*get_node_name) (GXmlDomNode* self);
	const gchar* (*get_base_uri) (GXmlDomNode* self);
	GXmlDomDocument* (*get_owner_document) (GXmlDomNode* self);
	void (*set_owner_document) (GXmlDomNode* self, GXmlDomDocument* value);
	GXmlDomNode* (*get_parent_node) (GXmlDomNode* self);
	GXmlDomElement* (*get_parent_element) (GXmlDomNode* self);
	GXmlDomNodeList* (*get_child_nodes) (GXmlDomNode* self);
	GXmlDomNode* (*get_first_child) (GXmlDomNode* self);
	GXmlDomNode* (*get_last_child) (GXmlDomNode* self);
	GXmlDomNode* (*get_previous_sibling) (GXmlDomNode* self);
	GXmlDomNode* (*get_next_sibling) (GXmlDomNode* self);
	gchar* (*get_node_value) (GXmlDomNode* self);
	void (*set_node_value) (GXmlDomNode* self, const gchar* value);
	gchar* (*get_text_content) (GXmlDomNode* self);
	void (*set_text_content) (GXmlDomNode* self, const gchar* value);
};

struct _GXmlDomTokenListIface {
	GTypeInterface parent_iface;
	gchar* (*item) (GXmlDomTokenList* self, gint index);
	gboolean (*contains) (GXmlDomTokenList* self, const gchar* token, GError** error);
	void (*add) (GXmlDomTokenList* self, gchar** tokens, gint tokens_length1, GError** error);
	void (*remove) (GXmlDomTokenList* self, gchar** tokens, gint tokens_length1);
	gboolean (*toggle) (GXmlDomTokenList* self, const gchar* token, gboolean force, gboolean _auto_, GError** error);
	gchar* (*to_string) (GXmlDomTokenList* self);
	gint (*get_length) (GXmlDomTokenList* self);
};

struct _GXmlDomNamedNodeMapIface {
	GTypeInterface parent_iface;
	GXmlDomNode* (*item) (GXmlDomNamedNodeMap* self, gint index);
	GXmlDomNode* (*get_named_item) (GXmlDomNamedNodeMap* self, const gchar* name);
	GXmlDomNode* (*set_named_item) (GXmlDomNamedNodeMap* self, GXmlDomNode* node, GError** error);
	GXmlDomNode* (*remove_named_item) (GXmlDomNamedNodeMap* self, const gchar* name, GError** error);
	GXmlDomNode* (*remove_named_item_ns) (GXmlDomNamedNodeMap* self, const gchar* namespace_uri, const gchar* localName, GError** error);
	GXmlDomNode* (*get_named_item_ns) (GXmlDomNamedNodeMap* self, const gchar* namespace_uri, const gchar* local_name, GError** error);
	GXmlDomNode* (*set_named_item_ns) (GXmlDomNamedNodeMap* self, GXmlDomNode* node, GError** error);
	gint (*get_length) (GXmlDomNamedNodeMap* self);
};

struct _GXmlDomElementIface {
	GTypeInterface parent_iface;
	gchar* (*get_attribute) (GXmlDomElement* self, const gchar* name);
	gchar* (*get_attribute_ns) (GXmlDomElement* self, const gchar* namespace, const gchar* local_name);
	void (*set_attribute) (GXmlDomElement* self, const gchar* name, const gchar* value, GError** error);
	void (*set_attribute_ns) (GXmlDomElement* self, const gchar* namespace, const gchar* name, const gchar* value, GError** error);
	void (*remove_attribute) (GXmlDomElement* self, const gchar* name);
	void (*remove_attribute_ns) (GXmlDomElement* self, const gchar* namespace, const gchar* local_name);
	gboolean (*has_attribute) (GXmlDomElement* self, const gchar* name);
	gboolean (*has_attribute_ns) (GXmlDomElement* self, const gchar* namespace, const gchar* local_name);
	GXmlDomHTMLCollection* (*get_elements_by_tag_name) (GXmlDomElement* self, const gchar* local_name);
	GXmlDomHTMLCollection* (*get_elements_by_tag_name_ns) (GXmlDomElement* self, const gchar* namespace, const gchar* local_name);
	GXmlDomHTMLCollection* (*get_elements_by_class_name) (GXmlDomElement* self, const gchar* class_names);
	gboolean (*matches) (GXmlDomElement* self, const gchar* selectors, GError** error);
	void (*read_from_uri) (GXmlDomElement* self, const gchar* uri, GError** error);
	void (*read_from_uri_async) (GXmlDomElement* self, const gchar* uri, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*read_from_uri_finish) (GXmlDomElement* self, GAsyncResult* _res_, GError** error);
	void (*read_from_file) (GXmlDomElement* self, GFile* f, GCancellable* cancellable, GError** error);
	void (*read_from_file_async) (GXmlDomElement* self, GFile* f, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*read_from_file_finish) (GXmlDomElement* self, GAsyncResult* _res_, GError** error);
	void (*read_from_stream) (GXmlDomElement* self, GInputStream* istream, GCancellable* cancellable, GError** error);
	void (*read_from_stream_async) (GXmlDomElement* self, GInputStream* istream, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*read_from_stream_finish) (GXmlDomElement* self, GAsyncResult* _res_, GError** error);
	void (*read_from_string) (GXmlDomElement* self, const gchar* str, GCancellable* cancellable, GError** error);
	void (*read_from_string_async) (GXmlDomElement* self, const gchar* str, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*read_from_string_finish) (GXmlDomElement* self, GAsyncResult* _res_, GError** error);
	gchar* (*write_string) (GXmlDomElement* self, GCancellable* cancellable, GError** error);
	void (*write_string_async) (GXmlDomElement* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar* (*write_string_finish) (GXmlDomElement* self, GAsyncResult* _res_, GError** error);
	void (*write_file) (GXmlDomElement* self, GFile* f, GCancellable* cancellable, GError** error);
	void (*write_file_async) (GXmlDomElement* self, GFile* f, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*write_file_finish) (GXmlDomElement* self, GAsyncResult* _res_, GError** error);
	void (*write_stream) (GXmlDomElement* self, GOutputStream* stream, GError** error);
	void (*write_stream_async) (GXmlDomElement* self, GOutputStream* stream, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*write_stream_finish) (GXmlDomElement* self, GAsyncResult* _res_, GError** error);
	GInputStream* (*create_stream) (GXmlDomElement* self, GError** error);
	void (*create_stream_async) (GXmlDomElement* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GInputStream* (*create_stream_finish) (GXmlDomElement* self, GAsyncResult* _res_, GError** error);
	gchar* (*get_namespace_uri) (GXmlDomElement* self);
	gchar* (*get_prefix) (GXmlDomElement* self);
	gchar* (*get_local_name) (GXmlDomElement* self);
	gchar* (*get_tag_name) (GXmlDomElement* self);
	gchar* (*get_id) (GXmlDomElement* self);
	void (*set_id) (GXmlDomElement* self, const gchar* value);
	gchar* (*get_class_name) (GXmlDomElement* self);
	void (*set_class_name) (GXmlDomElement* self, const gchar* value);
	GXmlDomTokenList* (*get_class_list) (GXmlDomElement* self);
	GXmlDomNamedNodeMap* (*get_attributes) (GXmlDomElement* self);
};

struct _GxmlDomElementReadFromUriAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	GXmlDomElement* self;
	gchar* uri;
	GCancellable* cancellable;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_;
};

struct _GxmlDomElementReadFromFileAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	GXmlDomElement* self;
	GFile* f;
	GCancellable* cancellable;
};

struct _GxmlDomElementReadFromStreamAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	GXmlDomElement* self;
	GInputStream* istream;
	GCancellable* cancellable;
};

struct _GxmlDomElementReadFromStringAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	GXmlDomElement* self;
	gchar* str;
	GCancellable* cancellable;
};

struct _GxmlDomElementWriteStringAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	GXmlDomElement* self;
	GCancellable* cancellable;
	gchar* result;
	gchar* _tmp0_;
};

struct _GxmlDomElementWriteFileAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	GXmlDomElement* self;
	GFile* f;
	GCancellable* cancellable;
	GXmlDomDocument* _tmp0_;
	GXmlDomDocument* _tmp1_;
	GError* _inner_error0_;
};

struct _GxmlDomElementWriteStreamAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	GXmlDomElement* self;
	GOutputStream* stream;
	GCancellable* cancellable;
	GXmlDomDocument* _tmp0_;
	GXmlDomDocument* _tmp1_;
	GError* _inner_error0_;
};

struct _GxmlDomElementCreateStreamAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	GXmlDomElement* self;
	GCancellable* cancellable;
	GInputStream* result;
	GInputStream* _tmp0_;
	GXmlDomDocument* _tmp1_;
	GXmlDomDocument* _tmp2_;
	GInputStream* _tmp3_;
	GInputStream* _tmp4_;
	GError* _inner_error0_;
};

struct _GXmlDomElementList {
	GeeArrayList parent_instance;
	GXmlDomElementListPrivate * priv;
};

struct _GXmlDomElementListClass {
	GeeArrayListClass parent_class;
};

static gpointer gxml_dom_element_list_parent_class = NULL;
static GXmlDomHTMLCollectionIface * gxml_dom_element_list_gxml_dom_html_collection_parent_iface = NULL;

GType gxml_dom_time_stamp_get_type (void) G_GNUC_CONST;
GType gxml_dom_event_phase_get_type (void) G_GNUC_CONST;
GType gxml_dom_event_get_type (void) G_GNUC_CONST;
GType gxml_dom_event_listener_get_type (void) G_GNUC_CONST;
GType gxml_dom_event_target_get_type (void) G_GNUC_CONST;
GType gxml_dom_node_document_position_get_type (void) G_GNUC_CONST;
GType gxml_dom_node_node_type_get_type (void) G_GNUC_CONST;
GType gxml_dom_node_list_get_type (void) G_GNUC_CONST;
GType gxml_dom_element_list_get_type (void) G_GNUC_CONST;
GType gxml_dom_html_collection_get_type (void) G_GNUC_CONST;
GType gxml_dom_parent_node_get_type (void) G_GNUC_CONST;
GType gxml_dom_non_element_parent_node_get_type (void) G_GNUC_CONST;
GType gxml_dom_document_fragment_get_type (void) G_GNUC_CONST;
GType gxml_dom_non_document_type_child_node_get_type (void) G_GNUC_CONST;
GType gxml_dom_child_node_get_type (void) G_GNUC_CONST;
GType gxml_dom_character_data_get_type (void) G_GNUC_CONST;
GType gxml_dom_text_get_type (void) G_GNUC_CONST;
GType gxml_dom_comment_get_type (void) G_GNUC_CONST;
GType gxml_dom_processing_instruction_get_type (void) G_GNUC_CONST;
GType gxml_dom_range_boundary_points_get_type (void) G_GNUC_CONST;
GType gxml_dom_range_get_type (void) G_GNUC_CONST;
GType gxml_dom_node_filter_get_type (void) G_GNUC_CONST;
GType gxml_dom_node_iterator_get_type (void) G_GNUC_CONST;
GType gxml_dom_tree_walker_get_type (void) G_GNUC_CONST;
GType gxml_parser_get_type (void) G_GNUC_CONST;
GType gxml_dom_document_type_get_type (void) G_GNUC_CONST;
GType gxml_dom_xml_document_get_type (void) G_GNUC_CONST;
GType gxml_element_list_get_type (void) G_GNUC_CONST;
GType gxml_namespace_get_type (void) G_GNUC_CONST;
GType gxml_node_type_get_type (void) G_GNUC_CONST;
GType gxml_node_get_type (void) G_GNUC_CONST;
GType gxml_document_get_type (void) G_GNUC_CONST;
GType gxml_dom_implementation_get_type (void) G_GNUC_CONST;
GType gxml_dom_document_get_type (void) G_GNUC_CONST;
GType gxml_dom_node_get_type (void) G_GNUC_CONST;
GType gxml_dom_token_list_get_type (void) G_GNUC_CONST;
GType gxml_dom_named_node_map_get_type (void) G_GNUC_CONST;
GType gxml_dom_element_get_type (void) G_GNUC_CONST;
gchar* gxml_dom_element_get_attribute (GXmlDomElement* self,
                                       const gchar* name);
gchar* gxml_dom_element_get_attribute_ns (GXmlDomElement* self,
                                          const gchar* namespace,
                                          const gchar* local_name);
void gxml_dom_element_set_attribute (GXmlDomElement* self,
                                     const gchar* name,
                                     const gchar* value,
                                     GError** error);
void gxml_dom_element_set_attribute_ns (GXmlDomElement* self,
                                        const gchar* namespace,
                                        const gchar* name,
                                        const gchar* value,
                                        GError** error);
void gxml_dom_element_remove_attribute (GXmlDomElement* self,
                                        const gchar* name);
void gxml_dom_element_remove_attribute_ns (GXmlDomElement* self,
                                           const gchar* namespace,
                                           const gchar* local_name);
gboolean gxml_dom_element_has_attribute (GXmlDomElement* self,
                                         const gchar* name);
gboolean gxml_dom_element_has_attribute_ns (GXmlDomElement* self,
                                            const gchar* namespace,
                                            const gchar* local_name);
GXmlDomHTMLCollection* gxml_dom_element_get_elements_by_tag_name (GXmlDomElement* self,
                                                                  const gchar* local_name);
GXmlDomHTMLCollection* gxml_dom_element_get_elements_by_tag_name_ns (GXmlDomElement* self,
                                                                     const gchar* namespace,
                                                                     const gchar* local_name);
GXmlDomHTMLCollection* gxml_dom_element_get_elements_by_class_name (GXmlDomElement* self,
                                                                    const gchar* class_names);
gboolean gxml_dom_element_matches (GXmlDomElement* self,
                                   const gchar* selectors,
                                   GError** error);
static gboolean gxml_dom_element_real_matches (GXmlDomElement* self,
                                        const gchar* selectors,
                                        GError** error);
GType gxml_css_selector_parser_get_type (void) G_GNUC_CONST;
GXmlCssSelectorParser* gxml_css_selector_parser_new (void);
GXmlCssSelectorParser* gxml_css_selector_parser_construct (GType object_type);
void gxml_css_selector_parser_parse (GXmlCssSelectorParser* self,
                                     const gchar* selectors,
                                     GError** error);
gboolean gxml_css_selector_parser_match (GXmlCssSelectorParser* self,
                                         GXmlDomElement* element,
                                         GError** error);
void gxml_dom_element_read_from_uri (GXmlDomElement* self,
                                     const gchar* uri,
                                     GError** error);
static void gxml_dom_element_real_read_from_uri (GXmlDomElement* self,
                                          const gchar* uri,
                                          GError** error);
void gxml_dom_element_read_from_file (GXmlDomElement* self,
                                      GFile* f,
                                      GCancellable* cancellable,
                                      GError** error);
static void gxml_dom_element_real_read_from_uri_async_data_free (gpointer _data);
static void gxml_dom_element_real_read_from_uri_async_async_ready_wrapper (GObject *source_object,
                                                                    GAsyncResult *res,
                                                                    void *user_data);
static void gxml_dom_element_real_read_from_uri_async (GXmlDomElement* self,
                                                const gchar* uri,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
void gxml_dom_element_read_from_uri_async (GXmlDomElement* self,
                                           const gchar* uri,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
void gxml_dom_element_read_from_uri_finish (GXmlDomElement* self,
                                            GAsyncResult* _res_,
                                            GError** error);
static gboolean gxml_dom_element_real_read_from_uri_async_co (GxmlDomElementReadFromUriAsyncData* _data_);
void gxml_dom_element_read_from_file_async (GXmlDomElement* self,
                                            GFile* f,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
void gxml_dom_element_read_from_file_finish (GXmlDomElement* self,
                                             GAsyncResult* _res_,
                                             GError** error);
static void gxml_dom_element_read_from_uri_async_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static void gxml_dom_element_real_read_from_file (GXmlDomElement* self,
                                           GFile* f,
                                           GCancellable* cancellable,
                                           GError** error);
static void gxml_dom_element_real_read_from_file_async_data_free (gpointer _data);
static void gxml_dom_element_real_read_from_file_async_async_ready_wrapper (GObject *source_object,
                                                                     GAsyncResult *res,
                                                                     void *user_data);
static void gxml_dom_element_real_read_from_file_async (GXmlDomElement* self,
                                                 GFile* f,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static gboolean gxml_dom_element_real_read_from_file_async_co (GxmlDomElementReadFromFileAsyncData* _data_);
void gxml_dom_element_read_from_stream (GXmlDomElement* self,
                                        GInputStream* istream,
                                        GCancellable* cancellable,
                                        GError** error);
static void gxml_dom_element_real_read_from_stream (GXmlDomElement* self,
                                             GInputStream* istream,
                                             GCancellable* cancellable,
                                             GError** error);
static void gxml_dom_element_real_read_from_stream_async_data_free (gpointer _data);
static void gxml_dom_element_real_read_from_stream_async_async_ready_wrapper (GObject *source_object,
                                                                       GAsyncResult *res,
                                                                       void *user_data);
static void gxml_dom_element_real_read_from_stream_async (GXmlDomElement* self,
                                                   GInputStream* istream,
                                                   GCancellable* cancellable,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
void gxml_dom_element_read_from_stream_async (GXmlDomElement* self,
                                              GInputStream* istream,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
void gxml_dom_element_read_from_stream_finish (GXmlDomElement* self,
                                               GAsyncResult* _res_,
                                               GError** error);
static gboolean gxml_dom_element_real_read_from_stream_async_co (GxmlDomElementReadFromStreamAsyncData* _data_);
void gxml_dom_element_read_from_string (GXmlDomElement* self,
                                        const gchar* str,
                                        GCancellable* cancellable,
                                        GError** error);
static void gxml_dom_element_real_read_from_string (GXmlDomElement* self,
                                             const gchar* str,
                                             GCancellable* cancellable,
                                             GError** error);
static void gxml_dom_element_real_read_from_string_async_data_free (gpointer _data);
static void gxml_dom_element_real_read_from_string_async_async_ready_wrapper (GObject *source_object,
                                                                       GAsyncResult *res,
                                                                       void *user_data);
static void gxml_dom_element_real_read_from_string_async (GXmlDomElement* self,
                                                   const gchar* str,
                                                   GCancellable* cancellable,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
void gxml_dom_element_read_from_string_async (GXmlDomElement* self,
                                              const gchar* str,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
void gxml_dom_element_read_from_string_finish (GXmlDomElement* self,
                                               GAsyncResult* _res_,
                                               GError** error);
static gboolean gxml_dom_element_real_read_from_string_async_co (GxmlDomElementReadFromStringAsyncData* _data_);
gchar* gxml_dom_element_write_string (GXmlDomElement* self,
                                      GCancellable* cancellable,
                                      GError** error);
static gchar* gxml_dom_element_real_write_string (GXmlDomElement* self,
                                           GCancellable* cancellable,
                                           GError** error);
static void gxml_dom_element_real_write_string_async_data_free (gpointer _data);
static void gxml_dom_element_real_write_string_async_async_ready_wrapper (GObject *source_object,
                                                                   GAsyncResult *res,
                                                                   void *user_data);
static void gxml_dom_element_real_write_string_async (GXmlDomElement* self,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
void gxml_dom_element_write_string_async (GXmlDomElement* self,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
gchar* gxml_dom_element_write_string_finish (GXmlDomElement* self,
                                             GAsyncResult* _res_,
                                             GError** error);
static gboolean gxml_dom_element_real_write_string_async_co (GxmlDomElementWriteStringAsyncData* _data_);
void gxml_dom_element_write_file (GXmlDomElement* self,
                                  GFile* f,
                                  GCancellable* cancellable,
                                  GError** error);
static void gxml_dom_element_real_write_file (GXmlDomElement* self,
                                       GFile* f,
                                       GCancellable* cancellable,
                                       GError** error);
GXmlDomDocument* gxml_dom_node_get_owner_document (GXmlDomNode* self);
void gxml_dom_document_write_file (GXmlDomDocument* self,
                                   GFile* file,
                                   GCancellable* cancellable,
                                   GError** error);
static void gxml_dom_element_real_write_file_async_data_free (gpointer _data);
static void gxml_dom_element_real_write_file_async_async_ready_wrapper (GObject *source_object,
                                                                 GAsyncResult *res,
                                                                 void *user_data);
static void gxml_dom_element_real_write_file_async (GXmlDomElement* self,
                                             GFile* f,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
void gxml_dom_element_write_file_async (GXmlDomElement* self,
                                        GFile* f,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
void gxml_dom_element_write_file_finish (GXmlDomElement* self,
                                         GAsyncResult* _res_,
                                         GError** error);
static gboolean gxml_dom_element_real_write_file_async_co (GxmlDomElementWriteFileAsyncData* _data_);
void gxml_dom_document_write_file_async (GXmlDomDocument* self,
                                         GFile* file,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
void gxml_dom_document_write_file_finish (GXmlDomDocument* self,
                                          GAsyncResult* _res_,
                                          GError** error);
static void gxml_dom_element_write_file_async_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
void gxml_dom_element_write_stream (GXmlDomElement* self,
                                    GOutputStream* stream,
                                    GError** error);
static void gxml_dom_element_real_write_stream (GXmlDomElement* self,
                                         GOutputStream* stream,
                                         GError** error);
void gxml_dom_document_write_stream (GXmlDomDocument* self,
                                     GOutputStream* stream,
                                     GCancellable* cancellable,
                                     GError** error);
static void gxml_dom_element_real_write_stream_async_data_free (gpointer _data);
static void gxml_dom_element_real_write_stream_async_async_ready_wrapper (GObject *source_object,
                                                                   GAsyncResult *res,
                                                                   void *user_data);
static void gxml_dom_element_real_write_stream_async (GXmlDomElement* self,
                                               GOutputStream* stream,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
void gxml_dom_element_write_stream_async (GXmlDomElement* self,
                                          GOutputStream* stream,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
void gxml_dom_element_write_stream_finish (GXmlDomElement* self,
                                           GAsyncResult* _res_,
                                           GError** error);
static gboolean gxml_dom_element_real_write_stream_async_co (GxmlDomElementWriteStreamAsyncData* _data_);
void gxml_dom_document_write_stream_async (GXmlDomDocument* self,
                                           GOutputStream* stream,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
void gxml_dom_document_write_stream_finish (GXmlDomDocument* self,
                                            GAsyncResult* _res_,
                                            GError** error);
static void gxml_dom_element_write_stream_async_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
GInputStream* gxml_dom_element_create_stream (GXmlDomElement* self,
                                              GError** error);
static GInputStream* gxml_dom_element_real_create_stream (GXmlDomElement* self,
                                                   GError** error);
GInputStream* gxml_dom_document_create_stream (GXmlDomDocument* self,
                                               GError** error);
static void gxml_dom_element_real_create_stream_async_data_free (gpointer _data);
static void gxml_dom_element_real_create_stream_async_async_ready_wrapper (GObject *source_object,
                                                                    GAsyncResult *res,
                                                                    void *user_data);
static void gxml_dom_element_real_create_stream_async (GXmlDomElement* self,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
void gxml_dom_element_create_stream_async (GXmlDomElement* self,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
GInputStream* gxml_dom_element_create_stream_finish (GXmlDomElement* self,
                                                     GAsyncResult* _res_,
                                                     GError** error);
static gboolean gxml_dom_element_real_create_stream_async_co (GxmlDomElementCreateStreamAsyncData* _data_);
void gxml_dom_document_create_stream_async (GXmlDomDocument* self,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
GInputStream* gxml_dom_document_create_stream_finish (GXmlDomDocument* self,
                                                      GAsyncResult* _res_,
                                                      GError** error);
static void gxml_dom_element_create_stream_async_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
gchar* gxml_dom_element_get_namespace_uri (GXmlDomElement* self);
gchar* gxml_dom_element_get_prefix (GXmlDomElement* self);
gchar* gxml_dom_element_get_local_name (GXmlDomElement* self);
gchar* gxml_dom_element_get_tag_name (GXmlDomElement* self);
gchar* gxml_dom_element_get_id (GXmlDomElement* self);
void gxml_dom_element_set_id (GXmlDomElement* self,
                              const gchar* value);
gchar* gxml_dom_element_get_class_name (GXmlDomElement* self);
void gxml_dom_element_set_class_name (GXmlDomElement* self,
                                      const gchar* value);
GXmlDomTokenList* gxml_dom_element_get_class_list (GXmlDomElement* self);
GXmlDomNamedNodeMap* gxml_dom_element_get_attributes (GXmlDomElement* self);
static GXmlDomElement* gxml_dom_element_list_real_get_element (GXmlDomHTMLCollection* base,
                                                        gint index);
GXmlDomElementList* gxml_dom_element_list_new (void);
GXmlDomElementList* gxml_dom_element_list_construct (GType object_type);

gchar*
gxml_dom_element_get_attribute (GXmlDomElement* self,
                                const gchar* name)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOM_ELEMENT_GET_INTERFACE (self)->get_attribute (self, name);
}

gchar*
gxml_dom_element_get_attribute_ns (GXmlDomElement* self,
                                   const gchar* namespace,
                                   const gchar* local_name)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOM_ELEMENT_GET_INTERFACE (self)->get_attribute_ns (self, namespace, local_name);
}

void
gxml_dom_element_set_attribute (GXmlDomElement* self,
                                const gchar* name,
                                const gchar* value,
                                GError** error)
{
	g_return_if_fail (self != NULL);
	GXML_DOM_ELEMENT_GET_INTERFACE (self)->set_attribute (self, name, value, error);
}

/**
   * Set an attribute value to this element. If it doesn't exists yet, it is added
   * to the list of attributes, unless it is an namespace redefinition.
   *
   * To set a namespace declaration [[http://www.w3.org/2000/xmlns]] namespace and xmlns
   * as prefix. For default namespaces, use xmlns as name without prefix. Namespace
   * URI will be the one provided as value.
   *
   * @param name a prefixed attribute name or xmlns for default namespace declaration
   * @param value a value for the attribute or URI for namespace declaration
   */
void
gxml_dom_element_set_attribute_ns (GXmlDomElement* self,
                                   const gchar* namespace,
                                   const gchar* name,
                                   const gchar* value,
                                   GError** error)
{
	g_return_if_fail (self != NULL);
	GXML_DOM_ELEMENT_GET_INTERFACE (self)->set_attribute_ns (self, namespace, name, value, error);
}

void
gxml_dom_element_remove_attribute (GXmlDomElement* self,
                                   const gchar* name)
{
	g_return_if_fail (self != NULL);
	GXML_DOM_ELEMENT_GET_INTERFACE (self)->remove_attribute (self, name);
}

void
gxml_dom_element_remove_attribute_ns (GXmlDomElement* self,
                                      const gchar* namespace,
                                      const gchar* local_name)
{
	g_return_if_fail (self != NULL);
	GXML_DOM_ELEMENT_GET_INTERFACE (self)->remove_attribute_ns (self, namespace, local_name);
}

gboolean
gxml_dom_element_has_attribute (GXmlDomElement* self,
                                const gchar* name)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_DOM_ELEMENT_GET_INTERFACE (self)->has_attribute (self, name);
}

gboolean
gxml_dom_element_has_attribute_ns (GXmlDomElement* self,
                                   const gchar* namespace,
                                   const gchar* local_name)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_DOM_ELEMENT_GET_INTERFACE (self)->has_attribute_ns (self, namespace, local_name);
}

GXmlDomHTMLCollection*
gxml_dom_element_get_elements_by_tag_name (GXmlDomElement* self,
                                           const gchar* local_name)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOM_ELEMENT_GET_INTERFACE (self)->get_elements_by_tag_name (self, local_name);
}

GXmlDomHTMLCollection*
gxml_dom_element_get_elements_by_tag_name_ns (GXmlDomElement* self,
                                              const gchar* namespace,
                                              const gchar* local_name)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOM_ELEMENT_GET_INTERFACE (self)->get_elements_by_tag_name_ns (self, namespace, local_name);
}

GXmlDomHTMLCollection*
gxml_dom_element_get_elements_by_class_name (GXmlDomElement* self,
                                             const gchar* class_names)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOM_ELEMENT_GET_INTERFACE (self)->get_elements_by_class_name (self, class_names);
}

static gboolean
gxml_dom_element_real_matches (GXmlDomElement* self,
                               const gchar* selectors,
                               GError** error)
{
	gboolean result = FALSE;
	GXmlCssSelectorParser* parser = NULL;
	GXmlCssSelectorParser* _tmp0_;
	GXmlCssSelectorParser* _tmp1_;
	gboolean _tmp3_ = FALSE;
	GXmlCssSelectorParser* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (selectors != NULL, FALSE);
	_tmp0_ = gxml_css_selector_parser_new ();
	parser = _tmp0_;
	_tmp1_ = parser;
	gxml_css_selector_parser_parse (_tmp1_, selectors, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (parser);
		return _tmp2_;
	}
	_tmp4_ = parser;
	_tmp3_ = gxml_css_selector_parser_match (_tmp4_, self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (parser);
		return _tmp5_;
	}
	result = _tmp3_;
	_g_object_unref0 (parser);
	return result;
}

gboolean
gxml_dom_element_matches (GXmlDomElement* self,
                          const gchar* selectors,
                          GError** error)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_DOM_ELEMENT_GET_INTERFACE (self)->matches (self, selectors, error);
}

/**
   * Parsing a URI file.
   */
static void
gxml_dom_element_real_read_from_uri (GXmlDomElement* self,
                                     const gchar* uri,
                                     GError** error)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (uri != NULL);
	_tmp0_ = g_file_new_for_uri (uri);
	_tmp1_ = _tmp0_;
	gxml_dom_element_read_from_file (self, _tmp1_, NULL, &_inner_error0_);
	_g_object_unref0 (_tmp1_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
gxml_dom_element_read_from_uri (GXmlDomElement* self,
                                const gchar* uri,
                                GError** error)
{
	g_return_if_fail (self != NULL);
	GXML_DOM_ELEMENT_GET_INTERFACE (self)->read_from_uri (self, uri, error);
}

static void
gxml_dom_element_real_read_from_uri_async_data_free (gpointer _data)
{
	GxmlDomElementReadFromUriAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GxmlDomElementReadFromUriAsyncData, _data_);
}

static void
gxml_dom_element_real_read_from_uri_async_async_ready_wrapper (GObject *source_object,
                                                               GAsyncResult *res,
                                                               void *user_data)
{
	GxmlDomElementReadFromUriAsyncData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gxml_dom_element_real_read_from_uri_async (GXmlDomElement* self,
                                           const gchar* uri,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	GxmlDomElementReadFromUriAsyncData* _data_;
	GXmlDomElement* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	_data_ = g_slice_new0 (GxmlDomElementReadFromUriAsyncData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, gxml_dom_element_real_read_from_uri_async_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, gxml_dom_element_real_read_from_uri_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	gxml_dom_element_real_read_from_uri_async_co (_data_);
}

static void
gxml_dom_element_real_read_from_uri_finish (GXmlDomElement* self,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	GxmlDomElementReadFromUriAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Parsing asinchronically a URI file.
   */
static void
gxml_dom_element_read_from_uri_async_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	GxmlDomElementReadFromUriAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	gxml_dom_element_real_read_from_uri_async_co (_data_);
}

static gboolean
gxml_dom_element_real_read_from_uri_async_co (GxmlDomElementReadFromUriAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_file_new_for_uri (_data_->uri);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_state_ = 1;
	gxml_dom_element_read_from_file_async (_data_->self, _data_->_tmp1_, NULL, gxml_dom_element_read_from_uri_async_ready, _data_);
	return FALSE;
	_state_1:
	gxml_dom_element_read_from_file_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_g_object_unref0 (_data_->_tmp1_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!_data_->_task_complete_) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
gxml_dom_element_read_from_uri_async (GXmlDomElement* self,
                                      const gchar* uri,
                                      GCancellable* cancellable,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	GXML_DOM_ELEMENT_GET_INTERFACE (self)->read_from_uri_async (self, uri, cancellable, _callback_, _user_data_);
}

void
gxml_dom_element_read_from_uri_finish (GXmlDomElement* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	GXML_DOM_ELEMENT_GET_INTERFACE (self)->read_from_uri_finish (self, _res_, error);
}

/**
   * Parses an XML file, deserializing it over {@link GomElement}.
   */
static void
gxml_dom_element_real_read_from_file (GXmlDomElement* self,
                                      GFile* f,
                                      GCancellable* cancellable,
                                      GError** error)
{
	g_return_if_fail (f != NULL);
}

void
gxml_dom_element_read_from_file (GXmlDomElement* self,
                                 GFile* f,
                                 GCancellable* cancellable,
                                 GError** error)
{
	g_return_if_fail (self != NULL);
	GXML_DOM_ELEMENT_GET_INTERFACE (self)->read_from_file (self, f, cancellable, error);
}

static void
gxml_dom_element_real_read_from_file_async_data_free (gpointer _data)
{
	GxmlDomElementReadFromFileAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->f);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GxmlDomElementReadFromFileAsyncData, _data_);
}

static void
gxml_dom_element_real_read_from_file_async_async_ready_wrapper (GObject *source_object,
                                                                GAsyncResult *res,
                                                                void *user_data)
{
	GxmlDomElementReadFromFileAsyncData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}

static void
gxml_dom_element_real_read_from_file_async (GXmlDomElement* self,
                                            GFile* f,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	GxmlDomElementReadFromFileAsyncData* _data_;
	GXmlDomElement* _tmp0_;
	GFile* _tmp1_;
	GCancellable* _tmp2_;
	_data_ = g_slice_new0 (GxmlDomElementReadFromFileAsyncData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, gxml_dom_element_real_read_from_file_async_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, gxml_dom_element_real_read_from_file_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (f);
	_g_object_unref0 (_data_->f);
	_data_->f = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	gxml_dom_element_real_read_from_file_async_co (_data_);
}

static void
gxml_dom_element_real_read_from_file_finish (GXmlDomElement* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	GxmlDomElementReadFromFileAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Parses asinchronically an XML file, deserializing it over {@link GomElement}.
   */
static gboolean
gxml_dom_element_real_read_from_file_async_co (GxmlDomElementReadFromFileAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!_data_->_task_complete_) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
gxml_dom_element_read_from_file_async (GXmlDomElement* self,
                                       GFile* f,
                                       GCancellable* cancellable,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	GXML_DOM_ELEMENT_GET_INTERFACE (self)->read_from_file_async (self, f, cancellable, _callback_, _user_data_);
}

void
gxml_dom_element_read_from_file_finish (GXmlDomElement* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	GXML_DOM_ELEMENT_GET_INTERFACE (self)->read_from_file_finish (self, _res_, error);
}

/**
   * Parses an XML over a {@link GLib.InputStream}, deserializing it over {@link GomElement}.
   */
static void
gxml_dom_element_real_read_from_stream (GXmlDomElement* self,
                                        GInputStream* istream,
                                        GCancellable* cancellable,
                                        GError** error)
{
	g_return_if_fail (istream != NULL);
}

void
gxml_dom_element_read_from_stream (GXmlDomElement* self,
                                   GInputStream* istream,
                                   GCancellable* cancellable,
                                   GError** error)
{
	g_return_if_fail (self != NULL);
	GXML_DOM_ELEMENT_GET_INTERFACE (self)->read_from_stream (self, istream, cancellable, error);
}

static void
gxml_dom_element_real_read_from_stream_async_data_free (gpointer _data)
{
	GxmlDomElementReadFromStreamAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->istream);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GxmlDomElementReadFromStreamAsyncData, _data_);
}

static void
gxml_dom_element_real_read_from_stream_async_async_ready_wrapper (GObject *source_object,
                                                                  GAsyncResult *res,
                                                                  void *user_data)
{
	GxmlDomElementReadFromStreamAsyncData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}

static void
gxml_dom_element_real_read_from_stream_async (GXmlDomElement* self,
                                              GInputStream* istream,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	GxmlDomElementReadFromStreamAsyncData* _data_;
	GXmlDomElement* _tmp0_;
	GInputStream* _tmp1_;
	GCancellable* _tmp2_;
	_data_ = g_slice_new0 (GxmlDomElementReadFromStreamAsyncData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, gxml_dom_element_real_read_from_stream_async_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, gxml_dom_element_real_read_from_stream_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (istream);
	_g_object_unref0 (_data_->istream);
	_data_->istream = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	gxml_dom_element_real_read_from_stream_async_co (_data_);
}

static void
gxml_dom_element_real_read_from_stream_finish (GXmlDomElement* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	GxmlDomElementReadFromStreamAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Parses asynchronically an XML over a {@link GLib.InputStream}, deserializing it over {@link GomElement}.
   */
static gboolean
gxml_dom_element_real_read_from_stream_async_co (GxmlDomElementReadFromStreamAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!_data_->_task_complete_) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
gxml_dom_element_read_from_stream_async (GXmlDomElement* self,
                                         GInputStream* istream,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	GXML_DOM_ELEMENT_GET_INTERFACE (self)->read_from_stream_async (self, istream, cancellable, _callback_, _user_data_);
}

void
gxml_dom_element_read_from_stream_finish (GXmlDomElement* self,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	GXML_DOM_ELEMENT_GET_INTERFACE (self)->read_from_stream_finish (self, _res_, error);
}

/**
   * Parses an XML string, deserializing it over {@link GomElement}.
   */
static void
gxml_dom_element_real_read_from_string (GXmlDomElement* self,
                                        const gchar* str,
                                        GCancellable* cancellable,
                                        GError** error)
{
	g_return_if_fail (str != NULL);
}

void
gxml_dom_element_read_from_string (GXmlDomElement* self,
                                   const gchar* str,
                                   GCancellable* cancellable,
                                   GError** error)
{
	g_return_if_fail (self != NULL);
	GXML_DOM_ELEMENT_GET_INTERFACE (self)->read_from_string (self, str, cancellable, error);
}

static void
gxml_dom_element_real_read_from_string_async_data_free (gpointer _data)
{
	GxmlDomElementReadFromStringAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->str);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GxmlDomElementReadFromStringAsyncData, _data_);
}

static void
gxml_dom_element_real_read_from_string_async_async_ready_wrapper (GObject *source_object,
                                                                  GAsyncResult *res,
                                                                  void *user_data)
{
	GxmlDomElementReadFromStringAsyncData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}

static void
gxml_dom_element_real_read_from_string_async (GXmlDomElement* self,
                                              const gchar* str,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	GxmlDomElementReadFromStringAsyncData* _data_;
	GXmlDomElement* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	_data_ = g_slice_new0 (GxmlDomElementReadFromStringAsyncData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, gxml_dom_element_real_read_from_string_async_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, gxml_dom_element_real_read_from_string_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (str);
	_g_free0 (_data_->str);
	_data_->str = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	gxml_dom_element_real_read_from_string_async_co (_data_);
}

static void
gxml_dom_element_real_read_from_string_finish (GXmlDomElement* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	GxmlDomElementReadFromStringAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Parses an XML string, deserializing it over {@link GomElement}.
   */
static gboolean
gxml_dom_element_real_read_from_string_async_co (GxmlDomElementReadFromStringAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!_data_->_task_complete_) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
gxml_dom_element_read_from_string_async (GXmlDomElement* self,
                                         const gchar* str,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	GXML_DOM_ELEMENT_GET_INTERFACE (self)->read_from_string_async (self, str, cancellable, _callback_, _user_data_);
}

void
gxml_dom_element_read_from_string_finish (GXmlDomElement* self,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	GXML_DOM_ELEMENT_GET_INTERFACE (self)->read_from_string_finish (self, _res_, error);
}

/**
   * Serialize {@link GomElement} to a string.
   */
static gchar*
gxml_dom_element_real_write_string (GXmlDomElement* self,
                                    GCancellable* cancellable,
                                    GError** error)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("");
	result = _tmp0_;
	return result;
}

gchar*
gxml_dom_element_write_string (GXmlDomElement* self,
                               GCancellable* cancellable,
                               GError** error)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOM_ELEMENT_GET_INTERFACE (self)->write_string (self, cancellable, error);
}

static void
gxml_dom_element_real_write_string_async_data_free (gpointer _data)
{
	GxmlDomElementWriteStringAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GxmlDomElementWriteStringAsyncData, _data_);
}

static void
gxml_dom_element_real_write_string_async_async_ready_wrapper (GObject *source_object,
                                                              GAsyncResult *res,
                                                              void *user_data)
{
	GxmlDomElementWriteStringAsyncData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}

static void
gxml_dom_element_real_write_string_async (GXmlDomElement* self,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	GxmlDomElementWriteStringAsyncData* _data_;
	GXmlDomElement* _tmp0_;
	GCancellable* _tmp1_;
	_data_ = g_slice_new0 (GxmlDomElementWriteStringAsyncData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, gxml_dom_element_real_write_string_async_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, gxml_dom_element_real_write_string_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	gxml_dom_element_real_write_string_async_co (_data_);
}

static gchar*
gxml_dom_element_real_write_string_finish (GXmlDomElement* self,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	gchar* result;
	GxmlDomElementWriteStringAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
   * Serialize asinchronically {@link GomElement} to a string.
   */
static gboolean
gxml_dom_element_real_write_string_async_co (GxmlDomElementWriteStringAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_strdup ("");
	_data_->result = _data_->_tmp0_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!_data_->_task_complete_) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
gxml_dom_element_write_string_async (GXmlDomElement* self,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	GXML_DOM_ELEMENT_GET_INTERFACE (self)->write_string_async (self, cancellable, _callback_, _user_data_);
}

gchar*
gxml_dom_element_write_string_finish (GXmlDomElement* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	return GXML_DOM_ELEMENT_GET_INTERFACE (self)->write_string_finish (self, _res_, error);
}

/**
   * Uses element's {@link GomDocument} to write an XML to a file, serializing it.
   */
static void
gxml_dom_element_real_write_file (GXmlDomElement* self,
                                  GFile* f,
                                  GCancellable* cancellable,
                                  GError** error)
{
	GXmlDomDocument* _tmp0_;
	GXmlDomDocument* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (f != NULL);
	_tmp0_ = gxml_dom_node_get_owner_document ((GXmlDomNode*) self);
	_tmp1_ = _tmp0_;
	gxml_dom_document_write_file (_tmp1_, f, cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
gxml_dom_element_write_file (GXmlDomElement* self,
                             GFile* f,
                             GCancellable* cancellable,
                             GError** error)
{
	g_return_if_fail (self != NULL);
	GXML_DOM_ELEMENT_GET_INTERFACE (self)->write_file (self, f, cancellable, error);
}

static void
gxml_dom_element_real_write_file_async_data_free (gpointer _data)
{
	GxmlDomElementWriteFileAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->f);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GxmlDomElementWriteFileAsyncData, _data_);
}

static void
gxml_dom_element_real_write_file_async_async_ready_wrapper (GObject *source_object,
                                                            GAsyncResult *res,
                                                            void *user_data)
{
	GxmlDomElementWriteFileAsyncData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}

static void
gxml_dom_element_real_write_file_async (GXmlDomElement* self,
                                        GFile* f,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	GxmlDomElementWriteFileAsyncData* _data_;
	GXmlDomElement* _tmp0_;
	GFile* _tmp1_;
	GCancellable* _tmp2_;
	_data_ = g_slice_new0 (GxmlDomElementWriteFileAsyncData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, gxml_dom_element_real_write_file_async_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, gxml_dom_element_real_write_file_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (f);
	_g_object_unref0 (_data_->f);
	_data_->f = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	gxml_dom_element_real_write_file_async_co (_data_);
}

static void
gxml_dom_element_real_write_file_finish (GXmlDomElement* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	GxmlDomElementWriteFileAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Uses element's {@link GomDocument} to write asynchronically an XML to a file, serializing it.
   */
static void
gxml_dom_element_write_file_async_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	GxmlDomElementWriteFileAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	gxml_dom_element_real_write_file_async_co (_data_);
}

static gboolean
gxml_dom_element_real_write_file_async_co (GxmlDomElementWriteFileAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gxml_dom_node_get_owner_document ((GXmlDomNode*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_state_ = 1;
	gxml_dom_document_write_file_async (_data_->_tmp1_, _data_->f, NULL, gxml_dom_element_write_file_async_ready, _data_);
	return FALSE;
	_state_1:
	gxml_dom_document_write_file_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!_data_->_task_complete_) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
gxml_dom_element_write_file_async (GXmlDomElement* self,
                                   GFile* f,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	GXML_DOM_ELEMENT_GET_INTERFACE (self)->write_file_async (self, f, cancellable, _callback_, _user_data_);
}

void
gxml_dom_element_write_file_finish (GXmlDomElement* self,
                                    GAsyncResult* _res_,
                                    GError** error)
{
	GXML_DOM_ELEMENT_GET_INTERFACE (self)->write_file_finish (self, _res_, error);
}

/**
   * Uses element's {@link GomDocument} to write an XML to a stream, serializing it.
   */
static void
gxml_dom_element_real_write_stream (GXmlDomElement* self,
                                    GOutputStream* stream,
                                    GError** error)
{
	GXmlDomDocument* _tmp0_;
	GXmlDomDocument* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (stream != NULL);
	_tmp0_ = gxml_dom_node_get_owner_document ((GXmlDomNode*) self);
	_tmp1_ = _tmp0_;
	gxml_dom_document_write_stream (_tmp1_, stream, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
gxml_dom_element_write_stream (GXmlDomElement* self,
                               GOutputStream* stream,
                               GError** error)
{
	g_return_if_fail (self != NULL);
	GXML_DOM_ELEMENT_GET_INTERFACE (self)->write_stream (self, stream, error);
}

static void
gxml_dom_element_real_write_stream_async_data_free (gpointer _data)
{
	GxmlDomElementWriteStreamAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->stream);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GxmlDomElementWriteStreamAsyncData, _data_);
}

static void
gxml_dom_element_real_write_stream_async_async_ready_wrapper (GObject *source_object,
                                                              GAsyncResult *res,
                                                              void *user_data)
{
	GxmlDomElementWriteStreamAsyncData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}

static void
gxml_dom_element_real_write_stream_async (GXmlDomElement* self,
                                          GOutputStream* stream,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	GxmlDomElementWriteStreamAsyncData* _data_;
	GXmlDomElement* _tmp0_;
	GOutputStream* _tmp1_;
	GCancellable* _tmp2_;
	_data_ = g_slice_new0 (GxmlDomElementWriteStreamAsyncData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, gxml_dom_element_real_write_stream_async_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, gxml_dom_element_real_write_stream_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (stream);
	_g_object_unref0 (_data_->stream);
	_data_->stream = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	gxml_dom_element_real_write_stream_async_co (_data_);
}

static void
gxml_dom_element_real_write_stream_finish (GXmlDomElement* self,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	GxmlDomElementWriteStreamAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Uses element's {@link GomDocument} to write an XML to a stream, serializing it.
   */
static void
gxml_dom_element_write_stream_async_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	GxmlDomElementWriteStreamAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	gxml_dom_element_real_write_stream_async_co (_data_);
}

static gboolean
gxml_dom_element_real_write_stream_async_co (GxmlDomElementWriteStreamAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gxml_dom_node_get_owner_document ((GXmlDomNode*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_state_ = 1;
	gxml_dom_document_write_stream_async (_data_->_tmp1_, _data_->stream, NULL, gxml_dom_element_write_stream_async_ready, _data_);
	return FALSE;
	_state_1:
	gxml_dom_document_write_stream_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!_data_->_task_complete_) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
gxml_dom_element_write_stream_async (GXmlDomElement* self,
                                     GOutputStream* stream,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	GXML_DOM_ELEMENT_GET_INTERFACE (self)->write_stream_async (self, stream, cancellable, _callback_, _user_data_);
}

void
gxml_dom_element_write_stream_finish (GXmlDomElement* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	GXML_DOM_ELEMENT_GET_INTERFACE (self)->write_stream_finish (self, _res_, error);
}

/**
   * Creates an {@link GLib.InputStream} to write a string representation
   * in XML of {@link GomElement} using node's {@link GomDocument}
   */
static GInputStream*
gxml_dom_element_real_create_stream (GXmlDomElement* self,
                                     GError** error)
{
	GInputStream* result = NULL;
	GInputStream* _tmp0_ = NULL;
	GXmlDomDocument* _tmp1_;
	GXmlDomDocument* _tmp2_;
	GInputStream* _tmp3_;
	GInputStream* _tmp4_;
	GError* _inner_error0_ = NULL;
	_tmp1_ = gxml_dom_node_get_owner_document ((GXmlDomNode*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = gxml_dom_document_create_stream (_tmp2_, &_inner_error0_);
	_tmp0_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp4_;
	_g_object_unref0 (_tmp0_);
	return result;
}

GInputStream*
gxml_dom_element_create_stream (GXmlDomElement* self,
                                GError** error)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOM_ELEMENT_GET_INTERFACE (self)->create_stream (self, error);
}

static void
gxml_dom_element_real_create_stream_async_data_free (gpointer _data)
{
	GxmlDomElementCreateStreamAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GxmlDomElementCreateStreamAsyncData, _data_);
}

static void
gxml_dom_element_real_create_stream_async_async_ready_wrapper (GObject *source_object,
                                                               GAsyncResult *res,
                                                               void *user_data)
{
	GxmlDomElementCreateStreamAsyncData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}

static void
gxml_dom_element_real_create_stream_async (GXmlDomElement* self,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	GxmlDomElementCreateStreamAsyncData* _data_;
	GXmlDomElement* _tmp0_;
	GCancellable* _tmp1_;
	_data_ = g_slice_new0 (GxmlDomElementCreateStreamAsyncData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, gxml_dom_element_real_create_stream_async_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, gxml_dom_element_real_create_stream_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	gxml_dom_element_real_create_stream_async_co (_data_);
}

static GInputStream*
gxml_dom_element_real_create_stream_finish (GXmlDomElement* self,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	GInputStream* result;
	GxmlDomElementCreateStreamAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
   * Creates an {@link GLib.InputStream} to write a string representation
   * in XML of {@link GomElement} using node's {@link GomDocument}
   */
static void
gxml_dom_element_create_stream_async_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	GxmlDomElementCreateStreamAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	gxml_dom_element_real_create_stream_async_co (_data_);
}

static gboolean
gxml_dom_element_real_create_stream_async_co (GxmlDomElementCreateStreamAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = gxml_dom_node_get_owner_document ((GXmlDomNode*) _data_->self);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_state_ = 1;
	gxml_dom_document_create_stream_async (_data_->_tmp2_, NULL, gxml_dom_element_create_stream_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = gxml_dom_document_create_stream_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp0_ = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_data_->result = _data_->_tmp4_;
	_g_object_unref0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!_data_->_task_complete_) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
gxml_dom_element_create_stream_async (GXmlDomElement* self,
                                      GCancellable* cancellable,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	GXML_DOM_ELEMENT_GET_INTERFACE (self)->create_stream_async (self, cancellable, _callback_, _user_data_);
}

GInputStream*
gxml_dom_element_create_stream_finish (GXmlDomElement* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	return GXML_DOM_ELEMENT_GET_INTERFACE (self)->create_stream_finish (self, _res_, error);
}

gchar*
gxml_dom_element_get_namespace_uri (GXmlDomElement* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOM_ELEMENT_GET_INTERFACE (self)->get_namespace_uri (self);
}

gchar*
gxml_dom_element_get_prefix (GXmlDomElement* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOM_ELEMENT_GET_INTERFACE (self)->get_prefix (self);
}

gchar*
gxml_dom_element_get_local_name (GXmlDomElement* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOM_ELEMENT_GET_INTERFACE (self)->get_local_name (self);
}

gchar*
gxml_dom_element_get_tag_name (GXmlDomElement* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOM_ELEMENT_GET_INTERFACE (self)->get_tag_name (self);
}

gchar*
gxml_dom_element_get_id (GXmlDomElement* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOM_ELEMENT_GET_INTERFACE (self)->get_id (self);
}

void
gxml_dom_element_set_id (GXmlDomElement* self,
                         const gchar* value)
{
	g_return_if_fail (self != NULL);
	GXML_DOM_ELEMENT_GET_INTERFACE (self)->set_id (self, value);
}

gchar*
gxml_dom_element_get_class_name (GXmlDomElement* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOM_ELEMENT_GET_INTERFACE (self)->get_class_name (self);
}

void
gxml_dom_element_set_class_name (GXmlDomElement* self,
                                 const gchar* value)
{
	g_return_if_fail (self != NULL);
	GXML_DOM_ELEMENT_GET_INTERFACE (self)->set_class_name (self, value);
}

GXmlDomTokenList*
gxml_dom_element_get_class_list (GXmlDomElement* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOM_ELEMENT_GET_INTERFACE (self)->get_class_list (self);
}

GXmlDomNamedNodeMap*
gxml_dom_element_get_attributes (GXmlDomElement* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOM_ELEMENT_GET_INTERFACE (self)->get_attributes (self);
}

static void
gxml_dom_element_default_init (GXmlDomElementIface * iface,
                               gpointer iface_data)
{
	/**
	   * Returns default namespace's uri defined in node or first found.
	   */
	g_object_interface_install_property (iface, g_param_spec_string ("namespace-uri", "namespace-uri", "namespace-uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Returns default namespace's prefix defined in node or first found.
	   */
	g_object_interface_install_property (iface, g_param_spec_string ("prefix", "prefix", "prefix", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("local-name", "local-name", "local-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("tag-name", "tag-name", "tag-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("class-name", "class-name", "class-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_object ("class-list", "class-list", "class-list", GXML_TYPE_DOM_TOKEN_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_interface_install_property (iface, g_param_spec_object ("attributes", "attributes", "attributes", GXML_TYPE_DOM_NAMED_NODE_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	iface->matches = gxml_dom_element_real_matches;
	iface->read_from_uri = gxml_dom_element_real_read_from_uri;
	iface->read_from_uri_async = gxml_dom_element_real_read_from_uri_async;
	iface->read_from_uri_finish = gxml_dom_element_real_read_from_uri_finish;
	iface->read_from_file = gxml_dom_element_real_read_from_file;
	iface->read_from_file_async = gxml_dom_element_real_read_from_file_async;
	iface->read_from_file_finish = gxml_dom_element_real_read_from_file_finish;
	iface->read_from_stream = gxml_dom_element_real_read_from_stream;
	iface->read_from_stream_async = gxml_dom_element_real_read_from_stream_async;
	iface->read_from_stream_finish = gxml_dom_element_real_read_from_stream_finish;
	iface->read_from_string = gxml_dom_element_real_read_from_string;
	iface->read_from_string_async = gxml_dom_element_real_read_from_string_async;
	iface->read_from_string_finish = gxml_dom_element_real_read_from_string_finish;
	iface->write_string = gxml_dom_element_real_write_string;
	iface->write_string_async = gxml_dom_element_real_write_string_async;
	iface->write_string_finish = gxml_dom_element_real_write_string_finish;
	iface->write_file = gxml_dom_element_real_write_file;
	iface->write_file_async = gxml_dom_element_real_write_file_async;
	iface->write_file_finish = gxml_dom_element_real_write_file_finish;
	iface->write_stream = gxml_dom_element_real_write_stream;
	iface->write_stream_async = gxml_dom_element_real_write_stream_async;
	iface->write_stream_finish = gxml_dom_element_real_write_stream_finish;
	iface->create_stream = gxml_dom_element_real_create_stream;
	iface->create_stream_async = gxml_dom_element_real_create_stream_async;
	iface->create_stream_finish = gxml_dom_element_real_create_stream_finish;
}

GType
gxml_dom_element_get_type (void)
{
	static volatile gsize gxml_dom_element_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_dom_element_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlDomElementIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gxml_dom_element_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gxml_dom_element_type_id;
		gxml_dom_element_type_id = g_type_register_static (G_TYPE_INTERFACE, "GXmlDomElement", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gxml_dom_element_type_id, G_TYPE_OBJECT);
		g_type_interface_add_prerequisite (gxml_dom_element_type_id, GXML_TYPE_DOM_NODE);
		g_type_interface_add_prerequisite (gxml_dom_element_type_id, GXML_TYPE_DOM_CHILD_NODE);
		g_type_interface_add_prerequisite (gxml_dom_element_type_id, GXML_TYPE_DOM_NON_DOCUMENT_TYPE_CHILD_NODE);
		g_type_interface_add_prerequisite (gxml_dom_element_type_id, GXML_TYPE_DOM_PARENT_NODE);
		g_once_init_leave (&gxml_dom_element_type_id__volatile, gxml_dom_element_type_id);
	}
	return gxml_dom_element_type_id__volatile;
}

static GXmlDomElement*
gxml_dom_element_list_real_get_element (GXmlDomHTMLCollection* base,
                                        gint index)
{
	GXmlDomElementList * self;
	GXmlDomElement* result = NULL;
	gpointer _tmp0_;
	self = (GXmlDomElementList*) base;
	_tmp0_ = gee_abstract_list_get ((GeeAbstractList*) self, index);
	result = G_TYPE_CHECK_INSTANCE_CAST ((GXmlDomElement*) _tmp0_, GXML_TYPE_DOM_ELEMENT, GXmlDomElement);
	return result;
}

GXmlDomElementList*
gxml_dom_element_list_construct (GType object_type)
{
	GXmlDomElementList * self = NULL;
	self = (GXmlDomElementList*) gee_array_list_construct (object_type, GXML_TYPE_DOM_ELEMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	return self;
}

GXmlDomElementList*
gxml_dom_element_list_new (void)
{
	return gxml_dom_element_list_construct (GXML_TYPE_DOM_ELEMENT_LIST);
}

static void
gxml_dom_element_list_class_init (GXmlDomElementListClass * klass,
                                  gpointer klass_data)
{
	gxml_dom_element_list_parent_class = g_type_class_peek_parent (klass);
}

static void
gxml_dom_element_list_gxml_dom_html_collection_interface_init (GXmlDomHTMLCollectionIface * iface,
                                                               gpointer iface_data)
{
	gxml_dom_element_list_gxml_dom_html_collection_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_element = (GXmlDomElement* (*) (GXmlDomHTMLCollection*, gint)) gxml_dom_element_list_real_get_element;
}

static void
gxml_dom_element_list_instance_init (GXmlDomElementList * self,
                                     gpointer klass)
{
}

GType
gxml_dom_element_list_get_type (void)
{
	static volatile gsize gxml_dom_element_list_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_dom_element_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlDomElementListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gxml_dom_element_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GXmlDomElementList), 0, (GInstanceInitFunc) gxml_dom_element_list_instance_init, NULL };
		static const GInterfaceInfo gxml_dom_html_collection_info = { (GInterfaceInitFunc) gxml_dom_element_list_gxml_dom_html_collection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gxml_dom_element_list_type_id;
		gxml_dom_element_list_type_id = g_type_register_static (GEE_TYPE_ARRAY_LIST, "GXmlDomElementList", &g_define_type_info, 0);
		g_type_add_interface_static (gxml_dom_element_list_type_id, GXML_TYPE_DOM_HTML_COLLECTION, &gxml_dom_html_collection_info);
		g_once_init_leave (&gxml_dom_element_list_type_id__volatile, gxml_dom_element_list_type_id);
	}
	return gxml_dom_element_list_type_id__volatile;
}

