/* Serializable.c generated by valac 0.17.2, the Vala compiler
 * generated from Serializable.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/*
  Version 3: json-glib version

  PLAN:
  * add support for GObject Introspection to allow us to serialise non-property members

  json-glib
  * has functions to convert XML structures into Objects and vice versa
  * can convert simple objects automatically
  * richer objects need to implement interface

  json_serializable_real_serialize -> json_serialize_pspec
  * how do these get used with GInterfaces?  are these default methods like with superclasses?
  * TODO: I don't think vala does multiple inheritance, so do we want GXml.Serializable to be an interface or a superclass?

  json_serializable_default_{de,}serialize_property -> json_serializable_real_{de,}serialize

  json_serializable_{de,}serialize_property -> iface->{de,}serialize_property
    these all get init'd to -> json_serializable_real_{de,}serialize_property
      these all call -> json_{de,}serialize_pspec

  json_serializable_{find,list,get,set}_propert{y,ies} -> iface->{find,list,get,set}_propert{y,ies}
    these all get init'd to -> json_serializable_real_{find,list,get,set}_propert{y,ies}
  these all call -> g_object_{class,}_{find,list,get,set}_propert{y,ies}
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define GXML_TYPE_SERIALIZABLE (gxml_serializable_get_type ())
#define GXML_SERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE, GXmlSerializable))
#define GXML_IS_SERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE))
#define GXML_SERIALIZABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_SERIALIZABLE, GXmlSerializableIface))

typedef struct _GXmlSerializable GXmlSerializable;
typedef struct _GXmlSerializableIface GXmlSerializableIface;

#define GXML_TYPE_DOM_NODE (gxml_dom_node_get_type ())
#define GXML_DOM_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_NODE, GXmlDomNode))
#define GXML_DOM_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_DOM_NODE, GXmlDomNodeClass))
#define GXML_IS_DOM_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_NODE))
#define GXML_IS_DOM_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_DOM_NODE))
#define GXML_DOM_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_DOM_NODE, GXmlDomNodeClass))

typedef struct _GXmlDomNode GXmlDomNode;
typedef struct _GXmlDomNodeClass GXmlDomNodeClass;

#define GXML_TYPE_DOCUMENT (gxml_document_get_type ())
#define GXML_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOCUMENT, GXmlDocument))
#define GXML_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_DOCUMENT, GXmlDocumentClass))
#define GXML_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOCUMENT))
#define GXML_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_DOCUMENT))
#define GXML_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_DOCUMENT, GXmlDocumentClass))

typedef struct _GXmlDocument GXmlDocument;
typedef struct _GXmlDocumentClass GXmlDocumentClass;

struct _GXmlSerializableIface {
	GTypeInterface parent_iface;
	gboolean (*deserialize_property) (GXmlSerializable* self, const gchar* property_name, GParamSpec* spec, GXmlDomNode* property_node);
	GXmlDomNode* (*serialize_property) (GXmlSerializable* self, const gchar* property_name, GParamSpec* spec, GXmlDocument* doc);
	GParamSpec* (*find_property) (GXmlSerializable* self, const gchar* property_name);
	GParamSpec** (*list_properties) (GXmlSerializable* self, int* result_length1);
	void (*get_property) (GXmlSerializable* self, GParamSpec* spec, GValue* str_value);
	void (*set_property) (GXmlSerializable* self, GParamSpec* spec, GValue* value);
};



GType gxml_dom_node_get_type (void) G_GNUC_CONST;
GType gxml_document_get_type (void) G_GNUC_CONST;
GType gxml_serializable_get_type (void) G_GNUC_CONST;
gboolean gxml_serializable_deserialize_property (GXmlSerializable* self, const gchar* property_name, GParamSpec* spec, GXmlDomNode* property_node);
static gboolean gxml_serializable_real_deserialize_property (GXmlSerializable* self, const gchar* property_name, GParamSpec* spec, GXmlDomNode* property_node);
GXmlDomNode* gxml_serializable_serialize_property (GXmlSerializable* self, const gchar* property_name, GParamSpec* spec, GXmlDocument* doc);
static GXmlDomNode* gxml_serializable_real_serialize_property (GXmlSerializable* self, const gchar* property_name, GParamSpec* spec, GXmlDocument* doc);
GParamSpec* gxml_serializable_find_property (GXmlSerializable* self, const gchar* property_name);
static GParamSpec* gxml_serializable_real_find_property (GXmlSerializable* self, const gchar* property_name);
GParamSpec** gxml_serializable_list_properties (GXmlSerializable* self, int* result_length1);
static GParamSpec** gxml_serializable_real_list_properties (GXmlSerializable* self, int* result_length1);
void gxml_serializable_get_property (GXmlSerializable* self, GParamSpec* spec, GValue* str_value);
static void gxml_serializable_real_get_property (GXmlSerializable* self, GParamSpec* spec, GValue* str_value);
void gxml_serializable_set_property (GXmlSerializable* self, GParamSpec* spec, GValue* value);
static void gxml_serializable_real_set_property (GXmlSerializable* self, GParamSpec* spec, GValue* value);


/**
 * Handles deserializing individual properties.
 *
 * Interface method to handle deserialization of an
 * individual property.  The implementing class
 * receives a description of the property and the
 * {@link GXml.DomNode} that contains the content.  The
 * implementing {@link GXml.Serializable} object can extract
 * the data from the {@link GXml.DomNode} and store it in its
 * property itself. Note that the {@link GXml.DomNode} may be
 * as simple as a {@link GXml.Text} that stores the data as a
 * string.
 *
 * If the implementation has handled deserialization,
 * return true.  Return false if you want
 * {@link GXml.Serialization} to try to automatically
 * deserialize it.  If {@link GXml.Serialization} tries to
 * handle it, it will want either {@link GXml.Serializable}'s
 * set_property (or at least {@link GLib.Object.set_property})
 * to know about the property.
 *
 * @param property_name the name of the property as a string
 * @param spec the {@link GLib.ParamSpec} describing the property.
 * @param property_node the {@link GXml.DomNode} encapsulating data to deserialize
 * @return `true` if the property was handled, `false` if {@link GXml.Serialization} should handle it.
 */
static gboolean gxml_serializable_real_deserialize_property (GXmlSerializable* self, const gchar* property_name, GParamSpec* spec, GXmlDomNode* property_node) {
	gboolean result = FALSE;
	g_return_val_if_fail (property_name != NULL, FALSE);
	g_return_val_if_fail (spec != NULL, FALSE);
	g_return_val_if_fail (property_node != NULL, FALSE);
	result = FALSE;
	return result;
}


gboolean gxml_serializable_deserialize_property (GXmlSerializable* self, const gchar* property_name, GParamSpec* spec, GXmlDomNode* property_node) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->deserialize_property (self, property_name, spec, property_node);
}


/**
 * Handles serializing individual properties.
 *
 * Interface method to handle serialization of an
 * individual property.  The implementing class
 * receives a description of it, and should create a
 * {@link GXml.DomNode} that encapsulates the property.
 * {@link GXml.Serialization} will embed the {@link GXml.DomNode} into
 * a "Property" {@link GXml.Element}, so the {@link GXml.DomNode}
 * returned can often be something as simple as
 * {@link GXml.Text}.
 *
 * To let {@link GXml.Serialization} attempt to automatically
 * serialize the property itself, do not implement
 * this method.  If the method returns %NULL,
 * {@link GXml.Serialization} will attempt handle it itsel.
 *
 * @param property_name string name of a property to serialize.
 * @param spec the {@link GLib.ParamSpec} describing the property.
 * @param doc the {@link GXml.Document} the returned {@link GXml.DomNode} should belong to
 * @return a new {@link GXml.DomNode}, or `null`
 */
static GXmlDomNode* gxml_serializable_real_serialize_property (GXmlSerializable* self, const gchar* property_name, GParamSpec* spec, GXmlDocument* doc) {
	GXmlDomNode* result = NULL;
	g_return_val_if_fail (property_name != NULL, NULL);
	g_return_val_if_fail (spec != NULL, NULL);
	g_return_val_if_fail (doc != NULL, NULL);
	result = NULL;
	return result;
}


GXmlDomNode* gxml_serializable_serialize_property (GXmlSerializable* self, const gchar* property_name, GParamSpec* spec, GXmlDocument* doc) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->serialize_property (self, property_name, spec, doc);
}


static GParamSpec* gxml_serializable_real_find_property (GXmlSerializable* self, const gchar* property_name) {
	GParamSpec* result = NULL;
	GObjectClass* _tmp0_ = NULL;
	const gchar* _tmp1_;
	GParamSpec* _tmp2_ = NULL;
	g_return_val_if_fail (property_name != NULL, NULL);
	_tmp0_ = G_OBJECT_GET_CLASS ((GObject*) self);
	_tmp1_ = property_name;
	_tmp2_ = g_object_class_find_property (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


GParamSpec* gxml_serializable_find_property (GXmlSerializable* self, const gchar* property_name) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->find_property (self, property_name);
}


static GParamSpec** gxml_serializable_real_list_properties (GXmlSerializable* self, int* result_length1) {
	GParamSpec** result = NULL;
	GObjectClass* _tmp0_ = NULL;
	guint _tmp1_;
	GParamSpec** _tmp2_ = NULL;
	GParamSpec** _tmp3_;
	gint _tmp3__length1;
	_tmp0_ = G_OBJECT_GET_CLASS ((GObject*) self);
	_tmp2_ = g_object_class_list_properties (_tmp0_, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp1_;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}


GParamSpec** gxml_serializable_list_properties (GXmlSerializable* self, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->list_properties (self, result_length1);
}


static void gxml_serializable_real_get_property (GXmlSerializable* self, GParamSpec* spec, GValue* str_value) {
	GParamSpec* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (spec != NULL);
	g_return_if_fail (str_value != NULL);
	_tmp0_ = spec;
	_tmp1_ = _tmp0_->name;
	g_object_get_property (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), _tmp1_, str_value);
}


void gxml_serializable_get_property (GXmlSerializable* self, GParamSpec* spec, GValue* str_value) {
	g_return_if_fail (self != NULL);
	GXML_SERIALIZABLE_GET_INTERFACE (self)->get_property (self, spec, str_value);
}


static void gxml_serializable_real_set_property (GXmlSerializable* self, GParamSpec* spec, GValue* value) {
	GParamSpec* _tmp0_;
	const gchar* _tmp1_;
	GValue _tmp2_;
	g_return_if_fail (spec != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = spec;
	_tmp1_ = _tmp0_->name;
	_tmp2_ = *value;
	g_object_set_property (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), _tmp1_, &_tmp2_);
}


void gxml_serializable_set_property (GXmlSerializable* self, GParamSpec* spec, GValue* value) {
	g_return_if_fail (self != NULL);
	GXML_SERIALIZABLE_GET_INTERFACE (self)->set_property (self, spec, value);
}


static void gxml_serializable_base_init (GXmlSerializableIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		iface->deserialize_property = gxml_serializable_real_deserialize_property;
		iface->serialize_property = gxml_serializable_real_serialize_property;
		iface->find_property = gxml_serializable_real_find_property;
		iface->list_properties = gxml_serializable_real_list_properties;
		iface->get_property = gxml_serializable_real_get_property;
		iface->set_property = gxml_serializable_real_set_property;
	}
}


/**
 * Interface allowing implementors direct control over serialisation of properties and other data
 *
 * A class that implements this interface will still be passed
 * to {@link GXml.Serialization.serialize_object} for
 * serialization.  That function will check whether the object
 * implements {@link GXml.Serializable} and will then prefer
 * overridden methods instead of standard ones.  Most of the
 * methods for this interface can indicate (via return value)
 * that, for a given property, the standard serialization
 * approach should be used instead.  Indeed, not all methods
 * need to be implemented, but some accompany one another and
 * should be implemented carefully, corresponding to one
 * another.  You can also create virtual properties from
 * non-public property fields to enable their serialization.
 *
 * For an example, look in tests/XmlSerializableTest
 */
GType gxml_serializable_get_type (void) {
	static volatile gsize gxml_serializable_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_serializable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlSerializableIface), (GBaseInitFunc) gxml_serializable_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gxml_serializable_type_id;
		gxml_serializable_type_id = g_type_register_static (G_TYPE_INTERFACE, "GXmlSerializable", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gxml_serializable_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gxml_serializable_type_id__volatile, gxml_serializable_type_id);
	}
	return gxml_serializable_type_id__volatile;
}



